/*
 
 ADOBE CONFIDENTIAL
 ___________________
 
 Copyright 2015 Adobe Systems Incorporated
 All Rights Reserved.
 
 NOTICE:  All information contained herein is, and remains
 the property of Adobe Systems Incorporated and its suppliers,
 if any.  The intellectual and technical concepts contained
 herein are proprietary to Adobe Systems Incorporated and its
 suppliers and are protected by trade secret or copyright law.
 Dissemination of this information or reproduction of this material
 is strictly forbidden unless prior written permission is obtained
 from Adobe Systems Incorporated.
 
 */
/*jslint vars: true, plusplus: true, devel: true, browser: true, nomen: true, maxerr: 50, continue: true */
/*global dw, dwscripts, MM,  GetxmlLocation, GetxmlFile, GetBootstrapJqueryFile, GetBootstrapAltCssFile, GetBootstrapAltJsFile, UpdateFileNamesWithAppropriateVersion */

//---------------   GLOBAL VARIABLES   ---------------
var insertOption = null;
var isInsertOptionsDisabled = false;
var COLORS = {
    WIN_DLG_BG : '#F0F0F0',
	MAC_DLG_BG : '#D6D6D6',
	BORDER	   : '#A9A9A9'
};
var COLOR_ID_SELECTION = 5000014; // dva colorID of kColor_Focus

var helpDoc = MM.HELP_bootstrap;
var components_req_Images = ["thumbnails", "carousel", "img-responsive-rounded", "img-responsive-circle", "img-responsive-thumbnail", "img-responsive-default", "media-object-case1", "media-object-case2", "cards-case1"];

//---------------     API FUNCTIONS    ---------------

function isDOMRequired() {
    "use strict";
	return false;
}

//---------------    LOCAL FUNCTIONS   ---------------

function generateUniqIDs(str) {
    "use strict";
    
    //write with maps
    var myMap = {},
        getIdsExp = str.match(/UNIQID-GET-[a-zA-Z]*/gi),
        setIdsExp = str.match(/UNIQID-SET-[a-zA-Z]*/gi),
        i,
        j,
        compId,
        uniqueCompId;
    
    if (getIdsExp) {
        for (i = 0; i < getIdsExp.length; i += 1) {
            compId = getIdsExp[i].substring(11);
            uniqueCompId = dwscripts.getUniqueId(compId, true);
            myMap[compId] = uniqueCompId;
            str = str.replace(getIdsExp[i], uniqueCompId);
        }
        if (setIdsExp) {
            for (i = 0; i < setIdsExp.length; i += 1) {
                compId = setIdsExp[i].substring(11);
                if (myMap[compId]) {
                    uniqueCompId = myMap[compId];
                    str = str.replace(new RegExp(setIdsExp[i], 'g'), uniqueCompId);
                }
            }
        }
    }
    return str;
}

function getHTML(componentName) {
    "use strict";
    var xmlFilePath = dw.getConfigurationPath() + GetxmlLocation() + GetxmlFileName(),
        xmlDOM = dw.getDocumentDOM(xmlFilePath, false),
        html = "",
        theDOM,
        stylesArray;
    
    if (xmlDOM) {
        var domEl = xmlDOM.getElementsByTagName(componentName);
        if (domEl && domEl.length > 0) {
            if (componentName.indexOf('media-object-') !== 0) {        
               html = domEl[0].childNodes[0].innerHTML; 
            }
            else {
                /*
                This is because .pull-left and .pull-right classes which are added for media objects were deprecated from Bootstrap v3.2 to 3.3
                */
                theDOM = dw.getDocumentDOM();
                stylesArray = theDOM.getSelectorsDefinedInStylesheet('class');
                if (stylesArray && stylesArray.indexOf('.media-left') >= 0) {
                    html = domEl[0].getElementsByTagName('newer')[0].childNodes[0].innerHTML;
                } else {
                    html = domEl[0].getElementsByTagName('older')[0].childNodes[0].innerHTML;
                }
            }
            html = generateUniqIDs(html);
        }
    }
        
    return html;
}

function setAdditionalBodyStyles(componentName, styleProperty, minValue) {
    "use strict";
    var theDOM = dw.getDocumentDOM(),
        bodystyle = theDOM.getElementsByTagName("body")[0].style[styleProperty],
        val1,
        val2;
    if (bodystyle) {
        val1 = parseInt(bodystyle.slice(0, -2), 10);
        val2 = parseInt(minValue.slice(0, -2), 10);
        if (val1 >= val2) {
            return;
        }
    }
    theDOM.getElementsByTagName("body")[0].style[styleProperty] = minValue;
}

function moveCssAboveJquery() {
    "use strict";
    
    var dom = dw.getDocumentDOM(),
        jqIndex = -1,
        cssIndex = -1,
        i,
        links,
        scripts,
        fileName,
        temp,
        retVal = false;
    
    links = dom.getElementsByTagName('link');
    scripts = dom.getElementsByTagName('script');
    
    if (links) {
        for (i = 0; i < links.length; i += 1) {
            fileName = links[i].href;
            if ((fileName) && (fileName.indexOf(".css") === fileName.length - 4)) {
                if (fileName.toLowerCase().indexOf("bootstrap") > -1) {
                    if (cssIndex === -1) {
                        cssIndex = i;
                        break;
                    }
                }
            }
        }
    }
    if (scripts) {
        for (i = 0; i < scripts.length; i += 1) {
            fileName = scripts[i].src;
            if ((fileName) && (fileName.indexOf(".js") === fileName.length - 3)) {
                if (fileName.toLowerCase().indexOf("jquery") > -1) {
                    if (jqIndex === -1) {
                        jqIndex = i;
                        break;
                    }
                }
            }
        }
    }
    
    if ((jqIndex !== -1) && (cssIndex !== -1)) {
        temp = links[cssIndex].outerHTML;
        links[cssIndex].outerHTML = "";
        scripts[jqIndex].outerHTML = temp + scripts[jqIndex].outerHTML;
        retVal = true;
    }
    
    return retVal;
}

function makeTagChanges(change, tagName, property, extension, newFileName, oldFileName, lookForExistingCDN) {
    "use strict";
    var dom = dw.getDocumentDOM(),
        prevIndex = -1,
        newIndex = -1,
        tags,
        i,
        temp,
        fileName,
        retVal = false;
    
    tags = dom.getElementsByTagName(tagName);
    
    if (tags) {
        for (i = 0; i < tags.length; i += 1) {
            fileName = tags[i][property];
            if ((fileName) && (fileName.indexOf(extension) === fileName.length - extension.length)) {
                if ((!lookForExistingCDN && fileName.toLowerCase().indexOf(newFileName) > -1)
                        || (lookForExistingCDN && fileName.toLowerCase().indexOf(newFileName) > -1 && fileName.toLowerCase().indexOf("cdn") === -1)) {
                    if (newIndex === -1) {
                        newIndex = i;
                    }
                } else if ((!lookForExistingCDN && fileName.toLowerCase().indexOf(oldFileName) > -1)
                            || (lookForExistingCDN && fileName.toLowerCase().indexOf(newFileName) > -1 && fileName.toLowerCase().indexOf("cdn") > -1)) {
                    if (prevIndex === -1) {
                        prevIndex = i;
                    }
                }
            }
            if ((prevIndex !== -1) && (newIndex !== -1)) {
                break;
            }
        }
    }

    if ((prevIndex !== -1) && (newIndex !== -1)) {
        if (change === "comment") {
            tags[prevIndex].outerHTML = "<!-- " + tags[prevIndex].outerHTML + " -->" + tags[newIndex].outerHTML;
            tags[newIndex].outerHTML = "";
            retVal = true;
        } else if ((change === "moveAbove") && (prevIndex < newIndex)) {
            temp = tags[newIndex].outerHTML;
            tags[newIndex].outerHTML = "";
            tags[prevIndex].outerHTML = temp + tags[prevIndex].outerHTML;
            retVal = true;
        }
    }
    
    return retVal;
}

function addMetaTag() {
    "use strict";
    
    var dom = dw.getDocumentDOM(),
        changeDone = false,
        metaToAdd_1 = "<meta http-equiv=\"X-UA-Compatible\" content=\"IE=edge\">",
        metaToAdd_2 = "<meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">",
        metaToAdd = "",
        ie8shim = false,
        ie8respond = false,
        ie8HeadContentToAdd = "",
        ie8Content_start_1 = "<!-- HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries -->",
        ie8Content_start_shim = "<!-- HTML5 shim for IE8 support of HTML5 elements and media queries -->",
        ie8Content_start_respond = "<!-- Respond.js for IE8 support of HTML5 elements and media queries -->",
        ie8respond_1 = "<!-- WARNING: Respond.js doesn\'t work if you view the page via file:// -->",
        ie8Content_mid = "<!--[if lt IE 9]>\n",
        ie8shim_1 = "<script src=\"https://oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js\"></script>\n",
        ie8respond_2 = "<script src=\"https://oss.maxcdn.com/respond/1.4.2/respond.min.js\"></script>\n",
        ie8Content_end = "<![endif]-->",
        headContent,
        titleTag,
        titleContent,
        retVal = false;
    headContent = dom.getElementsByTagName('head')[0].innerHTML;
    //check if the meta viewport tag already exists, else add it at in head just before 'title' tag
    if (headContent) {
        if (headContent.indexOf('meta http-equiv="X-UA-Compatible"') === -1) {
            metaToAdd += metaToAdd_1;
        }
        if (headContent.indexOf('meta name="viewport"') === -1) {
            metaToAdd += metaToAdd_2;
        }
        if (metaToAdd !== "") {
            titleTag = dom.getElementsByTagName('title');
            if (titleTag && titleTag[0]) {
                titleContent = titleTag[0].outerHTML;
                dom.getElementsByTagName('title')[0].outerHTML = metaToAdd + '\n' + titleContent;
            } else {    //no Title in doc?
                dom.insertAtTheBegnningOfHead(metaToAdd);
            }
            retVal = true;
        }
        if ((headContent.indexOf('html5shiv.min.js') === -1) && (headContent.indexOf('html5shiv.js') === -1)) {
            ie8shim = true;
        }
        if ((headContent.indexOf('respond.min.js') === -1) && (headContent.indexOf('respond.js') === -1)) {
            ie8respond = true;
        }
        if (ie8shim && ie8respond) {
            ie8HeadContentToAdd = ie8Content_start_1 + ie8respond_1 + ie8Content_mid + ie8shim_1 + ie8respond_2 + ie8Content_end;
        } else if (ie8shim) { //only HTML5 shim required
            ie8HeadContentToAdd = ie8Content_start_shim + ie8Content_mid + ie8shim_1 + ie8Content_end;
        } else if (ie8respond) { //only respond.min.js required
            ie8HeadContentToAdd = ie8Content_start_respond + ie8respond_1 + ie8Content_mid + ie8respond_2 + ie8Content_end;
        }
        var bsVer;
        if(dom)
            bsVer = parseInt(dom.getCompatibleBootstrapVersion());

        if (ie8HeadContentToAdd !== "" && bsVer === 3) {
            dom.getElementsByTagName('head')[0].innerHTML += ie8HeadContentToAdd;
            retVal = true;
        }
    }
    
    return retVal;
}

function makeRemainingChangesToDocument(replaceObj) {
    "use strict";
    
    var dom = dw.getDocumentDOM(),
        changeDone = false,
        prevSelectedNode = dom.getSelectedNode();
    
    if (replaceObj.hasOwnProperty("jQueryPresent") && replaceObj.jQueryPresent) {
        //this is the case when jQuery is already present in page and we add css at the end of head.
        
        if (moveCssAboveJquery()) {
            changeDone = true;
        }
    }
    
    if (replaceObj.useAltBootstrapName) {
        UpdateFileNamesWithAppropriateVersion();
    }
    if (replaceObj.hasOwnProperty("replaceCss") && replaceObj.replaceCss) {
        //code to comment out existing link & script tags for bootstrap css & js and add ours below it
        var bootstrapCSSFileName = replaceObj.useAltBootstrapName ? BootstrapAltCssFile : "bootstrap";
        if (makeTagChanges("comment", "link", "href", ".css", bootstrapCSSFileName, "bootstrap", !replaceObj.useAltBootstrapName)) {
            changeDone = true;
        }
        
        var bootstrapJSFileName = replaceObj.useAltBootstrapName ? BootstrapAltJsFile : "bootstrap";
        if (makeTagChanges("comment", "script", "src", ".js", bootstrapJSFileName, "bootstrap", !replaceObj.useAltBootstrapName)) {
            changeDone = true;
        }
    }
    
    if (replaceObj.hasOwnProperty("replaceJQuery") && replaceObj.replaceJQuery) {
        //code to comment out existing jQuery tag and add ours below it
        
        if (makeTagChanges("comment", "script", "src", ".js", BootstrapJqueryFile, "jquery", false)) {
            changeDone = true;
        }
    }
    
    if (replaceObj.hasOwnProperty("moveJQueryAboveJs") && replaceObj.moveJQueryAboveJs) {
        /*  Bootstrap JS existed but we added jQuery, Then jQuery needs to be added before bootstrap.js
            WatsonBug# 3964104 */
        
        if (makeTagChanges("moveAbove", "script", "src", ".js", BootstrapJqueryFile, "bootstrap", false)) {
            changeDone = true;
        }
    }

    if (replaceObj.hasOwnProperty("movePopperAboveBootstrap") && replaceObj.movePopperAboveBootstrap) {
        if (makeTagChanges("moveAbove", "script", "src", ".js", PopperJsFile, "bootstrap", false)) {
            changeDone = true;
        }
    }

    if (replaceObj.hasOwnProperty("addMetaInfo") && replaceObj.addMetaInfo) {
        if (addMetaTag()) {
            changeDone = true;
        }
    }
    
    if (changeDone && prevSelectedNode) {
        dom.setSelectedNode(prevSelectedNode);
    }
    
}

function replaceWithImagePaths(html, imageAbsPath) {
    "use strict";
    
    var placeholderStringRegex = new RegExp("GET-IMG-ABSOLUTEPATH", "g");
    html = html.replace(placeholderStringRegex, imageAbsPath);
    
    return html;
    
}

function insertHTMLAtIP(html) {
    "use strict";
	var domSource =  dw.getDocumentDOM().source,
        selOffsets = domSource.getSelection();
    
    domSource.insert(selOffsets[1], html); // insert at the end of the selection in code view
    domSource.setSelection(selOffsets[1], selOffsets[1] + html.length); // Select the inserted code
    domSource.syncCodeToDOM();
}

function insertComponent(componentName, replaceExistingAssetsInfo) {
    "use strict";
    
    if (!window.doInsert) {
        return;
    }
    
    var html = getHTML(componentName),
        dom = dw.getDocumentDOM(),
        selection;
    if (!dom) {
        return;
    }
    
    if (components_req_Images.indexOf(componentName) > -1 && replaceExistingAssetsInfo.imageAbsolutePath) {
        html = replaceWithImagePaths(html, replaceExistingAssetsInfo.imageAbsolutePath);
    }
    
    selection = dw.getSelection();
    if (selection[0] === selection[1]) {
        if (dw.getFocus(false) === 'textView' && !dw.isDragDrop()) {
            insertHTMLAtIP(html);
            dom.formatSelection();
        } else {
            dom.insertHTML(html, false, false);
        }
    } else {
        // This condition had to be modified for drag drop - we can never wrap by drag drop insert
        if (dw.isDragDrop()) {
            var tagNode = dom.getSelectedNode();
            if (tagNode) {
                var newSelection = dw.nodeToOffsets(tagNode);
                var startOffset = newSelection[0];
                var endOffset = newSelection[1];
                tagNode.innerHTML = html + tagNode.innerHTML;
                if (tagNode.firstChild) {
                    newSelection = dw.nodeToOffsets(tagNode.firstChild);
                    startOffset = newSelection[0];
                    endOffset = newSelection[1];
                }
                //now update the selection
                if ((startOffset < endOffset) && (!dw.getDocumentDOM().rangeContainsLockedRegion(startOffset, endOffset))) {
                    dw.setSelection(startOffset, endOffset);
                }
            }
        } else {
            dom.wrapTag(html, true, true);
        }
    }
    if (componentName === 'navbar-case3') {
        setAdditionalBodyStyles(componentName, "padding-bottom", "70px");
    } else if (componentName === 'navbar-case2') {
        setAdditionalBodyStyles(componentName, "padding-top", "70px");
    }
    
    if (replaceExistingAssetsInfo) {
        makeRemainingChangesToDocument(replaceExistingAssetsInfo);
    }
    
}

function copyAssetsAndInsertComponent(componentName, assetList, replaceExistingAssetsInfo) {
    "use strict";
    
    var dom = dw.getDocumentDOM();
    
    if (dom && dom.getDesignViewMode() === "editable" && dom.getView() !== "code") {
        dw.popupCommand("BootstrapDesignToLiveView.htm");
        window.doInsert = false;
        if (dom.getBootstrapSwitchToLiveView()) {
            dom.setDesignViewMode("live");
        }
    }
    
    if (!window.doInsert) {
        return;
    }

    var i, ret;
    
    if (replaceExistingAssetsInfo.hasOwnProperty("addLinks") && replaceExistingAssetsInfo.addLinks) {
        if (!dom.isHeadEditable()) {
            alert(dwscripts.sprintf(dw.loadString('jquery/alert/lockedHeadRegion'), dom.getAttachedTemplate()));
            window.doInsert = false;
            return;
        }
    } else {
        replaceExistingAssetsInfo.addLinks = false;
    }
    
	if (dom !== undefined) {
        dom.beginBatchEdit();
    }
    
    if (dom && assetList && assetList.length) {
        ret = dom.copyAssets(assetList, true, !replaceExistingAssetsInfo.addLinks); /* args: 1. array of assets 2. bool to indicate that scripts to be added at end of body 3. bool - pass TRUE if only fonts/images are to be imported */
        if (components_req_Images.indexOf(componentName) > -1) {
            if (ret) {
                for (i = 0; i < ret.length; i += 1) {
                    if (ret[i] && ret[i].indexOf(".png") === ret[i].length - 4) {
                        replaceExistingAssetsInfo.imageAbsolutePath = ret[i];
                        break;
                    }
                }
            }
        }
    }
    
    insertComponent(componentName, replaceExistingAssetsInfo);
    
	if (dom !== undefined) {
        dom.endBatchEdit();
    }
}

function updateInsertIcons() {
    "use strict";
    var suffix = "",
        optionList = ['before', 'after', 'child'],
        bgColor = COLORS.MAC_DLG_BG,
        i,
        prefix,
        optionImage;
    if (isInsertOptionsDisabled) {
		suffix = "_Disabled";
    }
    if (dwscripts.IS_WIN) {
        bgColor = COLORS.WIN_DLG_BG;
    }
	 // Update border color as per the current theme
	var colorFocus = dw.getThemeColor(COLOR_ID_SELECTION);
	for (i = 0; i < optionList.length; i += 1) {
	    prefix = optionList[i];
		optionImage = document.getElementById(prefix + "image");
		if (insertOption === prefix && !isInsertOptionsDisabled) {
			optionImage.src = "insertFGIcons/insert_" + prefix + "_Down.png";
			optionImage.setAttribute('style', 'border: 1px solid ' + colorFocus + ';');
		} else {
			optionImage.src = "insertFGIcons/insert_" + prefix + suffix + ".png";
			optionImage.setAttribute('style', 'border: 1px solid ' + COLORS.BORDER + ';');
		}
	}
	return;
}

function checkInsertOption() {
    "use strict";
    if (dw.getFocus(false) === 'document' || dw.isDragDrop()) {
        isInsertOptionsDisabled = true;
    } else {
		isInsertOptionsDisabled = false;
    }
    updateInsertIcons();
}

function setInsertOption(option) {
    "use strict";
    if (isInsertOptionsDisabled) {
        return;
    }
	insertOption = option;
	updateInsertIcons();
}

function showError(msg) {
    "use strict";
	var eleTable = document.getElementById("errorTable"),
        ele = document.getElementById("errMsg");
	if (eleTable) {
		eleTable.style.display = "block";
    }
	if (ele) {
		ele.innerHTML = msg;
    }
}

function hideError() {
    "use strict";
	var eleTable = document.getElementById("errorTable"),
        ele = document.getElementById("errMsg");
	if (eleTable) {
		eleTable.style.display = "none";
    }
	if (ele) {
		ele.innerHTML = "";
    }
}

function validateNumOfColumns(num, totalCols) {
    "use strict";
    var msg;
    if (isNaN(num) || num < 1 || num > totalCols || num % 1 !== 0) {
        msg = dw.loadString("BootstrapColumn/error/InvalidEntry");
        msg = msg.replace("%d", totalCols);
		showError(msg);
        return false;
    }
    if (!isInsertOptionsDisabled && insertOption === null) {
        msg = dw.loadString("insertbar/div/insertWhereMissing");
        showError(msg);
		return false;
	}
    return true;
}

function getInfoForNonResponsiveInsert() {
    "use strict";
    
    var xmlFilePath = dw.getConfigurationPath() + GetxmlLocation() + GetxmlFileName(),
        xmlDOM = dw.getDocumentDOM(xmlFilePath, false),
        screenWidth,
        columnClass,
        viewPortDimensions = dw.getViewSize(),
        breakPointsArray = [],
        i,
        indexOfActiveViewport = -1,
        value,
        widthDim,
        columnRegex,
        rowClass,
        totalNumOfCols;
    
    if (xmlDOM && viewPortDimensions) {
        var minWidths = xmlDOM.getElementsByTagName('defaultBreakPointMinWidths');
        for (i = 0; i < minWidths.length; i += 1) {
            value = parseInt(minWidths[i].innerHTML, 10);
            breakPointsArray.push(value);
        }
        breakPointsArray.sort(function (a, b) {
            return a - b;
        });
        widthDim = viewPortDimensions.substr(0, viewPortDimensions.indexOf('x'));
        screenWidth = parseInt(widthDim, 10);
        while (indexOfActiveViewport++ < breakPointsArray.length) {
            if (screenWidth < breakPointsArray[indexOfActiveViewport] || indexOfActiveViewport === breakPointsArray.length) {
                break;
            }
        }
        rowClass = xmlDOM.getElementsByTagName('rowClass')[0].innerHTML;
        totalNumOfCols = xmlDOM.getElementsByTagName('totalNumOfCols')[0].innerHTML;
        columnRegex = xmlDOM.getElementsByTagName('resizeClassRegex');
        columnClass = columnRegex[indexOfActiveViewport].innerHTML;
        
        return { columnClass: columnClass,
                    rowClass: rowClass,
                    numOfCols: totalNumOfCols
               };
        
    }
    return "";
}

function insertAtSelectedOption(html) {
    "use strict";
	var dom = dw.getDocumentDOM(),
        selOption = insertOption,
        tagNode,
        newSelection,
        startOffset,
        endOffset;

    if (selOption === null) {
        dom.insertHTML(html, false, false);
    } else {
        tagNode = dom.getSelectedNode();
        while (tagNode.nodeType !== 1) {
            // Fetch the Node of type Element
            tagNode = tagNode.parentNode;
        }
        if (tagNode !== null) {
            newSelection = dw.nodeToOffsets(tagNode);
            startOffset = newSelection[0];
            endOffset = newSelection[1];
            if (selOption === 'before') {
                tagNode.outerHTML = html + tagNode.outerHTML;
                if (tagNode.previousSibling) {
                    newSelection = dw.nodeToOffsets(tagNode.previousSibling);
                    startOffset = newSelection[0];
                    endOffset = newSelection[1];
                } else {
                    //fallback
                    endOffset = startOffset;
                    startOffset = endOffset - html.length;
                }
            } else if (selOption === 'after') {
                tagNode.outerHTML = tagNode.outerHTML + html;
                if (tagNode.nextSibling) {
                    newSelection = dw.nodeToOffsets(tagNode.nextSibling);
                    startOffset = newSelection[0];
                    endOffset = newSelection[1];
                } else {
                    //fallback
                    startOffset = endOffset;
                    endOffset = startOffset + html.length;
                }
            } else if (selOption === 'child') { //append as last child
                tagNode.innerHTML = tagNode.innerHTML + html;
                if (tagNode.lastChild) {
                    newSelection = dw.nodeToOffsets(tagNode.lastChild);
                    startOffset = newSelection[0];
                    endOffset = newSelection[1];
                }
            } else {
                return; // unknown insert option
            }

            //now update the selection
            if ((startOffset < endOffset) && (!dw.getDocumentDOM().rangeContainsLockedRegion(startOffset, endOffset))) {
                dw.setSelection(startOffset, endOffset);
            }
        }
    }
}

function doInsertGridRow(isResponsivePage, numOfCols) {
    "use strict";
    var obj,
        colRegex,
        totalCols,
        newColumn,
        classToBeApplied,
        startTag,
        html_mid,
        midTag,
        endTag,
        i,
        html,
        dom,
        rowClass;
    
    if (isResponsivePage) {
        obj = dw.callLiveViewFunction("getAllInfoForResponsiveInsert");
    } else {
        obj = getInfoForNonResponsiveInsert();
    }
    
    if (obj) {
        totalCols = obj.numOfCols;
        colRegex = obj.columnClass;
        rowClass = obj.rowClass;
    }
    if (!obj) {
        return;
    }
    
    if (isResponsivePage && !validateNumOfColumns(numOfCols, totalCols)) {
        return;
    }
    
    newColumn = parseInt(totalCols / numOfCols, 10);
    classToBeApplied = colRegex.replace('[\\d]+', newColumn);
    
    startTag = "<div class=\"" + rowClass + "\">";
    html_mid = "<div class=\"" + classToBeApplied + "\"></div>";
    endTag = "</div>";
    midTag = "";
    for (i = 1; i <= numOfCols; i += 1) {
        midTag += html_mid;
    }
    
    html = startTag + midTag + endTag;
    
    //insertion code
    insertAtSelectedOption(html);
    
    window.close();
}
