/*
 * Decompiled with CFR 0.152.
 */
package com.techtrader.modules.tools.bytecode;

import com.techtrader.modules.tools.bytecode.Attribute;
import com.techtrader.modules.tools.bytecode.BCEntity;
import com.techtrader.modules.tools.bytecode.InnerClass;
import com.techtrader.modules.tools.bytecode.visitor.BCVisitor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class InnerClassesAttribute
extends Attribute {
    private List _innerClasses = new LinkedList();

    public InnerClass[] getInnerClasses() {
        return this._innerClasses.toArray(new InnerClass[this._innerClasses.size()]);
    }

    public InnerClass getInnerClass(String string) {
        Iterator iterator = this._innerClasses.iterator();
        while (iterator.hasNext()) {
            InnerClass innerClass = (InnerClass)iterator.next();
            if (!innerClass.getName().equals(string)) continue;
            return innerClass;
        }
        return null;
    }

    public InnerClass[] getInnerClasses(String string) {
        LinkedList<InnerClass> linkedList = new LinkedList<InnerClass>();
        Iterator iterator = this._innerClasses.iterator();
        while (iterator.hasNext()) {
            InnerClass innerClass = (InnerClass)iterator.next();
            if (!innerClass.getName().equals(string)) continue;
            linkedList.add(innerClass);
        }
        return linkedList.toArray(new InnerClass[linkedList.size()]);
    }

    public InnerClass importInnerClass(InnerClass innerClass) {
        InnerClass innerClass2 = this.addInnerClass(innerClass.getName());
        innerClass2.setAccessFlags(innerClass.getAccessFlags());
        return innerClass2;
    }

    public void importInnerClasses(InnerClassesAttribute innerClassesAttribute) {
        if (innerClassesAttribute == null) {
            return;
        }
        InnerClass[] innerClassArray = innerClassesAttribute.getInnerClasses();
        int n = 0;
        while (n < innerClassArray.length) {
            this.importInnerClass(innerClassArray[n]);
            ++n;
        }
    }

    public InnerClass addInnerClass() {
        InnerClass innerClass = new InnerClass(this);
        this._innerClasses.add(innerClass);
        return innerClass;
    }

    public InnerClass addInnerClass(String string) {
        InnerClass innerClass = new InnerClass(string, this);
        this._innerClasses.add(innerClass);
        return innerClass;
    }

    public void clearInnerClasses() {
        this._innerClasses.clear();
    }

    public boolean removeInnerClass(String string) {
        InnerClass[] innerClassArray = this.getInnerClasses(string);
        int n = 0;
        while (n < innerClassArray.length) {
            this.removeInnerClass(innerClassArray[n]);
            ++n;
        }
        return innerClassArray.length > 0;
    }

    public boolean removeInnerClass(InnerClass innerClass) {
        if (innerClass == null || !this._innerClasses.remove(innerClass)) {
            return false;
        }
        innerClass.invalidate();
        return true;
    }

    public int getLength() {
        return 2 + 8 * this._innerClasses.size();
    }

    protected void copy(Attribute attribute) {
        this.importInnerClasses((InnerClassesAttribute)attribute);
    }

    protected void readData(DataInput dataInput, int n) throws IOException {
        this._innerClasses.clear();
        int n2 = dataInput.readUnsignedShort();
        int n3 = 0;
        while (n3 < n2) {
            InnerClass innerClass = this.addInnerClass();
            innerClass.readData(dataInput);
            ++n3;
        }
    }

    protected void writeData(DataOutput dataOutput, int n) throws IOException {
        dataOutput.writeShort(this._innerClasses.size());
        Iterator iterator = this._innerClasses.iterator();
        while (iterator.hasNext()) {
            ((InnerClass)iterator.next()).writeData(dataOutput);
        }
    }

    public void acceptVisit(BCVisitor bCVisitor) {
        bCVisitor.enterInnerClassesAttribute(this);
        Iterator iterator = this._innerClasses.iterator();
        while (iterator.hasNext()) {
            ((InnerClass)iterator.next()).acceptVisit(bCVisitor);
        }
        bCVisitor.exitInnerClassesAttribute(this);
    }

    public InnerClassesAttribute(int n, BCEntity bCEntity) {
        super(n, bCEntity);
    }
}

