/*
 * Copyright (c) 2012 - present Adobe Systems Incorporated. All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 */

define({

    /**
     * Errors
     */

    // General file io error strings
    "GENERIC_ERROR": "(hata {0})",
    "NOT_FOUND_ERR": "Dosya bulunamadı.",
    "NOT_READABLE_ERR": "Dosya okunamadı.",
    "EXCEEDS_MAX_FILE_SIZE": "{0} MB'tan büyük dosyalar {APP_NAME} ile açılamaz.",
    "NO_MODIFICATION_ALLOWED_ERR": "Klasörde değişiklik yapılamıyor.",
    "NO_MODIFICATION_ALLOWED_ERR_FILE": "Dosya değişikliği için izniniz yok.",
    "CONTENTS_MODIFIED_ERR": "Dosya {APP_NAME} dışında değiştirilmiş.",
    "UNSUPPORTED_ENCODING_ERR": "{APP_NAME} şu anda yalnızca UTF-8 olarak kodlanmış metin dosyalarını destekliyor.",
    "FILE_EXISTS_ERR": "Dosya bulunmaktadır.",
    "FILE": "dosya",
    "FILE_TITLE": "Dosya",
    "DIRECTORY": "dizin",
    "DIRECTORY_TITLE": "Dizin",
    "DIRECTORY_NAMES_LEDE": "Dizin adları",
    "FILENAMES_LEDE": "Dosya Adları",
    "FILENAME": "Dosya adı",
    "DIRECTORY_NAME": "Dizin Adı",

    // Project error strings
    "ERROR_LOADING_PROJECT": "Proje yüklenirken hata",
    "OPEN_DIALOG_ERROR": "Dosya dialogu gösterilirken hata meydana geldi. (hata {0})",
    "REQUEST_NATIVE_FILE_SYSTEM_ERROR": "<span class='dialog-filename'>{0}</span> klasörü yüklenirken hata meydana geldi. (hata {1})",
    "READ_DIRECTORY_ENTRIES_ERROR": "<span class='dialog-filename'>{0}</span> klasörü okunurken hata meydana geldi. (hata {1})",

    // File open/save error string
    "ERROR_OPENING_FILE_TITLE": "Dosya açılırken hata",
    "ERROR_OPENING_FILE": "<span class='dialog-filename'>{0}</span> dosyası açılırken hata meydana geldi. {1}",
    "ERROR_OPENING_FILES": "Aşağıdaki dosyaları açmaya çalışırken bir hata oluştu:",
    "ERROR_RELOADING_FILE_TITLE": "Değişiklikler hafızadan okunurken hata oluştu.",
    "ERROR_RELOADING_FILE": "<span class='dialog-filename'>{0}</span> dosyası yenilenirken hata meydana geldi. {1}",
    "ERROR_SAVING_FILE_TITLE": "Dosya kaydedilirken hata",
    "ERROR_SAVING_FILE": "<span class='dialog-filename'>{0}</span> dosyası kaydedilirken hata meydana geldi. {1}",
    "ERROR_RENAMING_FILE_TITLE": "Dosya ismi değiştirilirken hata",
    "ERROR_RENAMING_FILE": "<span class='dialog-filename'>{0}</span> dosyasının ismi değiştirilirken hata meydana geldi. {1}",
    "ERROR_RENAMING_NOT_IN_PROJECT": "Dosya veya dizin şu anda açık olan projenin parçası değil. Ne yazık ki bu aşamada yalnızca proje dosyaları yeniden adlandırılabilir.",
    "ERROR_DELETING_FILE_TITLE": "{0} Silinirken Hata Oluştu",
    "ERROR_DELETING_FILE": "{2} <span class='dialog-filename'>{0}</span> dosyasını silmeye çalışırken bir hata oluştu. {1}",
    "INVALID_FILENAME_TITLE": "Hatalı dosya ismi",
    "INVALID_FILENAME_MESSAGE": "Dosya isimleri yandaki karakterleri bulunduramaz: {0}",
    "ENTRY_WITH_SAME_NAME_EXISTS": "<span class='dialog-filename'>{0}</span> adlı bir dosya veya dizin zaten var.",
    "ERROR_CREATING_FILE_TITLE": "Dosya yaratılırken hata",
    "ERROR_CREATING_FILE": "<span class='dialog-filename'>{0}</span> dosyası yaratılırken hata meydana geldi. {1}",
    "ERROR_MIXED_DRAGDROP": "Diğer dosyalarla aynı anda bir klasörü açamazsınız.",

    // User key map error strings
    "ERROR_KEYMAP_TITLE": "Kullanıcı Anahtarı Eşlemesi Okunurken Hata Oluştu",
    "ERROR_KEYMAP_CORRUPT": "Anahtar eşleme dosyanız geçerli bir JSON dosyası değil. Formatı düzeltebilmeniz için dosya açılacak.",
    "ERROR_LOADING_KEYMAP": "Anahtar eşleme dosyanız UTF-8 olarak kodlanmış geçerli bir metin dosyası değil ve yüklenemiyor",
    "ERROR_RESTRICTED_COMMANDS": "Şu komutlara kısayolları yeniden atayamazsınız: {0}",
    "ERROR_RESTRICTED_SHORTCUTS": "Şu kısayolları yeniden atayamazsınız: {0}",
    "ERROR_MULTIPLE_SHORTCUTS": "Şu komutlara birden çok kısayolu yeniden atıyorsunuz: {0}",
    "ERROR_DUPLICATE_SHORTCUTS": "Şu kısayollar için birden çok veri bağlantısı bulunuyor: {0}",
    "ERROR_INVALID_SHORTCUTS": "Şu kısayollar geçersiz: {0}",
    "ERROR_NONEXISTENT_COMMANDS": "Var olmayan komutlara kısayol atıyorsunuz: {0}",

    // Application preferences corrupt error strings
    "ERROR_PREFS_CORRUPT_TITLE": "Tercihler Okunurken Hata Oluştu",
    "ERROR_PREFS_CORRUPT": "Tercihler dosyanız geçerli bir JSON dosyası değil. Formatı düzeltebilmeniz için dosya açılacak. Değişikliklerin etkin olması için {APP_NAME} uygulamasını yeniden başlatmanız gerekiyor.",
    "ERROR_PROJ_PREFS_CORRUPT": "Proje tercihleri dosyanız geçerli bir JSON dosyası değil. Formatı düzeltebilmeniz için dosya açılacak. Değişikliklerin etkin olması için projeyi yeniden yüklemeniz gerekiyor.",

    // Application error strings
    "ERROR_IN_BROWSER_TITLE": "Ups! {APP_NAME} programı şuan tarayıcıda açılmadı.",
    "ERROR_IN_BROWSER": "{APP_NAME} HTML olarak hazırlandı, ancak şuan için masaüstünde çalışabilmekte. Bu nedenle makinanızda bulunan dosyalarda değişiklik için kullanabilirsiniz. {APP_NAME} programını çalıştırabilmek için lütfen <b>github.com/adobe/brackets-shell</b> adresindeki 'application shell'i kullanınız.",

    // ProjectManager max files error string
    "ERROR_MAX_FILES_TITLE": "Dosyalar indekslenirken hata",
    "ERROR_MAX_FILES": "Maksimum sayıda dosya indekslendi. Indekslenen dosyalardaki işlemler düzgün çalışmayabilir.",

    // Live Preview error strings
    "ERROR_LAUNCHING_BROWSER_TITLE": "Tarayıcı çalıştırılırken hata",
    "ERROR_CANT_FIND_CHROME": "Google Chrome tarayıcısı bulunamadı. Lütfen kurulu olduğundan emin olun.",
    "ERROR_LAUNCHING_BROWSER": "Tarayıcı açılırken hata meydana geldi. (hata {0})",

    "LIVE_DEVELOPMENT_ERROR_TITLE": "Canlı Önizleme Hatası",
    "LIVE_DEVELOPMENT_RELAUNCH_TITLE": "Tarayıcıya bağlanılıyor",
    "LIVE_DEVELOPMENT_ERROR_MESSAGE": "Canlı önizleme özelliğini kullanabilmek için uzaktan hata ayıklayıcı ile Chrome'un tekrardan açılması gerekiyor.<br /><br />Chrome'u uzaktan hata ayıklayıcı ile tekrardan açılmasını ister misiniz?",
    "LIVE_DEV_LOADING_ERROR_MESSAGE": "Canlı Önizleme sayfası yüklenemedi.",
    "LIVE_DEV_NEED_HTML_MESSAGE": "Canlı önizlemeyi çalıştırabilmeniz için html dosyası açmanız gerekiyor",
    "LIVE_DEV_NEED_BASEURL_MESSAGE": "Canlı Önizlemeyi server-side dosyalarınız ile açmak istiyorsanız, lütfen bu proje için kullanılabilir bir link belirtiniz.",
    "LIVE_DEV_SERVER_NOT_READY_MESSAGE": "Canlı önizleme dosyaları için HTTP sunucusu başlatılırken hata oluştu. Daha sonra yeniden deneyin.",
    "LIVE_DEVELOPMENT_INFO_TITLE": "Canlı Önizlemeye Hoşgeldiniz!",
    "LIVE_DEVELOPMENT_INFO_MESSAGE": "Canlı önizleme için {APP_NAME} programı tarayıcınıza bağlanıyor ve sizin HTML dosyanızın örnek görüntüsünü tarayıcınızda açıyor. Sonrasında ise değişiklik yaptığınız sayfayı anında tarayıcıda yenileyerek gösteriyor.<br /><br />{APP_NAME} programının bu versiyonunda, Canlı önizleme özelliği sadece <strong>CSS dosyaları</strong> değişikliğine izin veriyor ve sadece <strong>Google Chrome</strong> üzerinde çalışıyor. Yakında HTML ve Javascript değişikliğini de ekleyeceğiz!<br /><br />(Bu mesaj sadece tek sefer gösterilecektir.)",
    "LIVE_DEVELOPMENT_TROUBLESHOOTING": "Detaylı bilgi için lütfen <a href='{0}' title='{0}'>Troubleshooting Live Development connection errors</a> sayfasına bakınız.",

    "LIVE_DEV_STATUS_TIP_NOT_CONNECTED": "Canlı Önizleme",
    "LIVE_DEV_STATUS_TIP_PROGRESS1": "Canlı Önizleme: Bağlanılıyor\u2026",
    "LIVE_DEV_STATUS_TIP_PROGRESS2": "Canlı Önizleme: Başlıyor\u2026",
    "LIVE_DEV_STATUS_TIP_CONNECTED": "Canlı Önizleme'den Çık",
    "LIVE_DEV_STATUS_TIP_OUT_OF_SYNC": "Canlı Önizleme: Kapatmak için tıklayın (Yenilemek için dosyayı kaydedin)",
    "LIVE_DEV_STATUS_TIP_SYNC_ERROR": "Canlı Önizleme (sözdizimi hatası nedeniyle güncellenemiyor)",

    "LIVE_DEV_DETACHED_REPLACED_WITH_DEVTOOLS": "Tarayıcının geliştirici araçları açıldığı için Canlı Önizleme iptal edildi",
    "LIVE_DEV_DETACHED_TARGET_CLOSED": "Sayfa tarayıcıda kapatıldığı için Canlı Önizleme iptal edildi",
    "LIVE_DEV_NAVIGATED_AWAY": "Tarayıcı geçerli projenin parçası olmayan bir sayfaya ulaştığı için Canlı Önizleme iptal edildi",
    "LIVE_DEV_CLOSED_UNKNOWN_REASON": "Canlı Önizleme bilinmeyen bir nedenle iptal edildi ({0})",

    "SAVE_CLOSE_TITLE": "Değişiklikleri kaydet",
    "SAVE_CLOSE_MESSAGE": "<span class='dialog-filename'>{0}</span> dosyasında yaptığınız değişiklikleri kaydetmek istiyor musunuz?",
    "SAVE_CLOSE_MULTI_MESSAGE": "Dosyalardaki değişiklikleri kaydetmek istiyor musunuz?",
    "EXT_MODIFIED_TITLE": "Harici değişiklikler",
    "CONFIRM_DELETE_TITLE": "Silme İşlemini Onayla",
    "CONFIRM_FILE_DELETE": "<span class='dialog-filename'>{0}</span> dosyasını silmek istediğinizden emin misiniz?",
    "CONFIRM_FOLDER_DELETE": "<span class='dialog-filename'>{0}</span> klasörünü silmek istediğinizden emin misiniz?",
    "FILE_DELETED_TITLE": "Dosya Silindi",
    "EXT_MODIFIED_WARNING": "<span class='dialog-filename'>{0}</span>, {APP_NAME} dışında bir disk üzerinde değiştirilmiş.<br /><br />Dosyayı kaydetmek ve bu değişikliklerin üzerine yazmak istiyor musunuz?",
    "EXT_MODIFIED_MESSAGE": "<span class='dialog-filename'>{0}</span> dosyası dışarıdan değiştirildi ama {APP_NAME} programında kaydetmediğiniz değişiklikler bulunmakta.<br /><br />Hangi versiyonun kalmasını istiyorsunuz?",
    "EXT_DELETED_MESSAGE": "<span class='dialog-filename'>{0}</span> dosyası hafızadan silind ama {APP_NAME} programında kaydetmediğiniz değişiklikler bulunmakta.<br /><br />Değişikliklerin kalmasını istiyor musunuz?",

    // Generic dialog/button labels
    "DONE": "Bitti",
    "OK": "Tamam",
    "CANCEL": "İptal",
    "DONT_SAVE": "Kaydetme",
    "SAVE": "Kaydet",
    "SAVE_AS": "Farklı Kaydet\u2026",
    "SAVE_AND_OVERWRITE": "Üzerine Yaz",
    "DELETE": "Sil",
    "BUTTON_YES": "Evet",
    "BUTTON_NO": "Hayır",

    // Find, Replace, Find in Files
    "FIND_MATCH_INDEX": "{0} / {1}",
    "FIND_NO_RESULTS": "Sonuç yok",
    "FIND_QUERY_PLACEHOLDER": "Bul\u2026",
    "REPLACE_PLACEHOLDER": "Şununla değiştir\u2026",
    "BUTTON_REPLACE_ALL": "Toplu Olarak\u2026",
    "BUTTON_REPLACE_ALL_IN_FILES": "Değiştir\u2026",
    "BUTTON_REPLACE": "Değiştir",
    "BUTTON_NEXT": "\u25B6",
    "BUTTON_PREV": "\u25C0",
    "BUTTON_NEXT_HINT": "Sonraki Eşleşme",
    "BUTTON_PREV_HINT": "Önceki Eşleşme",
    "BUTTON_CASESENSITIVE_HINT": "Büyük Küçük Harf Eşleştir",
    "BUTTON_REGEXP_HINT": "Düzenli İfade",
    "REPLACE_WITHOUT_UNDO_WARNING_TITLE": "Geri Alma Olmadan Değiştir",
    "REPLACE_WITHOUT_UNDO_WARNING": "{0} dosyadan fazlasının değiştirilmesi gerektiği için {APP_NAME} diskteki açılmamış dosyaları değiştirecek.<br />Bu dosyalarda yapılan değişiklikleri geri alamazsınız.",
    "BUTTON_REPLACE_WITHOUT_UNDO": "Geri Alma Olmadan Değiştir",

    "OPEN_FILE": "Dosya Aç",
    "SAVE_FILE_AS": "Dosyayı Kaydet",
    "CHOOSE_FOLDER": "Klasör seç",

    "RELEASE_NOTES": "Sürüm Notları",
    "NO_UPDATE_TITLE": "En son versiyon!",
    "NO_UPDATE_MESSAGE": "{APP_NAME} programının en son versiyonunu kullanıyorsunuz.",

    // Find and Replace
    "FIND_REPLACE_TITLE_LABEL": "Değiştir",
    "FIND_REPLACE_TITLE_WITH": "-",
    "FIND_TITLE_LABEL": "Bulundu",
    "FIND_TITLE_SUMMARY": "&mdash; {3} içinde {0} {1} {2}",

    // Find in Files
    "FIND_NUM_FILES": "{0} {1}",
    "FIND_IN_FILES_SCOPED": "<span class='dialog-filename'>{0}</span> dosyası içinde",
    "FIND_IN_FILES_NO_SCOPE": "proje içinde",
    "FIND_IN_FILES_ZERO_FILES": "Filtre tüm dosyaları dışlıyor {0}",
    "FIND_IN_FILES_FILE": "dosya",
    "FIND_IN_FILES_FILES": "dosyalar",
    "FIND_IN_FILES_MATCH": "eşleşen",
    "FIND_IN_FILES_MATCHES": "eşleşenler",
    "FIND_IN_FILES_MORE_THAN": "Daha fazla ",
    "FIND_IN_FILES_PAGING": "{0}&mdash;{1}",
    "FIND_IN_FILES_FILE_PATH": "Dosya: <b>{0}</b>",
    "FIND_IN_FILES_EXPAND_COLLAPSE": "Tümünü genişletmek/daraltmak için Ctrl/Cmd tuşuna basarak tıklatın",
    "FIND_IN_FILES_INDEXING": "Hızlı Arama için dizin oluşturuluyor\u2026",
    "REPLACE_IN_FILES_ERRORS_TITLE": "Değiştirme Hataları",
    "REPLACE_IN_FILES_ERRORS": "Aşağıdaki dosyalar arama işleminden sonra değişiklik yapıldığı veya yazılamadığı için değiştirilemedi.",

    "ERROR_FETCHING_UPDATE_INFO_TITLE": "Versiyon bilgisi alınırken hata",
    "ERROR_FETCHING_UPDATE_INFO_MSG": "Sunucudan yeni versiyon bilgisi alınırken hata oluştu. Lütfen internete bağlı olduğunuzdan emin olun ve tekrar deneyin.",

    // File exclusion filters
    "NEW_FILE_FILTER": "Yeni Dışlama Kümesi\u2026",
    "CLEAR_FILE_FILTER": "Dosyaları Hariç Tutma",
    "NO_FILE_FILTER": "Dışlanan Dosya Yok",
    "EXCLUDE_FILE_FILTER": "{0} Dışla",
    "EDIT_FILE_FILTER": "Düzenle\u2026",
    "FILE_FILTER_DIALOG": "Dışlama Kümesini Düzenle",
    "FILE_FILTER_INSTRUCTIONS": "Aşağıdaki dizeler / alt dizeler veya <a href='{0}' title='{0}'>joker karakterlerden</a> biriyle eşleşen dosyalar ve klasörleri dışlayın. Her dizeyi yeni bir satıra girin.",
    "FILTER_NAME_PLACEHOLDER": "Bu dışlama kümesini adlandır (isteğe bağlı)",
    "FILE_FILTER_CLIPPED_SUFFIX": "ve {0} daha",
    "FILTER_COUNTING_FILES": "Dosyalar sayılıyor\u2026",
    "FILTER_FILE_COUNT": "{0} / {1} dosyaya izin veriliyor {2}",
    "FILTER_FILE_COUNT_ALL": "{0} dosyanın tamamına izin veriliyor {1}",

    // Quick Edit
    "ERROR_QUICK_EDIT_PROVIDER_NOT_FOUND": "Geçerli imleç konumu için kullanılabilecek Hızlı Düzenleme yok",
    "ERROR_CSSQUICKEDIT_BETWEENCLASSES": "CSS Hızlı Düzenleme: İmleci tek bir sınıf adının üzerine getirin",
    "ERROR_CSSQUICKEDIT_CLASSNOTFOUND": "CSS Hızlı Düzenleme: Tamamlanmamış sınıf niteliği",
    "ERROR_CSSQUICKEDIT_IDNOTFOUND": "CSS Hızlı Düzenleme: Tamamlanmamış kimlik niteliği",
    "ERROR_CSSQUICKEDIT_UNSUPPORTEDATTR": "CSS Hızlı Düzenleme: İmleci etiket, sınıf veya kimlik içine yerleştirin",
    "ERROR_TIMINGQUICKEDIT_INVALIDSYNTAX": "CSS Zamanlama İşlevini Hızlı Düzenleme: geçersiz sözdizimi",
    "ERROR_JSQUICKEDIT_FUNCTIONNOTFOUND": "JS Hızlı Düzenleme: İmleci işlev adının üzerine getirin",

    // Quick Docs
    "ERROR_QUICK_DOCS_PROVIDER_NOT_FOUND": "Geçerli imleç konumu için kullanılabilecek Hızlı Belgeler yok",

    /**
     * ProjectManager
     */
    "PROJECT_LOADING": "Proje Yükleniyor\u2026",
    "UNTITLED": "Adsız",
    "WORKING_FILES": "Çalışılan Dosyalar",

    /**
     * MainViewManager
     */
    "TOP": "Üst",
    "BOTTOM": "Alt",
    "LEFT": "Sol",
    "RIGHT": "Sağ",

    "CMD_SPLITVIEW_NONE": "Bölünme Yok",
    "CMD_SPLITVIEW_VERTICAL": "Dikey Böl",
    "CMD_SPLITVIEW_HORIZONTAL": "Yatay Böl",
    "SPLITVIEW_MENU_TOOLTIP": "Düzenleyiciyi dikey veya yatay olarak böl",
    "GEAR_MENU_TOOLTIP": "Çalışma Kümesini Yapılandır",

    "SPLITVIEW_INFO_TITLE": "Zaten Açık",
    "SPLITVIEW_MULTIPANE_WARNING": "Dosya başka bir bölmede zaten açık. {APP_NAME} yakında aynı dosyanın birden çok bölmede açılmasını destekleyecek. O zamana kadar, dosya zaten açık olduğu bölmede gösterilmeye devam edecek.<br /><br />(Bu mesajı yalnızca bir kez göreceksiniz.)",

    /**
     * Keyboard modifiers and special key names
     */
    "KEYBOARD_CTRL": "Ctrl",
    "KEYBOARD_SHIFT": "Shift",
    "KEYBOARD_SPACE": "Boşluk",
    "KEYBOARD_PAGE_UP": "Page Up",
    "KEYBOARD_PAGE_DOWN": "Page Down",
    "KEYBOARD_HOME": "Home",
    "KEYBOARD_END": "Son",
    "KEYBOARD_INSERT": "Ekle",
    "KEYBOARD_DELETE": "Sil",

    /**
     * StatusBar strings
     */
    "STATUSBAR_CURSOR_POSITION": "Satır {0}, Kolon {1}",
    "STATUSBAR_SELECTION_CH_SINGULAR": " \u2014 {0} sütun seçildi",
    "STATUSBAR_SELECTION_CH_PLURAL": " \u2014 {0} sütun seçildi",
    "STATUSBAR_SELECTION_LINE_SINGULAR": " \u2014 {0} satır seçildi",
    "STATUSBAR_SELECTION_LINE_PLURAL": " \u2014 {0} satır seçildi",
    "STATUSBAR_SELECTION_MULTIPLE": " \u2014 {0} seçim",
    "STATUSBAR_INDENT_TOOLTIP_SPACES": "Girintiyi boşluk karakterleriyle değiştirmek için tıklayın",
    "STATUSBAR_INDENT_TOOLTIP_TABS": "Girintiyi tab karakterleriyle değiştirmek için tıklayın",
    "STATUSBAR_INDENT_SIZE_TOOLTIP_SPACES": "Girintide kullanılacak boşluk sayısını değiştirmek için tıklayın",
    "STATUSBAR_INDENT_SIZE_TOOLTIP_TABS": "Tab karakter genişliğini değiştirmek için tıklayın",
    "STATUSBAR_SPACES": "Boşluk:",
    "STATUSBAR_TAB_SIZE": "Tab Boyutu:",
    "STATUSBAR_LINE_COUNT_SINGULAR": "\u2014 {0} Satır",
    "STATUSBAR_LINE_COUNT_PLURAL": "\u2014 {0} Satır",
    "STATUSBAR_USER_EXTENSIONS_DISABLED": "Uzantılar Devre Dışı Bırakıldı",
    "STATUSBAR_INSERT": "EKLE",
    "STATUSBAR_OVERWRITE": "OVR",
    "STATUSBAR_INSOVR_TOOLTIP": "Ekle (INS) ve Üzerine Yaz (OVR) modlarına imleci geçirmek için tıklatın",
    "STATUSBAR_LANG_TOOLTIP": "Dosya türünü değiştirmek için tıklatın",
    "STATUSBAR_CODE_INSPECTION_TOOLTIP": "{0}. Rapor bölmesine geçmek için tıklatın.",
    "STATUSBAR_DEFAULT_LANG": "(varsayılan)",
    "STATUSBAR_SET_DEFAULT_LANG": ".{0} Dosyaları için Varsayılan Yap",

    // CodeInspection: errors/warnings
    "ERRORS_PANEL_TITLE_MULTIPLE": "{0} Sorunları",
    "SINGLE_ERROR": "1 {0} Sorunu",
    "MULTIPLE_ERRORS": "{1} {0} Sorunları",
    "NO_ERRORS": "Tebrikler, {0} ile ilgili bir sorun bulunmadı!",
    "NO_ERRORS_MULTIPLE_PROVIDER": "Tebrikler, hiçbir sorun bulunmadı!",
    "LINT_DISABLED": "Linting devre dışı bırakıldı",
    "NO_LINT_AVAILABLE": "{0} için Linting aracı yok",
    "NOTHING_TO_LINT": "Linting uygulanacak öğe yok",
    "LINTER_TIMED_OUT": "{0} {1} ms bekledikten sonra zaman aşımına uğradı",
    "LINTER_FAILED": "{0} şu hatayla sonlandırıldı: {1}",

    /**
     * Command Name Constants
     */

    // File menu commands
    "FILE_MENU": "Dosya",
    "CMD_FILE_NEW_UNTITLED": "Yeni",
    "CMD_FILE_NEW": "Yeni Dosya",
    "CMD_FILE_NEW_FOLDER": "Yeni Klasör",
    "CMD_FILE_OPEN": "Aç\u2026",
    "CMD_RECENT_FILES_OPEN": "Son Kullanılanları Aç\u2026",
    "CMD_ADD_TO_WORKING_SET": "Çalışma Ekranına Ekle",
    "CMD_OPEN_DROPPED_FILES": "Bırakılan Dosyaları Aç",
    "CMD_OPEN_FOLDER": "Klasörü Aç\u2026",
    "CMD_FILE_CLOSE": "Kapat",
    "CMD_FILE_CLOSE_ALL": "Hepsini Kapat",
    "CMD_FILE_CLOSE_LIST": "Listeyi Kapat",
    "CMD_FILE_CLOSE_OTHERS": "Diğerlerini Kapat",
    "CMD_FILE_CLOSE_ABOVE": "Üstündeki Diğer Öğeleri Kapat",
    "CMD_FILE_CLOSE_BELOW": "Altındaki Diğer Öğeleri Kapat",
    "CMD_FILE_SAVE": "Kaydet",
    "CMD_FILE_SAVE_ALL": "Tümünü Kaydet",
    "CMD_FILE_SAVE_AS": "Farklı Kaydet\u2026",
    "CMD_LIVE_FILE_PREVIEW": "Canlı Önizleme",
    "CMD_TOGGLE_LIVE_PREVIEW_MB_MODE": "Deneysel Canlı Önizlemeyi Etkinleştir",
    "CMD_RELOAD_LIVE_PREVIEW": "Canlı Önizlemeyi Yeniden Yüklemeye Zorla",
    "CMD_PROJECT_SETTINGS": "Proje Ayarları\u2026",
    "CMD_FILE_RENAME": "Yeniden Adlandır",
    "CMD_FILE_DELETE": "Sil",
    "CMD_INSTALL_EXTENSION": "Uzantıyı Yükle\u2026",
    "CMD_EXTENSION_MANAGER": "Eklenti Yöneticisi\u2026",
    "CMD_FILE_REFRESH": "Dosya Ağacını Yenile",
    "CMD_QUIT": "Çıkış",
    // Used in native File menu on Windows
    "CMD_EXIT": "Çıkış",

    // Edit menu commands
    "EDIT_MENU": "Düzenle",
    "CMD_UNDO": "Geri Al",
    "CMD_REDO": "Yinele",
    "CMD_CUT": "Kes",
    "CMD_COPY": "Kopyala",
    "CMD_PASTE": "Yapıştır",
    "CMD_SELECT_ALL": "Tümünü Seç",
    "CMD_SELECT_LINE": "Satırı Seç",
    "CMD_SPLIT_SEL_INTO_LINES": "Seçileni Satırlara Böl",
    "CMD_ADD_CUR_TO_NEXT_LINE": "Sonraki Satıra İmleç Ekle",
    "CMD_ADD_CUR_TO_PREV_LINE": "Önceki Satıra İmleç Ekle",
    "CMD_INDENT": "Girinti",
    "CMD_UNINDENT": "Girintiyi Geri Al",
    "CMD_DUPLICATE": "Çoğalt",
    "CMD_DELETE_LINES": "Satırı Sil",
    "CMD_COMMENT": "Satır Yorumu Açık/Kapalı",
    "CMD_BLOCK_COMMENT": "Blok Yorumu Açık/Kapalı",
    "CMD_LINE_UP": "Satırı Yukarı Taşı",
    "CMD_LINE_DOWN": "Satırı Aşağıya Taşı",
    "CMD_OPEN_LINE_ABOVE": "Üstündeki Satırı Aç",
    "CMD_OPEN_LINE_BELOW": "Altındaki Satırı Aç",
    "CMD_TOGGLE_CLOSE_BRACKETS": "Parantezleri Otomatik Tamamla",
    "CMD_SHOW_CODE_HINTS": "Kod İpuçlarını Göster",

    // Search menu commands
    "FIND_MENU": "Bul",
    "CMD_FIND": "Bul",
    "CMD_FIND_NEXT": "Sonrakini Bul",
    "CMD_FIND_PREVIOUS": "Öncekini Bul",
    "CMD_FIND_ALL_AND_SELECT": "Hepsini Bul ve Seç",
    "CMD_ADD_NEXT_MATCH": "Sonraki Eşleşmeyi Seçime Ekle",
    "CMD_SKIP_CURRENT_MATCH": "Atla ve Sonraki Eşleşmeyi Ekle",
    "CMD_FIND_IN_FILES": "Dosyalarda Bul",
    "CMD_FIND_IN_SUBTREE": "\u2026içinde bul",
    "CMD_REPLACE": "Değiştir",
    "CMD_REPLACE_IN_FILES": "Dosyalarda Değiştir",
    "CMD_REPLACE_IN_SUBTREE": "Değiştir\u2026",

    // View menu commands
    "VIEW_MENU": "Görünüm",
    "CMD_HIDE_SIDEBAR": "Kenar Çubuğunu Gizle",
    "CMD_SHOW_SIDEBAR": "Kenar Çubuğunu Göster",
    "CMD_TOGGLE_SIDEBAR": "Kenar Çubuğunu Aç/Kapat",
    "CMD_TOGGLE_PANELS": "Panelleri Aç/Kapat",
    "CMD_TOGGLE_PURE_CODE": "Ayrıntı Yok",
    "CMD_INCREASE_FONT_SIZE": "Font Boyutunu Büyült",
    "CMD_DECREASE_FONT_SIZE": "Font Boyutunu Küçült",
    "CMD_RESTORE_FONT_SIZE": "Font Boyutunu Sıfırla",
    "CMD_SCROLL_LINE_UP": "Satırı Yukarı Kaydır",
    "CMD_SCROLL_LINE_DOWN": "Satırı Aşağı Kaydır",
    "CMD_TOGGLE_LINE_NUMBERS": "Satır Numaraları",
    "CMD_TOGGLE_ACTIVE_LINE": "Etkin Satırı Vurgula",
    "CMD_TOGGLE_WORD_WRAP": "Sözcük Kaydır",
    "CMD_LIVE_HIGHLIGHT": "Canlı Önizleme Vurgusu",
    "CMD_VIEW_TOGGLE_INSPECTION": "Kaydederken Dosyalara Linting Uygula",
    "CMD_WORKINGSET_SORT_BY_ADDED": "Eklenmeye Göre Sırala",
    "CMD_WORKINGSET_SORT_BY_NAME": "İsme Göre Sırala",
    "CMD_WORKINGSET_SORT_BY_TYPE": "Türüne Göre Sırala",
    "CMD_WORKING_SORT_TOGGLE_AUTO": "Otomatik Sırala",
    "CMD_THEMES": "Temalar\u2026",

    // Navigate menu commands
    "NAVIGATE_MENU": "Git",
    "CMD_QUICK_OPEN": "Hızlı Aç",
    "CMD_GOTO_LINE": "Satıra Git",
    "CMD_GOTO_DEFINITION": "Tanıma Git",
    "CMD_GOTO_FIRST_PROBLEM": "İlk Hata veya Uyarıya Git",
    "CMD_TOGGLE_QUICK_EDIT": "Hızlı Düzenleme",
    "CMD_TOGGLE_QUICK_DOCS": "Hızlı Belgeler",
    "CMD_QUICK_EDIT_PREV_MATCH": "Önceki Eşleşme",
    "CMD_QUICK_EDIT_NEXT_MATCH": "Sonraki Eşleşme",
    "CMD_CSS_QUICK_EDIT_NEW_RULE": "Yeni Kural",
    "CMD_NEXT_DOC": "Sonraki Belge",
    "CMD_PREV_DOC": "Önceki Belge",
    "CMD_NEXT_DOC_LIST_ORDER": "Listedeki Sonraki Belge",
    "CMD_PREV_DOC_LIST_ORDER": "Listedeki Önceki Belge",
    "CMD_SHOW_IN_TREE": "Dosya Listesinde Göster",
    "CMD_SHOW_IN_EXPLORER": "Explorer'da Göster",
    "CMD_SHOW_IN_FINDER": "Finder'da Göster",
    "CMD_SHOW_IN_OS": "Bulunduğu Konumu Aç",

    // Help menu commands
    "HELP_MENU": "Yardım",
    "CMD_CHECK_FOR_UPDATE": "Yeni Versiyon Kontrol Et",
    "CMD_HOW_TO_USE_BRACKETS": "{APP_NAME} Nasıl Kullanılır",
    "CMD_SUPPORT": "{APP_NAME} Desteği",
    "CMD_SUGGEST": "Yeni Özellik Öner",
    "CMD_RELEASE_NOTES": "Sürüm Notları",
    "CMD_GET_INVOLVED": "Projeye Dahil Ol",
    "CMD_SHOW_EXTENSIONS_FOLDER": "Eklentiler Klasörünü Göster",
    "CMD_HEALTH_DATA_STATISTICS": "Sistem Durumu Raporu",
    "CMD_HOMEPAGE": "{APP_TITLE} Giriş Sayfası",
    "CMD_TWITTER": "{TWITTER_NAME} Twitter'da...",
    "CMD_ABOUT": "{APP_TITLE} Hakkında",
    "CMD_OPEN_PREFERENCES": "Ayarlar Dosyasını Aç",
    "CMD_OPEN_KEYMAP": "Kullanıcı Anahtarı Eşlemesini Aç",

    // Strings for main-view.html
    "EXPERIMENTAL_BUILD": "Deneysel Sürüm",
    "RELEASE_BUILD": "derleme",
    "DEVELOPMENT_BUILD": "geliştirme derlemesi",
    "RELOAD_FROM_DISK": "Hafızadan Yenile",
    "KEEP_CHANGES_IN_EDITOR": "Değişiklikleri Editörde Tut",
    "CLOSE_DONT_SAVE": "Kapat (Kaydetme)",
    "RELAUNCH_CHROME": "Chrome'u Tekrar Aç",
    "ABOUT": "Hakkında",
    "CLOSE": "Kapat",
    "ABOUT_TEXT_LINE1": "sprint 14 test sürümü",
    "ABOUT_TEXT_BUILD_TIMESTAMP": "derleme zaman damgası: ",
    "ABOUT_TEXT_LINE3": "Üçüncü parti yazılımlara ilişkin bildirimler, şartlar ve koşullar <a href='{ADOBE_THIRD_PARTY}'>{ADOBE_THIRD_PARTY}</a> adresinde bulunmaktadır ve bu adreste referans olarak dahil edilmiştir",
    "ABOUT_TEXT_LINE4": "Döküman ve kodlar için <a href='https://github.com/adobe/brackets/'>https://github.com/adobe/brackets/</a> adresine bakabilirsiniz.",
    "ABOUT_TEXT_LINE5": "\u2764 ve JavaScript ile oluşturan:",
    "ABOUT_TEXT_LINE6": "Çok sayıda kişi (ancak bu verileri şu anda yükleyemiyoruz).",
    "ABOUT_TEXT_WEB_PLATFORM_DOCS": "Web Platform Docs ve Web Platform grafik logosu Creative Commons Nitelik lisansı, <a href='{WEB_PLATFORM_DOCS_LICENSE}'>CC-BY 3.0 Unported</a> kapsamında lisanslıdır.",
    "UPDATE_NOTIFICATION_TOOLTIP": "{APP_NAME} programının yeni versiyonu bulunmakta! Detaylar için tıklayın.",
    "UPDATE_AVAILABLE_TITLE": "Yeni versiyon hazır",
    "UPDATE_MESSAGE": "Hey, {APP_NAME} programının yeni versiyonu hazır. İşte bazı yeni özellikler:",
    "GET_IT_NOW": "Şimdi Yükle!",
    "PROJECT_SETTINGS_TITLE": "{0} için Proje Ayarları",
    "PROJECT_SETTING_BASE_URL": "Ana URL'den Canlı Önizleme",
    "PROJECT_SETTING_BASE_URL_HINT": "(dosya urlsi için boş bırakın)",
    "BASEURL_ERROR_INVALID_PROTOCOL": "{0} protokolü canlı önizlemeyi desteklemiyor.&mdash;lütfen http: or https: kullanın.",
    "BASEURL_ERROR_SEARCH_DISALLOWED": "Ana URL \"{0}\" gibi arama karakterleri bulunduramaz.",
    "BASEURL_ERROR_HASH_DISALLOWED": "Ana URL \"{0}\" gibi karakterler bulunduramaz.",
    "BASEURL_ERROR_INVALID_CHAR": "'{0}' gibi özel karakterler %-kodlanması gerekiyor.",
    "BASEURL_ERROR_UNKNOWN_ERROR": "Ana URL'yi işlerken bilinmeyen hata",

    // Strings for Pane.js
    "EMPTY_VIEW_HEADER": "<em>Bu bölme odaktayken dosya aç</em>",
    "FLIPVIEW_BTN_TOOLTIP": "Bu görünümü {0} bölmesine çevir",

    // Strings for themes-settings.html and themes-general.html
    "CURRENT_THEME": "Geçerli Tema",
    "USE_THEME_SCROLLBARS": "Tema Kaydırma Çubuklarını Kullan",
    "FONT_SIZE": "Font Boyutu",
    "FONT_FAMILY": "Font Ailesi",
    "THEMES_SETTINGS": "Tema Ayarları",

    // CSS Quick Edit
    "BUTTON_NEW_RULE": "Yeni Kural",

    // Extension Management strings
    "INSTALL": "Yükle",
    "UPDATE": "Güncelleştir",
    "REMOVE": "Kaldır",
    "DISABLE": "Devre dışı bırak",
    "ENABLE": "Etkinleştir",
    "OVERWRITE": "Üzerine Yaz",
    "CANT_REMOVE_DEV": "\“Dev\” klasöründeki uzantıların elle silinmesi gerekiyor.",
    "CANT_UPDATE": "Güncelleme bu {APP_NAME} sürümü ile uyumlu değil.",
    "CANT_UPDATE_DEV": "\“Dev\” klasöründeki uzantılar otomatik olarak güncellenemez.",
    "INSTALL_EXTENSION_TITLE": "Uzantıyı Yükle",
    "UPDATE_EXTENSION_TITLE": "Uzantıyı Güncelle",
    "INSTALL_EXTENSION_LABEL": "Uzantı URL'si",
    "INSTALL_EXTENSION_HINT": "Uzantının zip dosyasının veya GitHub havuzunun URL'si",
    "INSTALLING_FROM": "{0} uzantısı yükleniyor\u2026",
    "INSTALL_SUCCEEDED": "Yükleme başarıyla tamamlandı!",
    "INSTALL_FAILED": "Yükleme başarısız oldu.",
    "CANCELING_INSTALL": "İptal ediliyor\u2026",
    "CANCELING_HUNG": "Yükleme işleminin iptal edilmesi uzun zaman alıyor. Dahili bir hata oluşmuş olabilir.",
    "INSTALL_CANCELED": "Yükleme iptal edildi.",
    "VIEW_COMPLETE_DESCRIPTION": "Açıklamanın tamamını göster",
    "VIEW_TRUNCATED_DESCRIPTION": "Açıklamayı göründüğü kadarıyla göster",
    // These must match the error codes in ExtensionsDomain.Errors.* :
    "INVALID_ZIP_FILE": "İndirilen içerik geçerli bir zip dosyası değil.",
    "MISSING_PACKAGE_JSON": "Pakette package.json dosyası bulunmuyor.",
    "INVALID_PACKAGE_JSON": "package.json dosyası geçersiz (oluşan hata: {0}).",
    "MISSING_PACKAGE_NAME": "Package.json dosyasında paket adı belirtilmemiş.",
    "BAD_PACKAGE_NAME": "{0} geçersiz bir paket adıdır.",
    "MISSING_PACKAGE_VERSION": "Package.json dosyasında paket sürümü belirtilmemiş.",
    "INVALID_VERSION_NUMBER": "Paket sürüm numarası ({0}) geçersiz.",
    "INVALID_BRACKETS_VERSION": "{APP_NAME} uyumluluk dizesi ({0}) geçersiz.",
    "DISALLOWED_WORDS": "{0} alanında ({1}) sözcüklerine izin verilmiyor.",
    "API_NOT_COMPATIBLE": "Uzantı bu {APP_NAME} sürümü ile uyumlu değil. Devre dışı bırakılmış uzantılar klasörüne yüklendi.",
    "MISSING_MAIN": "Pakette main.js dosyası bulunmuyor.",
    "EXTENSION_ALREADY_INSTALLED": "Bu paket yüklenirse daha önce yüklenen bir uzantının üzerine yazılacak. Eski uzantının üzerine yazılsın mı?",
    "EXTENSION_SAME_VERSION": "Bu paketin sürümü şu anda yüklü olan sürüm ile aynı. Mevcut kurulumun üzerine yazılsın mı?",
    "EXTENSION_OLDER_VERSION": "Bu paketin sürümü {0} ve şu anda yüklü olan sürümden ({1}) daha eski. Mevcut kurulumun üzerine yazılsın mı?",
    "DOWNLOAD_ID_IN_USE": "Dahili hata: İndirme kimliği zaten kullanılıyor.",
    "NO_SERVER_RESPONSE": "Sunucuya bağlanılamıyor.",
    "BAD_HTTP_STATUS": "Dosya sunucuda bulunamadı (HTTP {0}).",
    "CANNOT_WRITE_TEMP": "İndirilen öğe geçici dosyaya kaydedilemedi.",
    "ERROR_LOADING": "Uzantı başlatılırken bir hatayla karşılaşıldı.",
    "MALFORMED_URL": "URL geçersiz. Lütfen URL'yi doğru girip girmediğinizi kontrol edin.",
    "UNSUPPORTED_PROTOCOL": "URL bir http veya https URL'si olmalıdır.",
    "UNKNOWN_ERROR": "Bilinmeyen dahili hata.",
    // For NOT_FOUND_ERR, see generic strings above
    "EXTENSION_MANAGER_TITLE": "Extension Manager",
    "EXTENSION_MANAGER_ERROR_LOAD": "Uzantı kayıt defterine erişilemedi. Lütfen daha sonra tekrar deneyin.",
    "INSTALL_EXTENSION_DRAG": ".zip dosyasını buraya sürükleyin veya",
    "INSTALL_EXTENSION_DROP": "Yüklenecek .zip dosyasını buraya bırakın",
    "INSTALL_EXTENSION_DROP_ERROR": "Yükleme/Güncelleme işlemi aşağıdaki hatalar nedeniyle sonlandırıldı:",
    "INSTALL_FROM_URL": "URL'den Yükle\u2026",
    "INSTALL_EXTENSION_VALIDATING": "Doğrulanıyor\u2026",
    "EXTENSION_AUTHOR": "Yazar",
    "EXTENSION_DATE": "Tarih",
    "EXTENSION_INCOMPATIBLE_NEWER": "Bu uzantı için daha yeni bir {APP_NAME} sürümü gerekiyor.",
    "EXTENSION_INCOMPATIBLE_OLDER": "Bu uzantı şu anda yalnızca daha eski {APP_NAME} sürümleriyle birlikte çalışır.",
    "EXTENSION_LATEST_INCOMPATIBLE_NEWER": "Bu uzantının {0} sürümü için daha yeni bir {APP_NAME} sürümü gerekiyor. Ancak daha eski {1} sürümünü yükleyebilirsiniz.",
    "EXTENSION_LATEST_INCOMPATIBLE_OLDER": "Bu uzantının {0} sürümü yalnızca daha eski {APP_NAME} sürümleriyle birlikte çalışır. Ancak daha eski {1} sürümünü yükleyebilirsiniz.",
    "EXTENSION_NO_DESCRIPTION": "Açıklama yok",
    "EXTENSION_MORE_INFO": "Daha fazla bilgi\u2026",
    "EXTENSION_ERROR": "Uzantı hatası",
    "EXTENSION_KEYWORDS": "Anahtar Sözcükler",
    "EXTENSION_TRANSLATED_USER_LANG": "Türkçe de dahil olmak üzere {0} dile çevrilmiş",
    "EXTENSION_TRANSLATED_GENERAL": "{0} dile çevrilmiş",
    "EXTENSION_TRANSLATED_LANGS": "Bu uzantı şu dillere çevrilmiş: {0}",
    "EXTENSION_INSTALLED": "Yüklendi",
    "EXTENSION_UPDATE_INSTALLED": "Bu uzantı güncellemesi indirildi ve {APP_NAME} yeniden yüklendikten sonra kurulumu yapılacak.",
    "EXTENSION_SEARCH_PLACEHOLDER": "Arama",
    "EXTENSION_MORE_INFO_LINK": "Daha Fazla",
    "BROWSE_EXTENSIONS": "Uzantılara Gözat",
    "EXTENSION_MANAGER_REMOVE": "Uzantıyı Kaldır",
    "EXTENSION_MANAGER_REMOVE_ERROR": "Bir veya daha fazla uzantı kaldırılamadı: {0}. {APP_NAME} yeniden yüklenecek.",
    "EXTENSION_MANAGER_UPDATE": "Uzantıyı Güncelle",
    "EXTENSION_MANAGER_UPDATE_ERROR": "Bir veya daha fazla uzantı güncellenemedi: {0}. {APP_NAME} yeniden yüklenecek.",
    "EXTENSION_MANAGER_DISABLE": "Uzantıyı Devre Dışı Bırak",
    "EXTENSION_MANAGER_DISABLE_ERROR": "Bir veya daha fazla uzantı devre dışı bırakılamadı: {0}. {APP_NAME} yeniden yüklenecek.",
    "MARKED_FOR_REMOVAL": "Kaldırılmak üzere işaretlendi",
    "UNDO_REMOVE": "Geri Al",
    "MARKED_FOR_UPDATE": "Güncellenmek üzere işaretlendi",
    "UNDO_UPDATE": "Geri Al",
    "MARKED_FOR_DISABLING": "Devre dışı bırakılmak üzere işaretlendi",
    "UNDO_DISABLE": "Geri Al",
    "CHANGE_AND_RELOAD_TITLE": "Uzantıları Değiştir",
    "CHANGE_AND_RELOAD_MESSAGE": "İşaretlenen uzantıları güncellemek, kaldırmak veya devre dışı bırakmak için {APP_NAME} uygulamasının yeniden yüklenmesi gerekiyor. Kaydedilmemiş değişiklikleri kaydetmeniz istenecektir.",
    "REMOVE_AND_RELOAD": "Uzantıları Kaldır ve Yeniden Yükle",
    "CHANGE_AND_RELOAD": "Uzantıları Değiştir ve Yeniden Yükle",
    "UPDATE_AND_RELOAD": "Uzantıları Güncelle ve Yeniden Yükle",
    "DISABLE_AND_RELOAD": "Uzantıları Devre Dışı Bırak ve Yeniden Yükle",
    "PROCESSING_EXTENSIONS": "Uzantı değişiklikleri işleniyor\u2026",
    "EXTENSION_NOT_INSTALLED": "{0} uzantısı yüklü değil.",
    "NO_EXTENSIONS": "Henüz uzantı yüklenmedi.<br>Başlamak için yukarıdaki Kullanılabilir sekmesini tıklatın.",
    "NO_EXTENSION_MATCHES": "Aramanızla eşleşen uzantı bulunmuyor.",
    "REGISTRY_SANITY_CHECK_WARNING": "NOT: Bu uzantılar {APP_NAME} yerine farklı yazarlar tarafından hazırlanmış olabilir. Uzantılar incelenmez ve tüm yerel ayrıcalıklara sahiptir. Bilinmeyen bir kaynaktan uzantı yüklerken dikkatli olun.",
    "EXTENSIONS_INSTALLED_TITLE": "Yüklendi",
    "EXTENSIONS_AVAILABLE_TITLE": "Kullanılabilir",
    "EXTENSIONS_THEMES_TITLE": "Temalar",
    "EXTENSIONS_UPDATES_TITLE": "Güncellemeler",

    "INLINE_EDITOR_NO_MATCHES": "Kullanılabilir eşleşme yok.",
    "INLINE_EDITOR_HIDDEN_MATCHES": "Tüm eşleşmeler daraltıldı. Eşleşmeleri görüntülemek için sağ tarafta listelenen dosyaları genişletin.",
    "CSS_QUICK_EDIT_NO_MATCHES": "Seçiminizle eşleşen mevcut CSS kuralı bulunmuyor.<br> Yeni bir kural oluşturmak için \“Yeni Kural\”ı tıklatın.",
    "CSS_QUICK_EDIT_NO_STYLESHEETS": "Projenizde stil sayfası bulunmuyor.<br>CSS kuralları eklemek için bir stil sayfası oluşturun.",

    // Custom Viewers
    "IMAGE_VIEWER_LARGEST_ICON": "en büyük",

    /**
     * Unit names
     */
    "UNIT_PIXELS": "piksel",

    // extensions/default/DebugCommands
    "DEBUG_MENU": "Hata Ayıkla",
    "ERRORS": "Hatalar",
    "CMD_SHOW_DEV_TOOLS": "Geliştirici Araçlarını Göster",
    "CMD_REFRESH_WINDOW": "{APP_NAME} Ekranını Yenile",
    "CMD_RELOAD_WITHOUT_USER_EXTS": "Eklentiler Olmadan Yeniden Yükle",
    "CMD_NEW_BRACKETS_WINDOW": "Yeni {APP_NAME} Ekranı",
    "CMD_LAUNCH_SCRIPT_MAC": "Komut Satırı Kısayolunu Yükle",
    "CMD_SWITCH_LANGUAGE": "Dili Değiştir",
    "CMD_RUN_UNIT_TESTS": "Testleri Çalıştır",
    "CMD_SHOW_PERF_DATA": "Performans Bilgisini Göster",
    "CMD_ENABLE_NODE_DEBUGGER": "Node Hata Ayıklayıcısını Etkinleştir",
    "CMD_LOG_NODE_STATE": "Node Durumunu Konsola Yaz",
    "CMD_RESTART_NODE": "Node'u Yeniden Başlat",
    "CMD_SHOW_ERRORS_IN_STATUS_BAR": "Hataları Durum Çubuğu'nda Göster",
    "CMD_OPEN_BRACKETS_SOURCE": "{APP_NAME} Kaynağını Aç",

    "CREATING_LAUNCH_SCRIPT_TITLE": "{APP_NAME} Komut Satırı Kısayolu",
    "ERROR_CREATING_LAUNCH_SCRIPT": "Komut satırı kısayolu yüklenirken bir hata oluştu. Lütfen, <a href='https://github.com/adobe/brackets/wiki/Command-Line-Arguments#troubleshooting'>şu sorun giderme önerilerini</a> deneyin.<br/><br/>Neden: {0}",
    "ERROR_CLTOOLS_RMFAILED": "Mevcut <code>/usr/local/bin/brackets</code> sembolik bağlantısı kaldırılamıyor.",
    "ERROR_CLTOOLS_MKDIRFAILED": "<code>/usr/local/bin</code> dizini oluşturulamıyor.",
    "ERROR_CLTOOLS_LNFAILED": "<code>/usr/local/bin/brackets</code> sembolik bağlantısı oluşturulamıyor.",
    "ERROR_CLTOOLS_SERVFAILED": "İç hata.",
    "ERROR_CLTOOLS_NOTSUPPORTED": "Bu işletim sisteminde komut satırı kısayolu desteklenmiyor.",
    "LAUNCH_SCRIPT_CREATE_SUCCESS": "İşlem başarılı! {APP_NAME} uygulamasını artık komut satırından kolaylıkla başlatabilirsiniz: Dosya açmak için <code>brackets myFile.txt</code> veya projeler arasında geçiş yapmak için <code>brackets myFolder</code> komutunu kullanın. <br/><br/>{APP_NAME} uygulamasını komut satırından kullanma hakkında <a href='https://github.com/adobe/brackets/wiki/Command-Line-Arguments'>daha fazla bilgi edinin</a>.",

    "LANGUAGE_TITLE": "Dili Değiştir",
    "LANGUAGE_MESSAGE": "Dil:",
    "LANGUAGE_SUBMIT": "{APP_NAME} Yenile",
    "LANGUAGE_CANCEL": "İptal",
    "LANGUAGE_SYSTEM_DEFAULT": "Sistem Varsayılanı",

    // extensions/default/HealthData
    "HEALTH_DATA_NOTIFICATION": "Sistem Durumu Raporu Tercihleri",
    "HEALTH_FIRST_POPUP_TITLE": "{APP_NAME} Sistem Durumu Raporu",
    "HEALTH_DATA_DO_TRACK": "{APP_NAME} uygulamasını nasıl kullandığım ile ilgili anonim bilgileri paylaş",
    "HEALTH_DATA_NOTIFICATION_MESSAGE": "{APP_NAME} uygulamasını geliştirmek için, {APP_NAME} uygulamasını nasıl kullandığınız ile ilgili sınırlı, <strong>anonim</strong> istatistikleri düzenli olarak Adobe'ye gönderiyoruz. Bu bilgiler özelliklerin önceliklerinin belirlenmesine, hataların bulunmasına ve kullanımla ilgili sorunların belirlenmesine yardımcı oluyor.<br><br><strong>Yardım > Sistem Durumu Raporu</strong> menüsünden verilerinizi görebilir veya verilerinizi paylaşmamayı seçebilirsiniz.<br><br><a href='https://github.com/adobe/brackets/wiki/Health-Data'>{APP_NAME} Sistem Durumu Raporu hakkında daha fazla bilgi edinin</a>",
    "HEALTH_DATA_PREVIEW": "{APP_NAME} Sistem Durumu Raporu",
    "HEALTH_DATA_PREVIEW_INTRO": "<p>{APP_NAME} uygulamasını geliştirmek için, {APP_NAME} uygulamasını nasıl kullandığınız ile ilgili sınırlı, <strong>anonim</strong> istatistikleri düzenli olarak Adobe'ye gönderiyoruz. Bu bilgiler özelliklerin önceliklerinin belirlenmesine, hataların bulunmasına ve kullanımla ilgili sorunların belirlenmesine yardımcı oluyor. <a href='https://github.com/adobe/brackets/wiki/Health-Data'>{APP_NAME} Sistem Durumu Raporu</a> ve bu raporun gizliliğinizi koruyarak {APP_NAME} topluluğuna nasıl yardımcı olduğu konusunda daha fazla bilgi edinin.</p><p>Bu özellik <em>etkinleştirilirse</em> bir sonraki Sistem Durumu Raporu'nda gönderilecek verilerin önizlemesini aşağıda bulabilirsiniz.</p>",

    // extensions/default/InlineTimingFunctionEditor
    "INLINE_TIMING_EDITOR_TIME": "Saat",
    "INLINE_TIMING_EDITOR_PROGRESSION": "İlerleme",
    "BEZIER_EDITOR_INFO": "<kbd>↑</kbd><kbd>↓</kbd><kbd>←</kbd><kbd>→</kbd> Seçili noktayı taşı<br><kbd class='text'>Shift</kbd> On birim taşı<br><kbd class='text'>Sekme</kbd> Noktaları değiştir",
    "STEPS_EDITOR_INFO": "<kbd>↑</kbd><kbd>↓</kbd> Adımları artır veya azalt<br><kbd>←</kbd><kbd>→</kbd> “Başlangıç” veya “Bitiş”",
    "INLINE_TIMING_EDITOR_INVALID": "<code>{0}</code> eski değeri geçersiz olduğu için görüntülenen işlev <code>{1}</code> olarak değiştirildi. Belge ilk düzenleme sırasında güncellenecek.",

    // extensions/default/InlineColorEditor
    "COLOR_EDITOR_CURRENT_COLOR_SWATCH_TIP": "Geçerli Renk",
    "COLOR_EDITOR_ORIGINAL_COLOR_SWATCH_TIP": "Orijinal Renk",
    "COLOR_EDITOR_RGBA_BUTTON_TIP": "RGBa Formatı",
    "COLOR_EDITOR_HEX_BUTTON_TIP": "Onaltılık Format",
    "COLOR_EDITOR_HSLA_BUTTON_TIP": "HSLa Formatı",
    "COLOR_EDITOR_USED_COLOR_TIP_SINGULAR": "{0} ({1} kez kullanıldı)",
    "COLOR_EDITOR_USED_COLOR_TIP_PLURAL": "{0} ({1} kez kullanıldı)",

    // extensions/default/JavaScriptCodeHints
    "CMD_JUMPTO_DEFINITION": "Tanıma Atla",
    "CMD_SHOW_PARAMETER_HINT": "Parametre İpuçlarını Göster",
    "NO_ARGUMENTS": "<parametre yok>",
    "DETECTED_EXCLUSION_TITLE": "JavaScript Dosya Kesintisi Sorunu",
    "DETECTED_EXCLUSION_INFO": "{APP_NAME} <span class='dialog-filename'>{0}</span> dosyasını işlerken sorunlarla karşılaştı.<br><br>Bu dosya artık kod ipuçları, Tanıma Geç veya Hızlı Düzenleme için kullanılmayacak. Bu dosyayı yeniden etkinleştirmek için projenizde <code>.brackets.json</code> dosyasını açın ve <code>jscodehints.detectedExclusions</code> bölümünü düzenleyin.<br><br>Bu bir {APP_NAME} hatası olabilir. Bu dosyanın bir kopyasını paylaşabiliyorsanız burada belirtilen dosyaya bir bağlantıyla birlikte <a href='https://github.com/adobe/brackets/wiki/How-to-Report-an-Issue'>bir hata bildiriminde bulunun</a>.",

    // extensions/default/JSLint
    "JSLINT_NAME": "JSLint",

    // extensions/default/QuickView
    "CMD_ENABLE_QUICK_VIEW": "Üzerine Gelindiğinde Kısaca Göster",

    // extensions/default/RecentProjects
    "CMD_TOGGLE_RECENT_PROJECTS": "Son Kullanılan Projeler",

    // extensions/default/WebPlatformDocs
    "DOCS_MORE_LINK": "Daha Fazla Bilgi",

    // extensions/default/CodeFolding
    "COLLAPSE_ALL": "Tümünü Daralt",
    "EXPAND_ALL": "Tümünü Genişlet",
    "COLLAPSE_CURRENT": "Geçerli Olanı Daralt",
    "EXPAND_CURRENT": "Geçerli Öğeyi Genişlet",

    // extensions/default/NavigationAndHistory
    "RECENT_FILES_DLG_HEADER": "Son Dosyalar",
    "RECENT_FILES_DLG_CLEAR_BUTTON_LABEL": "Temizle",
    "RECENT_FILES_DLG_CLEAR_BUTTON_TITLE": "Çalışma Kümesi'nde olmayan dosyaları temizle",

    // Descriptions of core preferences
    "DESCRIPTION_CLOSE_BRACKETS": "Ayraçları, köşeli parantezleri ve parantezleri otomatik olarak kapatmak için doğru olarak ayarlayın",
    "DESCRIPTION_CLOSE_OTHERS_ABOVE": "Çalışma Dosyaları bağlam menüsünden \“Üstündeki Diğer Öğeleri Kapat\” seçeneğini kaldırmak için yanlış olarak ayarlayın",
    "DESCRIPTION_CLOSE_OTHERS_BELOW": "Çalışma Dosyaları bağlam menüsünden \“Altındaki Diğer Öğeleri Kapat\” seçeneğini kaldırmak için yanlış olarak ayarlayın",
    "DESCRIPTION_CLOSE_OTHERS": "Çalışma Dosyaları bağlam menüsünden \“Diğerlerini Kapat\” seçeneğini kaldırmak için yanlış olarak ayarlayın",
    "DESCRIPTION_CLOSE_TAGS": "Etiket kapatma seçeneklerini ayarlar",
    "DESCRIPTION_CLOSE_TAGS_DONT_CLOSE_TAGS": "Otomatik olarak kapatılmaması gereken bir dizi etiket",
    "DESCRIPTION_CLOSE_TAGS_WHEN_OPENING": "> açılış etiketi yazıldığında kapat",
    "DESCRIPTION_CLOSE_TAGS_WHEN_CLOSING": "/ kapanış etiketi yazıldığında kapat",
    "DESCRIPTION_CLOSE_TAGS_INDENT_TAGS": "Açıldığında boş bir satır içeren bir dizi etiket",
    "DESCRIPTION_CODE_FOLDING_ALWAY_USE_INDENT_FOLD": "Girinti düzeyi değiştiğinde daima daraltılabilir bölüm işaretçileri oluşturmak için doğru olarak ayarlayın",
    "DESCRIPTION_CODE_FOLDING_ENABLED": "Kod katlamayı etkinleştirmek için doğru olarak ayarlayın",
    "DESCRIPTION_CODE_FOLDING_HIDE_UNTIL_MOUSEOVER": "Bölüm daraltma işaretçilerini yalnızca fareyi sütun aralığının üzerine getirdiğinizde görünür yapmak için doğru olarak ayarlayın",
    "DESCRIPTION_CODE_FOLDING_MAX_FOLD_LEVEL": "Tümünü Daralt seçeneğinin uygulanacağı düzey sayısını sınırlar",
    "DESCRIPTION_CODE_FOLDING_MIN_FOLD_SIZE": "Daraltılabilir bir bölüm simgesi görününceye kadar minimum satır sayısı",
    "DESCRIPTION_CODE_FOLDING_SAVE_FOLD_STATES": "Bir dosya veya projeyi kapatıp yeniden açarsanız daraltılmış bölümlerin korunması için doğru olarak ayarlayın",
    "DESCRIPTION_CODE_FOLDING_MAKE_SELECTIONS_FOLDABLE": "Düzenleyicide seçili metin üzerinde kod katlamayı etkinleştirmek için doğru olarak ayarlayın",
    "DESCRIPTION_ATTR_HINTS": "HTML niteliği ipuçlarını etkinleştir/devre dışı bırak",
    "DESCRIPTION_CSS_PROP_HINTS": "CSS/LESS/SCSS özelliği ipuçlarını etkinleştir/devre dışı bırak",
    "DESCRIPTION_JS_HINTS": "JavaScript kod ipuçlarını etkinleştir/devre dışı bırak",
    "DESCRIPTION_JS_HINTS_TYPE_DETAILS": "JavaScript kod ipuçlarında veri türü ayrıntılarını etkinleştir/devre dışı bırak",
    "DESCRIPTION_PREF_HINTS": "Tercihler kod ipuçlarını etkinleştir/devre dışı bırak",
    "DESCRIPTION_SPECIAL_CHAR_HINTS": "HTML varlığı ipuçlarını etkinleştir/devre dışı bırak",
    "DESCRIPTION_SVG_HINTS": "SVG kod ipuçlarını etkinleştir/devre dışı bırak",
    "DESCRIPTION_HTML_TAG_HINTS": "HTML etiketi ipuçlarını etkinleştir/devre dışı bırak",
    "DESCRIPTION_URL_CODE_HINTS": "HTML ve CSS/LESS/SCSS içinde URL ipuçlarını etkinleştir/devre dışı bırak",
    "DESCRIPTION_DRAG_DROP_TEXT": "Sürükle ve Bırak işlevselliğini etkinleştir/devre dışı bırak",
    "DESCRIPTION_HEALTH_DATA_TRACKING": "Sistem Durumu Verilerini İzlemeyi Etkinleştir",
    "DESCRIPTION_HIGHLIGHT_MATCHES": "Belge genelinde eşleşen dizelerin otomatik vurgulanmasını etkinleştirir",
    "DESCRIPTION_HIGHLIGHT_MATCHES_SHOW_TOKEN": "İmlecin bulunduğu belirteç ile eşleşen tüm dizeleri vurgula (seçim yapılması gerekmez)",
    "DESCRIPTION_HIGHLIGHT_MATCHES_WORDS_ONLY": "Yalnızca seçim eksiksiz bir belirteç olduğunda vurgula",
    "DESCRIPTION_INSERT_HINT_ON_TAB": "Şu anda seçili olan kod ipucunu sekmeye eklemek için doğru olarak ayarlayın",
    "DESCRIPTION_NO_HINTS_ON_DOT": ". yazıldığında JS kod ipuçlarının otomatik olarak gösterilmesi için doğru olarak ayarlayın",
    "DESCRIPTION_JSLINT_OPTIONS": "JSLint için varsayılan seçeneklere sahip bir nesne",
    "DESCRIPTION_JSLINT_OPTIONS_ASS": "Atama ifadelerine izin vermek için doğru olarak ayarlayın",
    "DESCRIPTION_JSLINT_OPTIONS_BITWISE": "Bit işleçlerine izin vermek için doğru olarak ayarlayın",
    "DESCRIPTION_JSLINT_OPTIONS_BROWSER": "Standart tarayıcı genel ayarlarının önceden tanımlanması gerekiyorsa doğru olarak ayarlayın",
    "DESCRIPTION_JSLINT_OPTIONS_CLOSURE": "Google Closure deyimlerine izin vermek için doğru olarak ayarlayın",
    "DESCRIPTION_JSLINT_OPTIONS_CONTINUE": "\“Continue\” deyimlerine izin vermek için doğru olarak ayarlayın",
    "DESCRIPTION_JSLINT_OPTIONS_COUCH": "CouchDB genel ayarlarının önceden tanımlanması gerekiyorsa doğru olarak ayarlayın",
    "DESCRIPTION_JSLINT_OPTIONS_DEBUG": "Hata ayıklayıcı deyimlerine izin vermek için doğru olarak ayarlayın",
    "DESCRIPTION_JSLINT_OPTIONS_DEVEL": "Geliştirme sırasında kullanışlı olabilecek tarayıcı genel ayarlarının önceden tanımlanması gerekiyorsa doğru olarak ayarlayın",
    "DESCRIPTION_JSLINT_OPTIONS_EQEQ": "== ve != kullanımına izin vermek için doğru olarak ayarlayın",
    "DESCRIPTION_JSLINT_OPTIONS_ES6": "ES6 genel ayarlarının önceden tanımlanması gerekiyorsa doğru olarak ayarlayın",
    "DESCRIPTION_JSLINT_OPTIONS_EVIL": "eval kullanımına izin vermek için doğru olarak ayarlayın",
    "DESCRIPTION_JSLINT_OPTIONS_FORIN": "Filtre uygulanmamış \“for ... in\” kullanımına izin vermek için doğru olarak ayarlayın",
    "DESCRIPTION_JSLINT_OPTIONS_INDENT": "Belirli bir sekme genişliği ayarla",
    "DESCRIPTION_JSLINT_OPTIONS_MAXERR": "Bildirilen maksimum uyarı sayısı",
    "DESCRIPTION_JSLINT_OPTIONS_MAXLEN": "Bir satırdaki maksimum karakter sayısı",
    "DESCRIPTION_JSLINT_OPTIONS_NEWCAP": "Küçük harfli oluşturuculara izin vermek için doğru olarak ayarlayın",
    "DESCRIPTION_JSLINT_OPTIONS_NODE": "Node.js genel ayarlarının önceden tanımlanması gerekiyorsa doğru olarak ayarlayın",
    "DESCRIPTION_JSLINT_OPTIONS_NOMEN": "Tanımlayıcılarda tek başına alt çizgiye izin vermek için doğru olarak ayarlayın",
    "DESCRIPTION_JSLINT_OPTIONS_PASSFAIL": "İlk hatada durdurmak için doğru olarak ayarlayın",
    "DESCRIPTION_JSLINT_OPTIONS_PLUSPLUS": "++ ve -- kullanımına izin vermek için doğru olarak ayarlayın",
    "DESCRIPTION_JSLINT_OPTIONS_REGEXP": "RegExp içinde . ve [^...]. kullanımına izin vermek için doğru olarak ayarlayın",
    "DESCRIPTION_JSLINT_OPTIONS_RHINO": "Rhino genel ayarlarının önceden tanımlanması gerekiyorsa doğru olarak ayarlayın",
    "DESCRIPTION_JSLINT_OPTIONS_SLOPPY": "Eksik “katı kullan” pragmasına izin vermek için doğru olarak ayarlayın",
    "DESCRIPTION_JSLINT_OPTIONS_STUPID": "Engelleme (“...Sync”) yöntemleri kullanılabiliyorsa doğru olarak ayarlayın.",
    "DESCRIPTION_JSLINT_OPTIONS_SUB": "Yetersiz altsimge kullanımına izin vermek için doğru olarak ayarlayın",
    "DESCRIPTION_JSLINT_OPTIONS_TODO": "YAPILACAK yorumlarına izin vermek için doğru olarak ayarlayın",
    "DESCRIPTION_JSLINT_OPTIONS_UNPARAM": "Kullanılmayan parametrelere izin vermek için doğru olarak ayarlayın",
    "DESCRIPTION_JSLINT_OPTIONS_VARS": "İşlevde birden çok değişkene izin vermek için doğru olarak ayarlayın",
    "DESCRIPTION_JSLINT_OPTIONS_WHITE": "Boşluk kurallarını yok saymak için doğru olarak ayarlayın",
    "DESCRIPTION_LANGUAGE": "Dile özel ayarlar",
    "DESCRIPTION_LANGUAGE_FILE_EXTENSIONS": "Dosya uzantısından dil adına ek eşlemeler",
    "DESCRIPTION_LANGUAGE_FILE_NAMES": "Dosya adından dil adına ek eşlemeler",
    "DESCRIPTION_LINEWISE_COPY_CUT": "Seçim olmadan kopyala ve kes işlemleri gerçekleştirildiğinde imlecin bulunduğu satırların tamamı kopyalanır veya kesilir",
    "DESCRIPTION_LINTING_ENABLED": "Kod İnceleme'yi etkinleştirmek için doğru olarak ayarlayın",
    "DESCRIPTION_ASYNC_TIMEOUT": "Zaman uyumsuz Linting araçları zaman aşımına uğradıktan sonra milisaniye olarak geçen zaman",
    "DESCRIPTION_LINTING_PREFER": "İlk çalıştırılacak Linting araçları dizesi",
    "DESCRIPTION_LIVE_DEV_MULTIBROWSER": "Deneysel Canlı Önizleme'yi etkinleştirmek için doğru olarak ayarlayın",
    "DESCRIPTION_USE_PREFERED_ONLY": "Yalnızca linting.prefer içinde belirtilen sağlayıcıları çalıştırmak için doğru olarak ayarlayın",
    "DESCRIPTION_MAX_CODE_HINTS": "Aynı anda görüntülenen maksimum kod ipucu sayısı",
    "DESCRIPTION_PATH": "Yola özel ayarlar",
    "DESCRIPTION_PROXY": "Uzantının yüklenmesi için kullanılan proxy sunucunun URL'si",
    "DESCRIPTION_SCROLL_PAST_END": "Belgenin sonuna ulaştıktan sonra kaydırmaya devam edilebilmesi için doğru olarak ayarlayın",
    "DESCRIPTION_SHOW_CODE_HINTS": "Tüm kod ipuçlarını devre dışı bırakmak için yanlış olarak ayarlayın",
    "DESCRIPTION_SHOW_CURSOR_WHEN_SELECTING": "Metin seçimi yapıldığında yanıp sönen imleci görünür tutar",
    "DESCRIPTION_SHOW_LINE_NUMBERS": "Kodun solundaki bir “sütun aralığında” satır numaralarını göstermek için doğru olarak ayarlayın",
    "DESCRIPTION_SMART_INDENT": "Yeni bir blok oluştururken otomatik olarak girinti oluştur",
    "DESCRIPTION_SOFT_TABS": "Esnek sekme davranışını kapatmak için yanlış olarak ayarlayın",
    "DESCRIPTION_SORT_DIRECTORIES_FIRST": "Proje ağacında en başta dizinleri sıralamak için doğru olarak ayarlayın",
    "DESCRIPTION_SPACE_UNITS": "Boşluğa dayalı girinti için kullanılacak boşluk sayısı",
    "DESCRIPTION_STATIC_SERVER_PORT": "Dahili sunucunun Canlı Önizleme için kullanması gereken bağlantı noktası numarası",
    "DESCRIPTION_STYLE_ACTIVE_LINE": "İmlecin bulunduğu satırın arka plan rengini vurgulamak için doğru olarak ayarlayın",
    "DESCRIPTION_TAB_SIZE": "Sekmeler için görüntülenecek boşluk sayısı",
    "DESCRIPTION_USE_TAB_CHAR": "Boşluk yerine sekme kullanmak için doğru olarak ayarlayın",
    "DESCRIPTION_UPPERCASE_COLORS": "Satır İçi Renk Düzenleyici'de büyük harf onaltılı renkler oluşturmak için doğru olarak ayarlayın",
    "DESCRIPTION_WORD_WRAP": "Görüntü kapısı genişliğini aşan satırları sar",
    "DESCRIPTION_DETECTED_EXCLUSIONS": "Tern'in denetim dışında çalışmasına neden olduğu algılanmış dosyaların listesi",
    "DESCRIPTION_INFERENCE_TIMEOUT": "Tern'in dosyaları anlamaya çalışırken zaman aşımına uğramadan önce geçen süre",
    "DESCRIPTION_SHOW_ERRORS_IN_STATUS_BAR": "Durum çubuğunda hataları göstermek için doğru olarak ayarlayın",
    "DESCRIPTION_QUICK_VIEW_ENABLED": "Hızlı Görünüm'ü etkinleştirmek için doğru olarak ayarlayın",
    "DESCRIPTION_EXTENSION_LESS_IMAGE_PREVIEW": "Uzantıları olmayan URL'lerde görüntü önizlemelerini göstermek için doğru olarak ayarlayın",
    "DESCRIPTION_THEME": "{APP_NAME} teması seçin",
    "DESCRIPTION_USE_THEME_SCROLLBARS": "Özel kaydırma çubuklarına izin vermek için doğru olarak ayarlayın",
    "DESCRIPTION_LINTING_COLLAPSED": "Linting panelini daraltmak için doğru olarak ayarlayın",
    "DESCRIPTION_FONT_FAMILY": "Font ailesini değiştir",
    "DESCRIPTION_FONT_SIZE": "Font boyutunu değiştir, örn. 13 px",
    "DESCRIPTION_FIND_IN_FILES_NODE": "Düğüme dayalı aramayı etkinleştirmek için doğru olarak ayarlayın",
    "DESCRIPTION_FIND_IN_FILES_INSTANT": "Hızlı aramayı etkinleştirmek için doğru olarak ayarlayın",
    "DESCRIPTION_FONT_SMOOTHING": "Yalnızca Mac: Alt piksel kenar yumuşatmayı etkinleştirmek için \“alt piksel kenar yumuşatma\” veya gri tonlama kenar yumuşatma için \“kenar yumuşatma\” seçeneğini kullanın",
    "DESCRIPTION_OPEN_PREFS_IN_SPLIT_VIEW": "Bölünmüş görünümde açılış tercihleri dosyasını devre dışı bırakmak için yanlış olarak ayarlayın",
    "DESCRIPTION_OPEN_USER_PREFS_IN_SECOND_PANE": "Sol/üst bölmede kullanıcı tercihleri dosyasını açmak için yanlış olarak ayarlayın",
    "DESCRIPTION_MERGE_PANES_WHEN_LAST_FILE_CLOSED": "Bölmedeki son dosya bölme başlığındaki kapat düğmesi ile kapatıldıktan sonra bölmeleri daraltmak için doğru olarak ayarlayın",
    "DESCRIPTION_SHOW_PANE_HEADER_BUTTONS": "Kapat ve görünümü çevir düğmelerini başlıkta göstermek için açın/kapatın.",
    "DEFAULT_PREFERENCES_JSON_HEADER_COMMENT": "/*\n * Bu, {APP_NAME} tarafından desteklenen\n * tercihlerin yer aldığı salt okunur bir dosya.\n * Diğer bölmede açık olan \“brackets.json\” tercihler dosyanızı\n * değiştirmek için bu dosyayı referans olarak kullanın.\n * {APP_NAME} içindeki tercihleri kullanma hakkında\n * daha fazla bilgi için https://github.com/adobe/brackets/wiki/How-to-Use-Brackets#preferences\n * adresindeki web sayfasına başvurun/",
    "DEFAULT_PREFERENCES_JSON_DEFAULT": "Varsayılan",
    "DESCRIPTION_PURE_CODING_SURFACE": "Yalnızca kod modunu etkinleştirmek ve {APP_NAME} içindeki tüm diğer kullanıcı arabirimi öğelerini gizlemek için doğru olarak ayarlayın",
    "DESCRIPTION_INDENT_LINE_COMMENT": "Satır yorumlarında girintiyi etkinleştirmek için doğru olarak ayarlayın",
    "DESCRIPTION_RECENT_FILES_NAV": "Son kullanılan dosyalarda gezinmeyi etkinleştir/devre dışı bırak",
    "DESCRIPTION_PHP_HINTS": "php kod ipuçlarını etkinleştir/devre dışı bırak",
    "BROWSE_COMMAND_STRING": " Gözat...",
    "COLOR_PICKER_CMD_STRING": " Renk Seçici...",
    "CHOOSE_ANOTHER_CC_LIBARAY": "Kitaplığı Değiştir",
    "EXTRACT_INSERT_SELECTED": " Seçili Olanı Ekle",
    "DESCRIPTION_EMMET_PREFS": "Emmet Kodunu Etkinleştir/Devre Dışı Bırak",
    "IMAGE_NOT_FOUND_ERR": "Görüntü bulunamadı"
});
