/*
 * Copyright (c) 2012 - present Adobe Systems Incorporated. All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 */

define({

    /**
     * Errors
     */

    // General file io error strings
    "GENERIC_ERROR"                     : "(kļūda {0})",
    "NOT_FOUND_ERR"                     : "Datne/katalogs netika atrasts.",
    "NOT_READABLE_ERR"                  : "Nevar nolasīt datni/katalogu.",
    "EXCEEDS_MAX_FILE_SIZE"             : "{APP_NAME} nevar atvērt datnes, lielākas par {0} MB.",
    "NO_MODIFICATION_ALLOWED_ERR"       : "Izvēlētais katalogs nevar tikt pārveidots.",
    "NO_MODIFICATION_ALLOWED_ERR_FILE"  : "Jums nav atļaujas veikt izmaiņas.",
    "CONTENTS_MODIFIED_ERR"             : "Šī datne ir pārveidota ārpus {APP_NAME}.",
    "UNSUPPORTED_ENCODING_ERR"          : "{APP_NAME} šobrīd atbalsta tikai UTF-8 kodējuma teksta datnes.",
    "FILE_EXISTS_ERR"                   : "Datne vai katalogs jau eksistē.",
    "FILE"                              : "datne",
    "FILE_TITLE"                        : "Datne",
    "DIRECTORY"                         : "katalogs",
    "DIRECTORY_TITLE"                   : "Katalogs",
    "DIRECTORY_NAMES_LEDE"              : "Katalogu nosaukumi",
    "FILENAMES_LEDE"                    : "Datņu nosaukumi",
    "FILENAME"                          : "Datnes nosaukums",
    "DIRECTORY_NAME"                    : "Kataloga nosaukums",

    // Project error strings
    "ERROR_LOADING_PROJECT"             : "Kļūda, ielādējot projektu",
    "OPEN_DIALOG_ERROR"                 : "Radās kļūda, rādot datņu atvēršanas dialogu. (kļūda {0})",
    "REQUEST_NATIVE_FILE_SYSTEM_ERROR"  : "Radās kļūda, ielādējot katalogu <span class='dialog-filename'>{0}</span>. (error {1})",
    "READ_DIRECTORY_ENTRIES_ERROR"      : "Radās kļūda, nolasot kataloga saturu <span class='dialog-filename'>{0}</span>. (error {1})",

    // File open/save error string
    "ERROR_OPENING_FILE_TITLE"          : "Kļūda, verot datni",
    "ERROR_OPENING_FILE"                : "Radās kļūda, verot datni <span class='dialog-filename'>{0}</span>. {1}",
    "ERROR_OPENING_FILES"               : "Radās kļūda, verot šīs datnes:",
    "ERROR_RELOADING_FILE_TITLE"        : "Kļūda, pārlādējot izmaiņas no diska",
    "ERROR_RELOADING_FILE"              : "Radās kļūda, pārlādējot datni <span class='dialog-filename'>{0}</span>. {1}",
    "ERROR_SAVING_FILE_TITLE"           : "Kļūda, saglabājot datni",
    "ERROR_SAVING_FILE"                 : "Radās kļūda, saglabājot datni <span class='dialog-filename'>{0}</span>. {1}",
    "ERROR_RENAMING_FILE_TITLE"         : "Kļūda, pārdēvējot {0}",
    "ERROR_RENAMING_FILE"               : "Radās kļūda, pārdēvējot {2} <span class='dialog-filename'>{0}</span>. {1}",
    "ERROR_RENAMING_NOT_IN_PROJECT"     : "Datne vai katalogs nav daļa no pašlaik atvērtā projekta. Diemžēl šobrīd var pārdēvēt tikai projekta datnes.",
    "ERROR_DELETING_FILE_TITLE"         : "Kļūda, dzēšot {0}",
    "ERROR_DELETING_FILE"               : "Radās kļūda, dzēšot {2} <span class='dialog-filename'>{0}</span>. {1}",
    "INVALID_FILENAME_TITLE"            : "Nederīgs {0}",
    "INVALID_FILENAME_MESSAGE"          : "{0} nevar izmantot sistēmas rezervētos vārdus, kas beidzas ar punktu (.) vai izmantot šādus simbolus: <code class='emphasized'>{1}</code>",
    "ENTRY_WITH_SAME_NAME_EXISTS"       : "Jau eksistē datne vai katalogs ar nosaukumu <span class='dialog-filename'>{0}</span> .",
    "ERROR_CREATING_FILE_TITLE"         : "Kļūda, veidojot {0}",
    "ERROR_CREATING_FILE"               : "Radās kļūda, veidojot {0} <span class='dialog-filename'>{1}</span>. {2}",
    "ERROR_MIXED_DRAGDROP"              : "Nevar atvērt mapi, kamēr tiek atvērtas citas datnes.",

    // User key map error strings
    "ERROR_KEYMAP_TITLE"                : "Kļūda, lasot lietotāja atslēgu karti",
    "ERROR_KEYMAP_CORRUPT"              : "Atslēgu kartes datne nav derīga JSON datne. Datne tiks atvērta, lai Jūs varētu izlabot formātu.",
    "ERROR_LOADING_KEYMAP"              : "Atslēgu karte nav derīga UTF-8 kodējuma teksta datne un nevar tikt ielādēta",
    "ERROR_RESTRICTED_COMMANDS"         : "Nevar piešķirt saīsnes šīm komandām: {0}",
    "ERROR_RESTRICTED_SHORTCUTS"        : "Nevar piešķirt šīs saīsnes: {0}",
    "ERROR_MULTIPLE_SHORTCUTS"          : "Tiek piešķirtas vairākas saīsnes šīm komandām: {0}",
    "ERROR_DUPLICATE_SHORTCUTS"         : "Šīm saīsnēm ir vairākas piesaistes: {0}",
    "ERROR_INVALID_SHORTCUTS"           : "Šīs saīsnes nav derīgas: {0}",
    "ERROR_NONEXISTENT_COMMANDS"        : "Tiek piešķirtas saīsnes neeksistējošām komandām: {0}",

    // Application preferences corrupt error strings
    "ERROR_PREFS_CORRUPT_TITLE"         : "Kļūda, lasot iestatījumus",
    "ERROR_PREFS_CORRUPT"               : "Iestatījumu datne nav derīga JSON datne. Datne tiks atvērta, lai Jūs varētu izlabot formātu. Nepieciešams restartēt {APP_NAME}, lai izmaiņas stāstos spēkā.",
    "ERROR_PROJ_PREFS_CORRUPT"          : "Iestatījumu datne nav derīga JSON datne. Datne tiks atvērta, lai Jūs varētu izlabot formātu. Nepieciešams pārlādēt projektu, lai izmaiņas stāstos spēkā.",

    // Application error strings
    "ERROR_IN_BROWSER_TITLE"            : "Ups! {APP_NAME} vēl nedarbojas pārlūkā.",
    "ERROR_IN_BROWSER"                  : "{APP_NAME} ir būvēta HTML, bet šobrīd strādā kā darbvirsmas lietotne, tāpēc to var izmantot, lai rediģētu lokālās datnes. Lūdzu, izmantojiet lietotnes čaulu <b>github.com/adobe/brackets-shell</b> repozitorijā, lai palaistu {APP_NAME}.",

    // ProjectManager max files error string
    "ERROR_MAX_FILES_TITLE"             : "Kļūda, indeksējot datnes",
    "ERROR_MAX_FILES"                   : "Šis projekts ietver vairāk nekā 30000 datņu. Funkcijas, kas darbojas vairākās datnēs, var tikt atspējotas vai darboties tā, it kā projekts būtu tukšs. <a href='https://github.com/adobe/brackets/wiki/Large-Projects'> Lasīt vairāk par strādāšanu ar lieliem projektiem</a>.",

    // Live Preview error strings
    "ERROR_LAUNCHING_BROWSER_TITLE"     : "Kļūda, palaižot pārlūku",
    "ERROR_CANT_FIND_CHROME"            : "Pārlūks Google Chrome netika atrasts. Pārliecinieties, ka tas ir instalēts.",
    "ERROR_LAUNCHING_BROWSER"           : "Radās kļūda, palaižot pārlūku. (kļūda {0})",

    "LIVE_DEVELOPMENT_ERROR_TITLE"      : "Tiešā priekšskatījuma kļūda",
    "LIVE_DEVELOPMENT_RELAUNCH_TITLE"   : "Savienojas ar pārlūku",
    "LIVE_DEVELOPMENT_ERROR_MESSAGE"    : "Lai savienotos ar tiešo priekšskatījumu, nepieciešams pārlādēt Chrome ar iespējotu attālo atkļūdošanu.<br /><br />Vai vēlaties pārlādēt Chrome un iespējot attālo atkļūdošanu?<br /><br />",
    "LIVE_DEV_LOADING_ERROR_MESSAGE"    : "Neizdevās ielādēt tiešā priekšskatījuma lapu.",
    "LIVE_DEV_NEED_HTML_MESSAGE"        : "Atveriet HTML datni vai pārliecinieties, ka jūsu projektā ir datne index.html, lai palaistu tiešo priekšskatījumu.",
    "LIVE_DEV_NEED_BASEURL_MESSAGE"     : "Lai palaistu tiešo priekšskatījumu ar serverī importētu datni, nepieciešams norādīt šī projekta bāzes URL.",
    "LIVE_DEV_SERVER_NOT_READY_MESSAGE" : "Kļūda, startējot HTTP serveri tiešā priekšskatījuma datnēm. Lūdzu, mēģiniet vēlreiz. ",
    "LIVE_DEVELOPMENT_INFO_TITLE"       : "Laipni lūgts tiešajā priekšskatījumā!",
    "LIVE_DEVELOPMENT_INFO_MESSAGE"     : "Tiešais priekšskatījums savieno {APP_NAME} ar pārlūku. Tas palaiž HTML datnes priekšskatījumu pārlūkā, tad atjaunina priekšskatījumu, kad tiek rediģēts kods.<br /><br />Šajā agrīnajā {APP_NAME} versijā tiešais priekšskatījums darbojas tikai ar <strong>Google Chrome</strong> un atjauninās, kad tiek rediģētas <strong>CSS vai HTML datnes</strong>. Izmaiņas JavaScript datnēs tiek automātiski pārlādētas saglabājot.<br /><br />(Šis paziņojums paradīsies tikai vienreiz.)",
    "LIVE_DEVELOPMENT_TROUBLESHOOTING"  : "Sīkākai informācijai skatiet <a href='{0}' title='{0}'>Tiešā priekšskatījuma savienojuma kļūdu novēršana</a>.",

    "LIVE_DEV_STATUS_TIP_NOT_CONNECTED" : "Tiešais priekšskatījums",
    "LIVE_DEV_STATUS_TIP_PROGRESS1"     : "Tiešais priekšskatījums: savienojas\u2026",
    "LIVE_DEV_STATUS_TIP_PROGRESS2"     : "Tiešais priekšskatījums: inicializē\u2026",
    "LIVE_DEV_STATUS_TIP_CONNECTED"     : "Izslēgt tiešo priekšskatījumu",
    "LIVE_DEV_STATUS_TIP_OUT_OF_SYNC"   : "Tiešais priekšskatījums (saglabājiet datni, lai atsvaidzinātu)",
    "LIVE_DEV_STATUS_TIP_SYNC_ERROR"    : "Tiešais priekšskatījums (netiek atjaunināts sintakses kļūdas dēļ)",

    "LIVE_DEV_DETACHED_REPLACED_WITH_DEVTOOLS" : "Tiešais priekšskatījums tika atcelts, jo bija atvērti pārlūka izstrādātāja rīki",
    "LIVE_DEV_DETACHED_TARGET_CLOSED"          : "Tiešais priekšskatījums tika atcelts, jo lapa tika aizvērta pārlūkā",
    "LIVE_DEV_NAVIGATED_AWAY"                  : "Tiešais priekšskatījums tika atcelts, jo pārlūks pārvietojās uz lapu, kas nav daļa no šī projekta",
    "LIVE_DEV_CLOSED_UNKNOWN_REASON"           : "Tiešais priekšskatījums tika atcelts nezināma iemesla dēļ ({0})",

    "SAVE_CLOSE_TITLE"                  : "Saglabāt izmaiņas",
    "SAVE_CLOSE_MESSAGE"                : "Vai vēlaties saglabāt veiktās izmaiņas dokumentā <span class='dialog-filename'>{0}</span>?",
    "SAVE_CLOSE_MULTI_MESSAGE"          : "Vai vēlaties saglabāt izmaiņas šajās datnēs?",
    "EXT_MODIFIED_TITLE"                : "Ārējas izmaiņas",
    "CONFIRM_DELETE_TITLE"              : "Apstiprināt dzēšanu",
    "CONFIRM_FOLDER_DELETE"             : "Vai tiešām vēlaties izdzēst mapi <span class='dialog-filename'>{0}</span>?",
    "FILE_DELETED_TITLE"                : "Datne izdzēsta",
    "EXT_MODIFIED_WARNING"              : "<span class='dialog-filename'>{0}</span> ir pārveidots diskā ārpus {APP_NAME}.<br /><br />Vai vēlaties saglabāt datni un pārrakstīt šīs izmaiņas?",
    "EXT_MODIFIED_MESSAGE"              : "<span class='dialog-filename'>{0}</span> ir pārveidots diskā ārpus {APP_NAME}, bet tam ir arī nesaglabātas izmaiņas {APP_NAME}.<br /><br />Kuru versiju vēlaties paturēt?",
    "EXT_DELETED_MESSAGE"               : "<span class='dialog-filename'>{0}</span> ir pārveidots diskā ārpus {APP_NAME}, bet tam ir nesaglabātas izmaiņas {APP_NAME}.<br /><br />Vai vēlaties paturēt izmaiņas?",

    // Generic dialog/button labels
    "DONE"                              : "Darīts",
    "OK"                                : "Labi",
    "CANCEL"                            : "Atcelt",
    "DONT_SAVE"                         : "Nesaglabāt",
    "SAVE"                              : "Saglabāt",
    "SAVE_AS"                           : "Saglabāt kā\u2026",
    "SAVE_AND_OVERWRITE"                : "Pārrakstīt",
    "DELETE"                            : "Dzēst",
    "BUTTON_YES"                        : "Jā",
    "BUTTON_NO"                         : "Nē",

    // Find, Replace, Find in Files
    "FIND_MATCH_INDEX"                  : "{0} no {1}",
    "FIND_NO_RESULTS"                   : "Nav rezultātu",
    "FIND_QUERY_PLACEHOLDER"            : "Meklēt\u2026",
    "REPLACE_PLACEHOLDER"               : "Aizstāt ar\u2026",
    "BUTTON_REPLACE_ALL"                : "Grupēt\u2026",
    "BUTTON_REPLACE_ALL_IN_FILES"       : "Aizstāt\u2026",
    "BUTTON_REPLACE"                    : "Aizstāt",
    "BUTTON_NEXT"                       : "\u25B6",
    "BUTTON_PREV"                       : "\u25C0",
    "BUTTON_NEXT_HINT"                  : "Nākamā sakritība",
    "BUTTON_PREV_HINT"                  : "Iepriekšējā sakritība",
    "BUTTON_CASESENSITIVE_HINT"         : "Jāsakrīt reģistriem",
    "BUTTON_REGEXP_HINT"                : "Regulārā izteiksme",
    "REPLACE_WITHOUT_UNDO_WARNING_TITLE": "Aizstāt bez atcelšanas",
    "REPLACE_WITHOUT_UNDO_WARNING"      : "Tā kā jāizmaina vairāk nekā {0} datnes, {APP_NAME} pārveidos neatvērtas datnes uz diska.<br />Jūs nevarēsiet atcelt šajās datnēs veiktos aizvietojumus.",
    "BUTTON_REPLACE_WITHOUT_UNDO"       : "Aizstāt bez atcelšanas",

    "OPEN_FILE"                         : "Atvērt datni",
    "SAVE_FILE_AS"                      : "Saglabāt datni",
    "CHOOSE_FOLDER"                     : "Izvēlēties mapi",

    "RELEASE_NOTES"                     : "Informācija par laidienu",
    "NO_UPDATE_TITLE"                   : "Jums ir jaunākā versija!",
    "NO_UPDATE_MESSAGE"                 : "Jums ir jaunākā {APP_NAME} versija.",

    // Find and Replace
    "FIND_REPLACE_TITLE_LABEL"          : "Aizstāt",
    "FIND_REPLACE_TITLE_WITH"           : "ar",
    "FIND_TITLE_LABEL"                  : "Atrasts",
    "FIND_TITLE_SUMMARY"                : "&mdash; {0} {1} {2} iekš {3}",

    // Find in Files
    "FIND_NUM_FILES"                    : "{0} {1}",
    "FIND_IN_FILES_SCOPED"              : "iekš <span class='dialog-filename'>{0}</span>",
    "FIND_IN_FILES_NO_SCOPE"            : "projektā",
    "FIND_IN_FILES_ZERO_FILES"          : "Filtrs izslēdz visas datnes {0}",
    "FIND_IN_FILES_FILE"                : "datne",
    "FIND_IN_FILES_FILES"               : "datnes",
    "FIND_IN_FILES_MATCH"               : "sakritība",
    "FIND_IN_FILES_MATCHES"             : "sakritības",
    "FIND_IN_FILES_MORE_THAN"           : "Pāri ",
    "FIND_IN_FILES_PAGING"              : "{0}&mdash;{1}",
    "FIND_IN_FILES_FILE_PATH"           : "<span class='dialog-filename'>{0}</span> {2} <span class='dialog-path'>{1}</span>",
    "FIND_IN_FILES_EXPAND_COLLAPSE"     : "Spiediet Ctrl/Cmd, lai izvērstu/sakļautu visu",
    "FIND_IN_FILES_INDEXING"            : "Indeksēšana tūlītējai meklēšanai\u2026",
    "REPLACE_IN_FILES_ERRORS_TITLE"     : "Aizstāt kļūdas",
    "REPLACE_IN_FILES_ERRORS"           : "Šīs datnes netika pārveidotas, jo tās mainījās pēc meklēšanas vai nevar tikt rakstītas.",

    "ERROR_FETCHING_UPDATE_INFO_TITLE"  : "Kļūda, saņemot informāciju par atjauninājumiem",
    "ERROR_FETCHING_UPDATE_INFO_MSG"    : "Neizdevās iegūt informāciju no servera par jaunākajiem atjauninājumiem. Pārliecinieties, vai esat pieslēdzies internetam, un mēģiniet vēlreiz.",

    // File exclusion filters
    "NEW_FILE_FILTER"                   : "Jauna izslēgšanas kopa\u2026",
    "CLEAR_FILE_FILTER"                 : "Neizslēgt datnes",
    "NO_FILE_FILTER"                    : "Netika izslēgtas datnes",
    "EXCLUDE_FILE_FILTER"               : "Izslēgt {0}",
    "EDIT_FILE_FILTER"                  : "Rediģēt\u2026",
    "FILE_FILTER_DIALOG"                : "Rediģēt izslēgšanas kopu",
    "FILE_FILTER_INSTRUCTIONS"          : "Izslēgt datnes un mapes, kas sakrīt ar šīm virknēm / apakšvirknēm vai <a href='{0}' title='{0}'>aizstājējzīmēm</a>. Ievadiet katru virkni jaunā rindā.",
    "FILTER_NAME_PLACEHOLDER"           : "Nosaukt šo izslēgšanas kopu (nav obligāti)",
    "FILE_FILTER_CLIPPED_SUFFIX"        : "un {0} vairāk",
    "FILTER_COUNTING_FILES"             : "Skaita datnes\u2026",
    "FILTER_FILE_COUNT"                 : "Pieļauj {0} no {1} datnēm {2} ",
    "FILTER_FILE_COUNT_ALL"             : "Pieļauj visas {0} datnes {1}",

    // Quick Edit
    "ERROR_QUICK_EDIT_PROVIDER_NOT_FOUND"   : "Pašreizējai kursora pozīcijai nav pieejama ātrā rediģēšana",
    "ERROR_CSSQUICKEDIT_BETWEENCLASSES"     : "CSS ātrā rediģēšana: novietojiet kursoru uz vienas klases nosaukuma",
    "ERROR_CSSQUICKEDIT_CLASSNOTFOUND"      : "CSS ātrā rediģēšana: nepilnīgs klases atribūts",
    "ERROR_CSSQUICKEDIT_IDNOTFOUND"         : "CSS ātrā rediģēšana: nepilnīgs id atribūts",
    "ERROR_CSSQUICKEDIT_UNSUPPORTEDATTR"    : "CSS ātrā rediģēšana: novietojiet kursuru tagā, klasē vai id",
    "ERROR_TIMINGQUICKEDIT_INVALIDSYNTAX"   : "CSS laika funkcijas ātrā rediģēšana: nederīga sintakse",
    "ERROR_JSQUICKEDIT_FUNCTIONNOTFOUND"    : "JS ātrā rediģēšana: novietojiet kursoru funkcijas nosaukumā",

    // Quick Docs
    "ERROR_QUICK_DOCS_PROVIDER_NOT_FOUND"   : "Pašreizējai kursora pozīcijai nav pieejams neviens ātrais dokuments",

    /**
     * ProjectManager
     */
    "PROJECT_LOADING"   : "Ielādē\u2026",
    "UNTITLED"          : "Nenosaukts",
    "WORKING_FILES"     : "Darba datnes",

    /**
     * MainViewManager
     */
    "TOP"               : "Augša",
    "BOTTOM"            : "Apakša",
    "LEFT"              : "Pa kreisi",
    "RIGHT"             : "Pa labi",

    "CMD_SPLITVIEW_NONE"        : "Netiek sadalīts",
    "CMD_SPLITVIEW_VERTICAL"    : "Vertikālā sadalīšana",
    "CMD_SPLITVIEW_HORIZONTAL"  : "Horizontālā sadalīšana",
    "SPLITVIEW_MENU_TOOLTIP"    : "Sadalīt redaktoru vertikāli vai horizontāli",
    "GEAR_MENU_TOOLTIP"         : "Konfigurēt darba kopu",

    "SPLITVIEW_INFO_TITLE"              : "Jau atvērts",
    "SPLITVIEW_MULTIPANE_WARNING"       : "Datne jau ir atvērta citā rūtī. {APP_NAME} drīz atbalstīs datnes atvēršanu vairāk nekā vienā rūtī. Līdz tam datne tiks rādīta rūtī, kurā tā jau ir atvērta.<br /<br />(Šis paziņojums paradīsies tikai vienreiz.)",

    /**
     * Keyboard modifiers and special key names
     */
    "KEYBOARD_CTRL"         : "Vadības taustiņš \"Ctrl\"",
    "KEYBOARD_SHIFT"        : "Pārslēgšanas taustiņš \"Shift\"",
    "KEYBOARD_SPACE"        : "Atstarpēšanas taustiņš \"Space\"",
    "KEYBOARD_PAGE_UP"      : "Augšupšķiršanas taustiņš \"Page Up\"",
    "KEYBOARD_PAGE_DOWN"    : "Lejupšķiršanas taustiņš \"Page Down\"",
    "KEYBOARD_HOME"         : "Sākumvietas taustiņš \"Home\"",
    "KEYBOARD_END"          : "Beigvietas taustiņš \"End\"",
    "KEYBOARD_INSERT"       : "Iespraušanas taustiņš \"Insert\"",
    "KEYBOARD_DELETE"       : "Dzēšanas taustiņš \"Delete\"",

    /**
     * StatusBar strings
     */
    "STATUSBAR_CURSOR_POSITION"             : "Rinda {0} kolonna {1}",
    "STATUSBAR_SELECTION_CH_SINGULAR"       : " \u2014 izvēlēta {0} kolonna",
    "STATUSBAR_SELECTION_CH_PLURAL"         : " \u2014 izvēlētas {0} kolonnas",
    "STATUSBAR_SELECTION_LINE_SINGULAR"     : " \u2014 izvēlēta {0} rinda",
    "STATUSBAR_SELECTION_LINE_PLURAL"       : " \u2014 izvēlētas {0} rindas",
    "STATUSBAR_SELECTION_MULTIPLE"          : " \u2014 {0} izvēles",
    "STATUSBAR_INDENT_TOOLTIP_SPACES"       : "Nospiediet, lai pārslēgtu atkāpes uz atstarpēm",
    "STATUSBAR_INDENT_TOOLTIP_TABS"         : "Nospiediet, lai pārslēgtu atkāpes uz tabulāciju",
    "STATUSBAR_INDENT_SIZE_TOOLTIP_SPACES"  : "Nospiediet, lai mainītu atstarpju skaitu, izmantojot atkāpes",
    "STATUSBAR_INDENT_SIZE_TOOLTIP_TABS"    : "Nospiediet, lai mainītu tabulācijas simbolu platumu",
    "STATUSBAR_SPACES"                      : "Atstarpes:",
    "STATUSBAR_TAB_SIZE"                    : "Tabulācijas izmērs:",
    "STATUSBAR_LINE_COUNT_SINGULAR"         : "\u2014 {0} rinda",
    "STATUSBAR_LINE_COUNT_PLURAL"           : "\u2014 {0} rindas",
    "STATUSBAR_USER_EXTENSIONS_DISABLED"    : "Paplašinājumi atspējoti",
    "STATUSBAR_INSERT"                      : "Iespraušana (INS)",
    "STATUSBAR_OVERWRITE"                   : "Pārraksts (OVR)",
    "STATUSBAR_INSOVR_TOOLTIP"              : "Nospiediet, lai pārslēgtu kursoru starp iespraušanas (INS) un pārraksta (OVR) režīmu",
    "STATUSBAR_LANG_TOOLTIP"                : "Nospiediet, lai mainītu datnes tipu",
    "STATUSBAR_CODE_INSPECTION_TOOLTIP"     : "{0}. Nospiediet, lai rādītu/slēptu atskaites paneli.",
    "STATUSBAR_DEFAULT_LANG"                : "(noklusējums)",
    "STATUSBAR_SET_DEFAULT_LANG"            : "Iestatīt kā noklusējumu .{0} datnēm",

    // CodeInspection: errors/warnings
    "ERRORS_PANEL_TITLE_MULTIPLE"           : "{0} problēmas",
    "SINGLE_ERROR"                          : "1 {0} problēma",
    "MULTIPLE_ERRORS"                       : "{1} {0} problēmas",
    "NO_ERRORS"                             : "Netika atrasta neviena {0} problēma - labi pastrādāts!",
    "NO_ERRORS_MULTIPLE_PROVIDER"           : "Netika atrasta neviena problēma - labi pastrādāts!",
    "LINT_DISABLED"                         : "Sintakses pārbaudīšana ir atspējota",
    "NO_LINT_AVAILABLE"                     : "Nav pieejama sintakses pārbaudīšana priekš {0}",
    "NOTHING_TO_LINT"                       : "Nav ko pārbaudīt",
    "LINTER_TIMED_OUT"                      : "{0} iestājās taimauts pēc {1} ms ilgas gaidīšanas",
    "LINTER_FAILED"                         : "{0} beidzās ar kļūdu: {1}",

    /**
     * Command Name Constants
     */

    // File menu commands
    "FILE_MENU"                           : "Datne",
    "CMD_FILE_NEW_UNTITLED"               : "Jauna",
    "CMD_FILE_NEW"                        : "Jauna datne",
    "CMD_FILE_NEW_FOLDER"                 : "Jauna mape",
    "CMD_FILE_OPEN"                       : "Atvērt\u2026",
    "CMD_ADD_TO_WORKING_SET"              : "Atvērt darba kopā",
    "CMD_OPEN_DROPPED_FILES"              : "Atvērt nomestās datnes",
    "CMD_OPEN_FOLDER"                     : "Atvērt mapi\u2026",
    "CMD_FILE_CLOSE"                      : "Aizvērt",
    "CMD_FILE_CLOSE_ALL"                  : "Aizvērt visas",
    "CMD_FILE_CLOSE_LIST"                 : "Aizvērt sarakstu",
    "CMD_FILE_CLOSE_OTHERS"               : "Aizvērt citas",
    "CMD_FILE_CLOSE_ABOVE"                : "Aizvērt visas augstāk",
    "CMD_FILE_CLOSE_BELOW"                : "Aizvērt visas zemāk",
    "CMD_FILE_SAVE"                       : "Saglabāt",
    "CMD_FILE_SAVE_ALL"                   : "Saglabāt visas",
    "CMD_FILE_SAVE_AS"                    : "Saglabāt kā\u2026",
    "CMD_LIVE_FILE_PREVIEW"               : "Tiešais priekšskatījums",
    "CMD_TOGGLE_LIVE_PREVIEW_MB_MODE"     : "Iespējot eksperimentālo tiešo priekšskatījumu",
    "CMD_RELOAD_LIVE_PREVIEW"             : "Piespiedu tiešā priekšskatījuma pārlādēšana",
    "CMD_PROJECT_SETTINGS"                : "Projekta iestatījumi\u2026",
    "CMD_FILE_RENAME"                     : "Pārdēvēt",
    "CMD_FILE_DELETE"                     : "Dzēst",
    "CMD_INSTALL_EXTENSION"               : "Instalēt paplašinājumu\u2026",
    "CMD_EXTENSION_MANAGER"               : "Paplašinājumu pārvaldnieks\u2026",
    "CMD_FILE_REFRESH"                    : "Atsvaidzināt datņu koku",
    "CMD_QUIT"                            : "Beigt",
    // Used in native File menu on Windows
    "CMD_EXIT"                            : "Iziet",

    // Edit menu commands
    "EDIT_MENU"                           : "Rediģēt",
    "CMD_UNDO"                            : "Atsaukt",
    "CMD_REDO"                            : "Atcelt atsaukšanu",
    "CMD_CUT"                             : "Izgriezt",
    "CMD_COPY"                            : "Kopēt",
    "CMD_PASTE"                           : "Ielīmēt",
    "CMD_SELECT_ALL"                      : "Izvēlēties visu",
    "CMD_SELECT_LINE"                     : "Izvēlēties rindu",
    "CMD_SPLIT_SEL_INTO_LINES"            : "Sadalīt izvēlēto rindās",
    "CMD_ADD_CUR_TO_NEXT_LINE"            : "Pievienot kursoru nākamajai rindai",
    "CMD_ADD_CUR_TO_PREV_LINE"            : "Pievienot kursoru iepriekšējai rindai",
    "CMD_INDENT"                          : "Atkāpe",
    "CMD_UNINDENT"                        : "Nav atkāpes",
    "CMD_DUPLICATE"                       : "Dublēt",
    "CMD_DELETE_LINES"                    : "Dzēst rindu",
    "CMD_COMMENT"                         : "Rādīt/slēpt rindas komentāru",
    "CMD_BLOCK_COMMENT"                   : "Rādīt/slēpt bloka komentāru",
    "CMD_LINE_UP"                         : "Pārvietot rindu uz augšu",
    "CMD_LINE_DOWN"                       : "Pārvietot rindu uz leju",
    "CMD_OPEN_LINE_ABOVE"                 : "Atvērt augšējo rindu",
    "CMD_OPEN_LINE_BELOW"                 : "Atvērt apakšējo rindu",
    "CMD_TOGGLE_CLOSE_BRACKETS"           : "Automātiski aizvērt figūriekavas",
    "CMD_SHOW_CODE_HINTS"                 : "Rādīt koda ieteikumus",

    // Search menu commands
    "FIND_MENU"                           : "Meklēt",
    "CMD_FIND"                            : "Meklēt",
    "CMD_FIND_NEXT"                       : "Meklēt nākamo",
    "CMD_FIND_PREVIOUS"                   : "Meklēt iepriekšējo",
    "CMD_FIND_ALL_AND_SELECT"             : "Meklēt visu un izvēlēties",
    "CMD_ADD_NEXT_MATCH"                  : "Pievienot nākamo sakritību izvēlētajam",
    "CMD_SKIP_CURRENT_MATCH"              : "Izlaist un pievienot nākamo sakritību",
    "CMD_FIND_IN_FILES"                   : "Meklēt datnēs",
    "CMD_FIND_IN_SUBTREE"                 : "Meklēt\u2026 ",
    "CMD_REPLACE"                         : "Aizstāt",
    "CMD_REPLACE_IN_FILES"                : "Aizstāt datnēs",
    "CMD_REPLACE_IN_SUBTREE"              : "Aizstāt\u2026",

    // View menu commands
    "VIEW_MENU"                           : "Skats",
    "CMD_HIDE_SIDEBAR"                    : "Slēpt sānjoslu",
    "CMD_SHOW_SIDEBAR"                    : "Rādīt sānjoslu",
    "CMD_TOGGLE_SIDEBAR"                  : "Rādīt/slēpt sānjoslu",
    "CMD_TOGGLE_PANELS"                   : "Rādīt/slēpt paneļus",
    "CMD_TOGGLE_PURE_CODE"                : "Rādīt/slēpt palīgjoslas",
    "CMD_INCREASE_FONT_SIZE"              : "Palielināt fonta lielumu",
    "CMD_DECREASE_FONT_SIZE"              : "Samazināt fonta lielumu",
    "CMD_RESTORE_FONT_SIZE"               : "Atjaunot fonta lielumu",
    "CMD_SCROLL_LINE_UP"                  : "Ritināt rindu augstāk",
    "CMD_SCROLL_LINE_DOWN"                : "Ritināt rindu zemāk",
    "CMD_TOGGLE_LINE_NUMBERS"             : "Rindu numuri",
    "CMD_TOGGLE_ACTIVE_LINE"              : "Izcelt aktīvo rindu",
    "CMD_TOGGLE_WORD_WRAP"                : "Aplaušana",
    "CMD_LIVE_HIGHLIGHT"                  : "Tiešā priekšskatījuma izcelšana",
    "CMD_VIEW_TOGGLE_INSPECTION"          : "Pārbaudīt sintaksi datnēs, tās saglabājot",
    "CMD_WORKINGSET_SORT_BY_ADDED"        : "Kārtot pēc pievienošanas datuma",
    "CMD_WORKINGSET_SORT_BY_NAME"         : "Kārtot pēc nosaukuma",
    "CMD_WORKINGSET_SORT_BY_TYPE"         : "Kārtot pēc tipa",
    "CMD_WORKING_SORT_TOGGLE_AUTO"        : "Automātiskā kārtošana",
    "CMD_THEMES"                          : "Dizains\u2026",

    // Navigate menu commands
    "NAVIGATE_MENU"                       : "Pārvietoties",
    "CMD_QUICK_OPEN"                      : "Ātrā atvēršana",
    "CMD_GOTO_LINE"                       : "Iet uz rindu",
    "CMD_GOTO_DEFINITION"                 : "Ātrā definīcijas meklēšana",
    "CMD_GOTO_FIRST_PROBLEM"              : "Iet uz pirmo problēmu",
    "CMD_TOGGLE_QUICK_EDIT"               : "Ātrā rediģēšana",
    "CMD_TOGGLE_QUICK_DOCS"               : "Ātrie dokumenti",
    "CMD_QUICK_EDIT_PREV_MATCH"           : "Iepriekšējā sakritība",
    "CMD_QUICK_EDIT_NEXT_MATCH"           : "Nākamā sakritība",
    "CMD_CSS_QUICK_EDIT_NEW_RULE"         : "Jauna kārtula",
    "CMD_NEXT_DOC"                        : "Nākamais dokuments",
    "CMD_PREV_DOC"                        : "Iepriekšējais dokuments",
    "CMD_NEXT_DOC_LIST_ORDER"             : "Nākamais dokuments sarakstā",
    "CMD_PREV_DOC_LIST_ORDER"             : "Iepriekšējais dokuments sarakstā",
    "CMD_SHOW_IN_TREE"                    : "Parādīt datņu kokā",
    "CMD_SHOW_IN_EXPLORER"                : "Parādīt pārlūkā",
    "CMD_SHOW_IN_FINDER"                  : "Parādīt meklētājā",
    "CMD_SHOW_IN_OS"                      : "Parādīt operētājsistēmā",

    // Help menu commands
    "HELP_MENU"                           : "Palīdzība",
    "CMD_CHECK_FOR_UPDATE"                : "Pārbaudīt atjauninājumus",
    "CMD_HOW_TO_USE_BRACKETS"             : "Kā lietot {APP_NAME}",
    "CMD_SUPPORT"                         : "{APP_NAME} palīdzība",
    "CMD_SUGGEST"                         : "Ieteikt funkciju",
    "CMD_RELEASE_NOTES"                   : "Informācija par laidienu",
    "CMD_GET_INVOLVED"                    : "Iesaistīties",
    "CMD_SHOW_EXTENSIONS_FOLDER"          : "Parādīt paplašinājumu mapi",
    "CMD_HEALTH_DATA_STATISTICS"          : "Veselības atskaite",
    "CMD_HOMEPAGE"                        : "{APP_TITLE} mājas lapa",
    "CMD_TWITTER"                         : "{TWITTER_NAME} tīmekļa vietnē \"Twitter\"",
    "CMD_ABOUT"                           : "Par {APP_TITLE}",
    "CMD_OPEN_PREFERENCES"                : "Atvērt iestatījumu datni",
    "CMD_OPEN_KEYMAP"                     : "Atvērt lietotāja atslēgu karti",

    // Strings for main-view.html
    "EXPERIMENTAL_BUILD"                   : "eksperimentāls būvējums",
    "RELEASE_BUILD"                        : "būvējums",
    "DEVELOPMENT_BUILD"                    : "izstrādes būvējums",
    "RELOAD_FROM_DISK"                     : "Pārlādēt no diska",
    "KEEP_CHANGES_IN_EDITOR"               : "Saglabāt izmaiņas redaktorā",
    "CLOSE_DONT_SAVE"                      : "Aizvērt (nesaglabāt)",
    "RELAUNCH_CHROME"                      : "Restartēt Chrome",
    "ABOUT"                                : "Par",
    "CLOSE"                                : "Aizvērt",
    "ABOUT_TEXT_LINE1"                     : "Laidiena versija {VERSION_MAJOR}.{VERSION_MINOR} {BUILD_TYPE} {VERSION}",
    "ABOUT_TEXT_BUILD_TIMESTAMP"           : "būvējuma laikspiedols:",
    "ABOUT_TEXT_LINE3"                     : "Paziņojumi, noteikumi un nosacījumi, kas attiecas uz trešo pušu programmatūru, atrodas <a href='{ADOBE_THIRD_PARTY}'>{ADOBE_THIRD_PARTY}</a> un šeit iekļauti ar atsauci.",
    "ABOUT_TEXT_LINE4"                     : "Dokumentācija un avots <a href='https://github.com/adobe/brackets/'>https://github.com/adobe/brackets/</a>",
    "ABOUT_TEXT_LINE5"                     : "Izveidots ar \u2764 un JavaScript, autors:",
    "ABOUT_TEXT_LINE6"                     : "Daudz cilvēku (bet mums šobrīd ir grūtības ielādēt šos datus).",
    "ABOUT_TEXT_WEB_PLATFORM_DOCS"         : "Tīmekļa platformas dokumenti un tīmekļa platformas grafiskais logo ir licencēti saskaņā ar \"Creative Commons\" licenci <a href='{WEB_PLATFORM_DOCS_LICENSE}'>CC-BY 3.0 Unported</a>.",
    "UPDATE_NOTIFICATION_TOOLTIP"          : "{APP_NAME} ir pieejams jauns būvējums! Spiediet šeit, lai saņemtu sīkāku informāciju.",
    "UPDATE_AVAILABLE_TITLE"               : "Pieejams atjauninājums",
    "UPDATE_MESSAGE"                       : "{APP_NAME} ir pieejams jauns būvējums. Dažas no jaunajām funkcijām:",
    "GET_IT_NOW"                           : "Iegūt to tagad!",
    "PROJECT_SETTINGS_TITLE"               : "Projekta iestatījumi priekš: {0}",
    "PROJECT_SETTING_BASE_URL"             : "Tiešā priekšskatījuma bāzes URL",
    "PROJECT_SETTING_BASE_URL_HINT"        : "Lai izmantotu lokālo serveri, ievadiet URL, kā, piemēram, http://localhost:8000/",
    "BASEURL_ERROR_INVALID_PROTOCOL"       : "Tiešais priekšskatījums neatbalsta protokolu {0} &mdash;lūdzu, izmantojiet http: vai https: .",
    "BASEURL_ERROR_SEARCH_DISALLOWED"      : "Bāzes URL nevar ietvert tādus meklēšanas parametrus kā \"{0}\".",
    "BASEURL_ERROR_HASH_DISALLOWED"        : "Bāzes URL nevar ietver jaucējkodu kā \"{0}\".",
    "BASEURL_ERROR_INVALID_CHAR"           : "Speciālajiem simboliem kā '{0}' jābūt %-kodētiem.",
    "BASEURL_ERROR_UNKNOWN_ERROR"          : "Nezināma kļūda, parsējot bāzes URL",

    // Strings for Pane.js
    "EMPTY_VIEW_HEADER"                    : "<em>Atvērt datni, kamēr fokuss ir uz šo rūti</em>",
    "FLIPVIEW_BTN_TOOLTIP"                 : "Pārnest šo skatu uz rūti {0}",

    // Strings for themes-settings.html and themes-general.html
    "CURRENT_THEME"                        : "Pašreizējais dizains",
    "USE_THEME_SCROLLBARS"                 : "Lietot dizaina ritjoslas",
    "FONT_SIZE"                            : "Fonta lielums",
    "FONT_FAMILY"                          : "Fontu saime",
    "THEMES_SETTINGS"                      : "Dizaina iestatījumi",

    // CSS Quick Edit
    "BUTTON_NEW_RULE"                      : "Jauna kārtula",

    // Extension Management strings
    "INSTALL"                              : "Instalēt",
    "UPDATE"                               : "Atjaunināt",
    "REMOVE"                               : "Noņemt",
    "DISABLE"                              : "Atspējot",
    "ENABLE"                               : "Iespējot",
    "OVERWRITE"                            : "Pārrakstīt",
    "CANT_REMOVE_DEV"                      : "Paplašinājumi mapē \"dev\" ir jādzēš manuāli.",
    "CANT_UPDATE"                          : "Atjauninājums nesader ar šo {APP_NAME} versiju.",
    "CANT_UPDATE_DEV"                      : "Paplašinājumi mapē \"dev\" nevar tikt atjaunoti automātiski.",
    "INSTALL_EXTENSION_TITLE"              : "Instalēt paplašinājumu",
    "UPDATE_EXTENSION_TITLE"               : "Atjaunināt paplašinājumu",
    "INSTALL_EXTENSION_LABEL"              : "Paplašinājuma URL",
    "INSTALL_EXTENSION_HINT"               : "Paplašinājuma zip datnes URL vai GitHub repozitorijs",
    "INSTALLING_FROM"                      : "Instalē paplašinājumu no {0}\u2026",
    "INSTALL_SUCCEEDED"                    : "Instalēšana veiksmīga!",
    "INSTALL_FAILED"                       : "Instalēšana neveiksmīga.",
    "CANCELING_INSTALL"                    : "Atceļ \u2026",
    "CANCELING_HUNG"                       : "Instalēšanas atcelšana aizņem daudz laika. Var būt radusies iekšēja kļūda.",
    "INSTALL_CANCELED"                     : "Instalēšana atcelta.",
    "VIEW_COMPLETE_DESCRIPTION"            : "Skatīt pilnīgu aprakstu",
    "VIEW_TRUNCATED_DESCRIPTION"           : "Skatīt saīsinātu aprakstu",
    // These must match the error codes in ExtensionsDomain.Errors.* :
    "INVALID_ZIP_FILE"                     : "Lejupielādētais saturs nav derīga zip datne.",
    "INVALID_PACKAGE_JSON"                 : "Datne package.json nav derīga (kļūda: {0}).",
    "MISSING_PACKAGE_NAME"                 : "Datnē package.json nav norādīts pakotnes nosaukums.",
    "BAD_PACKAGE_NAME"                     : "{0} ir nederīgs pakotnes nosaukums.",
    "MISSING_PACKAGE_VERSION"              : "Datnē package.json nav norādīta pakotnes versija.",
    "INVALID_VERSION_NUMBER"               : "Pakotnes versijas numurs ({0}) ir nederīgs.",
    "INVALID_BRACKETS_VERSION"             : "{APP_NAME} saderības virkne ({0}) ir nederīga.",
    "DISALLOWED_WORDS"                     : "Laukā {0} nav atļauti vārdi ({1}).",
    "API_NOT_COMPATIBLE"                   : "Paplašinājums nav saderīgs ar šo {APP_NAME} versiju. Tas ir instalēts atspējoto paplašinājumu mapē.",
    "MISSING_MAIN"                         : "Pakotnē nav datnes main.js.",
    "EXTENSION_ALREADY_INSTALLED"          : "Šīs pakotnes instalēšana pārrakstīs iepriekš instalētu paplašinājumu. Pārrakstīt veco paplašinājumu?",
    "EXTENSION_SAME_VERSION"               : "Šai pakotnei ir tāda pati versija kā jau pašreiz instalētajai. Pārrakstīt esošo instalāciju?",
    "EXTENSION_OLDER_VERSION"              : "Pakotnes versija ir {0}, kas ir vecāka par pašreiz instalēto ({1}). Pārrakstīt esošo instalāciju?",
    "DOWNLOAD_ID_IN_USE"                   : "Iekšēja kļūda: lejupielādes ID jau tiek lietots.",
    "NO_SERVER_RESPONSE"                   : "Nevar savienoties ar serveri.",
    "BAD_HTTP_STATUS"                      : "Datne netika atrasta serverī (HTTP {0}).",
    "CANNOT_WRITE_TEMP"                    : "Neizdevās saglabāt lejupielādi pagaidu datnē.",
    "ERROR_LOADING"                        : "Uzsākot darbību, paplašinājums sadūrās ar kļūdu.",
    "MALFORMED_URL"                        : "URL nav derīgs. Pārliecinieties, vai ievadījāt to pareizi.",
    "UNSUPPORTED_PROTOCOL"                 : "URL jābūt http vai https formātā.",
    "UNKNOWN_ERROR"                        : "Nezināma iekšējā kļūda.",
    // For NOT_FOUND_ERR, see generic strings above
    "EXTENSION_MANAGER_TITLE"              : "Paplašinājumu pārvaldnieks",
    "EXTENSION_MANAGER_ERROR_LOAD"         : "Neizdevās piekļūt paplašinājumu reģistram. Lūdzu, mēģiniet vēlreiz.",
    "INSTALL_EXTENSION_DRAG"               : "Ievelciet šeit .zip vai",
    "INSTALL_EXTENSION_DROP"               : "Nometiet .zip, lai instalētu",
    "INSTALL_EXTENSION_DROP_ERROR"         : "Instalēšana/atjaunināšana pārtraukta šādu kļūdu dēļ:",
    "INSTALL_FROM_URL"                     : "Instalēt no URL\u2026",
    "INSTALL_EXTENSION_VALIDATING"         : "Validē\u2026",
    "EXTENSION_AUTHOR"                     : "Autors",
    "EXTENSION_DATE"                       : "Datums",
    "EXTENSION_INCOMPATIBLE_NEWER"         : "Šim paplašinājumam nepieciešama jaunāka {APP_NAME} versija.",
    "EXTENSION_INCOMPATIBLE_OLDER"         : "Pašlaik šis paplašinājums darbojas tikai ar vecākām {APP_NAME} versijām.",
    "EXTENSION_LATEST_INCOMPATIBLE_NEWER"  : "Šai paplašinājuma versijai {0} nepieciešama jaunāka {APP_NAME} versija. Bet jūs varat instalēt agrāko versiju {1}. ",
    "EXTENSION_LATEST_INCOMPATIBLE_OLDER"  : "Šī paplašinājuma versija {0} darbojas tikai ar vecākām {APP_NAME} versijām. Bet jūs varat instalēt agrāko versiju {1}.",
    "EXTENSION_NO_DESCRIPTION"             : "Nav apraksta",
    "EXTENSION_MORE_INFO"                  : "Vairāk informācijas\u2026",
    "EXTENSION_ERROR"                      : "Paplašinājuma kļūda",
    "EXTENSION_KEYWORDS"                   : "Atslēgas vārdi",
    "EXTENSION_TRANSLATED_USER_LANG"       : "Tulkots {0} valodās, ieskaitot Jūsu",
    "EXTENSION_TRANSLATED_GENERAL"         : "Tulkots {0} valodās",
    "EXTENSION_TRANSLATED_LANGS"           : "Paplašinājums tulkots šādās valodās: {0}",
    "EXTENSION_INSTALLED"                  : "Instalēts",
    "EXTENSION_UPDATE_INSTALLED"           : "Paplašinājuma atjauninājums tika lejupielādēts, un tas tiks instalēts pēc {APP_NAME} pārlādēšanas.",
    "EXTENSION_SEARCH_PLACEHOLDER"         : "Meklēt",
    "EXTENSION_MORE_INFO_LINK"             : "Vairāk",
    "BROWSE_EXTENSIONS"                    : "Pārlūkot paplašinājumus",
    "EXTENSION_MANAGER_REMOVE"             : "Noņemt paplašinājumu",
    "EXTENSION_MANAGER_REMOVE_ERROR"       : "Neizdevās noņemt vienu vai vairākus paplašinājumus: {0}. {APP_NAME} tik un tā pārlādēsies.",
    "EXTENSION_MANAGER_UPDATE"             : "Atjaunināt paplašinājumu",
    "EXTENSION_MANAGER_UPDATE_ERROR"       : "Neizdevās atjaunināt vienu vai vairākus paplašinājumus: {0}. {APP_NAME} tik un tā pārlādēsies.",
    "EXTENSION_MANAGER_DISABLE"            : "Atspējot paplašinājumu",
    "EXTENSION_MANAGER_DISABLE_ERROR"      : "Neizdevās atspējot vienu vai vairākus paplašinājumus: {0}. {APP_NAME} tik un tā pārlādēsies.",
    "MARKED_FOR_REMOVAL"                   : "Atzīmēts noņemšanai",
    "UNDO_REMOVE"                          : "Atsaukt",
    "MARKED_FOR_UPDATE"                    : "Atzīmēts atjaunināšanai",
    "UNDO_UPDATE"                          : "Atsaukt",
    "MARKED_FOR_DISABLING"                 : "Atzīmēts atspējošanai",
    "UNDO_DISABLE"                         : "Atsaukt",
    "CHANGE_AND_RELOAD_TITLE"              : "Mainīt paplašinājumus",
    "CHANGE_AND_RELOAD_MESSAGE"            : "Lai atjauninātu, noņemtu vai atspējotu atzīmētos paplašinājumus, ir jāpārlādē {APP_NAME}. Jums būs jāsaglabā nesaglabātās izmaiņas.",
    "REMOVE_AND_RELOAD"                    : "Noņemt paplašinājumus un pārlādēt",
    "CHANGE_AND_RELOAD"                    : "Mainīt paplašinājumus un pārlādēt",
    "UPDATE_AND_RELOAD"                    : "Atjaunināt paplašinājumus un pārlādēt",
    "DISABLE_AND_RELOAD"                   : "Atspējot paplašinājumus un pārlādēt",
    "PROCESSING_EXTENSIONS"                : "Apstrādā paplašinājumu izmaiņas\u2026",
    "EXTENSION_NOT_INSTALLED"              : "Nevarēja noņemt paplašinājumu {0}, jo tas nebija instalēts.",
    "NO_EXTENSIONS"                        : "Vēl nav instalēti paplašinājumi.<br>Spiediet uz cilnes \"Pieejamie\", lai sāktu darbu.",
    "NO_EXTENSION_MATCHES"                 : "Neviens paplašinājums neatbilst meklētajam.",
    "REGISTRY_SANITY_CHECK_WARNING"        : "PIEZĪME: Šo paplašinājumu autori var nebūt {APP_NAME} autori. Paplašinājumi nav pārskatīti, un tiem ir pilnas lokālās privilēģijas. Uzmanieties, instalējot paplašinājumus no nezināma avota.",
    "EXTENSIONS_INSTALLED_TITLE"           : "Instalētie",
    "EXTENSIONS_AVAILABLE_TITLE"           : "Pieejamie",
    "EXTENSIONS_THEMES_TITLE"              : "Dizaini",
    "EXTENSIONS_UPDATES_TITLE"             : "Atjauninājumi",

    "INLINE_EDITOR_NO_MATCHES"             : "Nav sakritību.",
    "INLINE_EDITOR_HIDDEN_MATCHES"         : "Visas sakritības ir sakļautas. Izvērsiet labajā pusē uzskaitītās datnes, lai apskatītu sakritības.",
    "CSS_QUICK_EDIT_NO_MATCHES"            : "Neeksistē tādas CSS kārtulas, kas atbilstu izvēlētajam.<br> Nospiediet \"Jauna kārtula\", lai to izveidotu.",
    "CSS_QUICK_EDIT_NO_STYLESHEETS"        : "Jūsu projektā nav stila lapu.<br>Izveidojiet to, lai pievienotu CSS kārtulas.",

    // Custom Viewers
    "IMAGE_VIEWER_LARGEST_ICON"            : "lielākais",

    /**
     * Unit names
     */
    "UNIT_PIXELS"                          : "pikseļi",

    // extensions/default/DebugCommands
    "DEBUG_MENU"                                : "Atkļūdot",
    "ERRORS"                                    : "Kļūdas",
    "CMD_SHOW_DEV_TOOLS"                        : "Rādīt izstrādātāja rīkus",
    "CMD_REFRESH_WINDOW"                        : "Pārlādēt ar paplašinājumiem",
    "CMD_RELOAD_WITHOUT_USER_EXTS"              : "Pārlādēt bez paplašinājumiem",
    "CMD_NEW_BRACKETS_WINDOW"                   : "Jauns {APP_NAME} logs",
    "CMD_LAUNCH_SCRIPT_MAC"                     : "Instalēt komandrindas saīsni",
    "CMD_SWITCH_LANGUAGE"                       : "Pārslēgt valodu",
    "CMD_RUN_UNIT_TESTS"                        : "Palaist testus",
    "CMD_SHOW_PERF_DATA"                        : "Rādīt veiktspējas informāciju",
    "CMD_ENABLE_NODE_DEBUGGER"                  : "Iespējot mezgla atkļūdošanu",
    "CMD_LOG_NODE_STATE"                        : "Ierakstīt mezgla stāvokli konsolē",
    "CMD_RESTART_NODE"                          : "Restartēt mezglu",
    "CMD_SHOW_ERRORS_IN_STATUS_BAR"             : "Rādīt kļūdas statusa joslā",
    "CMD_OPEN_BRACKETS_SOURCE"                  : "Atvērt {APP_NAME} avotu",

    "CREATING_LAUNCH_SCRIPT_TITLE"              : "{APP_NAME} komandrindas saīsne",
    "ERROR_CREATING_LAUNCH_SCRIPT"              : "Radās kļūda, instalējot komandrindas saīsni. Lūdzu, mēģiniet <a href='https://github.com/adobe/brackets/wiki/Command-Line-Arguments#troubleshooting'>šīs problēmu noteikšanas ieteikumi</a>.<br/><br/>Iemesls: {0}",
    "ERROR_CLTOOLS_RMFAILED"                    : "Neizdevās noņemt esošo <code>/usr/local/bin/brackets</code> simbolisko saiti.",
    "ERROR_CLTOOLS_MKDIRFAILED"                 : "Neizdevās izveidot <code>/usr/local/bin</code> katalogu.",
    "ERROR_CLTOOLS_LNFAILED"                    : "Neizdevās izveidot <code>/usr/local/bin/brackets</code> simbolisko saiti.",
    "ERROR_CLTOOLS_SERVFAILED"                  : "Iekšēja kļūda.",
    "ERROR_CLTOOLS_NOTSUPPORTED"                : "Šī operētājsistēma neatbalsta komandrindas saīsni.",
    "LAUNCH_SCRIPT_CREATE_SUCCESS"              : "Veiksmīgi! Nu varat vienkārši palaist {APP_NAME} no komandrindas: <code>brackets myFile.txt</code>, lai atvērtu datni vai <code>brackets myFolder</code>, lai pārslēgtu projektus. <br/><br/><a href='https://github.com/adobe/brackets/wiki/Command-Line-Arguments'>Uzzināt vairāk</a>  par {APP_NAME} komandrindas izmantošanu.",

    "LANGUAGE_TITLE"                            : "Pārslēgt valodu",
    "LANGUAGE_MESSAGE"                          : "Valoda:",
    "LANGUAGE_SUBMIT"                           : "Pārlādēt {APP_NAME}",
    "LANGUAGE_CANCEL"                           : "Atcelt",
    "LANGUAGE_SYSTEM_DEFAULT"                   : "Sistēmas noklusējums",

    // extensions/default/HealthData
    "HEALTH_DATA_NOTIFICATION"                  : "Veselības atskaites iestatījumi",
    "HEALTH_FIRST_POPUP_TITLE"                  : "{APP_NAME} veselības atskaite",
    "HEALTH_DATA_DO_TRACK"                      : "Dalīties ar anonīmu informāciju, kā es izmantoju {APP_NAME}",
    "HEALTH_DATA_NOTIFICATION_MESSAGE"          : "Lai uzlabotu {APP_NAME}, mēs periodiski nosūtām ierobežotu, <strong>anonīmu</strong> statistiku uzņēmumam Adobe, kā Jūs izmantojat {APP_NAME}. Šī informācija palīdz noteikt funkciju prioritāti, atrast kļūdas un noteikt lietojamības problēmas.<br><br>Jūs varat redzēt savus datus vai izvēlēties nedalīties ar informāciju, izvēloties <strong>Palīdzība > Veselības atskaite</strong>.<br><br><a href='https://github.com/adobe/brackets/wiki/Health-Data'>Uzzināt vairāk par {APP_NAME} veselības atskaiti</a>",
    "HEALTH_DATA_PREVIEW"                       : "{APP_NAME} veselības atskaite",
    "HEALTH_DATA_PREVIEW_INTRO"                 : "<p> Lai uzlabotu {APP_NAME}, mēs periodiski nosūtām ierobežotu, <strong>anonīmu</strong> statistiku uzņēmumam Adobe, kā Jūs izmantojat {APP_NAME}. Šī informācija palīdz noteikt funkciju prioritāti, atrast kļūdas un noteikt lietojamības problēmas. <a href='https://github.com/adobe/brackets/wiki/Health-Data'>Uzzināt vairāk par {APP_NAME} veselības atskaiti</a> un kādu labumu tā dod {APP_NAME} kopienai, pasargājot jūsu privātumu.</p><p>Zemāk varat redzēt datu priekšskatījumu, kas tiks nosūtīti nākamajā veselības atskaitē<em>ja</em> tā ir iespējota.</p>",

    // extensions/default/InlineTimingFunctionEditor
    "INLINE_TIMING_EDITOR_TIME"                 : "Laiks",
    "INLINE_TIMING_EDITOR_PROGRESSION"          : "Progress",
    "BEZIER_EDITOR_INFO"                        : "<kbd>↑</kbd><kbd>↓</kbd><kbd>←</kbd><kbd>→</kbd>Pārvietot izvēlēto punktu<br><kbd class='text'>Shift</kbd> Pārvietot par desmit vienībām<br><kbd class='text'>Tabulācija</kbd> Pārslēgšanās punkti",
    "STEPS_EDITOR_INFO"                         : "<kbd>↑</kbd><kbd>↓</kbd> Palielināt vai samazināt soļus<br><kbd>←</kbd><kbd>→</kbd> 'Sākt' vai 'Beigt'",
    "INLINE_TIMING_EDITOR_INVALID"              : "Vecā vērtība <code>{0}</code> nav derīga, tāpēc parādītā funkcija tika mainīta uz <code>{1}</code>. Dokuments tiks atjaunināts līdz ar pirmo rediģēšanu.",

    // extensions/default/InlineColorEditor
    "COLOR_EDITOR_CURRENT_COLOR_SWATCH_TIP"     : "Pašreizējā krāsa",
    "COLOR_EDITOR_ORIGINAL_COLOR_SWATCH_TIP"    : "Oriģinālā krāsa",
    "COLOR_EDITOR_RGBA_BUTTON_TIP"              : "RGBa formāts",
    "COLOR_EDITOR_HEX_BUTTON_TIP"               : "Hex formāts",
    "COLOR_EDITOR_HSLA_BUTTON_TIP"              : "HSLa formāts",
    "COLOR_EDITOR_USED_COLOR_TIP_SINGULAR"      : "{0} (lietots {1} reizi)",
    "COLOR_EDITOR_USED_COLOR_TIP_PLURAL"        : "{0} (lietots {1} reizes)",

    // extensions/default/JavaScriptCodeHints
    "CMD_JUMPTO_DEFINITION"                     : "Pārlēkt uz definīciju",
    "CMD_SHOW_PARAMETER_HINT"                   : "Rādīt parametru ieteikumus",
    "NO_ARGUMENTS"                              : "<nav argumentu>",
    "DETECTED_EXCLUSION_TITLE"                  : "JavaScript datnes izveduma problēma",
    "DETECTED_EXCLUSION_INFO"                   : "{APP_NAME} saskārās ar grūtībām apstrādāt <span class='dialog-filename'>{0}</span>.<br><br> Šo datni vairs nevarēs apstrādāt ar funkcijām: koda ieteikumi, pārlēkt uz definīciju un ātrā rediģēšana. Lai no jauna iespējotu šo datni, atveriet <code>.brackets.json</code> projektā un rediģējiet <code>jscodehints.detectedExclusions</code>.<br><br> Šī ir iespējama {APP_NAME} kļūda. Ja varat nodrošināt šīs datnes kopiju, <a href='https://github.com/adobe/brackets/wiki/How-to-Report-an-Issue'>reģistrējiet kļūdu</a> ar saiti uz šeit norādīto datni.",

    // extensions/default/JSLint
    "JSLINT_NAME"                               : "JSLint",

    // extensions/default/QuickView
    "CMD_ENABLE_QUICK_VIEW"                     : "Ātrais skats uz norādēm",

    // extensions/default/RecentProjects
    "CMD_TOGGLE_RECENT_PROJECTS"                : "Nesenie projekti",

    // extensions/default/WebPlatformDocs
    "DOCS_MORE_LINK"                            : "Lasīt vairāk",

    // extensions/default/CodeFolding
    "COLLAPSE_ALL"                  : "Sakļaut visu",
    "EXPAND_ALL"                    : "Izvērst visu",
    "COLLAPSE_CURRENT"              : "Sakļaut pašreizējo",
    "EXPAND_CURRENT"                : "Izvērst pašreizējo",

    // Descriptions of core preferences
    "DESCRIPTION_CLOSE_BRACKETS"                     : "vērtība true, lai automātiski aizvērtu figūriekavas, iekavas un apaļās iekavas",
    "DESCRIPTION_CLOSE_OTHERS_ABOVE"                 : "vērtība false, lai noņemtu \"Aizvērt visus augstāk\" no darba datņu kontekstizvēlnes",
    "DESCRIPTION_CLOSE_OTHERS_BELOW"                 : "vērtība false, lai noņemtu \"Aizvērt visus zemāk\" no darba datņu kontekstizvēlnes",
    "DESCRIPTION_CLOSE_OTHERS"                       : "vērtība false, lai noņemtu \"Aizvērt citus\" no darba datņu kontekstizvēlnes",
    "DESCRIPTION_CLOSE_TAGS"                         : "Nosaka tagu aizvēršanas iespējas",
    "DESCRIPTION_CLOSE_TAGS_DONT_CLOSE_TAGS"         : "Tagu masīvs, kas nav automātiski jāaizver",
    "DESCRIPTION_CLOSE_TAGS_WHEN_OPENING"            : "Aizvērt, kad tiek ierakstīts atverošā taga > ",
    "DESCRIPTION_CLOSE_TAGS_WHEN_CLOSING"            : "Aizvērt, kad tiek ierakstīts aizverošā taga / ",
    "DESCRIPTION_CLOSE_TAGS_INDENT_TAGS"             : "Tagu masīvs, kuru atverot ir tukša rinda",
    "DESCRIPTION_CODE_FOLDING_ALWAY_USE_INDENT_FOLD" : "vērtība true, lai vienmēr ģenerētu sakļaušanas atzīmes, kad mainās atkāpes līmenis",
    "DESCRIPTION_CODE_FOLDING_ENABLED"               : "vērtība true, lai iespējotu koda locīšanu",
    "DESCRIPTION_CODE_FOLDING_HIDE_UNTIL_MOUSEOVER"  : "vērtība true, lai sadaļu sakļaušanas atzīmes būtu redzamas, kustinot peli pāri koda kreisajai malai",
    "DESCRIPTION_CODE_FOLDING_MAX_FOLD_LEVEL"        : "Limitēt, uz cik līmeņiem attiecas Sakļaut visu",
    "DESCRIPTION_CODE_FOLDING_MIN_FOLD_SIZE"         : "Minimālais rindu skaits, pirms parādās sakļaušanas sadaļas ikona",
    "DESCRIPTION_CODE_FOLDING_SAVE_FOLD_STATES"      : "vērtība true, lai atcerētos sakļautās sadaļas, aizverot un no jauna atverot datni vai projektu",
    "DESCRIPTION_CODE_FOLDING_MAKE_SELECTIONS_FOLDABLE": "vērtība true, lai iespējotu koda locīšanu izvēlētajam tekstam redaktorā",
    "DESCRIPTION_ATTR_HINTS"                         : "Iespējot/atspējot HTML atribūtu ieteikumus",
    "DESCRIPTION_CSS_PROP_HINTS"                     : "Iespējot/atspējot CSS/LESS/SCSS rekvizītu ieteikumus",
    "DESCRIPTION_JS_HINTS"                           : "Iespējot/atspējot JavaScript koda ieteikumus",
    "DESCRIPTION_JS_HINTS_TYPE_DETAILS"              : "Iespējot/atspējot datu tipa informāciju JavaScript koda ieteikumos",
    "DESCRIPTION_PREF_HINTS"                         : "Iespējot/atspējot iestatījumu koda ieteikumus",
    "DESCRIPTION_SPECIAL_CHAR_HINTS"                 : "Iespējot/atspējot HTML elementu ieteikumus",
    "DESCRIPTION_SVG_HINTS"                          : "Iespējot/atspējot SVG koda ieteikumus",
    "DESCRIPTION_HTML_TAG_HINTS"                     : "Iespējot/atspējot HTML tagu ieteikumus",
    "DESCRIPTION_URL_CODE_HINTS"                     : "Iespējot/atspējot URL ieteikumus HTML & CSS/LESS/SCSS",
    "DESCRIPTION_DRAG_DROP_TEXT"                     : "Iespējot/atspējot ievilkšanas & nomešanas funkcionalitāti",
    "DESCRIPTION_HEALTH_DATA_TRACKING"               : "Iespējot sekošanu veselības datiem",
    "DESCRIPTION_HIGHLIGHT_MATCHES"                  : "Iespējot automātisko saskanīgo virkņu izcelšanu visā dokumentā",
    "DESCRIPTION_HIGHLIGHT_MATCHES_SHOW_TOKEN"       : "Izcelt visas virknes, kuras sakrīt ar tekstvienībām, kurās šobrīd ir kursors (nav nepieciešams izvēlēties)",
    "DESCRIPTION_HIGHLIGHT_MATCHES_WORDS_ONLY"       : "Izcelt tikai tad, kad izvēlētais ir pilna tekstvienība",
    "DESCRIPTION_INSERT_HINT_ON_TAB"                 : "vērtība true, lai ievietotu pašlaik izvēlēto koda ieteikumu cilnē",
    "DESCRIPTION_NO_HINTS_ON_DOT"                    : "vērtība true, lai automātiski nerādītu JS koda ieteikumus, ierakstot .",
    "DESCRIPTION_JSLINT_OPTIONS"                     : "Objekts ar JSLint noklusējuma iespējām",
    "DESCRIPTION_JSLINT_OPTIONS_ASS"                 : "vērtība true, lai atļautu piešķiršanas izteiksmes",
    "DESCRIPTION_JSLINT_OPTIONS_BITWISE"             : "vērtība true, lai atļautu bitu operācijas",
    "DESCRIPTION_JSLINT_OPTIONS_BROWSER"             : "vērtība true, ja pārlūka globālie mainīgie ir jānosaka iepriekš",
    "DESCRIPTION_JSLINT_OPTIONS_CLOSURE"             : "vērtība true, lai atļautu Google Closure idiomas",
    "DESCRIPTION_JSLINT_OPTIONS_CONTINUE"            : "vērtība true, lai atļautu \"turpināt\" priekšrakstu",
    "DESCRIPTION_JSLINT_OPTIONS_COUCH"               : "vērtība true, ja CouchDB globālie mainīgie ir jānosaka iepriekš",
    "DESCRIPTION_JSLINT_OPTIONS_DEBUG"               : "vērtība true, lai atļautu atkļūdotāja priekšrakstu",
    "DESCRIPTION_JSLINT_OPTIONS_DEVEL"               : "vērtība true, ja iepriekš jānosaka pārlūka globālie mainīgie, kas var noderēt izstrādē",
    "DESCRIPTION_JSLINT_OPTIONS_EQEQ"                : "vērtība true, lai atļautu  == un !=",
    "DESCRIPTION_JSLINT_OPTIONS_ES6"                 : "vērtība true, ja ES6 globālie mainīgie ir jānosaka iepriekš",
    "DESCRIPTION_JSLINT_OPTIONS_EVIL"                : "vērtība true, lai atļautu novērtēšanu",
    "DESCRIPTION_JSLINT_OPTIONS_FORIN"               : "vērtība true, lai atļautu nefiltrētu \"priekš … iekš\"",
    "DESCRIPTION_JSLINT_OPTIONS_INDENT"              : "Noteikt specifisku tabulācijas platumu",
    "DESCRIPTION_JSLINT_OPTIONS_MAXERR"              : "Maksimālais aprakstīto brīdinājumu skaits",
    "DESCRIPTION_JSLINT_OPTIONS_MAXLEN"              : "Maksimālais simbolu skaits rindā",
    "DESCRIPTION_JSLINT_OPTIONS_NEWCAP"              : "vērtība true, lai atļautu konstruktorus ar mazo burtu",
    "DESCRIPTION_JSLINT_OPTIONS_NODE"                : "vērtība true, ja Node.js globālie mainīgie ir jānosaka iepriekš",
    "DESCRIPTION_JSLINT_OPTIONS_NOMEN"               : "vērtība true, lai atļautu apakšsvītru identifikatorus sākumā vai beigās",
    "DESCRIPTION_JSLINT_OPTIONS_PASSFAIL"            : "vērtība true, lai apstātos pie pirmās kļūdas",
    "DESCRIPTION_JSLINT_OPTIONS_PLUSPLUS"            : "vērtība true, lai atļautu  ++ un --",
    "DESCRIPTION_JSLINT_OPTIONS_REGEXP"              : "vērtība true, lai atļautu . un [^...]. regulārajā izteiksmē",
    "DESCRIPTION_JSLINT_OPTIONS_RHINO"               : "vērtība true, ja Rhino globālie mainīgie ir jānosaka iepriekš",
    "DESCRIPTION_JSLINT_OPTIONS_SLOPPY"              : "vērtība true, lai atļautu neizdevušos 'striktas pragmatikas izmantošanu'",
    "DESCRIPTION_JSLINT_OPTIONS_STUPID"              : "vērtība true, ja bloķēšanas ('…Sinhronizācija') metodes var tikt izmantotas.",
    "DESCRIPTION_JSLINT_OPTIONS_SUB"                 : "vērtība true, lai atļautu neefektīvu masīva indeksēšanu",
    "DESCRIPTION_JSLINT_OPTIONS_TODO"                : "vērtība true, lai atļautu TODO komentārus",
    "DESCRIPTION_JSLINT_OPTIONS_UNPARAM"             : "vērtība true, lai atļautu neizmantotus parametrus",
    "DESCRIPTION_JSLINT_OPTIONS_VARS"                : "vērtība true, lai atļautu funkcijā vairāk nekā 1 mainīgo",
    "DESCRIPTION_JSLINT_OPTIONS_WHITE"               : "vērtība true, lai ignorētu baltstarpas rakstzīmju noteikumus",
    "DESCRIPTION_LANGUAGE"                           : "Specifiski valodas iestatījumi",
    "DESCRIPTION_LANGUAGE_FILE_EXTENSIONS"           : "Papildu kartēšana no datnes paplašinājuma uz valodas nosaukumu",
    "DESCRIPTION_LANGUAGE_FILE_NAMES"                : "Papildu kartēšana no datnes nosaukuma uz valodas nosaukumu",
    "DESCRIPTION_LINTING_ENABLED"                    : "vērtība true, lai iespējotu koda pārbaudi",
    "DESCRIPTION_ASYNC_TIMEOUT"                      : "Laiks milisekundēs pēc asinhronās sintakses pārbaudes taimauta",
    "DESCRIPTION_LINTING_PREFER"                     : "Sintakses pārbaužu kārtība",
    "DESCRIPTION_LIVE_DEV_MULTIBROWSER"              : "vērtība true, lai iespējotu eksperimentālo tiešo priekšskatījumu",
    "DESCRIPTION_USE_PREFERED_ONLY"                  : "vērtība true, lai palaistu sniedzējus, kas norādīti tikai linting.prefer",
    "DESCRIPTION_MAX_CODE_HINTS"                     : "Sasniegts maksimālais vienlaicīgi parādīto kodu ieteikumu skaits",
    "DESCRIPTION_PATH"                               : "Specifiski ceļu iestatījumi",
    "DESCRIPTION_PROXY"                              : "Paplašinājuma instalēšanai izmantotais starpniekservera URL",
    "DESCRIPTION_SCROLL_PAST_END"                    : "vērtība true, lai iespējotu ritināšanu pēc dokumenta beigām",
    "DESCRIPTION_SHOW_CODE_HINTS"                    : "vērtība false, lai atspējotu koda ieteikumus",
    "DESCRIPTION_SHOW_CURSOR_WHEN_SELECTING"         : "Atstāj mirgojošo kursoru redzamu, kad izvēlēts teksts",
    "DESCRIPTION_SHOW_LINE_NUMBERS"                  : "vērtība true, lai rādītu rindu numuru koda kreisajā malā",
    "DESCRIPTION_SMART_INDENT"                       : "Automātiskā atkāpe, veidojot jaunu bloku",
    "DESCRIPTION_SOFT_TABS"                          : "vērtība false, lai izslēgtu mīkstās tabulācijas uzvedību",
    "DESCRIPTION_SORT_DIRECTORIES_FIRST"             : "vērtība true, lai projektu kokā pirmos sakārtotu katalogus",
    "DESCRIPTION_SPACE_UNITS"                        : "Atstarpju skaits, lai izmantotu uz atstarpēm balstītas atkāpes",
    "DESCRIPTION_STATIC_SERVER_PORT"                 : "Porta numurs, kas iebūvētajam serverim jāizmanto tiešajam priekšskatījumam",
    "DESCRIPTION_STYLE_ACTIVE_LINE"                  : "vērtība true, lai izceltu fona krāsu rindai, kurā atrodas kursors",
    "DESCRIPTION_TAB_SIZE"                           : "Atstarpju skaits, lai parādītu tabulāciju",
    "DESCRIPTION_USE_TAB_CHAR"                       : "vērtība true, lai atstarpju vietā izmantotu tabulāciju",
    "DESCRIPTION_UPPERCASE_COLORS"                   : "vērtība true, lai iekšrindas krāsu redaktorā ģenerētu  heksadecimālos krāsu kodus ar lielajiem burtiem",
    "DESCRIPTION_WORD_WRAP"                          : "Rindu aplaušana, lai pārsniegtu skatlauka platumu",
    "DESCRIPTION_DETECTED_EXCLUSIONS"                : "Noteikto datņu saraksts, kas izraisīja Tern nekontrolējamību",
    "DESCRIPTION_INFERENCE_TIMEOUT"                  : "Laiks, pēc kura Tern iestāsies taimauts, cenšoties saprast datnes",
    "DESCRIPTION_SHOW_ERRORS_IN_STATUS_BAR"          : "vērtība true, lai rādītu kļūdas statusa joslā",
    "DESCRIPTION_QUICK_VIEW_ENABLED"                 : "vērtība true, lai iespējotu ātro skatu",
    "DESCRIPTION_EXTENSION_LESS_IMAGE_PREVIEW"       : "vērtība true, lai rādītu attēlu priekšskatījumus URL bez paplašinājumiem",
    "DESCRIPTION_THEME"                              : "Izvēlēties {APP_NAME} dizainu",
    "DESCRIPTION_USE_THEME_SCROLLBARS"               : "vērtība true, lai atļautu pielāgotas ritjoslas",
    "DESCRIPTION_LINTING_COLLAPSED"                  : "vērtība true, lai sakļautu sintakses pārbaudes paneli",
    "DESCRIPTION_FONT_FAMILY"                        : "Mainīt fontu saimi",
    "DESCRIPTION_FONT_SIZE"                          : "Mainīt fonta lielumu; piemēram, 13px",
    "DESCRIPTION_FIND_IN_FILES_NODE"                 : "vērtība true, lai iespējotu uz mezgliem balstītu meklēšanu",
    "DESCRIPTION_FIND_IN_FILES_INSTANT"              : "vērtība true, lai iespējotu tūlītēju meklēšanu",
    "DESCRIPTION_FONT_SMOOTHING"                     : "Tikai Mac: \"subpikseļi-gludināšana\", lai iespējotu subpikseļu gludināšanu vai \"gludināšana\", lai iespējotu pelēko toņu gludināšanu",
    "DESCRIPTION_OPEN_PREFS_IN_SPLIT_VIEW"           : "vērtība false, lai atspējotu iestatījumu datni sadalītajā skatā",
    "DESCRIPTION_OPEN_USER_PREFS_IN_SECOND_PANE"     : "vērtība false, lai atvērtu iestatījumu datni kreisajā/augšējā rūtī",
    "DESCRIPTION_MERGE_PANES_WHEN_LAST_FILE_CLOSED"  : "vērtība true, lai sakļautu rūtis, kad tiek aizvērta pēdējā rūts ar aizvēršanas pogu rūts galvenē",
    "DESCRIPTION_SHOW_PANE_HEADER_BUTTONS"           : "Rādīt/nerādīt aizvēršanas un pārnešanas pogas galvenē.",
    "DEFAULT_PREFERENCES_JSON_HEADER_COMMENT"        : "/*\n * Šī datne ir tikai lasāma, iestatījumus atbalsta\n * {APP_NAME}.\n * Izmantojiet šo datni kā norādījumus, lai mainītu iestatījumus \n * datnē \"brackets.json\", kas ir atvērta citā rūtī.\n * Sīkākai informācija par iestatījumu izmantošanu\n * {APP_NAME} apmeklējiet tīmekļa vietni https://github.com/adobe/brackets/wiki/How-to-Use-Brackets#preferences\n */",
    "DEFAULT_PREFERENCES_JSON_DEFAULT"               : "Noklusējums",
    "DESCRIPTION_PURE_CODING_SURFACE"                : "vērtība true, lai iespējotu tikai koda režīmu un paslēptu visus citus UI elementus {APP_NAME}",
    "DESCRIPTION_INDENT_LINE_COMMENT"                : "vērtība true, lai iespējotu rindas komentāru atkāpi"
});

/* Last translated for a505026d40a4eb0bffc196eda30557c0e6b021bc */