/*
 * Copyright (c) 2012 - present Adobe Systems Incorporated. All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 */

define({

    /**
     * Errors
     */

    // General file io error strings
    "GENERIC_ERROR"                     : "(грешка {0})",
    "NOT_FOUND_ERR"                     : "Файлът/папката не може да бъде открит.",
    "NOT_READABLE_ERR"                  : "Файлът/папката не може да бъде прочетен.",
    "EXCEEDS_MAX_FILE_SIZE"             : "Файлове с размер по-голям от {0} МБ не могат да бъдат прочетени от {APP_NAME}.",
    "NO_MODIFICATION_ALLOWED_ERR"       : "Целевата папка не може да бъде променяна.",
    "NO_MODIFICATION_ALLOWED_ERR_FILE"  : "Правата не Ви позволяват да правите промени.",
    "CONTENTS_MODIFIED_ERR"             : "Файлът е бил променен извън {APP_NAME}.",
    "UNSUPPORTED_ENCODING_ERR"          : "{APP_NAME} в момента поддържа само текстови файлове с кодировка UTF-8.",
    "FILE_EXISTS_ERR"                   : "Файлът или папката вече съществува.",
    "FILE"                              : "файл",
    "FILE_TITLE"                        : "Файл",
    "DIRECTORY"                         : "папка",
    "DIRECTORY_TITLE"                   : "Папка",
    "DIRECTORY_NAMES_LEDE"              : "Имена на папки",
    "FILENAMES_LEDE"                    : "Имена на файлове",
    "FILENAME"                          : "Име на файл",
    "DIRECTORY_NAME"                    : "Име на папка",

    // Project error strings
    "ERROR_LOADING_PROJECT"             : "Грешка при зареждане на проекта",
    "OPEN_DIALOG_ERROR"                 : "Възникна грешка при показването на прозореца за отваряне на файл. (грешка {0})",
    "REQUEST_NATIVE_FILE_SYSTEM_ERROR"  : "Възникна грешка при опита за зареждане на папката <span class='dialog-filename'>{0}</span>. (грешка {1})",
    "READ_DIRECTORY_ENTRIES_ERROR"      : "Възникна грешка при прочитането на съдържанието на папката <span class='dialog-filename'>{0}</span>. (грешка {1})",

    // File open/save error string
    "ERROR_OPENING_FILE_TITLE"          : "Грешка при отваряне на файла",
    "ERROR_OPENING_FILE"                : "Възникна грешка при опита за отваряне на файла <span class='dialog-filename'>{0}</span>. {1}",
    "ERROR_OPENING_FILES"               : "Възникна грешка при опита за отваряне на следните файлове:",
    "ERROR_RELOADING_FILE_TITLE"        : "Грешка при прочитането на промените от диска",
    "ERROR_RELOADING_FILE"              : "Възникна грешка при опита за презареждане на файла <span class='dialog-filename'>{0}</span>. {1}",
    "ERROR_SAVING_FILE_TITLE"           : "Грешка при запазването на файла",
    "ERROR_SAVING_FILE"                 : "Възникна грешка при опита за запазване на файла <span class='dialog-filename'>{0}</span>. {1}",
    "ERROR_RENAMING_FILE_TITLE"         : "Грешка при преименуването на {0}",
    "ERROR_RENAMING_FILE"               : "Възникна грешка при опита за преименуване на {2} <span class='dialog-filename'>{0}</span>. {1}",
    "ERROR_RENAMING_NOT_IN_PROJECT"     : "Файлът или папката не е част от текущо отворения проект. За съжаление, само файловете в проекта могат да бъдат преименувани засега.",
    "ERROR_DELETING_FILE_TITLE"         : "Грешка при изтриването на {0}",
    "ERROR_DELETING_FILE"               : "Възникна грешка при опита за изтриване на {2} <span class='dialog-filename'>{0}</span>. {1}",
    "INVALID_FILENAME_TITLE"            : "Грешно {0}",
    "INVALID_FILENAME_MESSAGE"          : "{0} не може да използва запазени думи, да завършва с точки (.) или да използва никой от следните знаци: <code class='emphasized'>{1}</code>",
    "ENTRY_WITH_SAME_NAME_EXISTS"       : "Вече съществува файл или папка с името <span class='dialog-filename'>{0}</span>.",
    "ERROR_CREATING_FILE_TITLE"         : "Грешка при създаването на {0}",
    "ERROR_CREATING_FILE"               : "Възникна грешка при опита за създаване на {0} <span class='dialog-filename'>{1}</span>. {2}",
    "ERROR_MIXED_DRAGDROP"              : "Папка и файлове не могат да се отварят едновременно.",

    // User key map error strings
    "ERROR_KEYMAP_TITLE"                : "Грешка при прочитането на потребителските клавишни настройки",
    "ERROR_KEYMAP_CORRUPT"              : "Файлът с Вашите клавишни настройки не е правилно форматиран според формата JSON. Файлът ще бъде отворен, за да го поправите.",
    "ERROR_LOADING_KEYMAP"              : "Файлът с Вашите клавишни настройки не е кодиран в правилната кодировка UTF-8 и не може да бъде зареден.",
    "ERROR_RESTRICTED_COMMANDS"         : "Не можете да настройвате други клавиши и комбинации за следните команди: {0}",
    "ERROR_RESTRICTED_SHORTCUTS"        : "Не можете да пренастройвате следните клавиши и комбинации: {0}",
    "ERROR_MULTIPLE_SHORTCUTS"          : "Настройвате твърде много клавишни комбинации за следните команди: {0}",
    "ERROR_DUPLICATE_SHORTCUTS"         : "Имате твърде много настроени команди за следните клавишни комбинации: {0}",
    "ERROR_INVALID_SHORTCUTS"           : "Следните клавишни комбинации са грешни: {0}",
    "ERROR_NONEXISTENT_COMMANDS"        : "Задавате клавишни комбинации на несъществуващи команди: {0}",

    // Application preferences corrupt error strings
    "ERROR_PREFS_CORRUPT_TITLE"         : "Грешка при прочитането на настройките",
    "ERROR_PREFS_CORRUPT"               : "Файлът с настройките не е правилно форматиран според формата JSON. Файлът ще бъде отворен, за да го поправите. След това ще трябва да затворите и пуснете отново {APP_NAME}, за да влязат в сила промените.",
    "ERROR_PROJ_PREFS_CORRUPT"          : "Файлът с настройките на проекта не е правилно форматиран според формата JSON. Файлът ще бъде отворен, за да го поправите. След това ще трябва да презаредите проекта, за да влязат в сила промените.",

    // Application error strings
    "ERROR_IN_BROWSER_TITLE"            : "Опа! {APP_NAME} все още не може да работи в браузър.",
    "ERROR_IN_BROWSER"                  : "Приложението {APP_NAME} е изградено чрез HTML, но в момента работи като настолно приложение, така че да може да го използвате за редактиране на местни файлове. Моля, използвайте приложната обвивка от хранилището <b>github.com/adobe/brackets-shell</b>, за да пуснете {APP_NAME}.",

    // ProjectManager max files error string
    "ERROR_MAX_FILES_TITLE"             : "Грешка при обработката на файловете",
    "ERROR_MAX_FILES"                   : "Този проект има над 30 000 файла. Функционалностите, които работят с множество файлове може да бъдат изключени или да работят така, сякаш проектът е празен. <a href='https://github.com/adobe/brackets/wiki/Large-Projects'>Прочете повече относно работата с големи проекти</a>.",

    // Live Preview error strings
    "ERROR_LAUNCHING_BROWSER_TITLE"     : "Грешка при пускането на браузъра",
    "ERROR_CANT_FIND_CHROME"            : "Браузърът „Google Chrome“ не може да бъде открит. Моля, уверете се, че той е инсталиран.",
    "ERROR_LAUNCHING_BROWSER"           : "Възникна грешка при пускането на браузъра. (грешка {0})",

    "LIVE_DEVELOPMENT_ERROR_TITLE"      : "Грешка при прегледа на живо",
    "LIVE_DEVELOPMENT_RELAUNCH_TITLE"   : "Свързване с браузъра",
    "LIVE_DEVELOPMENT_ERROR_MESSAGE"    : "За да може да се свърже прегледът на живо, Chrome трябва да бъде пуснат отново с включена възможност за отдалечено отстраняване на грешки.<br /><br />Искате ли да пуснете отново Chrome и да включите тази възможност?<br /><br />",
    "LIVE_DEV_LOADING_ERROR_MESSAGE"    : "Неуспешно зареждане на страницата в прегледа на живо.",
    "LIVE_DEV_NEED_HTML_MESSAGE"        : "Отворете файл с HTML или се уверете, че има файл с името „index.html“ в проекта Ви, за да можете да пуснете прегледа на живо.",
    "LIVE_DEV_NEED_BASEURL_MESSAGE"     : "За да пуснете прегледа на живо с файл от сървър, трябва да посочите базов адрес за този проект.",
    "LIVE_DEV_SERVER_NOT_READY_MESSAGE" : "Грешка при пускането на HTTP сървъра за преглед на файлове на живо. Моля, опитайте отново.",
    "LIVE_DEVELOPMENT_INFO_TITLE"       : "Добре дошли в прегледа на живо!",
    "LIVE_DEVELOPMENT_INFO_MESSAGE"     : "Прегледът на живо свързва {APP_NAME} към браузъра Ви. Той Ви дава възможност да видите своя HTML файл в браузъра си, а след това го обновява постоянно, докато редактирате кода си.<br /><br />В тази ранна версия на {APP_NAME}, прегледът на живо може да работи единствено с <strong>Google Chrome</strong> и се обновява, докато редактирате файлове от типовете <strong>CSS и HTML</strong>. Промените във файловете с код на JavaScript се презареждат автоматично, когато ги запазите.<br /><br />(Това съобщение се появява само веднъж.)",
    "LIVE_DEVELOPMENT_TROUBLESHOOTING"  : "За повече информация, вижте <a href='{0}' title='{0}'>Отстраняване на проблеми с връзката на прегледа на живо</a>.",

    "LIVE_DEV_STATUS_TIP_NOT_CONNECTED" : "Преглед на живо",
    "LIVE_DEV_STATUS_TIP_PROGRESS1"     : "Преглед на живо: свързване\u2026",
    "LIVE_DEV_STATUS_TIP_PROGRESS2"     : "Преглед на живо: установка\u2026",
    "LIVE_DEV_STATUS_TIP_CONNECTED"     : "Разкачане на прегледа на живо",
    "LIVE_DEV_STATUS_TIP_OUT_OF_SYNC"   : "Преглед на живо (запазете файла, за да опресните)",
    "LIVE_DEV_STATUS_TIP_SYNC_ERROR"    : "Преглед на живо (без обновяване, поради синтактична грешка)",

    "LIVE_DEV_DETACHED_REPLACED_WITH_DEVTOOLS" : "Прегледът на живо беше прекъснат, тъй като бяха отворени инструментите за разработчици на браузъра.",
    "LIVE_DEV_DETACHED_TARGET_CLOSED"          : "Прегледът на живо беше прекъснат, тъй като страницата в браузъра беше затворена.",
    "LIVE_DEV_NAVIGATED_AWAY"                  : "Прегледът на живо беше прекъснат, тъй като бръузърът премина към страница, която не е част от текущия проект.",
    "LIVE_DEV_CLOSED_UNKNOWN_REASON"           : "Прегледът на живо беше прекъснат поради неизвестна причина ({0})",

    "SAVE_CLOSE_TITLE"                  : "Запазване на промените",
    "SAVE_CLOSE_MESSAGE"                : "Искате ли да запазите промените, които направихте в документа <span class='dialog-filename'>{0}</span>?",
    "SAVE_CLOSE_MULTI_MESSAGE"          : "Искате ли да запазите промените си в следните файлове?",
    "EXT_MODIFIED_TITLE"                : "Външни промени",
    "CONFIRM_DELETE_TITLE"              : "Потвърждаване на изтриването",
    "CONFIRM_FOLDER_DELETE"             : "Наистина ли искате да изтриете папката <span class='dialog-filename'>{0}</span>?",
    "FILE_DELETED_TITLE"                : "Изтрит файл",
    "EXT_MODIFIED_WARNING"              : "Файлът <span class='dialog-filename'>{0}</span> беше променен извън {APP_NAME}.<br /><br />Искате ли да запазите файла и да презапишете промените му?",
    "EXT_MODIFIED_MESSAGE"              : "Файлът <span class='dialog-filename'>{0}</span> беше променен извън {APP_NAME}, но също така има незапазени промени в {APP_NAME}.<br /><br />Кой вариант искате да запазите?",
    "EXT_DELETED_MESSAGE"               : "Файлът <span class='dialog-filename'>{0}</span> беше изтрит извън {APP_NAME}, но има незапазени промени в {APP_NAME}.<br /><br />Искате ли да запазите промените си?",

    // Generic dialog/button labels
    "DONE"                              : "Готово",
    "OK"                                : "Добре",
    "CANCEL"                            : "Отказ",
    "DONT_SAVE"                         : "Без запазване",
    "SAVE"                              : "Запазване",
    "SAVE_AS"                           : "Запазване като\u2026",
    "SAVE_AND_OVERWRITE"                : "Презаписване",
    "DELETE"                            : "Изтриване",
    "BUTTON_YES"                        : "Да",
    "BUTTON_NO"                         : "Не",

    // Find, Replace, Find in Files
    "FIND_MATCH_INDEX"                  : "{0} от {1}",
    "FIND_NO_RESULTS"                   : "Няма резултати",
    "FIND_QUERY_PLACEHOLDER"            : "Търсене\u2026",
    "REPLACE_PLACEHOLDER"               : "Замяна с\u2026",
    "BUTTON_REPLACE_ALL"                : "Група\u2026",
    "BUTTON_REPLACE_ALL_IN_FILES"       : "Замяна\u2026",
    "BUTTON_REPLACE"                    : "Замяна",
    "BUTTON_NEXT"                       : "\u25B6",
    "BUTTON_PREV"                       : "\u25C0",
    "BUTTON_NEXT_HINT"                  : "Следващо съвпадение",
    "BUTTON_PREV_HINT"                  : "Предишно съвпадение",
    "BUTTON_CASESENSITIVE_HINT"         : "Съвпадение на малки/големи букви",
    "BUTTON_REGEXP_HINT"                : "Регулярен израз",
    "REPLACE_WITHOUT_UNDO_WARNING_TITLE": "Замяна без възможност връщане",
    "REPLACE_WITHOUT_UNDO_WARNING"      : "Тъй като трябва да бъдат променени повече от {0} файла, {APP_NAME} ще промени и неотворените файлове направо в диска.<br />Няма да можете да отмените замените в тези файлове.",
    "BUTTON_REPLACE_WITHOUT_UNDO"       : "Замяна без връщане",

    "OPEN_FILE"                         : "Отваряне на файл",
    "SAVE_FILE_AS"                      : "Запазване на файл",
    "CHOOSE_FOLDER"                     : "Изберете папка",

    "RELEASE_NOTES"                     : "Бележки за изданието",
    "NO_UPDATE_TITLE"                   : "Актулно издание!",
    "NO_UPDATE_MESSAGE"                 : "Вие използвате най-новото издание на {APP_NAME}.",

    // Find and Replace
    "FIND_REPLACE_TITLE_LABEL"          : "Замяна на",
    "FIND_REPLACE_TITLE_WITH"           : "с",
    "FIND_TITLE_LABEL"                  : "Открито:",
    "FIND_TITLE_SUMMARY"                : "&mdash; {0} {1} {2} в {3}",

    // Find in Files
    "FIND_NUM_FILES"                    : "{0} {1}",
    "FIND_IN_FILES_SCOPED"              : "в <span class='dialog-filename'>{0}</span>",
    "FIND_IN_FILES_NO_SCOPE"            : "в проекта",
    "FIND_IN_FILES_ZERO_FILES"          : "Филтърът изключва всички файлове {0}",
    "FIND_IN_FILES_FILE"                : "файл",
    "FIND_IN_FILES_FILES"               : "файла",
    "FIND_IN_FILES_MATCH"               : "съвпадение",
    "FIND_IN_FILES_MATCHES"             : "съвпадения",
    "FIND_IN_FILES_MORE_THAN"           : "Над ",
    "FIND_IN_FILES_PAGING"              : "{0}&mdash;{1}",
    "FIND_IN_FILES_FILE_PATH"           : "<span class='dialog-filename'>{0}</span> {2} <span class='dialog-path'>{1}</span>", // We should use normal dashes on Windows instead of em dash eventually
    "FIND_IN_FILES_EXPAND_COLLAPSE"     : "Ctrl/Cmd + щракване за показване/скриване на всички",
    "FIND_IN_FILES_INDEXING"            : "Обработване за мигновено търсене\u2026",
    "REPLACE_IN_FILES_ERRORS_TITLE"     : "Грешки при замяната",
    "REPLACE_IN_FILES_ERRORS"           : "Следните файлове не бяха променени, тъй като те самите са били променени след търсенето, или не могат да бъдат записани.",

    "ERROR_FETCHING_UPDATE_INFO_TITLE"  : "Грешка при получаване на информацията за обновлението",
    "ERROR_FETCHING_UPDATE_INFO_MSG"    : "Възникна грешка при получаването на информацията за най-новото обновление от сървъра. Моля, уверете се, че имате връзка с Интернет, и опитайте отново.",

    // File exclusion filters
    "NEW_FILE_FILTER"                   : "Нов множество за изключване\u2026",
    "CLEAR_FILE_FILTER"                 : "Да не се изключват файлове",
    "NO_FILE_FILTER"                    : "Няма изключени файлове",
    "EXCLUDE_FILE_FILTER"               : "Изключване на {0}",
    "EDIT_FILE_FILTER"                  : "Редактиране\u2026",
    "FILE_FILTER_DIALOG"                : "Редактиране на множество за изключване",
    "FILE_FILTER_INSTRUCTIONS"          : "Изключете файловете и папките, отговарящи на следните низове/поднизове или <a href='{0}' title='{0}'>маски</a>. Въвеждайте всеки низ на нов ред.",
    "FILTER_NAME_PLACEHOLDER"           : "Въведете име за това множество (незадължително)",
    "FILE_FILTER_CLIPPED_SUFFIX"        : "и още {0}",
    "FILTER_COUNTING_FILES"             : "Броене на файловете\u2026",
    "FILTER_FILE_COUNT"                 : "Позволени са {0} от {1} файл(а) {2}",
    "FILTER_FILE_COUNT_ALL"             : "Позволени са всички {0} файл(а) {1}",

    // Quick Edit
    "ERROR_QUICK_EDIT_PROVIDER_NOT_FOUND"   : "Няма приложимо бързо редактиране за текущото местоположение на курсора.",
    "ERROR_CSSQUICKEDIT_BETWEENCLASSES"     : "Бързо редактиране на CSS: поставете курсора върху едно име на клас.",
    "ERROR_CSSQUICKEDIT_CLASSNOTFOUND"      : "Бързо редактиране на CSS: непълен атрибут на клас.",
    "ERROR_CSSQUICKEDIT_IDNOTFOUND"         : "Бързо редактиране на CSS: непълен атрибут на идентификатор.",
    "ERROR_CSSQUICKEDIT_UNSUPPORTEDATTR"    : "Бързо редактиране на CSS: поставете кърсора върху елемент, клас или идентификатор.",
    "ERROR_TIMINGQUICKEDIT_INVALIDSYNTAX"   : "Бързо редактиране на времева функция в CSS: грешен синтаксис.",
    "ERROR_JSQUICKEDIT_FUNCTIONNOTFOUND"    : "Бързо редактиране на JS: поставете курсора върху име на функция.",

    // Quick Docs
    "ERROR_QUICK_DOCS_PROVIDER_NOT_FOUND"   : "Няма бързи документи за текущото местоположение на курсора.",

    /**
     * ProjectManager
     */
    "PROJECT_LOADING"   : "Зареждане\u2026",
    "UNTITLED"          : "Неозаглавен",
    "WORKING_FILES"     : "Работни файлове",

    /**
     * MainViewManager
     */
    "TOP"               : "Горе",
    "BOTTOM"            : "Долу",
    "LEFT"              : "Ляво",
    "RIGHT"             : "Дясно",

    "CMD_SPLITVIEW_NONE"        : "Без разделяне",
    "CMD_SPLITVIEW_VERTICAL"    : "Вертикално разделяне",
    "CMD_SPLITVIEW_HORIZONTAL"  : "Хоризонтално разделяне",
    "SPLITVIEW_MENU_TOOLTIP"    : "Вертикално или хоризонтално разделяне на редактора",
    "GEAR_MENU_TOOLTIP"         : "Настройки за работните файлове",

    "SPLITVIEW_INFO_TITLE"              : "Вече е отворен",
    "SPLITVIEW_MULTIPANE_WARNING"       : "Файлът вече е отворен в друг раздел. {APP_NAME} скоро ще поддържа отварянето на един и същ файл в повече от един раздел. Дотогава файлът ще бъде показван само в раздела, в който вече е отворен.<br /><br />(Това съобщение се появява само веднъж.)",

    /**
     * Keyboard modifiers and special key names
     */
    "KEYBOARD_CTRL"         : "Ctrl",
    "KEYBOARD_SHIFT"        : "Shift",
    "KEYBOARD_SPACE"        : "Space",
    "KEYBOARD_PAGE_UP"      : "Page Up",
    "KEYBOARD_PAGE_DOWN"    : "Page Down",
    "KEYBOARD_HOME"         : "Home",
    "KEYBOARD_END"          : "End",
    "KEYBOARD_INSERT"       : "Insert",
    "KEYBOARD_DELETE"       : "Delete",

    /**
     * StatusBar strings
     */
    "STATUSBAR_CURSOR_POSITION"             : "Ред {0}, колона {1}",
    "STATUSBAR_SELECTION_CH_SINGULAR"       : " \u2014 Избрана е {0} колона",
    "STATUSBAR_SELECTION_CH_PLURAL"         : " \u2014 Избрани са {0} колони",
    "STATUSBAR_SELECTION_LINE_SINGULAR"     : " \u2014 Избран е {0} ред",
    "STATUSBAR_SELECTION_LINE_PLURAL"       : " \u2014 Избрани са {0} реда",
    "STATUSBAR_SELECTION_MULTIPLE"          : " \u2014 {0} избора",
    "STATUSBAR_INDENT_TOOLTIP_SPACES"       : "Щракнете, за да превърнете отстъпите в интервали",
    "STATUSBAR_INDENT_TOOLTIP_TABS"         : "Щракнете, за да превърнете отстъпите в табулации",
    "STATUSBAR_INDENT_SIZE_TOOLTIP_SPACES"  : "Щракнете, за да промените броя интервали, използвани при отстъпите",
    "STATUSBAR_INDENT_SIZE_TOOLTIP_TABS"    : "Щракнете, за да промените ширината на табулатора в брой знаци",
    "STATUSBAR_SPACES"                      : "Интервали:",
    "STATUSBAR_TAB_SIZE"                    : "Табулация с размер:",
    "STATUSBAR_LINE_COUNT_SINGULAR"         : "\u2014 {0} ред",
    "STATUSBAR_LINE_COUNT_PLURAL"           : "\u2014 {0} реда",
    "STATUSBAR_USER_EXTENSIONS_DISABLED"    : "Разширенията са изключени",
    "STATUSBAR_INSERT"                      : "ВМК",
    "STATUSBAR_OVERWRITE"                   : "ЗАМ",
    "STATUSBAR_INSOVR_TOOLTIP"              : "Щракнете, за да превключите поведените на курсора между вмъкване (ВМК) и заместване (ЗАМ)",
    "STATUSBAR_LANG_TOOLTIP"                : "Щракнете, за да промените типа на файла",
    "STATUSBAR_CODE_INSPECTION_TOOLTIP"     : "{0}. Щракнете, за да превключите панела да доклади.",
    "STATUSBAR_DEFAULT_LANG"                : "(по подразбиране)",
    "STATUSBAR_SET_DEFAULT_LANG"            : "Задаване по подразбиране за файлове с разширение .{0}",

    // CodeInspection: errors/warnings
    "ERRORS_PANEL_TITLE_MULTIPLE"           : "Проблеми от {0}",
    "SINGLE_ERROR"                          : "1 проблем от {0} ",
    "MULTIPLE_ERRORS"                       : "{1} проблема от {0}",
    "NO_ERRORS"                             : "Не са открити проблеми от {0} — добра работа!",
    "NO_ERRORS_MULTIPLE_PROVIDER"           : "Не са открити проблеми — добра работа!",
    "LINT_DISABLED"                         : "Проверката е изключена",
    "NO_LINT_AVAILABLE"                     : "Няма налични системи за проверка на {0}",
    "NOTHING_TO_LINT"                       : "Няма нищо за проверка",
    "LINTER_TIMED_OUT"                      : "Времето на {0} изтече след като чака {1} милисекунди",
    "LINTER_FAILED"                         : "{0} приключи с грешка: {1}",

    /**
     * Command Name Constants
     */

    // File menu commands
    "FILE_MENU"                           : "Файл",
    "CMD_FILE_NEW_UNTITLED"               : "Нов",
    "CMD_FILE_NEW"                        : "Нов файл",
    "CMD_FILE_NEW_FOLDER"                 : "Нова папка",
    "CMD_FILE_OPEN"                       : "Отваряне\u2026",
    "CMD_ADD_TO_WORKING_SET"              : "Отваряне в работните файлове",
    "CMD_OPEN_DROPPED_FILES"              : "Отваряне на пуснати файлове",
    "CMD_OPEN_FOLDER"                     : "Отваряне на папка\u2026",
    "CMD_FILE_CLOSE"                      : "Затваряне",
    "CMD_FILE_CLOSE_ALL"                  : "Затваряне на всички",
    "CMD_FILE_CLOSE_LIST"                 : "Затваряне на списък",
    "CMD_FILE_CLOSE_OTHERS"               : "Затваряне на останалите",
    "CMD_FILE_CLOSE_ABOVE"                : "Затваряне на всички отгоре",
    "CMD_FILE_CLOSE_BELOW"                : "Затваряне на всички отдолу",
    "CMD_FILE_SAVE"                       : "Запазване",
    "CMD_FILE_SAVE_ALL"                   : "Запазване на всички",
    "CMD_FILE_SAVE_AS"                    : "Запазване като\u2026",
    "CMD_LIVE_FILE_PREVIEW"               : "Преглед на живо",
    "CMD_TOGGLE_LIVE_PREVIEW_MB_MODE"     : "Включване на експерименталния преглед на живо",
    "CMD_RELOAD_LIVE_PREVIEW"             : "Презареждане на прегледа на живо насила",
    "CMD_PROJECT_SETTINGS"                : "Настройки на проекта\u2026",
    "CMD_FILE_RENAME"                     : "Преименуване",
    "CMD_FILE_DELETE"                     : "Изтриване",
    "CMD_INSTALL_EXTENSION"               : "Инсталиране на разширение\u2026",
    "CMD_EXTENSION_MANAGER"               : "Управител на разширения\u2026",
    "CMD_FILE_REFRESH"                    : "Опресняване на дървото от файлове",
    "CMD_QUIT"                            : "Изход",
    // Used in native File menu on Windows
    "CMD_EXIT"                            : "Изход",

    // Edit menu commands
    "EDIT_MENU"                           : "Редактиране",
    "CMD_UNDO"                            : "Отмяна",
    "CMD_REDO"                            : "Повторение",
    "CMD_CUT"                             : "Отрязване",
    "CMD_COPY"                            : "Копиране",
    "CMD_PASTE"                           : "Поставяне",
    "CMD_SELECT_ALL"                      : "Избиране на всичко",
    "CMD_SELECT_LINE"                     : "Избиране на ред",
    "CMD_SPLIT_SEL_INTO_LINES"            : "Разделяне на избраното на редове",
    "CMD_ADD_CUR_TO_NEXT_LINE"            : "Добавяне на курсор на следващия ред",
    "CMD_ADD_CUR_TO_PREV_LINE"            : "Добавяне на курсор на предишния ред",
    "CMD_INDENT"                          : "Увеличаване на отстъпа",
    "CMD_UNINDENT"                        : "Намаляване на отстъпа",
    "CMD_DUPLICATE"                       : "Копие на реда",
    "CMD_DELETE_LINES"                    : "Изтриване на реда",
    "CMD_COMMENT"                         : "Превключване на коментар на реда",
    "CMD_BLOCK_COMMENT"                   : "Превключване на коментар на блок",
    "CMD_LINE_UP"                         : "Преместване на реда нагоре",
    "CMD_LINE_DOWN"                       : "Преместване на реда надолу",
    "CMD_OPEN_LINE_ABOVE"                 : "Нов ред отгоре",
    "CMD_OPEN_LINE_BELOW"                 : "Нов ред отдолу",
    "CMD_TOGGLE_CLOSE_BRACKETS"           : "Автоматично затваряне на скобите",
    "CMD_SHOW_CODE_HINTS"                 : "Показване на подсказки за кода",

    // Search menu commands
    "FIND_MENU"                           : "Търсене",
    "CMD_FIND"                            : "Търсене",
    "CMD_FIND_NEXT"                       : "Търсене на следващото",
    "CMD_FIND_PREVIOUS"                   : "Търсене на предишното",
    "CMD_FIND_ALL_AND_SELECT"             : "Търсене на всичко и избиране",
    "CMD_ADD_NEXT_MATCH"                  : "Добавяне на следващото съвпадение към избора",
    "CMD_SKIP_CURRENT_MATCH"              : "Пропускане и добавяне на следващото съвпадение",
    "CMD_FIND_IN_FILES"                   : "Търсене във файлове",
    "CMD_FIND_IN_SUBTREE"                 : "Търсене в\u2026",
    "CMD_REPLACE"                         : "Замяна",
    "CMD_REPLACE_IN_FILES"                : "Замяна във файлове",
    "CMD_REPLACE_IN_SUBTREE"              : "Замяна в\u2026",

    // View menu commands
    "VIEW_MENU"                           : "Преглед",
    "CMD_HIDE_SIDEBAR"                    : "Скриване на страничната лента",
    "CMD_SHOW_SIDEBAR"                    : "Показване на страничната лента",
    "CMD_TOGGLE_SIDEBAR"                  : "Превключване на страничната лента",
    "CMD_TOGGLE_PANELS"                   : "Превключване на панелите",
    "CMD_TOGGLE_PURE_CODE"                : "Без разсейвания",
    "CMD_INCREASE_FONT_SIZE"              : "Увеличаване на размера на шрифта",
    "CMD_DECREASE_FONT_SIZE"              : "Намаляване на размера на шрифта",
    "CMD_RESTORE_FONT_SIZE"               : "Възстановяване на размера на шрифта",
    "CMD_SCROLL_LINE_UP"                  : "Превъртане един ред нагоре",
    "CMD_SCROLL_LINE_DOWN"                : "Превъртане един ред надолу",
    "CMD_TOGGLE_LINE_NUMBERS"             : "Номера на редове",
    "CMD_TOGGLE_ACTIVE_LINE"              : "Осветяване на текущия ред",
    "CMD_TOGGLE_WORD_WRAP"                : "Пренасяне",
    "CMD_LIVE_HIGHLIGHT"                  : "Осветяване на прегледа на живо",
    "CMD_VIEW_TOGGLE_INSPECTION"          : "Проверка на файловете при запазване",
    "CMD_WORKINGSET_SORT_BY_ADDED"        : "Подреждане по ред на добавяне",
    "CMD_WORKINGSET_SORT_BY_NAME"         : "Подреждане по име",
    "CMD_WORKINGSET_SORT_BY_TYPE"         : "Подреждане по тип",
    "CMD_WORKING_SORT_TOGGLE_AUTO"        : "Автоматично подреждане",
    "CMD_THEMES"                          : "Теми\u2026",

    // Navigate menu commands
    "NAVIGATE_MENU"                       : "Придвижване",
    "CMD_QUICK_OPEN"                      : "Бързо отваряне",
    "CMD_GOTO_LINE"                       : "Отиване на ред",
    "CMD_GOTO_DEFINITION"                 : "Бързо търсене на определение",
    "CMD_GOTO_FIRST_PROBLEM"              : "Преминаване към първия проблем",
    "CMD_TOGGLE_QUICK_EDIT"               : "Бързо редактиране",
    "CMD_TOGGLE_QUICK_DOCS"               : "Бърза документация",
    "CMD_QUICK_EDIT_PREV_MATCH"           : "Предишно съвпадение",
    "CMD_QUICK_EDIT_NEXT_MATCH"           : "Следващо съвпадение",
    "CMD_CSS_QUICK_EDIT_NEW_RULE"         : "Ново правило",
    "CMD_NEXT_DOC"                        : "Следващ документ",
    "CMD_PREV_DOC"                        : "Предишен документ",
    "CMD_NEXT_DOC_LIST_ORDER"             : "Следващ документ в списъка",
    "CMD_PREV_DOC_LIST_ORDER"             : "Предишен документ в списъка",
    "CMD_SHOW_IN_TREE"                    : "Показване в дървото на файловете",
    "CMD_SHOW_IN_EXPLORER"                : "Показване в Explorer",
    "CMD_SHOW_IN_FINDER"                  : "Показване във Finder",
    "CMD_SHOW_IN_OS"                      : "Показване в ОС",

    // Help menu commands
    "HELP_MENU"                           : "Помощ",
    "CMD_CHECK_FOR_UPDATE"                : "Проверка за обновления",
    "CMD_HOW_TO_USE_BRACKETS"             : "Как се използва {APP_NAME}",
    "CMD_SUPPORT"                         : "Поддръжка на {APP_NAME}",
    "CMD_SUGGEST"                         : "Предложете функционалност",
    "CMD_RELEASE_NOTES"                   : "Бележки за изданието",
    "CMD_GET_INVOLVED"                    : "Включете се",
    "CMD_SHOW_EXTENSIONS_FOLDER"          : "Показване на папката с разширенията",
    "CMD_HEALTH_DATA_STATISTICS"          : "Здравен доклад",
    "CMD_HOMEPAGE"                        : "Начална страница на {APP_TITLE}",
    "CMD_TWITTER"                         : "{TWITTER_NAME} в Тиутър",
    "CMD_ABOUT"                           : "Относно {APP_TITLE}",
    "CMD_OPEN_PREFERENCES"                : "Отваряне на файла с настройките",
    "CMD_OPEN_KEYMAP"                     : "Отваряне на файла с потребителските клавишни настройки",

    // Strings for main-view.html
    "EXPERIMENTAL_BUILD"                   : "експериментална компилация",
    "RELEASE_BUILD"                        : "компилация",
    "DEVELOPMENT_BUILD"                    : "компилация за разработчици",
    "RELOAD_FROM_DISK"                     : "Презареждане от диска",
    "KEEP_CHANGES_IN_EDITOR"               : "Използване на промените в редактора",
    "CLOSE_DONT_SAVE"                      : "Затваряне (без запазване)",
    "RELAUNCH_CHROME"                      : "Повторно пускане на Chrome",
    "ABOUT"                                : "Относно",
    "CLOSE"                                : "Затваряне",
    "ABOUT_TEXT_LINE1"                     : "Издание {VERSION_MAJOR}.{VERSION_MINOR} {BUILD_TYPE} {VERSION}",
    "ABOUT_TEXT_BUILD_TIMESTAMP"           : "дата на компилиране: ",
    "ABOUT_TEXT_LINE3"                     : "Бележките, правата и условията, свързани с използването на софтуер от трети страни, могат да бъдат открити на <a href='{ADOBE_THIRD_PARTY}'>{ADOBE_THIRD_PARTY}</a> и смятани за включени тук.",
    "ABOUT_TEXT_LINE4"                     : "Документацията и изходният код могат да бъдат открити тук: <a href='https://github.com/adobe/brackets/'>https://github.com/adobe/brackets/</a>",
    "ABOUT_TEXT_LINE5"                     : "Създадено с \u2764 и JavaScript от:",
    "ABOUT_TEXT_LINE6"                     : "Много хора (но в момента не може да заредим данните за тях).",
    "ABOUT_TEXT_WEB_PLATFORM_DOCS"         : "Документацията и логото на платформата за уеб приложения са лицензирани под лиценз за признание от вида „Криейтив Комънс“: <a href='{WEB_PLATFORM_DOCS_LICENSE}'>CC-BY 3.0 Нелокализиран</a>.",
    "UPDATE_NOTIFICATION_TOOLTIP"          : "Има ново издание на {APP_NAME}! Щракнете тук за подробности.",
    "UPDATE_AVAILABLE_TITLE"               : "Има ново обновление",
    "UPDATE_MESSAGE"                       : "Хей, има ново издание на {APP_NAME}. Ето някои от новите функционалности:",
    "GET_IT_NOW"                           : "Вземете го сега!",
    "PROJECT_SETTINGS_TITLE"               : "Настройки на проекта за: {0}",
    "PROJECT_SETTING_BASE_URL"             : "Базов адрес за преглед на живо",
    "PROJECT_SETTING_BASE_URL_HINT"        : "За да използвате местен сървър, въведете адрес като: http://localhost:8000/",
    "BASEURL_ERROR_INVALID_PROTOCOL"       : "Протоколът {0} не се поддържа от прегледа на живо &mdash; моля, използвайте „http:“ или „https:“.",
    "BASEURL_ERROR_SEARCH_DISALLOWED"      : "Базовият адрес не може да съдържа параметри за търсене като „{0}“.",
    "BASEURL_ERROR_HASH_DISALLOWED"        : "Базовият адрес не може да съдържа диези като „{0}“.",
    "BASEURL_ERROR_INVALID_CHAR"           : "Специалните знаци като „{0}“ трябва да бъдат кодирани с „%“.",
    "BASEURL_ERROR_UNKNOWN_ERROR"          : "Възникна неизвестна грешка при обработката на базовия адрес.",

    // Strings for Pane.js
    "EMPTY_VIEW_HEADER"                    : "<em>Отворете файл, докато този раздел е на фокус</em>",
    "FLIPVIEW_BTN_TOOLTIP"                 : "Прехвърляне на този изглед към раздела „{0}“.",

    // Strings for themes-settings.html and themes-general.html
    "CURRENT_THEME"                        : "Текуща тема",
    "USE_THEME_SCROLLBARS"                 : "Използване на лентите за превъртане от темата",
    "FONT_SIZE"                            : "Размер на шрифта",
    "FONT_FAMILY"                          : "Семейство на шрифта",
    "THEMES_SETTINGS"                      : "Настройки на темите",

    // CSS Quick Edit
    "BUTTON_NEW_RULE"                      : "Ново правило",

    // Extension Management strings
    "INSTALL"                              : "Инсталиране",
    "UPDATE"                               : "Обновяване",
    "REMOVE"                               : "Премахване",
    "DISABLE"                              : "Изключване",
    "ENABLE"                               : "Включване",
    "OVERWRITE"                            : "Презаписване",
    "CANT_REMOVE_DEV"                      : "Разширенията в папката „dev“ трябва да бъдат изтрити ръчно.",
    "CANT_UPDATE"                          : "Обновлението не е съвместимо с това издание на {APP_NAME}.",
    "CANT_UPDATE_DEV"                      : "Разширенията в папката „dev“ не могат да бъдат обновени автоматично.",
    "INSTALL_EXTENSION_TITLE"              : "Инсталиране на разширение",
    "UPDATE_EXTENSION_TITLE"               : "Обновяване на разширение",
    "INSTALL_EXTENSION_LABEL"              : "Адрес на разширението",
    "INSTALL_EXTENSION_HINT"               : "Адресът на архивния файл на разширението или хранилището му в GitHub",
    "INSTALLING_FROM"                      : "Инсталиране на разширение от {0}\u2026",
    "INSTALL_SUCCEEDED"                    : "Инсталирането беше успешно!",
    "INSTALL_FAILED"                       : "Инсталирането се провали.",
    "CANCELING_INSTALL"                    : "Отказване\u2026",
    "CANCELING_HUNG"                       : "Отказването на инсталирането отнема много време. Може да е възникнала вътрешна грешка.",
    "INSTALL_CANCELED"                     : "Инсталирането беше отказано.",
    "VIEW_COMPLETE_DESCRIPTION"            : "Преглед на пълното описание",
    "VIEW_TRUNCATED_DESCRIPTION"           : "Преглед на съкратеното описание",
    // These must match the error codes in ExtensionsDomain.Errors.* :
    "INVALID_ZIP_FILE"                     : "Сваленото съдържание не е правилен архивен файл във формата „zip“.",
    "INVALID_PACKAGE_JSON"                 : "Файлът „package.json“ не е правилно форматиран (грешката е: {0}).",
    "MISSING_PACKAGE_NAME"                 : "Файлът „package.json“ не указва името на пакета.",
    "BAD_PACKAGE_NAME"                     : "{0} не е правилно име на пакет.",
    "MISSING_PACKAGE_VERSION"              : "Файлът „package.json“ не указва версията на пакета.",
    "INVALID_VERSION_NUMBER"               : "Версията на пакета ({0}) е грешна.",
    "INVALID_BRACKETS_VERSION"             : "Низът за съвместимост ({0}) с {APP_NAME} е грешен.",
    "DISALLOWED_WORDS"                     : "Думите ({1}) не са позволени в полето {0}.",
    "API_NOT_COMPATIBLE"                   : "Разширението не е съвместимо с това издание на {APP_NAME}. То е инсталирано във Вашата папка с изключени разширения.",
    "MISSING_MAIN"                         : "В пакета няма файл „main.js“.",
    "EXTENSION_ALREADY_INSTALLED"          : "Инсталирането на този пакет ще презапише друго, вече инсталирано разширение. Искате ли да презапишете старото разширение?",
    "EXTENSION_SAME_VERSION"               : "Този пакет има същата версия като вече инсталирания. Искате ли да презапишете текущата инсталация?",
    "EXTENSION_OLDER_VERSION"              : "Този пакет има версия {0}, която е по-стара от текущо инсталираната ({1}). Искате ли да презапишете текущата инсталация?",
    "DOWNLOAD_ID_IN_USE"                   : "Вътрешна грешка: идентификатора на свалянето вече е зает.",
    "NO_SERVER_RESPONSE"                   : "Неуспешна връзка със сървъра.",
    "BAD_HTTP_STATUS"                      : "Файлът не е открит на сървъра (HTTP {0}).",
    "CANNOT_WRITE_TEMP"                    : "Неуспешно запазване на свалянето като временен файл.",
    "ERROR_LOADING"                        : "Това разширение имаше грешка при стартирането си.",
    "MALFORMED_URL"                        : "Адресът е грешен. Моля, проверете дали сте го въвели правилно.",
    "UNSUPPORTED_PROTOCOL"                 : "Адресът трябва да бъде от вида „http“ или „https“.",
    "UNKNOWN_ERROR"                        : "Неизвестна вътрешна грешка.",
    // For NOT_FOUND_ERR, see generic strings above
    "EXTENSION_MANAGER_TITLE"              : "Управител на разширенията",
    "EXTENSION_MANAGER_ERROR_LOAD"         : "Неуспешен достъп до регистъра на разширенията. Моля, опитайте отново по-късно.",
    "INSTALL_EXTENSION_DRAG"               : "Завлачете .zip тук или",
    "INSTALL_EXTENSION_DROP"               : "Пуснете .zip за инсталиране",
    "INSTALL_EXTENSION_DROP_ERROR"         : "Инсталирането/обновяването беше прекъснато поради следните грешки:",
    "INSTALL_FROM_URL"                     : "Инсталирайте от адрес\u2026",
    "INSTALL_EXTENSION_VALIDATING"         : "Проверка\u2026",
    "EXTENSION_AUTHOR"                     : "Автор",
    "EXTENSION_DATE"                       : "Дата",
    "EXTENSION_INCOMPATIBLE_NEWER"         : "Това разширение изисква по-ново издание на {APP_NAME}.",
    "EXTENSION_INCOMPATIBLE_OLDER"         : "Това разширение в момента работи само с по-стари издания на {APP_NAME}.",
    "EXTENSION_LATEST_INCOMPATIBLE_NEWER"  : "Версия {0} на това разширение изисква по-ново издание на {APP_NAME}. Но можете да инсталирате по-старата версия {1}.",
    "EXTENSION_LATEST_INCOMPATIBLE_OLDER"  : "Версия {0} на това разширение работи само с по-стари издания на {APP_NAME}. Но можете да инсталирате по-старата версия {1}.",
    "EXTENSION_NO_DESCRIPTION"             : "Няма описание",
    "EXTENSION_MORE_INFO"                  : "Още\u2026",
    "EXTENSION_ERROR"                      : "Грешка на разширението",
    "EXTENSION_KEYWORDS"                   : "Ключови думи",
    "EXTENSION_TRANSLATED_USER_LANG"       : "Разширението е преведено на {0} езика, включително Вашия.",
    "EXTENSION_TRANSLATED_GENERAL"         : "Разширението е преведено на {0} езика",
    "EXTENSION_TRANSLATED_LANGS"           : "Това разширение е преведено на следните езици: {0}",
    "EXTENSION_INSTALLED"                  : "Инсталирано",
    "EXTENSION_UPDATE_INSTALLED"           : "Обновлението за това разширение е било свалено и ще бъде инсталирано след като {APP_NAME} се презареди.",
    "EXTENSION_SEARCH_PLACEHOLDER"         : "Търсене",
    "EXTENSION_MORE_INFO_LINK"             : "Още",
    "BROWSE_EXTENSIONS"                    : "Преглед на разширенията",
    "EXTENSION_MANAGER_REMOVE"             : "Премахване на разширението",
    "EXTENSION_MANAGER_REMOVE_ERROR"       : "Неуспешно премахване на едно или повече разширения: {0}. {APP_NAME} все пак ще се презареди.",
    "EXTENSION_MANAGER_UPDATE"             : "Обновяване на разширението",
    "EXTENSION_MANAGER_UPDATE_ERROR"       : "Неуспешно обновяване на едно или повече разширения: {0}. {APP_NAME} все пак ще се презареди.",
    "EXTENSION_MANAGER_DISABLE"            : "Изключване на разширението",
    "EXTENSION_MANAGER_DISABLE_ERROR"      : "Неуспешно изключване на едно или повече разширения: {0}. {APP_NAME} все пак ще се презареди.",
    "MARKED_FOR_REMOVAL"                   : "Отбелязано за премахване",
    "UNDO_REMOVE"                          : "Отмяна",
    "MARKED_FOR_UPDATE"                    : "Отбелязано за обновяване",
    "UNDO_UPDATE"                          : "Отмяна",
    "MARKED_FOR_DISABLING"                 : "Отбелязано за изключване",
    "UNDO_DISABLE"                         : "Отмяна",
    "CHANGE_AND_RELOAD_TITLE"              : "Промяна на разширенията",
    "CHANGE_AND_RELOAD_MESSAGE"            : "За да обновите, премахнете или изключите отбелязаните разширения, {APP_NAME} ще трябва да се презареди. Ако имате незапазени промени, ще Ви бъде предложено да ги запазите.",
    "REMOVE_AND_RELOAD"                    : "Премахване на разширенията и презареждане",
    "CHANGE_AND_RELOAD"                    : "Промяна на разширенията и презареждане",
    "UPDATE_AND_RELOAD"                    : "Обновяване на разширенията и презареждане",
    "DISABLE_AND_RELOAD"                   : "Изключване на разширенията и презареждане",
    "PROCESSING_EXTENSIONS"                : "Обработване на промените по разширенията\u2026",
    "EXTENSION_NOT_INSTALLED"              : "Разширението {0} не може да бъде премахнато, тъй като не е инсталирано.",
    "NO_EXTENSIONS"                        : "Все още няма инсталирани разширения.<br>Изберете раздела с наличните разширения отгоре, за да започнете.",
    "NO_EXTENSION_MATCHES"                 : "Няма разширения, отговарящи на търсенето Ви.",
    "REGISTRY_SANITY_CHECK_WARNING"        : "ЗАБЕЛЕЖКА: Тези разширения може да са предоставени от различни автори, които не са свързани с {APP_NAME}. Разширенията не преминават никакви проверки и имат пълен достъп до местните Ви файлове. Внимавайте, когато инсталирате разширения от неизвестни източници.",
    "EXTENSIONS_INSTALLED_TITLE"           : "Инсталирани",
    "EXTENSIONS_AVAILABLE_TITLE"           : "Налични",
    "EXTENSIONS_THEMES_TITLE"              : "Теми",
    "EXTENSIONS_UPDATES_TITLE"             : "Обновления",

    "INLINE_EDITOR_NO_MATCHES"             : "Няма съвпадения.",
    "INLINE_EDITOR_HIDDEN_MATCHES"         : "Всички съвпадения бяха свити. Разширете файловете, изредени вдясно, за да видите съвпаденията.",
    "CSS_QUICK_EDIT_NO_MATCHES"            : "Няма съществуващи правила за CSS, които да отговарят на избора Ви.<br> Натиснете „Ново правило“, за да създадете такова.",
    "CSS_QUICK_EDIT_NO_STYLESHEETS"        : "В проекта Ви няма стилови файлове.<br>Създайте поне един, за да добавите правила за CSS.",

    // Custom Viewers
    "IMAGE_VIEWER_LARGEST_ICON"            : "най-голямо",

    /**
     * Unit names
     */
    "UNIT_PIXELS"                          : "пиксели",

    // extensions/default/DebugCommands
    "DEBUG_MENU"                                : "Разработка",
    "ERRORS"                                    : "Грешки",
    "CMD_SHOW_DEV_TOOLS"                        : "Показване на инструментите за разработчици",
    "CMD_REFRESH_WINDOW"                        : "Презареждане с разширения",
    "CMD_RELOAD_WITHOUT_USER_EXTS"              : "Презареждане без разширения",
    "CMD_NEW_BRACKETS_WINDOW"                   : "Нов прозорец на {APP_NAME}",
    "CMD_LAUNCH_SCRIPT_MAC"                     : "Инсталиране на пряк път за командния ред",
    "CMD_SWITCH_LANGUAGE"                       : "Смяна на езика",
    "CMD_RUN_UNIT_TESTS"                        : "Пускане на тестовете",
    "CMD_SHOW_PERF_DATA"                        : "Показване на данните за производителността",
    "CMD_ENABLE_NODE_DEBUGGER"                  : "Включване на отстраняването на грешки за Node",
    "CMD_LOG_NODE_STATE"                        : "Извеждане на състоянието на Node в конзолата",
    "CMD_RESTART_NODE"                          : "Рестартиране на Node",
    "CMD_SHOW_ERRORS_IN_STATUS_BAR"             : "Показване на грешките в лентата на състоянието",
    "CMD_OPEN_BRACKETS_SOURCE"                  : "Отваряне на изходния код на {APP_NAME}",

    "CREATING_LAUNCH_SCRIPT_TITLE"              : "Пряк път към {APP_NAME} за командния ред",
    "ERROR_CREATING_LAUNCH_SCRIPT"              : "Възникна грешка при инсталирането на прекия път за командния ред. Моля, прегледайте <a href='https://github.com/adobe/brackets/wiki/Command-Line-Arguments#troubleshooting'>тези съвети за отстраняване на проблемите</a>.<br/><br/>Причина: {0}",
    "ERROR_CLTOOLS_RMFAILED"                    : "Неуспешно премахване на съществуващата символна връзка <code>/usr/local/bin/brackets</code> .",
    "ERROR_CLTOOLS_MKDIRFAILED"                 : "Неуспешно създаване на папката <code>/usr/local/bin</code> .",
    "ERROR_CLTOOLS_LNFAILED"                    : "Неуспешно създаване на символната връзка <code>/usr/local/bin/brackets</code> .",
    "ERROR_CLTOOLS_SERVFAILED"                  : "Вътрешна грешка.",
    "ERROR_CLTOOLS_NOTSUPPORTED"                : "Тази ОС не поддържа преки пътища за команден ред.",
    "LAUNCH_SCRIPT_CREATE_SUCCESS"              : "Готово! Вече можете да пускате {APP_NAME} лесно от командния ред чрез: <code>brackets файл.txt</code> за отваряне на файл или <code>brackets папка</code> за промяна на проекта. <br/><br/><a href='https://github.com/adobe/brackets/wiki/Command-Line-Arguments'>Научете повече</a> относно използването на {APP_NAME} от командния ред.",

    "LANGUAGE_TITLE"                            : "Смяна на езика",
    "LANGUAGE_MESSAGE"                          : "Език:",
    "LANGUAGE_SUBMIT"                           : "Презареждане на {APP_NAME}",
    "LANGUAGE_CANCEL"                           : "Отказ",
    "LANGUAGE_SYSTEM_DEFAULT"                   : "По подразбиране",

    // extensions/default/HealthData
    "HEALTH_DATA_NOTIFICATION"                  : "Предпочитания за здравния доклад",
    "HEALTH_FIRST_POPUP_TITLE"                  : "Здравен доклад на {APP_NAME}",
    "HEALTH_DATA_DO_TRACK"                      : "Искам да споделям информация за това как използвам {APP_NAME}",
    "HEALTH_DATA_NOTIFICATION_MESSAGE"          : "С цел подобряване на {APP_NAME}, ни периодично изпращаме ограничено количество, <strong>анонимни</strong> данни до Adobe относно това как използвате {APP_NAME}. Тази информация ни помога да преценим кои функционалности са най-важни, да откриваме проблеми и забелязваме неудобства при ползването.<br><br>Можете да видите своите данни или да изберете да не ги споделяте с нас, като изберете <strong>Помощ > Здравен доклад</strong>.<br><br><a href='https://github.com/adobe/brackets/wiki/Health-Data'>Нучете повече относно здравния доклад на {APP_NAME}</a>",
    "HEALTH_DATA_PREVIEW"                       : "Здравен доклад на {APP_NAME}",
    "HEALTH_DATA_PREVIEW_INTRO"                 : "<p>С цел подобряване на {APP_NAME}, ни периодично изпращаме ограничено количество, <strong>анонимни</strong> данни до Adobe относно това как използвате {APP_NAME}. Тази информация ни помога да преценим кои функционалности са най-важни, да откриваме проблеми и забелязваме неудобства при ползването. <a href='https://github.com/adobe/brackets/wiki/Health-Data'>Нучете повече относно здравния доклад на {APP_NAME}</a> и как той е в полза на общността на {APP_NAME}, както и защитава личните Ви данни.</p><p>По-долу виждате преглед на данните, които ще бъдат изпратени в следващия Ви здравен доклад, <em>ако</em> той е включен.</p>",

    // extensions/default/InlineTimingFunctionEditor
    "INLINE_TIMING_EDITOR_TIME"                 : "Време",
    "INLINE_TIMING_EDITOR_PROGRESSION"          : "Напредък",
    "BEZIER_EDITOR_INFO"                        : "<kbd>↑</kbd><kbd>↓</kbd><kbd>←</kbd><kbd>→</kbd> Преместване на избраната точка<br><kbd class='text'>Shift</kbd> Преместване с десет единици<br><kbd class='text'>Tab</kbd> Превключване на точката",
    "STEPS_EDITOR_INFO"                         : "<kbd>↑</kbd><kbd>↓</kbd> Увеличаване или намаляване на стъпките<br><kbd>←</kbd><kbd>→</kbd> „Начало“ или „Край“",
    "INLINE_TIMING_EDITOR_INVALID"              : "Старата стойност <code>{0}</code> не е правилна, така че показаната функция беше променена на <code>{1}</code>. Документът ще бъде обновен при първата редакция.",

    // extensions/default/InlineColorEditor
    "COLOR_EDITOR_CURRENT_COLOR_SWATCH_TIP"     : "Текущ цвят",
    "COLOR_EDITOR_ORIGINAL_COLOR_SWATCH_TIP"    : "Оригинален цвят",
    "COLOR_EDITOR_RGBA_BUTTON_TIP"              : "Формат ЧЗСа",
    "COLOR_EDITOR_HEX_BUTTON_TIP"               : "Шестнадесетичен формат",
    "COLOR_EDITOR_HSLA_BUTTON_TIP"              : "Формат тон-насищане-осветеност",
    "COLOR_EDITOR_USED_COLOR_TIP_SINGULAR"      : "{0} (използван {1} път)",
    "COLOR_EDITOR_USED_COLOR_TIP_PLURAL"        : "{0} (използван {1} пъти)",

    // extensions/default/JavaScriptCodeHints
    "CMD_JUMPTO_DEFINITION"                     : "Към определението",
    "CMD_SHOW_PARAMETER_HINT"                   : "Показване на подсказката за параметрите",
    "NO_ARGUMENTS"                              : "<няма параметри>",
    "DETECTED_EXCLUSION_TITLE"                  : "Проблем с файл с код на JavaScript",
    "DETECTED_EXCLUSION_INFO"                   : "{APP_NAME} имаше проблем при обработката на <span class='dialog-filename'>{0}</span>.<br><br>Този файл няма повече да бъде проучван за подсказки за кода, преминаване към определения или бързо редактиране. За да включите този файл отново, отворете файла <code>.brackets.json</code> в проекта си и редактирайте секцията <code>jscodehints.detectedExclusions</code>.<br><br>Най-вероятно проблемът е в {APP_NAME}. Ако можете да изпратите този файл, моля <a href='https://github.com/adobe/brackets/wiki/How-to-Report-an-Issue'>докладвайте проблема</a> с връзка към файла.",

    // extensions/default/JSLint
    "JSLINT_NAME"                               : "JSLint",

    // extensions/default/QuickView
    "CMD_ENABLE_QUICK_VIEW"                     : "Бърз преглед при посочване",

    // extensions/default/RecentProjects
    "CMD_TOGGLE_RECENT_PROJECTS"                : "Скорошни проекти",

    // extensions/default/WebPlatformDocs
    "DOCS_MORE_LINK"                            : "Прочетете повече",

    // extensions/default/CodeFolding
    "COLLAPSE_ALL"                  : "Сгъване на всичко",
    "EXPAND_ALL"                    : "Разгъване на всичко",
    "COLLAPSE_CURRENT"              : "Сгъване на текущото",
    "EXPAND_CURRENT"                : "Разгъване на текущото",

    // Descriptions of core preferences
    "DESCRIPTION_CLOSE_BRACKETS"                     : "Задайте true за автоматично затваряне на всички видове скоби",
    "DESCRIPTION_CLOSE_OTHERS_ABOVE"                 : "Задайте false за премахване на възможността за „Затваряне на всички отгоре“ от контекстното меню на работните файлове",
    "DESCRIPTION_CLOSE_OTHERS_BELOW"                 : "Задайте false за премахване на възможността за „Затваряне на всички отдолу“ от контекстното меню на работните файлове",
    "DESCRIPTION_CLOSE_OTHERS"                       : "Задайте false за премахване на възможността за „Затваряне на останалите“ от контекстното меню на работните файлове",
    "DESCRIPTION_CLOSE_TAGS"                         : "Настройки за автоматично затваряне на елементи",
    "DESCRIPTION_CLOSE_TAGS_DONT_CLOSE_TAGS"         : "Списък от елементи, които не трябва да бъдат затваряни автоматично",
    "DESCRIPTION_CLOSE_TAGS_WHEN_OPENING"            : "Затваряне при въвеждане на „>“ от отварящия елемент",
    "DESCRIPTION_CLOSE_TAGS_WHEN_CLOSING"            : "Затваряне при въвеждане на „/“ от затварящия елемент",
    "DESCRIPTION_CLOSE_TAGS_INDENT_TAGS"             : "Списък от елементи, които трябва да имат празен ред след отваряне",
    "DESCRIPTION_CODE_FOLDING_ALWAY_USE_INDENT_FOLD" : "Задайте true за автоматично създаване на позиции за сгъване при промяна не нивото на отстъпа",
    "DESCRIPTION_CODE_FOLDING_ENABLED"               : "Задайте true за включване на сгъването на кода",
    "DESCRIPTION_CODE_FOLDING_HIDE_UNTIL_MOUSEOVER"  : "Задайте true за показване на триъгълничетата за сгъване само когато поставите курсора над лентата им",
    "DESCRIPTION_CODE_FOLDING_MAX_FOLD_LEVEL"        : "Ограничение за това върху колко нива се прилага операцията „Сгъване на всичко“",
    "DESCRIPTION_CODE_FOLDING_MIN_FOLD_SIZE"         : "Минимален брой редове, преди да се появи иконка за сгъване",
    "DESCRIPTION_CODE_FOLDING_SAVE_FOLD_STATES"      : "Задайте true за запомняне на сгънатите части при затваряне и повторно отваряне на файлове и проекти",
    "DESCRIPTION_CODE_FOLDING_MAKE_SELECTIONS_FOLDABLE": "Задайте true за включване на сгъването на избрания текст в редактора",
    "DESCRIPTION_ATTR_HINTS"                         : "Включване/изключване на подсказките за атрибути в HTML",
    "DESCRIPTION_CSS_PROP_HINTS"                     : "Включване/изключване на подсказките за атрибути в CSS/LESS/SCSS",
    "DESCRIPTION_JS_HINTS"                           : "Включване/изключване на подсказките за код на JavaScript",
    "DESCRIPTION_JS_HINTS_TYPE_DETAILS"              : "Включване/изключване на подсказките за подробности относно типовете данни в код на JavaScript",
    "DESCRIPTION_PREF_HINTS"                         : "Включване/изключване на подсказките за предпочитанията",
    "DESCRIPTION_SPECIAL_CHAR_HINTS"                 : "Включване/изключване на подсказките за специални знаци в HTML",
    "DESCRIPTION_SVG_HINTS"                          : "Включване/изключване на подсказките за код на векторни изображения (SVG)",
    "DESCRIPTION_HTML_TAG_HINTS"                     : "Включване/изключване на подсказките за елементи в HTML",
    "DESCRIPTION_URL_CODE_HINTS"                     : "Включване/изключване на подсказките за адреси в HTML и CSS/LESS/SCSS",
    "DESCRIPTION_DRAG_DROP_TEXT"                     : "Включване/изключване на фукционалността за влачене и пускане",
    "DESCRIPTION_HEALTH_DATA_TRACKING"               : "Включване на следенето на здравните данни",
    "DESCRIPTION_HIGHLIGHT_MATCHES"                  : "Включване на автоматичното осветяване на съвпадащите текстове в документа",
    "DESCRIPTION_HIGHLIGHT_MATCHES_SHOW_TOKEN"       : "Осветяване на всички текстове, отговарящи на елемента/символа, който в момента се намира под курсора (без нужда от избиране)",
    "DESCRIPTION_HIGHLIGHT_MATCHES_WORDS_ONLY"       : "Осветяване само когато избраното е завършен елемент/символ",
    "DESCRIPTION_INSERT_HINT_ON_TAB"                 : "Задайте true за използване на текущо избраната подсказка при натискане на клавиша Tab",
    "DESCRIPTION_NO_HINTS_ON_DOT"                    : "Задайте true за изключване на автоматичните подсказки в код на JavaScript при въвеждане на точка (.)",
    "DESCRIPTION_JSLINT_OPTIONS"                     : "Обект с настройките по подразбиране за JSLint",
    "DESCRIPTION_JSLINT_OPTIONS_ASS"                 : "Задайте true за разрешаване на изразите за присвояване",
    "DESCRIPTION_JSLINT_OPTIONS_BITWISE"             : "Задайте true за разрешаване на побитовите оператори",
    "DESCRIPTION_JSLINT_OPTIONS_BROWSER"             : "Задайте true , ако глобалните променливи на стандартния браузър трябва да бъдат преопределени",
    "DESCRIPTION_JSLINT_OPTIONS_CLOSURE"             : "Задайте true за разрешаване на диалектите на „Google Closure“",
    "DESCRIPTION_JSLINT_OPTIONS_CONTINUE"            : "Задайте true за разрешаване на ключовата дума „continue“",
    "DESCRIPTION_JSLINT_OPTIONS_COUCH"               : "Задайте true , ако глобалните променливи на CouchDB трябва да бъдат преопределени",
    "DESCRIPTION_JSLINT_OPTIONS_DEBUG"               : "Задайте true за разрешаване на изразите, свързани с отстраняването на грешки",
    "DESCRIPTION_JSLINT_OPTIONS_DEVEL"               : "Задайте true , ако глобалните променливи на браузъра, полезни за отстраняването на грешки, трябва да бъдат преопределени",
    "DESCRIPTION_JSLINT_OPTIONS_EQEQ"                : "Задайте true за разрешаване на == и !=",
    "DESCRIPTION_JSLINT_OPTIONS_ES6"                 : "Задайте true , ако глобалните променливи на ES6 трябва да бъдат преопределени",
    "DESCRIPTION_JSLINT_OPTIONS_EVIL"                : "Задайте true за разрешаване на „eval“",
    "DESCRIPTION_JSLINT_OPTIONS_FORIN"               : "Задайте true за разрешаване на нефилтриране изрази от вида „for ... in“",
    "DESCRIPTION_JSLINT_OPTIONS_INDENT"              : "Задаване на конкретна ширина на табулатора",
    "DESCRIPTION_JSLINT_OPTIONS_MAXERR"              : "Максимален брой докладвани грешки",
    "DESCRIPTION_JSLINT_OPTIONS_MAXLEN"              : "Максимален брой знаци на ред",
    "DESCRIPTION_JSLINT_OPTIONS_NEWCAP"              : "Задайте true за разрешаване на конструктори, които започват с малка буква",
    "DESCRIPTION_JSLINT_OPTIONS_NODE"                : "Задайте true , ако голбалните променливи на Node.js трябва да бъдат преопределени",
    "DESCRIPTION_JSLINT_OPTIONS_NOMEN"               : "Задайте true за разрешаване на висяща долна черта в идентификаторите",
    "DESCRIPTION_JSLINT_OPTIONS_PASSFAIL"            : "Задайте true за спиране при първа грешка",
    "DESCRIPTION_JSLINT_OPTIONS_PLUSPLUS"            : "Задайте true за разрешаване на ++ и --",
    "DESCRIPTION_JSLINT_OPTIONS_REGEXP"              : "Задайте true за разрешаване на . и [^...]. в регулярни изрази",
    "DESCRIPTION_JSLINT_OPTIONS_RHINO"               : "Задайте true , ако глобалните променливи на Rhino трябва да бъдат преопределени",
    "DESCRIPTION_JSLINT_OPTIONS_SLOPPY"              : "Задайте true за разрешаване на липсващи изявления „use strict“",
    "DESCRIPTION_JSLINT_OPTIONS_STUPID"              : "Задайте true за разрешаване на използването на блокиращи методи („...Sync“).",
    "DESCRIPTION_JSLINT_OPTIONS_SUB"                 : "Задайте true за разрешаване на неефективното извикване на методи/данни",
    "DESCRIPTION_JSLINT_OPTIONS_TODO"                : "Задайте true за разрешаване на коментарите „TODO“",
    "DESCRIPTION_JSLINT_OPTIONS_UNPARAM"             : "Задайте true за разрешаване на неизползваните параметри",
    "DESCRIPTION_JSLINT_OPTIONS_VARS"                : "Задайте true за разрешаване на повече от 1 използване на „var“ във функция",
    "DESCRIPTION_JSLINT_OPTIONS_WHITE"               : "Задайте true за пренебрегване на правилата за празните места",
    "DESCRIPTION_LANGUAGE"                           : "Настройки според езика",
    "DESCRIPTION_LANGUAGE_FILE_EXTENSIONS"           : "Допълнителни съответствия между файлово разширение и име на език",
    "DESCRIPTION_LANGUAGE_FILE_NAMES"                : "Допълнителни съответствия между файлово име и име на език",
    "DESCRIPTION_LINTING_ENABLED"                    : "Задайте true за включване на проучването на кода",
    "DESCRIPTION_ASYNC_TIMEOUT"                      : "Време в милисекунди, след което асинхронните системи за проверка ще бъдат спирани",
    "DESCRIPTION_LINTING_PREFER"                     : "Списък от системи за проверка, които да бъдат изпълнявани първо",
    "DESCRIPTION_LIVE_DEV_MULTIBROWSER"              : "Задайте true за включване на експерименталния преглед на живо",
    "DESCRIPTION_USE_PREFERED_ONLY"                  : "Задайте true за изпълнение само на доставчиците, определени в linting.prefer",
    "DESCRIPTION_MAX_CODE_HINTS"                     : "Максимален брой подсказки за кода, които могат да бъдат показани наведнъж",
    "DESCRIPTION_PATH"                               : "Настройки за пътищата",
    "DESCRIPTION_PROXY"                              : "Адресът на прокси сървъра, използван за инсталиране на разширения",
    "DESCRIPTION_SCROLL_PAST_END"                    : "Задайте true за включване на превъртането след края на документа",
    "DESCRIPTION_SHOW_CODE_HINTS"                    : "Задайте false за изключване на всички подсказки",
    "DESCRIPTION_SHOW_CURSOR_WHEN_SELECTING"         : "Курсорът продължава да мига дори и когато има избран текст",
    "DESCRIPTION_SHOW_LINE_NUMBERS"                  : "Задайте true за показване на номерата на редовете в ивица отляво на кода",
    "DESCRIPTION_SMART_INDENT"                       : "Автоматичен отстъп при създаване на нов блок",
    "DESCRIPTION_SOFT_TABS"                          : "Задайте false за изключване на леките табулатори",
    "DESCRIPTION_SORT_DIRECTORIES_FIRST"             : "Задайте true за показване на папките най-отгоре в дървото на файловете",
    "DESCRIPTION_SPACE_UNITS"                        : "Брой интервали, използвани при остъп чрез интервали",
    "DESCRIPTION_STATIC_SERVER_PORT"                 : "Номер на порт, който вграденият сървър да използва при преглед на живо",
    "DESCRIPTION_STYLE_ACTIVE_LINE"                  : "Задайте true за осветяване на цвета на фона на ред, на който се намира курсорът в момента",
    "DESCRIPTION_TAB_SIZE"                           : "Ширина на табулатора в брой интервали",
    "DESCRIPTION_USE_TAB_CHAR"                       : "Задайте true за използване на табулатори, вместо интервали",
    "DESCRIPTION_UPPERCASE_COLORS"                   : "Задайте true за използване на главни букви в шестнадесетичните цветове, създадени от редактора за цветове в текста",
    "DESCRIPTION_WORD_WRAP"                          : "Привидно пресяне на редовете, чиято дължина излиза извън видимата област на редактора",
    "DESCRIPTION_DETECTED_EXCLUSIONS"                : "Списък от файлове, за които се е установило, че създават проблеми на Tern",
    "DESCRIPTION_INFERENCE_TIMEOUT"                  : "Време, след което Tern ще спре да опитва да проучва файловете",
    "DESCRIPTION_SHOW_ERRORS_IN_STATUS_BAR"          : "Задайте true за показване на грешки в лентата на състоянието",
    "DESCRIPTION_QUICK_VIEW_ENABLED"                 : "Задайте true за включване на бързия преглед",
    "DESCRIPTION_EXTENSION_LESS_IMAGE_PREVIEW"       : "Задайте true за показване на изображения за адресите с лепсващи разширения",
    "DESCRIPTION_THEME"                              : "Изберете тема за {APP_NAME}",
    "DESCRIPTION_USE_THEME_SCROLLBARS"               : "Задайте true за позволяване на персонализирани ленти за превъртане",
    "DESCRIPTION_LINTING_COLLAPSED"                  : "Задайте true за скриване на панела за проверки",
    "DESCRIPTION_FONT_FAMILY"                        : "Промяна на семейството на шрифта",
    "DESCRIPTION_FONT_SIZE"                          : "Промяна на размера на шрифта, например 13px",
    "DESCRIPTION_FIND_IN_FILES_NODE"                 : "Задайте true за включване на търсенето по възли",
    "DESCRIPTION_FIND_IN_FILES_INSTANT"              : "Задайте true за включване на моменталното търсене",
    "DESCRIPTION_FONT_SMOOTHING"                     : "Само за Мак: използвайте „subpixel-antialiased“, за да включите подпикселното заглаждане или „antialiased“ за черно-бяло заглаждане",
    "DESCRIPTION_OPEN_PREFS_IN_SPLIT_VIEW"           : "Задайте false за изключване на отварянето на файла с настройките в разделен режим",
    "DESCRIPTION_OPEN_USER_PREFS_IN_SECOND_PANE"     : "Задайте false за отваряне на файла с потребителските настройки в левия/горния раздел",
    "DESCRIPTION_MERGE_PANES_WHEN_LAST_FILE_CLOSED"  : "Задайте true за скриване на разделите след като последният файл от раздела бъде затворен чрез бутона за затваряне в заглавната лента на раздела",
    "DESCRIPTION_SHOW_PANE_HEADER_BUTTONS"           : "Превключване на това кога да бъдат показвани бутоните за затваряне и прехвърляне в друг раздел в заглавната лента на раздела",
    "DEFAULT_PREFERENCES_JSON_HEADER_COMMENT"        : "/*\n * Този файл е само за четене и съдържа настройките,\n * поддържани от {APP_NAME}.\n * Използвайте го за справка, когато променяте своите настройки в\n * файла „brackets.json“, отворен в другия рездел.\n * За повече информация относно използването на настройките в\n * {APP_NAME}, прегледайте страницата https://github.com/adobe/brackets/wiki/How-to-Use-Brackets#preferences\n */",
    "DEFAULT_PREFERENCES_JSON_DEFAULT"               : "По подразбиране",
    "DESCRIPTION_PURE_CODING_SURFACE"                : "Задайте true за включване на режима, в който се вижда само кода, а всички останали части на потребителския интерфейс на {APP_NAME} са скрити",
    "DESCRIPTION_INDENT_LINE_COMMENT"                : "Задайте true за включване на отстъпа на коментарите за ред"
});

/* Last translated for a505026d40a4eb0bffc196eda30557c0e6b021bc */