/*
    Copyright 2015 Adobe Systems Incorporated.  All rights reserved. 
*/

/*global require, module, console, Buffer */

var validateAccesstoken = function (accessToken) {
    "use strict";
    var header,
        payload,
        signature,
        certificateName,
        userID,
        splitToken,
        decodedHeader,
        decodedPayload,
        currentTime,
        expiryTime;
        
    console.log("validtaing access token");
    if (!accessToken) {
        return false;

    }
    // Split the access token into its fields.
    // It has the format HEADER.PAYLOAD.SIGNATURE
    splitToken = accessToken.split('.');

    if (!(splitToken && splitToken.length === 3)) {

        console.log('Unable to split access token');
        return false;

    }
    header = splitToken[0];
    payload = splitToken[1];
    signature = splitToken[2];

    try {
        decodedHeader = JSON.parse(new Buffer(header, 'base64').toString('utf8'));
        decodedPayload = JSON.parse(new Buffer(payload, 'base64').toString('utf8'));
        console.log(decodedHeader);
        // Check the header is ok
        if (!decodedHeader || !decodedHeader.x5u || decodedHeader.alg !== 'RS256') {
            return false;
        }

        certificateName = decodedHeader.x5u;

        // Check the payload exists, and has the right client id, and expected fields like userID and expiry fields
        if (!decodedPayload || decodedPayload.client_id !== 'DwExtract' || !decodedPayload.user_id || !decodedPayload.created_at || !decodedPayload.expires_in) {
            return false;
        }

        userID = decodedPayload.user_id;
        console.log("user id: " + userID);
        // Check the token hasn't expired
        currentTime = (new Date()).getTime();
        expiryTime = decodedPayload.created_at + decodedPayload.expires_in;

        if (expiryTime < currentTime) {
            return false;
        }
        return true;
        
    } catch (e) {
        return false;
    }
};

module.exports.validateAccesstoken = validateAccesstoken;