// Generated by CoffeeScript 1.7.1
var Transformer, stream, util,
  __slice = [].slice;

stream = require('stream');

util = require('util');

module.exports = function() {
  var argument, callback, data, error, i, k, options, result, transform, type, udf, v, _i, _len;
  options = {};
  for (i = _i = 0, _len = arguments.length; _i < _len; i = ++_i) {
    argument = arguments[i];
    type = typeof argument;
    if (argument === null) {
      type = 'null';
    } else if (type === 'object' && Array.isArray(argument)) {
      type = 'array';
    }
    if (i === 0) {
      if (type === 'function') {
        udf = argument;
      } else if (type !== null) {
        data = argument;
      }
      continue;
    }
    if (type === 'object') {
      for (k in argument) {
        v = argument[k];
        options[k] = v;
      }
    } else if (type === 'function') {
      if (i === arguments.length - 1) {
        callback = argument;
      } else {
        udf = argument;
      }
    } else if (type !== 'null') {
      throw new Error('Invalid arguments');
    }
  }
  transform = new Transformer(options, udf);
  error = false;
  if (data) {
    process.nextTick(function() {
      var row, _j, _len1;
      for (_j = 0, _len1 = data.length; _j < _len1; _j++) {
        row = data[_j];
        if (error) {
          break;
        }
        transform.write(row);
      }
      return transform.end();
    });
  }
  if (callback) {
    result = [];
    transform.on('readable', function() {
      var r, _results;
      _results = [];
      while ((r = transform.read())) {
        _results.push(result.push(r));
      }
      return _results;
    });
    transform.on('error', function(err) {
      error = true;
      return callback(err);
    });
    transform.on('end', function() {
      if (!error) {
        return callback(null, result);
      }
    });
  }
  return transform;
};

Transformer = function(options, transform) {
  var _base;
  this.options = options != null ? options : {};
  this.transform = transform;
  this.options.objectMode = true;
  if ((_base = this.options).parallel == null) {
    _base.parallel = 100;
  }
  stream.Transform.call(this, this.options);
  this.running = 0;
  this.started = 0;
  this.finished = 0;
  return this;
};

util.inherits(Transformer, stream.Transform);

module.exports.Transformer = Transformer;

Transformer.prototype._transform = function(chunk, encoding, cb) {
  var err;
  this.started++;
  this.running++;
  if (this.running < this.options.parallel) {
    cb();
    cb = null;
  }
  try {
    if (this.transform.length === 2) {
      return this.transform.call(null, chunk, (function(_this) {
        return function() {
          var chunks, err;
          err = arguments[0], chunks = 2 <= arguments.length ? __slice.call(arguments, 1) : [];
          return _this._done(err, chunks, cb);
        };
      })(this));
    } else {
      return this._done(null, [this.transform.call(null, chunk)], cb);
    }
  } catch (_error) {
    err = _error;
    return this._done(err);
  }
};

Transformer.prototype._flush = function(cb) {
  this._ending = function() {
    if (this.running === 0) {
      return cb();
    }
  };
  return this._ending();
};

Transformer.prototype._done = function(err, chunks, cb) {
  var chunk, _i, _len;
  this.running--;
  if (err) {
    return this.emit('error', err);
  }
  this.finished++;
  for (_i = 0, _len = chunks.length; _i < _len; _i++) {
    chunk = chunks[_i];
    if (typeof chunk === 'number') {
      chunk = "" + chunk;
    }
    if (chunk != null) {
      this.push(chunk);
    }
  }
  if (cb) {
    cb();
  }
  if (this._ending) {
    return this._ending();
  }
};
