Charset Parser
==============

- Node.js module
- Parse charset string from http header and html data

## Installation

```sh
npm install charset-parser --save
```

## Usage
* Input a string, the charsetParser will find the charset string

```js
// charsetParser(string);
var charset = charsetParser('Content-Type:text/html; charset=utf-8');
```
* Input: the content type from http header, binary html content and a default charset
* If http header has no charset defined, the binary content will parse, if there is also no charset, it returns the default

```js
// charsetParser(header, html, default_charset);
var charset = charsetParser('Content-Type:text/html; charset=utf-8',
                            '<html><head><meta charset=utf-8></head><body></body></html>',
                            'iso-8859-1');
```

## Example
* A small example with node.js modules 'request' and 'iconv-lite'

```js
var request = require('request');
var iconv = require('iconv-lite');
var charsetParser = require('charset-parser');

iconv.extendNodeEncodings();

request('http://example.com', {encoding: 'binary'}, function(err, res, binary){
  // parse charset
  var charset = charsetParser(res.headers['content-type'], binary, 'iso-8859-1');
  // decode binary with charset
  var html = iconv.decode(binary, charset);
  // TODO: do something with html
}

```

## Test

```sh
npm install
npm test
```

## Release History

* 0.2.0 Add more input parameters
* 0.1.0 Initial release

## License

  [MIT](LICENSE)
