/*	
 Copyright 2014 Adobe Systems Incorporated.  All rights reserved. 

Purpose- 
This file has the implementation of bridging layer for Visual Media View..
*/

/*jslint vars: true, plusplus: true, devel: true, browser: true, nomen: true, maxerr: 50 */
/*global VmqBridger,dw,DWfile */

var DW_VMQ_DEBUGGING = false;

function VmqBridger() {
    'use strict';
}

/*
function:mediaQueryListToJSON
(Internal function on spider monkey side)
Arguments:argObj
        
        callback: on successful/failure of execution callback to js layer.

Description: 
    Returns media query JSON.

*/
VmqBridger.prototype.dwMediaQueryListToJSON = function (argObj) {
    'use strict';
    if (!argObj) {
        this.logDebugMsg("dwMediaQueryListToJSON :callback Obj not present");
        return;
    }
    
    var jsonStr = dw.mediaQueryListToJSON(argObj.mediastr);
    if (argObj.callback) {
        argObj.callback(jsonStr);
    }
};

/*
function:dwSetSelectedMQWidth
(Internal function on spider monkey side)
Arguments:argObj
        
        callback: on successful/failure of execution callback to js layer.

Description: 
    Sets the width of the live view to the selected MQ.

*/
VmqBridger.prototype.dwSetSelectedMQWidth = function (argObj) {
    'use strict';
    if (!argObj) {
        this.logDebugMsg("dwSetSelectedMQWidth :callback Obj not present");
        return;
    }
    
    dw.vmq.setSelectedWidth(argObj.width);
};


VmqBridger.prototype.dwLaunchAddMediaQueryPopup = function (argObj) {
    'use strict';
    if (!argObj) {
        this.logDebugMsg("dwLaunchAddMediaQueryPopup :callback Obj not present");
        return;
    }
    
    dw.vmq.launchAddMediaQueryPopup(argObj.minWidth, argObj.maxWidth);
    if (argObj.callback) {
        argObj.callback();
    }
};

VmqBridger.prototype.getLiveViewSize = function (argObj) {
    'use strict';
    if (!argObj) {
        this.logDebugMsg("getLiveViewSize :callback Obj not present");
        return;
    }
    
    var sizeStr = dw.getViewSize(),
        widthHeight = sizeStr.match(/\d+/g),
        width = widthHeight[0],
        height = widthHeight[1];
    
    if (argObj.callback) {
        argObj.callback(width, height);
    }
};

/*
function:dwGetViewWidthFromMqText
(Internal function on spider monkey side)
Arguments:argObj
        
        callback: on successful/failure of execution callback to js layer.

Description: 
   get the mq string value array from dw

*/
VmqBridger.prototype.dwGetViewWidthFromMqText = function (argObj) {
    'use strict';
    if (!argObj || !argObj.callback) {
        this.logDebugMsg("dwGetViewWidthFromMqText :callback Obj not present");
        return;
    }
    
    var i = 0,
        mqStrArray = [];
    
    for (i = 0; i < argObj.mqArray.length; i++) {
        mqStrArray[i] = argObj.mqArray[i];
    }
    
    var mqarray = dw.vmq.getViewWidthFromMqText(mqStrArray);
    argObj.callback(mqarray);
    
};

/*
function:dwLogHeadlightsData
(Internal function on spider monkey side)
Arguments:argObj

        headlights data for all VMQ related events

Description: 
   Log headlight data for the VMQ events

*/
VmqBridger.prototype.dwLogHeadlightsData = function (argObj) {
    'use strict';
    if (argObj && argObj.category && argObj.subCategory && argObj.eventString) {
        dw.logEvent(argObj.category, argObj.subCategory, argObj.eventString);
    }
};

/*
function:dwEditMq
(Internal function on spider monkey side)
Arguments:argObj
        
        callback: on successful/failure of execution callback to js layer.

Description: 
    Edits the currently selected mq breakpoint.

*/
VmqBridger.prototype.dwEditMq = function (argObj) {
    'use strict';
    if (!argObj) {
        this.logDebugMsg("dwSetSelectedMQWidth :callback Obj not present");
        return;
    }

    var edited = dw.vmq.editMq(argObj.selectedMq, argObj.minVal, argObj.maxVal, argObj.offsetLeft, argObj.offsetTop, argObj.isContextualEdit);
    if (argObj.callback) {
        argObj.callback(edited);
    }
};

/*
 * Constructor for bridging object...
 */
function VmqBridgingObject(browser) {
    /*
        Member variables : browser, browser object window and dreamweaver configuration path 
    */
    'use strict';
    this.m_browser = browser;
    this.m_browserWindow = browser.getWindow();
    this.m_vmqConfigPath = dw.getConfigurationPath() + "/VisualMediaQuery";
    this.m_vmqBridger = new VmqBridger();

}


/*
    This function attaches DW functionalitties to vmq browser
*/
VmqBridgingObject.prototype.attachDwFunctions = function () {
    'use strict';
    
    if (!this.m_browserWindow) {
        return;
    }
    
    // Initialize Log
	var writeDWLog = function (content) {
        if (DW_VMQ_DEBUGGING === true) {
            dw.logDebugMsg(content);
        }
    };
    
	this.logDebugMsg = writeDWLog;
    
    var setupObj = {
        writeDWLog: writeDWLog,
        dwMediaQueryListToJSON: this.m_vmqBridger.dwMediaQueryListToJSON,
        dwSetSelectedMQWidth: this.m_vmqBridger.dwSetSelectedMQWidth,
        dwGetViewWidthFromMqText: this.m_vmqBridger.dwGetViewWidthFromMqText,
        dwLaunchAddMediaQueryPopup: this.m_vmqBridger.dwLaunchAddMediaQueryPopup,
        dwLogHeadlightsData: this.m_vmqBridger.dwLogHeadlightsData,
        dwEditMq: this.m_vmqBridger.dwEditMq,
        vmqResourcePath: this.m_vmqConfigPath,
        getLiveViewSize: this.m_vmqBridger.getLiveViewSize
    };
    
	this.m_browserWindow.handleBridgingSetup(setupObj);
};






