/*

ADOBE CONFIDENTIAL
___________________

Copyright 2015 Adobe Systems Incorporated
All Rights Reserved.

NOTICE:  All information contained herein is, and remains
the property of Adobe Systems Incorporated and its suppliers,
if any.  The intellectual and technical concepts contained
herein are proprietary to Adobe Systems Incorporated and its
suppliers and are protected by trade secret or copyright law.
Dissemination of this information or reproduction of this material
is strictly forbidden unless prior written permission is obtained
from Adobe Systems Incorporated.
*/

/*jslint vars: true, plusplus: true, devel: true, browser: true, nomen: true, maxerr: 50, evil:true */
/*global dw, DWfile, nodeService */


var Bootstrap = (
    function () {
        "use strict";
        var _bootstrapDefaults = {
            "small-min": "768px",
            "medium-min": "992px",
            "large-min": "1200px",
            "num-columns": "12",
            "gutter-width": "30px"
        };

        var _bootstrapReplaceValues = {
            "replace-screen-sm": "small-min",
            "replace-screen-md": "medium-min",
            "replace-screen-lg": "large-min",
            "replace-grid-columns": "num-columns",
            "replace-grid-gutter-width": "gutter-width"
        };

        var BOOTSTRAP_CONSTANTS = {
            ASSETS_PATH: "Shared/LiveEdit/ResponsiveAssets/bootstrap/",
            LESS_PATH: "less/bootstrap.less",
            VARIABLES_TEMPLATE: "less/variablestemplate.less",
            VARIABLES_FILE: "less/variables.less"
        };

        var configPath = dw.getUserConfigurationPath();
        var assetsPath = configPath + BOOTSTRAP_CONSTANTS.ASSETS_PATH;
        
        //utils
        var _isAFunction = function (object) {
            if (typeof object === 'function') {
                return true;
            }
			return false;
        };
        
        var _validOutputFolder = function (path) {
            var attr = DWfile.getAttributes(path);
            if (!attr || attr.indexOf("D") !== -1) {
                return true;
            }
            return false;
        };
        //
        
        var _generateVariablesFile = function (bootstrapValues) {
			var variableTemplates = assetsPath + BOOTSTRAP_CONSTANTS.VARIABLES_TEMPLATE;
			if (!DWfile.exists(variableTemplates)) {
				return false;
			}
            var fileStr = DWfile.read(variableTemplates);
            if (fileStr) {
                var prop;
                for (prop in _bootstrapReplaceValues) {
                    if (_bootstrapReplaceValues.hasOwnProperty(prop) && _bootstrapReplaceValues[prop]) {
                        fileStr = fileStr.replace(prop, bootstrapValues[_bootstrapReplaceValues[prop]]);
                    }
                }
                var writePath = assetsPath + BOOTSTRAP_CONSTANTS.VARIABLES_FILE;
                if (DWfile.write(writePath, fileStr)) {
                    return true;
                } else {
                    return false;
                }
            }
			return false;
        };
    
        var _removeVariablesFile = function () {
            var variableLessPath = assetsPath + BOOTSTRAP_CONSTANTS.VARIABLES_FILE;
            if (DWfile.exists(variableLessPath, false)) {
                DWfile.remove(variableLessPath);
            }
        };

        var _generateBootstrap = function (outputPath, options, successCallback, errorCallback) {
            var lessFilePath = assetsPath + BOOTSTRAP_CONSTANTS.LESS_PATH;
            var variableLessFile = assetsPath + BOOTSTRAP_CONSTANTS.VARIABLES_FILE;
            if (!DWfile.exists(lessFilePath, false)) {
                return false;
            }
            //variables file is already present / maybe another process is in progress.
            if (DWfile.exists(variableLessFile, false)) {
                DWfile.remove(variableLessFile);
            }
            if (!_generateVariablesFile(options)) {
                _removeVariablesFile();
                // delete variables file and bail
                return false;
            }

            var _success = function (inputFile, outputCSS) {
                _removeVariablesFile();
                if (successCallback) {
                    successCallback.call(null, outputCSS);
                }
            };

            var _error = function (inputFile, errorType, errorMessage) {
                _removeVariablesFile();
                if (errorCallback) {
					var inputFileArg = "",
						errorTypeArg = "",
						errorMessageArg = "";
					if (typeof inputFile !== "undefined" && inputFile) {
						inputFileArg = inputFile;
					}
					if (typeof errorType !== "undefined" && errorType) {
						errorTypeArg = errorType;
					}
					if (typeof errorMessage !== "undefined" && errorMessage) {
						errorMessageArg = errorMessage;
					}
					
                    errorCallback.call(null, inputFileArg, errorTypeArg, errorMessageArg);
                }
            };

            return nodeService.compile(lessFilePath, outputPath, _success, _error);
        };

        var bootstrap = {
            generateDefault: function (outputPath, options) {
                if (!_validOutputFolder(outputPath)) {
                    return false;
                }
                var successCallback = null,
                    errorCallback = null;
                if (options && _isAFunction(options.success)) {
                    successCallback = options.success;
                }
                if (options && _isAFunction(options.error)) {
                    errorCallback = options.error;
                }
                return _generateBootstrap(outputPath, _bootstrapDefaults, successCallback, errorCallback);
            },

            generateCustom: function (outputPath, options) {
                if (!_validOutputFolder(outputPath)) {
                    return false;
                }
                if (typeof options === "undefined" || !options) {
                    return this.generateDefault(outputPath);
                }
                var prop,
                    successCallback = null,
                    errorCallback = null;
                var newOptions = {};
                // generate the options
                for (prop in _bootstrapDefaults) {
                    if (_bootstrapDefaults.hasOwnProperty(prop) && _bootstrapDefaults[prop]) {
                        newOptions[prop] = _bootstrapDefaults[prop];
                        if (typeof options[prop] !== "undefined" && options[prop]) {
                            newOptions[prop] = options[prop];
                        }
                    }
                }
                if (options && _isAFunction(options.success)) {
                    successCallback = options.success;
                }
                if (options && _isAFunction(options.error)) {
                    errorCallback = options.error;
                }
                return _generateBootstrap(outputPath, newOptions, successCallback, errorCallback);
            }
        };

        return bootstrap;
    }()
);