/*	
 Copyright 2015 Adobe Systems Incorporated.  All rights reserved. 

Purpose- 
This file contains all the constants that would be required for Responsive Layout Feature
*/

/*jslint vars: true, plusplus: true, devel: true, browser: true, nomen: true, maxerr: 50, continue: true */
/*global */

var ResponsiveLayoutConstants = {
    docWindowObj: null,

    ExtensionId: "ResponsiveLayout",

    FRAMEWORK: {
        // let all be in lowercase
        "BOOTSTRAP": "bootstrap"
    },

    /*
        function:setWindowObj() - sets the context of the window object that is the responsive document containing the framework
        Arguments: windowObj
        Return: none.
    */
    setWindowObj: function (windowObj) {
        "use strict";
        this.docWindowObj = windowObj;
        if (!this.docWindowObj.responsiveInfo) {
            this.docWindowObj.responsiveInfo = {};
        }
    },

    DESCRIPTORS: {
        FRAMEWORK_NAME:             "frameworkName",
        GRID_CONTAINER_CLASS:       "gridContainerClass",
        GRID_FLUID_CONTAINER_CLASS: "gridFluidContainerClass",
        ROW_CLASS:                  "rowClass",
        RESIZE_CLASS_REGEX:         "resizeClassRegex",
        OFFSET_CLASS_REGEX:         "offsetClassRegex",
        HIDE_CLASS_REGEX:           "hideClassRegex",
        MEDIA_QUERY_REGEX:          "mediaQueryRegex",
        NUM_BREAKPOINTS:            "numBreakpoints",
        DEPENDS_ON_COLUMNS:         "dependsOnMaxCols",
        FRAMEWORK_VERSION:          "frameworkVersionRegex",
        //Define the Features at the end so that all can be seen together
        FEATURE_RESIZE:             "resize",
        FEATURE_OFFSET:             "offset",
        FEATURE_HIDE:               "hide",
        FEATUR_UNHIDE:              "unhide",
        NO_REGEX:                   "noRegex",
		GRIDCLASS_SIZES_PREFIX:		"gridClassPrefixes"
    },

    FEATURES: {
        RESIZE:             "resize",   // this should be the same as the DESCRIPTORS.FEATURE_RESIZE
        OFFSET:             "offset",   // this should be the same as the DESCRIPTORS.FEATURE_OFFSET
        HIDE:               "hide",     // this should be the same as the DESCRIPTORS.FEATURE_HIDE
        UNHIDE:             "unhide"    // this should be the same as the DESCRIPTORS.FEATURE_UNHIDE
    },

    FEATURES_IMPL_REGEX: {
        RESIZE:             "resizeClassRegex",
        OFFSET:             "offsetClassRegex",
        HIDE:               "hideClassRegex"
    },
    
    CONTROL_IDS: {
        RESIZE: "resizeEdge",
        OFFSET: "offsetEdge",
        ADD_NEW_ROW_COLUMN_UNHIDE: "addRowColumnUnhide",
        ROW_RIGHT_EDGE: "rowRight",
        ROW_LEFT_EDGE: "rowLeft"
    },
    
    DW_RESPONSIVE_ELEMENT_ATTR: "data-dw-responsive",

    // CSS Selectors
    //Container
    RootContainerId : "responsiveLayoutOverlayContainer",
    DesignTimeCSSStyleID: "dw-responsive-style-sheet",
    //Overlay Elements
    OverlayElementClass: "overlayElement",
    RowContainerClass : "row",
    ColContainerClass : "column",
    ActiveElementClass : "active",
    HideContainerClass: "hidden",
    SelectedElementClass : "selected",
    //Overlay Controls
    OverlayControlButtonClass: "overlayControlButton",
    OverlayRowColumnButtonClass: "overlayRowColumnButton",
    OverlayRowColumnButtonBorderClass: "overlayRowColumnButtonBorder",
    AddRowColumnDeepClass: "addRowColumnDeep",
    AddRowShallowClass: "addRowShallow",
    AddColumnShallowClass: "addColumnShallow",
    UnhideClass: "unhide",
    KnobResizeClass : "knob knobResize",
    KnobOffsetClass : "knob knobOffset",
    RowEdgeClass: "rowEdge",
    ColumnEdgeClass: "columnEdge",
    // Other Constants
    OverlayBorderWidth : 1,
    OffsetKnobSize: 15,
    ResizeKnobSize: 12,
    RowOverlayDivPadding : 5,
    ControlButtonWidth: 30,
    ControlButtonHeight: 28,
    OverlayType : {
        Row: "row",
        Column: "column",
        Hidden: "hidden"
    },
    OverlayOffsetClass : "overlayOffsetDiv",
    VerticalPaddingToAvoidESHOverlap: 150,
    HorizontalPaddingToAvoidESHOverlap: 300,
    
    RESPONSIVE_HEADLIGHTS: {
        RWD_Category: "RWD",
        RWD_SubCategory: "RWD_Bootstrap",
        RWD_Resize: "Bootstrap_Resize",
        RWD_AddRow: "Bootstrap_AddRow",
        RWD_AddColumn: "Bootstrap_AddColumn",
        RWD_DeepCopy: "Bootstrap_DeepCopy",
        RWD_Offset: "Bootstrap_Offset",
        RWD_Hide: "DWContext_Bootstrap_HideElement",
        RWD_ManageHidden: "DWContext_Bootstrap_ManageHiddenElements",
        RWD_Unhide: "Bootstrap_ShowHiddenElement"
    },
    
    KEYCODES: {
        ESC: 27
    }
};