/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright (c) 2013-2014 Adobe Systems Incorporated. All rights reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 */

/*jslint vars: true, plusplus: true, devel: true, nomen: true, indent: 4 */
/*global define: true, graphite: true, require: true, $:true*/
define(
    'plugin-dependencies',
    [
        'underscore',
        'jqueryTranslate',
        'controllers/AuthController'
    ],
    function (_, jqueryTranslate, AuthController) {
        'use strict';
        var keys = null;
        var initStrings = function () {
            if ($.i18n) {
                $.i18n.properties({
                    name: 'ExtractStrings',
                    language: ' ',
                    path: '../strings/',
                    mode: 'both',
                    callback: function () {
                        keys = $.i18n.map;
                    }
                });
            }
        };
        return {
            translate: function () {
                if (!keys) {
                    initStrings();
                }
                var test_mode     = false;
                var original_key  = arguments[0] || null;
                var replacements  = Array.prototype.slice.call(arguments, 1);

                // simple lookup of a single key, return the key if no match found
                var splitStr = original_key.split("=");
                var ret = original_key;
                if (keys) {
                    ret = keys[splitStr[0]] || original_key;
                }
                
                ret = ret.replace(/\\'/g, '\'');

                // replace variables, assuming we have found the base string
                if (ret) {
                    _.each(replacements, function (item, index) {
                        ret = ret.replace(('{' + index + '}'), item);
                    });
                }
                if (test_mode) {
                    return "!!!-" + ret + "-!!!";
                }

                return ret;
            },

            utils: {
                getCurrentPage: function () {
                    return AuthController.isLoggedIn();
                },
                getCurrentBasePath: function () {
                    return 'parfait';
                },
                hasFeature: function () {
                    return false;
                }
            },

            config: {
                sharedcloud_proxy_url: ""
            },

            auth: {
                token: ""
            },

            parfait: true,

            notifyUser: function (msg) {
                graphite.events.trigger('load-alert', msg);
            }
        };
    }
);
