/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright (c) 2013-2014 Adobe Systems Incorporated. All rights reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 */

/*jslint vars: true, plusplus: true, devel: true, nomen: true, indent: 4 */
/*global define: true, graphite: true, window: true*/

// Used for popups that appear in the preview area
define([
    'jquery',
    'underscore',
    'backbone',
    'ccweb.files.extract/views/popup/BasePopupView',
    'parfait/BasePreviewPopupView'
], function ($, _, Backbone, BasePopupView, BasePreviewPopupView) {
    'use strict';
    var DwBasePreviewPopupView = BasePreviewPopupView.extend({
        remove: function () {
            $(window).off("mousedown", $.proxy(this.handleMouseDown, this));
            return BasePopupView.prototype.remove.apply(this, arguments);
        },
        
        //------------------------------------------------
        // Helpers
        //------------------------------------------------
        //Finds the position we'd like to place the popup relative to the source element
        positionPopup: function () {
            var parentOffset = this.$el.parent().offset().top,
                parentHeight = this.$el.parent().height(),
                parentWidth = this.$el.parent().width(),
                sourceHeight = this.getSourceOuterHeight(),
                sourceWidth = this.getSourceOuterWidth() || parentWidth,
                popupHeight = this.$el.outerHeight(),
                popupWidth = this.$el.outerWidth(),
                previewAreaWidth = $('div.psd-preview-view').width() - 10,
                hScrollPos =  $("div.psd-preview-view").scrollLeft(),
                $notch = this.$el.find(".notch"),
                $extractPlugin = $('.extract-plugin'),
                extractPluginOffset = document.documentElement.clientHeight,
                notchHeight = $notch.height(),
                notchWidth = $notch.width(),
                notchAdjustment = 0,
                nY = this.getSourceYOffset() + sourceHeight,
                nX = this.getSourceXOffset() + ((sourceWidth - popupWidth) / 2),
                isTop = true;

            this.$el.removeClass("top bottom");

            // Popup is placed below source by default. If popup is not visible
            // in current viewport then we place above the source.

            if (nY + popupHeight + notchHeight < extractPluginOffset - parentOffset) {
                isTop = false;
                nY += notchHeight - 4;
            } else {
                nY = this.getSourceYOffset() - popupHeight + 4;

                if (nY < 0 || (nY + popupHeight > parentHeight) || (this.getSourceOffsetTop() - popupHeight - notchHeight - this.getTopPsdPreviewView() < 0)) {
                    isTop = true;
                    nY = (this.getSourceYOffset() + sourceHeight) - popupHeight + 3;
                    if (nY + popupHeight + notchHeight - this.getTopPsdPreviewView() > extractPluginOffset - parentOffset) {
                        isTop = false;
                        nY = this.getSourceYOffset() + notchHeight - 4;
                    }
                }

            }


            // Assign final orientation for styling purposes.
            this.$el.addClass(isTop ? "top" : "bottom");

            // Initial placement of notch.
            $notch.css("left", (popupWidth - notchWidth) / 2);

            //Adjust horizontally to ensure fully within our parent bounds and adjust the notch position
            if (nX < hScrollPos) {
                notchAdjustment = Math.min(hScrollPos - nX, (popupWidth - notchWidth) / 2);
                $notch.css("left", ((popupWidth - notchWidth) / 2) - notchAdjustment);
                nX = hScrollPos;
            }
            if (nX + popupWidth > previewAreaWidth + hScrollPos) {
                notchAdjustment = Math.min(nX - (previewAreaWidth + hScrollPos - popupWidth), (popupWidth - notchWidth) / 2);
                $notch.css("left", (popupWidth - notchWidth) / 2 + notchAdjustment);
                nX = previewAreaWidth + hScrollPos - popupWidth;
            }
            
            // Final placement of popup.
            this.$el.css({top: nY, left: nX});
        },
        
        getSourceOffsetTop : function () {
            return this.source.offset().top;
        },

        getTopPsdPreviewView : function () {
			var returnTopPsdPreviewView = 0;
            var top = $(".psd-preview-view").css("top");
            if (top !== undefined && top !== null) {
                top = top.replace("px", "");
				if (isNaN(top)) {
					returnTopPsdPreviewView = 0;
				} else {
                    returnTopPsdPreviewView = parseInt(top, 10);
				}
            }
			return returnTopPsdPreviewView;
        }
    });
    
    return DwBasePreviewPopupView;
});