/*************************************************************************
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by all applicable intellectual property
 * laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

/**
 * After Effects Host ExtendScript Interface for CCX extensions
 */
CCXWelcomeXSHost_AEFT = {

    /**
     * Gets the user's personalization data from the host application as a JSON string.
     *
	 * @param mode		string key for host data mode
     * @return JSON string representation of the data.
     */
    getUserJSONData : function(mode) {
    
        var userData = app.getCCXUserJSONData();

        return userData;
    }

    /**
     * Create and open the host's default document type.
     */
  , createDefaultDocument : function()
    {
        app.newProject();
    }

    /**
     * Open the host's document creation/template UI
     */
  , createDocumentFromTemplate : function()
    {
    }

    /**
     * Open a document with the specified file path.
     */
  , openDocumentWithPath : function( filepath )
    {
        app.open(new File(filepath))
    }

  , openDocumentWithUI : function()
    {
        app.executeCommand(3 /*cmdOpen*/);  // via pro/src/app/egg/indep/Main/EggCmdDefines.h
    }
};

/*************************************************************************
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by all applicable intellectual property
 * laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

/**
 * Dreamweaver Host ExtendScript Interface for CCX extensions
 */
CCXWelcomeXSHost_DRWV = {

    /**
     * Gets the user's personalization data from the host application as a JSON string.
     *
     * @return JSON string representation of the data.
     */
    getUserJSONData : function() {
        var userData;
        if (typeof dw !== 'undefined') {
            userData = dw.ccx.getCCXUserJSONData();
        }
        return userData;
    }

    /**
     * Create and open the host's default document type.
     */
  , createDefaultDocument : function()
    {
    }

    /**
     * Open the host's document creation/template UI
     */
  , createDocumentFromTemplate : function()
    {
    }

    /**
     * Open a document with the specified file path.
     */
  , openDocumentWithPath : function( filepath )
    {
    }
};

/*************************************************************************
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by all applicable intellectual property
 * laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

/**
 * InDesign Host ExtendScript Interface for CCX extensions
 */
CCXWelcomeXSHost_IDSN = {

    /**
     * Gets the user's personalization data from the host application as a JSON string.
     *
	 * @param mode		string key for host data mode
     * @return JSON string representation of the data.
     */
    getUserJSONData : function(mode) {
    
        var userData = app.getCCXUserJSONData(mode);

        return userData;
    }

    /**
     * Create and open the host's default document type.
     */
  , createDefaultDocument : function()
    {
    }

    /**
     * Open the host's document creation/template UI
     */
  , createDocumentFromTemplate : function()
    {
    }

    /**
     * Open a document with the specified file path.
     */
  , openDocumentWithPath : function( filepath )
    {
    }
};

/*************************************************************************
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by all applicable intellectual property
 * laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
 
/**
 * Illustrator Host ExtendScript Interface for CCX extensions
 */
CCXWelcomeXSHost_ILST = {

    /**
     * Gets the user's personalization data from the host application as a JSON string.
     *
	 * @param mode		string key for host data mode
     * @return JSON string representation of the data.
     */
    getUserJSONData : function(mode) {
    
        var userData = app.getCCXUserJSONData(mode);

        return userData;
    }

    /**
     * Create and open the host's default document type.
     *
     * @return status code indicating success(true) or failure(false)
     */
  , createDefaultDocument : function()
    {
        var doc = app.documents.addDocument('', new DocumentPreset(), true);

        return (doc ? true : false);
    }

    /**
     * Map string to unit.
     *
     * @return Illustrator unit.
     */
  , getUnit : function(str)
    {
        var type;
        switch(str) {
            case "pointsUnit":
                type = RulerUnits.Points;
                break;
            case "picasUnit":
                type = RulerUnits.Picas;
                break;
            case "inchesUnit":
                type = RulerUnits.Inches;
                break;
            case "millimetersUnit":
                type = RulerUnits.Millimeters;
                break;
            case "centimetersUnit":
                type = RulerUnits.Centimeters;
                break;
            case "pixelsUnit":
                type = RulerUnits.Pixels;
                break;
            case "qsUnit":
                type = RulerUnits.Qs;
                break;
            default:
                type = RulerUnits.Points;
        }
        return type;
    }

    /**
     * Open the host's document creation/template UI
     */
  , createDocumentFromTemplate : function(templateJSON, docName, showDialog)
    {
        templateJSON = JSON.parse(templateJSON);
        var documentPreset = new DocumentPreset();
        documentPreset.height = templateJSON.height;
        documentPreset.width = templateJSON.width;
        documentPreset.units = this.getUnit(templateJSON.units);
        documentPreset.colorMode = templateJSON.colorMode === 'CMYK' ? DocumentColorSpace.CMYK: DocumentColorSpace.RGB;
        documentPreset.numArtboards = templateJSON.numArtboards;
        documentPreset.title = docName;
        var doc = app.documents.addDocument('', documentPreset, showDialog);
        return app.documents.length > 0;
    }

    /**
     * Open a document with the specified file path.
     */
  , openDocumentWithPath : function( filepath )
    {
    }

    /**
     * Sets the "Don't Show Again" preference in the host application.
     *
     * @param dontShowAgain     boolean value indicating true if "dont show again" was
     *                          requested, false otherwise
     */
  , setDontShowAgainPreference : function( dontShowAgain ) {
  
       app.preferences.setBooleanPreference("Hello/DontShowAgainPrefKey_Ver19_0",
                                            dontShowAgain ? "true" : "false");
    }

    /**
     * Open the legacy native new document UI dialog.
     */
  , openLegacyNewDocumentDialog : function () {
    
        var doc = app.documents.addDocument('', new DocumentPreset(), true);

        return (doc ? true : false);
    }
};

/*************************************************************************
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by all applicable intellectual property
 * laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

/**
 * Muse Host ExtendScript Interface for CCX extensions
 */
CCXWelcomeXSHost_MUSE = {

    /**
     * Gets the user's personalization data from the host application as a JSON string.
     *
     * @return JSON string representation of the data.
     */
    getUserJSONData : function() {
    
        var userData = app.getCCXUserJSONData();

        return userData;
    }

    /**
     * Create and open the host's default document type.
     */
  , createDefaultDocument : function()
    {
    }

    /**
     * Open the host's document creation/template UI
     */
  , createDocumentFromTemplate : function()
    {
    }

    /**
     * Open a document with the specified file path.
     */
  , openDocumentWithPath : function( filepath )
    {
    }
};

/**************************************************************************
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by all applicable intellectual property
 * laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

/**
 * Photoshop Host ExtendScript Interface for CCX extensions
 */
 /* globals localize, CCXWelcomeXSHost_PHXS,
            charIDToTypeID, stringIDToTypeID,
            ActionReference, ActionDescriptor, ActionList,
            app, executeActionGet, executeAction, File, $,
            DialogModes, alert */

/**************************************************************************
 * Helpers, meant for use locally in this file only.
 **************************************************************************/

/**
 * Shorthand for converting char ID to type ID.
 *
 * @return Type ID for provided char ID.
 */
function cTID(key) {
    return charIDToTypeID(key);
}

/**
 * Shorthand for converting string ID to type ID.
 *
 * @return Type ID for provided string ID.
 */
function sTID(key) {
    return stringIDToTypeID(key);
}

/**
 * Get a named property out of an ActionDescriptor.
 *
 * @return The specified property from the provided descriptor, or undefined if not available.
 */
function getPropertyFromDesc(propertykey, desc) {
    if (desc && desc.hasKey(propertykey)) {
        switch (desc.getType(propertykey)) {
            // Add handling of new types here as needed
        case DescValueType.OBJECTTYPE:
            return desc.getObjectValue(propertykey);
        case DescValueType.BOOLEANTYPE:
            return desc.getBoolean(propertykey);
        case DescValueType.LISTTYPE:
            return desc.getList(propertykey);
        case DescValueType.STRINGTYPE:
            return desc.getString(propertykey);
        }
    }
    return undefined;
}

/**
 * Get a named application property from Photoshop.
 *
 * @return The specified property from Photoshop, or undefined if not available.
 */
function getAppProperty(propertyKey, argsDesc, convertToActionJSON) {
    // Use the passed in desc if provided so the caller can supply additional params
    if (!argsDesc) {
        argsDesc = new ActionDescriptor();
    }

    var ref = new ActionReference();
    ref.putProperty(sTID('property'), propertyKey);
    ref.putEnumerated(sTID('application'), sTID('ordinal'), sTID('targetEnum'));

    argsDesc.putReference(sTID('target'), ref);
    var appDesc = executeAction(sTID('get'), argsDesc, DialogModes.NO);

	if (convertToActionJSON) {
		// Automatically convert to Action JSON, the JSON representation of
		// an ActionDescriptor. It is easiest to do this here while we know
		// that we still have an object (not a list, string, etc).
		if (appDesc && appDesc.hasKey(propertyKey)) {
			var convertDesc = new ActionDescriptor();
			convertDesc.putObject(sTID('object'), sTID('object'), appDesc );
			var jsonDesc = executeAction(sTID('convertJSONdescriptor'), convertDesc, DialogModes.NO );

			return jsonDesc.getString(sTID('json'));
		}	
		return undefined;
	}
    return getPropertyFromDesc(propertyKey, appDesc);
}

/**
 * Helper to avoid parsing and re-stringify multiple JSON strings just to combine
 * them into a master JSON array. Needed because Parsing JSON is terribly slow in
 * ExtendScript
 *
 * @param An object whos properties are all valid JSON strings.
 * @return A json array containing all the json strings from the object
 */function JSONBlocksToJSONArray(jsonBlocks) {
	var jsonArray = '{';
	var firstBlock = true;

	for (var key in jsonBlocks) {
		if (jsonBlocks.hasOwnProperty(key)) {
			jsonArray += (firstBlock ? '' : ',') + '"' + key + '" : ' + jsonBlocks[key];
			firstBlock = false;
		}
	}

	jsonArray += '}';
	
	return jsonArray;
}

/**************************************************************************
 * Externally visible APIs should be part of the CCXWelcomeXSHost_PHXS
 * object.
 **************************************************************************/

CCXWelcomeXSHost_PHXS = {

	CANCEL_ERROR_CODE : 8007

  ,	mruPathCache : []

    /**
     * Get the current logged in user's Adobe ID.
     *
     * @return String containing the user's Adobe ID.
     */
  , getAdobeID : function() {

        var s = getAppProperty(cTID('bhn2'));

        if (s === undefined) {
            s = 'ERROR_ADOBEID';
        }

        return s;
    }

    /**
     * Get the current logged in user's Adobe GUID.
     *
     * @return String containing the user's Adobe GUID.
     */
  , getDelegateGUID : function() {

        var s = getAppProperty(cTID('bhnc'));

        if (s === undefined) {
            s = 'ERROR_ADOBEGUID';
        }

        return s;
    }

    /**
     * Get the current UI locale.
     *
     * @return String containing the locale ID.
     */
  , getLocale : function() {

        // Coerce other english varients to en_US
        var modLocale = app.locale;

        if (! (modLocale in {'en_US':1, 'en_GB':1})) {
            if (modLocale.match(/en_??/)) {
                modLocale = 'en_US';
            }
        }

        return modLocale;
    }

    /**
     * Get the current value of the 'Dont Show Again' preference for Start
     *
     * @return Boolean value indicating preference state.
     */
  , getDontShowAgain : function() {

        var bResult  = false;

        try {
            var desc     = app.getCustomOptions( '0685b2e9-19db-4679-90b9-34644fcc7884' );
            var kshowStr = stringIDToTypeID( 'show' );

            if ( desc.count > 0 && desc.hasKey( kshowStr ) ) {
                bResult = ! desc.getBoolean( kshowStr );
            }
        }
        catch( e ) {
            bResult = false;
        }
        return bResult;
    }

    /**
     * Set the 'Dont Show Again' flag in the preferences.
     *
     * @param inValue       boolean value indicating flag state
     */
  , setDontShowAgain : function(inValue) {

        var desc = new ActionDescriptor();

        desc.putBoolean( stringIDToTypeID( 'show' ), ! inValue );
        app.putCustomOptions( '0685b2e9-19db-4679-90b9-34644fcc7884', desc, true );
    }

    /**
     * Determine display file 'kind' based on extension.
     *
     * @param filename      file name string to check
     * @return String containing the display name type.
     */
  , getFileKind : function( filename ) {

        var fileextsplit = filename.split('.');
        var fileext      = fileextsplit.pop().toUpperCase();

        if ( fileextsplit.length > 0 ) {
            switch (fileext)
            {
                case 'PSD':
                    fileext = 'Photoshop';
                    break;

                case 'TIF':
                    fileext = 'TIFF';
                    break;

                case 'JPG':
                    fileext = 'JPEG';
                    break;

                default:
                    break;
            }
        }

        return fileext;
    }

    /**
     * Create the list of the MRU's.
     *
     * @return array containing the list of MRU structures.
     */
  , getRecentFilesJSON : function() {

        /**
         * File.name returns an escaped string for the file's display name
         * that unfortunately fails in many cases for UTF-8 encoded file
         * names.  Therefore we have to breakdown the filename from the
         * path string ourselves.
         *
         * @param fullName		string containing the file's full path
         * @return A string containing the file's base display name.
         */
        var getFileBaseName = function(fullName) {
            return fullName.substring(fullName.lastIndexOf('/') + 1);
        };

        var s                       = [];

        var kpathStr                = stringIDToTypeID('path');
        var ksizeStr                = stringIDToTypeID('size');
        var klastStr                = stringIDToTypeID('last');
        var kthumbnailStr           = stringIDToTypeID('thumbnail');
        var classProperty           = charIDToTypeID('Prpr');

        var l = getAppProperty(sTID('recentFileEntries'));

        this.mruPathCache = [];  // clear cache for rebuild

        if (l !== undefined) {
            var lc = l.count;
            var keyRecentFiles = charIDToTypeID('Rcnf');
            var prefsDesc = getAppProperty(sTID('fileSavePrefs'));

            if (prefsDesc !== undefined) {
              if (prefsDesc.count && prefsDesc.hasKey(keyRecentFiles)) {
                lc = Math.min(lc, prefsDesc.getInteger(keyRecentFiles));
              }
            }

            for (var i = 0; i < lc; i++) {
                var itemDesc = l.getObjectValue(i);
                var item = new File(itemDesc.getString(kpathStr));
                var recent = { };

                this.mruPathCache.push(item.fullName);

                recent.identifier   = i.toString();
                recent.name         = getFileBaseName(item.fullName);
                recent.tip          = item.fsName;
                recent.thumb        = (itemDesc.hasKey(kthumbnailStr)) ? 'data:image/jpeg;base64,' + itemDesc.getData(kthumbnailStr) : '';
                recent.icon         = 'psd';
                recent.lastOpened   = itemDesc.getInteger(klastStr) * 1000;
                recent.size         = itemDesc.getLargeInteger(ksizeStr);
                recent.kind         = this.getFileKind(recent.name);
                s.push(recent);
            }
        }

        return JSON.stringify({ list : s });
    }

    /**
     * Get basic config data from Photoshop.
     *
     * @return JSON containing basic config data as provided by Photoshop.
     */
    , getFNFTConfigInfoJSON : function() {
        var configInfo = '';
        try {
            var configDesc = getAppProperty(cTID('CXNc'));
            if (configDesc && configDesc.hasKey(sTID('json'))) {
                configInfo = configDesc.getString(sTID('json'));
            }
        } catch (err) {
			alert( 'Photoshop scripting error: ' + err.message );
        }
        return configInfo;
    }

    /**
     * Get the list of most recently used (MRU) PS Presets
     *
     * @return JSON array containing the list of MRU presets.
     */
  ,	getRecentlyUsedPresetsJSON : function () {

        var psPresetsJSON	= '';
        var argDesc = new ActionDescriptor();

        argDesc.putBoolean(stringIDToTypeID('forFNFTDialog'), true); // gets us the tooltips for this extension
	  
        try {
            psPresetsJSON = getAppProperty(sTID('newDocPresetMRUlist'), argDesc);
        }
        catch (e) {
            if (e.number != this.CANCEL_ERROR_CODE) {
                alert ('Could not retrieve Photoshop MRU Presets JSON:\n\n' + e.number);
            }
        }
	  
	    return psPresetsJSON;
	}

    /**
     * Get the list of PS Presets to include
     *
     * @return JSON array containing the presets
     */
  ,	getPSPresetsJSON : function () {
	  
        var psPresetsJSON = '';
        var argDesc = new ActionDescriptor();

        argDesc.putString( stringIDToTypeID('presetKind'), 'all');
        argDesc.putBoolean(stringIDToTypeID('forFNFTDialog'), true); // gets the list filtered for this extension

        try {
           psPresetsJSON = getAppProperty(sTID('newDocPresetJSON'), argDesc);
        }
        catch (err) {
           alert('Could not retrieve Photoshop Presets JSON:\n\n' + err.message);
        }

	    return psPresetsJSON;
    }

    /**
     * Get the list of most recently used (MRU) Adobe Stock templates
     *
     * @return JSON array containing the list of MRU templates.
     */
  ,	getRecentlyUsedTemplatesJSON : function () {

		var mruJSON = '';

		try {
            mruJSON = getAppProperty(sTID('recentlyUsedCCLibrariesTemplateElements'));
		}
		catch (err) {
			if (err.number != this.CANCEL_ERROR_CODE) {
				alert ('Could not retrieve MRU Template JSON due to error (' + err.number + '):\n\n'+err.message);
			}
		}

	  	return mruJSON;
	}

    /**
     * Build a dictionary of mode-specific color profiles
     *
     * @return {object}
     */
  , getColorProfileLists: function () {
        var obj = {
            RGB: {
                STANDARD: this.getColorProfileList('rStd'),
                OTHER: this.getColorProfileList('rInp')
            },
            CMYK: {
                STANDARD: this.getColorProfileList('cSIn'),
                OTHER: this.getColorProfileList('cInp')
            },
            grayscale: {
                STANDARD: this.getColorProfileList('gStd'),
                OTHER: this.getColorProfileList('gInp')
            }
        };

        return obj;
    }

    /**
     * Get the list of valid Color Profiles
     *
     * @param {string} profile profile "category" such as rStd
     * @return Array.<string>
     */
  , getColorProfileList: function (profile) {

        var argDesc = new ActionDescriptor();

        argDesc.putInteger(stringIDToTypeID('profile'), charIDToTypeID(profile));

        try {
            var list = getAppProperty(stringIDToTypeID('colorProfileList'), argDesc);

            if (list && list.count > 0) {
                var out = new Array(list.count);
                for (var i =0; i < list.count; i++) {
                    out[i] = list.getString(i);
                }
                return out;
            }
            return [];
        }
        catch (e) {
            console.error('Failed to retrieve list of color profiles from photoshop with type %s', profile, e);
            return [];
        }
  }

    /**
     * Get various app and user config information
     *
	 * @param mode		string key for host data mode
     * @return JSON containing the config info
     */
  , getEnvironmentInfoJSON : function(mode) {

        var isFNFT = (mode && mode === 'fnft');
      
        var w = {
            userTrackingEnabled : false
          , firstName           : ''
          , lastName            : ''
          , subscription        : 'paid'
          , secondsLeftInTrial  : '0'
          , appStartClockTime   : '0'
          , countryCode         : 'US'
          , sessionGUID         : ''
          , accountType         : ''
          , displayMode         : 'welcome'
          , buttonInfo          : {
              create_button_newdocs : { }
            , create_button_open    : { }
              }
        };

        var kWelcomeStr           = charIDToTypeID('wlcm');
        var kentryStatusStr       = stringIDToTypeID('entryStatus');
        var kleftStr              = stringIDToTypeID('left');
        var kstartTimeStr         = stringIDToTypeID('startTime');
        var koptinStr             = stringIDToTypeID('optin');
        var kfirstStr             = stringIDToTypeID('first');
        var klastStr              = stringIDToTypeID('last');
        var kisoCountryCodeStr    = stringIDToTypeID('isoCountryCode');
        var kwelcomeScreenOpenStr = stringIDToTypeID('welcomeScreenOpen');
        var ksessionIDStr         = stringIDToTypeID('sessionID');
        var kaccountTypeStr       = stringIDToTypeID('accountType');
        var knewStr               = stringIDToTypeID('new');
        var kopenStr              = stringIDToTypeID('open');

        try {

            var welcomeDesc = getAppProperty(kWelcomeStr);

            if (welcomeDesc !== undefined) {

                if (welcomeDesc.count) {
                    w.userTrackingEnabled = welcomeDesc.getBoolean(koptinStr);
                    w.firstName           = welcomeDesc.getString(kfirstStr);
                    w.lastName            = welcomeDesc.getString(klastStr);
                    w.subscription        = (welcomeDesc.getInteger(kentryStatusStr) === 1) ? 'trial' : 'paid';
                    w.accountType         = welcomeDesc.getString(kaccountTypeStr);
                    w.secondsLeftInTrial  = (w.subscription === 'paid') ? 0 : welcomeDesc.getLargeInteger(kleftStr);
                    w.appStartClockTime   = welcomeDesc.getLargeInteger(kstartTimeStr);
                    w.countryCode         = welcomeDesc.getString(kisoCountryCodeStr);
                    w.sessionGUID         = welcomeDesc.getString(ksessionIDStr).replace(/-/g, '');
                    if (welcomeDesc.hasKey(kwelcomeScreenOpenStr)) {
                        w.displayMode       = welcomeDesc.getString(kwelcomeScreenOpenStr);
                    }
                    if (welcomeDesc.hasKey(knewStr)) {
                        w.buttonInfo.create_button_newdocs.shortcut = welcomeDesc.getString(knewStr);
                    }
                    if (welcomeDesc.hasKey(kopenStr)) {
                        w.buttonInfo.create_button_open.shortcut = welcomeDesc.getString(kopenStr);
                    }
                }
            }
        } catch( e ) { }

        w.colorProfileLists = this.getColorProfileLists();

        w.appVersion = app.version;
        w.platform = ( $.os.search(/windows/i) !== -1 ) ? 'win' : 'mac'
        w.locale = this.getLocale()
        w.userGUID = this.getDelegateGUID()
        
        if (!isFNFT) {
            w.startDSA = this.getDontShowAgain()
            w.fnftEnabled = !getAppProperty( sTID("generalPreferences") ).getBoolean( sTID("useClassicFileNewDialog" ));
        }
        
        return JSON.stringify(w);
    }

    /**
     * Retrieve list of pixel scale factors that may be applied to new documents
     *
     * @return {string} JSON string representation of {
     *   pixelScaleFactorList: <Array>.<{
     *     custom: boolean,
     *     name: string,
     *     value: number}>}
     */
  , getPixelScaleFactorJSON : function() {
	  
	  	return getAppProperty(sTID('pixelScaleFactorList'), undefined, true);
  }
    
    /**
     * Gets the data from Photoshop required to build the host application JSON
     *
	 * @param mode		string key for host data mode
     * @return JSON representation of the data.
     */
  , getInitJSON : function(mode) {
      
        var isFNFT = (mode && mode === 'fnft');
      
        // Retrieve all the JSON blocks we need from PS so that we can put
        // all behind one async evalExtendScript call.
        var supportJSONBlocks = {};
      
        supportJSONBlocks.envInfo = this.getEnvironmentInfoJSON(mode);
        
        if (isFNFT) {
            supportJSONBlocks.pixelScaleFactorList = this.getPixelScaleFactorJSON();
            supportJSONBlocks.fnftConfigInfo = this.getFNFTConfigInfoJSON();
        }
        else {
            supportJSONBlocks.recentFiles = this.getRecentFilesJSON();
        }
    	
	  	return JSONBlocksToJSONArray(supportJSONBlocks);
    }
    
    
    /**
     * Gets the data from Photoshop required to build the host application JSON
     *
	 * @param mode		string key for host data mode
     * @return JSON representation of the data.
     */
  , getPresetJSON : function(mode) {
      
        var isFNFT = (mode && mode === 'fnft');
      
        // Retrieve all the JSON blocks we need from PS so that we can put
        // all behind one async evalExtendScript call.
        var supportJSONBlocks = {};

        if (isFNFT) {
			supportJSONBlocks.mruPresets = this.getRecentlyUsedPresetsJSON();
			supportJSONBlocks.mruTemplates =  this.getRecentlyUsedTemplatesJSON();
			supportJSONBlocks.presets = this.getPSPresetsJSON();
        }
        
	  	return JSONBlocksToJSONArray(supportJSONBlocks);
    }
  

  /**
   * Create a new Preset from the current preset/template.
   * 
   * @param templateJSON  string containing the document parameters as JSON
   * @param templateName  string containing the template name
   * @return {[type]} [description]
   */
  , createPreset : function (templateJSON, templateName) {

    var argsDesc = new ActionDescriptor();

    var ref = new ActionReference();
    ref.putProperty(sTID('property'), sTID('newDocumentPreset'));
    
    if (templateName){
      argsDesc.putString(sTID('name'), templateName);
    }
    if (templateJSON){
      argsDesc.putString(sTID('newDocPresetJSON'), templateJSON);
    }
    ref.putEnumerated(sTID('application'), sTID('ordinal'), sTID('targetEnum'));

    argsDesc.putReference(sTID('target'), ref);
    var resultDesc = executeAction(sTID('set'), argsDesc, DialogModes.NO);
    return resultDesc.getString(sTID('newDocPresetJSON'));
  }

  /**
   * Deletes the current preset
   *
   * @param presetName   string containing the document name
   * @return {[type]} [description]
   */
  , deletePreset : function (presetName) {

    var argsDesc = new ActionDescriptor();

    var ref = new ActionReference();
    ref.putProperty(sTID('property'), sTID('deleteDocumentPreset'));

    if (presetName){
      argsDesc.putString(sTID('name'), presetName);
    }
    ref.putEnumerated(sTID('application'), sTID('ordinal'), sTID('targetEnum'));

    argsDesc.putReference(sTID('target'), ref);
    return executeAction(sTID('set'), argsDesc, DialogModes.NO);

  }
  /**
   * Create a document from the host preset/template.
   *
   * @param templateJSON	string containing the document parameters as JSON
	 * @param docName		string containing the document name
	 * @param showDialog	boolean to open the native dialog or not
   * @return status code indicating {success(true) or failure(false)
   */
  , createDocumentFromTemplate : function(templateJSON, docName, showDialog) {

      var status = false;
      var CANCEL_ERROR_CODE = 8007;
      var savedDialogMode = app.displayDialogs;

      try {
        // create the document description
        var documentParamDesc = new ActionDescriptor();

        documentParamDesc.putBoolean(stringIDToTypeID('forFNFTDialog'), true); // triggers some FNFT specific data validation
        documentParamDesc.putString(sTID('method'), 'FNFT'); // Provide context to PS for Highbeam analytics

        if (templateJSON){
          documentParamDesc.putString(stringIDToTypeID('presetJSON'), templateJSON);
        }
        if (docName){
          documentParamDesc.putString(stringIDToTypeID('name'), docName);
        }

        // If no parameters specified, we want the default PS new file behavior.
        if (!docName && !templateJSON)
            documentParamDesc.putBoolean(stringIDToTypeID('useDefault'), true);

        // create the exection action descriptor
        var eventDesc = new ActionDescriptor();

        eventDesc.putObject( stringIDToTypeID( 'new' ), stringIDToTypeID( 'document' ), documentParamDesc );
        eventDesc.putBoolean( stringIDToTypeID('forceRecording'), true );

        var resultDesc = executeAction( stringIDToTypeID( 'make' ), eventDesc, (showDialog ? DialogModes.ALL : DialogModes.ERROR) );

        status = (resultDesc.count > 0);
      }
      catch (err) {
        if (err.number != this.CANCEL_ERROR_CODE) {
          alert( 'Photoshop scripting error ('+err.number+'): ' + err.message );
        }
      }
      app.displayDialogs = savedDialogMode;

      return status;
    }

    /**
     * Open a document with the specified MRU list identifier.
     *
     * @param identifier        index into MRU list
     * @return A boolean value indicating the file was valid (true), or not (false)
     */
  , openDocumentWithMRUIdentifier : function( identifier, pipMethod ) {
        var mruIndex = parseInt(identifier, 10);
        filepath = mruIndex < this.mruPathCache.length ? this.mruPathCache[mruIndex] : null;
        return this.openDocumentWithPath(filepath, pipMethod);
    }

    /**
     * Open a document with the specified file path.
     *
     * @param filepath        path to the requested file
     * @return A boolean value indicating the file was valid (true), or not (false)
     */
  , openDocumentWithPath : function( filepath, pipMethod, isTemplate, ccLibElementRef ) {
        var savedDialogMode = app.displayDialogs;
        app.displayDialogs = DialogModes.NO;
        var status = true; // assume file is valid

        try {

          if (typeof filepath === 'string') {
            filepath = [filepath];
          }

          var filepathlen = filepath.length;

          for (var i = 0; i < filepathlen; i++) {

            var descOpen = new ActionDescriptor();
            var theFile = new File(filepath[i]);
            descOpen.putPath(sTID('null'), theFile);
            descOpen.putBoolean(sTID('forceRecording'), true);
            descOpen.putBoolean(sTID('overrideOpen'), true); /* suppress OS file picker*/
            descOpen.putBoolean(sTID('delayAutoVacuumHack'), true); /* run auto vac after this script exits so it does not get stuck */
            descOpen.putString(sTID('method'), pipMethod); /* for finer grain highbeam logging */

            
			if (isTemplate && ccLibElementRef) {
				
				// Force open as template behavior even if we don't have a template file type for some reason
				descOpen.putBoolean(sTID('template'), true);

            	// Provide element ref so PS can track recent
                var elementDesc = new ActionDescriptor();
                elementDesc.putString(sTID('elementReference'), ccLibElementRef);
                descOpen.putObject(sTID('ccLibrariesElement'), sTID('ccLibrariesElement'), elementDesc);
            }
			 
            if (theFile.exists) {
				try {
					// the ALL here shows file format options like ACR, EPS, type kit and auto vac BUT NOT OS open dialog (see above)
					var resultDesc = executeAction(sTID('open'), descOpen, DialogModes.ALL);

					// When forcing open as template, descriptor comes back empty because PS doesn't record it, so don't check for
					// an empty descriptor in that case.
					if (!isTemplate && resultDesc.count === 0) {
						status = false; // user canceled something
					}
				} catch(e) {
					status = false; // user canceled e.number === 8007 but let us catch everything out of file format open options
				}
            }
            else {

				try {
					// this should get it out of the MRU list and Photoshop will send us a request to get a new list with it missing
					executeAction(sTID('open'), descOpen, DialogModes.NO);
				} catch(e) { }

				var r = localize('$$$/Messages/RecentFileError=Cannot open the selected item ^0.');

				r = r.replace('^0', localize('$$$/ErrorStrings/FileCouldNotBeFound=because the file could not be found'));
				status = false;
				alert(r); /* this alert ok for release */
            }
          }
        }
		catch(err) {
			alert('Photoshop scripting error: '+err.message);
		}

        app.displayDialogs = savedDialogMode;
        return status;
    }

    /**
     * Open the applications default OS 'Open File' dialog.
     *
     * @return A boolean indicating a file was selected (true) or not (false)
     */
  , openDocumentWithUI : function(pipMethod) {

        try {
          var filepath = app.openDialog(); // this could be multiple files
          var status   = ( filepath && filepath.length > 0 && filepath[0].name.length > 0 );

          if (status) {
            status = this.openDocumentWithPath( filepath, pipMethod);
          }
          return status;
        } catch(e) { }
    }

    /**
     * Open the document(s) based on dropped files.
     *
     * @return A boolean indicating a file was selected (true) or not (false)
     */
  , openDroppedDocument : function( dropfilesJSON, pipMethod ) {

      try {
        var dropfiles = JSON.parse(dropfilesJSON);
        var filepath  = dropfiles.path || [];
        var status    = ( filepath && filepath.length > 0 && filepath[0].length > 0 );

        if (status) {
          status = this.openDocumentWithPath( filepath, pipMethod );
        }
        return status;
      } catch(e) { }
    }

    /**
     * Open the legacy native new document UI dialog.
     */
  , openLegacyNewDocumentDialog : function () {
    
        return this.createDocumentFromTemplate(null, null, true);
    }

    /**
     * Open the color picker dialog, seeded with the given color, and return a new color upon completion
     *
     * @param {string} colorJSON photoshop color object notation
     * @param {string} context Localized string context for the color picker dialog
     * @return {string} new color JSON
     */
  , openColorPicker : function (colorJSON, context) {
        var pickerDesc = new ActionDescriptor();

        pickerDesc.putString( stringIDToTypeID( 'context'), context);
        pickerDesc.putBoolean( stringIDToTypeID( 'newDocPresetJSON'), true);
        pickerDesc.putString( stringIDToTypeID( 'color' ), colorJSON);

        var resultDesc = executeAction( stringIDToTypeID('showColorPicker'), pickerDesc, DialogModes.ALL ),
            colorWasPicked = resultDesc.getBoolean( stringIDToTypeID('value')),
            colorJSON = resultDesc.getString(stringIDToTypeID('color'));

        if (!colorWasPicked) {
            return null;
        }
        return colorJSON;
    }

    /**
     * Given a valid photoshop color JSON object, return an associated RGB color object
     *
     * @param {string} colorJSON
     * @return {string}
     */
  , convertColorToRGB : function (colorJSON) {
        var pickerDesc = new ActionDescriptor();
        pickerDesc.putBoolean( stringIDToTypeID( 'newDocPresetJSON'), true);
        pickerDesc.putString( stringIDToTypeID( 'color' ), colorJSON);
        pickerDesc.putEnumerated(stringIDToTypeID( 'colorSpace'), stringIDToTypeID( 'colorSpace'), stringIDToTypeID('RGB'));

        var resultDesc = executeAction( stringIDToTypeID('convertColorToSpace'), pickerDesc, DialogModes.ALL );

        return resultDesc.getString(stringIDToTypeID('color'));
  }
};

/*************************************************************************
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by all applicable intellectual property
 * laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

/**
 * Premiere Pro Host ExtendScript Interface for CCX extensions
 */
CCXWelcomeXSHost_PPRO = {

    /**
     * Gets the user's personalization data from the host application as a JSON string.
     *
	 * @param mode		string key for host data mode
     * @return JSON string representation of the data.
     */
    getUserJSONData : function(mode) {
    
        var userData = app.getCCXUserJSONData(mode);

        return userData;
    }

    /**
     * Create and open the host's default document type.
     */
  , createDefaultDocument : function() {
    }

    /**
     * Open the host's document creation/template UI
     */
  , createDocumentFromTemplate : function() {
    }

    /**
     * Open a document with the specified file path.
     */
  , openDocumentWithPath : function( filepath ) {
//        var plugplugLib = new ExternalObject ("lib:" + "PlugPlugExternalObject");
//
//        if ( plugplugLib ) {
//
//            var csxsEvent = new CSXSEvent();
//
//            csxsEvent.type = "com.adobe.ccx.welcome.handleRecentFileOpen";
//            csxsEvent.data = filepath;
//            csxsEvent.dispatch();
//        }
//        else { alert("PlugPlugExternalObject not present in host application!"); }
    }
    
    /**
     * Sets the "Don't Show Again" preference in the host application.
     *
     * @param dontShowAgain     boolean value indicating true if "dont show again" was
     *                          requested, false otherwise
     */
  , setDontShowAgainPreference : function( dontShowAgain ) {

        app.dontShowWelcomeScreenAgain(dontShowAgain ? 1 : 0);
    }
};

/*! JSON v3.3.2 | http://bestiejs.github.io/json3 | Copyright 2012-2014, Kit Cambridge | http://kit.mit-license.org */
;(function () {
  // Detect the `define` function exposed by asynchronous module loaders. The
  // strict `define` check is necessary for compatibility with `r.js`.
  var isLoader = typeof define === "function" && define.amd;

  // A set of types used to distinguish objects from primitives.
  var objectTypes = {
    "function": true,
    "object": true
  };

  // Detect the `exports` object exposed by CommonJS implementations.
  var freeExports = objectTypes[typeof exports] && exports && !exports.nodeType && exports;

  // Use the `global` object exposed by Node (including Browserify via
  // `insert-module-globals`), Narwhal, and Ringo as the default context,
  // and the `window` object in browsers. Rhino exports a `global` function
  // instead.
  var root = objectTypes[typeof window] && window || this,
      freeGlobal = freeExports && objectTypes[typeof module] && module && !module.nodeType && typeof global == "object" && global;

  if (freeGlobal && (freeGlobal["global"] === freeGlobal || freeGlobal["window"] === freeGlobal || freeGlobal["self"] === freeGlobal)) {
    root = freeGlobal;
  }

  // Public: Initializes JSON 3 using the given `context` object, attaching the
  // `stringify` and `parse` functions to the specified `exports` object.
  function runInContext(context, exports) {
    context || (context = root["Object"]());
    exports || (exports = root["Object"]());

    // Native constructor aliases.
    var Number = context["Number"] || root["Number"],
        String = context["String"] || root["String"],
        Object = context["Object"] || root["Object"],
        Date = context["Date"] || root["Date"],
        SyntaxError = context["SyntaxError"] || root["SyntaxError"],
        TypeError = context["TypeError"] || root["TypeError"],
        Math = context["Math"] || root["Math"],
        nativeJSON = context["JSON"] || root["JSON"];

    // Delegate to the native `stringify` and `parse` implementations.
    if (typeof nativeJSON == "object" && nativeJSON) {
      exports.stringify = nativeJSON.stringify;
      exports.parse = nativeJSON.parse;
    }

    // Convenience aliases.
    var objectProto = Object.prototype,
        getClass = objectProto.toString,
        isProperty, forEach, undef;

    // Test the `Date#getUTC*` methods. Based on work by @Yaffle.
    var isExtended = new Date(-3509827334573292);
    try {
      // The `getUTCFullYear`, `Month`, and `Date` methods return nonsensical
      // results for certain dates in Opera >= 10.53.
      isExtended = isExtended.getUTCFullYear() == -109252 && isExtended.getUTCMonth() === 0 && isExtended.getUTCDate() === 1 &&
        // Safari < 2.0.2 stores the internal millisecond time value correctly,
        // but clips the values returned by the date methods to the range of
        // signed 32-bit integers ([-2 ** 31, 2 ** 31 - 1]).
        isExtended.getUTCHours() == 10 && isExtended.getUTCMinutes() == 37 && isExtended.getUTCSeconds() == 6 && isExtended.getUTCMilliseconds() == 708;
    } catch (exception) {}

    // Internal: Determines whether the native `JSON.stringify` and `parse`
    // implementations are spec-compliant. Based on work by Ken Snyder.
    function has(name) {
      if (has[name] !== undef) {
        // Return cached feature test result.
        return has[name];
      }
      var isSupported;
      if (name == "bug-string-char-index") {
        // IE <= 7 doesn't support accessing string characters using square
        // bracket notation. IE 8 only supports this for primitives.
        isSupported = "a"[0] != "a";
      } else if (name == "json") {
        // Indicates whether both `JSON.stringify` and `JSON.parse` are
        // supported.
        isSupported = has("json-stringify") && has("json-parse");
      } else {
        var value, serialized = '{"a":[1,true,false,null,"\\u0000\\b\\n\\f\\r\\t"]}';
        // Test `JSON.stringify`.
        if (name == "json-stringify") {
          var stringify = exports.stringify, stringifySupported = typeof stringify == "function" && isExtended;
          if (stringifySupported) {
            // A test function object with a custom `toJSON` method.
            (value = function () {
              return 1;
            }).toJSON = value;
            try {
              stringifySupported =
                // Firefox 3.1b1 and b2 serialize string, number, and boolean
                // primitives as object literals.
                stringify(0) === "0" &&
                // FF 3.1b1, b2, and JSON 2 serialize wrapped primitives as object
                // literals.
                stringify(new Number()) === "0" &&
                stringify(new String()) == '""' &&
                // FF 3.1b1, 2 throw an error if the value is `null`, `undefined`, or
                // does not define a canonical JSON representation (this applies to
                // objects with `toJSON` properties as well, *unless* they are nested
                // within an object or array).
                stringify(getClass) === undef &&
                // IE 8 serializes `undefined` as `"undefined"`. Safari <= 5.1.7 and
                // FF 3.1b3 pass this test.
                stringify(undef) === undef &&
                // Safari <= 5.1.7 and FF 3.1b3 throw `Error`s and `TypeError`s,
                // respectively, if the value is omitted entirely.
                stringify() === undef &&
                // FF 3.1b1, 2 throw an error if the given value is not a number,
                // string, array, object, Boolean, or `null` literal. This applies to
                // objects with custom `toJSON` methods as well, unless they are nested
                // inside object or array literals. YUI 3.0.0b1 ignores custom `toJSON`
                // methods entirely.
                stringify(value) === "1" &&
                stringify([value]) == "[1]" &&
                // Prototype <= 1.6.1 serializes `[undefined]` as `"[]"` instead of
                // `"[null]"`.
                stringify([undef]) == "[null]" &&
                // YUI 3.0.0b1 fails to serialize `null` literals.
                stringify(null) == "null" &&
                // FF 3.1b1, 2 halts serialization if an array contains a function:
                // `[1, true, getClass, 1]` serializes as "[1,true,],". FF 3.1b3
                // elides non-JSON values from objects and arrays, unless they
                // define custom `toJSON` methods.
                stringify([undef, getClass, null]) == "[null,null,null]" &&
                // Simple serialization test. FF 3.1b1 uses Unicode escape sequences
                // where character escape codes are expected (e.g., `\b` => `\u0008`).
                stringify({ "a": [value, true, false, null, "\x00\b\n\f\r\t"] }) == serialized &&
                // FF 3.1b1 and b2 ignore the `filter` and `width` arguments.
                stringify(null, value) === "1" &&
                stringify([1, 2], null, 1) == "[\n 1,\n 2\n]" &&
                // JSON 2, Prototype <= 1.7, and older WebKit builds incorrectly
                // serialize extended years.
                stringify(new Date(-8.64e15)) == '"-271821-04-20T00:00:00.000Z"' &&
                // The milliseconds are optional in ES 5, but required in 5.1.
                stringify(new Date(8.64e15)) == '"+275760-09-13T00:00:00.000Z"' &&
                // Firefox <= 11.0 incorrectly serializes years prior to 0 as negative
                // four-digit years instead of six-digit years. Credits: @Yaffle.
                stringify(new Date(-621987552e5)) == '"-000001-01-01T00:00:00.000Z"' &&
                // Safari <= 5.1.5 and Opera >= 10.53 incorrectly serialize millisecond
                // values less than 1000. Credits: @Yaffle.
                stringify(new Date(-1)) == '"1969-12-31T23:59:59.999Z"';
            } catch (exception) {
              stringifySupported = false;
            }
          }
          isSupported = stringifySupported;
        }
        // Test `JSON.parse`.
        if (name == "json-parse") {
          var parse = exports.parse;
          if (typeof parse == "function") {
            try {
              // FF 3.1b1, b2 will throw an exception if a bare literal is provided.
              // Conforming implementations should also coerce the initial argument to
              // a string prior to parsing.
              if (parse("0") === 0 && !parse(false)) {
                // Simple parsing test.
                value = parse(serialized);
                var parseSupported = value["a"].length == 5 && value["a"][0] === 1;
                if (parseSupported) {
                  try {
                    // Safari <= 5.1.2 and FF 3.1b1 allow unescaped tabs in strings.
                    parseSupported = !parse('"\t"');
                  } catch (exception) {}
                  if (parseSupported) {
                    try {
                      // FF 4.0 and 4.0.1 allow leading `+` signs and leading
                      // decimal points. FF 4.0, 4.0.1, and IE 9-10 also allow
                      // certain octal literals.
                      parseSupported = parse("01") !== 1;
                    } catch (exception) {}
                  }
                  if (parseSupported) {
                    try {
                      // FF 4.0, 4.0.1, and Rhino 1.7R3-R4 allow trailing decimal
                      // points. These environments, along with FF 3.1b1 and 2,
                      // also allow trailing commas in JSON objects and arrays.
                      parseSupported = parse("1.") !== 1;
                    } catch (exception) {}
                  }
                }
              }
            } catch (exception) {
              parseSupported = false;
            }
          }
          isSupported = parseSupported;
        }
      }
      return has[name] = !!isSupported;
    }

    if (!has("json")) {
      // Common `[[Class]]` name aliases.
      var functionClass = "[object Function]",
          dateClass = "[object Date]",
          numberClass = "[object Number]",
          stringClass = "[object String]",
          arrayClass = "[object Array]",
          booleanClass = "[object Boolean]";

      // Detect incomplete support for accessing string characters by index.
      var charIndexBuggy = has("bug-string-char-index");

      // Define additional utility methods if the `Date` methods are buggy.
      if (!isExtended) {
        var floor = Math.floor;
        // A mapping between the months of the year and the number of days between
        // January 1st and the first of the respective month.
        var Months = [0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334];
        // Internal: Calculates the number of days between the Unix epoch and the
        // first day of the given month.
        var getDay = function (year, month) {
          return Months[month] + 365 * (year - 1970) + floor((year - 1969 + (month = +(month > 1))) / 4) - floor((year - 1901 + month) / 100) + floor((year - 1601 + month) / 400);
        };
      }

      // Internal: Determines if a property is a direct property of the given
      // object. Delegates to the native `Object#hasOwnProperty` method.
      if (!(isProperty = objectProto.hasOwnProperty)) {
        isProperty = function (property) {
          var members = {}, constructor;
          if ((members.__proto__ = null, members.__proto__ = {
            // The *proto* property cannot be set multiple times in recent
            // versions of Firefox and SeaMonkey.
            "toString": 1
          }, members).toString != getClass) {
            // Safari <= 2.0.3 doesn't implement `Object#hasOwnProperty`, but
            // supports the mutable *proto* property.
            isProperty = function (property) {
              // Capture and break the object's prototype chain (see section 8.6.2
              // of the ES 5.1 spec). The parenthesized expression prevents an
              // unsafe transformation by the Closure Compiler.
              var original = this.__proto__, result = property in (this.__proto__ = null, this);
              // Restore the original prototype chain.
              this.__proto__ = original;
              return result;
            };
          } else {
            // Capture a reference to the top-level `Object` constructor.
            constructor = members.constructor;
            // Use the `constructor` property to simulate `Object#hasOwnProperty` in
            // other environments.
            isProperty = function (property) {
              var parent = (this.constructor || constructor).prototype;
              return property in this && !(property in parent && this[property] === parent[property]);
            };
          }
          members = null;
          return isProperty.call(this, property);
        };
      }

      // Internal: Normalizes the `for...in` iteration algorithm across
      // environments. Each enumerated key is yielded to a `callback` function.
      forEach = function (object, callback) {
        var size = 0, Properties, members, property;

        // Tests for bugs in the current environment's `for...in` algorithm. The
        // `valueOf` property inherits the non-enumerable flag from
        // `Object.prototype` in older versions of IE, Netscape, and Mozilla.
        (Properties = function () {
          this.valueOf = 0;
        }).prototype.valueOf = 0;

        // Iterate over a new instance of the `Properties` class.
        members = new Properties();
        for (property in members) {
          // Ignore all properties inherited from `Object.prototype`.
          if (isProperty.call(members, property)) {
            size++;
          }
        }
        Properties = members = null;

        // Normalize the iteration algorithm.
        if (!size) {
          // A list of non-enumerable properties inherited from `Object.prototype`.
          members = ["valueOf", "toString", "toLocaleString", "propertyIsEnumerable", "isPrototypeOf", "hasOwnProperty", "constructor"];
          // IE <= 8, Mozilla 1.0, and Netscape 6.2 ignore shadowed non-enumerable
          // properties.
          forEach = function (object, callback) {
            var isFunction = getClass.call(object) == functionClass, property, length;
            var hasProperty = !isFunction && typeof object.constructor != "function" && objectTypes[typeof object.hasOwnProperty] && object.hasOwnProperty || isProperty;
            for (property in object) {
              // Gecko <= 1.0 enumerates the `prototype` property of functions under
              // certain conditions; IE does not.
              if (!(isFunction && property == "prototype") && hasProperty.call(object, property)) {
                callback(property);
              }
            }
            // Manually invoke the callback for each non-enumerable property.
            for (length = members.length; property = members[--length]; hasProperty.call(object, property) && callback(property));
          };
        } else if (size == 2) {
          // Safari <= 2.0.4 enumerates shadowed properties twice.
          forEach = function (object, callback) {
            // Create a set of iterated properties.
            var members = {}, isFunction = getClass.call(object) == functionClass, property;
            for (property in object) {
              // Store each property name to prevent double enumeration. The
              // `prototype` property of functions is not enumerated due to cross-
              // environment inconsistencies.
              if (!(isFunction && property == "prototype") && !isProperty.call(members, property) && (members[property] = 1) && isProperty.call(object, property)) {
                callback(property);
              }
            }
          };
        } else {
          // No bugs detected; use the standard `for...in` algorithm.
          forEach = function (object, callback) {
            var isFunction = getClass.call(object) == functionClass, property, isConstructor;
            for (property in object) {
              if (!(isFunction && property == "prototype") && isProperty.call(object, property) && !(isConstructor = property === "constructor")) {
                callback(property);
              }
            }
            // Manually invoke the callback for the `constructor` property due to
            // cross-environment inconsistencies.
            if (isConstructor || isProperty.call(object, (property = "constructor"))) {
              callback(property);
            }
          };
        }
        return forEach(object, callback);
      };

      // Public: Serializes a JavaScript `value` as a JSON string. The optional
      // `filter` argument may specify either a function that alters how object and
      // array members are serialized, or an array of strings and numbers that
      // indicates which properties should be serialized. The optional `width`
      // argument may be either a string or number that specifies the indentation
      // level of the output.
      if (!has("json-stringify")) {
        // Internal: A map of control characters and their escaped equivalents.
        var Escapes = {
          92: "\\\\",
          34: '\\"',
          8: "\\b",
          12: "\\f",
          10: "\\n",
          13: "\\r",
          9: "\\t"
        };

        // Internal: Converts `value` into a zero-padded string such that its
        // length is at least equal to `width`. The `width` must be <= 6.
        var leadingZeroes = "000000";
        var toPaddedString = function (width, value) {
          // The `|| 0` expression is necessary to work around a bug in
          // Opera <= 7.54u2 where `0 == -0`, but `String(-0) !== "0"`.
          return (leadingZeroes + (value || 0)).slice(-width);
        };

        // Internal: Double-quotes a string `value`, replacing all ASCII control
        // characters (characters with code unit values between 0 and 31) with
        // their escaped equivalents. This is an implementation of the
        // `Quote(value)` operation defined in ES 5.1 section 15.12.3.
        var unicodePrefix = "\\u00";
        var quote = function (value) {
          var result = '"', index = 0, length = value.length, useCharIndex = !charIndexBuggy || length > 10;
          var symbols = useCharIndex && (charIndexBuggy ? value.split("") : value);
          for (; index < length; index++) {
            var charCode = value.charCodeAt(index);
            // If the character is a control character, append its Unicode or
            // shorthand escape sequence; otherwise, append the character as-is.
            switch (charCode) {
              case 8: case 9: case 10: case 12: case 13: case 34: case 92:
                result += Escapes[charCode];
                break;
              default:
                if (charCode < 32) {
                  result += unicodePrefix + toPaddedString(2, charCode.toString(16));
                  break;
                }
                result += useCharIndex ? symbols[index] : value.charAt(index);
            }
          }
          return result + '"';
        };

        // Internal: Recursively serializes an object. Implements the
        // `Str(key, holder)`, `JO(value)`, and `JA(value)` operations.
        var serialize = function (property, object, callback, properties, whitespace, indentation, stack) {
          var value, className, year, month, date, time, hours, minutes, seconds, milliseconds, results, element, index, length, prefix, result;
          try {
            // Necessary for host object support.
            value = object[property];
          } catch (exception) {}
          if (typeof value == "object" && value) {
            className = getClass.call(value);
            if (className == dateClass && !isProperty.call(value, "toJSON")) {
              if (value > -1 / 0 && value < 1 / 0) {
                // Dates are serialized according to the `Date#toJSON` method
                // specified in ES 5.1 section 15.9.5.44. See section 15.9.1.15
                // for the ISO 8601 date time string format.
                if (getDay) {
                  // Manually compute the year, month, date, hours, minutes,
                  // seconds, and milliseconds if the `getUTC*` methods are
                  // buggy. Adapted from @Yaffle's `date-shim` project.
                  date = floor(value / 864e5);
                  for (year = floor(date / 365.2425) + 1970 - 1; getDay(year + 1, 0) <= date; year++);
                  for (month = floor((date - getDay(year, 0)) / 30.42); getDay(year, month + 1) <= date; month++);
                  date = 1 + date - getDay(year, month);
                  // The `time` value specifies the time within the day (see ES
                  // 5.1 section 15.9.1.2). The formula `(A % B + B) % B` is used
                  // to compute `A modulo B`, as the `%` operator does not
                  // correspond to the `modulo` operation for negative numbers.
                  time = (value % 864e5 + 864e5) % 864e5;
                  // The hours, minutes, seconds, and milliseconds are obtained by
                  // decomposing the time within the day. See section 15.9.1.10.
                  hours = floor(time / 36e5) % 24;
                  minutes = floor(time / 6e4) % 60;
                  seconds = floor(time / 1e3) % 60;
                  milliseconds = time % 1e3;
                } else {
                  year = value.getUTCFullYear();
                  month = value.getUTCMonth();
                  date = value.getUTCDate();
                  hours = value.getUTCHours();
                  minutes = value.getUTCMinutes();
                  seconds = value.getUTCSeconds();
                  milliseconds = value.getUTCMilliseconds();
                }
                // Serialize extended years correctly.
                value = (year <= 0 || year >= 1e4 ? (year < 0 ? "-" : "+") + toPaddedString(6, year < 0 ? -year : year) : toPaddedString(4, year)) +
                  "-" + toPaddedString(2, month + 1) + "-" + toPaddedString(2, date) +
                  // Months, dates, hours, minutes, and seconds should have two
                  // digits; milliseconds should have three.
                  "T" + toPaddedString(2, hours) + ":" + toPaddedString(2, minutes) + ":" + toPaddedString(2, seconds) +
                  // Milliseconds are optional in ES 5.0, but required in 5.1.
                  "." + toPaddedString(3, milliseconds) + "Z";
              } else {
                value = null;
              }
            } else if (typeof value.toJSON == "function" && ((className != numberClass && className != stringClass && className != arrayClass) || isProperty.call(value, "toJSON"))) {
              // Prototype <= 1.6.1 adds non-standard `toJSON` methods to the
              // `Number`, `String`, `Date`, and `Array` prototypes. JSON 3
              // ignores all `toJSON` methods on these objects unless they are
              // defined directly on an instance.
              value = value.toJSON(property);
            }
          }
          if (callback) {
            // If a replacement function was provided, call it to obtain the value
            // for serialization.
            value = callback.call(object, property, value);
          }
          if (value === null) {
            return "null";
          }
          className = getClass.call(value);
          if (className == booleanClass) {
            // Booleans are represented literally.
            return "" + value;
          } else if (className == numberClass) {
            // JSON numbers must be finite. `Infinity` and `NaN` are serialized as
            // `"null"`.
            return value > -1 / 0 && value < 1 / 0 ? "" + value : "null";
          } else if (className == stringClass) {
            // Strings are double-quoted and escaped.
            return quote("" + value);
          }
          // Recursively serialize objects and arrays.
          if (typeof value == "object") {
            // Check for cyclic structures. This is a linear search; performance
            // is inversely proportional to the number of unique nested objects.
            for (length = stack.length; length--;) {
              if (stack[length] === value) {
                // Cyclic structures cannot be serialized by `JSON.stringify`.
                throw TypeError();
              }
            }
            // Add the object to the stack of traversed objects.
            stack.push(value);
            results = [];
            // Save the current indentation level and indent one additional level.
            prefix = indentation;
            indentation += whitespace;
            if (className == arrayClass) {
              // Recursively serialize array elements.
              for (index = 0, length = value.length; index < length; index++) {
                element = serialize(index, value, callback, properties, whitespace, indentation, stack);
                results.push(element === undef ? "null" : element);
              }
              result = results.length ? (whitespace ? "[\n" + indentation + results.join(",\n" + indentation) + "\n" + prefix + "]" : ("[" + results.join(",") + "]")) : "[]";
            } else {
              // Recursively serialize object members. Members are selected from
              // either a user-specified list of property names, or the object
              // itself.
              forEach(properties || value, function (property) {
                var element = serialize(property, value, callback, properties, whitespace, indentation, stack);
                if (element !== undef) {
                  // According to ES 5.1 section 15.12.3: "If `gap` {whitespace}
                  // is not the empty string, let `member` {quote(property) + ":"}
                  // be the concatenation of `member` and the `space` character."
                  // The "`space` character" refers to the literal space
                  // character, not the `space` {width} argument provided to
                  // `JSON.stringify`.
                  results.push(quote(property) + ":" + (whitespace ? " " : "") + element);
                }
              });
              result = results.length ? (whitespace ? "{\n" + indentation + results.join(",\n" + indentation) + "\n" + prefix + "}" : ("{" + results.join(",") + "}")) : "{}";
            }
            // Remove the object from the traversed object stack.
            stack.pop();
            return result;
          }
        };

        // Public: `JSON.stringify`. See ES 5.1 section 15.12.3.
        exports.stringify = function (source, filter, width) {
          var whitespace, callback, properties, className;
          if (objectTypes[typeof filter] && filter) {
            if ((className = getClass.call(filter)) == functionClass) {
              callback = filter;
            } else if (className == arrayClass) {
              // Convert the property names array into a makeshift set.
              properties = {};
              for (var index = 0, length = filter.length, value; index < length; value = filter[index++], ((className = getClass.call(value)), className == stringClass || className == numberClass) && (properties[value] = 1));
            }
          }
          if (width) {
            if ((className = getClass.call(width)) == numberClass) {
              // Convert the `width` to an integer and create a string containing
              // `width` number of space characters.
              if ((width -= width % 1) > 0) {
                for (whitespace = "", width > 10 && (width = 10); whitespace.length < width; whitespace += " ");
              }
            } else if (className == stringClass) {
              whitespace = width.length <= 10 ? width : width.slice(0, 10);
            }
          }
          // Opera <= 7.54u2 discards the values associated with empty string keys
          // (`""`) only if they are used directly within an object member list
          // (e.g., `!("" in { "": 1})`).
          return serialize("", (value = {}, value[""] = source, value), callback, properties, whitespace, "", []);
        };
      }

      // Public: Parses a JSON source string.
      if (!has("json-parse")) {
        var fromCharCode = String.fromCharCode;

        // Internal: A map of escaped control characters and their unescaped
        // equivalents.
        var Unescapes = {
          92: "\\",
          34: '"',
          47: "/",
          98: "\b",
          116: "\t",
          110: "\n",
          102: "\f",
          114: "\r"
        };

        // Internal: Stores the parser state.
        var Index, Source;

        // Internal: Resets the parser state and throws a `SyntaxError`.
        var abort = function () {
          Index = Source = null;
          throw SyntaxError();
        };

        // Internal: Returns the next token, or `"$"` if the parser has reached
        // the end of the source string. A token may be a string, number, `null`
        // literal, or Boolean literal.
        var lex = function () {
          var source = Source, length = source.length, value, begin, position, isSigned, charCode;
          while (Index < length) {
            charCode = source.charCodeAt(Index);
            switch (charCode) {
              case 9: case 10: case 13: case 32:
                // Skip whitespace tokens, including tabs, carriage returns, line
                // feeds, and space characters.
                Index++;
                break;
              case 123: case 125: case 91: case 93: case 58: case 44:
                // Parse a punctuator token (`{`, `}`, `[`, `]`, `:`, or `,`) at
                // the current position.
                value = charIndexBuggy ? source.charAt(Index) : source[Index];
                Index++;
                return value;
              case 34:
                // `"` delimits a JSON string; advance to the next character and
                // begin parsing the string. String tokens are prefixed with the
                // sentinel `@` character to distinguish them from punctuators and
                // end-of-string tokens.
                for (value = "@", Index++; Index < length;) {
                  charCode = source.charCodeAt(Index);
                  if (charCode < 32) {
                    // Unescaped ASCII control characters (those with a code unit
                    // less than the space character) are not permitted.
                    abort();
                  } else if (charCode == 92) {
                    // A reverse solidus (`\`) marks the beginning of an escaped
                    // control character (including `"`, `\`, and `/`) or Unicode
                    // escape sequence.
                    charCode = source.charCodeAt(++Index);
                    switch (charCode) {
                      case 92: case 34: case 47: case 98: case 116: case 110: case 102: case 114:
                        // Revive escaped control characters.
                        value += Unescapes[charCode];
                        Index++;
                        break;
                      case 117:
                        // `\u` marks the beginning of a Unicode escape sequence.
                        // Advance to the first character and validate the
                        // four-digit code point.
                        begin = ++Index;
                        for (position = Index + 4; Index < position; Index++) {
                          charCode = source.charCodeAt(Index);
                          // A valid sequence comprises four hexdigits (case-
                          // insensitive) that form a single hexadecimal value.
                          if (!(charCode >= 48 && charCode <= 57 || charCode >= 97 && charCode <= 102 || charCode >= 65 && charCode <= 70)) {
                            // Invalid Unicode escape sequence.
                            abort();
                          }
                        }
                        // Revive the escaped character.
                        value += fromCharCode("0x" + source.slice(begin, Index));
                        break;
                      default:
                        // Invalid escape sequence.
                        abort();
                    }
                  } else {
                    if (charCode == 34) {
                      // An unescaped double-quote character marks the end of the
                      // string.
                      break;
                    }
                    charCode = source.charCodeAt(Index);
                    begin = Index;
                    // Optimize for the common case where a string is valid.
                    while (charCode >= 32 && charCode != 92 && charCode != 34) {
                      charCode = source.charCodeAt(++Index);
                    }
                    // Append the string as-is.
                    value += source.slice(begin, Index);
                  }
                }
                if (source.charCodeAt(Index) == 34) {
                  // Advance to the next character and return the revived string.
                  Index++;
                  return value;
                }
                // Unterminated string.
                abort();
              default:
                // Parse numbers and literals.
                begin = Index;
                // Advance past the negative sign, if one is specified.
                if (charCode == 45) {
                  isSigned = true;
                  charCode = source.charCodeAt(++Index);
                }
                // Parse an integer or floating-point value.
                if (charCode >= 48 && charCode <= 57) {
                  // Leading zeroes are interpreted as octal literals.
                  if (charCode == 48 && ((charCode = source.charCodeAt(Index + 1)), charCode >= 48 && charCode <= 57)) {
                    // Illegal octal literal.
                    abort();
                  }
                  isSigned = false;
                  // Parse the integer component.
                  for (; Index < length && ((charCode = source.charCodeAt(Index)), charCode >= 48 && charCode <= 57); Index++);
                  // Floats cannot contain a leading decimal point; however, this
                  // case is already accounted for by the parser.
                  if (source.charCodeAt(Index) == 46) {
                    position = ++Index;
                    // Parse the decimal component.
                    for (; position < length && ((charCode = source.charCodeAt(position)), charCode >= 48 && charCode <= 57); position++);
                    if (position == Index) {
                      // Illegal trailing decimal.
                      abort();
                    }
                    Index = position;
                  }
                  // Parse exponents. The `e` denoting the exponent is
                  // case-insensitive.
                  charCode = source.charCodeAt(Index);
                  if (charCode == 101 || charCode == 69) {
                    charCode = source.charCodeAt(++Index);
                    // Skip past the sign following the exponent, if one is
                    // specified.
                    if (charCode == 43 || charCode == 45) {
                      Index++;
                    }
                    // Parse the exponential component.
                    for (position = Index; position < length && ((charCode = source.charCodeAt(position)), charCode >= 48 && charCode <= 57); position++);
                    if (position == Index) {
                      // Illegal empty exponent.
                      abort();
                    }
                    Index = position;
                  }
                  // Coerce the parsed value to a JavaScript number.
                  return +source.slice(begin, Index);
                }
                // A negative sign may only precede numbers.
                if (isSigned) {
                  abort();
                }
                // `true`, `false`, and `null` literals.
                if (source.slice(Index, Index + 4) == "true") {
                  Index += 4;
                  return true;
                } else if (source.slice(Index, Index + 5) == "false") {
                  Index += 5;
                  return false;
                } else if (source.slice(Index, Index + 4) == "null") {
                  Index += 4;
                  return null;
                }
                // Unrecognized token.
                abort();
            }
          }
          // Return the sentinel `$` character if the parser has reached the end
          // of the source string.
          return "$";
        };

        // Internal: Parses a JSON `value` token.
        var get = function (value) {
          var results, hasMembers;
          if (value == "$") {
            // Unexpected end of input.
            abort();
          }
          if (typeof value == "string") {
            if ((charIndexBuggy ? value.charAt(0) : value[0]) == "@") {
              // Remove the sentinel `@` character.
              return value.slice(1);
            }
            // Parse object and array literals.
            if (value == "[") {
              // Parses a JSON array, returning a new JavaScript array.
              results = [];
              for (;; hasMembers || (hasMembers = true)) {
                value = lex();
                // A closing square bracket marks the end of the array literal.
                if (value == "]") {
                  break;
                }
                // If the array literal contains elements, the current token
                // should be a comma separating the previous element from the
                // next.
                if (hasMembers) {
                  if (value == ",") {
                    value = lex();
                    if (value == "]") {
                      // Unexpected trailing `,` in array literal.
                      abort();
                    }
                  } else {
                    // A `,` must separate each array element.
                    abort();
                  }
                }
                // Elisions and leading commas are not permitted.
                if (value == ",") {
                  abort();
                }
                results.push(get(value));
              }
              return results;
            } else if (value == "{") {
              // Parses a JSON object, returning a new JavaScript object.
              results = {};
              for (;; hasMembers || (hasMembers = true)) {
                value = lex();
                // A closing curly brace marks the end of the object literal.
                if (value == "}") {
                  break;
                }
                // If the object literal contains members, the current token
                // should be a comma separator.
                if (hasMembers) {
                  if (value == ",") {
                    value = lex();
                    if (value == "}") {
                      // Unexpected trailing `,` in object literal.
                      abort();
                    }
                  } else {
                    // A `,` must separate each object member.
                    abort();
                  }
                }
                // Leading commas are not permitted, object property names must be
                // double-quoted strings, and a `:` must separate each property
                // name and value.
                if (value == "," || typeof value != "string" || (charIndexBuggy ? value.charAt(0) : value[0]) != "@" || lex() != ":") {
                  abort();
                }
                results[value.slice(1)] = get(lex());
              }
              return results;
            }
            // Unexpected token encountered.
            abort();
          }
          return value;
        };

        // Internal: Updates a traversed object member.
        var update = function (source, property, callback) {
          var element = walk(source, property, callback);
          if (element === undef) {
            delete source[property];
          } else {
            source[property] = element;
          }
        };

        // Internal: Recursively traverses a parsed JSON object, invoking the
        // `callback` function for each value. This is an implementation of the
        // `Walk(holder, name)` operation defined in ES 5.1 section 15.12.2.
        var walk = function (source, property, callback) {
          var value = source[property], length;
          if (typeof value == "object" && value) {
            // `forEach` can't be used to traverse an array in Opera <= 8.54
            // because its `Object#hasOwnProperty` implementation returns `false`
            // for array indices (e.g., `![1, 2, 3].hasOwnProperty("0")`).
            if (getClass.call(value) == arrayClass) {
              for (length = value.length; length--;) {
                update(value, length, callback);
              }
            } else {
              forEach(value, function (property) {
                update(value, property, callback);
              });
            }
          }
          return callback.call(source, property, value);
        };

        // Public: `JSON.parse`. See ES 5.1 section 15.12.2.
        exports.parse = function (source, callback) {
          var result, value;
          Index = 0;
          Source = "" + source;
          result = get(lex());
          // If a JSON string contains multiple tokens, it is invalid.
          if (lex() != "$") {
            abort();
          }
          // Reset the parser state.
          Index = Source = null;
          return callback && getClass.call(callback) == functionClass ? walk((value = {}, value[""] = result, value), "", callback) : result;
        };
      }
    }

    exports["runInContext"] = runInContext;
    return exports;
  }

  if (freeExports && !isLoader) {
    // Export for CommonJS environments.
    runInContext(root, freeExports);
  } else {
    // Export for web browsers and JavaScript engines.
    var nativeJSON = root.JSON,
        previousJSON = root["JSON3"],
        isRestored = false;

    var JSON3 = runInContext(root, (root["JSON3"] = {
      // Public: Restores the original value of the global `JSON` object and
      // returns a reference to the `JSON3` object.
      "noConflict": function () {
        if (!isRestored) {
          isRestored = true;
          root.JSON = nativeJSON;
          root["JSON3"] = previousJSON;
          nativeJSON = previousJSON = null;
        }
        return JSON3;
      }
    }));

    root.JSON = {
      "parse": JSON3.parse,
      "stringify": JSON3.stringify
    };
  }

  // Export for asynchronous module loaders.
  if (isLoader) {
    define(function () {
      return JSON3;
    });
  }
}).call(this);
