/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsdl.util.xml;

import com.ibm.wsdl.util.ObjectRegistry;
import com.ibm.wsdl.util.StringUtils;
import com.ibm.wsdl.util.xml.DOMUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOM2Writer {
    private static String NS_URI_XMLNS = "http://www.w3.org/2000/xmlns/";

    public static String nodeToString(Node node) {
        StringWriter stringWriter = new StringWriter();
        DOM2Writer.serializeAsXML(node, stringWriter);
        return stringWriter.toString();
    }

    public static void serializeAsXML(Node node, Writer writer) {
        DOM2Writer.print(node, null, new PrintWriter(writer));
    }

    private static void print(Node node, ObjectRegistry objectRegistry, PrintWriter printWriter) {
        if (node == null) {
            return;
        }
        boolean bl = false;
        short s = node.getNodeType();
        switch (s) {
            case 9: {
                printWriter.println("<?xml version=\"1.0\"?>");
                NodeList nodeList = node.getChildNodes();
                if (nodeList == null) break;
                int n = nodeList.getLength();
                int n2 = 0;
                while (n2 < n) {
                    DOM2Writer.print(nodeList.item(n2), objectRegistry, printWriter);
                    ++n2;
                }
                break;
            }
            case 1: {
                Object object;
                NamedNodeMap namedNodeMap;
                objectRegistry = new ObjectRegistry(objectRegistry);
                printWriter.print('<' + node.getNodeName());
                String string = node.getPrefix();
                String string2 = node.getNamespaceURI();
                if (string != null && string2 != null) {
                    boolean bl2 = false;
                    try {
                        String string3 = (String)objectRegistry.lookup(string);
                        if (string2.equals(string3)) {
                            bl2 = true;
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    if (!bl2) {
                        DOM2Writer.printNamespaceDecl(node, objectRegistry, printWriter);
                    }
                }
                int n = (namedNodeMap = node.getAttributes()) != null ? namedNodeMap.getLength() : 0;
                int n3 = 0;
                while (n3 < n) {
                    object = (Attr)namedNodeMap.item(n3);
                    printWriter.print(' ' + object.getNodeName() + "=\"" + DOM2Writer.normalize(object.getValue()) + '\"');
                    String string4 = object.getPrefix();
                    String string5 = object.getNamespaceURI();
                    if (string4 != null && string5 != null) {
                        boolean bl3 = false;
                        try {
                            String string6 = (String)objectRegistry.lookup(string4);
                            if (string5.equals(string6)) {
                                bl3 = true;
                            }
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                        if (!bl3) {
                            DOM2Writer.printNamespaceDecl((Node)object, objectRegistry, printWriter);
                        }
                    }
                    ++n3;
                }
                object = node.getChildNodes();
                if (object != null) {
                    int n4 = object.getLength();
                    boolean bl4 = bl = n4 > 0;
                    if (bl) {
                        printWriter.print('>');
                    }
                    int n5 = 0;
                    while (n5 < n4) {
                        DOM2Writer.print(object.item(n5), objectRegistry, printWriter);
                        ++n5;
                    }
                } else {
                    bl = false;
                }
                if (bl) break;
                printWriter.print("/>");
                break;
            }
            case 5: {
                printWriter.print('&');
                printWriter.print(node.getNodeName());
                printWriter.print(';');
                break;
            }
            case 4: {
                printWriter.print("<![CDATA[");
                printWriter.print(node.getNodeValue());
                printWriter.print("]]>");
                break;
            }
            case 3: {
                printWriter.print(DOM2Writer.normalize(node.getNodeValue()));
                break;
            }
            case 8: {
                printWriter.print("<!--");
                printWriter.print(node.getNodeValue());
                printWriter.print("-->");
                break;
            }
            case 7: {
                printWriter.print("<?");
                printWriter.print(node.getNodeName());
                String string = node.getNodeValue();
                if (string != null && string.length() > 0) {
                    printWriter.print(' ');
                    printWriter.print(string);
                }
                printWriter.println("?>");
            }
        }
        if (s == 1 && bl) {
            printWriter.print("</");
            printWriter.print(node.getNodeName());
            printWriter.print('>');
            bl = false;
        }
    }

    private static void printNamespaceDecl(Node node, ObjectRegistry objectRegistry, PrintWriter printWriter) {
        switch (node.getNodeType()) {
            case 2: {
                DOM2Writer.printNamespaceDecl(((Attr)node).getOwnerElement(), node, objectRegistry, printWriter);
                break;
            }
            case 1: {
                DOM2Writer.printNamespaceDecl((Element)node, node, objectRegistry, printWriter);
            }
        }
    }

    private static void printNamespaceDecl(Element element, Node node, ObjectRegistry objectRegistry, PrintWriter printWriter) {
        String string = node.getNamespaceURI();
        String string2 = node.getPrefix();
        if (!string.equals(NS_URI_XMLNS) || !string2.equals("xmlns")) {
            if (DOMUtils.getAttributeNS(element, NS_URI_XMLNS, string2) == null) {
                printWriter.print(" xmlns:" + string2 + "=\"" + string + '\"');
            }
        } else {
            string2 = node.getLocalName();
            string = node.getNodeValue();
        }
        objectRegistry.register(string2, string);
    }

    private static String normalize(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string != null ? string.length() : 0;
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            switch (c) {
                case '<': {
                    stringBuffer.append("&lt;");
                    break;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    break;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    break;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    break;
                }
                case '\n': {
                    if (n2 > 0) {
                        char c2 = stringBuffer.charAt(stringBuffer.length() - 1);
                        if (c2 != '\r') {
                            stringBuffer.append(StringUtils.lineSeparator);
                            break;
                        }
                        stringBuffer.append('\n');
                        break;
                    }
                    stringBuffer.append(StringUtils.lineSeparator);
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n2;
        }
        return stringBuffer.toString();
    }
}

