/*
 * Decompiled with CFR 0.152.
 */
package com.techtrader.modules.tools.bytecode;

import com.techtrader.modules.tools.bytecode.ClassInstruction;
import com.techtrader.modules.tools.bytecode.Code;
import com.techtrader.modules.tools.bytecode.Instruction;
import com.techtrader.modules.tools.bytecode.visitor.BCVisitor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class MultiANewArrayInstruction
extends ClassInstruction {
    private int _dims = 0;

    public MultiANewArrayInstruction setDimensions(int n) {
        this._dims = n;
        return this;
    }

    public int getDimensions() {
        return this._dims;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof MultiANewArrayInstruction)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        MultiANewArrayInstruction multiANewArrayInstruction = (MultiANewArrayInstruction)object;
        return this._dims == 0 || multiANewArrayInstruction._dims == 0 || this._dims == multiANewArrayInstruction._dims;
    }

    public int getLength() {
        return super.getLength() + 1;
    }

    public int getStackChange() {
        return -this.getDimensions() + 1;
    }

    protected void copy(Instruction instruction) {
        super.copy(instruction);
        this.setDimensions(((MultiANewArrayInstruction)instruction).getDimensions());
    }

    protected void readData(DataInput dataInput) throws IOException {
        super.readData(dataInput);
        this.setDimensions(dataInput.readUnsignedByte());
    }

    protected void writeData(DataOutput dataOutput) throws IOException {
        super.writeData(dataOutput);
        dataOutput.writeByte(this.getDimensions());
    }

    public void acceptVisit(BCVisitor bCVisitor) {
        bCVisitor.enterMultiANewArrayInstruction(this);
        bCVisitor.exitMultiANewArrayInstruction(this);
    }

    protected MultiANewArrayInstruction(Code code) {
        super(code, 197);
    }
}

