/*
 * Decompiled with CFR 0.152.
 */
package com.borland.xml.toolkit.generator;

import com.borland.xml.toolkit.generator.model.Child;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

class EntryList {
    private ArrayList entries = new ArrayList();

    EntryList() {
    }

    EntryList(Collection collection) {
        if (collection != null) {
            this.entries.addAll(collection);
        }
    }

    List getEntries() {
        return Collections.unmodifiableList(this.entries);
    }

    void addChildEntry(Child child) {
        if (child != null) {
            this.entries.add(child);
        }
    }

    void addEitherEntry(EntryList entryList, EntryList entryList2) {
        if (entryList != null && entryList2 != null) {
            this.entries.add(new EitherEntry(entryList, entryList2));
        }
    }

    void addEitherEntry(EitherEntry eitherEntry) {
        if (eitherEntry != null && eitherEntry.getLeftList() != null && eitherEntry.getRightList() != null) {
            this.entries.add(eitherEntry);
        }
    }

    List getAllChildren() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = ((AbstractList)this.entries).iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof Child) {
                arrayList.add(e);
                continue;
            }
            EitherEntry eitherEntry = (EitherEntry)e;
            EntryList entryList = eitherEntry.getLeftList();
            EntryList entryList2 = eitherEntry.getRightList();
            arrayList.addAll(entryList.getAllChildren());
            arrayList.addAll(entryList2.getAllChildren());
        }
        return arrayList;
    }

    static class EitherEntry {
        private EntryList left;
        private EntryList right;

        public EitherEntry() {
        }

        public EitherEntry(EntryList entryList, EntryList entryList2) {
            this.left = entryList;
            this.right = entryList2;
        }

        public EntryList getLeftList() {
            return this.left;
        }

        public void setLeftList(EntryList entryList) {
            this.left = entryList;
        }

        public EntryList getRightList() {
            return this.right;
        }

        public void setRightList(EntryList entryList) {
            this.right = entryList;
        }
    }
}

