/*
 * Decompiled with CFR 0.152.
 */
package com.borland.xml.toolkit;

import com.borland.xml.toolkit.XmlAttribute;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class Attribute
implements Serializable {
    private String name;
    private String type;
    private String defaultType;
    private String defaultValue;
    private String value;

    public Attribute(String string) {
        this.name = string;
    }

    public Attribute(String string, String string2) {
        this.name = string;
        this.value = string2;
    }

    public Attribute(String string, String string2, String string3, String string4) {
        this.name = string;
        this.type = string2;
        this.defaultType = string3;
        this.defaultValue = string4;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getDefaultType() {
        return this.defaultType;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setValue(XmlAttribute xmlAttribute) {
        this.value = xmlAttribute == null ? null : xmlAttribute.getValue();
    }

    public void setValue(String string) {
        this.value = string;
    }

    public String getValue() {
        return this.value;
    }

    public boolean getValueBoolean() {
        return new Boolean(this.value);
    }

    public void setValueBoolean(boolean bl) {
        this.value = new Boolean(bl).toString();
    }

    public double getValueDouble() throws NumberFormatException {
        return this.value == null ? 0.0 : Double.parseDouble(this.value);
    }

    public void setValueDouble(double d) {
        this.value = Double.toString(d);
    }

    public float getValueFloat() throws NumberFormatException {
        return this.value == null ? 0.0f : Float.parseFloat(this.value);
    }

    public void setValueFloat(float f) {
        this.value = Float.toString(f);
    }

    public long getValueLong() throws NumberFormatException {
        return this.value == null ? 0L : Long.parseLong(this.value);
    }

    public void setValueLong(long l) {
        this.value = Long.toString(l);
    }

    public int getValueInt() throws NumberFormatException {
        return this.value == null ? 0 : Integer.parseInt(this.value);
    }

    public void setValueInt(int n) {
        this.value = Integer.toString(n);
    }

    public short getValueShort() throws NumberFormatException {
        return this.value == null ? (short)0 : Short.parseShort(this.value);
    }

    public void setValueShort(short s) {
        this.value = Short.toString(s);
    }

    public BigDecimal getValueBigDecimal() throws NumberFormatException {
        return this.value == null ? null : new BigDecimal(this.value);
    }

    public void setValueBigDecimal(BigDecimal bigDecimal) {
        this.value = bigDecimal == null ? null : bigDecimal.toString();
    }

    public BigInteger getValueBigInteger() throws NumberFormatException {
        return this.value == null ? null : new BigInteger(this.value);
    }

    public void setValueBigInteger(BigInteger bigInteger) {
        this.value = bigInteger == null ? null : bigInteger.toString();
    }

    public String[] getChoices() {
        if (this.type.indexOf(40) == -1) {
            return new String[0];
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(this.type, "(| ");
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        return arrayList.toArray(new String[0]);
    }

    public boolean isEnumerated() {
        return this.type.indexOf(40) != -1;
    }

    public XmlAttribute marshal() {
        if (this.value != null && this.value.length() > 0) {
            return new XmlAttribute(this.name, this.value);
        }
        if (this.defaultValue != null && this.defaultValue.length() > 0) {
            return new XmlAttribute(this.name, this.defaultValue);
        }
        return null;
    }

    public static Attribute unmarshal(XmlAttribute xmlAttribute) {
        if (xmlAttribute == null) {
            return null;
        }
        return new Attribute(xmlAttribute.getName(), xmlAttribute.getValue());
    }
}

