/*
 * Decompiled with CFR 0.152.
 */
package com.borland.integration.tools.util;

import com.borland.integration.tools.util.Platform;
import com.borland.integration.tools.util.Runner;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Locale;

public class ShellRunner
extends Runner {
    private String shell;
    private String osName;

    public ShellRunner() {
        this.init();
        this.setDefaultShell();
    }

    public ShellRunner(String shell) {
        this.init();
        this.shell = shell;
    }

    private void init() {
        this.osName = System.getProperties().getProperty("os.name").toLowerCase();
    }

    public void setShell(String shell) {
        this.shell = shell;
    }

    public String getShell() {
        return this.shell;
    }

    private void setDefaultShell() {
        if (Platform.UNIX) {
            this.shell = "/bin/sh";
        } else if (Platform.WIN32) {
            this.shell = Platform.OS_NAME.indexOf("nt") != -1 ? "cmd /c" : (Platform.OS_NAME.indexOf("2000") != -1 ? "cmd /c" : "command.com /E:4096 /C");
        }
    }

    public void run(String[] cmds) {
        if (cmds == null) {
            return;
        }
        String cmd = this.createShellScript(cmds);
        if (Platform.WIN32) {
            cmd = "\"" + cmd + "\"";
        }
        this.executeCommand(this.shell + " " + cmd);
    }

    public void run(String cmd) {
        if (this.runDir != null || !this.runEnvironment.isEmpty()) {
            this.shellBasedCommand = cmd;
            if ((cmd = this.createShellScript(new String[]{cmd})) == null) {
                return;
            }
        }
        this.executeCommand(this.shell + " \"" + cmd + "\"");
    }

    protected String createShellScript(String[] cmds) {
        if (!Platform.UNIX && !Platform.WIN32) {
            return null;
        }
        String cvsScriptName = "cvscmd" + (Platform.WIN32 ? ".bat" : "");
        try {
            Locale currentLocale;
            File cvsCmd = new File(System.getProperties().getProperty("user.home") + File.separator + cvsScriptName);
            OutputStreamWriter writer = Platform.WIN32 ? ((currentLocale = Locale.getDefault()).getLanguage().equalsIgnoreCase("en") && !currentLocale.getCountry().equalsIgnoreCase("uk") ? new OutputStreamWriter((OutputStream)new FileOutputStream(cvsCmd), "Cp437") : new OutputStreamWriter((OutputStream)new FileOutputStream(cvsCmd), "Cp850")) : new OutputStreamWriter(new FileOutputStream(cvsCmd));
            PrintWriter cmdFile = new PrintWriter(writer);
            if (Platform.UNIX) {
                cmdFile.println("#!/bin/sh");
            } else if (Platform.WIN32) {
                cmdFile.println("@echo off");
            }
            Iterator iter = this.runEnvironment.keySet().iterator();
            while (iter.hasNext()) {
                String nextKey = (String)iter.next();
                String nextValue = (String)this.runEnvironment.get(nextKey);
                String setter = nextKey + "=" + (String)this.runEnvironment.get(nextKey);
                if (Platform.WIN32) {
                    cmdFile.println("set " + setter);
                    continue;
                }
                cmdFile.println(setter);
                cmdFile.println("export " + nextKey);
            }
            if (this.runDir != null) {
                if (Platform.WIN32) {
                    cmdFile.println(this.runDir.getAbsolutePath().substring(0, 2));
                }
                cmdFile.println("cd \"" + this.runDir.getAbsolutePath() + "\"");
            }
            for (int i = 0; i < cmds.length; ++i) {
                cmdFile.println(cmds[i]);
            }
            if (this.shell.indexOf("command") != -1) {
                File errorFile = new File(System.getProperties().getProperty("user.home") + File.separator + "error.txt");
                if (errorFile.exists()) {
                    errorFile.delete();
                }
                cmdFile.println("if ERRORLEVEL 1 GOTO failure");
                cmdFile.println("goto end");
                cmdFile.println(":failure");
                cmdFile.println("echo \"Error Occurred\" > \"" + errorFile.getCanonicalPath() + "\"");
                cmdFile.println(":end");
            }
            cmdFile.close();
            return cvsCmd.toString();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return null;
        }
    }

    public int getExitCode() {
        if (this.shell.indexOf("command") != -1) {
            File errorFile = new File(System.getProperties().getProperty("user.home") + File.separator + "error.txt");
            if (errorFile.exists()) {
                return -1;
            }
            return 0;
        }
        return this.exitCode;
    }

    public static void main(String[] arg) {
        ShellRunner r = new ShellRunner();
        for (int i = 0; i < arg.length; ++i) {
            System.out.println("Executing " + arg[i]);
            r.run(arg[i]);
            String stdout = new String(r.getRawStdout());
            System.out.println("StdOut: ");
            System.out.println(stdout);
            String stderr = new String(r.getRawStderr());
            System.out.println("StdErr: ");
            System.out.println(stderr);
            System.out.println("ExitCode: " + r.getExitCode());
        }
    }
}

