/*
 * Decompiled with CFR 0.152.
 */
package com.borland.integration.tools.util;

import com.borland.integration.tools.util.OSEnvironment;
import com.borland.integration.tools.util.RunnerListener;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class Runner {
    private BufferedInputStream out;
    private BufferedInputStream err;
    private BufferedWriter in = null;
    private Process process;
    private StringBuffer fullBuffer = new StringBuffer();
    protected int exitCode = -1;
    public static final int BUFFER_SIZE = 32768;
    public static final int CHECK_INTERVAL = 100;
    private static boolean messageViewEnabled = false;
    String shellBasedCommand = null;
    String messageReplacement = null;
    RunnerListener listener;
    private String stdinInput = null;
    private byte[] stdoutBuffer = new byte[32768];
    private ByteArrayOutputStream stdoutContent = new ByteArrayOutputStream();
    private byte[] stderrBuffer = new byte[32768];
    private ByteArrayOutputStream stderrContent = new ByteArrayOutputStream();
    protected File runDir = null;
    protected HashMap runEnvironment = new HashMap();
    protected boolean storageEnabled = true;
    static final int INWORD = 0;
    static final int INSTRING = 1;
    static final int SPACES = 2;

    public Runner() {
        this.initEnvironmentVariableStorage();
    }

    public Runner(RunnerListener listener) {
        this.setListener(listener);
    }

    private void initEnvironmentVariableStorage() {
        OSEnvironment osenv = new OSEnvironment();
        Enumeration varNames = osenv.getVariableNames();
        while (varNames.hasMoreElements()) {
            String varName = (String)varNames.nextElement();
            this.runEnvironment.put(varName, osenv.getVariable(varName));
        }
    }

    public void setStorageEnabled(boolean flag) {
        this.storageEnabled = flag;
    }

    public void setListener(RunnerListener listener) {
        this.listener = listener;
        this.setStorageEnabled(false);
    }

    public void setInput(String stdinInput) {
        this.stdinInput = stdinInput;
    }

    public void setDirectory(File runDir) {
        this.runDir = runDir;
    }

    public File getDirectory() {
        return this.runDir;
    }

    public void setEnvironmentVariable(String envName, String envValue) {
        if (this.runEnvironment.containsKey(envName)) {
            this.runEnvironment.remove(envName);
        }
        if (envValue != null) {
            this.runEnvironment.put(envName, envValue);
        }
    }

    public boolean hasEnvironmentVariable(String envName) {
        return this.runEnvironment.containsKey(envName);
    }

    public String getEnvironmentVariable(String envName) {
        return (String)this.runEnvironment.get(envName);
    }

    public void run(String cmd) {
        this.executeCommand(cmd);
    }

    public List convert(byte[] c) {
        ArrayList<String> lines = new ArrayList<String>();
        BufferedReader r = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(c)));
        String line = null;
        try {
            while ((line = r.readLine()) != null) {
                lines.add(line);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        return lines;
    }

    public List getStdout() {
        return this.convert(this.stdoutContent.toByteArray());
    }

    public List getStderr() {
        return this.convert(this.stderrContent.toByteArray());
    }

    public byte[] getRawStdout() {
        return this.stdoutContent.toByteArray();
    }

    public byte[] getRawStderr() {
        return this.stderrContent.toByteArray();
    }

    public static String[] parseCommand(String cmd) {
        ArrayList<String> words = new ArrayList<String>();
        StringBuffer word = new StringBuffer();
        int l = cmd.length();
        int state = 0;
        block5: for (int i = 0; i < l; ++i) {
            char ch = cmd.charAt(i);
            switch (state) {
                case 0: {
                    if (ch != ' ' && ch != '\"') {
                        word.append(ch);
                        continue block5;
                    }
                    if (ch == '\"' || ch == '\'') {
                        state = 1;
                        continue block5;
                    }
                    if (ch != ' ') continue block5;
                    words.add(new String(word));
                    word.setLength(0);
                    state = 2;
                    continue block5;
                }
                case 2: {
                    if (ch == ' ') continue block5;
                    if (ch == '\"') {
                        state = 1;
                        continue block5;
                    }
                    word.append(ch);
                    state = 0;
                    continue block5;
                }
                case 1: {
                    if (ch == '\"' || ch == '\'') {
                        words.add(new String(word));
                        word.setLength(0);
                        state = 2;
                        continue block5;
                    }
                    word.append(ch);
                    continue block5;
                }
                default: {
                    System.out.println("Parse error in reading command : " + (state == 0 ? "INWORD" : (state == 2 ? "SPACES" : "INSTRING")) + "ch == " + ch + " word == " + word);
                }
            }
        }
        if (word.length() > 0) {
            words.add(new String(word));
        }
        return words.toArray(new String[0]);
    }

    public void send(final String stdin) {
        if (stdin != null) {
            Thread responseRunner = new Thread(){

                public void run() {
                    try {
                        Runner.this.in.write(stdin);
                        Runner.this.in.flush();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
            responseRunner.start();
        }
    }

    protected void executeCommand(String cmd) {
        this.stderrContent = new ByteArrayOutputStream();
        this.stdoutContent = new ByteArrayOutputStream();
        Runtime runtime = Runtime.getRuntime();
        try {
            int runEnvSize = this.runEnvironment.size();
            if (runEnvSize > 0 || this.runDir != null) {
                String[] allVars = new String[runEnvSize];
                System.arraycopy(this.getEnvStrings(), 0, allVars, 0, runEnvSize);
                this.process = this.runDir != null ? runtime.exec(Runner.parseCommand(cmd), allVars, this.runDir) : runtime.exec(Runner.parseCommand(cmd), allVars);
            } else {
                this.process = runtime.exec(Runner.parseCommand(cmd));
            }
            this.out = new BufferedInputStream(this.process.getInputStream());
            this.err = new BufferedInputStream(this.process.getErrorStream());
            this.in = new BufferedWriter(new OutputStreamWriter(this.process.getOutputStream()));
            if (this.stdinInput != null) {
                this.send(this.stdinInput);
            }
            while (true) {
                try {
                    this.exitCode = this.process.exitValue();
                }
                catch (Exception ex) {
                    int i = this.out.available();
                    if (i > 0) {
                        this.copyOutput(this.out, this.stdoutContent, this.stdoutBuffer);
                    }
                    if ((i = this.err.available()) > 0) {
                        this.copyOutput(this.err, this.stderrContent, this.stderrBuffer);
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException iex) {}
                    continue;
                }
                break;
            }
            int i = this.out.available();
            if (i > 0) {
                this.copyOutput(this.out, this.stdoutContent, this.stdoutBuffer);
            }
            if ((i = this.err.available()) > 0) {
                this.copyOutput(this.err, this.stderrContent, this.stderrBuffer);
            }
            if (this.listener != null) {
                this.listener.processEnded();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String[] getEnvStrings() {
        String[] s = new String[this.runEnvironment.size()];
        Iterator i = this.runEnvironment.keySet().iterator();
        int pos = 0;
        while (i.hasNext()) {
            String k = (String)i.next();
            s[pos++] = k + "=" + (String)this.runEnvironment.get(k);
        }
        return s;
    }

    public int getExitCode() {
        return this.exitCode;
    }

    private void copyOutput(BufferedInputStream reader, ByteArrayOutputStream writer, byte[] buffer) {
        try {
            while (reader.available() > 0) {
                int num = reader.read(buffer, 0, buffer.length);
                if (this.listener != null) {
                    if (reader == this.out) {
                        this.listener.stdoutData(buffer, num);
                    } else {
                        this.listener.stderrData(buffer, num);
                    }
                }
                if (this.storageEnabled) {
                    writer.write(buffer, 0, num);
                }
                if (num >= buffer.length) continue;
                break;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void enableMessageViewOutput(boolean enabled) {
        messageViewEnabled = enabled;
    }

    public void setReplacementMessage(String msg) {
        this.messageReplacement = msg;
    }

    public static boolean isMessageViewEnabled() {
        return messageViewEnabled;
    }

    public static void setMessageViewEnabled(boolean b) {
        messageViewEnabled = b;
    }
}

