/*
 * Decompiled with CFR 0.152.
 */
package com.borland.integration.tools.util;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Date;

public class LogFile {
    RandomAccessFile log;

    public LogFile(String sFileName, String mode) throws IOException {
        if (mode.equals("w")) {
            new FileOutputStream(sFileName).close();
        }
        this.log = new RandomAccessFile(sFileName, "rw");
        this.log.seek(this.log.length());
    }

    public void close() throws IOException {
        this.log.close();
    }

    public void catFile(String sFile) throws IOException {
        int iBytes;
        byte[] buf = new byte[2048];
        FileInputStream fs = new FileInputStream(sFile);
        while ((iBytes = fs.read(buf)) > 0) {
            this.log.write(buf, 0, iBytes);
        }
    }

    public void write(int iByte) throws IOException {
        this.log.write(iByte);
    }

    public void print(String string) throws IOException {
        int startPos = 0;
        int endPos = 0;
        int len = string.length();
        while (startPos < len) {
            endPos = string.indexOf(10, startPos);
            if (endPos < 0) {
                if (startPos >= len) break;
                this.log.writeBytes(string.substring(startPos));
                break;
            }
            this.log.writeBytes(string.substring(startPos, endPos));
            this.log.writeBytes("\r\n");
            startPos = endPos + 1;
        }
    }

    public void println(String string) throws IOException {
        this.print(string);
        this.log.writeBytes("\r\n");
    }

    public void printDateln(String string) throws IOException {
        this.println("");
        this.print(new Date().toString() + ":  ");
        this.println(string);
    }
}

