/*
 * Decompiled with CFR 0.152.
 */
package com.borland.integration.tools.launcher.util;

import com.borland.integration.tools.launcher.dtd.Button;
import com.borland.integration.tools.launcher.dtd.ButtonAction;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.text.AttributedString;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class JInstallButton
extends JPanel
implements MouseListener {
    private static final long serialVersionUID = 1053L;
    private String buttonId;
    private Button launcherButton;
    private ButtonAction[] actionList;
    private Color btnTextColor = Color.white;
    private Font btnFont;
    private BufferedImage button;
    private BufferedImage model;
    private static int buttonWidthUnits = 13;
    private int buttonHeight = 0;
    private int buttonWidth = 0;
    private String btnText;
    private String btnToolTip;
    private boolean btnLocked;
    private String btnFontName;
    private int btnFontStyle;
    private int btnFontSize;
    private String btnMaxString;
    private TextLayout layout = null;
    private TextLayout maxLayout = null;
    private float textHeight = 0.0f;
    private float textMaxHeight = 0.0f;
    private float textWidth = 0.0f;
    private float textMaxWidth = 0.0f;
    private int textPad = 0;
    private boolean mouseIsPressed = false;
    private boolean mouseIsEntered = false;
    private boolean btnIsEnabled = false;
    private boolean isGreen = false;
    private Color ourGreen = new Color(46, 111, 210);

    public JInstallButton(String string, Button button, String string2, String string3, ButtonAction[] buttonActionArray, boolean bl, String string4, int n, int n2, String string5, String string6) {
        this.CoreSettings(string, button, string2, string3, buttonActionArray, bl, string4, n, n2, string5, string6);
        this.createButton();
    }

    private void CoreSettings(String string, Button button, String string2, String string3, ButtonAction[] buttonActionArray, boolean bl, String string4, int n, int n2, String string5, String string6) {
        this.btnFont = new Font(string4, n, n2);
        this.btnText = string2;
        this.btnToolTip = string3;
        this.setButtonId(string);
        this.actionList = buttonActionArray;
        this.launcherButton = button;
        this.btnLocked = bl;
        this.btnFontName = string4;
        this.btnFontStyle = n;
        this.btnFontSize = n2;
        this.btnMaxString = string6;
        if (string5.toLowerCase().equals("green")) {
            this.isGreen = true;
        }
        if (!string2.equals("")) {
            this.btnIsEnabled = true;
            Image image = this.isGreen ? (n2 == 10 ? new ImageIcon(JInstallButton.class.getResource("image/ButtongreenSm.gif")).getImage() : new ImageIcon(JInstallButton.class.getResource("image/Buttongreen.gif")).getImage()) : (n2 == 10 ? new ImageIcon(JInstallButton.class.getResource("image/ButtonSm.gif")).getImage() : new ImageIcon(JInstallButton.class.getResource("image/Button.gif")).getImage());
            MediaTracker mediaTracker = new MediaTracker(this);
            mediaTracker.addImage(image, 0);
            try {
                mediaTracker.waitForAll();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            try {
                this.model = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
                this.buttonHeight = this.model.getHeight();
                Graphics2D graphics2D = this.model.createGraphics();
                graphics2D.drawImage(image, 0, 0, null);
                this.setPreferredSize(new Dimension(buttonWidthUnits * 3, this.buttonHeight));
                this.addMouseListener(this);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void createButton() {
        if (this.btnIsEnabled) {
            FontRenderContext fontRenderContext = new FontRenderContext(null, true, true);
            AttributedString attributedString = new AttributedString(this.btnText);
            AttributedString attributedString2 = new AttributedString(this.btnMaxString);
            attributedString.addAttribute(TextAttribute.FONT, this.btnFont);
            attributedString2.addAttribute(TextAttribute.FONT, this.btnFont);
            if (this.isGreen) {
                attributedString.addAttribute(TextAttribute.BACKGROUND, this.ourGreen);
                attributedString2.addAttribute(TextAttribute.BACKGROUND, this.ourGreen);
            } else {
                attributedString.addAttribute(TextAttribute.BACKGROUND, Color.black);
                attributedString2.addAttribute(TextAttribute.BACKGROUND, Color.black);
            }
            this.layout = new TextLayout(attributedString.getIterator(), fontRenderContext);
            this.maxLayout = new TextLayout(attributedString2.getIterator(), fontRenderContext);
            this.textWidth = this.layout.getAdvance() + 0.5f;
            this.textMaxWidth = this.maxLayout.getAdvance() + 0.5f;
            this.textHeight = this.layout.getAscent();
            this.textMaxHeight = this.maxLayout.getAscent();
            this.buttonWidth = (int)this.textMaxWidth + buttonWidthUnits * 2;
            this.textPad = (int)((float)this.buttonWidth - this.textWidth) / 2;
            this.button = new BufferedImage(this.buttonWidth, this.buttonHeight, 2);
            WritableRaster writableRaster = this.model.getRaster();
            WritableRaster writableRaster2 = this.button.getRaster();
            int[] nArray = writableRaster.getPixels(0, 0, buttonWidthUnits, this.buttonHeight, (int[])null);
            writableRaster2.setPixels(0, 0, buttonWidthUnits, this.buttonHeight, nArray);
            nArray = writableRaster.getPixels(buttonWidthUnits + 1, 0, 1, this.buttonHeight, (int[])null);
            int n = 0;
            while ((float)n < this.textMaxWidth) {
                writableRaster2.setPixels(buttonWidthUnits + n, 0, 1, this.buttonHeight, nArray);
                ++n;
            }
            nArray = writableRaster.getPixels(buttonWidthUnits * 2, 0, buttonWidthUnits, this.buttonHeight, (int[])null);
            writableRaster2.setPixels(this.buttonWidth - buttonWidthUnits, 0, buttonWidthUnits, this.buttonHeight, nArray);
            this.setPreferredSize(new Dimension(this.buttonWidth, this.buttonHeight));
            this.setToolTipText(this.btnToolTip);
        }
    }

    private void drawText(Graphics2D graphics2D, Color color, boolean bl) {
        float f = 0.0f;
        float f2 = 0.0f;
        if (bl) {
            f = 1.0f;
            f2 = 1.0f;
        }
        graphics2D.setPaint(color);
        this.layout.draw(graphics2D, (float)this.textPad + f, this.textHeight + ((float)this.buttonHeight - this.textHeight) / 2.0f + f2 - 1.0f);
    }

    public void paint(Graphics graphics) {
        if (this.btnIsEnabled) {
            this.btnTextColor = this.mouseIsEntered ? this.getHighlightColor() : Color.white;
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.drawImage((Image)this.button, 0, 0, null);
            this.drawText(graphics2D, this.btnTextColor, this.mouseIsPressed);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.mouseIsEntered = true;
        Graphics graphics = this.getGraphics();
        this.paint(graphics);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.mouseIsPressed = false;
        this.mouseIsEntered = false;
        Graphics graphics = this.getGraphics();
        this.paint(graphics);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.mouseIsPressed = true;
        Graphics graphics = this.getGraphics();
        this.paint(graphics);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.mouseIsPressed = false;
        Graphics graphics = this.getGraphics();
        this.paint(graphics);
    }

    public void setFont(Font font) {
        this.btnFont = font;
    }

    public Font getFont() {
        return this.btnFont;
    }

    public void setText(String string) {
        this.btnText = string;
        this.createButton();
    }

    public String getText() {
        return this.btnText;
    }

    public void setToolTip(String string) {
        this.btnToolTip = string;
        this.createButton();
    }

    public String getToolTip() {
        return this.btnToolTip;
    }

    public void setActionList(ButtonAction[] buttonActionArray) {
        this.actionList = buttonActionArray;
    }

    public ButtonAction[] getActionList() {
        return this.actionList;
    }

    public void setLocked(boolean bl) {
        this.btnLocked = bl;
    }

    public boolean getLocked() {
        return this.btnLocked;
    }

    public void setFontStyle(int n) {
        this.btnFontStyle = n;
    }

    public int getFontStyle() {
        return this.btnFontStyle;
    }

    public void setFontSize(int n) {
        this.btnFontSize = n;
    }

    public int getFontSize() {
        return this.btnFontSize;
    }

    public void setFontName(String string) {
        this.btnFontName = string;
    }

    public String getFontName() {
        return this.btnFontName;
    }

    public boolean isEnabled() {
        return this.btnIsEnabled;
    }

    public void setButtonId(String string) {
        this.buttonId = string;
    }

    public String getButtonId() {
        return this.buttonId;
    }

    public boolean getIsTabbed() {
        String string = this.launcherButton.getIsTabbed();
        if (string == null) {
            return false;
        }
        return string.equals("true");
    }

    public Color getHighlightColor() {
        return new Color(177, 177, 251);
    }
}

