/*
 * Decompiled with CFR 0.152.
 */
package com.borland.integration.tools.launcher;

import com.borland.integration.tools.launcher.dtd.Action;
import com.borland.integration.tools.launcher.dtd.Button;
import com.borland.integration.tools.launcher.dtd.ButtonAction;
import com.borland.integration.tools.launcher.dtd.Command;
import com.borland.integration.tools.launcher.dtd.LauncherConfig;
import com.borland.integration.tools.launcher.dtd.Sku;
import com.borland.integration.tools.launcher.launcher;
import com.borland.integration.tools.launcher.state.StateUtil;
import com.borland.integration.tools.launcher.util.DialogManager;
import com.borland.integration.tools.launcher.util.DialogSelectInstall;
import com.borland.integration.tools.launcher.util.JInstallButton;
import com.borland.integration.tools.launcher.util.JPicturePanel;
import com.borland.integration.tools.launcher.util.LauncherXmlUtils;
import com.borland.integration.tools.launcher.util.ProcessThread;
import com.borland.integration.tools.util.IniFile;
import com.borland.integration.tools.util.IniFileSection;
import com.borland.jbcl.layout.XYConstraints;
import com.borland.jbcl.layout.XYLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.border.Border;

public class MainFrame
extends JFrame {
    private static final long serialVersionUID = 1001L;
    JPicturePanel Page1;
    JPicturePanel Page2;
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    Border border1;
    Border border2;
    JInstallButton InstallButton1;
    JInstallButton InstallButton2;
    JInstallButton InstallButton3;
    JInstallButton InstallButton4;
    JInstallButton InstallButton5;
    JInstallButton InstallButton6;
    JInstallButton InstallButton7;
    JInstallButton InstallButton8;
    JInstallButton InstallButton9;
    JInstallButton InstallButton10;
    JInstallButton InstallButton11;
    XYLayout xYLayout1 = new XYLayout();
    XYLayout xYLayout2 = new XYLayout();
    HashMap cfgResources = new HashMap();
    LauncherConfig launcherConfig = null;
    Sku launcherSkuConfig = null;
    int btnCount = 0;
    static final String DEFAULT_SKU = "ENT";
    static final String currentOS = System.getProperty("os.name").toLowerCase();
    static final String slash = System.getProperty("file.separator");
    static final boolean isMac = currentOS.substring(0, 3).equals("mac");
    static String currentLanguage = System.getProperty("user.language").toLowerCase();
    String SKU;
    String LANG;
    static DialogManager theDM;
    static final int valueInstall = 1;
    static final int valueCancel = 0;
    ProcessThread btnProcess;
    int idx;
    String launcherPartner = "";
    String msg = "";
    boolean isDialogCall = false;
    boolean isDiskChangeCall = false;
    boolean diskChangeMade = false;
    private DialogSelectInstall installDialog;
    int installDialogRV;
    HashMap installDialogHashMapRV;
    int installDialogNumItemsRV;
    String widestString;
    launcher parent;

    public MainFrame() {
        this.enableEvents(64L);
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private JInstallButton makeInstallButton(int n, String string, String string2) {
        --n;
        String string3 = this.launcherSkuConfig.getFont().getName();
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        String string8 = "";
        ButtonAction[] buttonActionArray = new ButtonAction[]{};
        Button button = null;
        if (n < this.launcherSkuConfig.getButtonCount()) {
            button = this.launcherSkuConfig.getButton(n);
            string4 = button.getId();
            string5 = button.getButtonTextText();
            string6 = button.getTooltipText();
            string7 = button.getColorText();
            string8 = button.getLockedText();
            buttonActionArray = button.getButtonAction();
        }
        string5 = string5 == null ? "" : string5;
        string6 = string6 == null ? "" : string6;
        string7 = string7 == null ? "" : string7;
        string8 = string8 == null ? string : string8;
        string3 = string3 == null ? string2 : string3;
        JInstallButton jInstallButton = new JInstallButton(string4, button, string5, string6, buttonActionArray, string8.equals("true"), string3, 1, 12, string7, this.widestString);
        jInstallButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                MainFrame.this.MainInstallLink_mouseClicked(mouseEvent);
            }
        });
        return jInstallButton;
    }

    private void jbInit() throws Exception {
        theDM = new DialogManager(this);
        this.getConfig();
        this.widestString = this.getMaxStrLen();
        String string = this.launcherSkuConfig.getIconImage();
        if (string == null || string.length() == 0) {
            System.err.println("Warning: IconImage not specified");
        } else {
            string = "image/" + string;
            this.setIconImage(new ImageIcon(MainFrame.class.getResource(string)).getImage());
        }
        String string2 = this.launcherSkuConfig.getMainImage();
        if (string2 == null || string2.length() == 0) {
            throw new RuntimeException("MainImage must be specified");
        }
        String string3 = this.launcherSkuConfig.getSecondImage();
        if (string3 == null || string3.length() == 0) {
            throw new RuntimeException("SecondImage must be specified");
        }
        string2 = "image/" + string2;
        string3 = "image/" + string3;
        this.Page1 = new JPicturePanel(MainFrame.class.getResourceAsStream(string2));
        this.Page2 = new JPicturePanel(MainFrame.class.getResourceAsStream(string3));
        this.Page1.setLayout(this.xYLayout1);
        this.Page2.setLayout(this.xYLayout2);
        this.getContentPane().setLayout(this.gridBagLayout1);
        this.launcherPartner = this.launcherSkuConfig.getPartner().getName();
        if (this.launcherPartner == null) {
            this.launcherPartner = "";
        }
        this.btnCount = this.launcherSkuConfig.getButton().length;
        this.InstallButton1 = this.makeInstallButton(1, "false", "black");
        if (this.InstallButton1.isEnabled()) {
            ++this.btnCount;
        }
        this.InstallButton2 = this.makeInstallButton(2, "false", "black");
        if (this.InstallButton2.isEnabled()) {
            ++this.btnCount;
        }
        this.InstallButton3 = this.makeInstallButton(3, "false", "black");
        if (this.InstallButton3.isEnabled()) {
            ++this.btnCount;
        }
        this.InstallButton4 = this.makeInstallButton(4, "false", "black");
        if (this.InstallButton4.isEnabled()) {
            ++this.btnCount;
        }
        this.InstallButton5 = this.makeInstallButton(5, "false", "black");
        if (this.InstallButton5.isEnabled()) {
            ++this.btnCount;
        }
        this.InstallButton6 = this.makeInstallButton(6, "false", "black");
        if (this.InstallButton6.isEnabled()) {
            ++this.btnCount;
        }
        this.InstallButton7 = this.makeInstallButton(7, "false", "black");
        if (this.InstallButton7.isEnabled()) {
            ++this.btnCount;
        }
        this.InstallButton8 = this.makeInstallButton(8, "false", "black");
        if (this.InstallButton8.isEnabled()) {
            ++this.btnCount;
        }
        this.InstallButton9 = this.makeInstallButton(9, "false", "black");
        if (this.InstallButton9.isEnabled()) {
            ++this.btnCount;
        }
        this.InstallButton10 = this.makeInstallButton(10, "false", "black");
        if (this.InstallButton10.isEnabled()) {
            ++this.btnCount;
        }
        this.InstallButton11 = this.makeInstallButton(11, "false", "black");
        if (this.InstallButton11.isEnabled()) {
            ++this.btnCount;
        }
        this.Page1.setMaximumSize(new Dimension(600, 400));
        this.Page1.setMinimumSize(new Dimension(600, 400));
        this.Page1.setPreferredSize(new Dimension(600, 400));
        int n = 150;
        int n2 = 35;
        this.Page1.add((Component)this.InstallButton1, new XYConstraints(18, n, -1, -1));
        this.Page1.add((Component)this.InstallButton2, new XYConstraints(18, n += n2, -1, -1));
        this.Page1.add((Component)this.InstallButton3, new XYConstraints(18, n += n2, -1, -1));
        this.Page1.add((Component)this.InstallButton4, new XYConstraints(18, n += n2, -1, -1));
        this.Page1.add((Component)this.InstallButton5, new XYConstraints(18, n += n2, -1, -1));
        this.Page1.add((Component)this.InstallButton6, new XYConstraints(18, n += n2, -1, 28));
        this.Page1.add((Component)this.InstallButton7, new XYConstraints(18, n += n2, -1, -1));
        this.Page1.add((Component)this.InstallButton8, new XYConstraints(18, n += n2, -1, -1));
        this.Page1.add((Component)this.InstallButton9, new XYConstraints(18, n += n2, -1, -1));
        this.Page1.add((Component)this.InstallButton10, new XYConstraints(18, n += n2, -1, -1));
        this.Page1.add((Component)this.InstallButton11, new XYConstraints(18, n += n2, -1, -1));
        n += n2;
        this.getContentPane().add((Component)this.Page1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.border1 = BorderFactory.createEmptyBorder();
        this.border2 = BorderFactory.createEmptyBorder();
        this.Page1.setBorder(this.border2);
        this.setSize(new Dimension(608, 434));
        this.setTitle(this.launcherSkuConfig.getTitleText());
        MainFrameWindowListener mainFrameWindowListener = new MainFrameWindowListener();
        mainFrameWindowListener.setLauncherSkuInfo(this.launcherSkuConfig);
        this.addWindowListener(mainFrameWindowListener);
    }

    private String safeGetResource(HashMap hashMap, String string) {
        String string2 = (String)hashMap.get(string);
        String string3 = "";
        if (string2 != null) {
            string3 = string2;
        }
        return string3;
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        super.processWindowEvent(windowEvent);
        if (windowEvent.getID() == 201) {
            System.exit(0);
        }
    }

    public void getConfig() {
        Object object;
        IniFile iniFile = new IniFile();
        this.launcherConfig = null;
        this.launcherSkuConfig = null;
        int n = currentOS.indexOf(32);
        if (n == -1) {
            n = currentOS.length();
        }
        if (iniFile.read(launcher.cdrootInitial + slash + "autorun.inf")) {
            object = iniFile.getSection("CONFIG");
            this.cfgResources = ((IniFileSection)object).getValuesHash();
            this.SKU = (String)this.cfgResources.get("SKU");
            this.LANG = (String)this.cfgResources.get("LANG");
            if (this.LANG != null) {
                currentLanguage = this.LANG.toLowerCase();
            }
        } else {
            this.SKU = DEFAULT_SKU;
        }
        object = "launcher_" + currentOS.substring(0, n).toLowerCase();
        object = currentLanguage.equals("de") || currentLanguage.equals("es") || currentLanguage.equals("fr") || currentLanguage.equals("ja") ? (String)object + "_" + currentLanguage + ".xml" : (String)object + ".xml";
        InputStream inputStream = MainFrame.class.getResourceAsStream((String)object);
        this.launcherConfig = LauncherConfig.unmarshal(inputStream);
        if (this.launcherConfig == null) {
            System.err.println("Unable to instantiate launcher config: ");
            System.exit(1);
        }
        Sku[] skuArray = this.launcherConfig.getSku();
        for (int i = 0; i < skuArray.length; ++i) {
            if (!skuArray[i].getName().equals(this.SKU)) continue;
            this.launcherSkuConfig = skuArray[i];
            break;
        }
        if (this.launcherSkuConfig == null) {
            System.err.println("Unable to match sku in xml configuration file to sku in autorun.inf");
            System.exit(2);
        }
    }

    private String getMaxStrLen() {
        String string = "";
        int n = this.launcherSkuConfig.getButtonCount();
        for (int i = 0; i < n; ++i) {
            if (this.launcherSkuConfig.getButton(i).getButtonTextText().length() <= string.length()) continue;
            string = this.launcherSkuConfig.getButton(i).getButtonTextText();
        }
        return string;
    }

    void MainInstallLink_mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() > 1) {
            mouseEvent.consume();
        }
        try {
            JInstallButton jInstallButton = (JInstallButton)mouseEvent.getSource();
            if (jInstallButton.getActionList().length == 1) {
                this.SingleAction_mouseClicked(mouseEvent);
            } else {
                this.MultipleAction_mouseClicked(jInstallButton);
            }
        }
        catch (Exception exception) {
            System.out.println("Exception while generating install button action: " + exception);
            exception.printStackTrace();
        }
    }

    public void paintImmediately() {
        this.Page1.paintImmediately();
    }

    public void MultipleAction_mouseClicked(JInstallButton jInstallButton) {
        boolean bl = false;
        boolean bl2 = false;
        String string = "";
        String string2 = "";
        theDM.DisplayInstallDialog(jInstallButton, jInstallButton.getText(), jInstallButton.getActionList(), jInstallButton.getLocked(), this.launcherSkuConfig, this.launcherConfig);
        this.paintImmediately();
        if (theDM.getInstallDialogRV() == 1) {
            this.idx = 0;
            while (this.idx < theDM.getInstallDialogNumItemsRV()) {
                if (theDM.getInstallDialogHashMapRV().get("Action" + (this.idx + 1) + "Selection").equals("true")) {
                    String string3 = jInstallButton.getActionList()[this.idx].getAction();
                    Action action = LauncherXmlUtils.getActionByName(string3, this.launcherConfig);
                    try {
                        boolean bl3;
                        theDM.DisplayDelayDialog(this.launcherSkuConfig.getTitleText(), "<html><center>" + this.launcherSkuConfig.getInstallProgressMessageText() + "<br>" + LauncherXmlUtils.getActionText(this.launcherSkuConfig.getName(), action) + "</center></html>");
                        this.paintImmediately();
                        Thread.sleep(5000L);
                        theDM.CloseDelayDialog();
                        this.paintImmediately();
                        boolean bl4 = false;
                        boolean bl5 = false;
                        do {
                            String string4;
                            bl4 = false;
                            String string5 = null;
                            string = "";
                            bl3 = false;
                            String string6 = LauncherXmlUtils.getDiskChangeMessage(this.launcherSkuConfig.getName(), action);
                            string2 = slash + LauncherXmlUtils.getCDLabelText(this.launcherSkuConfig.getName(), action);
                            if (string6 != null) {
                                this.isDiskChangeCall = true;
                                this.msg = string6;
                                if (action.getDiskverifyfileText() != null && (string = action.getDiskverifyfileText()).length() > 0) {
                                    string = launcher.cdroot + (launcher.isSolaris ? string2 : "") + slash + string;
                                }
                                boolean bl6 = bl5 = !new File(string).exists() || string.length() == 0;
                                if (bl5) {
                                    if (ProcessThread.testingLauncher()) {
                                        theDM.DisplayInfoAbortableDialog("Disk change test result", "<html><center>This file cannot be found:<br>" + string + "<br>action id:" + action.getId() + "</center></html>");
                                    } else {
                                        theDM.DisplayInfoAbortableDialog(this.launcherSkuConfig.getDiskChangeTitleText(), "<html><center>" + this.msg + "</center></html>");
                                    }
                                    if (theDM.getDisplayInfoAbortableDialogRV() == 0) {
                                        bl3 = true;
                                    }
                                }
                            }
                            if (bl3) continue;
                            if (this.isDiskChangeCall && bl5) {
                                this.paintImmediately();
                                Thread.sleep(15000L);
                            }
                            if (string.length() > 0 && !new File(string).exists()) {
                                bl4 = true;
                                continue;
                            }
                            if (action.getRebootRequired() != null && (string4 = action.getRebootRequired().trim()).equals("true")) {
                                bl2 = true;
                            }
                            for (int i = 0; i < action.getCommandCount(); ++i) {
                                string5 = action.getCommand(i).getArg();
                                if (string5.equals("DIALOG")) {
                                    String string7 = action.getCommand(i).getText();
                                    theDM.DisplayInfoDialog(this.launcherSkuConfig.getAdditionalActionTitleText(), "<html><center>" + string7 + "</center></html>");
                                    continue;
                                }
                                string5 = !string5.startsWith("@") ? launcher.cdroot + (launcher.isSolaris ? string2 : "") + slash + string5 : string5.substring(1);
                                string5 = ProcessThread.replaceTokens(string5, "$CDROOT", launcher.cdroot + (launcher.isSolaris ? string2 : ""));
                                this.btnProcess = new ProcessThread(this, string5);
                                this.btnProcess.setPriority(3);
                                this.btnProcess.start();
                                while (this.btnProcess.isAlive()) {
                                    Thread.sleep(200L);
                                    if (isMac) continue;
                                    this.paintImmediately();
                                }
                                if (!this.btnProcess.getErrOcurred()) continue;
                                bl = true;
                            }
                        } while (bl4);
                        bl3 = false;
                        this.isDialogCall = false;
                        this.isDiskChangeCall = false;
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
                ++this.idx;
            }
            if (!bl && !isMac) {
                if (!this.diskChangeMade) {
                    theDM.DisplayInfoDialog(this.launcherSkuConfig.getTitleText(), "<html><center>" + this.launcherSkuConfig.getInstallCompleteMessageText() + "</center></html>");
                    this.paintImmediately();
                } else {
                    theDM.DisplayInfoDialog(this.launcherSkuConfig.getTitleText(), "<html><center>" + this.launcherSkuConfig.getInstallCompleteReinsertMessageText() + "</center></html>");
                    try {
                        this.paintImmediately();
                        Thread.sleep(15000L);
                        System.exit(0);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
            }
            if (bl2) {
                theDM.DisplayInfoDialog(this.launcherSkuConfig.getRebootRequiredTitleText(), "<html><center>" + this.launcherSkuConfig.getRebootRequiredMessageText() + "</center></html>");
            }
        }
    }

    void SingleAction_mouseClicked(MouseEvent mouseEvent) {
        boolean bl = false;
        String string = "";
        String string2 = "";
        try {
            ButtonAction[] buttonActionArray = ((JInstallButton)mouseEvent.getSource()).getActionList();
            for (int i = 0; i < buttonActionArray.length; ++i) {
                String string3 = buttonActionArray[i].getAction();
                Action action = LauncherXmlUtils.getActionByName(string3, this.launcherConfig);
                boolean bl2 = false;
                String string4 = LauncherXmlUtils.getDiskChangeMessage(this.launcherSkuConfig.getName(), action);
                string2 = slash + LauncherXmlUtils.getCDLabelText(this.launcherSkuConfig.getName(), action);
                if (string4 != null) {
                    this.isDiskChangeCall = true;
                    theDM.DisplayDelayDialog(this.launcherSkuConfig.getTitleText(), "<html><center>" + this.launcherSkuConfig.getInstallProgressMessageText() + "<br>" + LauncherXmlUtils.getActionText(this.launcherSkuConfig.getName(), action) + "</center></html>");
                    this.paintImmediately();
                    Thread.sleep(5000L);
                    theDM.CloseDelayDialog();
                    this.msg = string4;
                    boolean bl3 = false;
                    if (action.getDiskverifyfileText() != null && (string = action.getDiskverifyfileText()).length() > 0) {
                        string = launcher.cdroot + (launcher.isSolaris ? string2 : "") + slash + string;
                    }
                    boolean bl4 = bl3 = !new File(string).exists() || string.length() == 0;
                    if (bl3) {
                        if (ProcessThread.testingLauncher()) {
                            theDM.DisplayInfoAbortableDialog("Disk change test result", "<html><center>This file cannot be found:<br>" + string + "<br>action id:" + action.getId() + "</center></html>");
                        } else {
                            theDM.DisplayInfoAbortableDialog(this.launcherSkuConfig.getDiskChangeTitleText(), "<html><center>" + this.msg + "</center></html>");
                        }
                        if (theDM.getDisplayInfoAbortableDialogRV() == 0) {
                            bl2 = true;
                        }
                    }
                }
                if (!bl2) {
                    String string5;
                    if (this.isDiskChangeCall) {
                        this.paintImmediately();
                        Thread.sleep(12000L);
                    }
                    if (action.getRebootRequired() != null && (string5 = action.getRebootRequired().trim()).equals("true")) {
                        bl = true;
                    }
                    Command[] commandArray = action.getCommand();
                    for (int j = 0; j < commandArray.length; ++j) {
                        Command command = commandArray[j];
                        String string6 = command.getArg();
                        if (string6.equals("DIALOG")) {
                            String string7 = action.getCommand(j).getText();
                            theDM.DisplayInfoDialog(this.launcherSkuConfig.getAdditionalActionTitleText(), "<html><center>" + string7 + "</center></html>");
                            continue;
                        }
                        string6 = !string6.startsWith("@") ? launcher.cdroot + (launcher.isSolaris ? string2 : "") + slash + string6 : string6.substring(1);
                        string6 = ProcessThread.replaceTokens(string6, "$CDROOT", launcher.cdroot);
                        this.btnProcess = new ProcessThread(this, string6);
                        this.btnProcess.setPriority(3);
                        this.btnProcess.start();
                        while (this.btnProcess.isAlive()) {
                            Thread.sleep(200L);
                            if (isMac) continue;
                            this.paintImmediately();
                        }
                    }
                    if (bl) {
                        theDM.DisplayInfoDialog(this.launcherSkuConfig.getRebootRequiredTitleText(), "<html><center>" + this.launcherSkuConfig.getRebootRequiredMessageText() + "</center></html>");
                    }
                }
                bl2 = false;
                this.isDialogCall = false;
                this.isDiskChangeCall = false;
            }
        }
        catch (Exception exception) {
            System.out.println("Exception while generating accessory button action: " + exception);
        }
    }

    class MainFrameWindowListener
    extends WindowAdapter {
        private Sku launcherSkuConfig = null;

        MainFrameWindowListener() {
        }

        public void windowOpened(WindowEvent windowEvent) {
            if (System.getProperty("os.name").toLowerCase().indexOf("windows") >= 0) {
                try {
                    if (!StateUtil.getStateResult("com.borland.integration.tools.launcher.state.IsAdminUser")) {
                        theDM.DisplayOKDialog(this.launcherSkuConfig.getAdminRequiredTitleText(), "<html>" + this.launcherSkuConfig.getAdminRequiredMessageText() + "</html>");
                        System.exit(0);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public void setLauncherSkuInfo(Sku sku) {
            this.launcherSkuConfig = sku;
        }
    }
}

