/*
 * Decompiled with CFR 0.152.
 */
package com.jobjects.jst.win32;

import com.jobjects.jst.RegistryException;
import com.jobjects.jst.RegistryKey;
import java.io.File;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class Win32RegKey
implements RegistryKey {
    private RegistryKey parent;
    private int keyType;
    private String name;
    private Vector enumBuffer;

    protected Win32RegKey(int type) {
        this.keyType = type;
        this.parent = null;
        this.name = null;
    }

    protected Win32RegKey(RegistryKey parent, String name) {
        this.keyType = 0;
        this.parent = parent;
        this.name = name;
    }

    public synchronized void putStringProperty(String name, String value) throws RegistryException {
        if (name == null) {
            throw new RegistryException("Property name is null.");
        }
        if (value == null) {
            throw new RegistryException("Can't set value to null.");
        }
        this._putString(name, value);
    }

    public synchronized String getStringProperty(String name) throws RegistryException {
        if (name == null) {
            throw new RegistryException("Property value is not specified (null)");
        }
        return this._getString(name);
    }

    public synchronized void removeProperty(String name) throws RegistryException {
        if (name == null) {
            throw new RegistryException("Property value is not specified (null)");
        }
        this._remove(name);
    }

    public RegistryKey getParent() {
        return this.parent;
    }

    public synchronized boolean exists() throws RegistryException {
        return this._exists();
    }

    public synchronized void removeKey() throws RegistryException {
        if (this.keyType != 0) {
            throw new RegistryException("Can't delete top level registry key.");
        }
        this._removeKey(((Win32RegKey)this.parent).getFullKeyPath(), this.name);
    }

    protected synchronized void addValueToEnumBuff(String val) {
        if (this.enumBuffer == null) {
            return;
        }
        this.enumBuffer.addElement(val);
    }

    public synchronized Enumeration properties() throws RegistryException {
        this.enumBuffer = new Vector();
        this._properties();
        return this.enumBuffer.elements();
    }

    public synchronized Enumeration subkeys() throws RegistryException {
        this.enumBuffer = new Vector();
        this._keys();
        return this.enumBuffer.elements();
    }

    protected int getKeyType() {
        return this.keyType;
    }

    public int getTopLevelKeyType() {
        if (this.keyType != 0) {
            return this.keyType;
        }
        return this.parent.getTopLevelKeyType();
    }

    protected String getFullKeyPath() {
        if (this.keyType != 0) {
            return "";
        }
        Win32RegKey p = (Win32RegKey)this.getParent();
        if (p.getKeyType() != 0) {
            return this.name;
        }
        return String.valueOf(String.valueOf(p.getFullKeyPath()).concat(String.valueOf("\\"))).concat(String.valueOf(this.name));
    }

    native void _putString(String var1, String var2) throws RegistryException;

    native String _getString(String var1) throws RegistryException;

    native void _remove(String var1) throws RegistryException;

    native void _removeKey(String var1, String var2) throws RegistryException;

    native boolean _exists();

    native void _properties();

    native void _keys();

    private native String _getLastErrorDescription();

    private static native String _getPathVariable();

    protected static String lookupForFile(String name, int where) {
        String path = "";
        if ((where & 1) != 0) {
            path = String.valueOf(path).concat(String.valueOf(System.getProperty("java.class.path")));
        }
        if ((where & 2) != 0) {
            path = String.valueOf(path).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(File.pathSeparator).concat(String.valueOf("."))).concat(String.valueOf(File.pathSeparator))).concat(String.valueOf(Win32RegKey._getPathVariable()))));
        }
        StringTokenizer tok = new StringTokenizer(path, File.pathSeparator);
        while (tok.hasMoreTokens()) {
            File lf;
            File f;
            String t = tok.nextToken().toLowerCase();
            if (t.equals(".")) {
                t = System.getProperty("user.dir");
            }
            if ((f = new File(t)).isFile() || t.endsWith(".zip") || t.endsWith(".jar")) {
                t = f.getParent();
                f = new File(t);
            }
            if ((lf = new File(f, name)).exists() && lf.isFile()) {
                return lf.getAbsolutePath();
            }
            lf = new File(new File(f, "..\\lib"), name);
            if (lf.exists() && lf.isFile()) {
                return lf.getAbsolutePath();
            }
            lf = new File(new File(f, "..\\bin"), name);
            if (!lf.exists() || !lf.isFile()) continue;
            return lf.getAbsolutePath();
        }
        return null;
    }

    static {
        String fullpath = Win32RegKey.lookupForFile("jst.dll", 1);
        if (fullpath != null) {
            System.load(fullpath);
        } else {
            System.loadLibrary("jst");
        }
    }
}

