/*
 * Decompiled with CFR 0.152.
 */
package com.jobjects.jst.win32;

import com.jobjects.jst.SystemToolkit;
import com.jobjects.jst.win32.SCM;
import java.lang.reflect.Method;

public class ControlMessagePeer {
    private static SCM scm = null;

    public static void onStart(String mainClass) {
        scm = (SCM)SystemToolkit.getServiceControlManager();
        new Thread(new ServiceThreadRunner(mainClass)).start();
    }

    public static void onStop() {
        if (scm == null) {
            return;
        }
        scm.notifyOnStop();
    }

    public static void onPause() {
        if (scm == null) {
            return;
        }
        scm.notifyOnPause();
    }

    public static void onContinue() {
        if (scm == null) {
            return;
        }
        scm.notifyOnContinue();
    }

    public static void onShutdown() {
        if (scm == null) {
            return;
        }
        scm.notifyOnShutdown();
    }

    static class ServiceThreadRunner
    implements Runnable {
        String srvcClassName;

        ServiceThreadRunner(String className) {
            this.srvcClassName = className;
        }

        public void run() {
            try {
                Class<?> srvcClass = Class.forName(this.srvcClassName);
                Class[] params = new Class[]{new String[0].getClass()};
                Method mainMtd = srvcClass.getMethod("main", params);
                if ((mainMtd.getModifiers() & 8) == 0) {
                    throw new Exception("Service main method must be 'static'.");
                }
                String[] param = new String[0];
                Object[] paramList = new Object[]{param};
                mainMtd.invoke(null, paramList);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

