/*
 * Decompiled with CFR 0.152.
 */
package com.jobjects.jst;

import com.jobjects.jst.RegistryManager;
import com.jobjects.jst.ServiceControlManager;
import com.jobjects.jst.win32.SCM;
import com.jobjects.jst.win32.Win32RegManager;

public class SystemToolkit {
    private static ServiceControlManager scm = null;
    private static RegistryManager regman = null;

    public static boolean doesSupportServices() {
        if (!SystemToolkit.checkArch()) {
            return false;
        }
        String os = System.getProperty("os.name");
        return os != null && os.indexOf("NT") != -1;
    }

    public static synchronized ServiceControlManager getServiceControlManager() {
        if (!SystemToolkit.doesSupportServices()) {
            return null;
        }
        if (scm != null) {
            return scm;
        }
        boolean isNT = true;
        String os = System.getProperty("os.name");
        if (os == null || os.indexOf("NT") == -1) {
            isNT = false;
        }
        if (!isNT) {
            return null;
        }
        scm = new SCM(isNT);
        return scm;
    }

    public static boolean doesSupportRegistry() {
        if (!SystemToolkit.checkArch()) {
            return false;
        }
        String os = System.getProperty("os.name");
        return os != null && os.indexOf("Windows") != -1;
    }

    public static synchronized RegistryManager getRegistryManager() {
        if (!SystemToolkit.doesSupportRegistry()) {
            return null;
        }
        if (regman != null) {
            return regman;
        }
        regman = new Win32RegManager();
        return regman;
    }

    private static boolean checkArch() {
        String arch = System.getProperty("os.arch");
        return arch != null && arch.equals("x86");
    }
}

