/*
 * Decompiled with CFR 0.152.
 */
package com.borland.xml.toolkit.generator;

import com.borland.xml.toolkit.InvalidDirectoryException;
import com.borland.xml.toolkit.InvalidParameterException;
import com.borland.xml.toolkit.generator.ExistingException;
import com.borland.xml.toolkit.generator.ModelConstants;
import com.borland.xml.toolkit.generator.model.Action;
import com.borland.xml.toolkit.generator.model.Dtd;
import com.borland.xml.toolkit.generator.model.InterfaceName;
import com.borland.xml.toolkit.generator.model.ObjectModel;
import com.borland.xml.toolkit.generator.model.ValidationPolicy;
import com.borland.xml.toolkit.generator.model._Class;
import com.borland.xml.toolkit.generator.model._Interface;
import com.borland.xml.toolkit.generator.model._Package;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.StringTokenizer;

public class DataModel
implements ModelConstants {
    protected ObjectModel model;
    protected _Package[] packages;
    protected _Package defaultPackage;
    protected String rootClassName;
    protected _Class rootClass;
    protected _Interface[] interfaces;
    protected _Class[] classes;
    protected Action[] validationActions;
    protected File outputDir = null;
    static Comparator classComparator = new Comparator(){

        public int compare(Object object, Object object2) {
            String string;
            String string2 = object instanceof _Class ? ((_Class)object).getNameText() : (String)object;
            String string3 = string = object2 instanceof _Class ? ((_Class)object2).getNameText() : (String)object2;
            return string2 == null ? 0 : (string == null ? 1 : string2.compareTo(string));
        }

        public boolean equals(Object object) {
            return false;
        }
    };
    static Comparator interfaceComparator = new Comparator(){

        public int compare(Object object, Object object2) {
            String string;
            String string2 = object instanceof _Interface ? ((_Interface)object).getNameText() : (String)object;
            String string3 = string = object2 instanceof _Interface ? ((_Interface)object2).getNameText() : (String)object2;
            return string2 == null ? 0 : (string == null ? 1 : string2.compareTo(string));
        }

        public boolean equals(Object object) {
            return false;
        }
    };

    public DataModel() throws MissingRootClassException {
        ObjectModel objectModel = new ObjectModel();
        objectModel.setDtd(new Dtd());
        objectModel.add_Package(DataModel.createDefaultPackage());
        objectModel.setRootClassText("RootElement");
        objectModel.add_Class(DataModel.createPCDATAClass("RootElement", "root-element"));
        this.init(objectModel);
    }

    public DataModel(ObjectModel objectModel) throws MissingRootClassException, InvalidParameterException {
        if (objectModel == null) {
            throw new InvalidParameterException("model is null");
        }
        this.init(objectModel);
    }

    public DataModel(InputStream inputStream) throws MissingRootClassException, InvalidParameterException {
        this(ObjectModel.unmarshal(inputStream));
    }

    public DataModel(File file) throws MissingRootClassException, InvalidParameterException {
        this(ObjectModel.unmarshal(file));
    }

    public DataModel(String string) throws MissingRootClassException, InvalidParameterException {
        this(ObjectModel.unmarshal(string));
    }

    public DataModel(Reader reader) throws MissingRootClassException, InvalidParameterException {
        this(ObjectModel.unmarshal(reader));
    }

    protected void init(ObjectModel objectModel) throws MissingRootClassException {
        Serializable serializable;
        String string = System.getProperty("OUTPUT_DIR");
        if (string != null && string.length() > 0) {
            serializable = new File(string);
            if (((File)serializable).isDirectory()) {
                this.outputDir = serializable;
            } else {
                System.out.println("\"OUTPUT_DIR\" contains an invalid directory; current directory is used as the ouput directory");
            }
        }
        if (objectModel == null) {
            throw new IllegalArgumentException("model is null");
        }
        this.model = objectModel;
        if (objectModel.isNo_Package()) {
            objectModel.add_Package(DataModel.createDefaultPackage());
        }
        this.packages = objectModel.get_Package();
        this.defaultPackage = this.findPackage("default");
        this.interfaces = objectModel.get_Interface();
        this.sortInterfaces();
        this.classes = objectModel.get_Class();
        this.sortClasses();
        serializable = objectModel.getValidationPolicy();
        if (serializable != null) {
            this.validationActions = ((ValidationPolicy)serializable).getAction();
        }
        this.rootClassName = objectModel.getRootClassText();
        this.rootClass = this.findClass(this.rootClassName);
        if (this.rootClass == null) {
            throw new MissingRootClassException();
        }
    }

    public void sortClasses() {
        if (this.classes != null) {
            Arrays.sort(this.classes, classComparator);
        }
    }

    public void sortInterfaces() {
        if (this.interfaces != null) {
            Arrays.sort(this.interfaces, interfaceComparator);
        }
    }

    public ObjectModel getObjectModel() {
        return this.model;
    }

    public String getSystemId() {
        return this.model.getDtd().getSystemIdText();
    }

    public String getPublicId() {
        return this.model.getDtd().getPublicIdText();
    }

    public void setSystemId(String string) {
        this.model.getDtd().setSystemIdText(string);
    }

    public void setPublicId(String string) {
        this.model.getDtd().setPublicIdText(string);
    }

    public _Class getRootClass() {
        return this.rootClass;
    }

    public _Package[] getPackages() {
        return this.packages;
    }

    public _Package getDefaultPackage() {
        return this.defaultPackage;
    }

    public _Class[] getClasses() {
        return this.classes;
    }

    public _Interface[] getInterfaces() {
        return this.interfaces;
    }

    public boolean isRootClass(_Class _Class2) {
        String string = _Class2.getNameText();
        return this.rootClassName == null ? false : this.rootClassName.equals(string);
    }

    public boolean isRootClass(String string) {
        return this.isRootClass(this.findClass(string));
    }

    public boolean isTextClass(_Class _Class2) {
        return _Class2 != null && _Class2.isNoChild() && _Class2.isNoEither() && !this.isEmptyClass(_Class2);
    }

    public boolean isTextClass(String string) {
        return this.isTextClass(this.findClass(string));
    }

    public boolean isEmptyClass(_Class _Class2) {
        return _Class2.isEmpty();
    }

    public boolean isEmptyClass(String string) {
        return this.isEmptyClass(this.findClass(string));
    }

    public boolean isElementClass(_Class _Class2) {
        return _Class2 != null && (!_Class2.isNoChild() || !_Class2.isNoEither());
    }

    public boolean isElementClass(String string) {
        return this.isElementClass(this.findClass(string));
    }

    public boolean hasValueType(_Class _Class2) {
        return _Class2 != null && _Class2.getValueTypeText() != null && _Class2.getValueTypeText().length() > 0;
    }

    public boolean hasValueType(String string) {
        return this.hasValueType(this.findClass(string));
    }

    public String[] getInterfaceNames(_Class _Class2) {
        InterfaceName[] interfaceNameArray = _Class2.getInterfaceName();
        String[] stringArray = new String[interfaceNameArray.length];
        int n = 0;
        while (n < interfaceNameArray.length) {
            _Interface _Interface2 = this.findInterface(interfaceNameArray[n].getText());
            if (_Interface2 != null) {
                String string;
                StringBuffer stringBuffer = new StringBuffer(80);
                String string2 = _Interface2.getPackageRefNameText();
                _Package _Package2 = this.findPackage(string2);
                if (_Package2 != null && (string = _Package2.getPackageNameText()) != null && !string.equals(".")) {
                    stringBuffer.append(string);
                    if (!string.endsWith(".")) {
                        stringBuffer.append('.');
                    }
                }
                stringBuffer.append(_Interface2.getNameText());
                stringArray[n] = stringBuffer.toString();
            }
            ++n;
        }
        return stringArray;
    }

    public HashSet getInterfacePackages(String string, _Class _Class2) {
        HashSet<String> hashSet = new HashSet<String>();
        if (_Class2 == null) {
            return hashSet;
        }
        InterfaceName[] interfaceNameArray = _Class2.getInterfaceName();
        int n = 0;
        while (n < interfaceNameArray.length) {
            _Interface _Interface2 = this.findInterface(interfaceNameArray[n].getText());
            if (_Interface2 != null) {
                String string2;
                StringBuffer stringBuffer = new StringBuffer(80);
                String string3 = _Interface2.getPackageRefNameText();
                _Package _Package2 = this.findPackage(string3);
                if (_Package2 != null && (string2 = _Package2.getPackageNameText()) != null && !string2.equals(".") && !string2.equals(string)) {
                    hashSet.add(string2);
                }
            }
            ++n;
        }
        return hashSet;
    }

    public _Class findClass(String string) {
        if (this.classes == null || string == null) {
            return null;
        }
        int n = Arrays.binarySearch(this.classes, string, classComparator);
        return n >= 0 ? this.classes[n] : null;
    }

    public _Interface findInterface(String string) {
        if (this.interfaces == null || string == null) {
            return null;
        }
        int n = Arrays.binarySearch(this.interfaces, string, interfaceComparator);
        return n >= 0 ? this.interfaces[n] : null;
    }

    public _Package findPackage(String string) {
        if (string == null || string.length() == 0) {
            return this.defaultPackage;
        }
        if (this.packages == null) {
            return null;
        }
        int n = 0;
        while (n < this.packages.length) {
            String string2 = this.packages[n].getPackageRefNameText();
            if (string2 != null && string2.equals(string)) {
                return this.packages[n];
            }
            ++n;
        }
        return null;
    }

    public boolean containsPackage(_Package _Package2) {
        if (_Package2 == null || this.packages == null) {
            return false;
        }
        int n = 0;
        while (n < this.packages.length) {
            if (_Package2.equals(this.packages[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static _Package createDefaultPackage() {
        return DataModel.createPackage("default", ".", "overwrite");
    }

    public static _Package createPackage(String string, String string2, String string3) {
        _Package _Package2 = new _Package();
        _Package2.setPackageRefNameText(string);
        _Package2.setPackageNameText(string2);
        _Package2.setWritePolicyText(string3);
        return _Package2;
    }

    public boolean add_Package(_Package _Package2) throws ExistingException {
        if (_Package2 != null && this.findPackage(_Package2.getPackageRefNameText()) != null) {
            throw new ExistingException(_Package2.getPackageRefNameText());
        }
        if (_Package2 != null && this.model.add_Package(_Package2)) {
            this.packages = this.model.get_Package();
            return true;
        }
        return false;
    }

    public _Package add_Package(String string, String string2, String string3) throws ExistingException {
        _Package _Package2 = DataModel.createPackage(string, string2, string3);
        return this.add_Package(_Package2) ? _Package2 : null;
    }

    public static _Interface createInterface(String string) {
        _Interface _Interface2 = new _Interface();
        _Interface2.setNameText(string);
        return _Interface2;
    }

    public boolean add_Interface(String string, _Interface _Interface2) throws ExistingException {
        if (_Interface2 == null) {
            return false;
        }
        if (this.findInterface(_Interface2.getNameText()) != null) {
            throw new ExistingException(_Interface2.getNameText());
        }
        _Package _Package2 = this.findPackage(string);
        if (_Package2 == null) {
            return false;
        }
        _Interface2.setPackageRefNameText(_Package2.getPackageRefNameText());
        if (this.model.add_Interface(_Interface2)) {
            this.interfaces = this.model.get_Interface();
            this.sortInterfaces();
            return true;
        }
        return false;
    }

    public void refresh() {
        this.classes = this.model.get_Class();
        this.sortClasses();
        this.interfaces = this.model.get_Interface();
        this.sortInterfaces();
        this.packages = this.model.get_Package();
        this.rootClassName = this.model.getRootClassText();
    }

    public void refreshClasses() {
        this.classes = this.model.get_Class();
        this.sortClasses();
    }

    public void refreshPackages() {
        this.packages = this.model.get_Package();
    }

    public void refreshInterfaces() {
        this.interfaces = this.model.get_Interface();
        this.sortInterfaces();
    }

    public void refreshRootClass() {
        this.rootClassName = this.model.getRootClassText();
        this.rootClass = this.findClass(this.rootClassName);
    }

    public _Interface add_Interface(String string, String string2) throws ExistingException {
        _Interface _Interface2 = DataModel.createInterface(string2);
        return this.add_Interface(string, _Interface2) ? _Interface2 : null;
    }

    public static _Class createPCDATAClass(String string, String string2) {
        _Class _Class2 = new _Class();
        _Class2.setNameText(string);
        _Class2.setTagNameText(string2);
        _Class2.setContentModelText("(#PCDATA)");
        return _Class2;
    }

    public static _Class createEMPTYClass(String string, String string2) {
        _Class _Class2 = new _Class();
        _Class2.setNameText(string);
        _Class2.setTagNameText(string2);
        _Class2.setContentModelText("EMPTY");
        _Class2.setEmpty(true);
        return _Class2;
    }

    public boolean add_Class(String string, _Class _Class2) throws ExistingException {
        if (_Class2 == null) {
            return false;
        }
        if (this.findClass(_Class2.getNameText()) != null) {
            throw new ExistingException(_Class2.getNameText());
        }
        _Package _Package2 = this.findPackage(string);
        if (_Package2 == null) {
            return false;
        }
        _Class2.setPackageRefNameText(_Package2.getPackageRefNameText());
        if (this.model.add_Class(_Class2)) {
            this.classes = this.model.get_Class();
            this.sortClasses();
            return true;
        }
        return false;
    }

    public _Class addPCDATAClass(String string, String string2, String string3) throws ExistingException {
        _Class _Class2 = DataModel.createPCDATAClass(string2, string3);
        return this.add_Class(string, _Class2) ? _Class2 : null;
    }

    public _Class addEMPTYClass(String string, String string2, String string3) throws ExistingException {
        _Class _Class2 = DataModel.createEMPTYClass(string2, string3);
        return this.add_Class(string, _Class2) ? _Class2 : null;
    }

    public String getPackageName(_Class _Class2) {
        _Package _Package2 = this.findPackage(_Class2.getPackageRefNameText());
        return _Package2 == null ? null : _Package2.getPackageNameText();
    }

    public String getPackageName(_Interface _Interface2) {
        _Package _Package2 = this.findPackage(_Interface2.getPackageRefNameText());
        return _Package2 == null ? null : _Package2.getPackageNameText();
    }

    public static StringBuffer getDirs(String string) {
        if (string == null || string.length() == 0) {
            return new StringBuffer();
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() + 10);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        while (stringTokenizer.hasMoreTokens()) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(File.separatorChar);
            }
            stringBuffer.append(stringTokenizer.nextToken());
        }
        return stringBuffer;
    }

    public static StringBuffer getDirs(StringBuffer stringBuffer, String string) {
        if (string == null || string.length() == 0) {
            return stringBuffer;
        }
        stringBuffer.setLength(0);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        while (stringTokenizer.hasMoreTokens()) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(File.separatorChar);
            }
            stringBuffer.append(stringTokenizer.nextToken());
        }
        return stringBuffer;
    }

    public static boolean makeDirs(String string, String string2) {
        if (string2 == null || string2.length() == 0 || string2.equals(".")) {
            return true;
        }
        String string3 = DataModel.getDirs(string2).toString();
        File file = string == null || string.length() == 0 ? new File(string3) : new File(string, string3);
        return file.isDirectory() ? true : file.mkdirs();
    }

    public static boolean makeDirs(File file, String string) {
        return file == null ? DataModel.makeDirs((String)null, string) : DataModel.makeDirs(file.getPath(), string);
    }

    public static String getFilePath(String string, String string2) {
        StringBuffer stringBuffer = DataModel.getDirs(string);
        if (stringBuffer.length() > 0) {
            stringBuffer.append(File.separatorChar);
        }
        return stringBuffer.append(string2).append(".java").toString();
    }

    public static StringBuffer getFilePath(StringBuffer stringBuffer, String string, String string2) {
        DataModel.getDirs(stringBuffer, string);
        if (stringBuffer.length() > 0) {
            stringBuffer.append(File.separatorChar);
        }
        return stringBuffer.append(string2).append(".java");
    }

    public static String getFileName(String string) {
        int n = string.lastIndexOf(File.separatorChar);
        return n < 0 ? string : string.substring(n + 1);
    }

    public static String getFileName(File file) {
        return DataModel.getFileName(file.getPath());
    }

    public static String getExtension(String string) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(46) + 1;
        return n > 0 && n < string.length() ? string.substring(n) : null;
    }

    public static String getExtension(File file) {
        return DataModel.getExtension(file.getPath());
    }

    public static String makeFile(String string, String string2) {
        int n = string.lastIndexOf(46);
        return n < 0 ? string + "." + string2 : string.substring(0, n + 1) + string2;
    }

    public static File makeFile(File file, String string) {
        return new File(DataModel.makeFile(file.getPath(), string));
    }

    public File getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(String string) throws InvalidDirectoryException {
        if (string != null && string.length() > 0) {
            this.setOutputDir(new File(string));
        } else {
            this.setOutputDir((File)null);
        }
    }

    public void setOutputDir(File file) throws InvalidDirectoryException {
        if (file == null || file.getPath() == null || file.getPath().length() == 0) {
            file = new File(System.getProperty("user.dir"));
        }
        if (file.exists() && !file.isDirectory()) {
            if (file.isFile()) {
                file = file.getParentFile();
            } else {
                throw new InvalidDirectoryException("invalid output directory: \"" + file.getPath() + "\"");
            }
        }
        this.outputDir = file;
    }

    public static class MissingRootClassException
    extends Exception {
        public MissingRootClassException() {
        }

        public MissingRootClassException(String string) {
            super(string);
        }
    }
}

