/*
 * Decompiled with CFR 0.152.
 */
package com.borland.integration.tools.launcher.util;

import com.borland.integration.tools.launcher.launcher;
import com.borland.integration.tools.launcher.util.DialogManager;
import com.borland.integration.tools.util.Runner;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class ProcessThread
extends Thread {
    public Runner proc;
    public String cmd;
    private static boolean isTestingLauncher;
    private static boolean testingCalculated;
    static final String currentOS;
    static final String currentDir;
    static final String slash;
    static final String CMD_PWD = "$PWD";
    static final String CMD_IE = "$IE";
    static final String CMD_EXIT = "$EXIT";
    static final String CMD_SLEEP = "$SLEEP";
    public static final String cdroot_var = "$CDROOT";
    public static final String cleanupdir_var = "$CLEANUPDIR";
    static final String oldExp = "cmd /c start /min";
    static final String newExp = "explorer";
    static String explorer;
    static JFrame theFrame;
    private boolean errOcurred;
    static DialogManager theDM;
    protected String executable = null;

    public ProcessThread(String string) {
        this.cmd = string;
        this.errOcurred = false;
    }

    public ProcessThread(JFrame jFrame, String string) {
        this.cmd = string;
        theFrame = jFrame;
        this.errOcurred = false;
        theDM = new DialogManager(theFrame);
    }

    public static boolean testingLauncher() {
        if (testingCalculated) {
            return isTestingLauncher;
        }
        File file = new File("C:\\cbx_launcher_testing.txt");
        isTestingLauncher = file.exists();
        testingCalculated = true;
        return isTestingLauncher;
    }

    public void run() {
        System.out.println("Command to execute: " + this.cmd);
        if (currentOS.equals("windows nt")) {
            explorer = oldExp;
        }
        if (this.cmd.indexOf(CMD_EXIT) > -1) {
            System.exit(0);
        }
        if (this.cmd.indexOf(CMD_SLEEP) > -1) {
            this.cmd = this.cmd.substring(this.cmd.indexOf(CMD_SLEEP) + 1);
            String string = "10";
            if (this.cmd.length() > CMD_SLEEP.length() + 1) {
                string = this.cmd.substring(this.cmd.indexOf(" ") + 1);
            }
            System.out.println("SLEEP seconds=" + string);
            try {
                Thread.sleep(Integer.parseInt(string) * 1000);
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("Invalid number of seconds to sleep for");
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return;
        }
        this.proc = new Runner();
        System.out.println("New Process Thread Created");
        String string = ProcessThread.replaceTokens(this.cmd, CMD_PWD, currentDir);
        string = ProcessThread.replaceTokens(string, CMD_IE, explorer);
        string = ProcessThread.replaceTokens(string, cdroot_var, launcher.cdroot);
        string = ProcessThread.replaceTokens(string, cleanupdir_var, launcher.cleanupdir);
        System.out.println("Command to execute: " + string);
        if (ProcessThread.testingLauncher()) {
            this.executable = Runner.parseCommand(string)[0];
            File file = new File(this.executable);
            if (file.exists() || this.executable.equals(newExp)) {
                Runnable runnable = new Runnable(){

                    public void run() {
                        theDM.DisplayOKDialog("Launcher test - Success!", "<html>The executable was found:<br>Path: " + ProcessThread.this.executable + "</html>");
                    }
                };
                if (SwingUtilities.isEventDispatchThread()) {
                    runnable.run();
                } else {
                    SwingUtilities.invokeLater(runnable);
                }
            } else {
                Runnable runnable = new Runnable(){

                    public void run() {
                        ArrayList<String> arrayList = new ArrayList<String>();
                        arrayList.add(0, "Executable not found: " + ProcessThread.this.executable);
                        if (ProcessThread.this.executable.indexOf("\\") == -1 && ProcessThread.this.executable.indexOf("/") == -1) {
                            arrayList.add(1, "Perhaps this command can be found on the path?");
                        }
                        theDM.DisplayErrorMessageDialog("Launcher test result", 1, arrayList);
                    }
                };
                if (SwingUtilities.isEventDispatchThread()) {
                    runnable.run();
                } else {
                    SwingUtilities.invokeLater(runnable);
                }
            }
        } else {
            this.proc.run(string);
        }
    }

    public static String replaceTokens(String string, String string2, String string3) {
        int n = 0;
        String string4 = "";
        int n2 = string.indexOf(string2, n);
        while (n2 != -1) {
            string4 = string4 + string.substring(n, n2) + string3;
            n = n2 + string2.length();
            n2 = string.indexOf(string2, n);
        }
        string4 = string4 + string.substring(n);
        return string4;
    }

    public boolean getErrOcurred() {
        return this.errOcurred;
    }

    static {
        testingCalculated = false;
        currentOS = System.getProperty("os.name").toLowerCase();
        currentDir = System.getProperty("user.dir");
        slash = System.getProperty("file.separator");
        explorer = newExp;
    }
}

