/*
 * Decompiled with CFR 0.152.
 */
package com.borland.integration.tools.launcher.util;

import com.borland.integration.tools.util.ExecProcess;
import com.borland.integration.tools.util.Platform;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;

public class DeleteDir {
    private static Vector shutdownScripts = new Vector();
    private static boolean shutdownHookActivated = false;
    private static String detachedExeFilename = null;

    public static void delTree(File file) {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                DeleteDir.delTree(fileArray[i]);
            }
            file.delete();
        } else if (file.exists()) {
            file.delete();
        }
    }

    public static void delTreeOnExit(File file) {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                DeleteDir.delTreeOnExit(fileArray[i]);
            }
            file.deleteOnExit();
        } else if (file.exists()) {
            file.deleteOnExit();
        }
    }

    private static void _shellDelTreeOnExit(File file, Vector vector) {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                DeleteDir._shellDelTreeOnExit(fileArray[i], vector);
            }
            if (Platform.WIN32) {
                vector.add("RMDIR " + file.getAbsolutePath() + " >nul");
            } else if (Platform.UNIX) {
                vector.add("rm -rf " + file.getAbsolutePath() + " >/dev/null 2>/dev/null");
            }
        } else if (file.exists()) {
            if (Platform.WIN32) {
                vector.add("DEL " + file.getAbsolutePath() + " >nul");
            } else if (Platform.UNIX) {
                vector.add("rm -f " + file.getAbsolutePath() + " >/dev/null 2>/dev/null");
            }
        }
    }

    public static String getDetachedExeFilename() {
        return detachedExeFilename;
    }

    public static void shellDelTreeOnExit(File file, String string) throws IOException {
        if (!Platform.WIN32 && !Platform.UNIX) {
            DeleteDir.delTreeOnExit(file);
            return;
        }
        Vector vector = new Vector();
        DeleteDir._shellDelTreeOnExit(file, vector);
        detachedExeFilename = string;
        String string2 = Platform.WIN32 ? ".bat" : ".sh";
        File file2 = File.createTempFile("delete", string2);
        FileWriter fileWriter = new FileWriter(file2);
        String string3 = System.getProperty("line.separator");
        if (Platform.WIN32) {
            fileWriter.write("@ECHO OFF" + string3);
            fileWriter.write("REM Temporary transient file cleanup script" + string3);
        } else if (Platform.UNIX) {
            fileWriter.write("#!/bin/sh" + string3);
            fileWriter.write("# Temporary transient file cleanup script" + string3);
        }
        for (int i = 0; i < vector.size(); ++i) {
            String string4 = (String)vector.elementAt(i);
            fileWriter.write(string4 + string3);
        }
        if (Platform.WIN32) {
            fileWriter.write("DEL " + file2.getAbsolutePath() + " > nul" + string3);
        } else if (Platform.UNIX) {
            fileWriter.write("rm -f " + file2.getAbsolutePath() + " >/dev/null 2>/dev/null" + string3);
        }
        fileWriter.flush();
        fileWriter.close();
        shutdownScripts.add(file2.getAbsolutePath());
        if (!shutdownHookActivated) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    for (int i = 0; i < shutdownScripts.size(); ++i) {
                        String string = (String)shutdownScripts.elementAt(i);
                        String[] stringArray = null;
                        ExecProcess execProcess = new ExecProcess();
                        if (Platform.WIN32) {
                            stringArray = new String[7];
                            if (DeleteDir.getDetachedExeFilename().length() > 0) {
                                stringArray[0] = DeleteDir.getDetachedExeFilename();
                                stringArray[1] = "-delay";
                                stringArray[2] = "10";
                                stringArray[3] = "-command";
                                stringArray[4] = "cmd";
                                stringArray[5] = "/c";
                                stringArray[6] = string;
                            } else {
                                stringArray = new String[]{"cmd", "/c", string};
                            }
                        } else if (Platform.UNIX) {
                            stringArray = new String[]{"/bin/sh", string};
                        }
                        execProcess.setCommand(stringArray);
                        try {
                            execProcess.launch();
                            continue;
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    shutdownScripts.clear();
                }
            });
            shutdownHookActivated = true;
        }
    }
}

