/*
 * Decompiled with CFR 0.152.
 */
package com.borland.integration.tools.launcher.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class CheckCellRenderer
extends JLabel {
    private static final long serialVersionUID = 1014L;
    public static final int CHECKMARK = 0;
    public static final int XMARK = 1;
    protected int boxSize = 12;
    protected int checkStyle = 0;
    protected int alignment = 2;
    protected boolean checkVisible = true;
    protected boolean selected = true;
    protected boolean drawsFocusBorderAroundIcon = false;
    protected boolean paintFocusRect = false;
    protected static Border emptyBorder = BorderFactory.createEmptyBorder(1, 1, 1, 1);

    public CheckCellRenderer() {
        this.setBorder(emptyBorder);
    }

    public CheckCellRenderer(int n) {
        this();
        this.boxSize = n;
    }

    public CheckCellRenderer(int n, int n2) {
        this(n);
        this.checkStyle = n2;
    }

    public void setBoxSize(int n) {
        this.boxSize = n;
    }

    public int getBoxSize() {
        return this.boxSize;
    }

    public void setStyle(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException();
        }
        this.checkStyle = n;
    }

    public int getStyle() {
        return this.checkStyle;
    }

    protected Rectangle getBoxRectangle() {
        Rectangle rectangle = new Rectangle(0, 0, this.boxSize, this.boxSize);
        if (this.alignment == 2) {
            ++rectangle.x;
            rectangle.y = (this.getHeight() - this.boxSize) / 2;
        } else if (this.alignment == 0) {
            Dimension dimension = this.getPreferredSize();
            rectangle.x = (this.getWidth() - dimension.width) / 2;
            rectangle.y = (this.getHeight() - this.boxSize) / 2;
        }
        return rectangle;
    }

    public void paint(Graphics graphics) {
        Object object;
        Serializable serializable;
        if (this.checkVisible) {
            serializable = this.getBoxRectangle();
            this.drawBox(graphics, serializable.x, serializable.y, serializable.width, serializable.height);
            if (this.selected) {
                this.drawCheck(graphics, serializable.x + 1, serializable.y + 1, serializable.width - 2, serializable.height - 2);
            }
        }
        serializable = this.getBackground();
        int n = -1;
        if (serializable != null) {
            object = this.getIcon();
            n = this.getLabelStart();
            graphics.setColor((Color)serializable);
            graphics.fillRect(n, 0, this.getWidth() - 1 - n, this.getHeight());
        }
        if (this.paintFocusRect) {
            n = this.getLabelStart();
            object = UIManager.getColor("Tree.selectionBorderColor");
            if (object != null) {
                graphics.setColor((Color)object);
                graphics.drawRect(n, 0, this.getWidth() - 1 - n, this.getHeight() - 1);
            }
        }
        super.paint(graphics);
    }

    public void setPaintFocusRect(boolean bl) {
        this.paintFocusRect = bl;
    }

    private int getLabelStart() {
        int n = this.checkVisible ? this.boxSize + this.getIconTextGap() : 0;
        Icon icon = this.getIcon();
        if (icon != null && this.getText() != null) {
            return n + icon.getIconWidth() + Math.max(0, this.getIconTextGap() - 1);
        }
        return n;
    }

    protected void drawBox(Graphics graphics, int n, int n2, int n3, int n4) {
        Color color = graphics.getColor();
        graphics.setColor(Color.black);
        graphics.drawRect(n, n2, n3 - 1, n4 - 1);
        graphics.setColor(color);
    }

    protected void drawCheck(Graphics graphics, int n, int n2, int n3, int n4) {
        Color color = graphics.getColor();
        ++n;
        ++n2;
        graphics.setColor(Color.black);
        if (this.checkStyle == 0) {
            int n5 = n4 / 3;
            int n6 = n + n3 / 3 - 1;
            for (int i = 1; i <= n5; ++i) {
                graphics.drawLine(n6, n2 + n4 - i - 2, n, n2 + n5 - i + n4 / 2 - 2);
                graphics.drawLine(n6, n2 + n4 - i - 2, n + n3 - 3, n2 + n5 - i);
            }
        } else if (this.checkStyle == 1) {
            graphics.drawLine(n, n2, n + n3 - 3, n2 + n4 - 3);
            graphics.drawLine(n + 1, n2, n + n3 - 3, n2 + n4 - 4);
            graphics.drawLine(n, n2 + 1, n + n3 - 4, n2 + n4 - 3);
            graphics.drawLine(n, n2 + n4 - 3, n + n3 - 3, n2);
            graphics.drawLine(n + 1, n2 + n4 - 3, n + n3 - 3, n2 + 1);
            graphics.drawLine(n, n2 + n4 - 4, n + n3 - 4, n2);
        }
        graphics.setColor(color);
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        dimension.width += 3;
        return dimension;
    }

    public Insets getInsets() {
        Insets insets = super.getInsets();
        if (this.checkVisible) {
            insets.left += this.boxSize + this.getIconTextGap();
        }
        return insets;
    }

    public Insets getInsets(Insets insets) {
        Insets insets2 = super.getInsets(insets);
        if (this.checkVisible) {
            insets2.left += this.boxSize + this.getIconTextGap();
        }
        return insets2;
    }

    public boolean hitTest(int n, int n2) {
        if (this.checkVisible) {
            Rectangle rectangle = this.getBoxRectangle();
            return n >= rectangle.x && n <= rectangle.x + rectangle.width && n2 >= rectangle.y && n2 <= rectangle.y + rectangle.height;
        }
        return false;
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public boolean isCheckVisible() {
        return this.checkVisible;
    }

    public void setCheckVisible(boolean bl) {
        this.checkVisible = bl;
    }
}

