/*
 * Decompiled with CFR 0.152.
 */
package com.borland.integration.tools.launcher;

import com.borland.integration.tools.launcher.MainFrame;
import com.borland.integration.tools.launcher.util.DeleteDir;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.Timer;
import javax.swing.UIManager;

public class launcher {
    private static final long serialVersionUID = 1051L;
    boolean packFrame = false;
    static Timer frameTimer;
    static MainFrame frame;
    static String osname;
    private static ArrayList classes;
    private static int countSuccess;
    private static int countFailure;
    public static String cdroot;
    public static String cleanupdir;
    public static boolean debugging;
    public static boolean isSolaris;
    public static String cdrootInitial;
    private static Process disableAutorunProcess;

    public launcher() {
        frame = new MainFrame();
        if (this.packFrame) {
            frame.pack();
        } else {
            frame.validate();
        }
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = frame.getSize();
        if (dimension2.height > dimension.height) {
            dimension2.height = dimension.height;
        }
        if (dimension2.width > dimension.width) {
            dimension2.width = dimension.width;
        }
        frame.setLocation(100, 100);
        frameTimer = new Timer(500, new frameTimerListener());
        frameTimer.start();
        frame.setResizable(false);
        frame.setVisible(true);
    }

    private static void processArgs(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string.startsWith("cdroot=")) {
                cdrootInitial = cdroot = string.substring(7);
                if (isSolaris) {
                    cdroot = cdroot.substring(0, cdroot.lastIndexOf("/"));
                }
                System.out.println("cdroot is " + cdroot);
                continue;
            }
            if (string.startsWith("cleanupdir=")) {
                cleanupdir = string.substring(11);
                System.out.println("cleanupdir is " + cleanupdir);
                continue;
            }
            if (string.equals("-debug")) {
                debugging = true;
                continue;
            }
            launcher.usage("Unknown option:  " + string);
        }
        if (cdroot == null) {
            launcher.usage("cdroot not specified");
        }
    }

    private static void usage(String string) {
        System.err.println();
        if (string != null) {
            System.err.println(string);
            System.err.println();
        }
        System.err.println("Usage:  launcher [options]");
        System.err.println(" cdroot=<cdrom root directory> (required)");
        System.err.println(" cleanupdir=<directory to remove on exit>");
        System.exit(1);
    }

    public static void main(String[] stringArray) {
        File file;
        try {
            osname = System.getProperty("os.name").toLowerCase();
            if (osname.equals("sunos") || osname.equals("solaris")) {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                isSolaris = true;
            } else {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        launcher.processArgs(stringArray);
        if (cleanupdir != null && (file = new File(cleanupdir)).exists()) {
            try {
                if (!debugging) {
                    DeleteDir.shellDelTreeOnExit(file, cdroot + File.separator + "launcher" + File.separator + "tools" + File.separator + "detachedexec.exe");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        new launcher();
    }

    static {
        classes = new ArrayList();
        countSuccess = 0;
        countFailure = 0;
        cdroot = null;
        cleanupdir = null;
        debugging = false;
        isSolaris = false;
        cdrootInitial = null;
        disableAutorunProcess = null;
    }

    private static class frameTimerListener
    implements ActionListener {
        String osName = System.getProperty("os.name").toLowerCase();
        boolean isMac = this.osName.substring(0, 3).equals("mac");

        private frameTimerListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                if (!this.isMac) {
                    frame.repaint();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

