/*
 * Decompiled with CFR 0.152.
 */
package com.inprise.vbroker.compiler.tools;

import com.inprise.vbroker.compiler.ast.NodeFactory;
import com.inprise.vbroker.compiler.backends.common.GenericBackend;
import com.inprise.vbroker.compiler.tools.ToolOptions;
import com.inprise.vbroker.compiler.util.BufferReader;
import com.inprise.vbroker.compiler.util.ErrorReporter;
import com.inprise.vbroker.compiler.util.PrintER;
import com.inprise.vbroker.compiler.util.Utils;
import com.inprise.vbroker.util.StringFunctions;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public abstract class tool {
    public static final int SUCCESS = 0;
    public static final int BOOTSTRAP_ERROR = 10;
    public static final int COMMAND_LINE_ERROR = 20;
    public static final int PREPROCESSOR_ERROR = 30;
    public static final int FRONTEND_ERROR = 40;
    public static final int BACKEND_ERROR = 50;
    public static final int INTERNAL_ERROR = 60;
    public String _toolName;
    public GenericBackend _backend;
    public int _frontEndResult;
    public int _exitCode;
    public ErrorReporter _ER;
    private static final Class[] frontendConstructorArgs;
    private static final Class[] backendConstructorArgs;
    static Class class$com$inprise$vbroker$compiler$util$BufferReader;
    static Class class$com$inprise$vbroker$compiler$util$BufferWriter;
    static Class class$com$inprise$vbroker$compiler$ast$ContainerNode;
    static Class class$com$inprise$vbroker$compiler$util$ErrorReporter;
    static Class array$Ljava$lang$String;
    static Class class$java$lang$String;
    static Class class$java$util$Vector;
    static Class class$java$lang$Class;

    public tool(ErrorReporter errorReporter) {
        this._ER = errorReporter;
        this._toolName = errorReporter.getToolName();
    }

    public static Object construct(Class clazz, String string, Object[] objectArray, ErrorReporter errorReporter) {
        return tool.construct(clazz, string, objectArray, errorReporter, backendConstructorArgs);
    }

    public static Object construct(Class clazz, String string, Object[] objectArray, ErrorReporter errorReporter, Class[] classArray) {
        Exception exception = null;
        try {
            Object t;
            Constructor constructor = clazz.getConstructor(classArray);
            Object t2 = t = constructor.newInstance(objectArray);
            return t2;
        }
        catch (SecurityException securityException) {
            exception = securityException;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            exception = noSuchMethodException;
        }
        catch (ClassCastException classCastException) {
            exception = classCastException;
        }
        catch (InstantiationException instantiationException) {
            exception = instantiationException;
        }
        catch (IllegalAccessException illegalAccessException) {
            exception = illegalAccessException;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            exception = invocationTargetException;
        }
        errorReporter.internalError(exception);
        return null;
    }

    public static final ErrorReporter createER(String string, String[] stringArray) {
        PrintER printER = null;
        try {
            printER = new PrintER("com.inprise.vbroker.compiler.Messages");
            if (printER == null) {
                System.err.println("<internal>: unable to instantiate new classes; giving up");
                ErrorReporter errorReporter = null;
                return errorReporter;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals("-XXX_debug")) continue;
                printER._verbose = true;
            }
            printER.setToolName(string);
        }
        catch (Throwable throwable) {
            System.err.println("<internal>: unable to load the compiler's message resources");
            System.err.println("<internal>: (check your installation and CLASSPATH settings)");
            ErrorReporter errorReporter = null;
            return errorReporter;
        }
        return printER;
    }

    public static Class getClassForName(String string, ErrorReporter errorReporter, String string2) {
        if (string == null) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName(string);
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            errorReporter.error(string2, new Object[]{string});
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            errorReporter.internalError(exceptionInInitializerError.getException());
        }
        return null;
    }

    protected NodeFactory getNodeFactory(Class clazz) {
        NodeFactory nodeFactory;
        block11: {
            Throwable throwable = null;
            nodeFactory = null;
            try {
                try {
                    nodeFactory = (NodeFactory)clazz.getMethod("makeNodeFactory", class$com$inprise$vbroker$compiler$util$ErrorReporter == null ? (class$com$inprise$vbroker$compiler$util$ErrorReporter = tool.class$("com.inprise.vbroker.compiler.util.ErrorReporter")) : class$com$inprise$vbroker$compiler$util$ErrorReporter).invoke(null, this._ER);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throwable = noSuchMethodException;
                    Object var6_5 = null;
                    if (throwable != null) {
                        this._ER.internalError(throwable);
                        return null;
                    }
                    break block11;
                }
                catch (InvocationTargetException invocationTargetException) {
                    throwable = invocationTargetException.getTargetException();
                    Object var6_6 = null;
                    if (throwable != null) {
                        this._ER.internalError(throwable);
                        return null;
                    }
                    break block11;
                }
                catch (IllegalAccessException illegalAccessException) {
                    throwable = illegalAccessException;
                    Object var6_7 = null;
                    if (throwable != null) {
                        this._ER.internalError(throwable);
                        return null;
                    }
                }
                Object var6_4 = null;
                if (throwable != null) {
                    this._ER.internalError(throwable);
                    return null;
                }
            }
            catch (Throwable throwable2) {
                Object var6_8 = null;
                if (throwable != null) {
                    this._ER.internalError(throwable);
                    return null;
                }
                throw throwable2;
            }
        }
        return nodeFactory;
    }

    public static int main(ToolOptions toolOptions, String[] stringArray) {
        tool tool2 = tool.main(stringArray, toolOptions);
        if (tool2 == null) {
            return 10;
        }
        return tool2._exitCode;
    }

    public static void main(String[] stringArray) {
        try {
            ToolOptions toolOptions;
            ErrorReporter errorReporter = tool.createER("tool", stringArray);
            if (errorReporter == null) {
                System.exit(10);
            }
            if ((toolOptions = new ToolOptions(errorReporter)) == null) {
                System.err.println(String.valueOf(String.valueOf(errorReporter.getToolName())).concat(": unable to parse command line; aborting"));
                System.exit(10);
            }
            boolean[] blArray = new boolean[]{false, false};
            stringArray = toolOptions.parse(stringArray, blArray);
            if (blArray[0]) {
                toolOptions.printUsage(null, new String[]{"Comp.Tools.toolUsage"});
            }
            if (blArray[1]) {
                System.exit(20);
            }
            System.exit(tool.main((String[])stringArray, (ToolOptions)toolOptions)._exitCode);
        }
        catch (Throwable throwable) {
            System.err.println("<internal>: unrecoverable error launching tool; aborting");
            System.exit(10);
        }
    }

    public static tool main(String[] stringArray, ToolOptions toolOptions) {
        if (toolOptions._frontEnd == null) {
            return null;
        }
        ErrorReporter errorReporter = toolOptions._ER;
        try {
            tool tool2;
            Object[] objectArray = new Object[]{toolOptions._backEnd, toolOptions._userER, toolOptions._bufferReader, toolOptions._bufferWriter, stringArray};
            tool tool3 = tool2 = (tool)tool.construct(toolOptions._frontEnd, String.valueOf(String.valueOf(toolOptions._frontEnd.getName())).concat(" driver"), objectArray, toolOptions._userER, frontendConstructorArgs);
            return tool3;
        }
        catch (Throwable throwable) {
            if (throwable instanceof OutOfMemoryError) {
                if (errorReporter._verbose) {
                    errorReporter.fatal("Comp.Tools.verboseOutOfMemory", new Object[]{"Stack Trace :".concat(String.valueOf(String.valueOf(Utils.getStackTrace(throwable))))});
                } else {
                    errorReporter.fatal("Comp.Tools.outOfMemory");
                }
            }
            if (throwable instanceof ExceptionInInitializerError || throwable instanceof StackOverflowError) {
                errorReporter.internalError(throwable);
            }
            if (throwable instanceof NoClassDefFoundError) {
                if (errorReporter._verbose) {
                    errorReporter.fatal("Comp.Tools.verboseNoClassDefFound", new Object[]{throwable.toString(), "Stack Trace :".concat(String.valueOf(String.valueOf(Utils.getStackTrace(throwable))))});
                } else {
                    errorReporter.fatal("Comp.Tools.noClassDefFound", new Object[]{throwable.toString()});
                }
            }
            if (throwable instanceof Error) {
                if (errorReporter._verbose) {
                    errorReporter.fatal("Comp.Tools.verboseErrorCaught", new Object[]{throwable.toString(), "Stack Trace :".concat(String.valueOf(String.valueOf(Utils.getStackTrace(throwable))))});
                } else {
                    errorReporter.fatal("Comp.Tools.errorCaught", new Object[]{throwable.toString()});
                }
            }
            errorReporter.internalError(throwable);
            tool tool4 = null;
            return tool4;
        }
    }

    public String readFrom(String string, BufferReader bufferReader) {
        File file = bufferReader.getFile(string);
        String string2 = String.valueOf(String.valueOf(new StringBuffer("\"").append(StringFunctions.prepFilename(string)).append("\"")));
        if (!file.exists()) {
            this._ER.error("Comp.File.doesntExist", string2);
            return null;
        }
        if (!file.canRead()) {
            this._ER.error("Comp.File.cantRead", string2);
            return null;
        }
        if (file.isDirectory()) {
            this._ER.error("Comp.File.isDirectory", string2);
            return null;
        }
        try {
            String string3;
            int n;
            InputStream inputStream = bufferReader.getInputStream(file);
            StringBuffer stringBuffer = new StringBuffer(65536);
            byte[] byArray = new byte[65536];
            while ((n = inputStream.read(byArray)) > 0) {
                string3 = new String(byArray, 0, n, "8859_1");
                stringBuffer.append(string3);
            }
            string3 = stringBuffer.toString();
            return string3;
        }
        catch (IOException iOException) {
            this._ER.error("Comp.File.readingIOError", string2);
            String string4 = null;
            return string4;
        }
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        SUCCESS = 0;
        BOOTSTRAP_ERROR = 10;
        COMMAND_LINE_ERROR = 20;
        PREPROCESSOR_ERROR = 30;
        FRONTEND_ERROR = 40;
        BACKEND_ERROR = 50;
        INTERNAL_ERROR = 60;
        frontendConstructorArgs = new Class[]{class$java$lang$Class == null ? (class$java$lang$Class = tool.class$("java.lang.Class")) : class$java$lang$Class, class$com$inprise$vbroker$compiler$util$ErrorReporter == null ? (class$com$inprise$vbroker$compiler$util$ErrorReporter = tool.class$("com.inprise.vbroker.compiler.util.ErrorReporter")) : class$com$inprise$vbroker$compiler$util$ErrorReporter, class$com$inprise$vbroker$compiler$util$BufferReader == null ? (class$com$inprise$vbroker$compiler$util$BufferReader = tool.class$("com.inprise.vbroker.compiler.util.BufferReader")) : class$com$inprise$vbroker$compiler$util$BufferReader, class$com$inprise$vbroker$compiler$util$BufferWriter == null ? (class$com$inprise$vbroker$compiler$util$BufferWriter = tool.class$("com.inprise.vbroker.compiler.util.BufferWriter")) : class$com$inprise$vbroker$compiler$util$BufferWriter, array$Ljava$lang$String == null ? (array$Ljava$lang$String = tool.class$("[Ljava.lang.String;")) : array$Ljava$lang$String};
        backendConstructorArgs = new Class[]{class$com$inprise$vbroker$compiler$ast$ContainerNode == null ? (class$com$inprise$vbroker$compiler$ast$ContainerNode = tool.class$("com.inprise.vbroker.compiler.ast.ContainerNode")) : class$com$inprise$vbroker$compiler$ast$ContainerNode, class$com$inprise$vbroker$compiler$util$BufferWriter == null ? (class$com$inprise$vbroker$compiler$util$BufferWriter = tool.class$("com.inprise.vbroker.compiler.util.BufferWriter")) : class$com$inprise$vbroker$compiler$util$BufferWriter, class$java$lang$String == null ? (class$java$lang$String = tool.class$("java.lang.String")) : class$java$lang$String, class$java$util$Vector == null ? (class$java$util$Vector = tool.class$("java.util.Vector")) : class$java$util$Vector};
    }
}

