/*
 * Decompiled with CFR 0.152.
 */
package com.inprise.vbroker.compiler.frontends.idl;

import com.inprise.vbroker.compiler.ast.ConstantNode;
import com.inprise.vbroker.compiler.ast.EnumNameNode;
import com.inprise.vbroker.compiler.ast.EnumNode;
import com.inprise.vbroker.compiler.ast.InterfaceNode;
import com.inprise.vbroker.compiler.ast.Node;
import com.inprise.vbroker.compiler.ast.PrimitiveNode;
import com.inprise.vbroker.compiler.ast.StringNode;
import com.inprise.vbroker.compiler.ast.Type;
import com.inprise.vbroker.compiler.ast.WStringNode;
import com.inprise.vbroker.compiler.util.ErrorReporter;
import com.inprise.vbroker.compiler.util.FixedValue;
import com.inprise.vbroker.compiler.util.IntValue;
import java.math.BigDecimal;

final class Literal {
    int _type;
    Object _value;
    ErrorReporter _ER;

    Literal(int n, Object object, ErrorReporter errorReporter) {
        this._type = n;
        this._value = object;
        this._ER = errorReporter;
    }

    Literal(ConstantNode constantNode) {
        this._ER = constantNode.ER();
        if (constantNode._type == InterfaceNode.ERROR) {
            this._type = 14;
            this._value = "";
            return;
        }
        switch (constantNode._type.kind()) {
            case 14: {
                this._type = 14;
                break;
            }
            case 18: {
                this._type = 20;
                break;
            }
            case 12: {
                this._type = 30001;
                break;
            }
            case 19: {
                this._type = 30000;
                break;
            }
            case 13: {
                this._type = ((PrimitiveNode)constantNode._type)._pkind;
                break;
            }
            default: {
                this._ER.internalError("Literal(ConstantNode): attempt to construct from unexpected ConstantNode type ".concat(String.valueOf(String.valueOf(((Node)((Object)constantNode._type)).typeName()))));
            }
        }
        switch (this._type) {
            case 2: 
            case 3: 
            case 16: {
                this._value = new IntValue((Long)constantNode._value, false);
                break;
            }
            case 4: 
            case 5: 
            case 17: {
                this._value = new IntValue((Long)constantNode._value, true);
                break;
            }
            default: {
                this._value = constantNode._value;
            }
        }
    }

    Literal(EnumNameNode enumNameNode) {
        this._type = 30001;
        this._value = enumNameNode;
        this._ER = enumNameNode.ER();
    }

    void add(Literal literal) {
        if (!Literal.anumber(this) || !Literal.anumber(literal)) {
            return;
        }
        if (Literal.integralType(this._type)) {
            if (Literal.integralType(literal._type)) {
                try {
                    ((IntValue)this._value).add((IntValue)literal._value);
                }
                catch (ArithmeticException arithmeticException) {
                    this._ER.error("Comp.FE.IDL.overflow", "+");
                }
            } else {
                this._ER.error("Comp.FE.IDL.integralOperandMismatch", "+");
            }
        } else if (Literal.floatType(this._type)) {
            if (Literal.floatType(literal._type)) {
                this._value = new Double((Double)this._value + (Double)literal._value);
            } else {
                this._ER.error("Comp.FE.IDL.floatOperandMismatch", "+");
            }
        } else if (literal._type == 30000) {
            ((FixedValue)this._value).add((FixedValue)literal._value);
        } else {
            this._ER.error("Comp.FE.IDL.fixedOperandMismatch", "+");
        }
    }

    private static boolean anumber(Literal literal) {
        if (Literal.numericType(literal._type)) {
            return true;
        }
        literal._ER.error("Comp.FE.IDL.expectedNumericLiteralButGot", PrimitiveNode.typeName(literal._type));
        return false;
    }

    void append(String string) {
        this._value = String.valueOf(String.valueOf((String)this._value)).concat(String.valueOf(String.valueOf(string)));
    }

    void bitNot() {
        if (Literal.integralType(this)) {
            ((IntValue)this._value).bitNot();
        } else {
            this._ER.error("Comp.FE.IDL.needsIntegralOperand", "!");
        }
    }

    void bitand(Literal literal) {
        if (Literal.integralType(this) || !Literal.integralType(literal)) {
            ((IntValue)this._value).bitand((IntValue)literal._value);
        } else {
            this._ER.error("Comp.FE.IDL.needsIntegralOperands", "&");
        }
    }

    void bitor(Literal literal) {
        if (Literal.integralType(this) || !Literal.integralType(literal)) {
            ((IntValue)this._value).bitor((IntValue)literal._value);
        } else {
            this._ER.error("Comp.FE.IDL.needsIntegralOperands", "|");
        }
    }

    void bitxor(Literal literal) {
        if (Literal.integralType(this) || !Literal.integralType(literal)) {
            ((IntValue)this._value).bitxor((IntValue)literal._value);
        } else {
            this._ER.error("Comp.FE.IDL.needsIntegralOperands", "^");
        }
    }

    void div(Literal literal) {
        if (!Literal.anumber(this) || !Literal.anumber(literal)) {
            return;
        }
        if (Literal.integralType(this._type)) {
            if (Literal.integralType(literal._type)) {
                try {
                    ((IntValue)this._value).div((IntValue)literal._value);
                }
                catch (ArithmeticException arithmeticException) {
                    this._ER.error("Comp.FE.IDL.divideByZero");
                }
            } else {
                this._ER.error("Comp.FE.IDL.integralOperandMismatch", "/");
            }
        } else if (Literal.floatType(this._type)) {
            if (Literal.floatType(literal._type)) {
                this._value = new Double((Double)this._value / (Double)literal._value);
            } else {
                this._ER.error("Comp.FE.IDL.floatOperandMismatch", "/");
            }
        } else if (literal._type == 30000) {
            ((FixedValue)this._value).div((FixedValue)literal._value);
        } else {
            this._ER.error("Comp.FE.IDL.fixedOperandMismatch", "/");
        }
    }

    int ensurePositiveInteger() {
        if (!Literal.integralType(this._type)) {
            this._ER.error("Comp.FE.IDL.expectedIntegralTypeButGot", PrimitiveNode.typeName(this._type));
            return 1;
        }
        long l = ((IntValue)this._value)._val;
        if (l <= (long)0) {
            this._ER.error("Comp.FE.IDL.expectedPositiveIntegerButGotValue", new Object[]{new Long(l)});
            return 1;
        }
        if ((long)((int)l) != l) {
            this._ER.error("Comp.FE.IDL.positiveIntegerOutOfRange", new Object[]{new Long(l)});
            return 1;
        }
        return (int)l;
    }

    private void enumMismatch(String string, String string2, String string3) {
        if (string == null) {
            this._ER.error("Comp.FE.IDL.unnamedConstantEnumNameMismatch", new Object[]{string2, string3});
        } else {
            this._ER.error("Comp.FE.IDL.constantEnumNameMismatch", new Object[]{string, string2, string3});
        }
    }

    Object finalValue(Type type, String string) {
        switch (type.kind()) {
            case 13: {
                int n = ((PrimitiveNode)type)._pkind;
                switch (n) {
                    case 10: {
                        if (this._type == 10) {
                            return new Byte((byte)((IntValue)this._value)._val);
                        }
                        if (this._value instanceof IntValue) {
                            long l = ((IntValue)this._value)._val;
                            if (l < (long)0 || l > (long)255) {
                                this.outOfRange(string, type, new Long(l));
                            }
                            return new Byte((byte)l);
                        }
                        this._value = new Byte(0);
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 16: 
                    case 17: {
                        if (this._value instanceof Byte) {
                            return new Long(((IntValue)this._value)._val);
                        }
                        if (this._value instanceof IntValue) {
                            long l = ((IntValue)this._value)._val;
                            boolean bl = ((IntValue)this._value)._unsigned;
                            switch (n) {
                                case 2: {
                                    if (l > (long)Short.MAX_VALUE && !bl) {
                                        ((IntValue)this._value)._val = l = -((l - 1L) / 2L);
                                    }
                                    if ((long)((short)l) == l) break;
                                    this.outOfRange(string, type, new Long(l));
                                    break;
                                }
                                case 3: {
                                    if (l > (long)Integer.MAX_VALUE && !bl) {
                                        ((IntValue)this._value)._val = l = -((l - 1L) / 2L);
                                    }
                                    if ((long)((int)l) == l) break;
                                    this.outOfRange(string, type, new Long(l));
                                    break;
                                }
                                case 16: {
                                    break;
                                }
                                case 4: {
                                    if (l >= (long)0 && l <= 65535L) break;
                                    this.outOfRange(string, type, new Long(l));
                                    break;
                                }
                                case 5: {
                                    if (l >= (long)0 && l <= 0xFFFFFFFFL) break;
                                    this.outOfRange(string, type, new Long(l));
                                    break;
                                }
                            }
                            return new Long(l);
                        }
                        this._value = new Long(0L);
                        break;
                    }
                    case 14: 
                    case 20: {
                        if (this._value instanceof String) {
                            return this._value;
                        }
                        this._value = "";
                        break;
                    }
                    case 9: 
                    case 19: {
                        if (this._value instanceof Character) {
                            return this._value;
                        }
                        this._value = new Character('\u0000');
                        break;
                    }
                    case 8: {
                        if (this._value instanceof Boolean) {
                            return this._value;
                        }
                        this._value = Boolean.FALSE;
                        break;
                    }
                    case 6: {
                        if (this._value instanceof Float) {
                            return this._value;
                        }
                        if (this._value instanceof Double) {
                            double d = (Double)this._value;
                            if (d < (double)-3.4028235E38f || d > (double)Float.MAX_VALUE) {
                                this._ER.error("Comp.FE.IDL.floatOutOfRange", "".concat(String.valueOf(String.valueOf(d))));
                            }
                            return this._value;
                        }
                        this._value = new Float(0.0);
                        break;
                    }
                    case 7: {
                        if (this._value instanceof Double) {
                            return this._value;
                        }
                        this._value = new Double(0.0);
                        break;
                    }
                    case 18: {
                        if (this._value instanceof Double) {
                            return this._value;
                        }
                        this._value = new Double(0.0);
                        break;
                    }
                    default: {
                        this._ER.internalError("Literal.finalValue(Type,String): invalid primitive type ".concat(String.valueOf(String.valueOf(((PrimitiveNode)type).typeName()))));
                    }
                }
                this.typeMismatch(string, type);
                return this._value;
            }
            case 12: {
                if (this._value instanceof EnumNameNode) {
                    EnumNameNode enumNameNode = (EnumNameNode)this._value;
                    EnumNode enumNode = (EnumNode)type;
                    if (enumNameNode._definingEnum != enumNode) {
                        this.enumMismatch(string, enumNode._fullName, enumNameNode._name);
                        this._value = (String)enumNode._memberNames.elementAt(0);
                        return this._value;
                    }
                    return this._value;
                }
                this._value = (String)((EnumNode)type)._memberNames.elementAt(0);
                break;
            }
            case 14: 
            case 18: {
                if (this._value instanceof String) {
                    int n;
                    String string2 = (String)this._value;
                    int n2 = n = type.kind() == 14 ? ((StringNode)type)._bound : ((WStringNode)type)._bound;
                    if (string2.length() > n) {
                        this.stringOverrun(string, new Long(n), string2);
                        this._value = "";
                        return "";
                    }
                    return this._value;
                }
                this._value = "";
                break;
            }
            case 19: {
                if (this._value instanceof BigDecimal) {
                    return this._value;
                }
                this._value = new FixedValue(0, 0, 0);
                break;
            }
            case 5: {
                if (type == InterfaceNode.ERROR) {
                    return null;
                }
            }
            default: {
                this._ER.internalError("Literal.finalValue(Type,String): invalid type ".concat(String.valueOf(String.valueOf(((Node)((Object)type)).typeName()))));
            }
        }
        this.typeMismatch(string, type);
        return this._value;
    }

    public static boolean floatType(int n) {
        switch (n) {
            case 6: 
            case 7: 
            case 18: {
                return true;
            }
        }
        return false;
    }

    public static boolean integralType(int n) {
        switch (n) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 16: 
            case 17: {
                return true;
            }
        }
        return false;
    }

    public static boolean integralType(Literal literal) {
        return Literal.integralType(literal._type);
    }

    void lshift(Literal literal) {
        if (Literal.integralType(this._type) && Literal.integralType(literal._type)) {
            long l = ((IntValue)literal._value)._val;
            if (l < (long)0 || l >= (long)64) {
                this._ER.error("Comp.FE.IDL.operandOutOfRange", new Object[]{"<<", new Long(l)});
                return;
            }
            ((IntValue)this._value).lshift((IntValue)literal._value);
        } else {
            this._ER.error("Comp.FE.IDL.needsIntegralOperands", "<<");
        }
    }

    void mod(Literal literal) {
        if (Literal.integralType(this) || !Literal.integralType(literal)) {
            try {
                ((IntValue)this._value).mod((IntValue)literal._value);
            }
            catch (ArithmeticException arithmeticException) {
                this._ER.error("Comp.FE.IDL.divideByZero");
            }
        } else {
            this._ER.error("Comp.FE.IDL.needsIntegralOperands", "%");
        }
    }

    void mul(Literal literal) {
        if (!Literal.anumber(this) || !Literal.anumber(literal)) {
            return;
        }
        if (Literal.integralType(this._type)) {
            if (Literal.integralType(literal._type)) {
                try {
                    ((IntValue)this._value).mul((IntValue)literal._value);
                }
                catch (ArithmeticException arithmeticException) {
                    this._ER.error("Comp.FE.IDL.overflow", "*");
                }
            } else {
                this._ER.error("Comp.FE.IDL.integralOperandMismatch", "*");
            }
        } else if (Literal.floatType(this._type)) {
            if (Literal.floatType(literal._type)) {
                this._value = new Double((Double)this._value * (Double)literal._value);
            } else {
                this._ER.error("Comp.FE.IDL.floatOperandMismatch", "*");
            }
        } else if (literal._type == 30000) {
            ((FixedValue)this._value).mul((FixedValue)literal._value);
        } else {
            this._ER.error("Comp.FE.IDL.fixedOperandMismatch", "*");
        }
    }

    public static boolean numericType(int n) {
        switch (n) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 16: 
            case 17: 
            case 18: 
            case 30000: {
                return true;
            }
        }
        return false;
    }

    private void outOfRange(String string, Type type, Long l) {
        if (string == null) {
            this._ER.error("Comp.FE.IDL.unnamedConstantValueOutOfRange", new Object[]{((Node)((Object)type)).typeName(), l});
        } else {
            this._ER.error("Comp.FE.IDL.constantValueOutOfRange", new Object[]{string, ((Node)((Object)type)).typeName(), l});
        }
    }

    void rshift(Literal literal) {
        if (Literal.integralType(this._type) && Literal.integralType(literal._type)) {
            long l = ((IntValue)literal._value)._val;
            if (l < (long)0 || l >= (long)64) {
                this._ER.error("Comp.FE.IDL.operandOutOfRange", new Object[]{">>", new Long(l)});
                return;
            }
            ((IntValue)this._value).rshift_pad_zero((IntValue)literal._value);
        } else {
            this._ER.error("Comp.FE.IDL.needsIntegralOperands", ">>");
        }
    }

    private void stringOverrun(String string, Long l, String string2) {
        if (string == null) {
            this._ER.error("Comp.FE.IDL.unnamedConstantStringExceedsBound", new Object[]{l, string2});
        } else {
            this._ER.error("Comp.FE.IDL.constantStringExceedsBound", new Object[]{string, l, string2});
        }
    }

    void sub(Literal literal) {
        if (!Literal.anumber(this) || !Literal.anumber(literal)) {
            return;
        }
        if (Literal.integralType(this._type)) {
            if (Literal.integralType(literal._type)) {
                try {
                    ((IntValue)this._value).sub((IntValue)literal._value);
                }
                catch (ArithmeticException arithmeticException) {
                    this._ER.error("Comp.FE.IDL.overflow", "-");
                }
            } else {
                this._ER.error("Comp.FE.IDL.integralOperandMismatch", "-");
            }
        } else if (Literal.floatType(this._type)) {
            if (Literal.floatType(literal._type)) {
                this._value = new Double((Double)this._value - (Double)literal._value);
            } else {
                this._ER.error("Comp.FE.IDL.floatOperandMismatch", "-");
            }
        } else if (literal._type == 30000) {
            ((FixedValue)this._value).sub((FixedValue)literal._value);
        } else {
            this._ER.error("Comp.FE.IDL.fixedOperandMismatch", "-");
        }
    }

    private void typeMismatch(String string, Type type) {
        if (string == null) {
            this._ER.error("Comp.FE.IDL.unnnamedConstantTypeValueMismatch", new Object[]{((Node)((Object)type)).typeName()});
        } else {
            this._ER.error("Comp.FE.IDL.constantTypeValueMismatch", new Object[]{string, ((Node)((Object)type)).typeName()});
        }
    }

    void unaryMinus() {
        if (!Literal.anumber(this)) {
            return;
        }
        if (Literal.integralType(this._type)) {
            ((IntValue)this._value).unaryMinus();
        } else if (Literal.floatType(this._type)) {
            this._value = new Double(-((Double)this._value).doubleValue());
        } else {
            ((FixedValue)this._value).unaryMinus();
        }
    }
}

