/*
 * Decompiled with CFR 0.152.
 */
package com.inprise.vbroker.compiler.backends.pascal;

import com.inprise.vbroker.compiler.ast.AliasNode;
import com.inprise.vbroker.compiler.ast.ConstantNode;
import com.inprise.vbroker.compiler.ast.ContainedNode;
import com.inprise.vbroker.compiler.ast.ContainerNode;
import com.inprise.vbroker.compiler.ast.EnumNode;
import com.inprise.vbroker.compiler.ast.ExceptionNode;
import com.inprise.vbroker.compiler.ast.InterfaceNode;
import com.inprise.vbroker.compiler.ast.ModuleNode;
import com.inprise.vbroker.compiler.ast.Node;
import com.inprise.vbroker.compiler.ast.PrimitiveNode;
import com.inprise.vbroker.compiler.ast.RepositoryNode;
import com.inprise.vbroker.compiler.ast.StructNode;
import com.inprise.vbroker.compiler.ast.Type;
import com.inprise.vbroker.compiler.ast.UnionNode;
import com.inprise.vbroker.compiler.backends.common.GenericBackend;
import com.inprise.vbroker.compiler.backends.pascal.PascalBase;
import com.inprise.vbroker.compiler.backends.pascal.ast.PAliasNode;
import com.inprise.vbroker.compiler.backends.pascal.ast.PArrayNode;
import com.inprise.vbroker.compiler.backends.pascal.ast.PAttributeNode;
import com.inprise.vbroker.compiler.backends.pascal.ast.PConstantNode;
import com.inprise.vbroker.compiler.backends.pascal.ast.PEnumNode;
import com.inprise.vbroker.compiler.backends.pascal.ast.PExceptionNode;
import com.inprise.vbroker.compiler.backends.pascal.ast.PInterfaceNode;
import com.inprise.vbroker.compiler.backends.pascal.ast.PMethod;
import com.inprise.vbroker.compiler.backends.pascal.ast.PModuleNode;
import com.inprise.vbroker.compiler.backends.pascal.ast.POperationNode;
import com.inprise.vbroker.compiler.backends.pascal.ast.PPrimitiveNode;
import com.inprise.vbroker.compiler.backends.pascal.ast.PRepositoryNode;
import com.inprise.vbroker.compiler.backends.pascal.ast.PSequenceNode;
import com.inprise.vbroker.compiler.backends.pascal.ast.PStructNode;
import com.inprise.vbroker.compiler.backends.pascal.ast.PType;
import com.inprise.vbroker.compiler.backends.pascal.ast.PUnionNode;
import com.inprise.vbroker.compiler.backends.pascal.ast.PascalBeOptions;
import com.inprise.vbroker.compiler.util.BufferWriter;
import java.security.MessageDigest;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

public final class PascalBackend
extends PascalBase {
    private int _pass;
    private final int COMMENT_LENGTH = 77;
    private static final int NUMBER_OF_PASSES = 4;
    private static final int PASCAL_I_FILE = 0;
    private static final int PASCAL_C_FILE = 1;
    private static final int PASCAL_S_FILE = 2;
    private static final int PASCAL_P_FILE = 3;
    private static final int GENERATE_I_FILE_DEFS = 11;
    private static final int GENERATE_I_GUID = 12;
    private static final int GENERATE_C_FILE_DEFS = 31;
    private static final int GENERATE_C_FILE_IMP = 32;
    private static final int GENERATE_C_STUB_IMP = 33;
    private static final int GENERATE_C_FILE_ADT_DEFS = 34;
    private static final int GENERATE_C_EXCEPTION_DEF = 35;
    private static final int GENERATE_C_EXCEPTION_IMP = 36;
    private static final int GENERATE_S_FILE_DEFS = 51;
    private static final int GENERATE_S_FILE_IMP = 52;
    private static final int GENERATE_S_EXCEPTION_DESCRIPTION = 53;
    private static final int GENERATE_S_EXCEPTION_HOOK_DESCRIPTION = 54;
    private static final int GENERATE_S_FILE_DESCRIPTION = 55;
    private static final int GENERATE_S_FILE_HOOK_DESCRIPTION = 56;
    private static final int GENERATE_S_SKELETON_IMP = 71;
    private static final int GENERATE_S_SKELETON_MARSHAL = 72;
    private static final int GENERATE_P_FILE_DEFS = 81;
    private static final int GENERATE_P_FILE_IMPL = 82;
    private static final int GENERATE_P_FILE_PROPERTY_PROXIES = 83;
    private static final int METHOD_TYPE_PRIMARY = 101;
    private static final int METHOD_TYPE_SECONDARY = 102;
    private int nextMethodIndex;

    public PascalBackend(ContainerNode containerNode, BufferWriter bufferWriter, String string, Vector vector) {
        super(((Node)((Object)containerNode))._repository, bufferWriter, string, vector);
        ((PRepositoryNode)((Node)((Object)containerNode))._repository).pascalInit(string);
        this.generate(containerNode);
    }

    public PascalBackend(ContainerNode containerNode, BufferWriter bufferWriter, String string, Vector vector, String string2) {
        super(((Node)((Object)containerNode))._repository, bufferWriter, string, vector);
        ((PRepositoryNode)containerNode).pascalInit(string2);
        this.generate(containerNode);
    }

    protected final void add(char c) {
        super.add(this._pass, c);
    }

    protected final void add(int n) {
        super.add(this._pass, n);
    }

    protected final void add(String string) {
        super.add(this._pass, string);
    }

    protected final void addln(int n) {
        super.addln(this._pass, n);
    }

    protected final void addln(long l) {
        super.addln(this._pass, l);
    }

    protected final void addln(String string) {
        super.addln(this._pass, string);
    }

    private void assembleImplementation(PExceptionNode pExceptionNode) {
        this.usePascalUnitImplementationBuffer(this._pass, pExceptionNode);
        switch (this._pass) {
            case 0: {
                break;
            }
            case 1: {
                if (this.getPascalExceptionPropertiesBuffer(this._pass, pExceptionNode).length() > 0) {
                    this.printUnindented(this.getPascalExceptionPropertiesBuffer(this._pass, pExceptionNode).toString());
                }
                if (this.getPascalExceptionPropertyMethodsBuffer(this._pass, pExceptionNode).length() > 0) {
                    this.printUnindented(this.getPascalExceptionPropertyMethodsBuffer(this._pass, pExceptionNode).toString());
                }
                if (this.getPascalExceptionMethodsBuffer(this._pass, pExceptionNode).length() <= 0) break;
                this.printUnindented(this.getPascalExceptionMethodsBuffer(this._pass, pExceptionNode).toString());
                break;
            }
            case 2: {
                break;
            }
        }
        pExceptionNode.componentBuffers.discard(this._pass);
    }

    private void assembleImplementation(PInterfaceNode pInterfaceNode) {
        this.usePascalUnitImplementationBuffer(this._pass, pInterfaceNode);
        switch (this._pass) {
            case 0: {
                if (this.getPascalInterfacePropertyMethodsBuffer(this._pass, pInterfaceNode).length() > 0) {
                    this.writeIdlComment("Implementation of Accessor and mutator methods for Properties (IDL Attributes).");
                    this.printUnindented(this.getPascalInterfacePropertyMethodsBuffer(this._pass, pInterfaceNode).toString());
                }
                if (this.getPascalInterfaceMethodsBuffer(this._pass, pInterfaceNode).length() <= 0) break;
                this.writeIdlComment("Implementation of Interface methods representing IDL operations.");
                this.printUnindented(this.getPascalInterfaceMethodsBuffer(this._pass, pInterfaceNode).toString());
                break;
            }
            case 1: {
                if (this.getPascalInterfacePropertyMethodsBuffer(this._pass, pInterfaceNode).length() > 0) {
                    this.writeIdlComment("Implementation of Accessor and mutator methods for Properties (IDL Attributes).");
                    this.printUnindented(this.getPascalInterfacePropertyMethodsBuffer(this._pass, pInterfaceNode).toString());
                }
                if (this.getPascalInterfaceMethodsBuffer(this._pass, pInterfaceNode).length() <= 0) break;
                this.writeIdlComment("Implementation of Interface methods representing IDL operations.");
                this.printUnindented(this.getPascalInterfaceMethodsBuffer(this._pass, pInterfaceNode).toString());
                break;
            }
            case 2: {
                if (this.getPascalInterfacePropertyMethodsBuffer(this._pass, pInterfaceNode).length() > 0) {
                    this.writeIdlComment("Implementation of Accessor and mutator methods for Properties (IDL Attributes).");
                    this.printUnindented(this.getPascalInterfacePropertyMethodsBuffer(this._pass, pInterfaceNode).toString());
                    this.newLine();
                }
                if (this.getPascalInterfaceMethodsBuffer(this._pass, pInterfaceNode).length() <= 0) break;
                this.writeIdlComment("Implementation of Interface methods representing IDL operations.");
                this.printUnindented(this.getPascalInterfaceMethodsBuffer(this._pass, pInterfaceNode).toString());
                break;
            }
            case 3: {
                if (this.getPascalInterfacePropertyMethodsBuffer(this._pass, pInterfaceNode).length() > 0) {
                    this.writeIdlComment("Implementation of Accessor and mutator methods for Properties (IDL Attributes).");
                    this.printUnindented(this.getPascalInterfacePropertyMethodsBuffer(this._pass, pInterfaceNode).toString());
                    this.newLine();
                }
                if (this.getPascalInterfaceMethodsBuffer(this._pass, pInterfaceNode).length() <= 0) break;
                this.writeIdlComment("Implementation of Interface methods representing IDL operations.");
                this.printUnindented(this.getPascalInterfaceMethodsBuffer(this._pass, pInterfaceNode).toString());
            }
        }
        pInterfaceNode.componentBuffers.discard(this._pass);
    }

    private void assemblePascalCFile(Node node) {
        String string = null;
        switch (node._kind) {
            case 6: {
                string = String.valueOf(String.valueOf(((PModuleNode)node).pascalCFilePath)).concat(String.valueOf(String.valueOf(((PModuleNode)node).pascalCUnitName)));
                break;
            }
            case 17: {
                string = String.valueOf(String.valueOf(((PRepositoryNode)node).pascalCFilePath)).concat(String.valueOf(String.valueOf(((PRepositoryNode)node).pascalCUnitName)));
                break;
            }
            default: {
                string = null;
                this._ER.internalError(String.valueOf(String.valueOf(new StringBuffer("invalid Node kind ").append(node._kind).append(" passed to assemblePascalCFile(Node, String)"))));
            }
        }
        this.assemblePascalFile(node, 1, PascalBeOptions.overwriteStubs, string, "", "", "", "Warning : This section should contain no type definitions. There may have been an error in the operation of the idl2pas compiler.", "", "Warning : This section should contain no constants. There may have been an error in the operation of the idl2pas compiler.", "", "Warning : This section should contain no enumerated datatypes. There may have been an error in the operation of the idl2pas compiler.", "", "", "", "", "", "", "", "", "", "", "", "", "");
        switch (node._kind) {
            case 6: {
                ((PModuleNode)node).componentBuffers.discard(this._pass);
                break;
            }
            case 17: {
                ((PRepositoryNode)node).componentBuffers.discard(this._pass);
                break;
            }
            default: {
                string = null;
                this._ER.internalError(String.valueOf(String.valueOf(new StringBuffer("invalid Node kind ").append(node._kind).append(" passed to assemblePascalCFile(Node, String)"))));
            }
        }
    }

    private final void assemblePascalFile(Node node, int n, boolean bl, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, String string13, String string14, String string15, String string16, String string17, String string18, String string19, String string20, String string21, String string22) {
        boolean bl2;
        boolean bl3 = this.getPascalUnitInterfaceFwdDefBuffer(n, node).toString().length() <= 0 && this.getPascalUnitTypedefBuffer(n, node).toString().length() <= 0 && this.getPascalUnitInterfaceDescriptionBuffer(n, node).toString().length() <= 0;
        boolean bl4 = this.getPascalUnitEnumsBuffer(n, node).toString().length() <= 0;
        boolean bl5 = bl2 = this.getPascalUnitConstantsBuffer(n, node).toString().length() <= 0;
        if (bl3 && bl4 && bl2 && !PascalBeOptions.generateEmptyUnits) {
            return;
        }
        this.useFile(string);
        this.printDirect(this.getPascalUnitPreambleBuffer(n, node).toString());
        this.printDirect(GenericBackend.LINE_SEP);
        this.printDirect(GenericBackend.LINE_SEP);
        this.printDirect("interface");
        this.printDirect(GenericBackend.LINE_SEP);
        if (!(bl2 && bl4 && bl3)) {
            this.printSubsectionToFile("uses", this.getPascalUnitUnitsUsedBuffer(n, node).toString(), string3, string4);
        }
        if (!bl4) {
            this.printSubsectionToFile("type", this.getPascalUnitEnumsBuffer(n, node).toString(), string9, string10);
        }
        if (!bl2) {
            this.printSubsectionToFile("const", this.getPascalUnitConstantsBuffer(n, node).toString(), string7, string8);
        }
        if (!bl3) {
            this.printDirect(GenericBackend.LINE_SEP);
            this.printDirect("type");
            this.printDirect(GenericBackend.LINE_SEP);
            this.printSubsectionToFile("", this.getPascalUnitInterfaceFwdDefBuffer(n, node).toString(), string11, string12);
            this.printSubsectionToFile("", this.getPascalUnitTypedefBuffer(n, node).toString(), string5, string6);
            this.printSubsectionToFile("", this.getPascalUnitInterfaceDescriptionBuffer(n, node).toString(), string13, string14);
        }
        this.printDirect(GenericBackend.LINE_SEP);
        this.printDirect(GenericBackend.LINE_SEP);
        this.printDirect("implementation");
        this.printDirect(GenericBackend.LINE_SEP);
        if (this.getPascalUnitUnitsUsed2Buffer(n, node).toString().length() > 0 && this.getPascalUnitUnitsUsed2Buffer(n, node).toString().trim().length() > 0) {
            this.printSubsectionToFile("uses", this.getPascalUnitUnitsUsed2Buffer(n, node).toString(), string3, string4);
        }
        this.printSectionToFile("var", this.getPascalUnitImplementationVarBuffer(n, node).toString(), string15, string16);
        this.printSectionToFile("", this.getPascalUnitImplementationBuffer(n, node).toString(), string17, string18);
        this.printDirect(GenericBackend.LINE_SEP);
        this.printDirect(GenericBackend.LINE_SEP);
        this.printDirect("initialization");
        this.printDirect(GenericBackend.LINE_SEP);
        this.printSectionToFile("", this.getPascalUnitInitialisationManagerBuffer(n, node).toString(), string19, string20);
        this.printSectionToFile("", this.getPascalUnitInitialisationExceptionBuffer(n, node).toString(), "", "");
        this.printSectionToFile("finalization", this.getPascalUnitFinalisationBuffer(n, node).toString(), string21, string22);
        this.printDirect(GenericBackend.LINE_SEP);
        this.printDirect(GenericBackend.LINE_SEP);
        this.printDirect("end.");
        this.closeFile(string, bl);
    }

    private void assemblePascalIFile(Node node) {
        String string = null;
        switch (node._kind) {
            case 6: {
                string = String.valueOf(String.valueOf(((PModuleNode)node).pascalIFilePath)).concat(String.valueOf(String.valueOf(((PModuleNode)node).pascalIUnitName)));
                break;
            }
            case 17: {
                string = String.valueOf(String.valueOf(((PRepositoryNode)node).pascalIFilePath)).concat(String.valueOf(String.valueOf(((PRepositoryNode)node).pascalIUnitName)));
                break;
            }
            default: {
                string = null;
                this._ER.internalError(String.valueOf(String.valueOf(new StringBuffer("invalid Node kind ").append(node._kind).append(" passed to assemblePascalIFile(Node, String)"))));
            }
        }
        this.assemblePascalFile(node, 0, PascalBeOptions.overwriteInterfaces, string, "", "", "", "", "", "(Do not edit the values assigned to these constants.)", "", "", "", "", "", "", "", "Warning : There should be no implementation variables in this unit. There may have been an error in the operation of the idl2pas compiler.", "", "Warning : There should be no implementation code in this unit. There may have been an error in the operation of the idl2pas compiler.", "", "Warning : There should be no initialization code in this unit. There may have been an error in the operation of the idl2pas compiler.", "", "Warning : There should be no finalization code in this unit. There may have been an error in the operation of the idl2pas compiler.", "");
        switch (node._kind) {
            case 6: {
                ((PModuleNode)node).componentBuffers.discard(this._pass);
                break;
            }
            case 17: {
                ((PRepositoryNode)node).componentBuffers.discard(this._pass);
                break;
            }
            default: {
                string = null;
                this._ER.internalError(String.valueOf(String.valueOf(new StringBuffer("invalid Node kind ").append(node._kind).append(" passed to assemblePascalIFile(Node, String)"))));
            }
        }
    }

    private void assemblePascalPFile(Node node) {
        String string = null;
        switch (node._kind) {
            case 6: {
                string = String.valueOf(String.valueOf(((PModuleNode)node).pascalSFilePath)).concat(String.valueOf(String.valueOf(((PModuleNode)node).pascalPUnitName)));
                break;
            }
            case 17: {
                string = String.valueOf(String.valueOf(((PRepositoryNode)node).pascalSFilePath)).concat(String.valueOf(String.valueOf(((PRepositoryNode)node).pascalPUnitName)));
                break;
            }
            default: {
                string = null;
                this._ER.internalError(String.valueOf(String.valueOf(new StringBuffer("invalid Node kind ").append(node._kind).append(" passed to assemblePascalPFile(Node, String)"))));
            }
        }
        this.assemblePascalFile(node, 3, PascalBeOptions.overwriteImplementations, string, "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "");
        switch (node._kind) {
            case 6: {
                ((PModuleNode)node).componentBuffers.discard(this._pass);
                break;
            }
            case 17: {
                ((PRepositoryNode)node).componentBuffers.discard(this._pass);
                break;
            }
            default: {
                string = null;
                this._ER.internalError(String.valueOf(String.valueOf(new StringBuffer("invalid Node kind ").append(node._kind).append(" passed to assemblePascalPFile(Node, String)"))));
            }
        }
    }

    private void assemblePascalSFile(Node node) {
        String string = null;
        switch (node._kind) {
            case 6: {
                string = String.valueOf(String.valueOf(((PModuleNode)node).pascalSFilePath)).concat(String.valueOf(String.valueOf(((PModuleNode)node).pascalSUnitName)));
                break;
            }
            case 17: {
                string = String.valueOf(String.valueOf(((PRepositoryNode)node).pascalSFilePath)).concat(String.valueOf(String.valueOf(((PRepositoryNode)node).pascalSUnitName)));
                break;
            }
            default: {
                string = null;
                this._ER.internalError(String.valueOf(String.valueOf(new StringBuffer("invalid Node kind ").append(node._kind).append(" passed to assemblePascalSFile(Node, String)"))));
            }
        }
        this.assemblePascalFile(node, 2, PascalBeOptions.overwriteSkeletons, string, "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "");
        switch (node._kind) {
            case 6: {
                ((PModuleNode)node).componentBuffers.discard(this._pass);
                break;
            }
            case 17: {
                ((PRepositoryNode)node).componentBuffers.discard(this._pass);
                break;
            }
            default: {
                string = null;
                this._ER.internalError(String.valueOf(String.valueOf(new StringBuffer("invalid Node kind ").append(node._kind).append(" passed to assemblePascalSFile(Node, String)"))));
            }
        }
    }

    private void assembleSignature(PExceptionNode pExceptionNode) {
        this.usePascalUnitInterfaceDescriptionBuffer(this._pass, pExceptionNode);
        switch (this._pass) {
            case 0: {
                break;
            }
            case 1: {
                if (this.getPascalExceptionFieldsBuffer(this._pass, pExceptionNode).length() > 0) {
                    this.println("private");
                    this.printUnindented(this.getPascalExceptionFieldsBuffer(this._pass, pExceptionNode).toString());
                }
                if (this.getPascalExceptionPropertyMethodsBuffer(this._pass, pExceptionNode).length() > 0) {
                    this.println("protected");
                    this.printUnindented(this.getPascalExceptionPropertyMethodsBuffer(this._pass, pExceptionNode).toString());
                }
                if (this.getPascalExceptionPropertiesBuffer(this._pass, pExceptionNode).length() <= 0 && this.getPascalExceptionMethodsBuffer(this._pass, pExceptionNode).length() <= 0) break;
                this.println("public");
                if (this.getPascalExceptionPropertiesBuffer(this._pass, pExceptionNode).length() > 0) {
                    this.printUnindented(this.getPascalExceptionPropertiesBuffer(this._pass, pExceptionNode).toString());
                }
                if (this.getPascalExceptionMethodsBuffer(this._pass, pExceptionNode).length() <= 0) break;
                this.printUnindented(this.getPascalExceptionMethodsBuffer(this._pass, pExceptionNode).toString());
                break;
            }
            case 2: {
                break;
            }
        }
        pExceptionNode.componentBuffers.discard(this._pass);
    }

    private void assembleSignature(PInterfaceNode pInterfaceNode) {
        this.usePascalUnitInterfaceDescriptionBuffer(this._pass, pInterfaceNode);
        switch (this._pass) {
            case 0: {
                if (this.getPascalInterfacePropertyMethodsBuffer(this._pass, pInterfaceNode).length() > 0) {
                    this.writeIdlComment("Accessor and mutator methods for Properties (IDL Attributes).");
                    this.printUnindented(this.getPascalInterfacePropertyMethodsBuffer(this._pass, pInterfaceNode).toString());
                }
                if (this.getPascalInterfaceMethodsBuffer(this._pass, pInterfaceNode).length() > 0) {
                    this.writeIdlComment("Interface methods representing IDL operations.");
                    this.printUnindented(this.getPascalInterfaceMethodsBuffer(this._pass, pInterfaceNode).toString());
                }
                if (this.getPascalInterfacePropertiesBuffer(this._pass, pInterfaceNode).length() <= 0) break;
                this.writeIdlComment("Properties representing IDL Attributes.");
                this.printUnindented(this.getPascalInterfacePropertiesBuffer(this._pass, pInterfaceNode).toString());
                break;
            }
            case 1: {
                if (this.getPascalInterfacePropertyMethodsBuffer(this._pass, pInterfaceNode).length() > 0) {
                    this.println("protected");
                    this.printUnindented(this.getPascalInterfacePropertyMethodsBuffer(this._pass, pInterfaceNode).toString());
                }
                if (this.getPascalInterfaceMethodsBuffer(this._pass, pInterfaceNode).length() > 0) {
                    this.println("public");
                    this.printUnindented(this.getPascalInterfaceMethodsBuffer(this._pass, pInterfaceNode).toString());
                }
                if (this.getPascalInterfacePropertiesBuffer(this._pass, pInterfaceNode).length() <= 0) break;
                this.println("published");
                this.printUnindented(this.getPascalInterfacePropertiesBuffer(this._pass, pInterfaceNode).toString());
                break;
            }
            case 2: {
                if (this.getPascalInterfacePropertiesBuffer(this._pass, pInterfaceNode).length() > 0) {
                    this.println("private");
                    this.printUnindented(this.getPascalInterfacePropertiesBuffer(this._pass, pInterfaceNode).toString());
                }
                if (this.getPascalInterfaceMethodsBuffer(this._pass, pInterfaceNode).length() > 0) {
                    this.println("public");
                    this.printUnindented(this.getPascalInterfaceMethodsBuffer(this._pass, pInterfaceNode).toString());
                }
                if (this.getPascalInterfacePropertyMethodsBuffer(this._pass, pInterfaceNode).length() <= 0) break;
                this.println("published");
                this.printUnindented(this.getPascalInterfacePropertyMethodsBuffer(this._pass, pInterfaceNode).toString());
                break;
            }
            case 3: {
                if (this.getPascalInterfacePropertyMethodsBuffer(this._pass, pInterfaceNode).length() > 0) {
                    this.printUnindented(this.getPascalInterfacePropertyMethodsBuffer(this._pass, pInterfaceNode).toString());
                }
                if (this.getPascalInterfaceMethodsBuffer(this._pass, pInterfaceNode).length() > 0) {
                    this.println("public");
                    this.printUnindented(this.getPascalInterfaceMethodsBuffer(this._pass, pInterfaceNode).toString());
                }
                if (this.getPascalInterfacePropertiesBuffer(this._pass, pInterfaceNode).length() <= 0) break;
                this.printUnindented(this.getPascalInterfacePropertiesBuffer(this._pass, pInterfaceNode).toString());
            }
        }
        pInterfaceNode.componentBuffers.discard(this._pass);
    }

    private void assembleSignature(PStructNode pStructNode) {
        this.usePascalUnitInterfaceDescriptionBuffer(this._pass, pStructNode);
        switch (this._pass) {
            case 0: {
                if (this.getPascalAdtPropertyMethodsBuffer(this._pass, pStructNode).length() > 0) {
                    this.writeIdlComment("Accessor and mutator methods for IDL Structure Elements.");
                    this.printUnindented(this.getPascalAdtPropertyMethodsBuffer(this._pass, pStructNode).toString());
                }
                if (this.getPascalAdtPropertiesBuffer(this._pass, pStructNode).length() <= 0) break;
                this.writeIdlComment("Properties representing IDL Structure Elements.");
                this.printUnindented(this.getPascalAdtPropertiesBuffer(this._pass, pStructNode).toString());
                break;
            }
            case 1: {
                if (this.getPascalAdtPropertyMethodsBuffer(this._pass, pStructNode).length() > 0) {
                    this.println("private");
                    this.printUnindented(this.getPascalAdtPropertiesBuffer(this._pass, pStructNode).toString());
                }
                if (this.getPascalAdtPropertiesBuffer(this._pass, pStructNode).length() <= 0) break;
                this.println("public");
                this.printUnindented(this.getPascalAdtPropertyMethodsBuffer(this._pass, pStructNode).toString());
                break;
            }
            case 2: {
                break;
            }
        }
        pStructNode.componentBuffers.discard(this._pass);
    }

    private void assembleSignature(PUnionNode pUnionNode) {
        this.usePascalUnitInterfaceDescriptionBuffer(this._pass, pUnionNode);
        switch (this._pass) {
            case 0: {
                if (this.getPascalAdtPropertyMethodsBuffer(this._pass, pUnionNode).length() > 0) {
                    this.writeIdlComment("Accessor and mutator methods for IDL Union Elements.");
                    this.printUnindented(this.getPascalAdtPropertyMethodsBuffer(this._pass, pUnionNode).toString());
                }
                if (this.getPascalAdtPropertiesBuffer(this._pass, pUnionNode).length() <= 0) break;
                this.writeIdlComment("Properties representing IDL Union Elements.");
                this.printUnindented(this.getPascalAdtPropertiesBuffer(this._pass, pUnionNode).toString());
                break;
            }
            case 1: {
                if (this.getPascalAdtPropertyMethodsBuffer(this._pass, pUnionNode).length() > 0) {
                    this.println("private");
                    this.printUnindented(this.getPascalAdtPropertiesBuffer(this._pass, pUnionNode).toString());
                }
                if (this.getPascalAdtPropertiesBuffer(this._pass, pUnionNode).length() <= 0) break;
                this.println("public");
                this.printUnindented(this.getPascalAdtPropertyMethodsBuffer(this._pass, pUnionNode).toString());
                break;
            }
            case 2: {
                break;
            }
        }
        pUnionNode.componentBuffers.discard(this._pass);
    }

    private void beginDefaultModule(RepositoryNode repositoryNode) {
        PRepositoryNode pRepositoryNode = (PRepositoryNode)repositoryNode;
        if (!pRepositoryNode.bUnitIsEmpty && pRepositoryNode.pascalUnstarted[this._pass]) {
            pRepositoryNode.componentBuffers.reset(this._pass);
            pRepositoryNode.pascalUnstarted[this._pass] = false;
        }
    }

    protected final void beginLineBreaking() {
        super.beginLineBreaking(this._pass);
    }

    protected void beginModule(ModuleNode moduleNode) {
        super.beginModule(moduleNode);
        PModuleNode pModuleNode = (PModuleNode)moduleNode;
        switch (this._pass) {
            case 0: {
                pModuleNode.componentBuffers.reset(0);
                pModuleNode.pascalUnstarted[0] = false;
                break;
            }
            case 1: {
                pModuleNode.componentBuffers.reset(1);
                pModuleNode.pascalUnstarted[1] = false;
            }
        }
        if (pModuleNode.pascalUnstarted[2]) {
            pModuleNode.componentBuffers.reset(2);
            pModuleNode.pascalUnstarted[2] = false;
        }
        if (pModuleNode.pascalUnstarted[3]) {
            pModuleNode.componentBuffers.reset(3);
            pModuleNode.pascalUnstarted[3] = false;
        }
    }

    private final void calcMethodGuid(PMethod pMethod, MessageDigest messageDigest, int n) {
        switch (n) {
            case 12: {
                messageDigest.update((byte)46);
                messageDigest.update(pMethod.pascalName.getBytes());
                messageDigest.update((byte)46);
                for (int i = 0; i < pMethod.pascalParamNames.length; ++i) {
                    if (pMethod.pascalParamHelperNames[i] != null) {
                        messageDigest.update(pMethod.pascalParamHelperNames[i].getBytes());
                    } else {
                        messageDigest.update(pMethod.pascalParamTypeNames[i].getBytes());
                    }
                    messageDigest.update((byte)46);
                }
                if (pMethod.hasReturnValue) {
                    messageDigest.update(this.writeReturnText(pMethod, n).getBytes());
                    break;
                }
                String string = "void";
                messageDigest.update(string.getBytes());
                break;
            }
            default: {
                this._ER.internalError(String.valueOf(String.valueOf(new StringBuffer("invalid mode ").append(n).append(" passed to calcMethodGuid (PMethod, MessageDigest, int)"))));
            }
        }
    }

    private final void calcMethodGuids(ContainedNode[] containedNodeArray, MessageDigest messageDigest, int n) {
        int n2 = containedNodeArray.length;
        block4: for (int i = 0; i < n2; ++i) {
            switch (containedNodeArray[i]._kind) {
                case 7: {
                    this.calcMethodGuid(((POperationNode)containedNodeArray[i]).pascalMethod, messageDigest, n);
                    continue block4;
                }
                case 2: {
                    PAttributeNode pAttributeNode = (PAttributeNode)containedNodeArray[i];
                    this.calcMethodGuid(pAttributeNode.pascalGetMethod, messageDigest, n);
                    if (pAttributeNode._readOnly) continue block4;
                    this.calcMethodGuid(pAttributeNode.pascalSetMethod, messageDigest, n);
                    continue block4;
                }
                default: {
                    this._ER.internalError(String.valueOf(String.valueOf(new StringBuffer("invalid kind ").append(containedNodeArray[i]._kind).append(" passed to calcMethodGuids(ContainedNode[], MessageDigest, int)"))));
                }
            }
        }
    }

    protected void endDefaultModule(RepositoryNode repositoryNode) {
        PRepositoryNode pRepositoryNode = (PRepositoryNode)repositoryNode;
        if (!pRepositoryNode.bUnitIsEmpty) {
            switch (this._pass) {
                case 0: {
                    this.writeUsedUnits(0, pRepositoryNode);
                    this.writeUsedUnits2(0, pRepositoryNode);
                    this.startPascalIFile(pRepositoryNode);
                    this.assemblePascalIFile(pRepositoryNode);
                    pRepositoryNode.pascalUnwritten[0] = false;
                    break;
                }
                case 1: {
                    this.writeUsedUnits(1, pRepositoryNode);
                    this.writeUsedUnits2(1, pRepositoryNode);
                    this.startPascalCFile(pRepositoryNode);
                    this.assemblePascalCFile(pRepositoryNode);
                    pRepositoryNode.pascalUnwritten[1] = false;
                    break;
                }
                case 2: {
                    this.writeUsedUnits(2, pRepositoryNode);
                    this.writeUsedUnits2(2, pRepositoryNode);
                    this.startPascalSFile(pRepositoryNode);
                    this.assemblePascalSFile(pRepositoryNode);
                    pRepositoryNode.pascalUnwritten[2] = false;
                    break;
                }
                case 3: {
                    this.writeUsedUnits(3, pRepositoryNode);
                    this.writeUsedUnits2(3, pRepositoryNode);
                    this.startPascalPFile(pRepositoryNode);
                    this.assemblePascalPFile(pRepositoryNode);
                    pRepositoryNode.pascalUnwritten[3] = false;
                }
            }
        }
    }

    protected final void endLineBreaking() {
        super.endLineBreaking(this._pass);
    }

    protected void endModule(ModuleNode moduleNode) {
        super.endModule(moduleNode);
        PModuleNode pModuleNode = (PModuleNode)moduleNode;
        switch (this._pass) {
            case 0: {
                this.writeUsedUnits(0, pModuleNode);
                this.writeUsedUnits2(0, pModuleNode);
                this.startPascalIFile(pModuleNode);
                this.assemblePascalIFile(pModuleNode);
                pModuleNode.pascalUnwritten[0] = false;
                break;
            }
            case 1: {
                this.writeUsedUnits(1, pModuleNode);
                this.writeUsedUnits2(1, pModuleNode);
                this.startPascalCFile(pModuleNode);
                this.assemblePascalCFile(pModuleNode);
                pModuleNode.pascalUnwritten[1] = false;
                break;
            }
            case 2: {
                this.writeUsedUnits(2, pModuleNode);
                this.writeUsedUnits2(2, pModuleNode);
                this.startPascalSFile(pModuleNode);
                this.assemblePascalSFile(pModuleNode);
                pModuleNode.pascalUnwritten[2] = false;
                break;
            }
            case 3: {
                this.writeUsedUnits(3, pModuleNode);
                this.writeUsedUnits2(3, pModuleNode);
                this.startPascalPFile(pModuleNode);
                this.assemblePascalPFile(pModuleNode);
                pModuleNode.pascalUnwritten[3] = false;
            }
        }
    }

    protected final void ensureIndent() {
        super.ensureIndent(this._pass);
    }

    protected final void ensureNewLine() {
        super.ensureNewLine(this._pass);
    }

    private final String formatGuid(MessageDigest messageDigest) {
        byte[] byArray = messageDigest.digest();
        StringBuffer stringBuffer = new StringBuffer(2 * byArray.length + 4);
        for (int i = 0; i < byArray.length; ++i) {
            int n = byArray[i] & 0xFF;
            int n2 = stringBuffer.length();
            if (n2 == 8 || n2 == 13 || n2 == 18 || n2 == 23) {
                stringBuffer.append('-');
            }
            if (n < 16) {
                stringBuffer.append("0".concat(String.valueOf(String.valueOf(Integer.toHexString(n)))));
                continue;
            }
            stringBuffer.append(Integer.toHexString(n));
        }
        return stringBuffer.toString().toUpperCase();
    }

    protected final void gen() {
        if (this._depSolver == this._topDepSolver) {
            if (PascalBeOptions.generateInterfaces) {
                this._pass = 0;
                this.beginDefaultModule(this._repository);
                super.gen();
                this.endDefaultModule(this._repository);
            }
            if (PascalBeOptions.generateStubs) {
                this._pass = 1;
                this.beginDefaultModule(this._repository);
                super.gen();
                this.endDefaultModule(this._repository);
            }
            if (PascalBeOptions.generateSkeletons) {
                this._pass = 2;
                this.beginDefaultModule(this._repository);
                super.gen();
                this.endDefaultModule(this._repository);
            }
            if (PascalBeOptions.generateImplementations) {
                this._pass = 3;
                this.beginDefaultModule(this._repository);
                super.gen();
                this.endDefaultModule(this._repository);
            }
        } else {
            super.gen();
        }
    }

    protected final void genAlias(AliasNode aliasNode) {
        PAliasNode pAliasNode = (PAliasNode)aliasNode;
        if (pAliasNode.pascalUnwritten[this._pass]) {
            switch (this._pass) {
                case 0: {
                    this.pascalIfaceSignature(pAliasNode);
                    break;
                }
                case 1: {
                    this.pascalHelperSignature(pAliasNode);
                    this.pascalHelperImplementation(pAliasNode);
                    break;
                }
                case 2: {
                    break;
                }
            }
            pAliasNode.pascalUnwritten[this._pass] = false;
        }
    }

    protected final void genConstant(ConstantNode constantNode) {
        PConstantNode pConstantNode = (PConstantNode)constantNode;
        if (pConstantNode.pascalUnwritten[this._pass]) {
            switch (this._pass) {
                case 0: {
                    this.pascalIfaceSignature(pConstantNode);
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
            }
            pConstantNode.pascalUnwritten[this._pass] = false;
        }
    }

    protected void genEnum(EnumNode enumNode, String string) {
        PEnumNode pEnumNode = (PEnumNode)enumNode;
        if (pEnumNode.pascalUnwritten[this._pass]) {
            switch (this._pass) {
                case 0: {
                    this.pascalIfaceSignature(pEnumNode);
                    break;
                }
                case 1: {
                    this.pascalHelperSignature(pEnumNode);
                    this.pascalHelperImplementation(pEnumNode);
                    break;
                }
                case 2: {
                    break;
                }
            }
            pEnumNode.pascalUnwritten[this._pass] = false;
        }
    }

    protected final void genException(ExceptionNode exceptionNode) {
        PExceptionNode pExceptionNode = (PExceptionNode)exceptionNode;
        if (pExceptionNode.pascalUnwritten[this._pass]) {
            switch (this._pass) {
                case 0: {
                    break;
                }
                case 1: {
                    this.pascalStubSignature(pExceptionNode);
                    this.pascalStubImplementation(pExceptionNode);
                    this.pascalStubInitialization(pExceptionNode);
                    this.pascalStubFinalization(pExceptionNode);
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    break;
                }
                default: {
                    this._ER.internalError(String.valueOf(String.valueOf(new StringBuffer("invalid mode ").append(this._pass).append(" passed to genException (final PExceptionNode, int)"))));
                }
            }
            pExceptionNode.pascalUnwritten[this._pass] = false;
            this.genContents(exceptionNode);
        }
    }

    protected final void genInterface(InterfaceNode interfaceNode) {
        PInterfaceNode pInterfaceNode = (PInterfaceNode)interfaceNode;
        if (pInterfaceNode.pascalUnwritten[this._pass]) {
            switch (this._pass) {
                case 0: {
                    this.pascalIfaceSignature(pInterfaceNode);
                    break;
                }
                case 1: {
                    this.pascalHelperSignature(pInterfaceNode);
                    this.pascalStubSignature(pInterfaceNode);
                    this.pascalHelperImplementation(pInterfaceNode);
                    this.pascalStubImplementation(pInterfaceNode);
                    this.pascalHelperInitialization(pInterfaceNode);
                    break;
                }
                case 2: {
                    this.pascalSkeletonSignature(pInterfaceNode);
                    this.pascalSkeletonImplementation(pInterfaceNode);
                    break;
                }
                case 3: {
                    this.pascalImplSignature(pInterfaceNode);
                    this.pascalImplImplementation(pInterfaceNode);
                }
            }
            pInterfaceNode.pascalUnwritten[this._pass] = false;
            this.genContents(interfaceNode);
        }
    }

    protected final void genStruct(StructNode structNode, String string) {
        PStructNode pStructNode = (PStructNode)structNode;
        if (pStructNode.pascalUnwritten[this._pass]) {
            int n = pStructNode.pascalMembersAreAnonymousAliases.length;
            for (int i = 0; i < n; ++i) {
                if (!pStructNode.pascalMembersAreAnonymousAliases[i]) continue;
                this.genAlias((AliasNode)((Object)pStructNode.pascalMemberTypes[i]));
            }
            switch (this._pass) {
                case 0: {
                    this.pascalIfaceSignature(pStructNode);
                    break;
                }
                case 1: {
                    this.pascalHelperSignature(pStructNode);
                    this.pascalStubSignature(pStructNode);
                    this.pascalHelperImplementation(pStructNode);
                    this.pascalStubImplementation(pStructNode);
                    break;
                }
                case 2: {
                    break;
                }
            }
            pStructNode.pascalUnwritten[this._pass] = false;
            this.genContents(structNode);
        }
    }

    protected final void genUnion(UnionNode unionNode, String string) {
        PUnionNode pUnionNode = (PUnionNode)unionNode;
        if (pUnionNode.pascalUnwritten[this._pass]) {
            int n = pUnionNode.pascalMembersAreAnonymousAliases.length;
            for (int i = 0; i < n; ++i) {
                if (!pUnionNode.pascalMembersAreAnonymousAliases[i]) continue;
                this.genAlias((AliasNode)((Object)pUnionNode.pascalMemberTypes[i]));
            }
            switch (this._pass) {
                case 0: {
                    this.pascalIfaceSignature(pUnionNode);
                    break;
                }
                case 1: {
                    this.pascalHelperSignature(pUnionNode);
                    this.pascalStubSignature(pUnionNode);
                    this.pascalHelperImplementation(pUnionNode);
                    this.pascalStubImplementation(pUnionNode);
                    break;
                }
                case 2: {
                    break;
                }
            }
            pUnionNode.pascalUnwritten[this._pass] = false;
            this.genContents(unionNode);
        }
    }

    public void generate(ContainerNode containerNode) {
        super.generate(containerNode);
    }

    protected final int horizPos() {
        return super.horizPos(this._pass);
    }

    protected final void indent() {
        super.indent(this._pass);
    }

    protected final void indent(int n) {
        super.indent(this._pass, n);
    }

    protected final void indentTo(int n) {
        super.indentTo(this._pass, n);
    }

    private boolean needsRangeCheck(Type type) {
        return type.kind() == 13 && ((PrimitiveNode)type)._pkind == 17;
    }

    protected final void newLine() {
        super.newLine(this._pass);
    }

    private String padCommentToLength(String string) {
        return String.valueOf(String.valueOf(new StringBuffer("{").append(this.padToLength(string)).append("}")));
    }

    private String padCommentToLength(String string, String string2) {
        int n = 77 - string.length() - string2.length() - this.getCurrentIndent(this._pass).length();
        String string3 = null;
        string3 = n < 0 ? String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.padCommentToLength(string)))).append("\n").append(this.getCurrentIndent(this._pass)).append(this.padCommentToLength("  ".concat(String.valueOf(String.valueOf(string2))))))) : this.padCommentToLength(String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(string2))));
        return string3;
    }

    private String padToLength(String string) {
        return this.padToLength(string, 77);
    }

    private String padToLength(String string, int n) {
        String string2 = null;
        if (string.length() >= n) {
            string2 = string;
        } else {
            StringBuffer stringBuffer = new StringBuffer(n);
            stringBuffer.append(string);
            int n2 = n - string.length() - this.getCurrentIndent(this._pass).length() + 1;
            if (n2 < 0) {
                n2 = 0;
            }
            for (int i = 1; i < n2; ++i) {
                stringBuffer.append(' ');
            }
            string2 = stringBuffer.toString();
        }
        return string2;
    }

    private final void pascalHelperFwdDef(ContainedNode containedNode, String string) {
        this.usePascalUnitInterfaceFwdDefBuffer(this._pass, containedNode);
        this.indent(1);
        this.println(String.valueOf(String.valueOf(string)).concat(" = class;"));
        this.indent(-1);
    }

    private final void pascalHelperFwdDef(PInterfaceNode pInterfaceNode) {
        this.usePascalUnitInterfaceFwdDefBuffer(this._pass, pInterfaceNode);
        this.indent(1);
        this.println(String.valueOf(String.valueOf(pInterfaceNode.pascalHelperName)).concat(" = class;"));
        this.indent(-1);
    }

    private final void pascalHelperImplementation(PAliasNode pAliasNode) {
        switch (pAliasNode._type.kind()) {
            case 16: {
                this.pascalHelperImplementation(pAliasNode, (PArrayNode)pAliasNode.pascalType);
                break;
            }
            case 15: {
                this.pascalHelperImplementation(pAliasNode, (PSequenceNode)pAliasNode.pascalType);
                break;
            }
            default: {
                this.pascalHelperImplementation(pAliasNode, pAliasNode.pascalType);
            }
        }
    }

    private final void pascalHelperImplementation(PAliasNode pAliasNode, PArrayNode pArrayNode) {
        this.usePascalUnitImplementationBuffer(this._pass, pAliasNode);
        this.writeIdlSectionComment(pAliasNode, "Implementation of Pascal helper class : ", pAliasNode.pascalHelperFullName, "supporting Pascal interface           : ", pAliasNode.pascalFullName);
        this.newLine();
        this.println(String.valueOf(String.valueOf(new StringBuffer("class procedure ").append(pAliasNode.pascalHelperName).append(".Insert(var _A: CORBA.Any; const _Value : ").append(pAliasNode.pascalFullName).append(");"))));
        this.println("var");
        this.indent(1);
        this.println("_Output : CORBA.OutputStream;");
        this.indent(-1);
        this.println("begin");
        this.indent(1);
        this.println("_Output := ORB.CreateOutputStream;");
        this.println(String.valueOf(String.valueOf(pAliasNode.pascalHelperName)).concat(".Write(_Output, _Value);"));
        this.println(String.valueOf(String.valueOf(new StringBuffer("ORB.PutAny(_A, ").append(pAliasNode.pascalHelperName).append(".TypeCode, _Output);"))));
        this.indent(-1);
        this.println("end;");
        this.newLine();
        this.println(String.valueOf(String.valueOf(new StringBuffer("class function  ").append(pAliasNode.pascalHelperName).append(".Extract(const _A : CORBA.Any): ").append(pAliasNode.pascalFullName).append(";"))));
        this.println("var");
        this.indent(1);
        this.println("_Input : CORBA.InputStream;");
        this.indent(-1);
        this.println("begin");
        this.indent(1);
        this.println("Orb.GetAny(_A, _Input);");
        this.println(String.valueOf(String.valueOf(new StringBuffer("Result := ").append(pAliasNode.pascalHelperName).append(".Read(_Input);"))));
        this.indent(-1);
        this.println("end;");
        this.newLine();
        this.println(String.valueOf(String.valueOf(new StringBuffer("class function  ").append(pAliasNode.pascalHelperName).append(".TypeCode: CORBA.TypeCode;"))));
        this.println("begin");
        this.indent(1);
        this.print(String.valueOf(String.valueOf(new StringBuffer("Result := ORB.CreateArrayTC(").append(pArrayNode._length).append(", "))));
        if (pArrayNode.getTkHelperFullName() != null) {
            this.add(String.valueOf(String.valueOf(pArrayNode.getTkHelperFullName())).concat(".TypeCode()"));
        } else {
            this.add(String.valueOf(String.valueOf(new StringBuffer("ORB.CreateTC(Integer(").append(pArrayNode.getTkName()).append("))"))));
        }
        this.addln(");");
        this.indent(-1);
        this.println("end;");
        this.newLine();
        this.println(String.valueOf(String.valueOf(new StringBuffer("class function  ").append(pAliasNode.pascalHelperName).append(".RepositoryId: string;"))));
        this.println("begin");
        this.indent(1);
        this.println(String.valueOf(String.valueOf(new StringBuffer("Result := '").append(pAliasNode._repId).append("';"))));
        this.indent(-1);
        this.println("end;");
        PAliasNode pAliasNode2 = pAliasNode;
        StringBuffer stringBuffer = new StringBuffer();
        int n = pAliasNode2.pascalDimensions.length;
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(String.valueOf(String.valueOf(new StringBuffer("[I").append(i).append("]"))));
        }
        String string = stringBuffer.toString();
        StringBuffer stringBuffer2 = new StringBuffer();
        int n2 = pAliasNode2.pascalDimensions.length;
        for (int i = 0; i < n2; ++i) {
            if (i > 0) {
                stringBuffer2.append(", ");
            }
            stringBuffer2.append("I".concat(String.valueOf(String.valueOf(i))));
        }
        String string2 = stringBuffer2.toString();
        this.newLine();
        this.println(String.valueOf(String.valueOf(new StringBuffer("class function  ").append(pAliasNode.pascalHelperName).append(".Read(const _Input: CORBA.InputStream) : ").append(pAliasNode.pascalFullName).append(";"))));
        this.println("var");
        this.indent(1);
        this.println(String.valueOf(String.valueOf(string2)).concat(" : Cardinal;"));
        this.indent(-1);
        this.println("begin");
        int n3 = pAliasNode2.pascalDimensions.length;
        for (n2 = 0; n2 < n3; ++n2) {
            this.indent(1);
            this.println(String.valueOf(String.valueOf(new StringBuffer("for I").append(n2).append(" := 0 to ").append(pAliasNode2.pascalDimensions[n2] - 1).append(" do"))));
            this.println("begin");
        }
        this.indent(1);
        if (pArrayNode.getHelperFullName() != null) {
            this.println(String.valueOf(String.valueOf(new StringBuffer("Result").append(string).append(" := ").append(pArrayNode.getHelperFullName()).append(".Read(_Input);"))));
        } else {
            this.println(String.valueOf(String.valueOf(new StringBuffer("_Input.Read").append(pArrayNode.getReadWritePrefix()).append("(Result").append(string).append(");"))));
        }
        this.writeReadRangeCheck(pArrayNode.pascalType, "Result".concat(String.valueOf(String.valueOf(string))), pAliasNode.pascalFullName);
        this.indent(-1);
        n3 = pAliasNode2.pascalDimensions.length;
        for (n2 = 0; n2 < n3; ++n2) {
            this.println("end;");
            this.indent(-1);
        }
        this.println("end;");
        this.newLine();
        this.println(String.valueOf(String.valueOf(new StringBuffer("class procedure ").append(pAliasNode.pascalHelperName).append(".Write(const _Output: CORBA.OutputStream; const _Value: ").append(pAliasNode.pascalFullName).append(");"))));
        this.println("var");
        this.indent(1);
        this.println(String.valueOf(String.valueOf(string2)).concat(" : Cardinal;"));
        this.indent(-1);
        this.println("begin");
        n3 = pAliasNode2.pascalDimensions.length;
        for (n2 = 0; n2 < n3; ++n2) {
            this.indent(1);
            this.println(String.valueOf(String.valueOf(new StringBuffer("for I").append(n2).append(" := 0 to ").append(pAliasNode2.pascalDimensions[n2] - 1).append(" do"))));
            this.println("begin");
        }
        this.indent(1);
        this.writeWriteRangeCheck(pArrayNode.pascalType, "_Value".concat(String.valueOf(String.valueOf(string))), pAliasNode.pascalFullName);
        if (pArrayNode.getHelperFullName() != null) {
            this.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(pArrayNode.getHelperFullName()))).append(".Write(_Output, _Value").append(string).append(");"))));
        } else {
            this.println(String.valueOf(String.valueOf(new StringBuffer("_Output.Write").append(pArrayNode.getReadWritePrefix()).append("(_Value").append(string).append(");"))));
        }
        this.indent(-1);
        n3 = pAliasNode2.pascalDimensions.length;
        for (n2 = 0; n2 < n3; ++n2) {
            this.println("end;");
            this.indent(-1);
        }
        this.println("end;");
    }

    private final void pascalHelperImplementation(PAliasNode pAliasNode, PSequenceNode pSequenceNode) {
        String string;
        StringBuffer stringBuffer;
        int n;
        this.usePascalUnitImplementationBuffer(this._pass, pAliasNode);
        this.writeIdlSectionComment(pAliasNode, "Implementation of Pascal helper class : ", pAliasNode.pascalHelperFullName, "supporting Pascal interface           : ", pAliasNode.pascalFullName);
        this.newLine();
        this.println(String.valueOf(String.valueOf(new StringBuffer("class procedure ").append(pAliasNode.pascalHelperName).append(".Insert(var _A : CORBA.Any; const _Value : ").append(pAliasNode.pascalFullName).append(");"))));
        this.println("var");
        this.indent(1);
        this.println("_Output : CORBA.OutputStream;");
        this.indent(-1);
        this.println("begin");
        this.indent(1);
        this.println("_Output := ORB.CreateOutputStream;");
        this.println(String.valueOf(String.valueOf(pAliasNode.pascalHelperName)).concat(".Write(_Output, _Value);"));
        this.println(String.valueOf(String.valueOf(new StringBuffer("ORB.PutAny(_A, ").append(pAliasNode.pascalHelperName).append(".TypeCode, _Output);"))));
        this.indent(-1);
        this.println("end;");
        this.newLine();
        this.println(String.valueOf(String.valueOf(new StringBuffer("class function ").append(pAliasNode.pascalHelperName).append(".Extract(const _A : CORBA.Any): ").append(pAliasNode.pascalFullName).append(";"))));
        this.println("var");
        this.indent(1);
        this.println("_Input : InputStream;");
        this.indent(-1);
        this.println("begin");
        this.indent(1);
        this.println("Orb.GetAny(_A, _Input);");
        this.println(String.valueOf(String.valueOf(new StringBuffer("Result := ").append(pAliasNode.pascalHelperName).append(".Read(_Input);"))));
        this.indent(-1);
        this.println("end;");
        this.newLine();
        this.println(String.valueOf(String.valueOf(new StringBuffer("class function  ").append(pAliasNode.pascalHelperName).append(".TypeCode: CORBA.TypeCode;"))));
        this.println("begin");
        this.indent(1);
        this.print(String.valueOf(String.valueOf(new StringBuffer("Result := ORB.CreateSequenceTC(").append(pSequenceNode._bound).append(", "))));
        if (pSequenceNode.getTkHelperFullName() != null) {
            this.add(String.valueOf(String.valueOf(pSequenceNode.getTkHelperFullName())).concat(".TypeCode()"));
        } else {
            this.add(String.valueOf(String.valueOf(new StringBuffer("ORB.CreateTC(Integer(").append(pSequenceNode.getTkName()).append("))"))));
        }
        this.addln(");");
        this.indent(-1);
        this.println("end;");
        this.newLine();
        this.println(String.valueOf(String.valueOf(new StringBuffer("class function  ").append(pAliasNode.pascalHelperName).append(".RepositoryId: string;"))));
        this.println("begin");
        this.indent(1);
        this.println(String.valueOf(String.valueOf(new StringBuffer("Result := '").append(pAliasNode._repId).append("';"))));
        this.indent(-1);
        this.println("end;");
        PAliasNode pAliasNode2 = pAliasNode;
        StringBuffer stringBuffer2 = new StringBuffer();
        int n2 = pAliasNode2.pascalDimensions.length;
        for (int i = 0; i < n2; ++i) {
            stringBuffer2.append(String.valueOf(String.valueOf(new StringBuffer("[I").append(i).append("]"))));
        }
        String string2 = stringBuffer2.toString();
        StringBuffer stringBuffer3 = new StringBuffer();
        StringBuffer stringBuffer4 = new StringBuffer();
        int n3 = pAliasNode2.pascalDimensions.length;
        for (int i = 0; i < n3; ++i) {
            if (i > 0) {
                stringBuffer3.append(", ");
                stringBuffer4.append(", ");
            }
            stringBuffer3.append("I".concat(String.valueOf(String.valueOf(i))));
            stringBuffer4.append("L".concat(String.valueOf(String.valueOf(i))));
        }
        String string3 = stringBuffer3.toString();
        String string4 = stringBuffer4.toString();
        this.newLine();
        this.println(String.valueOf(String.valueOf(new StringBuffer("class function  ").append(pAliasNode.pascalHelperName).append(".Read(const _Input : CORBA.InputStream) : ").append(pAliasNode.pascalFullName).append(";"))));
        this.println("var");
        this.indent(1);
        this.println(String.valueOf(String.valueOf(string4)).concat(" : Cardinal;"));
        this.println(String.valueOf(String.valueOf(string3)).concat(" : Cardinal;"));
        this.indent(-1);
        this.println("begin");
        int n4 = pAliasNode2.pascalDimensions.length;
        for (n = 0; n < n4; ++n) {
            this.indent(1);
            stringBuffer = new StringBuffer();
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(String.valueOf(String.valueOf(new StringBuffer("[I").append(i).append("]"))));
            }
            string = stringBuffer.toString();
            this.println(String.valueOf(String.valueOf(new StringBuffer("_Input.ReadULong(L").append(n).append(");"))));
            if (pAliasNode2.pascalDimensions[n] != 0) {
                this.println(String.valueOf(String.valueOf(new StringBuffer("if (L").append(n).append(" > ").append(pAliasNode2.pascalDimensions[n]).append(") then raise MARSHAL.Create(0, COMPLETED_YES);"))));
            } else {
                this.println(String.valueOf(String.valueOf(new StringBuffer("SetLength(Result").append(string).append(", L").append(n).append(");"))));
            }
            this.println(String.valueOf(String.valueOf(new StringBuffer("if (L").append(n).append(" > ").append("0) then"))));
            this.println("begin");
            this.indent(1);
            this.println(String.valueOf(String.valueOf(new StringBuffer("for I").append(n).append(" := 0 to High(Result").append(string).append(") do"))));
            this.println("begin");
        }
        this.indent(1);
        if (pSequenceNode.getHelperFullName() != null) {
            this.println(String.valueOf(String.valueOf(new StringBuffer("Result").append(string2).append(" := ").append(pSequenceNode.getHelperFullName()).append(".Read(_Input);"))));
        } else {
            this.println(String.valueOf(String.valueOf(new StringBuffer("_Input.Read").append(pSequenceNode.getReadWritePrefix()).append("(Result").append(string2).append(");"))));
        }
        this.writeReadRangeCheck(pSequenceNode.pascalType, String.valueOf(String.valueOf(new StringBuffer("Result").append(string2).append(""))), pAliasNode.pascalFullName);
        this.indent(-1);
        n4 = pAliasNode2.pascalDimensions.length;
        for (n = 0; n < n4; ++n) {
            this.println("end;");
            this.indent(-1);
            this.println("end;");
            this.indent(-1);
        }
        this.println("end;");
        this.newLine();
        this.println(String.valueOf(String.valueOf(new StringBuffer("class procedure ").append(pAliasNode.pascalHelperName).append(".Write(const _Output: CORBA.OutputStream; const _Value: ").append(pAliasNode.pascalFullName).append(");"))));
        this.println("var");
        this.indent(1);
        this.println(String.valueOf(String.valueOf(string4)).concat(" : Cardinal;"));
        this.println(String.valueOf(String.valueOf(string3)).concat(" : Cardinal;"));
        this.indent(-1);
        this.println("begin");
        n4 = pAliasNode2.pascalDimensions.length;
        for (n = 0; n < n4; ++n) {
            this.indent(1);
            stringBuffer = new StringBuffer();
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(String.valueOf(String.valueOf(new StringBuffer("[I").append(i).append("]"))));
            }
            string = stringBuffer.toString();
            this.println(String.valueOf(String.valueOf(new StringBuffer("L").append(n).append(" := Length(_Value").append(string).append(");"))));
            if (pAliasNode2.pascalDimensions[n] != 0) {
                this.println(String.valueOf(String.valueOf(new StringBuffer("if (L").append(n).append(" > ").append(pAliasNode2.pascalDimensions[n]).append(") then raise MARSHAL.Create(0, COMPLETED_NO);"))));
            }
            this.println(String.valueOf(String.valueOf(new StringBuffer("_Output.WriteULong(L").append(n).append(");"))));
            this.println(String.valueOf(String.valueOf(new StringBuffer("if (L").append(n).append(" > ").append("0) then"))));
            this.println("begin");
            this.indent(1);
            this.println(String.valueOf(String.valueOf(new StringBuffer("for I").append(n).append(" := 0 to High(_Value").append(string).append(") do"))));
            this.println("begin");
        }
        this.indent(1);
        this.writeWriteRangeCheck(pSequenceNode.pascalType, "_Value".concat(String.valueOf(String.valueOf(string2))), pAliasNode.pascalFullName);
        if (pSequenceNode.getHelperFullName() != null) {
            this.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(pSequenceNode.getHelperFullName()))).append(".Write(_Output, _Value").append(string2).append(");"))));
        } else {
            this.println(String.valueOf(String.valueOf(new StringBuffer("_Output.Write").append(pSequenceNode.getReadWritePrefix()).append("(_Value").append(string2).append(");"))));
        }
        this.indent(-1);
        n4 = pAliasNode2.pascalDimensions.length;
        for (n = 0; n < n4; ++n) {
            this.println("end;");
            this.indent(-1);
            this.println("end;");
            this.indent(-1);
        }
        this.println("end;");
    }

    private void pascalHelperImplementation(PAliasNode pAliasNode, PType pType) {
        this.usePascalUnitImplementationBuffer(this._pass, pAliasNode);
        this.writeIdlSectionComment(pAliasNode, "Implementation of Pascal helper class : ", pAliasNode.pascalHelperFullName, "supporting Pascal interface           : ", pAliasNode.pascalFullName);
        this.newLine();
        this.println(String.valueOf(String.valueOf(new StringBuffer("class procedure ").append(pAliasNode.pascalHelperName).append(".Insert(var _A : CORBA.Any; const _Value : ").append(pAliasNode.pascalFullName).append(");"))));
        this.println("begin");
        this.indent(1);
        this.println("_A := _Value;");
        this.indent(-1);
        this.println("end;");
        this.newLine();
        this.println(String.valueOf(String.valueOf(new StringBuffer("class function ").append(pAliasNode.pascalHelperName).append(".Extract(const _A : CORBA.Any) : ").append(pAliasNode.pascalFullName).append(";"))));
        if (pType.kind() == 13) {
            if (((PPrimitiveNode)pType)._pkind == 9) {
                this.println("var");
                this.indent(1);
                this.println("_s : String;");
                this.indent(-1);
                this.println("begin");
                this.indent(1);
                this.println("_s := _A;");
                this.println(String.valueOf(String.valueOf(new StringBuffer("Result := ").append(pAliasNode.pascalFullName).append("(_s[1]);"))));
                this.indent(-1);
                this.println("end;");
            } else {
                this.println("var");
                this.indent(1);
                this.println("_Input : InputStream;");
                this.println(String.valueOf(String.valueOf(new StringBuffer("_Temp  : ").append(pType.getTypeFullName()).append(";"))));
                this.indent(-1);
                this.println("begin");
                this.indent(1);
                this.println("Orb.GetAny(_A, _Input);");
                this.println(String.valueOf(String.valueOf(new StringBuffer("_Input.Read").append(pType.getReadWritePrefix()).append("(_Temp);"))));
                this.println(String.valueOf(String.valueOf(new StringBuffer("Result := ").append(pAliasNode.pascalFullName).append("(_Temp);"))));
                this.indent(-1);
                this.println("end;");
            }
        } else {
            this.println("begin");
            this.indent(1);
            this.println(String.valueOf(String.valueOf(new StringBuffer("Result := ").append(pType.getHelperFullName()).append(".Extract(_A);"))));
            this.indent(-1);
            this.println("end;");
        }
        this.newLine();
        this.println(String.valueOf(String.valueOf(new StringBuffer("class function  ").append(pAliasNode.pascalHelperName).append(".TypeCode : CORBA.TypeCode;"))));
        this.println("begin");
        this.indent(1);
        this.println(String.valueOf(String.valueOf(new StringBuffer("Result := ORB.CreateAliasTC(RepositoryId, '").append(pAliasNode.pascalName).append("', ORB.CreateTC(Integer(0)));"))));
        this.indent(-1);
        this.println("end;");
        this.newLine();
        this.println(String.valueOf(String.valueOf(new StringBuffer("class function  ").append(pAliasNode.pascalHelperName).append(".RepositoryId : string;"))));
        this.println("begin");
        this.indent(1);
        this.println(String.valueOf(String.valueOf(new StringBuffer("Result := '").append(pAliasNode._repId).append("';"))));
        this.indent(-1);
        this.println("end;");
        this.newLine();
        this.println(String.valueOf(String.valueOf(new StringBuffer("class function  ").append(pAliasNode.pascalHelperName).append(".Read(const _Input: CORBA.InputStream) : ").append(pAliasNode.pascalFullName).append(";"))));
        this.println("begin");
        this.indent(1);
        if (pType.getHelperFullName() != null) {
            this.println(String.valueOf(String.valueOf(new StringBuffer("Result := ").append(pType.getHelperFullName()).append(".Read(_Input);"))));
        } else {
            this.println(String.valueOf(String.valueOf(new StringBuffer("_Input.Read").append(pType.getReadWritePrefix()).append("(Result);"))));
        }
        this.writeReadRangeCheck(pType, "Result", pAliasNode.pascalFullName);
        this.indent(-1);
        this.println("end;");
        this.newLine();
        this.println(String.valueOf(String.valueOf(new StringBuffer("class procedure ").append(pAliasNode.pascalHelperName).append(".Write(const _Output : CORBA.OutputStream; const _Value :").append(pAliasNode.pascalFullName).append(");"))));
        this.println("begin");
        this.indent(1);
        this.writeWriteRangeCheck(pType, "_Value", pAliasNode.pascalFullName);
        if (pType.getHelperFullName() != null) {
            this.println(String.valueOf(String.valueOf(pType.getHelperFullName())).concat(".Write(_Output, _Value);"));
        } else {
            this.println(String.valueOf(String.valueOf(new StringBuffer("_Output.Write").append(pType.getReadWritePrefix()).append("(_Value);"))));
        }
        this.indent(-1);
        this.println("end;");
    }

    private final void pascalHelperImplementation(PEnumNode pEnumNode) {
        this.usePascalUnitImplementationBuffer(this._pass, pEnumNode);
        this.writeIdlSectionComment(pEnumNode, "Implementation of Pascal helper class : ", pEnumNode.pascalHelperFullName, "supporting Pascal interface           : ", pEnumNode.pascalFullName);
        this.newLine();
        this.println(String.valueOf(String.valueOf(new StringBuffer("class procedure ").append(pEnumNode.pascalHelperName).append(".Insert(var _A : CORBA.Any; const _Value : ").append(pEnumNode.pascalFullName).append(");"))));
        this.println("begin");
        this.indent(1);
        this.println("_A := _Value;");
        this.indent(-1);
        this.println("end;");
        this.newLine();
        this.println(String.valueOf(String.valueOf(new StringBuffer("class function ").append(pEnumNode.pascalHelperName).append(".Extract(const _A : CORBA.Any) : ").append(pEnumNode.pascalFullName).append(";"))));
        this.println("begin");
        this.indent(1);
        this.println(String.valueOf(String.valueOf(new StringBuffer("Result := ").append(pEnumNode.pascalFullName).append("(_A);"))));
        this.indent(-1);
        this.println("end;");
        this.newLine();
        this.println(String.valueOf(String.valueOf(new StringBuffer("class function ").append(pEnumNode.pascalHelperName).append(".TypeCode : CORBA.TypeCode;"))));
        this.println("begin");
        this.indent(1);
        this.print(String.valueOf(String.valueOf(new StringBuffer("Result := ORB.CreateEnumTC(RepositoryId, '").append(pEnumNode.pascalName).append("', ["))));
        int n = pEnumNode._memberNames.size();
        for (int i = 0; i < n; ++i) {
            this.add(String.valueOf(String.valueOf(new StringBuffer("'").append(pEnumNode._memberNames.elementAt(i).toString()).append("'"))));
            if (i >= n - 1) continue;
            this.add(", ");
        }
        this.addln("]);");
        this.indent(-1);
        this.println("end;");
        this.newLine();
        this.println(String.valueOf(String.valueOf(new StringBuffer("class function ").append(pEnumNode.pascalHelperName).append(".RepositoryId: string;"))));
        this.println("begin");
        this.indent(1);
        this.println(String.valueOf(String.valueOf(new StringBuffer("Result := '").append(pEnumNode._repId).append("';"))));
        this.indent(-1);
        this.println("end;");
        this.newLine();
        this.println(String.valueOf(String.valueOf(new StringBuffer("class function ").append(pEnumNode.pascalHelperName).append(".Read(const _Input : CORBA.InputStream) : ").append(pEnumNode.pascalFullName).append(";"))));
        this.println("var");
        this.indent(1);
        this.println("_Temp: Cardinal;");
        this.indent(-1);
        this.println("begin");
        this.indent(1);
        this.println("_Input.ReadULong(_Temp);");
        this.println(String.valueOf(String.valueOf(new StringBuffer("Result := ").append(pEnumNode.pascalFullName).append("(_Temp);"))));
        this.indent(-1);
        this.println("end;");
        this.newLine();
        this.println(String.valueOf(String.valueOf(new StringBuffer("class procedure ").append(pEnumNode.pascalHelperName).append(".Write(const _Output : CORBA.OutputStream; const _Value  : ").append(pEnumNode.pascalFullName).append(");"))));
        this.println("begin");
        this.indent(1);
        this.println("_Output.WriteULong(Cardinal(_Value));");
        this.indent(-1);
        this.println("end;");
    }

    private final void pascalHelperImplementation(PInterfaceNode pInterfaceNode) {
        this.usePascalUnitImplementationBuffer(this._pass, pInterfaceNode);
        this.writeIdlSectionComment(pInterfaceNode, "Implementation of Pascal helper class : ", pInterfaceNode.pascalHelperFullName, "supporting Pascal interface           : ", pInterfaceNode.pascalFullName, "", "");
        this.newLine();
        this.println(String.valueOf(String.valueOf(new StringBuffer("class procedure ").append(pInterfaceNode.pascalHelperName).append(".Insert(var _A : CORBA.Any; const _Value : ").append(pInterfaceNode.pascalFullName).append(");"))));
        this.println("begin");
        this.indent(1);
        this.println(String.valueOf(String.valueOf(new StringBuffer("_A := Orb.MakeObjectRef( ").append(pInterfaceNode.pascalHelperName).append(".TypeCode, _Value as CORBA.CORBAObject);"))));
        this.indent(-1);
        this.println("end;");
        this.newLine();
        this.println(String.valueOf(String.valueOf(new StringBuffer("class function ").append(pInterfaceNode.pascalHelperName).append(".Extract(var _A : CORBA.Any): ").append(pInterfaceNode.pascalFullName).append(";"))));
        this.println("var");
        this.indent(1);
        this.println("_obj : CORBA.CorbaObject;");
        this.indent(-1);
        this.println("begin");
        this.indent(1);
        this.println("_obj := Orb.GetObjectRef(_A);");
        this.println(String.valueOf(String.valueOf(new StringBuffer("Result := ").append(pInterfaceNode.pascalHelperName).append(".Narrow(_obj, True);"))));
        this.indent(-1);
        this.println("end;");
        this.newLine();
        this.println(String.valueOf(String.valueOf(new StringBuffer("class function ").append(pInterfaceNode.pascalHelperName).append(".TypeCode : CORBA.TypeCode;"))));
        this.println("begin");
        this.indent(1);
        this.println(String.valueOf(String.valueOf(new StringBuffer("Result := ORB.CreateInterfaceTC(RepositoryId, '").append(pInterfaceNode.pascalName).append("');"))));
        this.indent(-1);
        this.println("end;");
        this.newLine();
        this.println(String.valueOf(String.valueOf(new StringBuffer("class function ").append(pInterfaceNode.pascalHelperName).append(".RepositoryId : string;"))));
        this.println("begin");
        this.indent(1);
        this.println(String.valueOf(String.valueOf(new StringBuffer("Result := '").append(pInterfaceNode._repId).append("';"))));
        this.indent(-1);
        this.println("end;");
        this.newLine();
        this.println(String.valueOf(String.valueOf(new StringBuffer("class function ").append(pInterfaceNode.pascalHelperName).append(".Read(const _Input : CORBA.InputStream) : ").append(pInterfaceNode.pascalFullName).append(";"))));
        this.println("var");
        this.indent(1);
        this.println("_Obj : CORBA.CORBAObject;");
        this.indent(-1);
        this.println("begin");
        this.indent(1);
        this.println("_Input.ReadObject(_Obj);");
        this.println("Result := Narrow(_Obj, True)");
        this.indent(-1);
        this.println("end;");
        this.newLine();
        this.println(String.valueOf(String.valueOf(new StringBuffer("class procedure ").append(pInterfaceNode.pascalHelperName).append(".Write(const _Output : CORBA.OutputStream; const _Value : ").append(pInterfaceNode.pascalFullName).append(");"))));
        this.println("begin");
        this.indent(1);
        this.println("_Output.WriteObject(_Value as CORBA.CORBAObject);");
        this.indent(-1);
        this.println("end;");
        this.newLine();
        this.println(String.valueOf(String.valueOf(new StringBuffer("class function ").append(pInterfaceNode.pascalHelperName).append(".Narrow(const _Obj : CORBA.CORBAObject; _IsA : Boolean) : ").append(pInterfaceNode.pascalFullName).append(";"))));
        this.println("begin");
        this.indent(1);
        this.println("Result := nil;");
        this.println(String.valueOf(String.valueOf(new StringBuffer("if (_Obj = nil) or (_Obj.QueryInterface(").append(pInterfaceNode.pascalFullName).append(", Result) = 0) then"))));
        this.indent(1);
        this.println("exit;");
        this.indent(-1);
        this.println("if _IsA and _Obj._IsA(RepositoryId) then");
        this.indent(1);
        this.println(String.valueOf(String.valueOf(new StringBuffer("Result := ").append(pInterfaceNode.pascalStubName).append(".Create(_Obj);"))));
        this.indent(-2);
        this.println("end;");
        this.newLine();
        this.println(String.valueOf(String.valueOf(new StringBuffer("class function ").append(pInterfaceNode.pascalHelperName).append(".Bind(const _InstanceName : string = ''; _HostName: string = '') : ").append(pInterfaceNode.pascalFullName).append(";"))));
        this.println("begin");
        this.indent(1);
        this.println("Result := Narrow(ORB.bind(RepositoryId, _InstanceName, _HostName), True);");
        this.indent(-1);
        this.println("end;");
        this.newLine();
        this.println(String.valueOf(String.valueOf(new StringBuffer("class function ").append(pInterfaceNode.pascalHelperName).append(".Bind(_Options : BindOptions; const _InstanceName : string = ''; _HostName : string = '') : ").append(pInterfaceNode.pascalFullName).append(";"))));
        this.println("begin");
        this.indent(1);
        this.println("Result := Narrow(ORB.bind(RepositoryId, _Options, _InstanceName, _HostName), True);");
        this.indent(-1);
        this.println("end;");
    }

    private final void pascalHelperImplementation(PStructNode pStructNode) {
        int n;
        this.usePascalUnitImplementationBuffer(this._pass, pStructNode);
        this.writeIdlSectionComment(pStructNode, "Implementation of Pascal helper class : ", pStructNode.pascalHelperFullName, "supporting Pascal interface           : ", pStructNode.pascalFullName);
        this.newLine();
        this.println(String.valueOf(String.valueOf(new StringBuffer("class procedure ").append(pStructNode.pascalHelperName).append(".Insert(var _A : CORBA.Any; const _Value : ").append(pStructNode.pascalFullName).append(");"))));
        this.println("var");
        this.indent(1);
        this.println("_Output : CORBA.OutputStream;");
        this.indent(-1);
        this.println("begin");
        this.indent(1);
        this.println("_Output := ORB.CreateOutputStream;");
        this.println(String.valueOf(String.valueOf(pStructNode.pascalHelperName)).concat(".Write(_Output, _Value);"));
        this.println(String.valueOf(String.valueOf(new StringBuffer("ORB.PutAny(_A, ").append(pStructNode.pascalHelperName).append(".TypeCode, _Output);"))));
        this.indent(-1);
        this.println("end;");
        this.newLine();
        this.println(String.valueOf(String.valueOf(new StringBuffer("class function ").append(pStructNode.pascalHelperName).append(".Extract(const _A : CORBA.Any) : ").append(pStructNode.pascalFullName).append(";"))));
        this.println("var");
        this.indent(1);
        this.println("_Input : CORBA.InputStream;");
        this.indent(-1);
        this.println("begin");
        this.indent(1);
        this.println("Orb.GetAny(_A, _Input);");
        this.println(String.valueOf(String.valueOf(new StringBuffer("Result := ").append(pStructNode.pascalHelperName).append(".Read(_Input);"))));
        this.indent(-1);
        this.println("end;");
        this.newLine();
        this.println(String.valueOf(String.valueOf(new StringBuffer("class function ").append(pStructNode.pascalHelperName).append(".TypeCode : CORBA.TypeCode;"))));
        this.println("var");
        this.indent(1);
        this.println("_Seq: StructMemberSeq;");
        this.indent(-1);
        this.println("begin");
        this.indent(1);
        this.println(String.valueOf(String.valueOf(new StringBuffer("SetLength(_Seq, ").append(pStructNode.pascalMemberNames.length).append(");"))));
        int n2 = pStructNode.pascalMemberNames.length;
        for (n = 0; n < n2; ++n) {
            this.println(String.valueOf(String.valueOf(new StringBuffer("_Seq[").append(n).append("].Name := '").append(pStructNode.pascalMemberNames[n]).append("';"))));
            this.print(String.valueOf(String.valueOf(new StringBuffer("_Seq[").append(n).append("].TC   := "))));
            if (pStructNode.pascalMemberTkHelperFullNames[n] != null) {
                this.add(String.valueOf(String.valueOf(pStructNode.pascalMemberTkHelperFullNames[n])).concat(".TypeCode"));
            } else {
                this.add(String.valueOf(String.valueOf(new StringBuffer("ORB.CreateTC(Integer(").append(pStructNode.pascalMemberTkNames[n]).append("))"))));
            }
            this.addln(";");
        }
        this.println(String.valueOf(String.valueOf(new StringBuffer("Result := ORB.MakeStructureTypecode(RepositoryID, '").append(pStructNode.pascalName).append("', _Seq);"))));
        this.indent(-1);
        this.println("end;");
        this.newLine();
        this.println(String.valueOf(String.valueOf(new StringBuffer("class function ").append(pStructNode.pascalHelperName).append(".RepositoryId : string;"))));
        this.println("begin");
        this.indent(1);
        this.println(String.valueOf(String.valueOf(new StringBuffer("Result := '").append(pStructNode._repId).append("';"))));
        this.indent(-1);
        this.println("end;");
        this.newLine();
        this.println(String.valueOf(String.valueOf(new StringBuffer("class function ").append(pStructNode.pascalHelperName).append(".Read(const _Input : CORBA.InputStream) : ").append(pStructNode.pascalFullName).append(";"))));
        this.println("var");
        this.indent(1);
        this.println(String.valueOf(String.valueOf(new StringBuffer("_Value : ").append(pStructNode.pascalStubFullName).append(";"))));
        this.indent(-1);
        this.println("begin");
        this.indent(1);
        this.println(String.valueOf(String.valueOf(new StringBuffer("_Value := ").append(pStructNode.pascalStubFullName).append(".Create;"))));
        n2 = pStructNode.pascalMemberNames.length;
        for (n = 0; n < n2; ++n) {
            if (pStructNode.pascalMemberHelperFullNames[n] != null) {
                this.println(String.valueOf(String.valueOf(new StringBuffer("_Value.").append(pStructNode.pascalMemberNames[n]).append(" := ").append(pStructNode.pascalMemberHelperFullNames[n]).append(".Read(_Input);"))));
            } else {
                this.println(String.valueOf(String.valueOf(new StringBuffer("_Input.Read").append(pStructNode.pascalMemberReadWritePrefixes[n]).append("(_Value.").append(pStructNode.pascalMemberNames[n]).append(");"))));
            }
            this.writeReadRangeCheck(pStructNode.pascalMemberTypes[n], "_Value.".concat(String.valueOf(String.valueOf(pStructNode.pascalMemberNames[n]))), pStructNode.pascalFullName);
        }
        this.println("Result := _Value;");
        this.indent(-1);
        this.println("end;");
        this.newLine();
        this.println(String.valueOf(String.valueOf(new StringBuffer("class procedure ").append(pStructNode.pascalHelperName).append(".Write(const _Output : CORBA.OutputStream; const _Value : ").append(pStructNode.pascalFullName).append(");"))));
        this.println("begin");
        this.indent(1);
        n2 = pStructNode.pascalMemberNames.length;
        for (n = 0; n < n2; ++n) {
            this.writeWriteRangeCheck(pStructNode.pascalMemberTypes[n], "_Value.".concat(String.valueOf(String.valueOf(pStructNode.pascalMemberNames[n]))), pStructNode.pascalFullName);
            if (pStructNode.pascalMemberHelperFullNames[n] != null) {
                this.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(pStructNode.pascalMemberHelperFullNames[n]))).append(".Write(_Output, _Value.").append(pStructNode.pascalMemberNames[n]).append(");"))));
                continue;
            }
            this.println(String.valueOf(String.valueOf(new StringBuffer("_Output.Write").append(pStructNode.pascalMemberReadWritePrefixes[n]).append("(_Value.").append(pStructNode.pascalMemberNames[n]).append(");"))));
        }
        this.indent(-1);
        this.println("end;");
    }

    private final void pascalHelperImplementation(PUnionNode pUnionNode) {
        int n;
        int n2;
        int n3;
        this.usePascalUnitImplementationBuffer(this._pass, pUnionNode);
        this.writeIdlSectionComment(pUnionNode, "Implementation of Pascal helper class : ", pUnionNode.pascalHelperFullName, "supporting Pascal interface           : ", pUnionNode.pascalFullName);
        this.newLine();
        this.println(String.valueOf(String.valueOf(new StringBuffer("class procedure ").append(pUnionNode.pascalHelperName).append(".Insert(var _A : CORBA.Any; const _Value : ").append(pUnionNode.pascalFullName).append(");"))));
        this.println("var");
        this.indent(1);
        this.println("_Output : CORBA.OutputStream;");
        this.indent(-1);
        this.println("begin");
        this.indent(1);
        this.println("_Output := ORB.CreateOutputStream;");
        this.println(String.valueOf(String.valueOf(pUnionNode.pascalHelperName)).concat(".Write(_Output, _Value);"));
        this.println(String.valueOf(String.valueOf(new StringBuffer("ORB.PutAny(_A, ").append(pUnionNode.pascalHelperName).append(".TypeCode, _Output);"))));
        this.indent(-1);
        this.println("end;");
        this.newLine();
        this.println(String.valueOf(String.valueOf(new StringBuffer("class function ").append(pUnionNode.pascalHelperName).append(".Extract(const _A : CORBA.Any) : ").append(pUnionNode.pascalFullName).append(";"))));
        this.println("var");
        this.indent(1);
        this.println("_Input : CORBA.InputStream;");
        this.indent(-1);
        this.println("begin");
        this.indent(1);
        this.println("Orb.GetAny(_A, _Input);");
        this.println(String.valueOf(String.valueOf(new StringBuffer("Result := ").append(pUnionNode.pascalHelperName).append(".Read(_Input);"))));
        this.indent(-1);
        this.println("end;");
        this.newLine();
        this.println(String.valueOf(String.valueOf(new StringBuffer("class function ").append(pUnionNode.pascalHelperName).append(".TypeCode : CORBA.TypeCode;"))));
        this.println("var");
        this.indent(1);
        this.println("Seq: UnionMemberSeq;");
        this.indent(-1);
        this.println("begin");
        this.indent(1);
        this.println(String.valueOf(String.valueOf(new StringBuffer("SetLength(Seq, ").append(pUnionNode.pascalNumMembers).append(");"))));
        int n4 = 0;
        int n5 = pUnionNode.pascalMemberNames.length;
        for (n3 = 0; n3 < n5; ++n3) {
            n2 = pUnionNode.pascalMemberLabels[n3] != null ? pUnionNode.pascalMemberLabels[n3].length : -1;
            for (n = 0; n < n2; ++n) {
                this.writeTypecodeSequenceElement(pUnionNode, n3, n, n4++);
            }
        }
        if (pUnionNode.pascalDefaultExists) {
            this.writeTypecodeSequenceDefaultElement(pUnionNode, n4++);
        }
        this.print(String.valueOf(String.valueOf(new StringBuffer("Result := ORB.CreateUnionTC(RepositoryID, '").append(pUnionNode.pascalName).append("', "))));
        if (pUnionNode.pascalDiscHelperName != null) {
            this.add(String.valueOf(String.valueOf(pUnionNode.pascalDiscHelperName)).concat(".TypeCode"));
        } else {
            this.add(String.valueOf(String.valueOf(new StringBuffer("ORB.CreateTC(Integer(").append(pUnionNode.pascalDiscTkName).append("))"))));
        }
        this.addln(", Seq);");
        this.indent(-1);
        this.println("end;");
        this.newLine();
        this.println(String.valueOf(String.valueOf(new StringBuffer("class function ").append(pUnionNode.pascalHelperName).append(".RepositoryId: string;"))));
        this.println("begin");
        this.indent(1);
        this.println(String.valueOf(String.valueOf(new StringBuffer("Result := '").append(pUnionNode._repId).append("';"))));
        this.indent(-1);
        this.println("end;");
        this.newLine();
        this.println(String.valueOf(String.valueOf(new StringBuffer("class function ").append(pUnionNode.pascalHelperName).append(".Read(const _Input: CORBA.InputStream): ").append(pUnionNode.pascalFullName).append(";"))));
        this.println("var");
        this.indent(1);
        this.println(String.valueOf(String.valueOf(new StringBuffer("_Value : ").append(pUnionNode.pascalStubFullName).append(";"))));
        if (pUnionNode.pascalDiscIsEnum) {
            this.println("_Temp  : Integer;");
        }
        this.indent(-1);
        this.println("begin");
        this.indent(1);
        this.println(String.valueOf(String.valueOf(new StringBuffer("_Value := ").append(pUnionNode.pascalStubName).append(".Create;"))));
        if (pUnionNode.pascalDiscIsEnum) {
            this.println("_Input.ReadLong(_Temp);");
            this.println(String.valueOf(String.valueOf(new StringBuffer("_Value._discriminator := ").append(pUnionNode.pascalDiscTypeName).append("(_Temp);"))));
        } else {
            this.println(String.valueOf(String.valueOf(new StringBuffer("_Input.Read").append(pUnionNode.pascalDiscReadWritePrefix).append("(_Value._discriminator);"))));
        }
        this.writeReadRangeCheck(pUnionNode._discriminator, "_Value._discriminator", pUnionNode.pascalFullName);
        this.println("case _Value._discriminator of");
        this.indent(1);
        n5 = pUnionNode.pascalMemberNames.length;
        for (n3 = 0; n3 < n5; ++n3) {
            n2 = pUnionNode.pascalMemberLabels[n3] != null ? pUnionNode.pascalMemberLabels[n3].length : -1;
            for (n = 0; n < n2; ++n) {
                this.writeReadElement(pUnionNode, n3, n);
            }
        }
        if (pUnionNode.pascalDefaultExists) {
            this.writeReadElement(pUnionNode);
        }
        this.indent(-1);
        this.println("end;");
        this.println("Result := _Value;");
        this.indent(-1);
        this.println("end;");
        this.newLine();
        this.println(String.valueOf(String.valueOf(new StringBuffer("class procedure ").append(pUnionNode.pascalHelperName).append(".Write(const _Output : CORBA.OutputStream; const _Value : ").append(pUnionNode.pascalFullName).append(");"))));
        if (pUnionNode.pascalDiscIsEnum) {
            this.println("var");
            this.indent(1);
            this.println("temp  : Integer;");
            this.indent(-1);
        }
        this.println("begin");
        this.indent(1);
        this.writeWriteRangeCheck(pUnionNode._discriminator, "_Value._discriminator", pUnionNode.pascalFullName);
        if (pUnionNode.pascalDiscIsEnum) {
            this.println("temp := Integer(_Value._discriminator);");
            this.println("_Output.WriteLong(temp);");
        } else {
            this.println(String.valueOf(String.valueOf(new StringBuffer("_Output.Write").append(pUnionNode.pascalDiscReadWritePrefix).append("(_Value._discriminator);"))));
        }
        this.println("case _Value._discriminator of");
        this.indent(1);
        n5 = pUnionNode.pascalMemberNames.length;
        for (n3 = 0; n3 < n5; ++n3) {
            n2 = pUnionNode.pascalMemberLabels[n3] != null ? pUnionNode.pascalMemberLabels[n3].length : -1;
            for (n = 0; n < n2; ++n) {
                this.writeWriteElement(pUnionNode, n3, n);
            }
        }
        if (pUnionNode.pascalDefaultExists) {
            this.writeWriteElement(pUnionNode);
        }
        this.indent(-1);
        this.println("end;");
        this.indent(-1);
        this.println("end;");
    }

    private final void pascalHelperInitialization(PInterfaceNode pInterfaceNode) {
        this.usePascalUnitInitialisationManagerBuffer(this._pass, pInterfaceNode);
        this.writeIdlSectionComment(pInterfaceNode, "Initialization of the Pascal helper class : ", pInterfaceNode.pascalStubFullName);
    }

    private final void pascalHelperSignature(ContainedNode containedNode, String string, String string2, String string3) {
        this.pascalHelperFwdDef(containedNode, string2);
        this.usePascalUnitInterfaceDescriptionBuffer(this._pass, containedNode);
        this.indent(1);
        this.writeIdlSectionComment(containedNode, string);
        this.newLine();
        this.println(String.valueOf(String.valueOf(string2)).concat(" = class"));
        this.indent(1);
        this.println(String.valueOf(String.valueOf(new StringBuffer("class procedure Insert (var   _A: CORBA.Any; const _Value : ").append(string3).append(");"))));
        this.println(String.valueOf(String.valueOf(new StringBuffer("class function  Extract(const _A: CORBA.Any): ").append(string3).append(";"))));
        this.println("class function  TypeCode    : CORBA.TypeCode;");
        this.println("class function  RepositoryId: string;");
        this.println(String.valueOf(String.valueOf(new StringBuffer("class function  Read (const _Input  : CORBA.InputStream) : ").append(string3).append(";"))));
        this.println(String.valueOf(String.valueOf(new StringBuffer("class procedure Write(const _Output : CORBA.OutputStream; const _Value : ").append(string3).append(");"))));
        this.indent(-1);
        this.println("end;");
        this.indent(-1);
    }

    private final void pascalHelperSignature(PAliasNode pAliasNode) {
        this.pascalHelperSignature(pAliasNode, String.valueOf(String.valueOf(new StringBuffer("Signature of Pascal helper class \"").append(pAliasNode.pascalHelperFullName).append("\"supporting Pascal interface \"").append(pAliasNode.pascalFullName).append("\"."))), pAliasNode.pascalHelperName, pAliasNode.pascalFullName);
    }

    private final void pascalHelperSignature(PEnumNode pEnumNode) {
        this.pascalHelperSignature(pEnumNode, String.valueOf(String.valueOf(new StringBuffer("Signature of Pascal helper class \"").append(pEnumNode.pascalHelperFullName).append("\"supporting Pascal interface \"").append(pEnumNode.pascalFullName).append("\"."))), pEnumNode.pascalHelperName, pEnumNode.pascalFullName);
    }

    private final void pascalHelperSignature(PInterfaceNode pInterfaceNode) {
        this.pascalHelperFwdDef(pInterfaceNode);
        this.usePascalUnitInterfaceDescriptionBuffer(this._pass, pInterfaceNode);
        this.indent(1);
        this.writeIdlSectionComment(pInterfaceNode, "Signature of Pascal helper class : ", pInterfaceNode.pascalHelperFullName, "supporting Pascal interface      : ", pInterfaceNode.pascalFullName);
        this.newLine();
        this.println(String.valueOf(String.valueOf(pInterfaceNode.pascalHelperName)).concat(" = class"));
        this.indent(1);
        this.println(String.valueOf(String.valueOf(new StringBuffer("class procedure Insert (var _A: CORBA.Any; const _Value : ").append(pInterfaceNode.pascalFullName).append(");"))));
        this.println(String.valueOf(String.valueOf(new StringBuffer("class function  Extract(var _A: CORBA.Any) : ").append(pInterfaceNode.pascalFullName).append(";"))));
        this.println("class function  TypeCode     : CORBA.TypeCode;");
        this.println("class function  RepositoryId : string;");
        this.println(String.valueOf(String.valueOf(new StringBuffer("class function  Read (const _Input  : CORBA.InputStream) : ").append(pInterfaceNode.pascalFullName).append(";"))));
        this.println(String.valueOf(String.valueOf(new StringBuffer("class procedure Write(const _Output : CORBA.OutputStream; const _Value : ").append(pInterfaceNode.pascalFullName).append(");"))));
        this.println(String.valueOf(String.valueOf(new StringBuffer("class function  Narrow(const _Obj   : CORBA.CORBAObject; _IsA : Boolean = False) : ").append(pInterfaceNode.pascalFullName).append(";"))));
        this.println(String.valueOf(String.valueOf(new StringBuffer("class function  Bind(const _InstanceName : string = ''; _HostName : string = '') : ").append(pInterfaceNode.pascalFullName).append("; overload;"))));
        this.println(String.valueOf(String.valueOf(new StringBuffer("class function  Bind(_Options : BindOptions; const _InstanceName : string = ''; _HostName: string = '') : ").append(pInterfaceNode.pascalFullName).append("; overload;"))));
        this.indent(-1);
        this.println("end;");
        this.indent(-1);
    }

    private final void pascalHelperSignature(PStructNode pStructNode) {
        this.pascalHelperSignature(pStructNode, String.valueOf(String.valueOf(new StringBuffer("Signature of Pascal helper class \"").append(pStructNode.pascalHelperFullName).append("\"supporting Pascal interface \"").append(pStructNode.pascalFullName).append("\"."))), pStructNode.pascalHelperName, pStructNode.pascalFullName);
    }

    private final void pascalHelperSignature(PUnionNode pUnionNode) {
        this.pascalHelperSignature(pUnionNode, String.valueOf(String.valueOf(new StringBuffer("Signature of Pascal helper class \"").append(pUnionNode.pascalHelperFullName).append("\"supporting Pascal interface \"").append(pUnionNode.pascalFullName).append("\"."))), pUnionNode.pascalHelperName, pUnionNode.pascalFullName);
    }

    private final void pascalIfaceFwdDef(PInterfaceNode pInterfaceNode) {
        this.usePascalUnitInterfaceFwdDefBuffer(this._pass, pInterfaceNode);
        this.indent(1);
        this.println(String.valueOf(String.valueOf(pInterfaceNode.pascalName)).concat(" = interface;"));
        this.indent(-1);
    }

    private final void pascalIfaceFwdDef(PStructNode pStructNode) {
        this.usePascalUnitInterfaceFwdDefBuffer(this._pass, pStructNode);
        this.indent(1);
        this.println(String.valueOf(String.valueOf(pStructNode.pascalName)).concat(" = interface;"));
        this.indent(-1);
    }

    private final void pascalIfaceFwdDef(PUnionNode pUnionNode) {
        this.usePascalUnitInterfaceFwdDefBuffer(this._pass, pUnionNode);
        this.indent(1);
        this.println(String.valueOf(String.valueOf(pUnionNode.pascalName)).concat(" = interface;"));
        this.indent(-1);
    }

    private final void pascalIfaceSignature(PAliasNode pAliasNode) {
        this.usePascalUnitTypedefBuffer(this._pass, pAliasNode);
        this.indent(1);
        switch (pAliasNode._type.kind()) {
            case 16: {
                this.newLine();
                this.writeIdlSectionComment(pAliasNode, "Pascal array           : ", pAliasNode.pascalFullName, "derived from IDL array : ", pAliasNode._name);
                if (pAliasNode.isAnonymous) {
                    this.writeIdlSectionComment(pAliasNode, "(This is a generated alias for an anonymous array.)");
                }
                PArrayNode pArrayNode = (PArrayNode)pAliasNode.pascalType;
                this.print(String.valueOf(String.valueOf(pAliasNode.pascalName)).concat(" = array"));
                int n = this.horizPos();
                int n2 = pAliasNode.pascalDimensions.length;
                for (int i = 0; i < n2; ++i) {
                    if (i > 0) {
                        this.add(" of array ");
                    }
                    this.add(String.valueOf(String.valueOf(new StringBuffer("[0..").append(pAliasNode.pascalDimensions[i] - 1).append("]"))));
                }
                this.add(" of ".concat(String.valueOf(String.valueOf(pAliasNode.pascalType.getTypeFullName()))));
                this.addln(";");
                break;
            }
            case 15: {
                this.newLine();
                this.writeIdlSectionComment(pAliasNode, "Pascal array              : ", pAliasNode.pascalFullName, "derived from IDL sequence : ", pAliasNode._name);
                if (pAliasNode.isAnonymous) {
                    this.writeIdlSectionComment(pAliasNode, "(This is a generated alias for an anonymous sequence.)");
                }
                PSequenceNode pSequenceNode = (PSequenceNode)pAliasNode.pascalType;
                this.print(String.valueOf(String.valueOf(pAliasNode.pascalName)).concat(" = array"));
                int n = this.horizPos();
                int n3 = pAliasNode.pascalDimensions.length;
                for (int i = 0; i < n3; ++i) {
                    if (i > 0) {
                        this.add(" of array ");
                    }
                    if (pAliasNode.pascalDimensions[i] == 0) continue;
                    this.add(String.valueOf(String.valueOf(new StringBuffer("[0..").append(pAliasNode.pascalDimensions[i] - 1).append("]"))));
                }
                this.add(" of ".concat(String.valueOf(String.valueOf(pAliasNode.pascalType.getTypeFullName()))));
                this.addln(";");
                break;
            }
            default: {
                this.newLine();
                this.writeIdlSectionComment(pAliasNode, "Pascal alias           : ", pAliasNode.pascalFullName, "derived from IDL alias : ", pAliasNode._name);
                this.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(pAliasNode.pascalName))).append(" = ").append(pAliasNode.pascalType.getTypeFullName()).append(";"))));
            }
        }
        this.indent(-1);
    }

    private final void pascalIfaceSignature(PConstantNode pConstantNode) {
        this.usePascalUnitConstantsBuffer(this._pass, pConstantNode);
        this.indent(1);
        this.writeIdlSectionComment(pConstantNode, "Pascal constant           : ", pConstantNode.pascalFullName, "derived from IDL constant : ", pConstantNode._name);
        this.newLine();
        this.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(pConstantNode.pascalName))).append(" : ").append(pConstantNode.pascalTypeName).append(" = ").append(pConstantNode.pascalValue).append(";"))));
        this.indent(-1);
    }

    private final void pascalIfaceSignature(PEnumNode pEnumNode) {
        this.usePascalUnitEnumsBuffer(this._pass, pEnumNode);
        this.indent(1);
        this.writeIdlSectionComment(pEnumNode, "Pascal enumeration           : ", pEnumNode.pascalFullName, "derived from IDL enumeration : ", pEnumNode._name);
        this.newLine();
        this.print(String.valueOf(String.valueOf(pEnumNode.pascalName)).concat(" = ("));
        int n = pEnumNode.pascalMemberNames.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                this.add(" ");
            }
            this.add(pEnumNode.pascalMemberNames[i]);
            if (i >= n - 1) continue;
            this.add(",");
        }
        this.println(");");
        this.indent(-1);
    }

    private final void pascalIfaceSignature(PInterfaceNode pInterfaceNode) {
        this.pascalIfaceFwdDef(pInterfaceNode);
        this.usePascalUnitInterfaceDescriptionBuffer(this._pass, pInterfaceNode);
        this.indent(1);
        this.writeIdlSectionComment(pInterfaceNode, "Signature of Pascal interface : ", pInterfaceNode.pascalFullName, "derived from IDL interface    : ", pInterfaceNode._name);
        this.newLine();
        this.print(String.valueOf(String.valueOf(pInterfaceNode.pascalName)).concat(" = interface"));
        this.writeIfaceInheritance(pInterfaceNode);
        this.indent(1);
        this.writeGuid(pInterfaceNode);
        pInterfaceNode.componentBuffers.reset(this._pass);
        this.writeMethods(pInterfaceNode, 11);
        this.writeSecondaryMethods(pInterfaceNode, 11);
        this.usePascalUnitInterfaceDescriptionBuffer(this._pass, pInterfaceNode);
        this.assembleSignature(pInterfaceNode);
        this.indent(-1);
        this.println("end;");
        this.indent(-1);
    }

    private final void pascalIfaceSignature(PStructNode pStructNode) {
        this.pascalIfaceFwdDef(pStructNode);
        this.usePascalUnitInterfaceDescriptionBuffer(this._pass, pStructNode);
        this.indent(1);
        this.writeIdlSectionComment(pStructNode, "Signature of Pascal interface : ", pStructNode.pascalFullName, "derived from IDL structure    : ", pStructNode._name);
        this.newLine();
        this.println(String.valueOf(String.valueOf(pStructNode.pascalName)).concat(" = interface"));
        this.indent(1);
        this.writeGuid(pStructNode);
        pStructNode.componentBuffers.reset(this._pass);
        this.writeMethods(pStructNode, 11);
        this.usePascalUnitInterfaceDescriptionBuffer(this._pass, pStructNode);
        this.assembleSignature(pStructNode);
        this.indent(-1);
        this.println("end;");
        this.indent(-1);
    }

    private final void pascalIfaceSignature(PUnionNode pUnionNode) {
        this.pascalIfaceFwdDef(pUnionNode);
        this.usePascalUnitInterfaceDescriptionBuffer(this._pass, pUnionNode);
        this.indent(1);
        this.writeIdlSectionComment(pUnionNode, "Signature of Pascal interface : ", pUnionNode.pascalFullName, "derived from IDL union        : ", pUnionNode._name);
        this.newLine();
        this.println(String.valueOf(String.valueOf(pUnionNode.pascalName)).concat(" = interface"));
        this.indent(1);
        this.writeGuid(pUnionNode);
        pUnionNode.componentBuffers.reset(this._pass);
        this.writeMethods(pUnionNode, 11);
        this.usePascalUnitInterfaceDescriptionBuffer(this._pass, pUnionNode);
        this.assembleSignature(pUnionNode);
        this.indent(-1);
        this.println("end;");
        this.indent(-1);
    }

    private void pascalImplImplementation(PInterfaceNode pInterfaceNode) {
        this.usePascalUnitImplementationBuffer(this._pass, pInterfaceNode);
        this.writeIdlSectionComment(pInterfaceNode, "Implementation of Pascal class : ", pInterfaceNode.pascalImplFullName, "supporting Pascal interface    : ", pInterfaceNode.pascalFullName);
        this.newLine();
        this.println(String.valueOf(String.valueOf(new StringBuffer("constructor ").append(pInterfaceNode.pascalImplName).append(".Create;"))));
        this.println("begin");
        this.indent(1);
        this.println("inherited;");
        this.println("{ *************************** }");
        this.println("{ *** User code goes here *** }");
        this.println("{ *************************** }");
        this.indent(-1);
        this.println("end;");
        pInterfaceNode.componentBuffers.reset(this._pass);
        this.writeMethods(pInterfaceNode, 82);
        this.writeSecondaryMethods(pInterfaceNode, 82);
        this.writeInheritedMethods(pInterfaceNode, 82);
        this.usePascalUnitImplementationBuffer(this._pass, pInterfaceNode);
        this.assembleImplementation(pInterfaceNode);
    }

    private void pascalImplSignature(PInterfaceNode pInterfaceNode) {
        this.pascalImplSignatureFwdDef(pInterfaceNode);
        this.usePascalUnitInterfaceDescriptionBuffer(this._pass, pInterfaceNode);
        this.indent(1);
        this.newLine();
        this.print(String.valueOf(String.valueOf(pInterfaceNode.pascalImplName)).concat(" = class"));
        this.writeImplInheritance(pInterfaceNode);
        this.println("protected");
        this.indent(1);
        this.println("{******************************}");
        this.println("{*** User variables go here ***}");
        this.println("{******************************}");
        this.indent(-1);
        pInterfaceNode.componentBuffers.reset(this._pass);
        this.writeConstructors(pInterfaceNode, 0);
        this.writeImplProxyAttributes(pInterfaceNode, 83);
        this.writeMethods(pInterfaceNode, 81);
        this.writeSecondaryMethods(pInterfaceNode, 81);
        this.writeInheritedMethods(pInterfaceNode, 81);
        this.usePascalUnitInterfaceDescriptionBuffer(this._pass, pInterfaceNode);
        this.assembleSignature(pInterfaceNode);
        this.println("end;");
        this.indent(-1);
    }

    private final void pascalImplSignatureFwdDef(PInterfaceNode pInterfaceNode) {
        this.usePascalUnitInterfaceFwdDefBuffer(this._pass, pInterfaceNode);
        this.indent(1);
        this.println(String.valueOf(String.valueOf(pInterfaceNode.pascalImplName)).concat(" = class;"));
        this.indent(-1);
    }

    private final void pascalSkeletonFwdDef(PInterfaceNode pInterfaceNode) {
        this.usePascalUnitInterfaceFwdDefBuffer(this._pass, pInterfaceNode);
        this.indent(1);
        this.println(String.valueOf(String.valueOf(pInterfaceNode.pascalSkeletonName)).concat(" = class;"));
        this.indent(-1);
    }

    private void pascalSkeletonImplementation(PInterfaceNode pInterfaceNode) {
        this.usePascalUnitImplementationBuffer(this._pass, pInterfaceNode);
        this.writeIdlSectionComment(pInterfaceNode, "Implementation of Pascal skeleton class : ", pInterfaceNode.pascalSkeletonFullName, "supporting Pascal interface             : ", pInterfaceNode.pascalFullName);
        this.newLine();
        this.println(String.valueOf(String.valueOf(new StringBuffer("constructor ").append(pInterfaceNode.pascalSkeletonName).append(".Create(const InstanceName : string; const Impl : ").append(pInterfaceNode.pascalFullName).append(");"))));
        this.println("begin");
        this.indent(1);
        if (pInterfaceNode.pascalBases.length == 0 || pInterfaceNode.pascalBases.length == 1) {
            this.println("inherited;");
        }
        this.println(String.valueOf(String.valueOf(new StringBuffer("inherited CreateSkeleton(InstanceName, '").append(pInterfaceNode.pascalName).append("', '").append(pInterfaceNode._repId).append("');"))));
        this.println("FImplementation := Impl;");
        this.indent(-1);
        this.println("end;");
        this.newLine();
        this.println(String.valueOf(String.valueOf(new StringBuffer("destructor ").append(pInterfaceNode.pascalSkeletonName).append(".Destroy;"))));
        this.println("begin");
        this.indent(1);
        this.println("FImplementation := nil;");
        this.println("inherited;");
        this.indent(-1);
        this.println("end;");
        this.newLine();
        this.println(String.valueOf(String.valueOf(new StringBuffer("function ").append(pInterfaceNode.pascalSkeletonName).append(".GetImplementation : ").append(pInterfaceNode.pascalFullName).append(";"))));
        this.println("begin");
        this.indent(1);
        this.println(String.valueOf(String.valueOf(new StringBuffer("result := FImplementation as ").append(pInterfaceNode.pascalFullName).append(";"))));
        this.indent(-1);
        this.println("end;");
        pInterfaceNode.componentBuffers.reset(this._pass);
        this.writeMethods(pInterfaceNode, 71);
        this.writeInheritedMethods(pInterfaceNode, 71);
        this.writeSecondaryMethods(pInterfaceNode, 71);
        this.writeMethods(pInterfaceNode, 72);
        this.writeInheritedMethods(pInterfaceNode, 72);
        this.writeSecondaryMethods(pInterfaceNode, 72);
        this.usePascalUnitImplementationBuffer(this._pass, pInterfaceNode);
        this.assembleImplementation(pInterfaceNode);
    }

    private final void pascalSkeletonInitialisation(PInterfaceNode pInterfaceNode) {
        this.usePascalUnitInitialisationManagerBuffer(this._pass, pInterfaceNode);
        this.writeIdlSectionComment(pInterfaceNode, "Initialization of Pascal skeleton class : ", pInterfaceNode.pascalSkeletonFullName, "supporting Pascal interface             : ", pInterfaceNode.pascalFullName);
        this.println(String.valueOf(String.valueOf(new StringBuffer("SkeletonManager.RegisterSkeleton(_ISkeleton, ").append(pInterfaceNode.pascalSkeletonName).append(");"))));
    }

    private void pascalSkeletonSignature(PInterfaceNode pInterfaceNode) {
        this.pascalSkeletonFwdDef(pInterfaceNode);
        this.usePascalUnitInterfaceDescriptionBuffer(this._pass, pInterfaceNode);
        this.indent(1);
        this.writeIdlSectionComment(pInterfaceNode, "Signature of Pascal skeleton class : ", pInterfaceNode.pascalSkeletonFullName, "supporting IDL interface           : ", pInterfaceNode._name);
        this.newLine();
        this.print(String.valueOf(String.valueOf(pInterfaceNode.pascalSkeletonName)).concat(" = class"));
        this.writeSkelInheritance(pInterfaceNode);
        pInterfaceNode.componentBuffers.reset(this._pass);
        this.usePascalInterfacePropertiesBuffer(this._pass, pInterfaceNode);
        this.indent(2);
        this.println(String.valueOf(String.valueOf(new StringBuffer("FImplementation : ").append(pInterfaceNode.pascalName).append(";"))));
        this.indent(-2);
        this.writeConstructors(pInterfaceNode, 0);
        this.writeMethods(pInterfaceNode, 55);
        this.writeInheritedMethods(pInterfaceNode, 55);
        this.writeSecondaryMethods(pInterfaceNode, 55);
        this.writeHookMethods(pInterfaceNode, 56);
        this.writeInheritedHookMethods(pInterfaceNode, 56);
        this.writeSecondaryHookMethods(pInterfaceNode, 56);
        this.usePascalUnitInterfaceDescriptionBuffer(this._pass, pInterfaceNode);
        this.assembleSignature(pInterfaceNode);
        this.println("end;");
        this.indent(-1);
    }

    private final void pascalStubFinalization(PExceptionNode pExceptionNode) {
        this.usePascalUnitFinalisationBuffer(this._pass, pExceptionNode);
        this.writeIdlSectionComment(pExceptionNode, "Finalization of the Pascal exception : ", pExceptionNode.pascalFullName);
        this.println(String.valueOf(String.valueOf(new StringBuffer("UnRegisterUserException(").append(pExceptionNode.pascalProxyFullName).append(");"))));
    }

    private final void pascalStubFwdDef(PExceptionNode pExceptionNode) {
        this.usePascalUnitInterfaceFwdDefBuffer(this._pass, pExceptionNode);
        this.indent(1);
        this.println(String.valueOf(String.valueOf(pExceptionNode.pascalStubName)).concat(" = class;"));
        this.indent(-1);
    }

    private final void pascalStubFwdDef(PInterfaceNode pInterfaceNode) {
        this.usePascalUnitInterfaceFwdDefBuffer(this._pass, pInterfaceNode);
        this.indent(1);
        this.println(String.valueOf(String.valueOf(pInterfaceNode.pascalStubName)).concat(" = class;"));
        this.indent(-1);
    }

    private final void pascalStubFwdDef(PStructNode pStructNode) {
        this.usePascalUnitInterfaceFwdDefBuffer(this._pass, pStructNode);
        this.indent(1);
        this.println(String.valueOf(String.valueOf(pStructNode.pascalStubName)).concat(" = class;"));
        this.indent(-1);
    }

    private final void pascalStubFwdDef(PUnionNode pUnionNode) {
        this.usePascalUnitInterfaceFwdDefBuffer(this._pass, pUnionNode);
        this.indent(1);
        this.println(String.valueOf(String.valueOf(pUnionNode.pascalStubName)).concat(" = class;"));
        this.indent(-1);
    }

    private final void pascalStubImplementation(PExceptionNode pExceptionNode) {
        this.writeExceptionProxyVar(pExceptionNode);
        this.usePascalUnitImplementationBuffer(this._pass, pExceptionNode);
        this.writeIdlSectionComment(pExceptionNode, "Implementation of Pascal stub class : ", pExceptionNode.pascalStubFullName, "supporting Pascal interface         : ", pExceptionNode.pascalFullName);
        pExceptionNode.componentBuffers.reset(this._pass);
        this.writeMethods(pExceptionNode, 36);
        this.writeConstructors(pExceptionNode, 36);
        this.writeCopyMethods(pExceptionNode, 36);
        this.assembleImplementation(pExceptionNode);
        this.writeFactoryMethod(pExceptionNode);
    }

    private final void pascalStubImplementation(PInterfaceNode pInterfaceNode) {
        this.usePascalUnitImplementationBuffer(this._pass, pInterfaceNode);
        this.writeIdlSectionComment(pInterfaceNode, "Implementation of Pascal stub class : ", pInterfaceNode.pascalStubFullName, "supporting Pascal interface         : ", pInterfaceNode.pascalFullName);
        pInterfaceNode.componentBuffers.reset(this._pass);
        this.writeMethods(pInterfaceNode, 33);
        this.writeSecondaryMethods(pInterfaceNode, 33);
        this.writeInheritedMethods(pInterfaceNode, 33);
        this.usePascalUnitImplementationBuffer(this._pass, pInterfaceNode);
        this.assembleImplementation(pInterfaceNode);
    }

    private final void pascalStubImplementation(PStructNode pStructNode) {
        int n;
        this.usePascalUnitImplementationBuffer(this._pass, pStructNode);
        this.writeIdlSectionComment(pStructNode, "Implementation of Pascal stub class : ", pStructNode.pascalStubFullName, "supporting Pascal interface         : ", pStructNode.pascalFullName);
        this.newLine();
        this.println(String.valueOf(String.valueOf(new StringBuffer("constructor ").append(pStructNode.pascalStubName).append(".Create;"))));
        this.println("begin");
        this.indent(1);
        this.println("inherited Create;");
        this.indent(-1);
        this.println("end;");
        this.newLine();
        this.print(String.valueOf(String.valueOf(new StringBuffer("constructor ").append(pStructNode.pascalStubName).append(".Create("))));
        int n2 = this.horizPos();
        int n3 = pStructNode.pascalMemberNames.length;
        for (n = 0; n < n3; ++n) {
            this.add(String.valueOf(String.valueOf(new StringBuffer("const ").append(pStructNode.pascalMemberNames[n]).append(": ").append(pStructNode.pascalMemberTypeNames[n]))));
            if (n >= n3 - 1) continue;
            this.addln(";");
            this.indentTo(n2);
        }
        this.println(");");
        this.println("begin");
        this.indent(1);
        n3 = pStructNode.pascalMemberNames.length;
        for (n = 0; n < n3; ++n) {
            this.println(String.valueOf(String.valueOf(new StringBuffer("Self.").append(pStructNode.pascalMemberNames[n]).append(" := ").append(pStructNode.pascalMemberNames[n]).append(";"))));
        }
        this.indent(-1);
        this.println("end;");
        n3 = pStructNode.pascalMemberNames.length;
        for (n = 0; n < n3; ++n) {
            this.newLine();
            this.println(String.valueOf(String.valueOf(new StringBuffer("function  ").append(pStructNode.pascalStubName).append(".").append(pStructNode.pascalMembers[n].pascalGetMethod.pascalName).append(": ").append(pStructNode.pascalMemberTypeNames[n]).append(";"))));
            this.println("begin");
            this.indent(1);
            this.println(String.valueOf(String.valueOf(new StringBuffer("Result := ").append(pStructNode.pascalMemberNames[n]).append(";"))));
            this.writeReadRangeCheck(pStructNode.pascalMemberTypes[n], "Result", pStructNode.pascalFullName);
            this.indent(-1);
            this.println("end;");
            this.newLine();
            this.println(String.valueOf(String.valueOf(new StringBuffer("procedure ").append(pStructNode.pascalStubName).append(".").append(pStructNode.pascalMembers[n].pascalSetMethod.pascalName).append("(const").append(" _Value : ").append(pStructNode.pascalMemberTypeNames[n]).append(");"))));
            this.println("begin");
            this.indent(1);
            this.writeWriteRangeCheck(pStructNode.pascalMemberTypes[n], "_Value", pStructNode.pascalFullName);
            this.println(String.valueOf(String.valueOf(pStructNode.pascalMemberNames[n])).concat(" := _Value;"));
            this.indent(-1);
            this.println("end;");
        }
    }

    private final void pascalStubImplementation(PUnionNode pUnionNode) {
        this.usePascalUnitImplementationBuffer(this._pass, pUnionNode);
        this.writeIdlSectionComment(pUnionNode, "Implementation of Pascal stub class : ", pUnionNode.pascalStubFullName, "supporting Pascal interface         : ", pUnionNode.pascalFullName);
        this.newLine();
        this.println(String.valueOf(String.valueOf(new StringBuffer("constructor ").append(pUnionNode.pascalStubName).append(".Create;"))));
        this.println("begin");
        this.indent(1);
        this.println(String.valueOf(String.valueOf(new StringBuffer("Self._discriminator := ").append(pUnionNode.pascalDiscTypeName).append("(").append(pUnionNode.pascalDiscInitValue).append(");"))));
        this.indent(-1);
        this.println("end;");
        this.newLine();
        this.println(String.valueOf(String.valueOf(new StringBuffer("function  ").append(pUnionNode.pascalStubName).append("._get_discriminator: ").append(pUnionNode.pascalDiscTypeName).append(";"))));
        this.println("begin");
        this.indent(1);
        this.println("Result := _discriminator;");
        this.writeReadRangeCheck(pUnionNode._discriminator, "Result", pUnionNode.pascalFullName);
        this.indent(-1);
        this.println("end;");
        int n = pUnionNode.pascalMemberNames.length;
        for (int i = 0; i < n; ++i) {
            this.newLine();
            this.println(String.valueOf(String.valueOf(new StringBuffer("function  ").append(pUnionNode.pascalStubName).append(".").append(pUnionNode.pascalMembers[i].pascalGetMethod.pascalName).append(": ").append(pUnionNode.pascalMemberTypeNames[i]).append(";"))));
            this.println("begin");
            this.indent(1);
            this.print("if ( ");
            int n2 = this.horizPos();
            int n3 = pUnionNode.pascalMemberLabels[i] != null ? pUnionNode.pascalMemberLabels[i].length : -1;
            for (int j = 0; j < n3; ++j) {
                this.add(String.valueOf(String.valueOf(new StringBuffer("( _discriminator <> ").append(pUnionNode.pascalMemberLabels[i][j]).append(" ) "))));
                if (j >= n3 - 1) continue;
                this.addln(" and");
                this.indentTo(n2);
            }
            if (pUnionNode.pascalDefaultExists && pUnionNode._defaultIndex == i) {
                if (n3 > 0) {
                    this.addln(" and");
                    this.indentTo(n2);
                }
                this.add(String.valueOf(String.valueOf(new StringBuffer("( _discriminator <> ").append(pUnionNode.pascalDefaultDescValue).append(" ) "))));
            }
            this.newLine();
            this.indentTo(n2 - 1);
            this.addln(")");
            this.indent(1);
            this.println("then raise BAD_OPERATION.Create(0, COMPLETED_YES);");
            this.indent(-1);
            this.println(String.valueOf(String.valueOf(new StringBuffer("Result := ").append(pUnionNode.pascalMemberNames[i]).append(";"))));
            this.writeReadRangeCheck(pUnionNode.pascalMemberTypes[i], "Result", pUnionNode.pascalFullName);
            this.indent(-1);
            this.println("end;");
            this.newLine();
            this.println(String.valueOf(String.valueOf(new StringBuffer("procedure ").append(pUnionNode.pascalStubName).append(".").append(pUnionNode.pascalMembers[i].pascalSetMethod.pascalName).append("(const _Value : ").append(pUnionNode.pascalMemberTypeNames[i]).append(");"))));
            this.println("begin");
            this.indent(1);
            this.print("_discriminator := ");
            this.add(pUnionNode.pascalMemberLabels[i] != null && pUnionNode.pascalMemberLabels[i].length > 0 ? pUnionNode.pascalMemberLabels[i][0] : pUnionNode.pascalDefaultDescValue);
            this.addln(";");
            this.writeWriteRangeCheck(pUnionNode.pascalMemberTypes[i], "_Value", pUnionNode.pascalFullName);
            this.println(String.valueOf(String.valueOf(pUnionNode.pascalMemberNames[i])).concat(" := _Value;"));
            this.indent(-1);
            this.println("end;");
        }
    }

    private final void pascalStubInitialization(PExceptionNode pExceptionNode) {
        this.usePascalUnitInitialisationExceptionBuffer(this._pass, pExceptionNode);
        this.writeIdlSectionComment(pExceptionNode, "Initalization of Pascal stub class : ", pExceptionNode.pascalFullName, "supporting Pascal exception        : ", pExceptionNode.pascalFullName, "IDL exception                      : ", pExceptionNode._name);
        this.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(pExceptionNode.pascalProxyFullName))).append(" := RegisterUserException('").append(pExceptionNode._name).append("', '").append(pExceptionNode._repId).append("', @").append(pExceptionNode.pascalFactoryFullName).append(");"))));
    }

    private final void pascalStubInitialization(PInterfaceNode pInterfaceNode) {
        this.usePascalUnitInitialisationManagerBuffer(this._pass, pInterfaceNode);
        this.writeIdlSectionComment(pInterfaceNode, "Initialization of Pascal stub class : ", pInterfaceNode.pascalStubFullName, "supporting Pascal interface         : ", pInterfaceNode.pascalFullName);
        this.println(String.valueOf(String.valueOf(new StringBuffer("CORBA.StubManager.RegisterStub(").append(pInterfaceNode.pascalFullName).append(", ").append(pInterfaceNode.pascalStubFullName).append(");"))));
    }

    private final void pascalStubSignature(PExceptionNode pExceptionNode) {
        this.pascalStubFwdDef(pExceptionNode);
        this.usePascalUnitInterfaceDescriptionBuffer(this._pass, pExceptionNode);
        this.indent(1);
        this.writeIdlSectionComment(pExceptionNode, "Signature of Pascal stub class : ", pExceptionNode.pascalStubFullName, "supporting IDL exception       : ", pExceptionNode._name);
        this.newLine();
        this.println(String.valueOf(String.valueOf(pExceptionNode.pascalStubName)).concat(" = class(UserException)"));
        pExceptionNode.componentBuffers.reset(this._pass);
        this.writeMethods(pExceptionNode, 35);
        this.writeConstructors(pExceptionNode, 35);
        this.writeCopyMethods(pExceptionNode, 35);
        this.assembleSignature(pExceptionNode);
        this.println("end;");
        this.indent(-1);
    }

    private final void pascalStubSignature(PInterfaceNode pInterfaceNode) {
        this.pascalStubFwdDef(pInterfaceNode);
        this.usePascalUnitInterfaceDescriptionBuffer(this._pass, pInterfaceNode);
        this.indent(1);
        this.writeIdlSectionComment(pInterfaceNode, "Signature of Pascal stub class : ", pInterfaceNode.pascalStubFullName, "supporting Pascal interface    : ", pInterfaceNode.pascalFullName);
        this.newLine();
        this.print(String.valueOf(String.valueOf(pInterfaceNode.pascalStubName)).concat(" = class"));
        this.writeStubInheritance(pInterfaceNode);
        pInterfaceNode.componentBuffers.reset(this._pass);
        this.writeMethods(pInterfaceNode, 31);
        this.writeSecondaryMethods(pInterfaceNode, 31);
        this.writeInheritedMethods(pInterfaceNode, 31);
        this.usePascalUnitInterfaceDescriptionBuffer(this._pass, pInterfaceNode);
        this.assembleSignature(pInterfaceNode);
        this.println("end;");
        this.indent(-1);
    }

    private final void pascalStubSignature(PStructNode pStructNode) {
        this.pascalStubFwdDef(pStructNode);
        this.usePascalUnitInterfaceDescriptionBuffer(this._pass, pStructNode);
        this.indent(1);
        this.writeIdlSectionComment(pStructNode, "Signature of Pascal stub class : ", pStructNode.pascalStubFullName, "supporting Pascal interface    : ", pStructNode.pascalFullName);
        this.newLine();
        this.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(pStructNode.pascalStubName))).append(" = class (TInterfacedObject, ").append(pStructNode.pascalFullName).append(")"))));
        pStructNode.componentBuffers.reset(this._pass);
        this.writeMethods(pStructNode, 34);
        this.writeConstructors(pStructNode, 34);
        this.usePascalUnitInterfaceDescriptionBuffer(this._pass, pStructNode);
        this.assembleSignature(pStructNode);
        this.println("end;");
        this.indent(-1);
    }

    private final void pascalStubSignature(PUnionNode pUnionNode) {
        this.pascalStubFwdDef(pUnionNode);
        this.usePascalUnitInterfaceDescriptionBuffer(this._pass, pUnionNode);
        this.indent(1);
        this.writeIdlSectionComment(pUnionNode, "Signature of Pascal stub class : ", pUnionNode.pascalStubFullName, "supporting Pascal interface    : ", pUnionNode.pascalFullName);
        this.newLine();
        this.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(pUnionNode.pascalStubName))).append(" = class (TInterfacedObject, ").append(pUnionNode.pascalFullName).append(")"))));
        pUnionNode.componentBuffers.reset(this._pass);
        this.writeMethods(pUnionNode, 34);
        this.writeConstructors(pUnionNode, 34);
        this.usePascalUnitInterfaceDescriptionBuffer(this._pass, pUnionNode);
        this.assembleSignature(pUnionNode);
        this.println("end;");
        this.indent(-1);
    }

    protected final void print(String string) {
        super.print(this._pass, string);
    }

    private void printSectionToFile(String string, String string2, String string3, String string4) {
        if (string2.length() != 0 || string4.length() != 0) {
            if (string != null && string.length() > 0) {
                this.printDirect(GenericBackend.LINE_SEP);
                this.printDirect(GenericBackend.LINE_SEP);
                this.printDirect(string);
                this.printDirect(GenericBackend.LINE_SEP);
            }
            this.printToFile(string2, string3, string4);
        }
    }

    private void printSubsectionToFile(String string, String string2, String string3, String string4) {
        if (string2.length() != 0 || string4.length() != 0) {
            if (string != null && string.length() > 0) {
                this.printDirect(GenericBackend.LINE_SEP);
                this.printDirect(string);
                this.printDirect(GenericBackend.LINE_SEP);
            }
            this.printToFile(string2, string3, string4);
        }
    }

    private void printToFile(String string, String string2, String string3) {
        if (string == null || string.length() == 0) {
            if (string3 != null && string3.length() > 0) {
                this.printDirect(String.valueOf(String.valueOf(new StringBuffer("  { ").append(string3).append(" }"))));
                this.printDirect(GenericBackend.LINE_SEP);
            }
        } else {
            if (string2 != null && string2.length() > 0) {
                this.printDirect(String.valueOf(String.valueOf(new StringBuffer("  { ").append(string2).append(" }"))));
                this.printDirect(GenericBackend.LINE_SEP);
            }
            this.printDirect(string);
            if (!string.endsWith(GenericBackend.LINE_SEP)) {
                this.printDirect(GenericBackend.LINE_SEP);
            }
        }
    }

    private final void printUnindented(String string) {
        super.printUnindented(this._pass, string);
    }

    protected final void println(String string) {
        super.println(this._pass, string);
    }

    private final void setUnit(int n, String string) {
        this.println(n, String.valueOf(String.valueOf(new StringBuffer("unit ").append(string).append(";"))));
    }

    private final void startPascalCFile(PModuleNode pModuleNode) {
        this.useFile(pModuleNode.pascalCUnitName);
        this.usePascalUnitPreambleBuffer(1, pModuleNode);
        this.setUnit(1, pModuleNode.pascalCUnitName);
        this.writeUserComments(1, pModuleNode);
        this.writeIdlSectionComment(pModuleNode, "This unit contains the stub code for IDL module : ", pModuleNode._name);
    }

    private final void startPascalCFile(PRepositoryNode pRepositoryNode) {
        this.useFile(pRepositoryNode.pascalCUnitName);
        this.usePascalUnitPreambleBuffer(1, pRepositoryNode);
        this.setUnit(1, pRepositoryNode.pascalCUnitName);
        this.writeUserComments(1, pRepositoryNode);
    }

    private final void startPascalIFile(PModuleNode pModuleNode) {
        this.useFile(pModuleNode.pascalIUnitName);
        this.usePascalUnitPreambleBuffer(0, pModuleNode);
        this.setUnit(0, pModuleNode.pascalIUnitName);
        this.writeUserComments(0, pModuleNode);
        this.writeIdlSectionComment(pModuleNode, "This unit contains the pascal interface code for IDL module : ", pModuleNode._name);
    }

    private final void startPascalIFile(PRepositoryNode pRepositoryNode) {
        this.useFile(pRepositoryNode.pascalIUnitName);
        this.usePascalUnitPreambleBuffer(0, pRepositoryNode);
        this.setUnit(0, pRepositoryNode.pascalIUnitName);
        this.writeUserComments(0, pRepositoryNode);
    }

    private final void startPascalPFile(PModuleNode pModuleNode) {
        this.useFile(pModuleNode.pascalPUnitName);
        this.usePascalUnitPreambleBuffer(3, pModuleNode);
        this.setUnit(3, pModuleNode.pascalPUnitName);
        this.writeUserComments(3, pModuleNode);
        this.writeIdlSectionComment(pModuleNode, "This unit contains the implementation code for IDL module : ", pModuleNode._name);
    }

    private final void startPascalPFile(PRepositoryNode pRepositoryNode) {
        this.useFile(pRepositoryNode.pascalPUnitName);
        this.usePascalUnitPreambleBuffer(3, pRepositoryNode);
        this.setUnit(3, pRepositoryNode.pascalPUnitName);
        this.writeUserComments(3, pRepositoryNode);
    }

    private final void startPascalSFile(PModuleNode pModuleNode) {
        this.useFile(pModuleNode.pascalSUnitName);
        this.usePascalUnitPreambleBuffer(2, pModuleNode);
        this.setUnit(2, pModuleNode.pascalSUnitName);
        this.writeUserComments(2, pModuleNode);
        this.writeIdlSectionComment(pModuleNode, "This unit contains the skeleton code for IDL module : ", pModuleNode._name);
    }

    private final void startPascalSFile(PRepositoryNode pRepositoryNode) {
        this.useFile(pRepositoryNode.pascalSUnitName);
        this.usePascalUnitPreambleBuffer(2, pRepositoryNode);
        this.setUnit(2, pRepositoryNode.pascalSUnitName);
        this.writeUserComments(2, pRepositoryNode);
    }

    protected final void useFile(String string) {
        super.useFile(string);
    }

    private final void writeComments(int n, String string, String string2, String string3, String string4, String string5, String string6) {
        if (this._options.codeHints) {
            if (string.length() > 0 || string2.length() > 0) {
                this.println(this.padCommentToLength(string, string2));
            }
            if (string3.length() > 0 || string4.length() > 0) {
                this.println(this.padCommentToLength(string3, string4));
            }
            if (string5.length() > 0 || string6.length() > 0) {
                this.println(this.padCommentToLength(string5, string6));
            }
        }
    }

    private void writeConstructors(PExceptionNode pExceptionNode, int n) {
        switch (n) {
            case 35: {
                this.usePascalExceptionMethodsBuffer(this._pass, pExceptionNode);
                this.indent(2);
                this.println("constructor Create; overload;");
                if (pExceptionNode.pascalMemberNames.length > 0) {
                    this.print("constructor Create");
                    if (pExceptionNode.pascalMemberNames != null && pExceptionNode.pascalMemberNames.length > 0) {
                        this.add("(");
                        int n2 = this.horizPos();
                        for (int i = 0; i < pExceptionNode.pascalMemberNames.length; ++i) {
                            this.add(String.valueOf(String.valueOf(new StringBuffer("const ").append(pExceptionNode.pascalMemberNames[i]).append(" : ").append(pExceptionNode.pascalMemberTypeNames[i]))));
                            if (i >= pExceptionNode.pascalMemberNames.length - 1) continue;
                            this.add(";");
                            this.newLine();
                            this.indentTo(n2);
                        }
                        this.add(")");
                    }
                    this.addln("; overload;");
                }
                this.indent(-2);
                break;
            }
            case 36: {
                int n3;
                this.usePascalExceptionMethodsBuffer(this._pass, pExceptionNode);
                this.newLine();
                this.println(String.valueOf(String.valueOf(new StringBuffer("constructor ").append(pExceptionNode.pascalName).append(".Create;"))));
                this.println("begin");
                this.indent(1);
                this.println("inherited Create;");
                this.indent(-1);
                this.println("end;");
                if (pExceptionNode.pascalMemberNames.length <= 0) break;
                this.newLine();
                this.print(String.valueOf(String.valueOf(new StringBuffer("constructor ").append(pExceptionNode.pascalName).append(".Create"))));
                if (pExceptionNode.pascalMemberNames != null && pExceptionNode.pascalMemberNames.length > 0) {
                    this.add("(");
                    n3 = this.horizPos();
                    for (int i = 0; i < pExceptionNode.pascalMemberNames.length; ++i) {
                        this.add(String.valueOf(String.valueOf(new StringBuffer("const ").append(pExceptionNode.pascalMemberNames[i]).append(" : ").append(pExceptionNode.pascalMemberTypeNames[i]))));
                        if (i >= pExceptionNode.pascalMemberNames.length - 1) continue;
                        this.add(";");
                        this.newLine();
                        this.indentTo(n3);
                    }
                    this.add(")");
                }
                this.addln(";");
                this.println("begin");
                this.indent(1);
                this.println("inherited Create;");
                if (pExceptionNode.pascalMemberNames != null && pExceptionNode.pascalMemberNames.length > 0) {
                    for (n3 = 0; n3 < pExceptionNode.pascalMemberNames.length; ++n3) {
                        this.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(pExceptionNode.pascalFieldNames[n3]))).append(" := ").append(pExceptionNode.pascalMemberNames[n3]).append(";"))));
                    }
                }
                this.indent(-1);
                this.println("end;");
            }
        }
    }

    private void writeConstructors(PInterfaceNode pInterfaceNode, int n) {
        switch (this._pass) {
            case 2: {
                this.usePascalInterfaceMethodsBuffer(this._pass, pInterfaceNode);
                this.indent(2);
                this.println(String.valueOf(String.valueOf(new StringBuffer("constructor Create(const InstanceName: string; const Impl: ").append(pInterfaceNode.pascalName).append(");"))));
                this.println("destructor Destroy; override;");
                this.println(String.valueOf(String.valueOf(new StringBuffer("function GetImplementation : ").append(pInterfaceNode.pascalName).append(";"))));
                this.indent(-2);
                break;
            }
            case 3: {
                this.usePascalInterfaceMethodsBuffer(this._pass, pInterfaceNode);
                this.indent(2);
                this.println("constructor Create;");
                this.indent(-2);
            }
        }
    }

    private void writeConstructors(PStructNode pStructNode, int n) {
        this.usePascalPropertiesBuffer(this._pass, pStructNode);
        this.indent(2);
        this.println("constructor Create; overload;");
        this.indent(-2);
        this.usePascalPropertyMethodsBuffer(this._pass, pStructNode);
        this.indent(2);
        this.print("constructor Create (");
        int n2 = this.horizPos();
        for (int i = 0; i < pStructNode.pascalMemberNames.length; ++i) {
            this.add(String.valueOf(String.valueOf(new StringBuffer("const ").append(pStructNode.pascalMemberNames[i]).append(" : ").append(pStructNode.pascalMemberTypeNames[i]))));
            if (i >= pStructNode.pascalMemberNames.length - 1) continue;
            this.addln(";");
            this.print("");
            this.indentTo(n2);
        }
        this.newLine();
        this.indentTo(n2 - 1);
        this.addln("); overload;");
        this.indent(-2);
    }

    private void writeConstructors(PUnionNode pUnionNode, int n) {
        this.usePascalPropertyMethodsBuffer(this._pass, pUnionNode);
        this.indent(2);
        this.println("constructor Create;");
        this.indent(-2);
    }

    private void writeCopyMethods(PExceptionNode pExceptionNode, int n) {
        this.usePascalExceptionMethodsBuffer(this._pass, pExceptionNode);
        switch (n) {
            case 35: {
                this.indent(2);
                this.println("procedure Copy(const _Input : InputStream); override;");
                this.println("procedure WriteExceptionInfo(var _Output : OutputStream); override;");
                this.indent(-2);
                break;
            }
            case 36: {
                int n2;
                this.newLine();
                this.println(String.valueOf(String.valueOf(new StringBuffer("procedure ").append(pExceptionNode.pascalName).append(".Copy(const _Input: InputStream);"))));
                this.println("begin");
                this.indent(1);
                for (n2 = 0; n2 < pExceptionNode.pascalMemberNames.length; ++n2) {
                    if (pExceptionNode.pascalMemberHelperFullNames[n2] != null) {
                        this.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(pExceptionNode.pascalFieldNames[n2]))).append(" := ").append(pExceptionNode.pascalMemberHelperFullNames[n2]).append(".Read(_Input);"))));
                        continue;
                    }
                    this.println(String.valueOf(String.valueOf(new StringBuffer("_Input.Read").append(pExceptionNode.pascalMemberReadWritePrefixes[n2]).append("(").append(pExceptionNode.pascalFieldNames[n2]).append(");"))));
                    this.writeReadRangeCheck(pExceptionNode.pascalMemberTypes[n2], pExceptionNode.pascalFieldNames[n2], pExceptionNode.pascalFullName);
                }
                this.indent(-1);
                this.println("end;");
                this.newLine();
                this.println(String.valueOf(String.valueOf(new StringBuffer("procedure ").append(pExceptionNode.pascalName).append(".WriteExceptionInfo(var _Output : OutputStream);"))));
                this.println("begin");
                this.indent(1);
                this.println(String.valueOf(String.valueOf(new StringBuffer("_Output.WriteString('").append(pExceptionNode._repId).append("');"))));
                for (n2 = 0; n2 < pExceptionNode.pascalMemberNames.length; ++n2) {
                    if (pExceptionNode.pascalMemberHelperFullNames[n2] != null) {
                        this.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(pExceptionNode.pascalMemberHelperFullNames[n2]))).append(".Write(_Output, ").append(pExceptionNode.pascalFieldNames[n2]).append(");"))));
                        continue;
                    }
                    this.writeWriteRangeCheck(pExceptionNode.pascalMemberTypes[n2], pExceptionNode.pascalFieldNames[n2], pExceptionNode.pascalFullName);
                    this.println(String.valueOf(String.valueOf(new StringBuffer("_Output.Write").append(pExceptionNode.pascalMemberReadWritePrefixes[n2]).append("(").append(pExceptionNode.pascalFieldNames[n2]).append(");"))));
                }
                this.indent(-1);
                this.println("end;");
            }
        }
    }

    private final void writeExceptionProxyVar(PExceptionNode pExceptionNode) {
        this.usePascalUnitImplementationVarBuffer(this._pass, pExceptionNode);
        this.indent(1);
        this.writeIdlSectionComment(pExceptionNode, String.valueOf(String.valueOf(new StringBuffer("Pascal proxy \"").append(pExceptionNode.pascalProxyFullName).append("\" for the IDL exception ").append(pExceptionNode._name).append("."))));
        this.newLine();
        this.println(String.valueOf(String.valueOf(pExceptionNode.pascalProxyName)).concat(" : PExceptionDescription;"));
        this.indent(-1);
    }

    private final void writeFactoryMethod(PExceptionNode pExceptionNode) {
        this.usePascalUnitImplementationBuffer(this._pass, pExceptionNode);
        this.println("");
        this.println(String.valueOf(String.valueOf(new StringBuffer("function  ").append(pExceptionNode.pascalFactoryName).append(": PExceptionProxy; cdecl;"))));
        this.println("begin");
        this.indent(1);
        this.println(String.valueOf(String.valueOf(new StringBuffer("with ").append(pExceptionNode.pascalFullName).append(".Create() do Result := Proxy;"))));
        this.indent(-1);
        this.println("end;");
    }

    private final void writeFileComments(int n, String string, String string2, String string3, String string4, String string5) {
        String string6 = null;
        switch (n) {
            case 0: {
                string6 = string2;
                break;
            }
            case 1: {
                string6 = string3;
                break;
            }
            case 2: {
                string6 = string4;
                break;
            }
            case 3: {
                string6 = string5;
            }
        }
        this.writeIdlFixedComment(n, "Delphi Pascal unit      : ".concat(String.valueOf(String.valueOf(string6))));
        this.writeIdlFixedComment(n, "derived from IDL module : ".concat(String.valueOf(String.valueOf(string))));
        this.newLine();
        if (string6.equals(string2)) {
            this.writeIdlComment(n, "This unit declares the interfaces and variables used by the other generated");
            this.writeIdlComment(n, "units and must be used with the following generated units;");
        } else if (string6.equals(string3)) {
            this.writeIdlComment(n, "This unit implements the client-side stub and helper classes and must be used");
            this.writeIdlComment(n, "with the following generated units;");
        } else if (string6.equals(string4)) {
            this.writeIdlComment(n, "This unit implements the server-side skeleton classes and must be used with");
            this.writeIdlComment(n, "the following generated units;");
        } else if (string6.equals(string5)) {
            this.writeIdlComment(n, "This unit supports the user-coded server implementation classes and must be");
            this.writeIdlComment(n, "used with the following generated units;");
        }
        if (!string6.equals(string2)) {
            this.writeIdlComment(n, "* interface unit      : ".concat(String.valueOf(String.valueOf(string2))));
        }
        if (!string6.equals(string3)) {
            this.writeIdlComment(n, "* client unit         : ".concat(String.valueOf(String.valueOf(string3))));
        }
        if (!string6.equals(string4)) {
            this.writeIdlComment(n, "* server unit         : ".concat(String.valueOf(String.valueOf(string4))));
        }
        if (!string6.equals(string5)) {
            this.writeIdlComment(n, "* implementation unit : ".concat(String.valueOf(String.valueOf(string5))));
        }
    }

    private final void writeGuid(PInterfaceNode pInterfaceNode) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(pInterfaceNode.pascalFullName.getBytes());
            this.calcMethodGuids(pInterfaceNode._beMethods, messageDigest, 12);
            this.println(String.valueOf(String.valueOf(new StringBuffer("['{").append(this.formatGuid(messageDigest)).append("}']"))));
        }
        catch (Exception exception) {
            this._ER.internalError("invalid GUID digest Algorihm in calcGuid(PInterfaceNode)");
        }
    }

    private final void writeGuid(PStructNode pStructNode) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(pStructNode.pascalFullName.getBytes());
            this.calcMethodGuids(pStructNode.pascalMembers, messageDigest, 12);
            this.println(String.valueOf(String.valueOf(new StringBuffer("['{").append(this.formatGuid(messageDigest)).append("}']"))));
        }
        catch (Exception exception) {
            this._ER.internalError("invalid GUID digest Algorihm in calcGuid(PStructNode)");
        }
    }

    private final void writeGuid(PUnionNode pUnionNode) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(pUnionNode.pascalFullName.getBytes());
            this.calcMethodGuids(pUnionNode.pascalMembers, messageDigest, 12);
            this.println(String.valueOf(String.valueOf(new StringBuffer("['{").append(this.formatGuid(messageDigest)).append("}']"))));
        }
        catch (Exception exception) {
            this._ER.internalError("invalid GUID digest Algorihm in calcGuid(PUnionNode)");
        }
    }

    private final void writeHookMethods(PInterfaceNode pInterfaceNode, int n) {
        ContainedNode[] containedNodeArray = pInterfaceNode._beMethods;
        if (containedNodeArray != null) {
            int n2 = containedNodeArray.length;
            block4: for (int i = 0; i < n2; ++i) {
                switch (containedNodeArray[i]._kind) {
                    case 7: {
                        this.usePascalInterfacePropertyMethodsBuffer(this._pass, pInterfaceNode);
                        this.writeMethod((POperationNode)containedNodeArray[i], n);
                        continue block4;
                    }
                    case 2: {
                        this.usePascalPropertyMethodsBuffer(this._pass, pInterfaceNode);
                        this.writeMethod((PAttributeNode)containedNodeArray[i], n);
                        continue block4;
                    }
                    default: {
                        this._ER.internalError(String.valueOf(String.valueOf(new StringBuffer("invalid kind ").append(containedNodeArray[i]._kind).append(" passed to PascalBackend.writeHookMethods (PInterfaceNode, int)"))));
                    }
                }
            }
        }
    }

    private final void writeIdlComment(int n, String string) {
        if (this._options.idlHints) {
            this.writeIdlFixedComment(n, string);
        }
    }

    private final void writeIdlComment(String string) {
        if (this._options.idlHints) {
            this.writeIdlComment(this._pass, string);
        }
    }

    private final void writeIdlFixedComment(int n, String string) {
        this.println(n, this.padCommentToLength(string));
    }

    private final void writeIdlSectionComment(int n, ContainedNode containedNode) {
        Object var3_3 = null;
        if (this._options.idlHints) {
            this.println(this.padCommentToLength("IDL Source    : ", String.valueOf(String.valueOf(new StringBuffer("\"").append(containedNode.ER().getFileName(containedNode._fileNumber)).append("\", line ").append(containedNode._lineNumber)))));
            this.println(this.padCommentToLength("Repository Id : ", String.valueOf(String.valueOf(new StringBuffer("\"").append(containedNode._repId).append("\"")))));
            this.println(this.padCommentToLength("IDL Type      : ", containedNode.typeName()));
        }
    }

    private final void writeIdlSectionComment(int n, ContainedNode containedNode, String string) {
        if (this._options.codeHints) {
            this.newLine(n);
        }
        this.writeIdlComment(n, string);
        this.writeIdlSectionComment(n, containedNode);
    }

    private final void writeIdlSectionComment(ContainedNode containedNode) {
        this.writeIdlSectionComment(this._pass, containedNode);
    }

    private final void writeIdlSectionComment(ContainedNode containedNode, String string) {
        this.writeIdlSectionComment(this._pass, containedNode, string);
    }

    private final void writeIdlSectionComment(ContainedNode containedNode, String string, String string2) {
        this.writeIdlSectionComment(containedNode, string, string2, "", "", "", "");
    }

    private final void writeIdlSectionComment(ContainedNode containedNode, String string, String string2, String string3, String string4) {
        this.writeIdlSectionComment(containedNode, string, string2, string3, string4, "", "");
    }

    private final void writeIdlSectionComment(ContainedNode containedNode, String string, String string2, String string3, String string4, String string5, String string6) {
        if (this._options.codeHints) {
            this.newLine(this._pass);
            this.writeComments(this._pass, string, string2, string3, string4, string5, string6);
        }
        this.writeIdlSectionComment(this._pass, containedNode);
    }

    private final void writeIdlSectionComment(String string, String string2, String string3, String string4) {
        this.writeComments(this._pass, string, string2, string3, string4, "", "");
    }

    private void writeIfaceInheritance(PInterfaceNode pInterfaceNode) {
        if (pInterfaceNode._bases.size() > 0) {
            this.addln(String.valueOf(String.valueOf(new StringBuffer(" (").append(((PInterfaceNode)pInterfaceNode._bases.elementAt((int)0)).pascalFullName).append(")"))));
        } else {
            this.newLine();
        }
    }

    private void writeImplImlpMethod(PInterfaceNode pInterfaceNode, PMethod pMethod, int n, int n2) {
        ContainedNode containedNode = pMethod.node;
        PInterfaceNode pInterfaceNode2 = (PInterfaceNode)containedNode._container;
        this.newLine();
        this.print(this.writeMethodTypeText(pMethod));
        switch (n) {
            case 101: {
                this.add(pInterfaceNode2.pascalImplName);
                break;
            }
            case 102: {
                this.add(pInterfaceNode.pascalImplName);
                break;
            }
        }
        this.add(String.valueOf(String.valueOf(new StringBuffer(".").append(pMethod.pascalImplName).append(" "))));
        if (pMethod.pascalParamNames.length > 0) {
            this.add("(");
            int n3 = this.horizPos();
            for (int i = 0; i < pMethod.pascalParamTypeNames.length; ++i) {
                this.add(String.valueOf(String.valueOf(new StringBuffer(" ").append(pMethod.pascalParamDirections[i]).append(" ").append(pMethod.pascalParamNames[i]).append(" : ").append(pMethod.pascalParamTypeNames[i]))));
                if (i >= pMethod.pascalParamTypeNames.length - 1) continue;
                this.add(";");
                this.newLine();
                this.indentTo(n3);
            }
            this.add(")");
        }
        if (pMethod.hasReturnValue) {
            this.add(": ".concat(String.valueOf(String.valueOf(this.writeReturnText(pMethod, n2)))));
        }
        this.addln(";");
        this.println("begin");
        this.indent(1);
        this.println("{ *************************** }");
        this.println("{ *** User code goes here *** }");
        this.println("{ *************************** }");
        this.indent(-1);
        this.println("end;");
    }

    private void writeImplImplMethod(PInterfaceNode pInterfaceNode, PMethod pMethod, int n, int n2) {
        ContainedNode containedNode = pMethod.node;
        PInterfaceNode pInterfaceNode2 = (PInterfaceNode)containedNode._container;
        this.newLine();
        this.print(this.writeMethodTypeText(pMethod));
        switch (n) {
            case 101: {
                this.add(pInterfaceNode2.pascalImplName);
                break;
            }
            case 102: {
                this.add(pInterfaceNode.pascalImplName);
                break;
            }
        }
        this.add(String.valueOf(String.valueOf(new StringBuffer(".").append(pMethod.pascalImplName).append(" "))));
        if (pMethod.pascalParamNames.length > 0) {
            this.add("(");
            int n3 = this.horizPos();
            for (int i = 0; i < pMethod.pascalParamTypeNames.length; ++i) {
                this.add(String.valueOf(String.valueOf(new StringBuffer(" ").append(pMethod.pascalParamDirections[i]).append(" ").append(pMethod.pascalParamNames[i]).append(" : ").append(pMethod.pascalParamTypeNames[i]))));
                if (i >= pMethod.pascalParamTypeNames.length - 1) continue;
                this.add(";");
                this.newLine();
                this.indentTo(n3);
            }
            this.add(")");
        }
        if (pMethod.hasReturnValue) {
            this.add(": ".concat(String.valueOf(String.valueOf(this.writeReturnText(pMethod, n2)))));
        }
        this.addln(";");
        this.println("begin");
        this.indent(1);
        this.println("{ *************************** }");
        this.println("{ *** User code goes here *** }");
        this.println("{ *************************** }");
        this.indent(-1);
        this.println("end;");
    }

    private void writeImplInheritance(PInterfaceNode pInterfaceNode) {
        this.add("(");
        if (pInterfaceNode.pascalBases.length == 0) {
            this.add("TInterfacedObject");
            this.add(", ".concat(String.valueOf(String.valueOf(pInterfaceNode.pascalFullName))));
        } else if (pInterfaceNode.pascalBases.length == 1) {
            this.add("TInterfacedObject");
            this.add(", ".concat(String.valueOf(String.valueOf(pInterfaceNode.pascalFullName))));
        } else {
            this.add(((PInterfaceNode)pInterfaceNode._bases.elementAt((int)0)).pascalImplFullName);
            for (int i = 1; i < pInterfaceNode._bases.size(); ++i) {
                this.add(", ".concat(String.valueOf(String.valueOf(pInterfaceNode.pascalBases[i].pascalFullName))));
            }
            this.add(", ".concat(String.valueOf(String.valueOf(pInterfaceNode.pascalFullName))));
        }
        this.addln(")");
    }

    private void writeImplPropertyProxyMethod(PMethod pMethod, int n) {
        switch (n) {
            case 82: {
                ContainedNode containedNode = null;
                PInterfaceNode pInterfaceNode = null;
                containedNode = pMethod.node;
                pInterfaceNode = (PInterfaceNode)containedNode._container;
                this.newLine();
                this.print(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.writeMethodTypeText(pMethod)))).append(pInterfaceNode.pascalImplName).append(".").append(pMethod.pascalImplName).append(" "))));
                if (pMethod.pascalParamNames.length > 0) {
                    this.add("(");
                    int n2 = this.horizPos();
                    for (int i = 0; i < pMethod.pascalParamTypeNames.length; ++i) {
                        this.add(String.valueOf(String.valueOf(new StringBuffer(" ").append(pMethod.pascalParamDirections[i]).append(" ").append(pMethod.pascalParamNames[i]).append(" : ").append(pMethod.pascalParamTypeNames[i]))));
                        if (i >= pMethod.pascalParamTypeNames.length - 1) continue;
                        this.add(";");
                        this.newLine();
                        this.indentTo(n2);
                    }
                    this.add(")");
                }
                if (pMethod.hasReturnValue) {
                    this.add(": ".concat(String.valueOf(String.valueOf(this.writeReturnText(pMethod, n)))));
                }
                this.addln(";");
                this.println("begin");
                this.indent(1);
                this.println("{ *************************** }");
                this.println("{ *** Optional user code  *** }");
                this.println("{ ***      goes here      *** }");
                this.println("{ *************************** }");
                if (pMethod.hasReturnValue) {
                    this.println(String.valueOf(String.valueOf(new StringBuffer("Result := _").append(pMethod.pascalName.substring(5)).append(";"))));
                } else {
                    this.println(String.valueOf(String.valueOf(new StringBuffer("_").append(pMethod.pascalParamNames[0]).append(" := ").append(pMethod.pascalParamNames[0]).append(";"))));
                }
                this.indent(-1);
                this.println("end;");
            }
        }
    }

    private void writeImplProxyAttributes(PInterfaceNode pInterfaceNode, int n) {
        ContainedNode[] containedNodeArray = pInterfaceNode._beMethods;
        if (containedNodeArray != null) {
            int n2 = containedNodeArray.length;
            block4: for (int i = 0; i < n2; ++i) {
                switch (containedNodeArray[i]._kind) {
                    case 7: {
                        continue block4;
                    }
                    case 2: {
                        this.usePascalInterfacePropertyMethodsBuffer(this._pass, pInterfaceNode);
                        this.writePropertyField((PAttributeNode)containedNodeArray[i], n);
                        continue block4;
                    }
                    default: {
                        this._ER.internalError(String.valueOf(String.valueOf(new StringBuffer("invalid kind ").append(containedNodeArray[i]._kind).append(" passed to PascalBackend.writeImplProxyAttributes(PInterfaceNode, int)"))));
                    }
                }
            }
        }
    }

    private final void writeInheritedHookMethods(PInterfaceNode pInterfaceNode, int n) {
        ContainedNode[] containedNodeArray = pInterfaceNode.pascalInheritedMethods;
        if (containedNodeArray != null) {
            int n2 = containedNodeArray.length;
            block4: for (int i = 0; i < n2; ++i) {
                switch (containedNodeArray[i]._kind) {
                    case 7: {
                        this.usePascalInterfacePropertyMethodsBuffer(this._pass, pInterfaceNode);
                        this.writeSecondaryMethod(pInterfaceNode, ((POperationNode)containedNodeArray[i]).pascalMethod, n);
                        continue block4;
                    }
                    case 2: {
                        this.usePascalPropertyMethodsBuffer(this._pass, pInterfaceNode);
                        this.writeSecondaryMethods(pInterfaceNode, (PAttributeNode)containedNodeArray[i], n);
                        continue block4;
                    }
                    default: {
                        this._ER.internalError(String.valueOf(String.valueOf(new StringBuffer("invalid kind ").append(containedNodeArray[i]._kind).append(" passed to writeSecondaryHookMethods (PInterfaceNode, int)"))));
                    }
                }
            }
        }
    }

    private void writeInheritedMethod(PInterfaceNode pInterfaceNode, PMethod pMethod, int n) {
        this.writeSecondaryMethod(pInterfaceNode, pMethod, n);
    }

    private final void writeInheritedMethods(PInterfaceNode pInterfaceNode, int n) {
        ContainedNode[] containedNodeArray = pInterfaceNode.pascalInheritedMethods;
        if (containedNodeArray != null) {
            int n2 = containedNodeArray.length;
            block4: for (int i = 0; i < n2; ++i) {
                switch (containedNodeArray[i]._kind) {
                    case 7: {
                        this.usePascalInterfaceMethodsBuffer(this._pass, pInterfaceNode);
                        this.writeSecondaryMethod(pInterfaceNode, ((POperationNode)containedNodeArray[i]).pascalMethod, n);
                        continue block4;
                    }
                    case 2: {
                        if (n == 55) {
                            this.usePascalInterfaceMethodsBuffer(this._pass, pInterfaceNode);
                        } else {
                            this.usePascalPropertyMethodsBuffer(this._pass, pInterfaceNode);
                        }
                        this.writeSecondaryMethods(pInterfaceNode, (PAttributeNode)containedNodeArray[i], n);
                        this.usePascalPropertiesBuffer(this._pass, pInterfaceNode);
                        this.writeSecondaryProperty(pInterfaceNode, (PAttributeNode)containedNodeArray[i], n);
                        continue block4;
                    }
                    default: {
                        this._ER.internalError(String.valueOf(String.valueOf(new StringBuffer("invalid kind ").append(containedNodeArray[i]._kind).append(" passed to genSecondaryMethods (PInterfacesNode, PInterfaceNode, int)"))));
                    }
                }
            }
        }
    }

    private final void writeInheritedMethods(PInterfaceNode pInterfaceNode, PAttributeNode pAttributeNode, int n) {
        this.writeSecondaryMethods(pInterfaceNode, pAttributeNode, n);
    }

    private final void writeInheritedProperty(PInterfaceNode pInterfaceNode, PAttributeNode pAttributeNode, int n) {
        this.writeSecondaryProperty(pInterfaceNode, pAttributeNode, n);
    }

    private final void writeMethod(PAttributeNode pAttributeNode, int n) {
        switch (n) {
            case 11: 
            case 31: 
            case 34: 
            case 55: 
            case 81: {
                this.writeMethod(pAttributeNode.pascalGetMethod, n);
                if (pAttributeNode._readOnly) break;
                this.writeMethod(pAttributeNode.pascalSetMethod, n);
                break;
            }
            case 35: {
                this.writeMethod(pAttributeNode.pascalGetMethod, n);
                break;
            }
            case 83: {
                break;
            }
            case 33: 
            case 56: 
            case 71: 
            case 72: {
                this.newLine();
                this.writeMethod(pAttributeNode.pascalGetMethod, n);
                if (pAttributeNode._readOnly) break;
                this.newLine();
                this.writeMethod(pAttributeNode.pascalSetMethod, n);
                break;
            }
            case 82: {
                this.newLine();
                this.writeImplPropertyProxyMethod(pAttributeNode.pascalGetMethod, n);
                if (pAttributeNode._readOnly) break;
                this.newLine();
                this.writeImplPropertyProxyMethod(pAttributeNode.pascalSetMethod, n);
                break;
            }
            case 36: {
                this.newLine();
                this.writeMethod(pAttributeNode.pascalGetMethod, n);
                break;
            }
            case 53: 
            case 54: {
                break;
            }
            default: {
                this._ER.internalError(String.valueOf(String.valueOf(new StringBuffer("invalid mode ").append(n).append(" passed to writeMethod(PAttributeNode, int)"))));
            }
        }
    }

    private final void writeMethod(PMethod pMethod, int n) {
        switch (n) {
            case 11: {
                this.indent(2);
                this.print(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.writeMethodTypeText(pMethod)))).append(pMethod.pascalName).append(" "))));
                if (pMethod.pascalParamNames != null && pMethod.pascalParamNames.length > 0) {
                    this.add("(");
                    int n2 = this.horizPos();
                    for (int i = 0; i < pMethod.pascalParamNames.length; ++i) {
                        this.add(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(pMethod.pascalParamDirections[i]))).append(" ").append(pMethod.pascalParamNames[i]).append(" : ").append(pMethod.pascalParamTypeNames[i]))));
                        if (i >= pMethod.pascalParamNames.length - 1) continue;
                        this.add(";");
                        this.newLine();
                        this.indentTo(n2);
                    }
                    this.add(")");
                }
                if (pMethod.hasReturnValue) {
                    this.add(": ".concat(String.valueOf(String.valueOf(pMethod.pascalResultTypeName))));
                }
                this.addln(";");
                this.indent(-2);
                break;
            }
            case 31: {
                this.indent(2);
                this.print(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.writeMethodTypeText(pMethod)))).append(pMethod.pascalName).append(" "))));
                if (pMethod.pascalParamNames.length > 0) {
                    this.add("(");
                    int n3 = this.horizPos();
                    for (int i = 0; i < pMethod.pascalParamTypeNames.length; ++i) {
                        this.add(String.valueOf(String.valueOf(new StringBuffer(" ").append(pMethod.pascalParamDirections[i]).append(" ").append(pMethod.pascalParamNames[i]).append(" : ").append(pMethod.pascalParamTypeNames[i]))));
                        if (i >= pMethod.pascalParamTypeNames.length - 1) continue;
                        this.add(";");
                        this.newLine();
                        this.indentTo(n3);
                    }
                    this.add(")");
                }
                if (pMethod.hasReturnValue) {
                    this.add(": ".concat(String.valueOf(String.valueOf(this.writeReturnText(pMethod, n)))));
                }
                this.addln("; virtual;");
                this.indent(-2);
                break;
            }
            case 34: {
                this.indent(2);
                this.print(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.writeMethodTypeText(pMethod)))).append(pMethod.pascalName).append(" "))));
                if (pMethod.hasReturnValue) {
                    this.addln(String.valueOf(String.valueOf(new StringBuffer(": ").append(this.writeReturnText(pMethod, n)).append("; virtual;"))));
                } else {
                    this.addln(String.valueOf(String.valueOf(new StringBuffer("( ").append(pMethod.pascalParamDirections[0]).append(" _value : ").append(pMethod.pascalParamTypeNames[0]).append(" ); virtual;"))));
                }
                this.indent(-2);
                break;
            }
            case 35: {
                this.indent(2);
                this.print("function  ".concat(String.valueOf(String.valueOf(pMethod.pascalName))));
                if (pMethod.hasReturnValue) {
                    this.add(" : ".concat(String.valueOf(String.valueOf(this.writeReturnText(pMethod, n)))));
                }
                this.addln("; virtual;");
                this.indent(-2);
                break;
            }
            case 36: {
                this.newLine();
                this.print(String.valueOf(String.valueOf(new StringBuffer("function  ").append(pMethod.pascalExceptionName).append(".").append(pMethod.pascalName))));
                if (pMethod.hasReturnValue) {
                    this.add(" : ".concat(String.valueOf(String.valueOf(this.writeReturnText(pMethod, n)))));
                }
                this.addln(";");
                this.println("begin");
                this.indent(1);
                this.println(String.valueOf(String.valueOf(new StringBuffer("Result := ").append(pMethod.pascalFieldName).append(";"))));
                this.indent(-1);
                this.println("end;");
                this.newLine();
                break;
            }
            case 33: {
                int n4;
                ContainedNode containedNode = null;
                PInterfaceNode pInterfaceNode = null;
                this.newLine();
                this.print(this.writeMethodTypeText(pMethod));
                containedNode = pMethod.node;
                pInterfaceNode = (PInterfaceNode)containedNode._container;
                this.add(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(pInterfaceNode.pascalStubName))).append(".").append(pMethod.pascalName).append(" "))));
                if (pMethod.pascalParamNames.length > 0) {
                    this.add("(");
                    int n5 = this.horizPos();
                    for (int i = 0; i < pMethod.pascalParamTypeNames.length; ++i) {
                        this.add(String.valueOf(String.valueOf(new StringBuffer(" ").append(pMethod.pascalParamDirections[i]).append(" ").append(pMethod.pascalParamNames[i]).append(" : ").append(pMethod.pascalParamTypeNames[i]))));
                        if (i >= pMethod.pascalParamTypeNames.length - 1) continue;
                        this.add(";");
                        this.newLine();
                        this.indentTo(n5);
                    }
                    this.add(")");
                }
                if (pMethod.hasReturnValue) {
                    this.add(": ".concat(String.valueOf(String.valueOf(this.writeReturnText(pMethod, n)))));
                }
                this.addln(";");
                this.println("var");
                this.indent(1);
                this.println("_Output: CORBA.OutputStream;");
                this.println("_Input : CORBA.InputStream;");
                this.indent(-1);
                this.println("begin");
                this.indent(1);
                if (pMethod.pascalWireName.equalsIgnoreCase("_create")) {
                    String string = pMethod.pascalWireName.substring(1, pMethod.pascalWireName.length());
                    this.print(String.valueOf(String.valueOf(new StringBuffer("inherited _CreateRequest('").append(string).append("',"))));
                } else {
                    this.print(String.valueOf(String.valueOf(new StringBuffer("inherited _CreateRequest('").append(pMethod.pascalWireName).append("',"))));
                }
                this.add(!pMethod.oneway ? "True" : "False");
                this.addln(", _Output);");
                for (n4 = 0; n4 < pMethod.pascalParamTypeNames.length; ++n4) {
                    if (pMethod.pascalParamModes[n4] != 0 && pMethod.pascalParamModes[n4] != 2) continue;
                    if (pMethod.pascalParamHelperFullNames[n4] != null) {
                        this.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(pMethod.pascalParamHelperFullNames[n4]))).append(".Write(_Output, ").append(pMethod.pascalParamNames[n4]).append(");"))));
                        continue;
                    }
                    this.writeWriteRangeCheck(pMethod.pascalParamTypes[n4], pMethod.pascalParamNames[n4], String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(pInterfaceNode.pascalStubName))).append(".").append(pMethod.pascalFullName))));
                    this.println(String.valueOf(String.valueOf(new StringBuffer("_Output.Write").append(pMethod.pascalParamReadWritePrefixes[n4]).append("(").append(pMethod.pascalParamNames[n4]).append(");"))));
                }
                this.println("inherited _Invoke(_Output, _Input);");
                if (pMethod.hasReturnValue) {
                    if (pMethod.pascalReturnHelperFullName != null) {
                        this.println(String.valueOf(String.valueOf(new StringBuffer("Result := ").append(pMethod.pascalReturnHelperFullName).append(".Read(_Input);"))));
                    } else {
                        this.println(String.valueOf(String.valueOf(new StringBuffer("_Input.Read").append(pMethod.pascalReturnReadWritePrefix).append("(Result);"))));
                        this.writeReadRangeCheck(pMethod.pascalResultType, "Result", String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(pInterfaceNode.pascalStubName))).append(".").append(pMethod.pascalFullName))));
                    }
                }
                for (n4 = 0; n4 < pMethod.pascalParamTypeNames.length; ++n4) {
                    if (pMethod.pascalParamModes[n4] != 1 && pMethod.pascalParamModes[n4] != 2) continue;
                    if (pMethod.pascalParamHelperFullNames[n4] != null) {
                        this.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(pMethod.pascalParamNames[n4]))).append(" := ").append(pMethod.pascalParamHelperFullNames[n4]).append(".Read(_Input);"))));
                        continue;
                    }
                    this.println(String.valueOf(String.valueOf(new StringBuffer("_Input.Read").append(pMethod.pascalParamReadWritePrefixes[n4]).append("(").append(pMethod.pascalParamNames[n4]).append(");"))));
                    this.writeReadRangeCheck(pMethod.pascalParamTypes[n4], pMethod.pascalParamNames[n4], String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(pInterfaceNode.pascalStubName))).append(".").append(pMethod.pascalFullName))));
                }
                this.indent(-1);
                this.println("end;");
                break;
            }
            case 71: {
                int n6;
                int n7;
                ContainedNode containedNode = null;
                PInterfaceNode pInterfaceNode = null;
                this.newLine();
                this.print(this.writeMethodTypeText(pMethod));
                containedNode = pMethod.node;
                pInterfaceNode = (PInterfaceNode)containedNode._container;
                this.add(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(pInterfaceNode.pascalSkeletonName))).append(".").append(pMethod.pascalName).append(" "))));
                if (pMethod.pascalParamNames.length > 0) {
                    this.add("(");
                    n7 = this.horizPos();
                    for (n6 = 0; n6 < pMethod.pascalParamTypeNames.length; ++n6) {
                        this.add(String.valueOf(String.valueOf(new StringBuffer(" ").append(pMethod.pascalParamDirections[n6]).append(" ").append(pMethod.pascalParamNames[n6]).append(" : ").append(pMethod.pascalParamTypeNames[n6]))));
                        if (n6 >= pMethod.pascalParamTypeNames.length - 1) continue;
                        this.add(";");
                        this.newLine();
                        this.indentTo(n7);
                    }
                    this.add(")");
                }
                if (pMethod.hasReturnValue) {
                    this.add(": ".concat(String.valueOf(String.valueOf(this.writeReturnText(pMethod, n)))));
                }
                this.addln(";");
                this.println("begin");
                this.indent(1);
                if (pMethod.hasReturnValue) {
                    this.print("Result := ");
                } else {
                    this.print("");
                }
                this.add("FImplementation.".concat(String.valueOf(String.valueOf(pMethod.pascalName))));
                if (pMethod.pascalParamNames.length > 0) {
                    this.add("(");
                    n7 = this.horizPos();
                    for (n6 = 0; n6 < pMethod.pascalParamTypeNames.length; ++n6) {
                        this.add(" ".concat(String.valueOf(String.valueOf(pMethod.pascalParamNames[n6]))));
                        if (n6 >= pMethod.pascalParamTypeNames.length - 1) continue;
                        this.add(",");
                        this.newLine();
                        this.indentTo(n7);
                    }
                    this.add(")");
                }
                this.addln(";");
                this.indent(-1);
                this.println("end;");
                break;
            }
            case 72: {
                int n8;
                ContainedNode containedNode = null;
                PInterfaceNode pInterfaceNode = null;
                containedNode = pMethod.node;
                pInterfaceNode = (PInterfaceNode)containedNode._container;
                this.newLine();
                this.println(String.valueOf(String.valueOf(new StringBuffer("procedure ").append(pInterfaceNode.pascalSkeletonName).append(".").append(pMethod.pascalSkeletonMarshalName).append("(const _Input: CORBA.InputStream; _Cookie: Pointer);"))));
                this.println("var");
                this.indent(1);
                this.println("_Output : CORBA.OutputStream;");
                if (pMethod.pascalParamNames.length > 0) {
                    for (n8 = 0; n8 < pMethod.pascalParamTypeNames.length; ++n8) {
                        this.println(String.valueOf(String.valueOf(new StringBuffer("_").append(pMethod.pascalParamNames[n8]).append(" : ").append(pMethod.pascalParamTypeNames[n8]).append(";"))));
                    }
                }
                if (pMethod.hasReturnValue) {
                    this.println(String.valueOf(String.valueOf(new StringBuffer("_Result : ").append(this.writeReturnText(pMethod, n)).append(";"))));
                }
                this.indent(-1);
                this.println("begin");
                this.indent(1);
                for (n8 = 0; n8 < pMethod.pascalParamTypeNames.length; ++n8) {
                    if (pMethod.pascalParamModes[n8] != 0 && pMethod.pascalParamModes[n8] != 2) continue;
                    if (pMethod.pascalParamHelperFullNames[n8] != null) {
                        this.println(String.valueOf(String.valueOf(new StringBuffer("_").append(pMethod.pascalParamNames[n8]).append(" := ").append(pMethod.pascalParamHelperFullNames[n8]).append(".Read(_Input);"))));
                        continue;
                    }
                    this.println(String.valueOf(String.valueOf(new StringBuffer("_Input.Read").append(pMethod.pascalParamReadWritePrefixes[n8]).append("(_").append(pMethod.pascalParamNames[n8]).append(");"))));
                    this.writeReadRangeCheck(pMethod.pascalParamTypes[n8], "_".concat(String.valueOf(String.valueOf(pMethod.pascalParamNames[n8]))), String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(pInterfaceNode.pascalStubName))).append(".").append(pMethod.pascalFullName))));
                }
                if (pMethod.pascalExceptions.length > 0) {
                    this.println("try");
                    this.indent(1);
                }
                if (pMethod.hasReturnValue) {
                    this.print("_Result := ");
                } else {
                    this.print("");
                }
                this.add(pMethod.pascalName);
                if (pMethod.pascalParamNames.length > 0) {
                    this.add("(");
                    n8 = this.horizPos();
                    for (int i = 0; i < pMethod.pascalParamTypeNames.length; ++i) {
                        this.add(" _".concat(String.valueOf(String.valueOf(pMethod.pascalParamNames[i]))));
                        if (i >= pMethod.pascalParamTypeNames.length - 1) continue;
                        this.add(",");
                        this.newLine();
                        this.indentTo(n8);
                    }
                    this.add(")");
                }
                this.addln(";");
                if (pMethod.pascalExceptions.length > 0) {
                    this.indent(-1);
                }
                if (pMethod.pascalExceptions.length > 0) {
                    this.println("except on E: UserException do");
                    this.indent(1);
                    this.println("begin");
                    this.indent(1);
                    this.println("GetExceptionReplyBuffer(_Cookie, _Output);");
                    this.println("E.WriteExceptionInfo(_Output);");
                    this.println("exit");
                    this.indent(-1);
                    this.println("end;");
                    this.indent(-1);
                    this.println("end;");
                }
                this.println("GetReplyBuffer(_Cookie, _Output);");
                if (pMethod.hasReturnValue) {
                    if (pMethod.pascalReturnHelperFullName != null) {
                        this.println(String.valueOf(String.valueOf(pMethod.pascalReturnHelperFullName)).concat(".Write(_Output, _Result);"));
                    } else {
                        this.writeWriteRangeCheck(pMethod.pascalResultType, "_Result", String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(pInterfaceNode.pascalStubName))).append(".").append(pMethod.pascalFullName))));
                        this.println(String.valueOf(String.valueOf(new StringBuffer("_Output.Write").append(pMethod.pascalReturnReadWritePrefix).append("(_Result);"))));
                    }
                }
                for (n8 = 0; n8 < pMethod.pascalParamTypeNames.length; ++n8) {
                    if (pMethod.pascalParamModes[n8] != 1 && pMethod.pascalParamModes[n8] != 2) continue;
                    if (pMethod.pascalParamHelperFullNames[n8] != null) {
                        this.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(pMethod.pascalParamHelperFullNames[n8]))).append(".Write(_Output, ").append("_").append(pMethod.pascalParamNames[n8]).append(");"))));
                        continue;
                    }
                    this.println(String.valueOf(String.valueOf(new StringBuffer("_Output.Write").append(pMethod.pascalParamReadWritePrefixes[n8]).append("(").append("_").append(pMethod.pascalParamNames[n8]).append(");"))));
                    this.writeReadRangeCheck(pMethod.pascalParamTypes[n8], "_".concat(String.valueOf(String.valueOf(pMethod.pascalParamNames[n8]))), String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(pInterfaceNode.pascalStubName))).append(".").append(pMethod.pascalFullName))));
                }
                this.indent(-1);
                this.println("end;");
                break;
            }
            case 55: {
                this.indent(2);
                this.print(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.writeMethodTypeText(pMethod)))).append(pMethod.pascalName).append(" "))));
                if (pMethod.pascalParamNames.length > 0) {
                    this.add("(");
                    int n9 = this.horizPos();
                    for (int i = 0; i < pMethod.pascalParamTypeNames.length; ++i) {
                        this.add(String.valueOf(String.valueOf(new StringBuffer(" ").append(pMethod.pascalParamDirections[i]).append(" ").append(pMethod.pascalParamNames[i]).append(" : ").append(pMethod.pascalParamTypeNames[i]))));
                        if (i >= pMethod.pascalParamTypeNames.length - 1) continue;
                        this.add(";");
                        this.newLine();
                        this.indentTo(n9);
                    }
                    this.add(")");
                }
                if (pMethod.hasReturnValue) {
                    this.add(": ".concat(String.valueOf(String.valueOf(this.writeReturnText(pMethod, n)))));
                }
                this.addln(";");
                this.indent(-2);
                break;
            }
            case 56: {
                this.indent(2);
                this.println(String.valueOf(String.valueOf(new StringBuffer("procedure ").append(pMethod.pascalSkeletonMarshalName).append("(const _Input: CORBA.InputStream; _Cookie: Pointer);"))));
                this.indent(-2);
                break;
            }
            case 81: {
                this.indent(2);
                this.print(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.writeMethodTypeText(pMethod)))).append(pMethod.pascalName).append(" "))));
                if (pMethod.pascalParamNames.length > 0) {
                    this.add("(");
                    int n10 = this.horizPos();
                    for (int i = 0; i < pMethod.pascalParamTypeNames.length; ++i) {
                        this.add(String.valueOf(String.valueOf(new StringBuffer(" ").append(pMethod.pascalParamDirections[i]).append(" ").append(pMethod.pascalParamNames[i]).append(" : ").append(pMethod.pascalParamTypeNames[i]))));
                        if (i >= pMethod.pascalParamTypeNames.length - 1) continue;
                        this.add(";");
                        this.newLine();
                        this.indentTo(n10);
                    }
                    this.add(")");
                }
                if (pMethod.hasReturnValue) {
                    this.add(": ".concat(String.valueOf(String.valueOf(this.writeReturnText(pMethod, n)))));
                }
                this.addln(";");
                this.indent(-2);
                break;
            }
            case 82: {
                ContainedNode containedNode = null;
                PInterfaceNode pInterfaceNode = null;
                containedNode = pMethod.node;
                pInterfaceNode = (PInterfaceNode)containedNode._container;
                this.newLine();
                this.print(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.writeMethodTypeText(pMethod)))).append(pInterfaceNode.pascalImplName).append(".").append(pMethod.pascalImplName).append(" "))));
                if (pMethod.pascalParamNames.length > 0) {
                    this.add("(");
                    int n11 = this.horizPos();
                    for (int i = 0; i < pMethod.pascalParamTypeNames.length; ++i) {
                        this.add(String.valueOf(String.valueOf(new StringBuffer(" ").append(pMethod.pascalParamDirections[i]).append(" ").append(pMethod.pascalParamNames[i]).append(" : ").append(pMethod.pascalParamTypeNames[i]))));
                        if (i >= pMethod.pascalParamTypeNames.length - 1) continue;
                        this.add(";");
                        this.newLine();
                        this.indentTo(n11);
                    }
                    this.add(")");
                }
                if (pMethod.hasReturnValue) {
                    this.add(": ".concat(String.valueOf(String.valueOf(this.writeReturnText(pMethod, n)))));
                }
                this.addln(";");
                this.println("begin");
                this.indent(1);
                this.println("{ *************************** }");
                this.println("{ *** User code goes here *** }");
                this.println("{ *************************** }");
                this.indent(-1);
                this.println("end;");
                break;
            }
            case 83: {
                break;
            }
            default: {
                this._ER.internalError(String.valueOf(String.valueOf(new StringBuffer("invalid mode ").append(n).append(" passed to writeMethod(PMethod, int)"))));
            }
        }
    }

    private final void writeMethod(POperationNode pOperationNode, int n) {
        int n2 = -1;
        switch (n) {
            case 11: 
            case 31: 
            case 81: {
                n2 = 2;
                break;
            }
            case 33: 
            case 55: 
            case 56: 
            case 71: 
            case 72: 
            case 82: {
                n2 = 1;
                break;
            }
            case 83: {
                break;
            }
            default: {
                this._ER.internalError(String.valueOf(String.valueOf(new StringBuffer("invalid mode ").append(n).append(" passed to writeMethod(POperationNode)"))));
            }
        }
        if (n2 > -1) {
            this.indent(n2);
            this.writeIdlSectionComment(pOperationNode);
            this.indent(-1 * n2);
            this.writeMethod(pOperationNode.pascalMethod, n);
        }
    }

    private String writeMethodTypeText(PMethod pMethod) {
        return pMethod.hasReturnValue ? "function  " : "procedure ";
    }

    private final void writeMethods(PExceptionNode pExceptionNode, int n) {
        PAttributeNode[] pAttributeNodeArray = pExceptionNode.pascalMembers;
        pExceptionNode.componentBuffers.reset(this._pass);
        if (pAttributeNodeArray != null) {
            int n2 = pAttributeNodeArray.length;
            for (int i = 0; i < n2; ++i) {
                this.usePascalPropertyMethodsBuffer(this._pass, pExceptionNode);
                this.writeMethod(pAttributeNodeArray[i], n);
                this.usePascalPropertiesBuffer(this._pass, pExceptionNode);
                this.writeProperty(pAttributeNodeArray[i], n);
                this.usePascalExceptionFieldsBuffer(this._pass, pExceptionNode);
                this.writePropertyField(pAttributeNodeArray[i], n);
            }
        }
    }

    private final void writeMethods(PInterfaceNode pInterfaceNode, int n) {
        ContainedNode[] containedNodeArray = pInterfaceNode._beMethods;
        if (containedNodeArray != null) {
            int n2 = containedNodeArray.length;
            block4: for (int i = 0; i < n2; ++i) {
                switch (containedNodeArray[i]._kind) {
                    case 7: {
                        this.usePascalInterfaceMethodsBuffer(this._pass, pInterfaceNode);
                        this.writeMethod((POperationNode)containedNodeArray[i], n);
                        continue block4;
                    }
                    case 2: {
                        if (n == 55) {
                            this.usePascalInterfaceMethodsBuffer(this._pass, pInterfaceNode);
                        } else {
                            this.usePascalPropertyMethodsBuffer(this._pass, pInterfaceNode);
                        }
                        this.writeMethod((PAttributeNode)containedNodeArray[i], n);
                        this.usePascalPropertiesBuffer(this._pass, pInterfaceNode);
                        this.writeProperty((PAttributeNode)containedNodeArray[i], n);
                        continue block4;
                    }
                    default: {
                        this._ER.internalError(String.valueOf(String.valueOf(new StringBuffer("invalid kind ").append(containedNodeArray[i]._kind).append(" passed to writeMethods (PInterfaceNode, int)"))));
                    }
                }
            }
        }
    }

    private final void writeMethods(PStructNode pStructNode, int n) {
        PAttributeNode[] pAttributeNodeArray = pStructNode.pascalMembers;
        pStructNode.componentBuffers.reset(this._pass);
        if (pAttributeNodeArray != null) {
            int n2 = pAttributeNodeArray.length;
            for (int i = 0; i < n2; ++i) {
                this.usePascalPropertyMethodsBuffer(this._pass, pStructNode);
                this.writeMethod(pAttributeNodeArray[i], n);
                this.usePascalPropertiesBuffer(this._pass, pStructNode);
                this.writeProperty(pAttributeNodeArray[i], n);
            }
        }
    }

    private final void writeMethods(PUnionNode pUnionNode, int n) {
        PAttributeNode[] pAttributeNodeArray = pUnionNode.pascalMembers;
        pUnionNode.componentBuffers.reset(this._pass);
        if (pAttributeNodeArray != null) {
            int n2 = pAttributeNodeArray.length;
            for (int i = 0; i < n2; ++i) {
                this.usePascalPropertyMethodsBuffer(this._pass, pUnionNode);
                this.writeMethod(pAttributeNodeArray[i], n);
                this.usePascalPropertiesBuffer(this._pass, pUnionNode);
                this.writeProperty(pAttributeNodeArray[i], n);
            }
        }
    }

    private final void writePreambleComments(int n, String string) {
        Date date = new Date();
        this.newLine(n);
        this.writeIdlFixedComment(n, String.valueOf(String.valueOf(new StringBuffer("This file was generated on ").append(date.toGMTString()).append(" by version ").append("03.03.03.C1.A2"))));
        this.writeIdlFixedComment(n, "of the Inprise VisiBroker idl2pas CORBA IDL compiler.");
        this.newLine(n);
        this.writeIdlFixedComment(n, "Please do not edit the contents of this file. You should instead edit and");
        if (string.length() > 17) {
            this.writeIdlFixedComment(n, "recompile the original IDL which was located in the file");
            this.writeIdlFixedComment(n, String.valueOf(String.valueOf(string)).concat("."));
        } else {
            this.writeIdlFixedComment(n, String.valueOf(String.valueOf(new StringBuffer("recompile the original IDL which was located in the file ").append(string).append("."))));
        }
    }

    private final void writePreambleImplComments(int n, String string) {
        Date date = new Date();
        this.newLine(n);
        this.writeIdlFixedComment(n, String.valueOf(String.valueOf(new StringBuffer("This file was generated on ").append(date.toGMTString()).append(" by version ").append("03.03.03.C1.A2"))));
        this.writeIdlFixedComment(n, "of the Inprise VisiBroker idl2pas CORBA IDL compiler.");
        this.newLine(n);
    }

    private final void writeProperty(PAttributeNode pAttributeNode, int n) {
        switch (n) {
            case 11: 
            case 31: 
            case 81: {
                this.indent(2);
                this.print(String.valueOf(String.valueOf(new StringBuffer("property  ").append(pAttributeNode.pascalName).append(" : ").append(this.writeReturnText(pAttributeNode.pascalGetMethod, n)).append(" read ").append(pAttributeNode.pascalGetMethod.pascalName))));
                if (!pAttributeNode._readOnly) {
                    this.add(" write ".concat(String.valueOf(String.valueOf(pAttributeNode.pascalSetMethod.pascalName))));
                }
                this.addln(";");
                this.indent(-2);
                break;
            }
            case 34: {
                this.indent(2);
                this.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(pAttributeNode.pascalName))).append(" : ").append(this.writeReturnText(pAttributeNode.pascalGetMethod, n)).append(";"))));
                this.indent(-2);
                break;
            }
            case 35: {
                this.indent(2);
                this.print(String.valueOf(String.valueOf(new StringBuffer("property  ").append(pAttributeNode.pascalName).append(" : ").append(this.writeReturnText(pAttributeNode.pascalGetMethod, n)).append(" read ").append(pAttributeNode.pascalGetMethod.pascalName))));
                if (!pAttributeNode._readOnly) {
                    this.add(" write ".concat(String.valueOf(String.valueOf(pAttributeNode.pascalSetMethod.pascalName))));
                }
                this.addln(";");
                this.indent(-2);
                break;
            }
            case 82: {
                this.print(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(pAttributeNode.pascalName))).append(" : ").append(this.writeReturnText(pAttributeNode.pascalGetMethod, n)).append(";"))));
                break;
            }
            case 33: 
            case 36: 
            case 53: 
            case 54: 
            case 55: 
            case 71: 
            case 72: 
            case 83: {
                break;
            }
            default: {
                this._ER.internalError(String.valueOf(String.valueOf(new StringBuffer("invalid mode ").append(n).append(" passed to writeProperty(final PAttributeNode, int)"))));
            }
        }
    }

    private final void writePropertyField(PAttributeNode pAttributeNode, int n) {
        switch (n) {
            case 11: 
            case 31: 
            case 34: {
                break;
            }
            case 35: {
                this.indent(2);
                this.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(pAttributeNode.pascalFieldName))).append(" : ").append(this.writeReturnText(pAttributeNode.pascalGetMethod, n)).append(";"))));
                this.indent(-2);
                break;
            }
            case 33: 
            case 36: 
            case 53: 
            case 54: {
                break;
            }
            case 83: {
                this.indent(2);
                this.println(String.valueOf(String.valueOf(new StringBuffer("_").append(pAttributeNode.pascalName).append(" : ").append(this.writeReturnText(pAttributeNode.pascalGetMethod, n)).append(";"))));
                this.indent(-2);
                break;
            }
            default: {
                this._ER.internalError(String.valueOf(String.valueOf(new StringBuffer("invalid mode ").append(n).append(" passed to genPropertyField (final PAttributeNode, int)"))));
            }
        }
    }

    private void writeReadElement(PUnionNode pUnionNode) {
        this.print("else ");
        if (this.needsRangeCheck(pUnionNode.pascalMemberTypes[pUnionNode._defaultIndex])) {
            this.println("begin");
        }
        if (pUnionNode.pascalMemberHelperFullNames[pUnionNode._defaultIndex] != null) {
            this.add(String.valueOf(String.valueOf(new StringBuffer("_Value.").append(pUnionNode.pascalMemberNames[pUnionNode._defaultIndex]).append(" := ").append(pUnionNode.pascalMemberHelperFullNames[pUnionNode._defaultIndex]).append(".Read(_Input);"))));
        } else {
            this.add(String.valueOf(String.valueOf(new StringBuffer("_Input.Read").append(pUnionNode.pascalMemberReadWritePrefixes[pUnionNode._defaultIndex]).append("(_Value.").append(pUnionNode.pascalMemberNames[pUnionNode._defaultIndex]).append(");"))));
        }
        this.writeReadRangeCheck(pUnionNode.pascalMemberTypes[pUnionNode._defaultIndex], "_Value.".concat(String.valueOf(String.valueOf(pUnionNode.pascalMemberNames[pUnionNode._defaultIndex]))), pUnionNode.pascalFullName, true, true);
        if (this.needsRangeCheck(pUnionNode.pascalMemberTypes[pUnionNode._defaultIndex])) {
            this.println("end;");
        }
    }

    private void writeReadElement(PUnionNode pUnionNode, int n, int n2) {
        this.print(String.valueOf(String.valueOf(pUnionNode.pascalMemberLabels[n][n2])).concat(" : "));
        if (this.needsRangeCheck(pUnionNode.pascalMemberTypes[n])) {
            this.println("begin");
        }
        if (pUnionNode.pascalMemberHelperFullNames[n] != null) {
            this.add(String.valueOf(String.valueOf(new StringBuffer("_Value.").append(pUnionNode.pascalMemberNames[n]).append(" := ").append(pUnionNode.pascalMemberHelperFullNames[n]).append(".Read(_Input); "))));
        } else {
            this.add(String.valueOf(String.valueOf(new StringBuffer("_Input.Read").append(pUnionNode.pascalMemberReadWritePrefixes[n]).append("(_Value.").append(pUnionNode.pascalMemberNames[n]).append("); "))));
        }
        this.writeReadRangeCheck(pUnionNode.pascalMemberTypes[n], "_Value.".concat(String.valueOf(String.valueOf(pUnionNode.pascalMemberNames[n]))), pUnionNode.pascalFullName, true, false);
        this.newLine();
        if (this.needsRangeCheck(pUnionNode.pascalMemberTypes[n])) {
            this.println("end;");
        }
    }

    private void writeReadRangeCheck(Type type, String string, String string2) {
        this.writeReadRangeCheck(type, string, string2, false, true);
    }

    private void writeReadRangeCheck(Type type, String string, String string2, boolean bl, boolean bl2) {
        if (this.needsRangeCheck(type)) {
            if (!bl) {
                this.print("");
            }
            this.add(String.valueOf(String.valueOf(new StringBuffer("if (").append(string).append(" < 0) then raise DATA_CONVERSION.Create(0, COMPLETED_YES);"))));
            if (bl2) {
                this.newLine();
            } else {
                this.add(" ");
            }
        }
    }

    private String writeReturnText(PMethod pMethod, int n) {
        return pMethod.hasReturnValue ? pMethod.pascalResultTypeName : "";
    }

    private final void writeSecondaryHookMethods(PInterfaceNode pInterfaceNode, int n) {
        ContainedNode[] containedNodeArray = pInterfaceNode.pascalSecondaryMethods;
        if (containedNodeArray != null) {
            int n2 = containedNodeArray.length;
            block4: for (int i = 0; i < n2; ++i) {
                switch (containedNodeArray[i]._kind) {
                    case 7: {
                        this.usePascalInterfacePropertyMethodsBuffer(this._pass, pInterfaceNode);
                        this.writeSecondaryMethod(pInterfaceNode, ((POperationNode)containedNodeArray[i]).pascalMethod, n);
                        continue block4;
                    }
                    case 2: {
                        this.usePascalPropertyMethodsBuffer(this._pass, pInterfaceNode);
                        this.writeSecondaryMethods(pInterfaceNode, (PAttributeNode)containedNodeArray[i], n);
                        continue block4;
                    }
                    default: {
                        this._ER.internalError(String.valueOf(String.valueOf(new StringBuffer("invalid kind ").append(containedNodeArray[i]._kind).append(" passed to PascalBackend.writeSecondaryHookMethods(PInterfaceNode, int)"))));
                    }
                }
            }
        }
    }

    private void writeSecondaryMethod(PInterfaceNode pInterfaceNode, PMethod pMethod, int n) {
        switch (n) {
            case 71: {
                this.writeSkelImpMethod(pInterfaceNode, pMethod, 102, n);
                break;
            }
            case 33: {
                this.writeStubImpMethod(pInterfaceNode, pMethod, 102, n);
                break;
            }
            case 72: {
                this.writeSkelMarshalMethod(pInterfaceNode, pMethod, 102, n);
                break;
            }
            case 82: {
                this.writeImplImplMethod(pInterfaceNode, pMethod, 102, n);
                break;
            }
            default: {
                this.writeMethod(pMethod, n);
            }
        }
    }

    private final void writeSecondaryMethods(PInterfaceNode pInterfaceNode, int n) {
        ContainedNode[] containedNodeArray = pInterfaceNode.pascalSecondaryMethods;
        if (containedNodeArray != null) {
            int n2 = containedNodeArray.length;
            block4: for (int i = 0; i < n2; ++i) {
                switch (containedNodeArray[i]._kind) {
                    case 7: {
                        this.usePascalInterfaceMethodsBuffer(this._pass, pInterfaceNode);
                        this.writeSecondaryMethod(pInterfaceNode, ((POperationNode)containedNodeArray[i]).pascalMethod, n);
                        continue block4;
                    }
                    case 2: {
                        if (n == 55) {
                            this.usePascalInterfaceMethodsBuffer(this._pass, pInterfaceNode);
                        } else {
                            this.usePascalPropertyMethodsBuffer(this._pass, pInterfaceNode);
                        }
                        this.writeSecondaryMethods(pInterfaceNode, (PAttributeNode)containedNodeArray[i], n);
                        this.usePascalPropertiesBuffer(this._pass, pInterfaceNode);
                        this.writeSecondaryProperty(pInterfaceNode, (PAttributeNode)containedNodeArray[i], n);
                        continue block4;
                    }
                    default: {
                        this._ER.internalError(String.valueOf(String.valueOf(new StringBuffer("invalid kind ").append(containedNodeArray[i]._kind).append(" passed to PascalBackend.genSecondaryMethods (PInterfacesNode, PInterfaceNode, int)"))));
                    }
                }
            }
        }
    }

    private final void writeSecondaryMethods(PInterfaceNode pInterfaceNode, PAttributeNode pAttributeNode, int n) {
        if (n != 33) {
            this.writeMethod(pAttributeNode, n);
        } else {
            this.writeSecondaryMethod(pInterfaceNode, pAttributeNode.pascalGetMethod, n);
            if (!pAttributeNode._readOnly) {
                this.newLine();
                this.writeSecondaryMethod(pInterfaceNode, pAttributeNode.pascalSetMethod, n);
            }
        }
    }

    private final void writeSecondaryProperty(PInterfaceNode pInterfaceNode, PAttributeNode pAttributeNode, int n) {
        block0: {
            if (n == 33) break block0;
            this.writeProperty(pAttributeNode, n);
        }
    }

    private void writeSkelImpMethod(PInterfaceNode pInterfaceNode, PMethod pMethod, int n, int n2) {
        int n3;
        int n4;
        ContainedNode containedNode = null;
        PInterfaceNode pInterfaceNode2 = null;
        containedNode = pMethod.node;
        pInterfaceNode2 = (PInterfaceNode)containedNode._container;
        this.newLine();
        this.print(this.writeMethodTypeText(pMethod));
        switch (n) {
            case 101: {
                this.add(pInterfaceNode2.pascalSkeletonName);
                break;
            }
            case 102: {
                this.add(pInterfaceNode.pascalSkeletonName);
                break;
            }
        }
        this.add(String.valueOf(String.valueOf(new StringBuffer(".").append(pMethod.pascalName).append(" "))));
        if (pMethod.pascalParamNames.length > 0) {
            this.add("(");
            n4 = this.horizPos();
            for (n3 = 0; n3 < pMethod.pascalParamTypeNames.length; ++n3) {
                this.add(String.valueOf(String.valueOf(new StringBuffer(" ").append(pMethod.pascalParamDirections[n3]).append(" ").append(pMethod.pascalParamNames[n3]).append(" : ").append(pMethod.pascalParamTypeNames[n3]))));
                if (n3 >= pMethod.pascalParamTypeNames.length - 1) continue;
                this.add(";");
                this.newLine();
                this.indentTo(n4);
            }
            this.add(")");
        }
        if (pMethod.hasReturnValue) {
            this.add(": ".concat(String.valueOf(String.valueOf(this.writeReturnText(pMethod, n2)))));
        }
        this.addln(";");
        this.println("begin");
        this.indent(1);
        if (pMethod.hasReturnValue) {
            this.print("Result := ");
        } else {
            this.print("");
        }
        this.add("FImplementation.".concat(String.valueOf(String.valueOf(pMethod.pascalName))));
        if (pMethod.pascalParamNames.length > 0) {
            this.add("(");
            n4 = this.horizPos();
            for (n3 = 0; n3 < pMethod.pascalParamTypeNames.length; ++n3) {
                this.add(" ".concat(String.valueOf(String.valueOf(pMethod.pascalParamNames[n3]))));
                if (n3 >= pMethod.pascalParamTypeNames.length - 1) continue;
                this.add(",");
                this.newLine();
                this.indentTo(n4);
            }
            this.add(")");
        }
        this.addln(";");
        this.indent(-1);
        this.println("end;");
    }

    private void writeSkelInheritance(PInterfaceNode pInterfaceNode) {
        this.add("(");
        if (pInterfaceNode.pascalBases.length == 0) {
            this.add("CORBA.TCorbaObject");
        } else if (pInterfaceNode.pascalBases.length == 1) {
            this.add("CORBA.TCorbaObject");
        } else {
            this.add(((PInterfaceNode)pInterfaceNode._bases.elementAt((int)0)).pascalSkeletonFullName);
        }
        this.add(", ".concat(String.valueOf(String.valueOf(pInterfaceNode.pascalFullName))));
        this.addln(")");
    }

    private void writeSkelMarshalMethod(PInterfaceNode pInterfaceNode, PMethod pMethod, int n, int n2) {
        int n3;
        ContainedNode containedNode = null;
        PInterfaceNode pInterfaceNode2 = null;
        containedNode = pMethod.node;
        pInterfaceNode2 = (PInterfaceNode)containedNode._container;
        this.newLine();
        this.print("procedure ");
        switch (n) {
            case 101: {
                this.add(pInterfaceNode2.pascalSkeletonName);
                break;
            }
            case 102: {
                this.add(pInterfaceNode.pascalSkeletonName);
                break;
            }
        }
        this.addln(String.valueOf(String.valueOf(new StringBuffer(".").append(pMethod.pascalSkeletonMarshalName).append("(const _Input: CORBA.InputStream; _Cookie: Pointer);"))));
        this.println("var");
        this.indent(1);
        this.println("_Output : CORBA.OutputStream;");
        if (pMethod.pascalParamNames.length > 0) {
            for (n3 = 0; n3 < pMethod.pascalParamTypeNames.length; ++n3) {
                this.println(String.valueOf(String.valueOf(new StringBuffer("_").append(pMethod.pascalParamNames[n3]).append(" : ").append(pMethod.pascalParamTypeNames[n3]).append(";"))));
            }
        }
        if (pMethod.hasReturnValue) {
            this.println(String.valueOf(String.valueOf(new StringBuffer("_Result : ").append(this.writeReturnText(pMethod, n2)).append(";"))));
        }
        this.indent(-1);
        this.println("begin");
        this.indent(1);
        for (n3 = 0; n3 < pMethod.pascalParamTypeNames.length; ++n3) {
            if (pMethod.pascalParamModes[n3] != 0 && pMethod.pascalParamModes[n3] != 2) continue;
            if (pMethod.pascalParamHelperFullNames[n3] != null) {
                this.println(String.valueOf(String.valueOf(new StringBuffer("_").append(pMethod.pascalParamNames[n3]).append(" := ").append(pMethod.pascalParamHelperFullNames[n3]).append(".Read(_Input);"))));
                continue;
            }
            this.println(String.valueOf(String.valueOf(new StringBuffer("_Input.Read").append(pMethod.pascalParamReadWritePrefixes[n3]).append("(_").append(pMethod.pascalParamNames[n3]).append(");"))));
            this.writeReadRangeCheck(pMethod.pascalParamTypes[n3], "_".concat(String.valueOf(String.valueOf(pMethod.pascalParamNames[n3]))), String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(pInterfaceNode2.pascalStubName))).append(".").append(pMethod.pascalFullName))));
        }
        if (pMethod.hasReturnValue) {
            this.print("_Result := ");
        } else {
            this.print("");
        }
        this.add(pMethod.pascalName);
        if (pMethod.pascalParamNames.length > 0) {
            this.add("(");
            n3 = this.horizPos();
            for (int i = 0; i < pMethod.pascalParamTypeNames.length; ++i) {
                this.add(" _".concat(String.valueOf(String.valueOf(pMethod.pascalParamNames[i]))));
                if (i >= pMethod.pascalParamTypeNames.length - 1) continue;
                this.add(",");
                this.newLine();
                this.indentTo(n3);
            }
            this.add(")");
        }
        this.addln(";");
        this.println("GetReplyBuffer(_Cookie, _Output);");
        if (pMethod.hasReturnValue) {
            if (pMethod.pascalReturnHelperFullName != null) {
                this.println(String.valueOf(String.valueOf(pMethod.pascalReturnHelperFullName)).concat(".Write(_Output, _Result);"));
            } else {
                this.writeWriteRangeCheck(pMethod.pascalResultType, "_Result", String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(pInterfaceNode2.pascalStubName))).append(".").append(pMethod.pascalFullName))));
                this.println(String.valueOf(String.valueOf(new StringBuffer("_Output.Write").append(pMethod.pascalReturnReadWritePrefix).append("(_Result);"))));
            }
        }
        for (n3 = 0; n3 < pMethod.pascalParamTypeNames.length; ++n3) {
            if (pMethod.pascalParamModes[n3] != 1 && pMethod.pascalParamModes[n3] != 2) continue;
            if (pMethod.pascalParamHelperFullNames[n3] != null) {
                this.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(pMethod.pascalParamHelperFullNames[n3]))).append(".Write(_Output, ").append("_").append(pMethod.pascalParamNames[n3]).append(");"))));
                continue;
            }
            this.println(String.valueOf(String.valueOf(new StringBuffer("_Output.Write").append(pMethod.pascalParamReadWritePrefixes[n3]).append("(").append("_").append(pMethod.pascalParamNames[n3]).append(");"))));
            this.writeReadRangeCheck(pMethod.pascalParamTypes[n3], "_".concat(String.valueOf(String.valueOf(pMethod.pascalParamNames[n3]))), String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(pInterfaceNode2.pascalStubName))).append(".").append(pMethod.pascalFullName))));
        }
        this.indent(-1);
        this.println("end;");
    }

    private void writeStubImpMethod(PInterfaceNode pInterfaceNode, PMethod pMethod, int n, int n2) {
        int n3;
        ContainedNode containedNode = null;
        PInterfaceNode pInterfaceNode2 = null;
        containedNode = pMethod.node;
        pInterfaceNode2 = (PInterfaceNode)containedNode._container;
        this.newLine();
        this.print(this.writeMethodTypeText(pMethod));
        switch (n) {
            case 101: {
                this.add(pInterfaceNode2.pascalName);
                break;
            }
            case 102: {
                this.add(pInterfaceNode.pascalStubName);
                break;
            }
        }
        this.add(String.valueOf(String.valueOf(new StringBuffer(".").append(pMethod.pascalName).append(" "))));
        if (pMethod.pascalParamNames.length > 0) {
            this.add("(");
            n3 = this.horizPos();
            for (int i = 0; i < pMethod.pascalParamTypeNames.length; ++i) {
                this.add(String.valueOf(String.valueOf(new StringBuffer(" ").append(pMethod.pascalParamDirections[i]).append(" ").append(pMethod.pascalParamNames[i]).append(" : ").append(pMethod.pascalParamTypeNames[i]))));
                if (i >= pMethod.pascalParamTypeNames.length - 1) continue;
                this.add(";");
                this.newLine();
                this.indentTo(n3);
            }
            this.add(")");
        }
        if (pMethod.hasReturnValue) {
            this.add(": ".concat(String.valueOf(String.valueOf(this.writeReturnText(pMethod, n2)))));
        }
        this.addln(";");
        this.println("var");
        this.indent(1);
        this.println("_Output: CORBA.OutputStream;");
        this.println("_Input : CORBA.InputStream;");
        this.indent(-1);
        this.println("begin");
        this.indent(1);
        this.print(String.valueOf(String.valueOf(new StringBuffer("inherited _CreateRequest('").append(pMethod.pascalWireName).append("',"))));
        this.add(!pMethod.oneway ? "True" : "False");
        this.addln(", _Output);");
        for (n3 = 0; n3 < pMethod.pascalParamTypeNames.length; ++n3) {
            if (pMethod.pascalParamModes[n3] != 0 && pMethod.pascalParamModes[n3] != 2) continue;
            if (pMethod.pascalParamHelperFullNames[n3] != null) {
                this.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(pMethod.pascalParamHelperFullNames[n3]))).append(".Write(_Output, ").append(pMethod.pascalParamNames[n3]).append(");"))));
                continue;
            }
            this.writeWriteRangeCheck(pMethod.pascalParamTypes[n3], pMethod.pascalParamNames[n3], String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(pInterfaceNode2.pascalStubName))).append(".").append(pMethod.pascalFullName))));
            this.println(String.valueOf(String.valueOf(new StringBuffer("_Output.Write").append(pMethod.pascalParamReadWritePrefixes[n3]).append("(").append(pMethod.pascalParamNames[n3]).append(");"))));
        }
        this.println("inherited _Invoke(_Output, _Input);");
        if (pMethod.hasReturnValue) {
            if (pMethod.pascalReturnHelperFullName != null) {
                this.println(String.valueOf(String.valueOf(new StringBuffer("Result := ").append(pMethod.pascalReturnHelperFullName).append(".Read(_Input);"))));
            } else {
                this.println(String.valueOf(String.valueOf(new StringBuffer("_Input.Read").append(pMethod.pascalReturnReadWritePrefix).append("(Result);"))));
                this.writeReadRangeCheck(pMethod.pascalResultType, "Result", String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(pInterfaceNode2.pascalStubName))).append(".").append(pMethod.pascalFullName))));
            }
        }
        for (n3 = 0; n3 < pMethod.pascalParamTypeNames.length; ++n3) {
            if (pMethod.pascalParamModes[n3] != 1 && pMethod.pascalParamModes[n3] != 2) continue;
            if (pMethod.pascalParamHelperFullNames[n3] != null) {
                this.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(pMethod.pascalParamNames[n3]))).append(" := ").append(pMethod.pascalParamHelperFullNames[n3]).append(".Read(_Input);"))));
                continue;
            }
            this.println(String.valueOf(String.valueOf(new StringBuffer("_Input.Read").append(pMethod.pascalParamReadWritePrefixes[n3]).append("(").append(pMethod.pascalParamNames[n3]).append(");"))));
            this.writeReadRangeCheck(pMethod.pascalParamTypes[n3], pMethod.pascalParamNames[n3], String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(pInterfaceNode2.pascalStubName))).append(".").append(pMethod.pascalFullName))));
        }
        this.indent(-1);
        this.println("end;");
    }

    private void writeStubInheritance(PInterfaceNode pInterfaceNode) {
        this.add("(");
        if (pInterfaceNode.pascalBases.length == 0) {
            this.add("CORBA.TCORBAObject");
            this.add(", ".concat(String.valueOf(String.valueOf(pInterfaceNode.pascalFullName))));
        } else if (pInterfaceNode.pascalBases.length == 1) {
            this.add("CORBA.TCORBAObject");
            this.add(", ".concat(String.valueOf(String.valueOf(pInterfaceNode.pascalFullName))));
        } else {
            this.add(((PInterfaceNode)pInterfaceNode._bases.elementAt((int)0)).pascalStubFullName);
            for (int i = 1; i < pInterfaceNode._bases.size(); ++i) {
                this.add(", ".concat(String.valueOf(String.valueOf(pInterfaceNode.pascalBases[i].pascalFullName))));
            }
            this.add(", ".concat(String.valueOf(String.valueOf(pInterfaceNode.pascalFullName))));
        }
        this.addln(")");
    }

    private void writeTypecodeSequenceDefaultElement(PUnionNode pUnionNode, int n) {
        this.println(String.valueOf(String.valueOf(new StringBuffer("Seq[").append(n).append("].Member_Name := '").append(pUnionNode.pascalMemberNames[pUnionNode._defaultIndex]).append("';"))));
        this.println(String.valueOf(String.valueOf(new StringBuffer("Seq[").append(n).append("].Member_Label:= ").append(pUnionNode.pascalDefaultDescValue).append(";"))));
        this.print(String.valueOf(String.valueOf(new StringBuffer("Seq[").append(n).append("].Member_TC   := "))));
        if (pUnionNode.pascalMemberTkHelperFullNames[pUnionNode._defaultIndex] != null) {
            this.addln(String.valueOf(String.valueOf(pUnionNode.pascalMemberTkHelperFullNames[pUnionNode._defaultIndex])).concat(".TypeCode;"));
        } else {
            this.addln(String.valueOf(String.valueOf(new StringBuffer("ORB.CreateTC(Integer(").append(pUnionNode.pascalMemberTkNames[pUnionNode._defaultIndex]).append("));"))));
        }
    }

    private void writeTypecodeSequenceElement(PUnionNode pUnionNode, int n, int n2, int n3) {
        this.println(String.valueOf(String.valueOf(new StringBuffer("Seq[").append(n3).append("].Member_Name := '").append(pUnionNode.pascalMemberNames[n]).append("';"))));
        this.println(String.valueOf(String.valueOf(new StringBuffer("Seq[").append(n3).append("].Member_Label:= ").append(pUnionNode.pascalMemberLabels[n][n2]).append(";"))));
        this.print(String.valueOf(String.valueOf(new StringBuffer("Seq[").append(n3).append("].Member_TC   := "))));
        if (pUnionNode.pascalMemberTkHelperFullNames[n] != null) {
            this.addln(String.valueOf(String.valueOf(pUnionNode.pascalMemberTkHelperFullNames[n])).concat(".TypeCode;"));
        } else {
            this.addln(String.valueOf(String.valueOf(new StringBuffer("ORB.CreateTC(Integer(").append(pUnionNode.pascalMemberTkNames[n]).append("));"))));
        }
    }

    private final void writeUsedUnits(int n, PModuleNode pModuleNode) {
        int n2 = 0;
        Enumeration enumeration = null;
        this.usePascalUnitUnitsUsedBuffer(n, pModuleNode);
        this.indent(n, 1);
        switch (n) {
            case 0: {
                if (pModuleNode.pascalCorbaUnitRequired) {
                    this.print(n, "CORBA");
                    n2 = (short)(n2 + 1);
                }
                enumeration = pModuleNode.pascalIFileUnitsUsedByInterfaceSection.elements();
                break;
            }
            case 1: {
                this.println(n, "CORBA,");
                this.print(n, pModuleNode.pascalIUnitName);
                n2 = (short)(n2 + 2);
                enumeration = pModuleNode.pascalCFileUnitsUsedByInterfaceSection.elements();
                break;
            }
            case 2: {
                this.println(n, "CORBA,");
                this.println(n, String.valueOf(String.valueOf(pModuleNode.pascalIUnitName)).concat(","));
                this.print(n, pModuleNode.pascalCUnitName);
                enumeration = pModuleNode.pascalSFileUnitsUsedByInterfaceSection.elements();
                n2 = (short)(n2 + 3);
                break;
            }
            case 3: {
                this.println(n, "SysUtils,");
                this.println(n, "CORBA,");
                this.println(n, String.valueOf(String.valueOf(pModuleNode.pascalIUnitName)).concat(","));
                this.print(n, pModuleNode.pascalCUnitName);
                enumeration = pModuleNode.pascalPFileUnitsUsedByInterfaceSection.elements();
                n2 = (short)(n2 + 4);
            }
        }
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                int n3 = n2;
                n2 = (short)(n3 + 1);
                if (n3 > 0) {
                    this.addln(",");
                }
                this.print(n, enumeration.nextElement().toString());
                n2 = (short)(n2 + 1);
            }
        }
        if (n2 > 0) {
            this.addln(n, ";");
        }
        this.indent(n, -1);
    }

    private final void writeUsedUnits(int n, PRepositoryNode pRepositoryNode) {
        this.usePascalUnitUnitsUsedBuffer(n, pRepositoryNode);
        int n2 = 0;
        Enumeration enumeration = null;
        this.indent(1);
        switch (n) {
            case 0: {
                if (pRepositoryNode.pascalCorbaUnitRequired) {
                    this.print("CORBA");
                    n2 = (short)(n2 + 1);
                }
                enumeration = pRepositoryNode.pascalIFileUnitsUsedByInterfaceSection.elements();
                break;
            }
            case 1: {
                this.println("CORBA,");
                this.print(pRepositoryNode.pascalIUnitName);
                n2 = (short)(n2 + 2);
                enumeration = pRepositoryNode.pascalCFileUnitsUsedByInterfaceSection.elements();
                break;
            }
            case 2: {
                this.println("CORBA,");
                this.println(String.valueOf(String.valueOf(pRepositoryNode.pascalIUnitName)).concat(","));
                this.print(pRepositoryNode.pascalCUnitName);
                n2 = (short)(n2 + 3);
                enumeration = pRepositoryNode.pascalSFileUnitsUsedByInterfaceSection.elements();
                break;
            }
            case 3: {
                this.println("SysUtils,");
                this.println("CORBA,");
                this.println(String.valueOf(String.valueOf(pRepositoryNode.pascalIUnitName)).concat(","));
                this.print(n, pRepositoryNode.pascalCUnitName);
                n2 = (short)(n2 + 4);
                enumeration = pRepositoryNode.pascalPFileUnitsUsedByInterfaceSection.elements();
            }
        }
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                int n3 = n2;
                n2 = (short)(n3 + 1);
                if (n3 > 0) {
                    this.addln(",");
                }
                this.print(enumeration.nextElement().toString());
                n2 = (short)(n2 + 1);
            }
        }
        if (n2 > 0) {
            this.addln(";");
        }
        this.indent(-1);
    }

    private final void writeUsedUnits2(int n, PModuleNode pModuleNode) {
        this.usePascalUnitUnitsUsed2Buffer(n, pModuleNode);
        Enumeration enumeration = null;
        int n2 = 0;
        this.indent(1);
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                enumeration = pModuleNode.pascalCFileUnitsUsedByImplementationSection.elements();
                break;
            }
            case 2: {
                enumeration = pModuleNode.pascalSFileUnitsUsedByImplementationSection.elements();
                break;
            }
            case 3: {
                enumeration = pModuleNode.pascalPFileUnitsUsedByImplementationSection.elements();
            }
        }
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                int n3 = n2;
                n2 = (short)(n3 + 1);
                if (n3 > 0) {
                    this.addln(",");
                }
                this.print(enumeration.nextElement().toString());
                n2 = (short)(n2 + 1);
            }
        }
        if (n2 > 0) {
            this.addln(";");
        }
        this.indent(-1);
    }

    private final void writeUsedUnits2(int n, PRepositoryNode pRepositoryNode) {
        this.usePascalUnitUnitsUsed2Buffer(n, pRepositoryNode);
        Enumeration enumeration = null;
        int n2 = 0;
        this.indent(1);
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                enumeration = pRepositoryNode.pascalCFileUnitsUsedByImplementationSection.elements();
                break;
            }
            case 2: {
                enumeration = pRepositoryNode.pascalSFileUnitsUsedByImplementationSection.elements();
                break;
            }
            case 3: {
                enumeration = pRepositoryNode.pascalPFileUnitsUsedByImplementationSection.elements();
            }
        }
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                int n3 = n2;
                n2 = (short)(n3 + 1);
                if (n3 > 0) {
                    this.addln(",");
                }
                this.print(enumeration.nextElement().toString());
                n2 = (short)(n2 + 1);
            }
        }
        if (n2 > 0) {
            this.addln(";");
        }
        this.indent(-1);
    }

    private final void writeUserComments(int n, PModuleNode pModuleNode) {
        this.writePreambleComments(n, pModuleNode._repository.ER().getFileName(pModuleNode._fileNumber));
        this.newLine(n);
        this.writeFileComments(n, pModuleNode.pascalName, pModuleNode.pascalIUnitName, pModuleNode.pascalCUnitName, pModuleNode.pascalSUnitName, pModuleNode.pascalPUnitName);
    }

    private final void writeUserComments(int n, PRepositoryNode pRepositoryNode) {
        this.writePreambleComments(n, pRepositoryNode.pascalFileName);
        this.newLine(n);
        this.writeFileComments(n, "default", pRepositoryNode.pascalIUnitName, pRepositoryNode.pascalCUnitName, pRepositoryNode.pascalSUnitName, pRepositoryNode.pascalPUnitName);
    }

    private void writeWriteElement(PUnionNode pUnionNode) {
        this.print("else ");
        if (this.needsRangeCheck(pUnionNode.pascalMemberTypes[pUnionNode._defaultIndex])) {
            this.println("begin");
        }
        this.writeWriteRangeCheck(pUnionNode.pascalMemberTypes[pUnionNode._defaultIndex], "_Value.".concat(String.valueOf(String.valueOf(pUnionNode.pascalMemberNames[pUnionNode._defaultIndex]))), pUnionNode.pascalFullName, true, false);
        if (pUnionNode.pascalMemberHelperFullNames[pUnionNode._defaultIndex] != null) {
            this.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(pUnionNode.pascalMemberHelperFullNames[pUnionNode._defaultIndex]))).append(".Write(_Output, _Value.").append(pUnionNode.pascalMemberNames[pUnionNode._defaultIndex]).append(");"))));
        } else {
            this.println(String.valueOf(String.valueOf(new StringBuffer("_Output.Write").append(pUnionNode.pascalMemberReadWritePrefixes[pUnionNode._defaultIndex]).append("(_Value.").append(pUnionNode.pascalMemberNames[pUnionNode._defaultIndex]).append(");"))));
        }
        if (this.needsRangeCheck(pUnionNode.pascalMemberTypes[pUnionNode._defaultIndex])) {
            this.println("end;");
        }
    }

    private void writeWriteElement(PUnionNode pUnionNode, int n, int n2) {
        this.print(String.valueOf(String.valueOf(pUnionNode.pascalMemberLabels[n][n2])).concat(" : "));
        if (this.needsRangeCheck(pUnionNode.pascalMemberTypes[n])) {
            this.println("begin");
        }
        this.writeWriteRangeCheck(pUnionNode.pascalMemberTypes[n], "_Value.".concat(String.valueOf(String.valueOf(pUnionNode.pascalMemberNames[n]))), pUnionNode.pascalFullName, true, false);
        if (pUnionNode.pascalMemberHelperFullNames[n] != null) {
            this.addln(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(pUnionNode.pascalMemberHelperFullNames[n]))).append(".Write(_Output, _Value.").append(pUnionNode.pascalMemberNames[n]).append(");"))));
        } else {
            this.addln(String.valueOf(String.valueOf(new StringBuffer("_Output.Write").append(pUnionNode.pascalMemberReadWritePrefixes[n]).append("(_Value.").append(pUnionNode.pascalMemberNames[n]).append(");"))));
        }
        if (this.needsRangeCheck(pUnionNode.pascalMemberTypes[n])) {
            this.println("end;");
        }
    }

    private void writeWriteRangeCheck(Type type, String string, String string2) {
        this.writeWriteRangeCheck(type, string, string2, false, true);
    }

    private void writeWriteRangeCheck(Type type, String string, String string2, boolean bl, boolean bl2) {
        if (this.needsRangeCheck(type)) {
            if (!bl) {
                this.print("");
            }
            this.add(String.valueOf(String.valueOf(new StringBuffer("if (").append(string).append(" < 0) then raise DATA_CONVERSION.Create(0, COMPLETED_NO);"))));
            if (bl2) {
                this.newLine();
            } else {
                this.add(" ");
            }
        }
    }

    static {
        NUMBER_OF_PASSES = 4;
        PASCAL_I_FILE = 0;
        PASCAL_C_FILE = 1;
        PASCAL_S_FILE = 2;
        PASCAL_P_FILE = 3;
        GENERATE_I_FILE_DEFS = 11;
        GENERATE_I_GUID = 12;
        GENERATE_C_FILE_DEFS = 31;
        GENERATE_C_FILE_IMP = 32;
        GENERATE_C_STUB_IMP = 33;
        GENERATE_C_FILE_ADT_DEFS = 34;
        GENERATE_C_EXCEPTION_DEF = 35;
        GENERATE_C_EXCEPTION_IMP = 36;
        GENERATE_S_FILE_DEFS = 51;
        GENERATE_S_FILE_IMP = 52;
        GENERATE_S_EXCEPTION_DESCRIPTION = 53;
        GENERATE_S_EXCEPTION_HOOK_DESCRIPTION = 54;
        GENERATE_S_FILE_DESCRIPTION = 55;
        GENERATE_S_FILE_HOOK_DESCRIPTION = 56;
        GENERATE_S_SKELETON_IMP = 71;
        GENERATE_S_SKELETON_MARSHAL = 72;
        GENERATE_P_FILE_DEFS = 81;
        GENERATE_P_FILE_IMPL = 82;
        GENERATE_P_FILE_PROPERTY_PROXIES = 83;
        METHOD_TYPE_PRIMARY = 101;
        METHOD_TYPE_SECONDARY = 102;
    }
}

