/*
 * Decompiled with CFR 0.152.
 */
package com.inprise.vbroker.compiler.ast;

import com.inprise.vbroker.compiler.ast.ContainedContainerNode;
import com.inprise.vbroker.compiler.ast.ContainedNode;
import com.inprise.vbroker.compiler.ast.ContainerNode;
import com.inprise.vbroker.compiler.ast.InterfaceNode;
import com.inprise.vbroker.compiler.ast.Node;
import com.inprise.vbroker.compiler.ast.Type;
import com.inprise.vbroker.compiler.ast.ValueNode;
import com.inprise.vbroker.compiler.backends.depsolver.DepSolverDefs;
import com.inprise.vbroker.compiler.util.QName;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public abstract class InheritableNode
extends ContainedContainerNode
implements Type,
DepSolverDefs {
    public boolean _idlEntity = true;
    public boolean _abstract;
    public boolean _pseudo;
    public boolean _defined;
    public Vector _bases = new Vector();
    public Vector _allBases;
    public Vector _allContents;
    public Hashtable _bindings;
    public transient ContainedNode[] _beMethods;
    public transient ContainedNode[] _beAllMethods;

    public InheritableNode(int n) {
        super(n);
    }

    public void addBase(InheritableNode inheritableNode) {
        if (this._bases.contains(inheritableNode)) {
            if (inheritableNode != InterfaceNode.ERROR && inheritableNode != ValueNode.ERROR) {
                this.error("Comp.AST.duplicateBase", inheritableNode._name);
            }
        } else {
            this._bases.addElement(inheritableNode);
        }
    }

    public void cache() {
        this._allBases = new Vector();
        InheritableNode.recGenBases(this, this._allBases);
        this.genAllContents();
        this.genBindings();
    }

    public Node define(int n, String string, String string2, String string3, String string4) {
        ContainedNode containedNode = Node.define(n, string, this, string2, string3, string4, this._contents);
        if (containedNode != null) {
            ContainedNode containedNode2;
            this._allContents.addElement(containedNode);
            String string5 = string.toLowerCase();
            if (!(containedNode._kind != 7 && containedNode._kind != 2 && containedNode._kind != 22 || (containedNode2 = (ContainedNode)this._bindings.get(string5)) == null || containedNode2._kind != 7 && containedNode2._kind != 2 && containedNode2._kind != 22)) {
                String string6;
                String string7 = containedNode._kind == 7 ? "operation" : (string6 = containedNode._kind == 2 ? "attribute" : "value member");
                String string8 = containedNode2._kind == 7 ? "Comp.AST.collisionWithInheritedOperation" : (containedNode2._kind == 2 ? "Comp.AST.collisionWithInheritedAttribute" : "Comp.AST.collisionWithInheritedValueMember");
                this.error(string8, new Object[]{string, string6, this._repository._ER.getFileName(containedNode2._fileNumber), new Long(containedNode2._lineNumber)});
            }
            this._bindings.put(string5, containedNode);
        }
        return containedNode;
    }

    public Vector find(String string, int n, int n2, boolean bl) {
        if (bl) {
            return Node.find(this._contents, string, n, n2, bl);
        }
        return Node.find(this._allContents, string, n, n2, bl);
    }

    public boolean finish(int n) {
        super.finish(n);
        if (this._beMethods == null) {
            ContainedNode containedNode;
            int n2;
            if (!this._defined) {
                this.cache();
            }
            if (!this._defined && this._repository._options._warnMissingDefine) {
                String string = this._repository._ER.getFileName(this._fileNumber);
                this._repository._ER.warn("Comp.AST.declOnly", new Object[]{this._fullName, string, new Long(this._lineNumber)});
                this._repository._ER.warnAdd("Comp.AST.NoCodeGen");
            }
            int n3 = this._contents.size();
            ContainedNode[] containedNodeArray = new ContainedNode[n3];
            int n4 = 0;
            for (n2 = 0; n2 < n3; ++n2) {
                containedNode = (ContainedNode)this._contents.elementAt(n2);
                if (containedNode._kind != 7 && containedNode._kind != 2) continue;
                containedNodeArray[n4++] = containedNode;
            }
            this._beMethods = new ContainedNode[n4];
            System.arraycopy(containedNodeArray, 0, this._beMethods, 0, n4);
            n3 = this._allContents.size();
            containedNodeArray = new ContainedNode[n3];
            n4 = 0;
            for (n2 = 0; n2 < n3; ++n2) {
                containedNode = (ContainedNode)this._allContents.elementAt(n2);
                if (containedNode._kind != 7 && containedNode._kind != 2) continue;
                containedNodeArray[n4++] = containedNode;
            }
            this._beAllMethods = new ContainedNode[n4];
            System.arraycopy(containedNodeArray, 0, this._beAllMethods, 0, n4);
        }
        return true;
    }

    protected void genAllContents() {
        int n;
        this._allContents = new Vector();
        int n2 = this._contents.size();
        this._allContents.ensureCapacity(n2);
        for (n = 0; n < n2; ++n) {
            this._allContents.addElement(this._contents.elementAt(n));
        }
        int n3 = this._allBases.size();
        for (n = 0; n < n3; ++n) {
            Vector vector = ((InheritableNode)this._allBases.elementAt((int)n))._contents;
            int n4 = vector.size();
            this._allContents.ensureCapacity(n4);
            for (int i = 0; i < n4; ++i) {
                this._allContents.addElement(vector.elementAt(i));
            }
        }
    }

    protected void genBindings() {
        Serializable serializable;
        int n;
        this._bindings = new Hashtable();
        Vector<String> vector = new Vector<String>();
        int n2 = this._allBases.size();
        for (n = 0; n < n2; ++n) {
            serializable = ((InheritableNode)this._allBases.elementAt((int)n))._contents;
            int n3 = serializable.size();
            for (int i = 0; i < n3; ++i) {
                ContainedNode containedNode = (ContainedNode)serializable.elementAt(i);
                String string = containedNode._name.toLowerCase();
                ContainedNode containedNode2 = (ContainedNode)this._bindings.get(string);
                if (containedNode2 != null && containedNode2 != containedNode) {
                    vector.addElement(string);
                    if (containedNode._kind == 7) {
                        this.error("Comp.AST.inheritedOperationCollision", new Object[]{containedNode._name, this._repository._ER.getFileName(containedNode._fileNumber), new Long(containedNode._lineNumber), this._repository._ER.getFileName(containedNode2._fileNumber), new Long(containedNode2._lineNumber)});
                        continue;
                    }
                    if (containedNode._kind != 2) continue;
                    this.error("Comp.AST.inheritedAttributeCollision", new Object[]{containedNode._name, this._repository._ER.getFileName(containedNode._fileNumber), new Long(containedNode._lineNumber), this._repository._ER.getFileName(containedNode2._fileNumber), new Long(containedNode2._lineNumber)});
                    continue;
                }
                this._bindings.put(string, containedNode);
            }
        }
        n2 = vector.size();
        for (n = 0; n < n2; ++n) {
            this._bindings.remove(vector.elementAt(n));
        }
        n2 = this._contents.size();
        for (n = 0; n < n2; ++n) {
            serializable = (ContainedNode)this._contents.elementAt(n);
            String string = ((ContainedNode)serializable)._name.toLowerCase();
            this._bindings.put(string, serializable);
        }
    }

    public Vector getGoodBases(int n) {
        InheritableNode inheritableNode;
        int n2;
        Hashtable<InheritableNode, Boolean> hashtable = new Hashtable<InheritableNode, Boolean>();
        Vector<InheritableNode> vector = new Vector<InheritableNode>();
        int n3 = this._bases.size();
        for (n2 = 0; n2 < n3; ++n2) {
            inheritableNode = (InheritableNode)this._bases.elementAt(n2);
            int n4 = inheritableNode._allBases.size();
            for (int i = 0; i < n4; ++i) {
                InheritableNode inheritableNode2 = (InheritableNode)inheritableNode._allBases.elementAt(i);
                if (!inheritableNode2._abstract) continue;
                hashtable.put(inheritableNode2, Boolean.TRUE);
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            inheritableNode = (InheritableNode)this._bases.elementAt(n2);
            if (inheritableNode._abstract && hashtable.containsKey(inheritableNode) || n >= 0 && n != inheritableNode._kind) continue;
            vector.addElement(inheritableNode);
        }
        return vector;
    }

    public ContainedNode lookup(QName qName, boolean bl) {
        String string = qName._s.toLowerCase();
        ContainedNode containedNode = (ContainedNode)this._bindings.get(string);
        if (containedNode == null) {
            return bl ? null : this._container.lookup(qName, false);
        }
        if (containedNode._name != null && !containedNode._name.equals(qName._s)) {
            containedNode.warnCaseViolation(qName._s);
        }
        if (qName._next == null) {
            return containedNode;
        }
        if (containedNode.isContainer()) {
            return ((ContainerNode)((Object)containedNode)).lookup(qName._next, true);
        }
        return null;
    }

    public ContainedNode lookup(String string, boolean bl) {
        String string2 = string.toLowerCase();
        ContainedNode containedNode = (ContainedNode)this._bindings.get(string2);
        if (containedNode == null) {
            if (bl) {
                return null;
            }
            if (this._container == null) {
                return null;
            }
            return this._container.lookup(string, false);
        }
        return containedNode;
    }

    protected static final void recGenBases(InheritableNode inheritableNode, Vector vector) {
        int n = inheritableNode._bases.size();
        for (int i = 0; i < n; ++i) {
            InheritableNode inheritableNode2 = (InheritableNode)inheritableNode._bases.elementAt(i);
            if (!vector.contains(inheritableNode2)) {
                vector.addElement(inheritableNode2);
            }
            InheritableNode.recGenBases(inheritableNode2, vector);
        }
    }

    public void validateBases() {
        if (!this._pseudo) {
            Enumeration enumeration = this._bases.elements();
            while (enumeration.hasMoreElements()) {
                InheritableNode inheritableNode = (InheritableNode)enumeration.nextElement();
                if (inheritableNode == InterfaceNode.ERROR || inheritableNode == ValueNode.ERROR || this._pseudo || !inheritableNode._pseudo) continue;
                this.error("Comp.AST.pseudoBaseForRegular", inheritableNode._name);
            }
        }
    }
}

