/*
 * Decompiled with CFR 0.152.
 */
package com.borland.util;

import com.borland.util.ILogListener;
import com.borland.util.Resources;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Vector;

public class Logger {
    public static final int INFO = 0;
    public static final int WARNING = 1;
    public static final int ERROR = 2;
    public static final int SYSTEM = 3;
    public static final int LEVEL_NONE = 0;
    public static final int LEVEL_ERRORS = 1;
    public static final int LEVEL_DEBUG = 2;
    public static final int LEVEL_DEFAULT = 1;
    private static Logger instance;
    private boolean isDebugging = true;
    private PrintStream myStream;
    private PrintStream myErrStream;
    private boolean firstMessage = true;
    private Vector myListeners;
    private int myLevel = 1;
    private List myCategories = null;
    private int myErrorCount = 0;

    public static Logger getInstance() {
        if (instance == null) {
            instance = new Logger();
        }
        return instance;
    }

    private Logger() {
        this(System.out, System.err);
    }

    private Logger(PrintStream stream, PrintStream errStream) {
        this.setStream(stream, errStream);
        this.addDebugCategory("all");
    }

    public void log(String category, String message) {
        this.log(category, 0, message);
    }

    public void log(String category, int status, String message) {
        if (status == 2) {
            ++this.myErrorCount;
        }
        if (!this.hasCategory(category)) {
            return;
        }
        if (this.checkStatus(status)) {
            this.printMessage(category, status, message);
        }
    }

    public void log(String category, Throwable th) {
        ++this.myErrorCount;
        if (!this.hasCategory(category)) {
            return;
        }
        if (this.checkStatus(2)) {
            this.printStackTrace(category, 2, th);
        }
    }

    public boolean checkStatus(int status) {
        if (this.myLevel == 0) {
            return false;
        }
        return status == 2 || status == 3 || this.myLevel == 2;
    }

    public PrintStream getStream(boolean error) {
        return error && this.myErrStream != null ? this.myErrStream : this.myStream;
    }

    public void setStream(PrintStream aStream, PrintStream errStream) {
        this.myStream = aStream;
        this.myErrStream = errStream;
    }

    public void addLogListener(ILogListener listener) {
        if (this.myListeners == null) {
            this.myListeners = new Vector();
        }
        this.myListeners.add(listener);
    }

    public void removeLogListener(ILogListener listener) {
        if (this.myListeners != null && this.myListeners.contains(listener)) {
            this.myListeners.remove(listener);
        }
    }

    public void setLevel(int level) {
        this.myLevel = level;
    }

    public int getLevel() {
        return this.myLevel;
    }

    public boolean isDebugging() {
        return this.isDebugging;
    }

    public void setDebugging(boolean debug) {
        this.isDebugging = debug;
        this.myLevel = debug ? 2 : 1;
    }

    public boolean hasCategory(String category) {
        if (this.myCategories == null) {
            return false;
        }
        return this.myCategories.contains("all") || this.myCategories.contains(category);
    }

    public void addDebugCategory(String category) {
        if (category != null) {
            if (this.myCategories == null) {
                this.myCategories = new ArrayList();
            }
            this.myCategories.add(category);
        }
    }

    public int getErrorCount() {
        return this.myErrorCount;
    }

    protected void printMessage(String category, int status, String message) {
        PrintStream stream = this.getStream(status == 2);
        if (stream == null) {
            System.err.println(Resources.getString("Logger.ERROR__Log_stream_is_not_specified_3"));
        } else {
            if (this.firstMessage) {
                this.println(stream, status, String.valueOf(Resources.getString("Logger._!SESSION__4")) + new Date(System.currentTimeMillis()) + " ---------------------------------");
                this.firstMessage = false;
            }
            StringBuffer prefixText = new StringBuffer();
            prefixText.append("[").append(this.getStatusText(status));
            if (category != null) {
                prefixText.append(":").append(category);
            }
            prefixText.append("] ");
            this.print(stream, status, prefixText.toString());
            this.println(stream, status, message);
        }
        if (this.myListeners != null) {
            int i = 0;
            while (i < this.myListeners.size()) {
                ((ILogListener)this.myListeners.elementAt(i)).logging(category, status, message);
                ++i;
            }
        }
    }

    protected void printStackTrace(String category, int status, Throwable th) {
        PrintStream stream = this.getStream(status == 2);
        if (stream == null) {
            System.err.println(Resources.getString("Logger.ERROR__Log_stream_is_not_specified_9"));
        } else {
            this.printMessage(category, status, "");
            if (this.myLevel == 2 || this.isDebugging()) {
                this.print(stream, status, th);
            } else {
                this.println(stream, status, th.getLocalizedMessage());
            }
        }
        if (this.myListeners != null) {
            int i = 0;
            while (i < this.myListeners.size()) {
                ((ILogListener)this.myListeners.elementAt(i)).logging(category, status, th);
                ++i;
            }
        }
    }

    protected String getStatusText(int status) {
        switch (status) {
            case 1: {
                return Resources.getString("Logger.WARNING_11");
            }
            case 2: {
                return Resources.getString("Logger.ERROR_12");
            }
            case 3: {
                return Resources.getString("Logger.SYSTEM_13");
            }
        }
        return Resources.getString("Logger.INFO_14");
    }

    protected void println(PrintStream stream, int status, String buf) {
        this.print(stream, status, String.valueOf(buf) + System.getProperty("line.separator"));
    }

    protected void print(PrintStream stream, int status, String buf) {
        stream.print(buf);
        if (this.isDebugging()) {
            if (status == 2) {
                System.err.print(buf);
            } else {
                System.out.print(buf);
            }
        }
    }

    protected void print(PrintStream stream, int status, Throwable th) {
        th.printStackTrace(stream);
        if (this.isDebugging()) {
            if (status == 2) {
                th.printStackTrace(System.err);
            } else {
                th.printStackTrace(System.out);
            }
        }
    }

    public static Logger createNewInstance() {
        instance = new Logger();
        return instance;
    }
}

