/*
 * Decompiled with CFR 0.152.
 */
package com.borland.util;

import java.util.StringTokenizer;

public class JavaNames {
    private static final String[] JAVA_KEYWORDS = new String[]{"void", "int", "long", "short", "float", "double", "boolean", "byte", "char", "abstract", "const", "final", "native", "static", "synchronized", "transient", "volatile", "private", "protected", "public", "import", "class", "interface", "package", "extends", "implements", "throws", "try", "catch", "finally", "if", "else", "for", "while", "do", "break", "continue", "goto", "switch", "case", "default", "instanceof", "null", "return", "super", "this", "throw", "new", "true", "false"};

    public static boolean isValidJavaIdentifier(String value) {
        if (value == null || value.length() == 0 || JavaNames.isJavaKeyword(value)) {
            return false;
        }
        int i = 0;
        while (i < value.length()) {
            char ch = value.charAt(i);
            if (!(ch == '_' || ch == '$' || ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z')) {
                if (ch >= '0' && ch <= '9') {
                    if (i == 0) {
                        return false;
                    }
                } else {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    public static boolean isJavaKeyword(String name) {
        int i = 0;
        while (i < JAVA_KEYWORDS.length) {
            if (JAVA_KEYWORDS[i].equals(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String toJavaPackageName(String name) {
        return JavaNames.toJavaName(name, false, true);
    }

    public static String toJavaClassShortName(String name) {
        name = JavaNames.toJavaClassName(name);
        return name.replace('.', '_');
    }

    public static String toJavaClassName(String name) {
        if (name == null) {
            return null;
        }
        StringTokenizer tokens = new StringTokenizer(name, ".");
        StringBuffer buffer = new StringBuffer();
        boolean isFirst = true;
        while (tokens.hasMoreTokens()) {
            if (!isFirst) {
                buffer.append(".");
            }
            String token = tokens.nextToken();
            buffer.append(JavaNames.toJavaName(token, true, false));
            isFirst = false;
        }
        return buffer.toString();
    }

    public static String toJavaMemberName(String name) {
        return JavaNames.toJavaName(name, false, false);
    }

    public static String toJavaName(String name, boolean upperFirst, boolean lowerFirst) {
        int size = name.length();
        char[] ncChars = name.toCharArray();
        int next = 0;
        if (size > 1 && lowerFirst && Character.isUpperCase(ncChars[0]) && Character.isUpperCase(ncChars[1])) {
            lowerFirst = false;
        }
        boolean startsWithDigit = false;
        int i = 0;
        while (i < size) {
            char ch = ncChars[i];
            if (i == 0 && ch >= '0' && ch <= '9') {
                startsWithDigit = true;
            }
            switch (ch) {
                case ' ': {
                    ncChars[next++] = 95;
                    break;
                }
                case '\u000b': 
                case '\f': 
                case '!': 
                case '\"': 
                case '#': 
                case '%': 
                case '&': 
                case '\'': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '/': 
                case ':': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '@': 
                case '[': 
                case ']': 
                case '^': 
                case '`': 
                case '{': 
                case '|': 
                case '}': 
                case '~': 
                case '\u00a0': 
                case '\u00a6': 
                case '\u00a7': 
                case '\u00a9': 
                case '\u00ab': 
                case '\u00ac': 
                case '\u00ad': 
                case '\u00ae': 
                case '\u00b0': 
                case '\u00b1': 
                case '\u00b6': 
                case '\u00b7': 
                case '\u00bb': 
                case '\u0401': 
                case '\u0405': 
                case '\u0406': 
                case '\u0407': 
                case '\u040e': 
                case '\u0427': 
                case '\u0447': 
                case '\u0451': 
                case '\u0455': 
                case '\u0456': 
                case '\u0457': 
                case '\u0458': 
                case '\u0491': 
                case '\u2116': {
                    ncChars[next++] = 95;
                    upperFirst = true;
                    break;
                }
                default: {
                    ncChars[next] = ch;
                    ++next;
                }
            }
            ++i;
        }
        String result = new String(ncChars, 0, next);
        return startsWithDigit ? "_" + result : result;
    }
}

