/*
 * Decompiled with CFR 0.152.
 */
package com.borland.mdlimport.util;

import com.borland.mdlimport.util.Debug;
import com.borland.mdlimport.util.ILogListener;
import com.borland.util.Resources;
import java.io.PrintStream;
import java.util.Date;
import java.util.Vector;

public class Logger {
    public static final int INFO = 0;
    public static final int WARNING = 1;
    public static final int ERROR = 2;
    private static final String INFO_TEXT = "INFO";
    private static final String WARNING_TEXT = "WARNING";
    private static final String ERROR_TEXT = "ERROR";
    private static Logger instance;
    private PrintStream myStream;
    private boolean firstMessage = true;
    private Vector myListeners;

    public static Logger getInstance() {
        if (instance == null) {
            Logger.setInstance(new Logger());
        }
        return instance;
    }

    public static void setInstance(Logger logger) {
        instance = logger;
    }

    public Logger() {
        this(System.out);
    }

    public Logger(PrintStream stream) {
        this.myStream = stream;
    }

    public void log(String category, int status, String message) {
        this.printMessage(category, status, message);
    }

    public void log(String category, int status, Throwable th) {
        this.printStackTrace(category, status, th);
    }

    public PrintStream getStream() {
        return this.myStream;
    }

    public void setStream(PrintStream aStream) {
        this.myStream = aStream;
    }

    public void addLogListener(ILogListener listener) {
        if (this.myListeners == null) {
            this.myListeners = new Vector();
        }
        this.myListeners.add(listener);
    }

    public void removeLogListener(ILogListener listener) {
        if (this.myListeners != null && this.myListeners.contains(listener)) {
            this.myListeners.remove(listener);
        }
    }

    protected void printMessage(String category, int status, String message) {
        if (status == 2) {
            Debug.traceErr(category, message);
        } else {
            Debug.trace(category, message);
        }
        PrintStream stream = this.getStream();
        if (stream == null) {
            System.err.println(Resources.getString("Logger.ERROR__Log_stream_is_not_specified_1"));
        } else {
            if (this.firstMessage) {
                stream.println();
                stream.println(String.valueOf(Resources.getString("Logger._!SESSION__2")) + new Date(System.currentTimeMillis()) + Resources.getString("Logger._---------------------------------_3"));
                this.firstMessage = false;
            }
            StringBuffer prefixText = new StringBuffer();
            prefixText.append(Resources.getString("Logger.[_4")).append(this.getStatusText(status));
            if (category != null) {
                prefixText.append(":").append(category);
            }
            prefixText.append(Resources.getString("Logger.]__6"));
            stream.print(prefixText.toString());
            stream.println(message);
        }
        if (this.myListeners != null) {
            int i = 0;
            while (i < this.myListeners.size()) {
                ((ILogListener)this.myListeners.elementAt(i)).logging(category, status, message);
                ++i;
            }
        }
    }

    protected void printStackTrace(String category, int status, Throwable th) {
        Debug.trace(category, th);
        PrintStream stream = this.getStream();
        if (stream == null) {
            System.err.println(Resources.getString("Logger.ERROR__Log_stream_is_not_specified_7"));
        } else {
            this.printMessage(category, status, "");
            th.printStackTrace(stream);
        }
        if (this.myListeners != null) {
            int i = 0;
            while (i < this.myListeners.size()) {
                ((ILogListener)this.myListeners.elementAt(i)).logging(category, status, th);
                ++i;
            }
        }
    }

    protected String getStatusText(int status) {
        switch (status) {
            case 1: {
                return WARNING_TEXT;
            }
            case 2: {
                return ERROR_TEXT;
            }
        }
        return INFO_TEXT;
    }
}

