/*
 * Decompiled with CFR 0.152.
 */
package com.borland.mdlimport.txv;

import com.borland.mdlimport.mapping.UinSupport;
import com.borland.mdlimport.txv.IElement;
import com.borland.mdlimport.txv.IIdentifiable;
import com.borland.mdlimport.txv.ILink;
import com.borland.mdlimport.txv.INode;
import com.borland.mdlimport.txv.INodeSet;
import com.borland.mdlimport.txv.IView;
import com.borland.mdlimport.txv.IViewReference;
import com.borland.util.Resources;
import java.util.Enumeration;

public abstract class TxvAccess {
    private static TxvAccess ourImplementation;

    public static void setImplementation(TxvAccess implementation) {
        ourImplementation = implementation;
    }

    public static INodeSet createNodeSet(String location, String diagramFile) {
        if (ourImplementation != null) {
            return ourImplementation.createNodeSetImpl(location, diagramFile);
        }
        throw new UnsupportedOperationException(Resources.getString("TxvAccess.TxvAccess_implementation_not_set_1"));
    }

    public static INode createNode(String metaclass, String name) {
        return TxvAccess.createNode(UinSupport.newDesignUin(metaclass), metaclass, name);
    }

    public static INode createNode(String uin, String metaclass, String name) {
        if (ourImplementation != null) {
            return ourImplementation.createNodeImpl(uin, metaclass, name);
        }
        throw new UnsupportedOperationException(Resources.getString("TxvAccess.TxvAccess_implementation_not_set_1"));
    }

    public static ILink createLink(String metaclass, String name) {
        return TxvAccess.createLink(UinSupport.newDesignUin(metaclass), metaclass, name, null, null);
    }

    public static ILink createLink(String metaclass, String name, String clientUin, String supplierUin) {
        return TxvAccess.createLink(UinSupport.newDesignUin(metaclass), metaclass, name, clientUin, supplierUin);
    }

    public static ILink createLink(String uin, String metaclass, String name, String clientUin, String supplierUin) {
        if (ourImplementation != null) {
            return ourImplementation.createLinkImpl(uin, metaclass, name, clientUin, supplierUin);
        }
        throw new UnsupportedOperationException(Resources.getString("TxvAccess.TxvAccess_implementation_not_set_1"));
    }

    public static IViewReference createViewReference() {
        return TxvAccess.createViewReference(null);
    }

    public static IViewReference createViewReference(String referencedUin) {
        if (ourImplementation != null) {
            return ourImplementation.createViewReferenceImpl(referencedUin);
        }
        throw new UnsupportedOperationException(Resources.getString("TxvAccess.TxvAccess_implementation_not_set_1"));
    }

    public static IView createView(String metaclass) {
        return TxvAccess.createView(UinSupport.newDesignUin(metaclass), metaclass);
    }

    public static IView createView(String uin, String metaclass) {
        if (ourImplementation != null) {
            return ourImplementation.createViewImpl(uin, metaclass);
        }
        throw new UnsupportedOperationException(Resources.getString("TxvAccess.TxvAccess_implementation_not_set_1"));
    }

    protected abstract INodeSet createNodeSetImpl(String var1, String var2);

    protected abstract INode createNodeImpl(String var1, String var2, String var3);

    protected abstract ILink createLinkImpl(String var1, String var2, String var3, String var4, String var5);

    protected abstract IViewReference createViewReferenceImpl(String var1);

    protected abstract IView createViewImpl(String var1, String var2);

    protected abstract void setDuplicateImpl(String var1, String var2);

    protected abstract String getDuplicateImpl(String var1);

    public static IIdentifiable find(String uin) {
        if (ourImplementation != null) {
            return ourImplementation.findImpl(uin);
        }
        throw new UnsupportedOperationException(Resources.getString("TxvAccess.TxvAccess_implementation_not_set_1"));
    }

    public static IElement findElement(String uin) {
        IIdentifiable element = TxvAccess.find(uin);
        if (element instanceof IElement) {
            return (IElement)element;
        }
        return null;
    }

    public static INode findNode(String uin) {
        IIdentifiable element = TxvAccess.find(uin);
        if (element instanceof INode) {
            return (INode)element;
        }
        return null;
    }

    public static ILink findLink(String uin) {
        IIdentifiable element = TxvAccess.find(uin);
        if (element instanceof ILink) {
            return (ILink)element;
        }
        return null;
    }

    public static IView findView(String uin) {
        IIdentifiable element = TxvAccess.find(uin);
        if (element instanceof IView) {
            return (IView)element;
        }
        return null;
    }

    public static INode findClassifier(String fqn) {
        if (ourImplementation != null) {
            return ourImplementation.findClassifierImpl(fqn);
        }
        throw new UnsupportedOperationException(Resources.getString("TxvAccess.TxvAccess_implementation_not_set_1"));
    }

    public static INodeSet getNodeSet(String location, String diagramFile) {
        if (ourImplementation != null) {
            return ourImplementation.getNodeSetImpl(location, diagramFile);
        }
        throw new UnsupportedOperationException(Resources.getString("TxvAccess.TxvAccess_implementation_not_set_1"));
    }

    public static Enumeration getNodeSets(String location) {
        if (ourImplementation != null) {
            return ourImplementation.getNodeSetsImpl(location);
        }
        throw new UnsupportedOperationException(Resources.getString("TxvAccess.TxvAccess_implementation_not_set_1"));
    }

    public static Enumeration getNodeSetFiles(String location) {
        if (ourImplementation != null) {
            return ourImplementation.getNodeSetFilesImpl(location);
        }
        throw new UnsupportedOperationException(Resources.getString("TxvAccess.TxvAccess_implementation_not_set_1"));
    }

    public static void setDuplicate(String original, String copy) {
        if (ourImplementation != null) {
            ourImplementation.setDuplicateImpl(original, copy);
            return;
        }
        throw new UnsupportedOperationException(Resources.getString("TxvAccess.TxvAccess_implementation_not_set_1"));
    }

    public static String getDuplicate(String quid) {
        if (ourImplementation != null) {
            return ourImplementation.getDuplicateImpl(quid);
        }
        throw new UnsupportedOperationException(Resources.getString("TxvAccess.TxvAccess_implementation_not_set_1"));
    }

    protected abstract IIdentifiable findImpl(String var1);

    protected abstract INode findClassifierImpl(String var1);

    protected abstract INodeSet getNodeSetImpl(String var1, String var2);

    protected abstract Enumeration getNodeSetsImpl(String var1);

    protected abstract Enumeration getNodeSetFilesImpl(String var1);

    public static void writeAllNodeSets(String outPath) {
        if (ourImplementation != null) {
            ourImplementation.writeAllNodeSetsImpl(outPath);
            return;
        }
        throw new UnsupportedOperationException(Resources.getString("TxvAccess.TxvAccess_implementation_not_set_1"));
    }

    protected abstract void writeAllNodeSetsImpl(String var1);
}

