/*
 * Decompiled with CFR 0.152.
 */
package com.borland.mdlimport.txv;

import com.borland.mdlimport.txv.IIdentifiable;
import com.borland.mdlimport.txv.INode;
import com.borland.mdlimport.txv.INodeContainer;
import com.borland.mdlimport.txv.INodeSet;
import com.borland.mdlimport.txv.TxvAccess;
import com.borland.util.ICondition;
import com.borland.util.Logger;
import com.borland.util.Resources;
import java.io.File;
import java.util.Enumeration;
import java.util.HashMap;

public class TXVUtil {
    private static final HashMap extensions = new HashMap();

    static {
        extensions.put("Package Diagram", "txvpck");
        extensions.put("Use Case Diagram", "txvuse");
        extensions.put("Class Diagram", "txvcls");
        extensions.put("Component Diagram", "txvcmp");
        extensions.put("State Diagram", "txvstc");
        extensions.put("Activity Diagram", "txvact");
        extensions.put("Deployment Diagram", "txvdpl");
        extensions.put("Sequence Diagram", "txvint");
        extensions.put("Collaboration Diagram", "txvint");
        extensions.put("Package", "txaPackage");
    }

    public static IIdentifiable getRootContainer(IIdentifiable element) {
        if (element instanceof INodeSet) {
            return null;
        }
        if (element == null) {
            return null;
        }
        IIdentifiable parent = element.getParent();
        if (parent instanceof INodeSet) {
            return element;
        }
        return TXVUtil.getRootContainer(parent);
    }

    public static IIdentifiable getContainerBeforeElement(IIdentifiable element, IIdentifiable finishElement) {
        if (finishElement == null) {
            return TXVUtil.getRootContainer(element);
        }
        if (element instanceof INodeSet) {
            return null;
        }
        IIdentifiable parent = element.getParent();
        if (parent instanceof INodeSet || parent == finishElement) {
            return element;
        }
        return TXVUtil.getRootContainer(parent);
    }

    public static INodeSet getNodeSet(IIdentifiable element) {
        if (element == null) {
            return null;
        }
        if (element instanceof INodeSet) {
            return (INodeSet)element;
        }
        return TXVUtil.getNodeSet(element.getParent());
    }

    public static String getTxvExtension(String metaclass) {
        return (String)extensions.get(metaclass);
    }

    public static INode findChildNodeByCondition(INodeContainer parent, ICondition condition) {
        Enumeration children = parent.getChildNodes();
        while (children.hasMoreElements()) {
            INode nextChild = (INode)children.nextElement();
            if (!condition.accept(nextChild)) continue;
            return nextChild;
        }
        return null;
    }

    public static INode findClassifierByQualifiedName(String[] fullQualifiedName) {
        if (fullQualifiedName == null || fullQualifiedName.length == 0) {
            Logger.getInstance().log("txv", 1, Resources.getString("TXVUtil.Cannot_find_classifier_node_for_empty_qualified_name_2"));
            return null;
        }
        int i = fullQualifiedName.length - 1;
        while (i >= 0) {
            String[] packagePath = new String[i];
            String[] qName = new String[fullQualifiedName.length - i];
            System.arraycopy(fullQualifiedName, 0, packagePath, 0, i);
            System.arraycopy(fullQualifiedName, i, qName, 0, fullQualifiedName.length - i);
            INode found = TXVUtil.findClassifierByQualifiedName(packagePath, qName);
            if (found != null) {
                return found;
            }
            --i;
        }
        return null;
    }

    public static INode findClassifierByQualifiedName(String[] path, String[] qName) {
        StringBuffer location = new StringBuffer();
        int i = 0;
        while (i < path.length) {
            location.append(path[i]);
            if (i < path.length - 1) {
                location.append(File.separator);
            }
            ++i;
        }
        Enumeration nodeSets = TxvAccess.getNodeSets(location.toString());
        while (nodeSets.hasMoreElements()) {
            INodeSet nextNodeSet = (INodeSet)nodeSets.nextElement();
            INode classifier = TXVUtil.findClassifierByQualifiedName(nextNodeSet, qName, 0);
            if (classifier == null) continue;
            return classifier;
        }
        return null;
    }

    public static INode findClassifierByQualifiedName(INodeContainer currentParent, final String[] classifierQName, final int curIndex) {
        boolean isLastIndex = curIndex == classifierQName.length - 1;
        ICondition condition = new ICondition(){

            public boolean accept(Object source) {
                if (!(source instanceof INode)) {
                    return false;
                }
                INode node = (INode)source;
                if (!"Class".equals(node.getMetaclass())) {
                    return false;
                }
                String requiredName = classifierQName[curIndex];
                return requiredName.equals(node.getName());
            }
        };
        INode found = TXVUtil.findChildNodeByCondition(currentParent, condition);
        if (found == null) {
            return null;
        }
        return isLastIndex ? found : TXVUtil.findClassifierByQualifiedName(found, classifierQName, curIndex + 1);
    }
}

