/*
 * Decompiled with CFR 0.152.
 */
package com.borland.mdlimport.petal;

import com.borland.mdlimport.Configuration;
import com.borland.mdlimport.impl.petal.SourceModelUtil;
import com.borland.mdlimport.petal.IParser;
import com.borland.mdlimport.petal.IPetalNode;
import com.borland.util.Logger;
import com.borland.util.Resources;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class PetalUtil {
    public static final String NULL_QUID = "000000000000";
    public static final String CLIENT_ROLE_NODE = "client_role_node";
    public static final String SUPPLIER_ROLE_NODE = "supplier_role_node";
    public static final String QUOTE = "\"";
    private static ArrayList design_nodes = new ArrayList();
    private static ArrayList nodeViews = new ArrayList();
    private static ArrayList linkViews = new ArrayList();
    private static ArrayList srcViews = new ArrayList();
    private static ArrayList actorViews = new ArrayList();
    private static ArrayList srcLinkViews = new ArrayList();

    static {
        nodeViews.add("ActivityStateView");
        nodeViews.add("CategoryView");
        nodeViews.add("ClassInstanceView");
        nodeViews.add("InterfaceView");
        nodeViews.add("DecisionView");
        nodeViews.add("DeviceView");
        nodeViews.add("ModView");
        nodeViews.add("ProcessorView");
        nodeViews.add("StateView");
        nodeViews.add("SynchronizationView");
        nodeViews.add("SubSysView");
        nodeViews.add("UseCaseView");
        nodeViews.add("Swimlane");
        nodeViews.add("InterObjView");
        nodeViews.add("ObjectView");
        nodeViews.add("Label");
        nodeViews.add("ClassView");
        nodeViews.add("NoteView");
        nodeViews.add("Label");
        nodeViews.add("Focus_Of_Control");
        linkViews.add("SelfTransView");
        linkViews.add("TransView");
        linkViews.add("DependencyView");
        linkViews.add("ImportView");
        linkViews.add("UsesView");
        linkViews.add("InheritView");
        linkViews.add("RealizeView");
        linkViews.add("ModVisView");
        linkViews.add("ConnectionView");
        linkViews.add("LinkView");
        linkViews.add("LinkSelfView");
        linkViews.add("InterMessView");
        linkViews.add("AssocAttachView");
        linkViews.add("AssociationViewNew");
        linkViews.add("AttachView");
        linkViews.add("SelfMessView");
        linkViews.add("MessView");
        linkViews.add("Object_Flow");
        actorViews.add("Actor".toLowerCase());
        actorViews.add("Business Actor".toLowerCase());
        actorViews.add("Business Worker".toLowerCase());
        actorViews.add("Physical Worker".toLowerCase());
        srcViews.add("ClassView");
        srcViews.add("InterfaceView");
        design_nodes.add("Destruction_Marker");
        design_nodes.add("AttachView");
        srcLinkViews.add("InheritView");
        srcLinkViews.add("RealizeView");
        srcLinkViews.add("UsesView");
    }

    public static String validateDiagramName(String fullPath, String diagramName, int num, String ext) {
        String fileName;
        File file;
        if (diagramName == null) {
            return null;
        }
        if (num == 0) {
            char[] charArray = diagramName.toCharArray();
            int i = 0;
            while (i < charArray.length) {
                switch (charArray[i]) {
                    case '\"': 
                    case '*': 
                    case '/': 
                    case ':': 
                    case '<': 
                    case '>': 
                    case '?': 
                    case '\\': 
                    case '|': {
                        charArray[i] = 95;
                    }
                }
                ++i;
            }
            diagramName = new String(charArray, 0, charArray.length);
        }
        if ((file = new File(fileName = num == 0 ? String.valueOf(fullPath) + File.separator + diagramName + "." + ext : String.valueOf(fullPath) + File.separator + diagramName + num + "." + ext)).exists()) {
            return PetalUtil.validateDiagramName(fullPath, diagramName, ++num, ext);
        }
        return num == 0 ? diagramName : String.valueOf(diagramName) + num;
    }

    public static String validatePathName(String path, String separator) {
        StringBuffer buffer = new StringBuffer("");
        StringTokenizer tokens = new StringTokenizer(path, separator);
        while (tokens.hasMoreTokens()) {
            String folder = tokens.nextToken();
            if (folder.length() <= 0) continue;
            buffer.append(separator);
            buffer.append(PetalUtil.validatePackageName(folder));
        }
        return buffer.toString();
    }

    public static String validatePackageName(String diagramName) {
        if (diagramName == null) {
            return null;
        }
        char[] charArray = diagramName.toCharArray();
        int i = 0;
        while (i < charArray.length) {
            switch (charArray[i]) {
                case ' ': 
                case '\"': 
                case '*': 
                case '/': 
                case ':': 
                case '<': 
                case '>': 
                case '?': 
                case '\\': 
                case '|': {
                    charArray[i] = 95;
                }
            }
            ++i;
        }
        return new String(charArray, 0, charArray.length);
    }

    public static boolean isAssLinkWithClass(IPetalNode petalNode) {
        String associationClass = petalNode.getProperty("AssociationClass");
        return associationClass != null;
    }

    public static boolean isSubUnitRef(IPetalNode petalNode) {
        String file_name = petalNode.getProperty("file_name");
        return file_name != null;
    }

    public static List getAssociationQualifiers(IPetalNode keys) {
        ArrayList<String> qualifiers = new ArrayList<String>();
        if (keys != null) {
            int i = 0;
            while (i < keys.getChildNodes().size()) {
                IPetalNode class_attribute = (IPetalNode)keys.getChildNodes().get(i);
                if (class_attribute != null) {
                    String _name = class_attribute.getName();
                    String _type = class_attribute.getProperty("type");
                    if (_type != null) {
                        qualifiers.add(String.valueOf(_name) + ":" + _type);
                    } else {
                        qualifiers.add(_name);
                    }
                }
                ++i;
            }
        }
        return qualifiers;
    }

    public static Map extractClientAssociationEndProps(Map properties) {
        HashMap assEndprops = new HashMap();
        assEndprops.put("@role", properties.get("@clientRole"));
        assEndprops.put("@cardinality", properties.get("@clientCardinality"));
        assEndprops.put("@qualifier", properties.get("@clientQualifier"));
        return assEndprops;
    }

    public static Map extractSupplierAssociationEndProps(Map properties) {
        HashMap assEndprops = new HashMap();
        assEndprops.put("@role", properties.get("@supplierRole"));
        assEndprops.put("@cardinality", properties.get("@supplierCardinality"));
        assEndprops.put("@qualifier", properties.get("@supplierQualifier"));
        return assEndprops;
    }

    public static Map getAssociationLinkProps(IPetalNode petalNode) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("@associationAsClass", SourceModelUtil.convertRoseFqn(petalNode.getProperty("AssociationClass")));
        props.put("@label", petalNode.getName());
        IPetalNode roles = petalNode.findNodeWithKey("roles");
        if (roles == null) {
            Logger.getInstance().log("visitor", 1, String.valueOf(Resources.getString("PetalUtil.Cannot_find_properties_of_association_link._Petal_node_uin__6")) + petalNode.getQuid());
            return null;
        }
        List role_list = roles.findNodesWithType("Role");
        if (role_list.size() != 2) {
            String errMsg = String.valueOf(Resources.getString("PetalUtil.Cannot_correctly_handle_association_link._It_has__7")) + role_list.size() + Resources.getString("PetalUtil._roles_instead_of_2._Petal_node_quid___8") + petalNode.getQuid();
            Logger.getInstance().log("visitor", 1, errMsg);
            return null;
        }
        IPetalNode roleA = (IPetalNode)role_list.get(0);
        IPetalNode roleB = (IPetalNode)role_list.get(1);
        boolean roleA_navigable = roleA.findNodeWithKey("is_navigable") != null;
        boolean roleB_navigable = roleB.findNodeWithKey("is_navigable") != null;
        boolean roleA_aggr = roleA.findNodeWithKey("is_aggregate") != null;
        boolean roleB_aggr = roleB.findNodeWithKey("is_aggregate") != null;
        boolean roleA_composition = "By Value".equals(roleB.getProperty("Containment"));
        boolean roleB_composition = "By Value".equals(roleA.getProperty("Containment"));
        boolean aggrType = false;
        boolean compType = false;
        boolean directed = false;
        IPetalNode clientRole = roleB;
        IPetalNode supplierRole = roleA;
        if (roleA_aggr) {
            clientRole = roleA;
            supplierRole = roleB;
            if (roleA_composition) {
                compType = true;
            } else {
                aggrType = true;
            }
            if (roleB_navigable) {
                directed = false;
            }
        } else if (roleB_aggr) {
            clientRole = roleB;
            supplierRole = roleA;
            if (roleB_composition) {
                compType = true;
            } else {
                aggrType = true;
            }
            if (roleA_navigable) {
                directed = false;
            }
        }
        if (!directed) {
            if (roleA_navigable && !roleB_navigable) {
                directed = true;
                clientRole = roleB;
                supplierRole = roleA;
            } else if (!roleA_navigable && roleB_navigable) {
                directed = true;
                clientRole = roleA;
                supplierRole = roleB;
            }
        }
        props.put(CLIENT_ROLE_NODE, clientRole);
        props.put(SUPPLIER_ROLE_NODE, supplierRole);
        String clientRoleStr = clientRole.getProperty("label");
        props.put("@clientRole", clientRoleStr);
        String supplierRoleStr = supplierRole.getProperty("label");
        props.put("@supplierRole", supplierRoleStr);
        String clientCardinality = clientRole.getRoleMultiplicity();
        props.put("@clientCardinality", clientCardinality);
        String supplierCardinality = supplierRole.getRoleMultiplicity();
        props.put("@supplierCardinality", supplierCardinality);
        props.put("@clientQualifier", PetalUtil.getAssociationQualifiers(supplierRole.findNodeWithKey("keys")));
        props.put("@supplierQualifier", PetalUtil.getAssociationQualifiers(clientRole.findNodeWithKey("keys")));
        props.put("@clientConstraints", clientRole.getProperty("Constraints"));
        props.put("@supplierConstraints", supplierRole.getProperty("Constraints"));
        String clientNav = clientRole.findNodeWithKey("is_navigable") != null ? "$clientNavigableExplicitly" : null;
        String supplierNav = supplierRole.findNodeWithKey("is_navigable") != null ? "$supplierNavigableExplicitly" : null;
        props.put("@clientNavigability", clientNav);
        props.put("@supplierNavigability", supplierNav);
        String clientVisibility = PetalUtil.getAssociationEndVisibility(clientRole.getProperty("exportControl"), "client");
        String supplierVisibility = PetalUtil.getAssociationEndVisibility(supplierRole.getProperty("exportControl"), "supplier");
        props.put("@clientVisibility", clientVisibility);
        props.put("@supplierVisibility", supplierVisibility);
        PetalUtil.setBooleanPropForAss(props, clientRole, "is_aggregate", "@clientIsAggregate");
        PetalUtil.setBooleanPropForAss(props, supplierRole, "is_aggregate", "@supplierIsAggregate");
        PetalUtil.setBooleanPropForAss(props, clientRole, "friend", "@clientFriend");
        PetalUtil.setBooleanPropForAss(props, supplierRole, "friend", "@supplierFriend");
        PetalUtil.setBooleanPropForAss(props, clientRole, "static", "@clientStatic");
        PetalUtil.setBooleanPropForAss(props, supplierRole, "static", "@supplierStatic");
        String clientContainmentStr = clientRole.getProperty("Containment");
        props.put("@clientContainment", clientContainmentStr);
        String supplierContainmentStr = supplierRole.getProperty("Containment");
        props.put("@supplierContainment", supplierContainmentStr);
        IPetalNode isDerived = petalNode.findNodeWithKey("derived");
        if (isDerived != null) {
            props.put("@clientIsDerived", "");
            props.put("@supplierIsDerived", "");
        }
        if (directed) {
            props.put("@directed", "");
        }
        if (aggrType) {
            props.put("@link", "aggregation");
        } else if (compType) {
            props.put("@link", "aggregationByValue");
        } else {
            props.put("@link", "association");
        }
        return props;
    }

    private static void setBooleanPropForAss(Map props, IPetalNode role, String roseName, String ourName) {
        boolean value;
        boolean bl = value = role.findNodeWithKey(roseName) != null;
        if (value) {
            props.put(ourName, "");
        }
    }

    public static String getAssociationEndVisibility(String roseVisib, String prefix) {
        if (roseVisib == null) {
            return "$" + prefix + "Public";
        }
        if ("Implementation".equals(roseVisib)) {
            return "$" + prefix + "Default";
        }
        return "$" + prefix + roseVisib;
    }

    public static IPetalNode getSubUnitTree(IPetalNode petalNode, IParser parser, Configuration configuration) throws PropertyVetoException {
        String fileName = petalNode.getProperty("file_name");
        if (fileName == null) {
            return null;
        }
        File subUnitFile = null;
        if (fileName.startsWith("$")) {
            int fileSepIndex = (fileName = fileName.replace('\\', com.borland.util.File.separatorChar)).indexOf(com.borland.util.File.separatorChar);
            String mdlParam = fileSepIndex == -1 ? fileName.substring(1) : fileName.substring(1, fileSepIndex);
            String paramValue = configuration.getMdlOption(mdlParam);
            if (paramValue == null) {
                Logger.getInstance().log("visitor", 1, String.valueOf(Resources.getString("PetalUtil.Using_model_directory_as_value_of_parameter__12")) + mdlParam);
                paramValue = configuration.petalFile.getParent();
            }
            subUnitFile = new File(paramValue, fileName.substring(mdlParam.length() + 2));
        } else {
            subUnitFile = new File(fileName);
        }
        try {
            return parser.parse(subUnitFile, configuration.needProgressInfo);
        }
        catch (IOException ex) {
            Logger.getInstance().log("parser", 2, String.valueOf(Resources.getString("PetalUtil.Error_parsing_sub-unit__14")) + subUnitFile);
            return null;
        }
    }

    public static boolean isAssociationLinkView(IPetalNode petalNode) {
        String key = petalNode.getType();
        return key != null && key.startsWith("AssociationViewNew");
    }

    public static boolean isAssocAttachView(IPetalNode node) {
        return "AssocAttachView".equals(node.getType());
    }

    public static boolean isPseudoPackage(IPetalNode node) {
        String path = node.getName();
        return "Logical View".equals(path) || "Use Case View".equals(path) || "Component View".equals(path);
    }

    public static boolean isRootNode(IPetalNode node) {
        return node.getPetalNodeType() == 2 && "Design".equals(node.getType());
    }

    public static boolean isInteractionDiagram(IPetalNode node) {
        return "InteractionDiagram".equals(node.getType()) || "ObjectDiagram".equals(node.getType());
    }

    public static boolean isNodeView(IPetalNode petalNode) {
        return nodeViews.contains(petalNode.getType());
    }

    public static boolean isLinkView(IPetalNode petalNode) {
        return linkViews.contains(petalNode.getType());
    }

    public static String toRGB(String color) {
        if (color == null) {
            return null;
        }
        int i = Integer.parseInt(color);
        int r = i % 256;
        int g = i / 256 % 256;
        int b = i / 256 / 256 % 256;
        return String.valueOf(r) + "," + g + Resources.getString("PetalUtil.,_16") + b;
    }

    public static String trimQuotes(String str) {
        int f_ind = str.indexOf(QUOTE);
        int l_ind = str.lastIndexOf(QUOTE);
        if (f_ind == -1) {
            return str;
        }
        if (f_ind == l_ind) {
            return str.substring(f_ind + 1);
        }
        return str.substring(f_ind + 1, l_ind);
    }

    public static String getType(String str) {
        return PetalUtil.getWord(str, 1);
    }

    public static String getName(String str) {
        int ind_end = str.lastIndexOf(QUOTE);
        if (ind_end == -1) {
            return null;
        }
        String temp = str.substring(0, ind_end);
        int ind_start = temp.lastIndexOf(QUOTE);
        if (ind_start == -1) {
            return null;
        }
        ArrayList<Integer> quoteIndexList = null;
        while (ind_start > 0 && temp.charAt(ind_start - 1) == '\\') {
            temp = temp.substring(0, ind_start - 1);
            if (quoteIndexList == null) {
                quoteIndexList = new ArrayList<Integer>();
            }
            quoteIndexList.add(new Integer(ind_start - 1));
            ind_start = temp.lastIndexOf(QUOTE);
        }
        String name = str.substring(ind_start + 1, ind_end);
        if (name.indexOf("$UNNAMED") != -1) {
            name = "";
        }
        if (quoteIndexList != null) {
            StringBuffer nameBuffer = new StringBuffer(name);
            Iterator iter = quoteIndexList.iterator();
            while (iter.hasNext()) {
                Integer integer = (Integer)iter.next();
                nameBuffer.replace(integer - ind_start - 1, integer - ind_start, "");
            }
            name = nameBuffer.toString();
        }
        return name;
    }

    public static String getWord(String str, int n) {
        StringTokenizer st = new StringTokenizer(str);
        int i = 0;
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            if (++i != n) continue;
            return tok;
        }
        return null;
    }

    public static String excludeIncorrectChars(String text) {
        if (text == null) {
            return null;
        }
        char[] chars = new char[text.length()];
        text.getChars(0, chars.length, chars, 0);
        boolean hasChanged = false;
        int i = 0;
        while (i < chars.length) {
            char aChar = chars[i];
            if (aChar >= '\u0000' && aChar < ' ' && aChar != '\n' && aChar != '\r') {
                chars[i] = 32;
                hasChanged = true;
            }
            ++i;
        }
        return hasChanged ? new String(chars) : text;
    }

    public static String getWord(String str, String delim, int n) {
        StringTokenizer st = new StringTokenizer(str, delim);
        int i = 0;
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            if (++i != n) continue;
            return tok;
        }
        return null;
    }

    public static boolean isActorView(IPetalNode petalNode) {
        String icon = petalNode.getProperty("icon");
        if (icon != null) {
            icon = icon.toLowerCase();
        }
        return actorViews.contains(icon);
    }

    public static boolean isSrcView(String petalNodeType) {
        return srcViews.contains(petalNodeType);
    }

    public static boolean isSrcLinkView(String petalNodeType) {
        return srcLinkViews.contains(petalNodeType);
    }

    public static boolean isDesignNode(String petalNodeType) {
        return design_nodes.contains(petalNodeType);
    }
}

