/*
 * Decompiled with CFR 0.152.
 */
package com.borland.mdlimport.mapping.providers;

import com.borland.mdlimport.mapping.IPropertyProvider;
import com.borland.mdlimport.petal.IPetalNode;
import com.borland.util.IProperty;
import com.borland.util.PropertyAdapter;

public class TransitionProviders {
    public static final IPropertyProvider SEND_CLAUSE_PROVIDER = new IPropertyProvider(){

        public boolean isApplicable(String metaclass) {
            return "Transition".equals(metaclass) || "Internal Transition".equals(metaclass);
        }

        public String[] getSupportedProperties() {
            return new String[]{"$send_clause"};
        }

        public IProperty[] evaluatePropertyValues(String metaclass, String[] propertyNames, IPetalNode petalNode) {
            IPetalNode sourceNode = "Transition".equals(metaclass) ? petalNode.findNodeWithKey("sendEvent") : petalNode;
            String sendTarget = sourceNode.getProperty("target");
            String sendEventName = sourceNode.getProperty("Event");
            String sendArgs = sourceNode.getProperty("parameters");
            StringBuffer result = new StringBuffer();
            if (sendTarget != null) {
                result.append(sendTarget).append(".");
            }
            if ((sendTarget != null || sendArgs != null) && sendEventName == null) {
                sendEventName = "<undefined>";
            }
            if (sendEventName != null) {
                result.append(sendEventName);
            }
            if (sendArgs != null) {
                result.append("(").append(sendArgs).append(")");
            }
            if (result.length() == 0) {
                return new IProperty[0];
            }
            return new IProperty[]{new PropertyAdapter("$send_clause", result.toString())};
        }
    };
    public static final IPropertyProvider EVENT_PROVIDER = new IPropertyProvider(){

        public boolean isApplicable(String metaclass) {
            return "Transition".equals(metaclass) || "Internal Transition".equals(metaclass);
        }

        public String[] getSupportedProperties() {
            return new String[]{"$event_arguments", "$event_name", "$name"};
        }

        public IProperty[] evaluatePropertyValues(String metaclass, String[] propertyNames, IPetalNode petalNode) {
            IPetalNode event = null;
            String type = null;
            if ("Transition".equals(metaclass)) {
                event = petalNode.findNodeWithKey("Event");
            } else if ("Internal Transition".equals(metaclass)) {
                IPetalNode actionTime = petalNode.findNodeWithKey("ActionTime");
                type = actionTime.getProperty("when");
                IPetalNode iPetalNode = event = actionTime == null ? null : actionTime.findNodeWithKey("Event");
            }
            if (event == null) {
                if (type != null) {
                    return new IProperty[]{new PropertyAdapter("$name", type)};
                }
                return new IProperty[0];
            }
            IProperty[] props = new IProperty[propertyNames.length];
            int i = 0;
            while (i < propertyNames.length) {
                if ("$event_arguments".equals(propertyNames[i])) {
                    props[i] = new PropertyAdapter("$event_arguments", event.getProperty("parameters"));
                } else if ("$event_name".equals(propertyNames[i]) && "Transition".equals(metaclass)) {
                    props[i] = new PropertyAdapter("$event_name", event.getName());
                } else if ("$name".equals(propertyNames[i]) && "Internal Transition".equals(metaclass)) {
                    props[i] = new PropertyAdapter("$name", event.getName());
                }
                ++i;
            }
            return props;
        }
    };
    public static final IPropertyProvider ACTION_EXPRESSION_PROVIDER = new IPropertyProvider(){

        public boolean isApplicable(String metaclass) {
            return "Transition".equals(metaclass) || "Internal Transition".equals(metaclass);
        }

        public String[] getSupportedProperties() {
            return new String[]{"$action_expression"};
        }

        public IProperty[] evaluatePropertyValues(String metaclass, String[] propertyNames, IPetalNode petalNode) {
            if ("Internal Transition".equals(metaclass)) {
                if (!"action".equals(petalNode.getType())) {
                    return new IProperty[0];
                }
                return new IProperty[]{new PropertyAdapter("$action_expression", petalNode.getName())};
            }
            if ("Transition".equals(metaclass)) {
                return new IProperty[]{new PropertyAdapter("$action_expression", petalNode.getProperty("action"))};
            }
            return new IProperty[0];
        }
    };
    public static final IPropertyProvider GUARD_CONDITION_PROVIDER = new IPropertyProvider(){

        public boolean isApplicable(String metaclass) {
            return "Internal Transition".equals(metaclass);
        }

        public String[] getSupportedProperties() {
            return new String[]{"$guard_condition"};
        }

        public IProperty[] evaluatePropertyValues(String metaclass, String[] propertyNames, IPetalNode petalNode) {
            IPetalNode actionTime = petalNode.findNodeWithKey("ActionTime");
            if (actionTime == null) {
                return new IProperty[0];
            }
            return new IProperty[]{new PropertyAdapter("$guard_condition", actionTime.getProperty("condition"))};
        }
    };
}

