/*
 * Decompiled with CFR 0.152.
 */
package com.borland.mdlimport.mapping.providers;

import com.borland.mdlimport.Configuration;
import com.borland.mdlimport.mapping.IPropertyProvider;
import com.borland.mdlimport.petal.IPetalNode;
import com.borland.mdlimport.util.Logger;
import com.borland.util.IProperty;
import com.borland.util.PropertyAdapter;
import com.borland.util.Resources;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class HyperlinkPropertyProvider
implements IPropertyProvider {
    private Configuration myConfig;

    public HyperlinkPropertyProvider(Configuration config) {
        this.myConfig = config;
    }

    public boolean isApplicable(String metaclass) {
        return true;
    }

    public String[] getSupportedProperties() {
        return new String[]{"@url"};
    }

    public IProperty[] evaluatePropertyValues(String metaclass, String[] propertyNames, IPetalNode petalNode) {
        IPetalNode ext_docs = petalNode.findNodeWithKey("external_docs");
        if (ext_docs == null) {
            return null;
        }
        List hyperlinkNodes = ext_docs.findNodesWithType("external_doc");
        Iterator iter = hyperlinkNodes.iterator();
        Vector<String> hyperlinks = new Vector<String>();
        while (iter.hasNext()) {
            IPetalNode nextNode = (IPetalNode)iter.next();
            String docPath = nextNode.getProperty("external_doc_path");
            if (docPath != null) {
                hyperlinks.add("file:" + this.insertConstantValue(docPath));
                continue;
            }
            String docUrl = nextNode.getProperty("external_doc_url");
            if (docUrl == null) continue;
            hyperlinks.add(this.insertConstantValue(docUrl));
        }
        if (hyperlinks.size() == 0) {
            return null;
        }
        String[] values = hyperlinks.toArray(new String[hyperlinks.size()]);
        PropertyAdapter multProp = new PropertyAdapter("@url", values);
        return new IProperty[]{multProp};
    }

    private String insertConstantValue(String name) {
        String result = name;
        if (name != null && name.startsWith("$")) {
            String paramValue = "";
            int fileSepIndex = (name = name.replace('\\', com.borland.util.File.separatorChar)).indexOf(File.separator);
            String mdlParam = fileSepIndex == -1 ? name.substring(1) : name.substring(1, fileSepIndex);
            paramValue = this.myConfig.getMdlOption(mdlParam);
            if (paramValue == null) {
                Logger.getInstance().log("visitor", 1, String.valueOf(Resources.getString("PetalUtil.Using_model_directory_as_value_of_parameter__12")) + mdlParam);
                paramValue = this.myConfig.petalFile.getParent();
            }
            result = String.valueOf(paramValue) + File.separatorChar + name.substring(mdlParam.length() + 2);
        }
        return result;
    }
}

