/*
 * Decompiled with CFR 0.152.
 */
package com.borland.mdlimport.mapping.providers;

import com.borland.util.IExtractor;

public class Extractors {
    public static final IExtractor CUT_QUOTES = new IExtractor(){

        public Object extract(Object source) {
            if (source == null || !(source instanceof String)) {
                return null;
            }
            String srcString = (String)source;
            if (srcString.startsWith("")) {
                srcString = srcString.substring(1);
            }
            if (srcString.endsWith("")) {
                srcString = srcString.substring(0, srcString.length() - 1);
            }
            return srcString;
        }
    };
    public static final IExtractor TO_LOWER_CASE = new IExtractor(){

        public Object extract(Object source) {
            if (source == null || !(source instanceof String)) {
                return null;
            }
            return ((String)source).toLowerCase();
        }
    };
    public static final IExtractor EMPTY_TRUE = new IExtractor(){

        public Object extract(Object source) {
            if (source == null || !(source instanceof String)) {
                return null;
            }
            if ("TRUE".equals(source)) {
                return "";
            }
            return null;
        }
    };

    public static class COMPOUND_EXTRACTOR
    implements IExtractor {
        private IExtractor[] myExtractors;

        public COMPOUND_EXTRACTOR(IExtractor[] extractors) {
            this.myExtractors = extractors;
        }

        public Object extract(Object source) {
            if (this.myExtractors == null) {
                return source;
            }
            Object value = source;
            int i = 0;
            while (i < this.myExtractors.length) {
                if (value == null) {
                    return null;
                }
                value = this.myExtractors[i].extract(value);
                ++i;
            }
            return value;
        }
    }
}

