/*
 * Decompiled with CFR 0.152.
 */
package com.borland.mdlimport.mapping;

import com.borland.mdlimport.codegen.IClassifier;
import com.borland.mdlimport.codegen.ICodeElement;
import com.borland.mdlimport.codegen.IField;
import com.borland.mdlimport.codegen.IMethod;
import com.borland.mdlimport.impl.codegen.java.JavaUtil;
import com.borland.mdlimport.impl.petal.SourceModelUtil;
import com.borland.mdlimport.txv.IIdentifiable;
import com.borland.mdlimport.txv.ILink;
import com.borland.mdlimport.txv.INode;
import com.borland.mdlimport.txv.IView;
import java.util.LinkedList;
import java.util.Random;

public class UinSupport {
    public static final String ASSOCIATION_END_DOMAIN = "association-end";
    public static final String JDT_DOMAIN = "jdt";
    public static final String DESIGN_DOMAIN = "design";
    public static final String SRCMDL_CONNECTOR_ASPECT_DOMAIN = "srcmdl.connectoraspect";
    public static final String SRCMDL_LINK_ASPECT_DOMAIN = "srcmdl.linkaspect";
    public static final String NODE_SUBDOMAIN = "node";
    public static final String LINK_SUBDOMAIN = "link";
    public static final String VIEW_SUBDOMAIN = "view";
    private static final Random RANDOM_UIN_CREATOR = new Random();
    private static final String SEPARATOR = ":";
    private static final char SEPARATOR_CHAR = ':';

    public static String getFqnByEClassRef(String eClassRefUin) {
        if (eClassRefUin == null) {
            return null;
        }
        int index = eClassRefUin.lastIndexOf(58);
        if (index == -1) {
            return null;
        }
        return eClassRefUin.substring(index + 1);
    }

    public static String getNodeUin(String refuin) {
        if (refuin == null) {
            return null;
        }
        int i = 0;
        while (i <= 3) {
            int index = refuin.indexOf(SEPARATOR);
            if (index != -1) {
                refuin = refuin.substring(index + 1);
            }
            ++i;
        }
        int index = refuin.indexOf(SEPARATOR);
        if (index == -1) {
            return refuin;
        }
        return refuin.substring(0, index);
    }

    public static String newDesignUin(String metaclass) {
        return String.valueOf(Integer.toString(metaclass.hashCode(), 36)) + Long.toString(System.currentTimeMillis(), 36) + Integer.toString(RANDOM_UIN_CREATOR.nextInt(), 36);
    }

    public static String getReferencedUinForAssLink(String refUinPart) {
        return UinSupport.createUniqueName(JDT_DOMAIN, "l_ast", "src", refUinPart, null);
    }

    public static String getReferencedUinForAssEnd(IField field) {
        String className = field.getClassifier().getQualifiedName();
        String fieldName = field.getShortName();
        return UinSupport.createUniqueName(ASSOCIATION_END_DOMAIN, "l_ast", "src", className, new String[]{fieldName});
    }

    public static String getDesignReferencedUin(IIdentifiable element) {
        String subDomain = UinSupport.getSubDomain(element);
        String[] parentsChain = UinSupport.createParentsChain(element);
        return UinSupport.createUniqueName(DESIGN_DOMAIN, subDomain, null, null, parentsChain);
    }

    public static String getDependencyReferencedUin(String clientFqn, String supplierFqn) {
        if (clientFqn == null || supplierFqn == null) {
            return null;
        }
        String subDomain = "l_dpn";
        String location = "src";
        String name = clientFqn;
        String[] lastPart = new String[]{supplierFqn};
        return UinSupport.createUniqueName(JDT_DOMAIN, subDomain, location, name, lastPart);
    }

    public static String getInheritanceReferencedUin(int inherType, String clientFqn, String supplierFqn) {
        if (clientFqn == null || supplierFqn == null) {
            return null;
        }
        String subDomain = "l_gnt";
        if (inherType == 1) {
            subDomain = "l_impl";
        }
        String location = "src";
        String name = clientFqn;
        String[] lastPart = new String[]{supplierFqn};
        return UinSupport.createUniqueName(JDT_DOMAIN, subDomain, location, name, lastPart);
    }

    public static String getReferencedUinForAspect(String assClassFqn) {
        return UinSupport.createUniqueName(SRCMDL_LINK_ASPECT_DOMAIN, "e_class", "src", assClassFqn, null);
    }

    public static String getReferencedUinForConnector(String assClassFqn) {
        return UinSupport.createUniqueName(SRCMDL_CONNECTOR_ASPECT_DOMAIN, "e_class", "src", assClassFqn, null);
    }

    public static String getReferencedUinByFqn(String fQN) {
        return UinSupport.createUniqueName(JDT_DOMAIN, "e_class", "src", fQN, null);
    }

    public static String getClassifierReferencedUin(String classifierFqn) {
        String subDomain = "e_class";
        String location = "src";
        String name = classifierFqn;
        return UinSupport.createUniqueName(JDT_DOMAIN, subDomain, location, name, null);
    }

    public static String getSourceReferencedUin(ICodeElement srcElement) {
        String subDomain = UinSupport.getSourceElementDomain(srcElement);
        String location = "src";
        String name = UinSupport.getSourceElementName(srcElement);
        String[] lastPart = UinSupport.getSourceLastPart(srcElement);
        return UinSupport.createUniqueName(JDT_DOMAIN, subDomain, location, name, lastPart);
    }

    public static String getSourceElementDomain(ICodeElement srcElement) {
        if (srcElement instanceof IClassifier) {
            return "e_class";
        }
        if (srcElement instanceof IMethod) {
            return "e_method";
        }
        if (srcElement instanceof IField) {
            return "e_field";
        }
        return null;
    }

    public static String getSourceElementName(ICodeElement srcElement) {
        if (srcElement instanceof IClassifier) {
            return srcElement.getQualifiedName();
        }
        if (srcElement instanceof IMethod) {
            return SourceModelUtil.removeParameters(srcElement.getQualifiedName());
        }
        if (srcElement instanceof IField) {
            return srcElement.getQualifiedName();
        }
        return null;
    }

    public static String[] getSourceLastPart(ICodeElement srcElement) {
        if (srcElement instanceof IMethod) {
            return new String[]{JavaUtil.getRuntimeSignature((IMethod)srcElement)};
        }
        return null;
    }

    public static String getSubDomain(IIdentifiable element) {
        if (element instanceof INode) {
            return NODE_SUBDOMAIN;
        }
        if (element instanceof ILink) {
            return LINK_SUBDOMAIN;
        }
        if (element instanceof IView) {
            return VIEW_SUBDOMAIN;
        }
        return null;
    }

    public static String[] createParentsChain(IIdentifiable element) {
        LinkedList<String> chain = new LinkedList<String>();
        IIdentifiable ancestor = element;
        while (ancestor != null) {
            String curUin = ancestor.getUin();
            if (curUin == null || chain.contains(curUin)) break;
            chain.add(curUin);
            ancestor = ancestor.getParent();
        }
        return chain.toArray(new String[chain.size()]);
    }

    public static String createUniqueName(String domain, String subDomain, String location, String name, String[] parameters) {
        StringBuffer result = new StringBuffer();
        result.append(domain);
        result.append(SEPARATOR).append(subDomain == null ? "" : subDomain);
        result.append(SEPARATOR).append(location == null ? "" : location);
        result.append(SEPARATOR).append(name == null ? "" : name);
        if (parameters != null && parameters.length > 0) {
            int i = 0;
            while (i < parameters.length) {
                result.append(SEPARATOR).append(parameters[i]);
                ++i;
            }
        }
        while (result.charAt(result.length() - 1) == ':') {
            result.delete(result.length() - 1, result.length());
        }
        return result.toString();
    }
}

