/*
 * Decompiled with CFR 0.152.
 */
package com.borland.mdlimport.mapping;

import com.borland.mdlimport.mapping.ITypeMapper;
import com.borland.mdlimport.petal.IPetalNode;
import java.util.HashMap;

public class MetaclassMapping {
    private static HashMap metaclassMap = new HashMap();
    private static HashMap myMappers = new HashMap();
    private static final ITypeMapper SIMPLE_MAPPER = new ITypeMapper(){

        public String getMetaclass(String roseType, IPetalNode petalNode) {
            return (String)metaclassMap.get(roseType);
        }
    };

    public static String getMetaclass(IPetalNode petalNode) {
        if (petalNode == null) {
            return null;
        }
        if (petalNode.getPetalNodeType() != 2) {
            return null;
        }
        String type = petalNode.getType();
        ITypeMapper mapper = (ITypeMapper)myMappers.get(type);
        return mapper == null ? null : mapper.getMetaclass(type, petalNode);
    }

    public static void registerRoseTypeMapper(String roseType, ITypeMapper mapper) {
        myMappers.put(roseType, mapper);
    }

    public static void registerSimpleRoseTypeMapper(String roseType, String metaclass) {
        metaclassMap.put(roseType, metaclass);
        myMappers.put(roseType, SIMPLE_MAPPER);
    }

    public static void cleanUp() {
        metaclassMap = new HashMap();
        myMappers = new HashMap();
    }
}

