/*
 * Decompiled with CFR 0.152.
 */
package com.borland.mdlimport.mapping;

import com.borland.mdlimport.Configuration;
import com.borland.mdlimport.Importer;
import com.borland.mdlimport.codegen.ICodeElement;
import com.borland.mdlimport.codegen.IField;
import com.borland.mdlimport.command.CommandProcessor;
import com.borland.mdlimport.impl.petal.DesignModelUtil;
import com.borland.mdlimport.impl.petal.SourceModelUtil;
import com.borland.mdlimport.mapping.ITypeMapper;
import com.borland.mdlimport.mapping.MetaclassMapping;
import com.borland.mdlimport.mapping.PropertyMapping;
import com.borland.mdlimport.mapping.UinSupport;
import com.borland.mdlimport.mapping.providers.BooleanPropertyProvider;
import com.borland.mdlimport.mapping.providers.ComponentTypeProvider;
import com.borland.mdlimport.mapping.providers.ControlFlowProvider;
import com.borland.mdlimport.mapping.providers.CustomPropertyProvider;
import com.borland.mdlimport.mapping.providers.DocumentationProvider;
import com.borland.mdlimport.mapping.providers.Extractors;
import com.borland.mdlimport.mapping.providers.HyperlinkPropertyProvider;
import com.borland.mdlimport.mapping.providers.NotePropertyProvider;
import com.borland.mdlimport.mapping.providers.OperationConditionsProvider;
import com.borland.mdlimport.mapping.providers.PetalNameProvider;
import com.borland.mdlimport.mapping.providers.PetalValueProvider;
import com.borland.mdlimport.mapping.providers.ProviderWrapper;
import com.borland.mdlimport.mapping.providers.TransitionProviders;
import com.borland.mdlimport.petal.IElementListener;
import com.borland.mdlimport.petal.IPetalNode;
import com.borland.mdlimport.petal.PetalUtil;
import com.borland.mdlimport.txv.IElement;
import com.borland.mdlimport.txv.ILink;
import com.borland.mdlimport.txv.INode;
import com.borland.mdlimport.txv.TxvAccess;
import com.borland.util.IExtractor;
import com.borland.util.ITokenizer;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class DefaultMapping {
    public static void registerDefaults(Importer importer) {
        DefaultMapping.registerTypeMappers(importer);
        DefaultMapping.registerPropertyProviders(importer);
        DefaultMapping.registerElementListener(importer);
    }

    public static void registerTypeMappers(final Importer importer) {
        MetaclassMapping.registerSimpleRoseTypeMapper("ClassDiagram", "Class Diagram");
        MetaclassMapping.registerSimpleRoseTypeMapper("UseCaseDiagram", "Use Case Diagram");
        MetaclassMapping.registerSimpleRoseTypeMapper("State_Diagram", "State Diagram");
        MetaclassMapping.registerSimpleRoseTypeMapper("ActivityDiagram", "Activity Diagram");
        MetaclassMapping.registerSimpleRoseTypeMapper("Process_Diagram", "Deployment Diagram");
        MetaclassMapping.registerSimpleRoseTypeMapper("Module_Diagram", "Component Diagram");
        MetaclassMapping.registerSimpleRoseTypeMapper("InteractionDiagram", "Sequence Diagram");
        MetaclassMapping.registerSimpleRoseTypeMapper("ObjectDiagram", "Collaboration Diagram");
        MetaclassMapping.registerSimpleRoseTypeMapper("Class_Category", "Package");
        MetaclassMapping.registerSimpleRoseTypeMapper("Operation", "Operation");
        MetaclassMapping.registerSimpleRoseTypeMapper("ClassAttribute", "Attribute");
        MetaclassMapping.registerSimpleRoseTypeMapper("ActivityState", "Activity");
        MetaclassMapping.registerSimpleRoseTypeMapper("Decision", "Decision");
        MetaclassMapping.registerSimpleRoseTypeMapper("Partition", "Swimlane");
        MetaclassMapping.registerSimpleRoseTypeMapper("UseCase", "Use Case");
        MetaclassMapping.registerSimpleRoseTypeMapper("ClassInstance", "Object");
        MetaclassMapping.registerSimpleRoseTypeMapper("SynchronizationState", "Synchronization Bar");
        MetaclassMapping.registerSimpleRoseTypeMapper("module", "Component");
        MetaclassMapping.registerSimpleRoseTypeMapper("SubSystem", "Subsystem");
        MetaclassMapping.registerSimpleRoseTypeMapper("Processes", "Package");
        MetaclassMapping.registerSimpleRoseTypeMapper("Processor", "Node");
        MetaclassMapping.registerSimpleRoseTypeMapper("Device", "Node");
        MetaclassMapping.registerSimpleRoseTypeMapper("sendEvent", "Internal Transition");
        MetaclassMapping.registerSimpleRoseTypeMapper("action", "Internal Transition");
        MetaclassMapping.registerSimpleRoseTypeMapper("Object", "Object");
        MetaclassMapping.registerSimpleRoseTypeMapper("Parameter", "mod_shapeParameter");
        MetaclassMapping.registerSimpleRoseTypeMapper("Realize_Relationship", "Implementation Link");
        MetaclassMapping.registerSimpleRoseTypeMapper("Inheritance_Relationship", "Generalization Link");
        MetaclassMapping.registerSimpleRoseTypeMapper("Uses_Relationship", "Dependency Link");
        MetaclassMapping.registerSimpleRoseTypeMapper("Visibility_Relationship", "Dependency Link");
        MetaclassMapping.registerSimpleRoseTypeMapper("Dependency_Relationship", "Dependency Link");
        MetaclassMapping.registerSimpleRoseTypeMapper("Module_Visibility_Relationship", "Dependency Link");
        MetaclassMapping.registerSimpleRoseTypeMapper("Association", "Association Link");
        MetaclassMapping.registerSimpleRoseTypeMapper("State_Transition", "Transition");
        MetaclassMapping.registerSimpleRoseTypeMapper("Connection_Relationship", "Dependency Link");
        MetaclassMapping.registerSimpleRoseTypeMapper("Message", "Message Link");
        MetaclassMapping.registerSimpleRoseTypeMapper("Link", "Messages Link");
        MetaclassMapping.registerSimpleRoseTypeMapper("AttachView", "Note Link");
        MetaclassMapping.registerSimpleRoseTypeMapper("Object_Flow", "Object Flow");
        MetaclassMapping.registerSimpleRoseTypeMapper("Parameterized_Class", "Class");
        MetaclassMapping.registerSimpleRoseTypeMapper("Class_Utility", "Class");
        MetaclassMapping.registerSimpleRoseTypeMapper("Parameterized_Class_Utility", "Class");
        MetaclassMapping.registerSimpleRoseTypeMapper("Instantiated_Class", "Class");
        MetaclassMapping.registerSimpleRoseTypeMapper("Metaclass", "Class");
        MetaclassMapping.registerRoseTypeMapper("Class", new ITypeMapper(){

            public String getMetaclass(String roseType, IPetalNode petalNode) {
                String stereotype;
                IPetalNode stereotypeNode = petalNode.findNodeWithKey("stereotype");
                String string = stereotype = stereotypeNode == null ? null : PetalUtil.getName(stereotypeNode.getValue());
                if (importer.getConfiguration().actors && ("Actor".equalsIgnoreCase(stereotype) || "Business Actor".equalsIgnoreCase(stereotype) || "Business Worker".equalsIgnoreCase(stereotype) || "Physical Worker".equalsIgnoreCase(stereotype))) {
                    return "Actor";
                }
                return "Class";
            }
        });
        MetaclassMapping.registerRoseTypeMapper("Label", new ITypeMapper(){

            public String getMetaclass(String roseType, IPetalNode petalNode) {
                String key = petalNode.getType();
                if (key != null && key.startsWith(roseType)) {
                    return "Note";
                }
                return null;
            }
        });
        MetaclassMapping.registerRoseTypeMapper("NoteView", new ITypeMapper(){

            public String getMetaclass(String roseType, IPetalNode petalNode) {
                return roseType.equals(petalNode.getType()) ? "Note" : null;
            }
        });
        MetaclassMapping.registerRoseTypeMapper("State", new ITypeMapper(){

            public String getMetaclass(String roseType, IPetalNode petalNode) {
                String type = petalNode.getProperty("type");
                if (type == null || "Normal".equals(type)) {
                    return "State";
                }
                if ("StartState".equals(type)) {
                    return "Start State";
                }
                if ("EndState".equals(type)) {
                    return "End State";
                }
                if ("History".equals(type) || "HistoryAll".equals(type)) {
                    return "History";
                }
                return null;
            }
        });
    }

    public static void registerElementListener(final Importer importer) {
        importer.getVisitor().addElementListener(new IElementListener(){

            public void designElementCreated(IElement element, IPetalNode petalNode) {
                String type;
                String metaclass = element.getMetaclass();
                if ("History".equals(metaclass) && "HistoryAll".equals(type = petalNode.getProperty("type"))) {
                    element.setProperty("$deep", "true");
                }
                if ("Class".equals(metaclass) || "Operation".equals(metaclass) || "Attribute".equals(metaclass)) {
                    IPetalNode staticNode;
                    String visibility;
                    String finalValue = petalNode.getInnerAttributeType("Java", "Final");
                    element.setProperty("@mod__final", "FALSE".equals(finalValue) || finalValue == null ? null : "");
                    IPetalNode subNode = petalNode.findNodeWithKey("abstract");
                    if (subNode != null) {
                        element.setProperty("@mod__abstract", "");
                    } else {
                        String abstractValue = petalNode.getInnerAttributeType("Java", "Abstract");
                        element.setProperty("@mod__abstract", "FALSE".equals(abstractValue) || abstractValue == null ? null : "");
                    }
                    String string = visibility = "Operation".equals(metaclass) ? petalNode.getProperty("opExportControl") : petalNode.getProperty("exportControl");
                    if ("Implementation".equals(visibility)) {
                        element.setProperty("@mod_Visibility", "$packageLocal");
                    } else if ("Attribute".equals(metaclass)) {
                        element.setProperty("@mod_Visibility", "$" + (visibility == null ? SourceModelUtil.getDefaultVisibility("field") : visibility.toLowerCase()));
                    } else {
                        element.setProperty("@mod_Visibility", "$" + (visibility == null ? SourceModelUtil.getDefaultVisibility("classifier") : visibility.toLowerCase()));
                    }
                    String documentation = petalNode.getMultiLinedProperty("documentation");
                    if (documentation != null) {
                        element.setProperty("$description", documentation);
                    }
                    if ((staticNode = petalNode.findNodeWithKey("static")) != null) {
                        element.setProperty("@mod__static", "");
                    } else {
                        String staticValue = petalNode.getInnerAttributeType("Java", "Static");
                        element.setProperty("@mod__static", "FALSE".equals(staticValue) || staticValue == null ? null : "");
                    }
                    String persistence = petalNode.getProperty("persistence");
                    if (persistence != null && "Persistent".equals(persistence)) {
                        element.setProperty("@persistent", "true");
                    }
                    if ("Class".equals(metaclass)) {
                        String stereotype = petalNode.getProperty("stereotype");
                        if ("Interface".equals(stereotype)) {
                            element.setProperty("@mod__interface", "");
                        }
                    } else if ("Attribute".equals(metaclass)) {
                        String initialValue = petalNode.getMultiLinedProperty("initv");
                        if (initialValue != null) {
                            element.setProperty("@mod__initialValue", initialValue);
                        }
                        this.setReferencedProperty(element, "@mod__typeReferencedElement", petalNode.getQuidu(), false);
                        this.setTypeProperty(element, "@mod__type", "type", petalNode, false);
                    } else if ("Operation".equals(metaclass)) {
                        this.setReferencedProperty(element, "@mod__returnTypeReferencedElement", petalNode.getQuidu(), false);
                        this.setTypeProperty(element, "@mod__returnType", "result", petalNode, false);
                        String exceptions = petalNode.getProperty("exceptions");
                        if (exceptions != null) {
                            StringTokenizer st = new StringTokenizer(exceptions, ",");
                            while (st.hasMoreTokens()) {
                                String next = st.nextToken().trim();
                                String[] all = ITokenizer.NAME_AND_QUID.tokens(next);
                                String quidu = all[1];
                                if (!importer.getConfiguration().inPackage) {
                                    this.setReferencedProperty(element, "@mod__throwReferencedElement", quidu, true);
                                }
                                INode class_ = TxvAccess.findNode(quidu);
                                Runnable addFqnToProperty = new Runnable(this, quidu, element, importer){
                                    final /* synthetic */ 5 this$1;
                                    private final /* synthetic */ String val$quidu;
                                    private final /* synthetic */ IElement val$element;
                                    private final /* synthetic */ Importer val$importer;
                                    {
                                        this.this$1 = var1_1;
                                        this.val$quidu = string;
                                        this.val$element = iElement;
                                        this.val$importer = importer;
                                    }

                                    public void run() {
                                        INode classDef = TxvAccess.findNode(this.val$quidu);
                                        String oldValue = this.val$element.getPropertyValue("@mod__throw");
                                        String elementFqn = DesignModelUtil.getFqn((INode)this.val$element.getParent());
                                        String fqn = DesignModelUtil.getFqn(classDef);
                                        String typeFqn = DesignModelUtil.getCorrectFqnForType(elementFqn, fqn);
                                        if (!this.val$importer.getConfiguration().inPackage) {
                                            if (oldValue != null) {
                                                typeFqn = String.valueOf(oldValue) + "," + typeFqn;
                                            }
                                            this.val$element.setProperty("@mod__throw", typeFqn);
                                        } else {
                                            if (this.val$element.getParent() != null) {
                                                INode parent = (INode)this.val$element.getParent();
                                                ILink link = TxvAccess.createLink("RaisedExceptionLink", "", UinSupport.getDesignReferencedUin(parent), UinSupport.getDesignReferencedUin(classDef));
                                                ((INode)this.val$element).addLink(link);
                                                link.addProperty("@throws", typeFqn);
                                            }
                                            this.val$element.addProperty("@throws", typeFqn);
                                        }
                                    }
                                };
                                if (class_ != null) {
                                    addFqnToProperty.run();
                                    continue;
                                }
                                if (quidu != null) {
                                    CommandProcessor.runCommandLater(addFqnToProperty, "onTxvCreation", quidu);
                                    continue;
                                }
                                String addingFqn = SourceModelUtil.convertRoseFqn(all[0]);
                                if (addingFqn == null) continue;
                                if (!importer.getConfiguration().inPackage) {
                                    String oldValue = element.getPropertyValue("@mod__throw");
                                    oldValue = oldValue != null ? String.valueOf(oldValue) + "," : "";
                                    element.setProperty("@mod__throw", String.valueOf(oldValue) + addingFqn);
                                    continue;
                                }
                                element.addProperty("@throws", addingFqn);
                            }
                        }
                    }
                }
                if ("mod_shapeParameter".equals(metaclass)) {
                    this.setReferencedProperty(element, "@mod__typeReferencedElement", petalNode.getQuidu(), false);
                    this.setTypeProperty(element, "@mod__type", "type", petalNode, false);
                }
            }

            private void setTypeProperty(IElement element, String propertyName, String rosePropName, IPetalNode petalNode, boolean isAdding) {
                String quidu = petalNode.getQuidu();
                if (quidu != null) {
                    INode classType = TxvAccess.findNode(quidu);
                    Runnable setType = new Runnable(this, quidu, element, isAdding, propertyName){
                        final /* synthetic */ 5 this$1;
                        private final /* synthetic */ String val$quidu;
                        private final /* synthetic */ IElement val$element;
                        private final /* synthetic */ boolean val$isAdding;
                        private final /* synthetic */ String val$propertyName;
                        {
                            this.this$1 = var1_1;
                            this.val$quidu = string;
                            this.val$element = iElement;
                            this.val$isAdding = bl;
                            this.val$propertyName = string2;
                        }

                        public void run() {
                            INode classTypeDef = TxvAccess.findNode(this.val$quidu);
                            String elementFqn = DesignModelUtil.getFqn((INode)this.val$element.getParent());
                            String typeFqn = DesignModelUtil.getFqn(classTypeDef);
                            if (this.val$isAdding) {
                                this.val$element.addProperty(this.val$propertyName, DesignModelUtil.getCorrectFqnForType(elementFqn, typeFqn));
                            } else {
                                this.val$element.setProperty(this.val$propertyName, DesignModelUtil.getCorrectFqnForType(elementFqn, typeFqn));
                            }
                        }
                    };
                    if (classType != null) {
                        setType.run();
                    } else {
                        CommandProcessor.runCommandLater(setType, "onTxvCreation", quidu);
                    }
                } else {
                    String type = SourceModelUtil.convertRoseFqn(petalNode.getProperty(rosePropName));
                    if (type != null) {
                        element.setProperty(propertyName, type);
                    }
                }
            }

            private void setReferencedProperty(IElement element, String propertyName, String quidu, boolean isAdding) {
                if (quidu == null) {
                    return;
                }
                INode classType = TxvAccess.findNode(quidu);
                Runnable setType = new Runnable(this, quidu, isAdding, element, propertyName){
                    final /* synthetic */ 5 this$1;
                    private final /* synthetic */ String val$quidu;
                    private final /* synthetic */ boolean val$isAdding;
                    private final /* synthetic */ IElement val$element;
                    private final /* synthetic */ String val$propertyName;
                    {
                        this.this$1 = var1_1;
                        this.val$quidu = string;
                        this.val$isAdding = bl;
                        this.val$element = iElement;
                        this.val$propertyName = string2;
                    }

                    public void run() {
                        INode classTypeDef = TxvAccess.findNode(this.val$quidu);
                        if (this.val$isAdding) {
                            this.val$element.addProperty(this.val$propertyName, UinSupport.getDesignReferencedUin(classTypeDef));
                        } else {
                            this.val$element.setProperty(this.val$propertyName, UinSupport.getDesignReferencedUin(classTypeDef));
                        }
                    }
                };
                if (classType != null) {
                    setType.run();
                } else {
                    CommandProcessor.runCommandLater(setType, "onTxvCreation", quidu);
                }
            }

            public void srcElementCreated(ICodeElement srcElement, IPetalNode petalNode) {
                IPetalNode abstractNode;
                IPetalNode staticNode;
                String type = srcElement.getCodeElementType();
                String visibility = "method".equals(type) ? petalNode.getProperty("opExportControl") : petalNode.getProperty("exportControl");
                visibility = visibility == null ? SourceModelUtil.getDefaultVisibility(type) : SourceModelUtil.convertVisibility(visibility);
                srcElement.setVisibility(visibility);
                String documentation = petalNode.getMultiLinedProperty("documentation");
                if (documentation != null) {
                    srcElement.setDescription(documentation);
                }
                if ((staticNode = petalNode.findNodeWithKey("static")) != null) {
                    srcElement.getModifiers().setFlag(2);
                } else {
                    String staticValue = petalNode.getInnerAttributeType("Java", "Static");
                    if (staticValue != null && staticValue.equals("TRUE")) {
                        srcElement.getModifiers().setFlag(2);
                    }
                }
                String persistence = petalNode.getProperty("persistence");
                if (persistence != null && "Persistent".equals(persistence)) {
                    srcElement.addTag("@persistent", "true");
                }
                if ((abstractNode = petalNode.findNodeWithKey("abstract")) != null) {
                    srcElement.getModifiers().setFlag(1);
                } else {
                    String abstactValue = petalNode.getInnerAttributeType("Java", "Abstract");
                    if (abstactValue != null && abstactValue.equals("TRUE")) {
                        srcElement.getModifiers().setFlag(1);
                    }
                }
                String finalValue = petalNode.getInnerAttributeType("Java", "Final");
                if (finalValue != null && !"FALSE".equals(finalValue)) {
                    srcElement.getModifiers().setFlag(4);
                }
                if (!"classifier".equals(type) && "field".equals(type)) {
                    IField field = (IField)srcElement;
                    String initialValue = petalNode.getMultiLinedProperty("initv");
                    if (initialValue != null) {
                        field.setInitialValue(initialValue);
                    }
                }
            }
        });
    }

    public static void registerPropertyProviders(Importer importer) {
        PropertyMapping.registerPropertyProvider(new DocumentationProvider());
        PropertyMapping.registerPropertyProvider(new PetalNameProvider("@stereotype", "stereotype"));
        PropertyMapping.registerPropertyProvider(new ProviderWrapper(new PetalValueProvider(new String[]{"Attribute"}, "@isDerived", "derived"), Extractors.EMPTY_TRUE));
        PropertyMapping.registerPropertyProvider(new ProviderWrapper(new PetalValueProvider(new String[]{"Use Case"}, "$abstract", "abstract"), Extractors.EMPTY_TRUE));
        PropertyMapping.registerPropertyProvider(new PetalNameProvider(new String[]{"Use Case"}, "$rank", "rank"));
        PropertyMapping.registerPropertyProvider(new PetalNameProvider(new String[]{"Transition"}, "$constraint", "stereotype"));
        PropertyMapping.registerPropertyProvider(new PetalNameProvider(new String[]{"Transition"}, "$guard_condition", "condition"));
        PropertyMapping.registerPropertyProvider(new PetalNameProvider(new String[]{"Internal Transition"}, "$send_clause", "target"));
        PropertyMapping.registerPropertyProvider(TransitionProviders.SEND_CLAUSE_PROVIDER);
        PropertyMapping.registerPropertyProvider(TransitionProviders.EVENT_PROVIDER);
        PropertyMapping.registerPropertyProvider(TransitionProviders.ACTION_EXPRESSION_PROVIDER);
        PropertyMapping.registerPropertyProvider(TransitionProviders.GUARD_CONDITION_PROVIDER);
        PropertyMapping.registerPropertyProvider(new ComponentTypeProvider());
        PropertyMapping.registerPropertyProvider(new ProviderWrapper(new PetalValueProvider(new String[]{"Object"}, "$persistence", "persistence"), new Extractors.COMPOUND_EXTRACTOR(new IExtractor[]{Extractors.CUT_QUOTES, Extractors.TO_LOWER_CASE})));
        PropertyMapping.registerPropertyProvider(new ProviderWrapper(new BooleanPropertyProvider(new String[]{"Object"}, "$multiple_instance", "multi"), Extractors.EMPTY_TRUE));
        PropertyMapping.registerPropertyProvider(new ControlFlowProvider());
        PropertyMapping.registerPropertyProvider(new NotePropertyProvider());
        PropertyMapping.registerPropertyProvider(new HyperlinkPropertyProvider(importer.getConfiguration()));
        PropertyMapping.registerPropertyProvider(new OperationConditionsProvider());
        List cps = importer.getConfiguration().getCustomProperyMapping();
        Iterator iter = cps.iterator();
        while (iter.hasNext()) {
            Configuration.CustomPropertyMapping mapping = (Configuration.CustomPropertyMapping)iter.next();
            PropertyMapping.registerPropertyProvider(new CustomPropertyProvider(mapping));
        }
    }

    public static void cleanUp() {
        MetaclassMapping.cleanUp();
        PropertyMapping.cleanUp();
    }
}

