/*
 * Decompiled with CFR 0.152.
 */
package com.borland.mdlimport.impl.xml;

import com.borland.mdlimport.impl.xml.XMLException;
import com.borland.util.Resources;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.xml.transform.sax.TransformerHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XMLNode {
    private XMLNode myParentNode;
    private String myNodeName;
    private List myChildNodes = new ArrayList();
    private Map myAttributes = new TreeMap();

    public XMLNode(String nodeName) {
        this.myNodeName = nodeName;
    }

    public XMLNode getParentNode() {
        return this.myParentNode;
    }

    public String getNodeName() {
        return this.myNodeName;
    }

    protected XMLNode getElementAt(String name, int index) {
        int count = 0;
        Iterator iterator = this.myChildNodes.iterator();
        while (iterator.hasNext()) {
            XMLNode child = (XMLNode)iterator.next();
            if (!child.getNodeName().equals(name) || count++ != index) continue;
            return child;
        }
        throw new XMLException(Resources.getString("XMLNode.Index_out_of_range._3"));
    }

    protected Enumeration getChildren(String name) {
        Vector<XMLNode> foundElements = new Vector<XMLNode>();
        Iterator iterator = this.myChildNodes.iterator();
        while (iterator.hasNext()) {
            XMLNode child = (XMLNode)iterator.next();
            if (!child.getNodeName().equals(name)) continue;
            foundElements.addElement(child);
        }
        return foundElements.elements();
    }

    protected int getElementsCount(String name) {
        int count = 0;
        Iterator iterator = this.myChildNodes.iterator();
        while (iterator.hasNext()) {
            XMLNode child = (XMLNode)iterator.next();
            if (!child.getNodeName().equals(name)) continue;
            ++count;
        }
        return count;
    }

    protected XMLNode addElement(XMLNode element) {
        return this.addElement(element, null);
    }

    protected XMLNode addElement(XMLNode element, XMLNode beforeNode) {
        int i = this.myChildNodes.indexOf(beforeNode);
        if (element.myParentNode != null) {
            element.myParentNode.myChildNodes.remove(element);
        }
        element.myParentNode = this;
        if (i == -1) {
            this.myChildNodes.add(element);
        } else {
            this.myChildNodes.add(i, element);
        }
        return element;
    }

    protected XMLNode addElementBefore(XMLNode element, String beforeElementName) {
        XMLNode beforeNode = null;
        if (beforeElementName != null && this.getElementsCount(beforeElementName) > 0) {
            beforeNode = this.getElementAt(beforeElementName, 0);
        }
        return this.addElement(element, beforeNode);
    }

    protected XMLNode addElementBefore(XMLNode element, XMLNode beforeNode) {
        return this.addElement(element, beforeNode);
    }

    protected void removeElement(XMLNode child) {
        this.myChildNodes.remove(child);
    }

    protected String getAttribute(String name) {
        return (String)this.myAttributes.get(name);
    }

    protected boolean hasAttribute(String name) {
        return this.myAttributes.get(name) != null;
    }

    protected void setAttribute(String name, String value) {
        if (value == null) {
            this.myAttributes.remove(name);
        } else {
            this.myAttributes.put(name, value);
        }
    }

    public void serialize(TransformerHandler handler) throws SAXException {
        AttributesImpl attrs = new AttributesImpl();
        Iterator iterator = this.myAttributes.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            attrs.addAttribute("", "", (String)entry.getKey(), "CDATA", (String)entry.getValue());
        }
        handler.startElement("", "", this.getNodeName(), attrs);
        iterator = this.myChildNodes.iterator();
        while (iterator.hasNext()) {
            XMLNode xmlNode = (XMLNode)((Object)iterator.next());
            xmlNode.serialize(handler);
        }
        handler.endElement("", "", this.getNodeName());
    }
}

