/*
 * Decompiled with CFR 0.152.
 */
package com.borland.mdlimport.impl.xml;

import com.borland.mdlimport.impl.xml.XMLException;
import com.borland.mdlimport.impl.xml.XMLNode;
import com.borland.util.Logger;
import com.borland.util.Resources;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.SAXException;

public class XMLDocument {
    private XMLNode myRootNode;

    public XMLDocument(XMLNode rootNode) {
        this.myRootNode = rootNode;
    }

    public void save(String file) throws XMLException {
        XMLException exception = null;
        FileOutputStream fos = null;
        try {
            File ioFile = new File(file);
            if (ioFile.isFile() && !ioFile.delete()) {
                throw new XMLException(String.valueOf(Resources.getString("XMLDocument.Can__t_delete_file__3")) + ioFile);
            }
            if (!ioFile.createNewFile()) {
                throw new XMLException(String.valueOf(Resources.getString("XMLDocument.Can__t_create_output_file__4")) + ioFile);
            }
            fos = new FileOutputStream(ioFile);
        }
        catch (IOException ex) {
            String errMsg = String.valueOf(Resources.getString("XMLDocument.Error_saving_file__5")) + file;
            Logger.getInstance().log("xml", 2, errMsg);
            throw new XMLException(ex);
        }
        try {
            SAXTransformerFactory transformerFactory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
            TransformerHandler handler = transformerFactory.newTransformerHandler();
            Transformer serializer = handler.getTransformer();
            serializer.setOutputProperty("encoding", "UTF-8");
            serializer.setOutputProperty("indent", "yes");
            serializer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            handler.setResult(new StreamResult(fos));
            handler.startDocument();
            this.myRootNode.serialize(handler);
            handler.endDocument();
        }
        catch (TransformerConfigurationException ex) {
            exception = new XMLException(ex);
        }
        catch (SAXException e) {
            exception = new XMLException(e);
        }
        try {
            fos.flush();
            fos.close();
        }
        catch (IOException ex) {
            exception = new XMLException(ex);
        }
        if (exception != null) {
            throw exception;
        }
    }
}

