/*
 * Decompiled with CFR 0.152.
 */
package com.borland.mdlimport.impl.txv;

import com.borland.mdlimport.impl.petal.DesignModelUtil;
import com.borland.mdlimport.impl.txv.Link;
import com.borland.mdlimport.impl.txv.Node;
import com.borland.mdlimport.impl.txv.NodeSet;
import com.borland.mdlimport.impl.txv.View;
import com.borland.mdlimport.impl.txv.ViewReference;
import com.borland.mdlimport.impl.xml.XMLDocument;
import com.borland.mdlimport.impl.xml.XMLException;
import com.borland.mdlimport.txv.IIdentifiable;
import com.borland.mdlimport.txv.ILink;
import com.borland.mdlimport.txv.INode;
import com.borland.mdlimport.txv.INodeSet;
import com.borland.mdlimport.txv.IView;
import com.borland.mdlimport.txv.IViewReference;
import com.borland.mdlimport.txv.TxvAccess;
import com.borland.util.Logger;
import com.borland.util.Resources;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;

public class TXVAccessImpl
extends TxvAccess {
    private HashMap myElementCache = new HashMap();
    private HashMap myDuplicatesMap = new HashMap();
    private NodeSetTreeNode myRootNode;

    public INodeSet createNodeSetImpl(String location, String file) {
        NodeSetTreeNode treeNode = this.getTreeNode(location, true);
        if (treeNode == null) {
            Logger.getInstance().log("txv", 2, String.valueOf(Resources.getString("TXVAccessImpl.Cannot_create_node_set_for_location__2")) + location + Resources.getString("TXVAccessImpl.,_file__3") + file);
            return null;
        }
        NodeSet nodeSet = new NodeSet();
        treeNode.addNodeSet(file, nodeSet);
        return nodeSet;
    }

    public INode createNodeImpl(String uin, String metaclass, String name) {
        Node node = new Node(uin, metaclass, name);
        this.putToCache(uin, node);
        return node;
    }

    public ILink createLinkImpl(String uin, String metaclass, String name, String clientUin, String supplierUin) {
        Link link = new Link(uin, metaclass, name, clientUin, supplierUin);
        this.putToCache(uin, link);
        return link;
    }

    public IView createViewImpl(String uin, String metaclass) {
        View view = new View(uin, metaclass);
        this.putToCache(uin, view);
        return view;
    }

    public IViewReference createViewReferenceImpl(String referencedUin) {
        return new ViewReference(referencedUin);
    }

    public List getAllNodeSetsImpl() {
        if (this.myRootNode == null) {
            return null;
        }
        final ArrayList list = new ArrayList();
        this.traverseNodeSetTree("", this.myRootNode, new TraversalCommand(){

            public void run(INodeSet next, String path) {
                list.add(next);
            }
        }, new TraversalCommand(){

            public void run(NodeSetTreeNode treeNode) {
            }
        });
        return list;
    }

    public void writeAllNodeSetsImpl(String outPath) {
        if (this.myRootNode == null) {
            return;
        }
        this.traverseNodeSetTree(outPath, this.myRootNode, new TraversalCommand(){

            public void run(INodeSet next, String path) {
                TXVAccessImpl.this.writeNodeSetImpl(next, path);
            }
        }, new TraversalCommand(){

            public void run(NodeSetTreeNode treeNode) {
                treeNode.clear();
            }
        });
    }

    public IIdentifiable findImpl(String uin) {
        Object key = this.myDuplicatesMap.get(uin);
        return (IIdentifiable)this.myElementCache.get(key == null ? uin : key);
    }

    public INode findClassifierImpl(String fqn) {
        Collection values = this.myElementCache.values();
        Iterator iter = values.iterator();
        while (iter.hasNext()) {
            INode node;
            Object element = iter.next();
            if (!(element instanceof INode) || !fqn.equals(DesignModelUtil.getFqn(node = (INode)element))) continue;
            return node;
        }
        return null;
    }

    public INodeSet getNodeSetImpl(String location, String file) {
        NodeSetTreeNode treeNode = this.getTreeNode(location, false);
        return treeNode == null ? null : treeNode.getNodeSet(file);
    }

    public Enumeration getNodeSetsImpl(String location) {
        NodeSetTreeNode treeNode = this.getTreeNode(location, false);
        return treeNode == null ? new Vector().elements() : treeNode.getNodeSets();
    }

    public Enumeration getNodeSetFilesImpl(String location) {
        NodeSetTreeNode treeNode = this.getTreeNode(location, false);
        return treeNode == null ? new Vector().elements() : treeNode.getNodeSetFiles();
    }

    private String[] parsePath(String location) {
        if (location == null) {
            return new String[0];
        }
        StringTokenizer tokenizer = new StringTokenizer(location, File.separator, false);
        Vector<String> path = new Vector<String>();
        while (tokenizer.hasMoreElements()) {
            path.add(tokenizer.nextToken());
        }
        return path.toArray(new String[path.size()]);
    }

    private boolean pathEqual(String[] path1, String[] path2) {
        if (path1.length != path2.length) {
            return false;
        }
        int i = 0;
        while (i < path1.length) {
            if (!path1[i].equalsIgnoreCase(path2[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void traverseNodeSetTree(String outPath, NodeSetTreeNode parentNode, TraversalCommand command, TraversalCommand secondCommand) {
        Enumeration files = parentNode.getNodeSetFiles();
        if (files.hasMoreElements()) {
            String curPath = String.valueOf(outPath) + File.separator + parentNode.getLocation();
            while (files.hasMoreElements()) {
                String nextFile = (String)files.nextElement();
                INodeSet nextNodeSet = parentNode.getNodeSet(nextFile);
                String fullFileName = String.valueOf(curPath) + File.separator + nextFile;
                command.run(nextNodeSet, fullFileName);
            }
        }
        secondCommand.run(parentNode);
        int i = 0;
        while (i < parentNode.getChildCount()) {
            NodeSetTreeNode child = (NodeSetTreeNode)parentNode.getChildAt(i);
            this.traverseNodeSetTree(outPath, child, command, secondCommand);
            ++i;
        }
    }

    private NodeSetTreeNode getTreeNode(String location, boolean create) {
        String[] path;
        if (this.myRootNode == null) {
            if (!create) {
                return null;
            }
            this.myRootNode = new NodeSetTreeNode("");
        }
        if ((path = this.parsePath(location)).length == 0) {
            return this.myRootNode;
        }
        return this.findTreeNodeRecursively(this.myRootNode, path, create);
    }

    private NodeSetTreeNode findTreeNodeRecursively(NodeSetTreeNode currentNode, String[] path, boolean create) {
        String[] curPath = this.parsePath(currentNode.getLocation());
        String[] nextPath = new String[curPath.length + 1];
        System.arraycopy(curPath, 0, nextPath, 0, curPath.length);
        nextPath[curPath.length] = path[curPath.length];
        NodeSetTreeNode childNode = currentNode.getChild(nextPath);
        if (childNode == null) {
            if (!create) {
                return null;
            }
            childNode = new NodeSetTreeNode(nextPath);
            currentNode.add(childNode);
        }
        if (this.pathEqual(nextPath, path)) {
            return childNode;
        }
        return this.findTreeNodeRecursively(childNode, path, create);
    }

    private void putToCache(String uin, IIdentifiable element) {
        this.myElementCache.put(uin, element);
    }

    private void writeNodeSetImpl(INodeSet nodeSet, String file) {
        try {
            new XMLDocument((NodeSet)nodeSet).save(file);
        }
        catch (XMLException ex) {
            Logger.getInstance().log("txv", ex);
        }
    }

    public void setDuplicateImpl(String original, String copy) {
        this.myDuplicatesMap.put(original, copy);
    }

    public String getDuplicateImpl(String quid) {
        return (String)this.myDuplicatesMap.get(quid);
    }

    private class NodeSetTreeNode
    extends DefaultMutableTreeNode {
        private HashMap myNodeSets;
        private String[] myPath;

        public NodeSetTreeNode(String location) {
            this.setUserObject(location);
        }

        public NodeSetTreeNode(String[] path) {
            this.myPath = path;
            StringBuffer location = new StringBuffer();
            int i = 0;
            while (i < this.myPath.length) {
                location.append(this.myPath[i]);
                if (i < this.myPath.length - 1) {
                    location.append(File.separator);
                }
                ++i;
            }
            this.setUserObject(location.toString());
        }

        public String getLocation() {
            return (String)this.getUserObject();
        }

        public String[] getNodePath() {
            if (this.myPath == null) {
                this.myPath = TXVAccessImpl.this.parsePath(this.getLocation());
            }
            return this.myPath;
        }

        public void addNodeSet(String file, INodeSet nodeSet) {
            if (this.myNodeSets == null) {
                this.myNodeSets = new HashMap();
            }
            this.myNodeSets.put(file, nodeSet);
        }

        public NodeSetTreeNode getChild(String[] path) {
            if (path.length != this.getNodePath().length + 1) {
                return null;
            }
            int i = 0;
            while (i < this.getChildCount()) {
                NodeSetTreeNode child = (NodeSetTreeNode)this.getChildAt(i);
                String[] childPath = child.getNodePath();
                if (TXVAccessImpl.this.pathEqual(childPath, path)) {
                    return child;
                }
                ++i;
            }
            return null;
        }

        public Enumeration getNodeSets() {
            return this.myNodeSets == null ? new Vector().elements() : Collections.enumeration(this.myNodeSets.values());
        }

        public Enumeration getNodeSetFiles() {
            return this.myNodeSets == null ? new Vector().elements() : Collections.enumeration(this.myNodeSets.keySet());
        }

        public INodeSet getNodeSet(String file) {
            return this.myNodeSets == null ? null : (INodeSet)this.myNodeSets.get(file);
        }

        public void clear() {
            if (this.myNodeSets != null) {
                this.myNodeSets.clear();
                this.myNodeSets = null;
            }
        }
    }

    public static class TraversalCommand {
        public void run(INodeSet next, String path) {
        }

        public void run(NodeSetTreeNode next) {
        }
    }
}

